#SHADER_DEFINE BulgeDistortionVertex

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    
#END_CODE
#END_DEFINE





#SHADER_DEFINE BulgeDistortionFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { RADIUS, 		HIGH,	FLOAT,		"radius"},
    { SCALE, 		HIGH,	FLOAT,		"scale"},
    { ASPECT_RATIO, 		HIGH,	FLOAT,		"aspectRatio"},

	}

#SHADER_CODE
     
    vec2 center = vec2(0.5,0.5); 
    vec2 textureCoordinateToUse = vec2(in_TexCooridate.x, ((in_TexCooridate.y - center.y) * aspectRatio) + center.y);
    float dist = distance(center, textureCoordinateToUse);
    textureCoordinateToUse = in_TexCooridate;
    textureCoordinateToUse -= center;
    float percent = 1.0 - ((radius - dist) / radius) * scale;
    percent = pow(percent,2);
    textureCoordinateToUse = textureCoordinateToUse * percent;
    textureCoordinateToUse += center;
    gl_FragColor = step(dist,radius)*texture2D(uniCurrentTexture, textureCoordinateToUse)+(1.0-step(dist,radius))*texture2D(uniCurrentTexture, in_TexCooridate);    
#END_CODE
#END_DEFINE