
#DEFPARAMS
_InputTex1 = { "Texture One", TEXTURE2D, "tex1" },
_InputTex2 = { "Texture Two", TEXTURE2D, "tex2" },
_InputTex3 = { "Texture Three", TEXTURE2D, "tex3" },
#END

#DEFTAG
ShaderName = "OneRowThreeTexQuad"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "commonvar.inc"
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D _InputTex1;
sampler2D _InputTex2;
sampler2D _InputTex3;


v2f vert(appdata v)
{
    v2f o;
    float4 pos = v.vertex * (1.0 / v.vertex.w);
    pos = mul(LOCALWORLD_TRANSFORM, pos);
    pos.w = 1.0;
    //pos.x = pos.x + WORLD_POSITION.x;
    //pos.y = pos.y + WORLD_POSITION.y;  
    o.vertex = pos;
    o.vertex = UniformNDC(o.vertex);
    o.uv = v.uv.xy;
    return o;
}

float4 frag(v2f i) : SV_Target
{

  int row = int(i.uv.x * 3.0);
  float2 textureCoord = i.uv;
  textureCoord.x = (i.uv.x - float(row) / 3.0) * 3.0;
  float4 mainColor = step(row, 0.5)*tex2D(_InputTex1, textureCoord) + step(0.5, row)*step(row, 1.5)*tex2D(_InputTex2, textureCoord) + step(1.5, row)*tex2D(_InputTex3, textureCoord);
  return mainColor;
}
ENDCG
#END
