

#DEFPARAMS
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_BlendMode = {"Blend Mode", FLOAT, "1.0"},
[Keywords(SCENE_VIEW, GAME_VIEW)]
_ViewMode = {"View Mode", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "makeup_test"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#pragma multi_compile SCENE_VIEW GAME_VIEW
struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;  
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
float4 _MaskInfo;

v2f vert(appdata v)
{
	v2f o;

	float2 mask_scale = float2(1000.0/_MaskInfo.z,1500.0/_MaskInfo.w);
	float2 uv_offset = float2(v.uv.x - _MaskInfo.x/1000.0,v.uv.y - _MaskInfo.y/1500.0) * mask_scale;
	o.uv = uv_offset;
#ifdef SCENE_VIEW
	float scene2DRectWidth = 0.24;
	float scene2DRectHeight = 0.285;
	float xCenter = 0.12/scene2DRectWidth;
	float yCenter = 1.0 - 0.125/scene2DRectHeight;
	
	
	float2 uv2pos;
	uv2pos.x = (v.uv.x - xCenter) * scene2DRectWidth;
	uv2pos.y = ( v.uv.y - yCenter) * scene2DRectHeight;
	float4 pos = float4(uv2pos.x, -uv2pos.y, -0.03,1.0);
	
	pos = ObjectToClipPos(pos);
#else
	float4 pos = v.vertex * (1.0 / v.vertex.w);
	pos = mul(LOCALWORLD_TRANSFORM, pos);
#endif
	o.vertex = UniformNDC(pos);
	
	return o;
}

fixed4 frag(v2f i) : SV_Target
{
	// sample the texture
	
	fixed4 basecolor = tex2D(_MainTex, i.uv);
	return basecolor;
}
ENDCG
#END
