

function DefineParams()
	Properties = 
	{
		
_MainTex = { "Main Tex", TEXTURE2D, "black" },
_MaskMap = {"MaskTex", TEXTURE2D, "white" },
_EditorMaskMap = {"EditorMaskTex", TEXTURE2D, "white" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
_MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},
_MaskScaleInfo = {"MaskScaleInfo",VEC4,"0.0,0.0,0.0,0.0"},
_Opacity = { "Opacity", FLOATRANGE, "0.5, 1, 0" },
_Strength = { "Strength", FLOAT, "1" },

_BlendSrc = {"Blend Src", FLOAT, "8.0"},

_BlendDst = {"Blend Dst", FLOAT, "0.0"},

_Polygon = {"Polygon Mode", FLOAT, "2.0"},

_BlendMode = {"Blend Mode", FLOAT, "1.0"},
_DefMode = { "def Mode", FLOAT, "2.0"},
_UseMask = { "Mask On", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
		_Polygon = "Enum(PolygonMode)", 
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_MULTIPLY,BLEND_SCREEN,BLEND_Hue,BLEND_SATURATION,BLEND_LUMINOSITY,BLEND_COLOR,BLEND_BLEND,BLEND_EXCLUSION,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_OVERLAY,BLEND_COLORBURN,BLEND_COLORDODGE,BLEND_SOFTLIGHT,BLEND_HARDMIX,BLEND_PINLIGHT,BLEND_LINEARLIGHT,BLEND_DIFF,BLEND_LINEARBURN,BLEND_SUB,BLEND_LUT)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "makeup"
RenderQueue = "Transparent+1"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }
POLYGON_MODE = { "%_Polygon" }
POINT_SIZE = 5


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 materialColor_3;
  highp float alphaValue_4;
  alphaValue_4 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_4 = 1.0;
  };
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_3 = tmpvar_5;
  factor_2 = ((materialColor_3.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_4));
  highp vec3 tmpvar_6;
  tmpvar_6 = materialColor_3.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_2 = (factor_2 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_2 = (factor_2 * tmpvar_8.x);
    };
  };
  highp vec4 tmpvar_9;
  tmpvar_9.xyz = tmpvar_6;
  tmpvar_9.w = factor_2;
  tmpvar_1 = tmpvar_9;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec3 blendColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  blendColor_2 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  blendColor_2 = (vec3(1.0, 1.0, 1.0) - (factor_3 * (vec3(1.0, 1.0, 1.0) - materialColor_4.xyz)));
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = blendColor_2;
  tmpvar_1 = tmpvar_9;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec3 blendColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  blendColor_2 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  blendColor_2 = (factor_3 * materialColor_4.xyz);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = blendColor_2;
  tmpvar_1 = tmpvar_9;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_Hue"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  highp vec3 tmpvar_7;
  tmpvar_7 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_9.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_10;
  highp vec2 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (TEXTURE_GRAP, tmpvar_11);
  srcColor_10 = tmpvar_12;
  highp vec3 rgb_13;
  rgb_13 = srcColor_10.xyz;
  highp vec4 tmpvar_14;
  if ((srcColor_10.y < srcColor_10.z)) {
    highp vec4 tmpvar_15;
    tmpvar_15.zw = vec2(-1.0, 0.6666667);
    tmpvar_15.xy = rgb_13.zy;
    tmpvar_14 = tmpvar_15;
  } else {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(0.0, -0.3333333);
    tmpvar_16.xy = rgb_13.yz;
    tmpvar_14 = tmpvar_16;
  };
  highp vec4 tmpvar_17;
  if ((srcColor_10.x < tmpvar_14.x)) {
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = tmpvar_14.xyw;
    tmpvar_18.w = rgb_13.x;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.x = rgb_13.x;
    tmpvar_19.yzw = tmpvar_14.yzx;
    tmpvar_17 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_17.x - min (tmpvar_17.w, tmpvar_17.y));
  highp vec3 tmpvar_21;
  tmpvar_21.x = abs(((
    (tmpvar_17.w - tmpvar_17.y)
   / 
    ((6.0 * tmpvar_20) + 1e-7)
  ) + tmpvar_17.z));
  tmpvar_21.y = tmpvar_20;
  tmpvar_21.z = tmpvar_17.x;
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_17.x - (tmpvar_20 * 0.5));
  highp vec3 tmpvar_23;
  tmpvar_23.x = tmpvar_21.x;
  tmpvar_23.y = (tmpvar_20 / ((1.0 - 
    abs(((2.0 * tmpvar_22) - 1.0))
  ) + 1e-7));
  tmpvar_23.z = tmpvar_22;
  highp vec4 tmpvar_24;
  if ((materialColor_4.y < materialColor_4.z)) {
    highp vec4 tmpvar_25;
    tmpvar_25.zw = vec2(-1.0, 0.6666667);
    tmpvar_25.xy = tmpvar_7.zy;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(0.0, -0.3333333);
    tmpvar_26.xy = tmpvar_7.yz;
    tmpvar_24 = tmpvar_26;
  };
  highp vec4 tmpvar_27;
  if ((materialColor_4.x < tmpvar_24.x)) {
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = tmpvar_24.xyw;
    tmpvar_28.w = tmpvar_7.x;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.x = tmpvar_7.x;
    tmpvar_29.yzw = tmpvar_24.yzx;
    tmpvar_27 = tmpvar_29;
  };
  highp float tmpvar_30;
  tmpvar_30 = (tmpvar_27.x - min (tmpvar_27.w, tmpvar_27.y));
  highp vec3 tmpvar_31;
  tmpvar_31.x = abs(((
    (tmpvar_27.w - tmpvar_27.y)
   / 
    ((6.0 * tmpvar_30) + 1e-7)
  ) + tmpvar_27.z));
  tmpvar_31.y = tmpvar_30;
  tmpvar_31.z = tmpvar_27.x;
  highp vec3 tmpvar_32;
  tmpvar_32.x = (abs((
    (6.0 * tmpvar_31.x)
   - 3.0)) - 1.0);
  tmpvar_32.y = (2.0 - abs((
    (6.0 * tmpvar_31.x)
   - 2.0)));
  tmpvar_32.z = (2.0 - abs((
    (6.0 * tmpvar_31.x)
   - 4.0)));
  highp vec4 tmpvar_33;
  tmpvar_33.w = 0.0;
  tmpvar_33.xyz = (((
    clamp (tmpvar_32, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_22) - 1.0)))
   * tmpvar_23.y)) + tmpvar_22);
  resultColor_2.xyz = mix (srcColor_10, tmpvar_33, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  highp vec3 tmpvar_7;
  tmpvar_7 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_9.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_10;
  highp vec2 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (TEXTURE_GRAP, tmpvar_11);
  srcColor_10 = tmpvar_12;
  highp vec3 rgb_13;
  rgb_13 = srcColor_10.xyz;
  highp vec4 tmpvar_14;
  if ((srcColor_10.y < srcColor_10.z)) {
    highp vec4 tmpvar_15;
    tmpvar_15.zw = vec2(-1.0, 0.6666667);
    tmpvar_15.xy = rgb_13.zy;
    tmpvar_14 = tmpvar_15;
  } else {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(0.0, -0.3333333);
    tmpvar_16.xy = rgb_13.yz;
    tmpvar_14 = tmpvar_16;
  };
  highp vec4 tmpvar_17;
  if ((srcColor_10.x < tmpvar_14.x)) {
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = tmpvar_14.xyw;
    tmpvar_18.w = rgb_13.x;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.x = rgb_13.x;
    tmpvar_19.yzw = tmpvar_14.yzx;
    tmpvar_17 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_17.x - min (tmpvar_17.w, tmpvar_17.y));
  highp vec3 tmpvar_21;
  tmpvar_21.x = abs(((
    (tmpvar_17.w - tmpvar_17.y)
   / 
    ((6.0 * tmpvar_20) + 1e-7)
  ) + tmpvar_17.z));
  tmpvar_21.y = tmpvar_20;
  tmpvar_21.z = tmpvar_17.x;
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_17.x - (tmpvar_20 * 0.5));
  highp vec4 tmpvar_23;
  if ((materialColor_4.y < materialColor_4.z)) {
    highp vec4 tmpvar_24;
    tmpvar_24.zw = vec2(-1.0, 0.6666667);
    tmpvar_24.xy = tmpvar_7.zy;
    tmpvar_23 = tmpvar_24;
  } else {
    highp vec4 tmpvar_25;
    tmpvar_25.zw = vec2(0.0, -0.3333333);
    tmpvar_25.xy = tmpvar_7.yz;
    tmpvar_23 = tmpvar_25;
  };
  highp vec4 tmpvar_26;
  if ((materialColor_4.x < tmpvar_23.x)) {
    highp vec4 tmpvar_27;
    tmpvar_27.xyz = tmpvar_23.xyw;
    tmpvar_27.w = tmpvar_7.x;
    tmpvar_26 = tmpvar_27;
  } else {
    highp vec4 tmpvar_28;
    tmpvar_28.x = tmpvar_7.x;
    tmpvar_28.yzw = tmpvar_23.yzx;
    tmpvar_26 = tmpvar_28;
  };
  highp float tmpvar_29;
  tmpvar_29 = (tmpvar_26.x - min (tmpvar_26.w, tmpvar_26.y));
  highp vec3 tmpvar_30;
  tmpvar_30.x = abs(((
    (tmpvar_26.w - tmpvar_26.y)
   / 
    ((6.0 * tmpvar_29) + 1e-7)
  ) + tmpvar_26.z));
  tmpvar_30.y = tmpvar_29;
  tmpvar_30.z = tmpvar_26.x;
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_26.x - (tmpvar_29 * 0.5));
  highp vec3 tmpvar_32;
  tmpvar_32.x = tmpvar_30.x;
  tmpvar_32.y = (tmpvar_29 / ((1.0 - 
    abs(((2.0 * tmpvar_31) - 1.0))
  ) + 1e-7));
  tmpvar_32.z = tmpvar_31;
  highp vec3 tmpvar_33;
  tmpvar_33.x = (abs((
    (6.0 * tmpvar_21.x)
   - 3.0)) - 1.0);
  tmpvar_33.y = (2.0 - abs((
    (6.0 * tmpvar_21.x)
   - 2.0)));
  tmpvar_33.z = (2.0 - abs((
    (6.0 * tmpvar_21.x)
   - 4.0)));
  highp vec4 tmpvar_34;
  tmpvar_34.w = 0.0;
  tmpvar_34.xyz = (((
    clamp (tmpvar_33, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_22) - 1.0)))
   * tmpvar_32.y)) + tmpvar_22);
  resultColor_2.xyz = mix (srcColor_10, tmpvar_34, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  highp vec3 tmpvar_7;
  tmpvar_7 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_9.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_10;
  highp vec2 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (TEXTURE_GRAP, tmpvar_11);
  srcColor_10 = tmpvar_12;
  highp vec3 rgb_13;
  rgb_13 = srcColor_10.xyz;
  highp vec4 tmpvar_14;
  if ((srcColor_10.y < srcColor_10.z)) {
    highp vec4 tmpvar_15;
    tmpvar_15.zw = vec2(-1.0, 0.6666667);
    tmpvar_15.xy = rgb_13.zy;
    tmpvar_14 = tmpvar_15;
  } else {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(0.0, -0.3333333);
    tmpvar_16.xy = rgb_13.yz;
    tmpvar_14 = tmpvar_16;
  };
  highp vec4 tmpvar_17;
  if ((srcColor_10.x < tmpvar_14.x)) {
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = tmpvar_14.xyw;
    tmpvar_18.w = rgb_13.x;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.x = rgb_13.x;
    tmpvar_19.yzw = tmpvar_14.yzx;
    tmpvar_17 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_17.x - min (tmpvar_17.w, tmpvar_17.y));
  highp vec3 tmpvar_21;
  tmpvar_21.x = abs(((
    (tmpvar_17.w - tmpvar_17.y)
   / 
    ((6.0 * tmpvar_20) + 1e-7)
  ) + tmpvar_17.z));
  tmpvar_21.y = tmpvar_20;
  tmpvar_21.z = tmpvar_17.x;
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_17.x - (tmpvar_20 * 0.5));
  highp vec3 tmpvar_23;
  tmpvar_23.x = tmpvar_21.x;
  tmpvar_23.y = (tmpvar_20 / ((1.0 - 
    abs(((2.0 * tmpvar_22) - 1.0))
  ) + 1e-7));
  tmpvar_23.z = tmpvar_22;
  highp vec4 tmpvar_24;
  if ((materialColor_4.y < materialColor_4.z)) {
    highp vec4 tmpvar_25;
    tmpvar_25.zw = vec2(-1.0, 0.6666667);
    tmpvar_25.xy = tmpvar_7.zy;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(0.0, -0.3333333);
    tmpvar_26.xy = tmpvar_7.yz;
    tmpvar_24 = tmpvar_26;
  };
  highp vec4 tmpvar_27;
  if ((materialColor_4.x < tmpvar_24.x)) {
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = tmpvar_24.xyw;
    tmpvar_28.w = tmpvar_7.x;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.x = tmpvar_7.x;
    tmpvar_29.yzw = tmpvar_24.yzx;
    tmpvar_27 = tmpvar_29;
  };
  highp float tmpvar_30;
  tmpvar_30 = (tmpvar_27.x - ((tmpvar_27.x - 
    min (tmpvar_27.w, tmpvar_27.y)
  ) * 0.5));
  highp vec3 tmpvar_31;
  tmpvar_31.x = (abs((
    (6.0 * tmpvar_21.x)
   - 3.0)) - 1.0);
  tmpvar_31.y = (2.0 - abs((
    (6.0 * tmpvar_21.x)
   - 2.0)));
  tmpvar_31.z = (2.0 - abs((
    (6.0 * tmpvar_21.x)
   - 4.0)));
  highp vec4 tmpvar_32;
  tmpvar_32.w = 0.0;
  tmpvar_32.xyz = (((
    clamp (tmpvar_31, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_30) - 1.0)))
   * tmpvar_23.y)) + tmpvar_30);
  resultColor_2.xyz = mix (srcColor_10, tmpvar_32, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  highp vec3 tmpvar_7;
  tmpvar_7 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_9.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_10;
  highp vec2 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (TEXTURE_GRAP, tmpvar_11);
  srcColor_10 = tmpvar_12;
  highp vec3 rgb_13;
  rgb_13 = srcColor_10.xyz;
  highp vec4 tmpvar_14;
  if ((srcColor_10.y < srcColor_10.z)) {
    highp vec4 tmpvar_15;
    tmpvar_15.zw = vec2(-1.0, 0.6666667);
    tmpvar_15.xy = rgb_13.zy;
    tmpvar_14 = tmpvar_15;
  } else {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(0.0, -0.3333333);
    tmpvar_16.xy = rgb_13.yz;
    tmpvar_14 = tmpvar_16;
  };
  highp vec4 tmpvar_17;
  if ((srcColor_10.x < tmpvar_14.x)) {
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = tmpvar_14.xyw;
    tmpvar_18.w = rgb_13.x;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.x = rgb_13.x;
    tmpvar_19.yzw = tmpvar_14.yzx;
    tmpvar_17 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_17.x - ((tmpvar_17.x - 
    min (tmpvar_17.w, tmpvar_17.y)
  ) * 0.5));
  highp vec4 tmpvar_21;
  if ((materialColor_4.y < materialColor_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = tmpvar_7.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = tmpvar_7.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((materialColor_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = tmpvar_7.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = tmpvar_7.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - min (tmpvar_24.w, tmpvar_24.y));
  highp vec3 tmpvar_28;
  tmpvar_28.x = abs(((
    (tmpvar_24.w - tmpvar_24.y)
   / 
    ((6.0 * tmpvar_27) + 1e-7)
  ) + tmpvar_24.z));
  tmpvar_28.y = tmpvar_27;
  tmpvar_28.z = tmpvar_24.x;
  highp float tmpvar_29;
  tmpvar_29 = (tmpvar_24.x - (tmpvar_27 * 0.5));
  highp vec3 tmpvar_30;
  tmpvar_30.x = tmpvar_28.x;
  tmpvar_30.y = (tmpvar_27 / ((1.0 - 
    abs(((2.0 * tmpvar_29) - 1.0))
  ) + 1e-7));
  tmpvar_30.z = tmpvar_29;
  highp vec3 tmpvar_31;
  tmpvar_31.x = (abs((
    (6.0 * tmpvar_28.x)
   - 3.0)) - 1.0);
  tmpvar_31.y = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 2.0)));
  tmpvar_31.z = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 4.0)));
  highp vec4 tmpvar_32;
  tmpvar_32.w = 0.0;
  tmpvar_32.xyz = (((
    clamp (tmpvar_31, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_20) - 1.0)))
   * tmpvar_30.y)) + tmpvar_20);
  resultColor_2.xyz = mix (srcColor_10, tmpvar_32, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 0.0;
  tmpvar_12.xyz = ((dot (vec3(0.299, 0.587, 0.114), srcColor_9.xyz) * 1.68) * materialColor_4.xyz);
  resultColor_2.xyz = mix (srcColor_9, tmpvar_12, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  resultColor_2.xyz = mix (srcColor_9.xyz, ((srcColor_9.xyz + materialColor_4.xyz) - (
    (2.0 * srcColor_9.xyz)
   * materialColor_4.xyz)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp float tmpvar_12;
  if ((materialColor_4.x < 0.5)) {
    tmpvar_12 = ((2.0 * materialColor_4.x) * srcColor_9.x);
  } else {
    tmpvar_12 = (1.0 - ((2.0 * 
      (1.0 - materialColor_4.x)
    ) * (1.0 - srcColor_9.x)));
  };
  highp float tmpvar_13;
  if ((materialColor_4.y < 0.5)) {
    tmpvar_13 = ((2.0 * materialColor_4.y) * srcColor_9.y);
  } else {
    tmpvar_13 = (1.0 - ((2.0 * 
      (1.0 - materialColor_4.y)
    ) * (1.0 - srcColor_9.y)));
  };
  highp float tmpvar_14;
  if ((materialColor_4.z < 0.5)) {
    tmpvar_14 = ((2.0 * materialColor_4.z) * srcColor_9.z);
  } else {
    tmpvar_14 = (1.0 - ((2.0 * 
      (1.0 - materialColor_4.z)
    ) * (1.0 - srcColor_9.z)));
  };
  highp vec3 tmpvar_15;
  tmpvar_15.x = tmpvar_12;
  tmpvar_15.y = tmpvar_13;
  tmpvar_15.z = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_9.xyz, tmpvar_15, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp float tmpvar_12;
  if ((materialColor_4.x < 0.5)) {
    highp float blend_13;
    blend_13 = (2.0 * materialColor_4.x);
    highp float tmpvar_14;
    if ((blend_13 == 0.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = max ((1.0 - (
        (1.0 - srcColor_9.x)
       / blend_13)), 0.0);
    };
    tmpvar_12 = tmpvar_14;
  } else {
    highp float blend_15;
    blend_15 = (2.0 * (materialColor_4.x - 0.5));
    highp float tmpvar_16;
    if ((blend_15 == 1.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = min ((srcColor_9.x / (1.0 - blend_15)), 1.0);
    };
    tmpvar_12 = tmpvar_16;
  };
  highp float tmpvar_17;
  if ((materialColor_4.y < 0.5)) {
    highp float blend_18;
    blend_18 = (2.0 * materialColor_4.y);
    highp float tmpvar_19;
    if ((blend_18 == 0.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = max ((1.0 - (
        (1.0 - srcColor_9.y)
       / blend_18)), 0.0);
    };
    tmpvar_17 = tmpvar_19;
  } else {
    highp float blend_20;
    blend_20 = (2.0 * (materialColor_4.y - 0.5));
    highp float tmpvar_21;
    if ((blend_20 == 1.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = min ((srcColor_9.y / (1.0 - blend_20)), 1.0);
    };
    tmpvar_17 = tmpvar_21;
  };
  highp float tmpvar_22;
  if ((materialColor_4.z < 0.5)) {
    highp float blend_23;
    blend_23 = (2.0 * materialColor_4.z);
    highp float tmpvar_24;
    if ((blend_23 == 0.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = max ((1.0 - (
        (1.0 - srcColor_9.z)
       / blend_23)), 0.0);
    };
    tmpvar_22 = tmpvar_24;
  } else {
    highp float blend_25;
    blend_25 = (2.0 * (materialColor_4.z - 0.5));
    highp float tmpvar_26;
    if ((blend_25 == 1.0)) {
      tmpvar_26 = blend_25;
    } else {
      tmpvar_26 = min ((srcColor_9.z / (1.0 - blend_25)), 1.0);
    };
    tmpvar_22 = tmpvar_26;
  };
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_12;
  tmpvar_27.y = tmpvar_17;
  tmpvar_27.z = tmpvar_22;
  resultColor_2.xyz = mix (srcColor_9.xyz, tmpvar_27, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp float tmpvar_12;
  if ((srcColor_9.x < 0.5)) {
    tmpvar_12 = ((2.0 * srcColor_9.x) * materialColor_4.x);
  } else {
    tmpvar_12 = (1.0 - ((2.0 * 
      (1.0 - srcColor_9.x)
    ) * (1.0 - materialColor_4.x)));
  };
  highp float tmpvar_13;
  if ((srcColor_9.y < 0.5)) {
    tmpvar_13 = ((2.0 * srcColor_9.y) * materialColor_4.y);
  } else {
    tmpvar_13 = (1.0 - ((2.0 * 
      (1.0 - srcColor_9.y)
    ) * (1.0 - materialColor_4.y)));
  };
  highp float tmpvar_14;
  if ((srcColor_9.z < 0.5)) {
    tmpvar_14 = ((2.0 * srcColor_9.z) * materialColor_4.z);
  } else {
    tmpvar_14 = (1.0 - ((2.0 * 
      (1.0 - srcColor_9.z)
    ) * (1.0 - materialColor_4.z)));
  };
  highp vec3 tmpvar_15;
  tmpvar_15.x = tmpvar_12;
  tmpvar_15.y = tmpvar_13;
  tmpvar_15.z = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_9.xyz, tmpvar_15, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp vec3 blend_12;
  blend_12 = materialColor_4.xyz;
  highp float blend_13;
  blend_13 = blend_12.x;
  highp float tmpvar_14;
  if ((materialColor_4.x == 0.0)) {
    tmpvar_14 = blend_13;
  } else {
    tmpvar_14 = max ((1.0 - (
      (1.0 - srcColor_9.x)
     / materialColor_4.x)), 0.0);
  };
  highp float blend_15;
  blend_15 = blend_12.y;
  highp float tmpvar_16;
  if ((materialColor_4.y == 0.0)) {
    tmpvar_16 = blend_15;
  } else {
    tmpvar_16 = max ((1.0 - (
      (1.0 - srcColor_9.y)
     / materialColor_4.y)), 0.0);
  };
  highp float blend_17;
  blend_17 = blend_12.z;
  highp float tmpvar_18;
  if ((materialColor_4.z == 0.0)) {
    tmpvar_18 = blend_17;
  } else {
    tmpvar_18 = max ((1.0 - (
      (1.0 - srcColor_9.z)
     / materialColor_4.z)), 0.0);
  };
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_14;
  tmpvar_19.y = tmpvar_16;
  tmpvar_19.z = tmpvar_18;
  resultColor_2.xyz = mix (srcColor_9.xyz, tmpvar_19, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp vec3 blend_12;
  blend_12 = materialColor_4.xyz;
  highp float blend_13;
  blend_13 = blend_12.x;
  highp float tmpvar_14;
  if ((materialColor_4.x == 1.0)) {
    tmpvar_14 = blend_13;
  } else {
    tmpvar_14 = min ((srcColor_9.x / (1.0 - materialColor_4.x)), 1.0);
  };
  highp float blend_15;
  blend_15 = blend_12.y;
  highp float tmpvar_16;
  if ((materialColor_4.y == 1.0)) {
    tmpvar_16 = blend_15;
  } else {
    tmpvar_16 = min ((srcColor_9.y / (1.0 - materialColor_4.y)), 1.0);
  };
  highp float blend_17;
  blend_17 = blend_12.z;
  highp float tmpvar_18;
  if ((materialColor_4.z == 1.0)) {
    tmpvar_18 = blend_17;
  } else {
    tmpvar_18 = min ((srcColor_9.z / (1.0 - materialColor_4.z)), 1.0);
  };
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_14;
  tmpvar_19.y = tmpvar_16;
  tmpvar_19.z = tmpvar_18;
  resultColor_2.xyz = mix (srcColor_9.xyz, tmpvar_19, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  resultColor_2.xyz = mix (srcColor_9.xyz, ((
    ((vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * materialColor_4.xyz)) * srcColor_9.xyz)
   * srcColor_9.xyz) + (
    (vec3(2.0, 2.0, 2.0) * srcColor_9.xyz)
   * materialColor_4.xyz)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp float tmpvar_12;
  highp float tmpvar_13;
  if ((materialColor_4.x < 0.5)) {
    highp float blend_14;
    blend_14 = (2.0 * materialColor_4.x);
    highp float tmpvar_15;
    if ((blend_14 == 0.0)) {
      tmpvar_15 = blend_14;
    } else {
      tmpvar_15 = max ((1.0 - (
        (1.0 - srcColor_9.x)
       / blend_14)), 0.0);
    };
    tmpvar_13 = tmpvar_15;
  } else {
    highp float blend_16;
    blend_16 = (2.0 * (materialColor_4.x - 0.5));
    highp float tmpvar_17;
    if ((blend_16 == 1.0)) {
      tmpvar_17 = blend_16;
    } else {
      tmpvar_17 = min ((srcColor_9.x / (1.0 - blend_16)), 1.0);
    };
    tmpvar_13 = tmpvar_17;
  };
  if ((tmpvar_13 < 0.5)) {
    tmpvar_12 = 0.0;
  } else {
    tmpvar_12 = 1.0;
  };
  highp float tmpvar_18;
  highp float tmpvar_19;
  if ((materialColor_4.y < 0.5)) {
    highp float blend_20;
    blend_20 = (2.0 * materialColor_4.y);
    highp float tmpvar_21;
    if ((blend_20 == 0.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = max ((1.0 - (
        (1.0 - srcColor_9.y)
       / blend_20)), 0.0);
    };
    tmpvar_19 = tmpvar_21;
  } else {
    highp float blend_22;
    blend_22 = (2.0 * (materialColor_4.y - 0.5));
    highp float tmpvar_23;
    if ((blend_22 == 1.0)) {
      tmpvar_23 = blend_22;
    } else {
      tmpvar_23 = min ((srcColor_9.y / (1.0 - blend_22)), 1.0);
    };
    tmpvar_19 = tmpvar_23;
  };
  if ((tmpvar_19 < 0.5)) {
    tmpvar_18 = 0.0;
  } else {
    tmpvar_18 = 1.0;
  };
  highp float tmpvar_24;
  highp float tmpvar_25;
  if ((materialColor_4.z < 0.5)) {
    highp float blend_26;
    blend_26 = (2.0 * materialColor_4.z);
    highp float tmpvar_27;
    if ((blend_26 == 0.0)) {
      tmpvar_27 = blend_26;
    } else {
      tmpvar_27 = max ((1.0 - (
        (1.0 - srcColor_9.z)
       / blend_26)), 0.0);
    };
    tmpvar_25 = tmpvar_27;
  } else {
    highp float blend_28;
    blend_28 = (2.0 * (materialColor_4.z - 0.5));
    highp float tmpvar_29;
    if ((blend_28 == 1.0)) {
      tmpvar_29 = blend_28;
    } else {
      tmpvar_29 = min ((srcColor_9.z / (1.0 - blend_28)), 1.0);
    };
    tmpvar_25 = tmpvar_29;
  };
  if ((tmpvar_25 < 0.5)) {
    tmpvar_24 = 0.0;
  } else {
    tmpvar_24 = 1.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30.x = tmpvar_12;
  tmpvar_30.y = tmpvar_18;
  tmpvar_30.z = tmpvar_24;
  resultColor_2.xyz = mix (srcColor_9.xyz, tmpvar_30, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp float tmpvar_12;
  if ((materialColor_4.x < 0.5)) {
    tmpvar_12 = min ((2.0 * materialColor_4.x), srcColor_9.x);
  } else {
    tmpvar_12 = max ((2.0 * (materialColor_4.x - 0.5)), srcColor_9.x);
  };
  highp float tmpvar_13;
  if ((materialColor_4.y < 0.5)) {
    tmpvar_13 = min ((2.0 * materialColor_4.y), srcColor_9.y);
  } else {
    tmpvar_13 = max ((2.0 * (materialColor_4.y - 0.5)), srcColor_9.y);
  };
  highp float tmpvar_14;
  if ((materialColor_4.z < 0.5)) {
    tmpvar_14 = min ((2.0 * materialColor_4.z), srcColor_9.z);
  } else {
    tmpvar_14 = max ((2.0 * (materialColor_4.z - 0.5)), srcColor_9.z);
  };
  highp vec3 tmpvar_15;
  tmpvar_15.x = tmpvar_12;
  tmpvar_15.y = tmpvar_13;
  tmpvar_15.z = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_9.xyz, tmpvar_15, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  highp float tmpvar_12;
  if ((materialColor_4.x < 0.5)) {
    tmpvar_12 = max (((srcColor_9.x + 
      (2.0 * materialColor_4.x)
    ) - 1.0), 0.0);
  } else {
    tmpvar_12 = min ((srcColor_9.x + (2.0 * 
      (materialColor_4.x - 0.5)
    )), 1.0);
  };
  highp float tmpvar_13;
  if ((materialColor_4.y < 0.5)) {
    tmpvar_13 = max (((srcColor_9.y + 
      (2.0 * materialColor_4.y)
    ) - 1.0), 0.0);
  } else {
    tmpvar_13 = min ((srcColor_9.y + (2.0 * 
      (materialColor_4.y - 0.5)
    )), 1.0);
  };
  highp float tmpvar_14;
  if ((materialColor_4.z < 0.5)) {
    tmpvar_14 = max (((srcColor_9.z + 
      (2.0 * materialColor_4.z)
    ) - 1.0), 0.0);
  } else {
    tmpvar_14 = min ((srcColor_9.z + (2.0 * 
      (materialColor_4.z - 0.5)
    )), 1.0);
  };
  highp vec3 tmpvar_15;
  tmpvar_15.x = tmpvar_12;
  tmpvar_15.y = tmpvar_13;
  tmpvar_15.z = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_9.xyz, tmpvar_15, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  resultColor_2.xyz = mix (srcColor_9.xyz, abs((srcColor_9.xyz - materialColor_4.xyz)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  resultColor_2.xyz = mix (srcColor_9.xyz, max ((
    (srcColor_9.xyz + materialColor_4.xyz)
   - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  };
  highp vec4 srcColor_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_GRAP, tmpvar_10);
  srcColor_9 = tmpvar_11;
  resultColor_2.xyz = mix (srcColor_9.xyz, max ((srcColor_9.xyz - materialColor_4.xyz), vec3(0.0, 0.0, 0.0)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    };
  };
  highp vec4 tmpvar_17;
  tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_17 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0; gl_PointSize = 5.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform sampler2D _LutMap;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec3 resColor_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  highp vec3 tmpvar_8;
  tmpvar_8 = materialColor_5.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    } else {
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_10.x);
    };
  };
  highp vec4 srcColor_11;
  highp vec2 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (TEXTURE_GRAP, tmpvar_12);
  srcColor_11 = tmpvar_13;
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_8.x;
  tmpvar_14.y = srcColor_11.x;
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (_LutMap, tmpvar_14);
  resColor_2.x = tmpvar_15.x;
  highp vec2 tmpvar_16;
  tmpvar_16.x = tmpvar_8.y;
  tmpvar_16.y = srcColor_11.y;
  lowp vec4 tmpvar_17;
  tmpvar_17 = texture2D (_LutMap, tmpvar_16);
  resColor_2.y = tmpvar_17.y;
  highp vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_8.z;
  tmpvar_18.y = srcColor_11.z;
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2D (_LutMap, tmpvar_18);
  resColor_2.z = tmpvar_19.z;
  highp vec4 tmpvar_20;
  tmpvar_20.w = 0.0;
  tmpvar_20.xyz = resColor_2;
  resultColor_3.xyz = mix (srcColor_11, tmpvar_20, vec4(factor_4)).xyz;
  resultColor_3.w = 1.0;
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
