

#DEFPARAMS
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},
#END

#DEFTAG
ShaderName = "makeup_mask"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
float4 _MaskInfo;

float4 _ScaleInfo;

v2f vert(appdata v)
{
	v2f o;

	float uOffset = (v.uv.x * 1000.0 - _MaskInfo.x) / _MaskInfo.z;
	float vOffset = (v.uv.y * 1500.0 - _MaskInfo.y) / _MaskInfo.w;
	float2 uv_offset = float2(uOffset, vOffset);
	o.uv = uv_offset;
  
	float sceneType = v.vertex.w;
	float4 pos;

	if(sceneType > 0.1)
	{
		float scene2DRectWidth = 0.2;
		float scene2DRectHeight = 0.3;
		float xCenter = 0.1/scene2DRectWidth;
		float yCenter = 1.0 - 0.12/scene2DRectHeight;
		float2 uv2pos;
		uv2pos.x = (v.uv.x - xCenter) * scene2DRectWidth;
		uv2pos.y = ( v.uv.y - yCenter) * scene2DRectHeight;
		pos = float4(uv2pos.x, -uv2pos.y, 0.0,1.0);
		pos = ObjectToClipPos(pos);
	}
	else
	{
		pos = float4(v.vertex.x,v.vertex.y,0.0,1.0);
		pos = mul(LOCALWORLD_TRANSFORM, pos);
	}

	o.vertex = UniformNDC(pos);
	return o;
}

fixed4 frag(v2f i) : SV_Target
{
	// sample the texture

	fixed4 basecolor = tex2D(_MainTex, i.uv);
	return basecolor;
}
ENDCG
#END
