

function DefineParams()
	Properties = 
	{
		
_MainTex = { "Main Tex", TEXTURE2D, "black" },
_MaskMap = {"MaskTex", TEXTURE2D, "white" },
_EditorMaskMap = {"EditorMaskTex", TEXTURE2D, "white" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
_MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},
_MaskScaleInfo = {"MaskScaleInfo",VEC4,"0.0,0.0,0.0,0.0"},
_Opacity = { "Opacity", FLOATRANGE, "0.5, 1, 0" },
_Strength = { "Strength", FLOAT, "1" },

_BlendSrc = {"Blend Src", FLOAT, "8.0"},

_BlendDst = {"Blend Dst", FLOAT, "0.0"},

_Polygon = {"Polygon Mode", FLOAT, "2.0"},

_BlendMode = {"Blend Mode", FLOAT, "1.0"},
_DefMode = { "def Mode", FLOAT, "2.0"},
_UseMask = { "Mask On", FLOAT, "0.0"},
_UseBvtMask = {"BvtMask On",FLOAT,"0.0"},
_VideoSize = {"Video Size",VEC2,"0.0,0.0"},
_MaskInfoBvt = {"_MaskInfoBvt",VEC4,"0.0,0.0,0.0,0.0"},

	}
	Attributes = 
	{
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
		_Polygon = "Enum(PolygonMode)", 
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_MULTIPLY,BLEND_SCREEN,BLEND_Hue,BLEND_SATURATION,BLEND_LUMINOSITY,BLEND_COLOR,BLEND_BLEND,BLEND_EXCLUSION,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_OVERLAY,BLEND_COLORBURN,BLEND_COLORDODGE,BLEND_SOFTLIGHT,BLEND_HARDMIX,BLEND_PINLIGHT,BLEND_LINEARLIGHT,BLEND_DIFF,BLEND_LINEARBURN,BLEND_SUB,BLEND_LUT)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "makeup"
RenderQueue = "Transparent+1"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }
POLYGON_MODE = { "%_Polygon" }
POINT_SIZE = 5


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp float factor_1;
  highp vec4 materialColor_2;
  highp float alphaValue_3;
  alphaValue_3 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_3 = 1.0;
  };
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_2 = tmpvar_4;
  factor_1 = ((materialColor_2.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_3));
  highp vec3 tmpvar_5;
  tmpvar_5 = materialColor_2.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_6;
      tmpvar_6 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_1 = (factor_1 * tmpvar_6.x);
    } else {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_1 = (factor_1 * tmpvar_7.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_8;
      lowp float tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_8 = tmpvar_9;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_8 = 0.0;
      };
      highp float tmpvar_10;
      if ((bvtMaskColorAlpha_8 > 0.0)) {
        tmpvar_10 = (factor_1 * (1.0 - bvtMaskColorAlpha_8));
      } else {
        tmpvar_10 = factor_1;
      };
      factor_1 = tmpvar_10;
    };
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xyz = tmpvar_5;
  tmpvar_11.w = factor_1;
  gl_FragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 materialColor_3;
  highp float alphaValue_4;
  alphaValue_4 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_4 = 1.0;
  };
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_3 = tmpvar_5;
  factor_2 = ((materialColor_3.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_4));
  highp vec3 tmpvar_6;
  tmpvar_6 = materialColor_3.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_2 = (factor_2 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_2 = (factor_2 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_2 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_2;
      };
      factor_2 = tmpvar_11;
    };
  };
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = tmpvar_6;
  tmpvar_12.w = factor_2;
  tmpvar_1 = tmpvar_12;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec3 blendColor_1;
  highp float factor_2;
  highp vec4 materialColor_3;
  highp float alphaValue_4;
  alphaValue_4 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_4 = 1.0;
  };
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_3 = tmpvar_5;
  factor_2 = ((materialColor_3.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_4));
  blendColor_1 = materialColor_3.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_6;
      tmpvar_6 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_2 = (factor_2 * tmpvar_6.x);
    } else {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_2 = (factor_2 * tmpvar_7.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_8;
      lowp float tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_8 = tmpvar_9;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_8 = 0.0;
      };
      highp float tmpvar_10;
      if ((bvtMaskColorAlpha_8 > 0.0)) {
        tmpvar_10 = (factor_2 * (1.0 - bvtMaskColorAlpha_8));
      } else {
        tmpvar_10 = factor_2;
      };
      factor_2 = tmpvar_10;
    };
  };
  blendColor_1 = (vec3(1.0, 1.0, 1.0) - (factor_2 * (vec3(1.0, 1.0, 1.0) - materialColor_3.xyz)));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = blendColor_1;
  gl_FragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec3 blendColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  blendColor_2 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  blendColor_2 = (vec3(1.0, 1.0, 1.0) - (factor_3 * (vec3(1.0, 1.0, 1.0) - materialColor_4.xyz)));
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = blendColor_2;
  tmpvar_1 = tmpvar_12;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec3 blendColor_1;
  highp float factor_2;
  highp vec4 materialColor_3;
  highp float alphaValue_4;
  alphaValue_4 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_4 = 1.0;
  };
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_3 = tmpvar_5;
  factor_2 = ((materialColor_3.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_4));
  blendColor_1 = materialColor_3.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_6;
      tmpvar_6 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_2 = (factor_2 * tmpvar_6.x);
    } else {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_2 = (factor_2 * tmpvar_7.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_8;
      lowp float tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_8 = tmpvar_9;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_8 = 0.0;
      };
      highp float tmpvar_10;
      if ((bvtMaskColorAlpha_8 > 0.0)) {
        tmpvar_10 = (factor_2 * (1.0 - bvtMaskColorAlpha_8));
      } else {
        tmpvar_10 = factor_2;
      };
      factor_2 = tmpvar_10;
    };
  };
  blendColor_1 = (factor_2 * materialColor_3.xyz);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = blendColor_1;
  gl_FragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec3 blendColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  blendColor_2 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  blendColor_2 = (factor_3 * materialColor_4.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = blendColor_2;
  tmpvar_1 = tmpvar_12;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_Hue"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  highp vec3 tmpvar_8;
  tmpvar_8 = materialColor_5.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    } else {
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_10.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_11;
      lowp float tmpvar_12;
      tmpvar_12 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_11 = tmpvar_12;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_11 = 0.0;
      };
      highp float tmpvar_13;
      if ((bvtMaskColorAlpha_11 > 0.0)) {
        tmpvar_13 = (factor_4 * (1.0 - bvtMaskColorAlpha_11));
      } else {
        tmpvar_13 = factor_4;
      };
      factor_4 = tmpvar_13;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec3 rgb_14;
  rgb_14 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_15;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(-1.0, 0.6666667);
    tmpvar_16.xy = rgb_14.zy;
    tmpvar_15 = tmpvar_16;
  } else {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(0.0, -0.3333333);
    tmpvar_17.xy = rgb_14.yz;
    tmpvar_15 = tmpvar_17;
  };
  highp vec4 tmpvar_18;
  if ((xlt_fbColor_1.x < tmpvar_15.x)) {
    highp vec4 tmpvar_19;
    tmpvar_19.xyz = tmpvar_15.xyw;
    tmpvar_19.w = rgb_14.x;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.x = rgb_14.x;
    tmpvar_20.yzw = tmpvar_15.yzx;
    tmpvar_18 = tmpvar_20;
  };
  highp float tmpvar_21;
  tmpvar_21 = (tmpvar_18.x - min (tmpvar_18.w, tmpvar_18.y));
  highp vec3 tmpvar_22;
  tmpvar_22.x = abs(((
    (tmpvar_18.w - tmpvar_18.y)
   / 
    ((6.0 * tmpvar_21) + 1e-7)
  ) + tmpvar_18.z));
  tmpvar_22.y = tmpvar_21;
  tmpvar_22.z = tmpvar_18.x;
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_18.x - (tmpvar_21 * 0.5));
  highp vec3 tmpvar_24;
  tmpvar_24.x = tmpvar_22.x;
  tmpvar_24.y = (tmpvar_21 / ((1.0 - 
    abs(((2.0 * tmpvar_23) - 1.0))
  ) + 1e-7));
  tmpvar_24.z = tmpvar_23;
  highp vec4 tmpvar_25;
  if ((materialColor_5.y < materialColor_5.z)) {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(-1.0, 0.6666667);
    tmpvar_26.xy = tmpvar_8.zy;
    tmpvar_25 = tmpvar_26;
  } else {
    highp vec4 tmpvar_27;
    tmpvar_27.zw = vec2(0.0, -0.3333333);
    tmpvar_27.xy = tmpvar_8.yz;
    tmpvar_25 = tmpvar_27;
  };
  highp vec4 tmpvar_28;
  if ((materialColor_5.x < tmpvar_25.x)) {
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = tmpvar_25.xyw;
    tmpvar_29.w = tmpvar_8.x;
    tmpvar_28 = tmpvar_29;
  } else {
    highp vec4 tmpvar_30;
    tmpvar_30.x = tmpvar_8.x;
    tmpvar_30.yzw = tmpvar_25.yzx;
    tmpvar_28 = tmpvar_30;
  };
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_28.x - min (tmpvar_28.w, tmpvar_28.y));
  highp vec3 tmpvar_32;
  tmpvar_32.x = abs(((
    (tmpvar_28.w - tmpvar_28.y)
   / 
    ((6.0 * tmpvar_31) + 1e-7)
  ) + tmpvar_28.z));
  tmpvar_32.y = tmpvar_31;
  tmpvar_32.z = tmpvar_28.x;
  highp vec3 tmpvar_33;
  tmpvar_33.x = (abs((
    (6.0 * tmpvar_32.x)
   - 3.0)) - 1.0);
  tmpvar_33.y = (2.0 - abs((
    (6.0 * tmpvar_32.x)
   - 2.0)));
  tmpvar_33.z = (2.0 - abs((
    (6.0 * tmpvar_32.x)
   - 4.0)));
  highp vec4 tmpvar_34;
  tmpvar_34.w = 0.0;
  tmpvar_34.xyz = (((
    clamp (tmpvar_33, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_23) - 1.0)))
   * tmpvar_24.y)) + tmpvar_23);
  resultColor_3.xyz = mix (xlt_fbColor_1, tmpvar_34, vec4(factor_4)).xyz;
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_Hue"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  highp vec3 tmpvar_7;
  tmpvar_7 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_3 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_3;
      };
      factor_3 = tmpvar_12;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_13;
  highp vec2 tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (TEXTURE_GRAP, tmpvar_14);
  srcColor_13 = tmpvar_15;
  highp vec3 rgb_16;
  rgb_16 = srcColor_13.xyz;
  highp vec4 tmpvar_17;
  if ((srcColor_13.y < srcColor_13.z)) {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(-1.0, 0.6666667);
    tmpvar_18.xy = rgb_16.zy;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(0.0, -0.3333333);
    tmpvar_19.xy = rgb_16.yz;
    tmpvar_17 = tmpvar_19;
  };
  highp vec4 tmpvar_20;
  if ((srcColor_13.x < tmpvar_17.x)) {
    highp vec4 tmpvar_21;
    tmpvar_21.xyz = tmpvar_17.xyw;
    tmpvar_21.w = rgb_16.x;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.x = rgb_16.x;
    tmpvar_22.yzw = tmpvar_17.yzx;
    tmpvar_20 = tmpvar_22;
  };
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_20.x - min (tmpvar_20.w, tmpvar_20.y));
  highp vec3 tmpvar_24;
  tmpvar_24.x = abs(((
    (tmpvar_20.w - tmpvar_20.y)
   / 
    ((6.0 * tmpvar_23) + 1e-7)
  ) + tmpvar_20.z));
  tmpvar_24.y = tmpvar_23;
  tmpvar_24.z = tmpvar_20.x;
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_20.x - (tmpvar_23 * 0.5));
  highp vec3 tmpvar_26;
  tmpvar_26.x = tmpvar_24.x;
  tmpvar_26.y = (tmpvar_23 / ((1.0 - 
    abs(((2.0 * tmpvar_25) - 1.0))
  ) + 1e-7));
  tmpvar_26.z = tmpvar_25;
  highp vec4 tmpvar_27;
  if ((materialColor_4.y < materialColor_4.z)) {
    highp vec4 tmpvar_28;
    tmpvar_28.zw = vec2(-1.0, 0.6666667);
    tmpvar_28.xy = tmpvar_7.zy;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.zw = vec2(0.0, -0.3333333);
    tmpvar_29.xy = tmpvar_7.yz;
    tmpvar_27 = tmpvar_29;
  };
  highp vec4 tmpvar_30;
  if ((materialColor_4.x < tmpvar_27.x)) {
    highp vec4 tmpvar_31;
    tmpvar_31.xyz = tmpvar_27.xyw;
    tmpvar_31.w = tmpvar_7.x;
    tmpvar_30 = tmpvar_31;
  } else {
    highp vec4 tmpvar_32;
    tmpvar_32.x = tmpvar_7.x;
    tmpvar_32.yzw = tmpvar_27.yzx;
    tmpvar_30 = tmpvar_32;
  };
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_30.x - min (tmpvar_30.w, tmpvar_30.y));
  highp vec3 tmpvar_34;
  tmpvar_34.x = abs(((
    (tmpvar_30.w - tmpvar_30.y)
   / 
    ((6.0 * tmpvar_33) + 1e-7)
  ) + tmpvar_30.z));
  tmpvar_34.y = tmpvar_33;
  tmpvar_34.z = tmpvar_30.x;
  highp vec3 tmpvar_35;
  tmpvar_35.x = (abs((
    (6.0 * tmpvar_34.x)
   - 3.0)) - 1.0);
  tmpvar_35.y = (2.0 - abs((
    (6.0 * tmpvar_34.x)
   - 2.0)));
  tmpvar_35.z = (2.0 - abs((
    (6.0 * tmpvar_34.x)
   - 4.0)));
  highp vec4 tmpvar_36;
  tmpvar_36.w = 0.0;
  tmpvar_36.xyz = (((
    clamp (tmpvar_35, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_25) - 1.0)))
   * tmpvar_26.y)) + tmpvar_25);
  resultColor_2.xyz = mix (srcColor_13, tmpvar_36, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  highp vec3 tmpvar_8;
  tmpvar_8 = materialColor_5.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    } else {
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_10.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_11;
      lowp float tmpvar_12;
      tmpvar_12 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_11 = tmpvar_12;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_11 = 0.0;
      };
      highp float tmpvar_13;
      if ((bvtMaskColorAlpha_11 > 0.0)) {
        tmpvar_13 = (factor_4 * (1.0 - bvtMaskColorAlpha_11));
      } else {
        tmpvar_13 = factor_4;
      };
      factor_4 = tmpvar_13;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec3 rgb_14;
  rgb_14 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_15;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(-1.0, 0.6666667);
    tmpvar_16.xy = rgb_14.zy;
    tmpvar_15 = tmpvar_16;
  } else {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(0.0, -0.3333333);
    tmpvar_17.xy = rgb_14.yz;
    tmpvar_15 = tmpvar_17;
  };
  highp vec4 tmpvar_18;
  if ((xlt_fbColor_1.x < tmpvar_15.x)) {
    highp vec4 tmpvar_19;
    tmpvar_19.xyz = tmpvar_15.xyw;
    tmpvar_19.w = rgb_14.x;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.x = rgb_14.x;
    tmpvar_20.yzw = tmpvar_15.yzx;
    tmpvar_18 = tmpvar_20;
  };
  highp float tmpvar_21;
  tmpvar_21 = (tmpvar_18.x - min (tmpvar_18.w, tmpvar_18.y));
  highp vec3 tmpvar_22;
  tmpvar_22.x = abs(((
    (tmpvar_18.w - tmpvar_18.y)
   / 
    ((6.0 * tmpvar_21) + 1e-7)
  ) + tmpvar_18.z));
  tmpvar_22.y = tmpvar_21;
  tmpvar_22.z = tmpvar_18.x;
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_18.x - (tmpvar_21 * 0.5));
  highp vec4 tmpvar_24;
  if ((materialColor_5.y < materialColor_5.z)) {
    highp vec4 tmpvar_25;
    tmpvar_25.zw = vec2(-1.0, 0.6666667);
    tmpvar_25.xy = tmpvar_8.zy;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(0.0, -0.3333333);
    tmpvar_26.xy = tmpvar_8.yz;
    tmpvar_24 = tmpvar_26;
  };
  highp vec4 tmpvar_27;
  if ((materialColor_5.x < tmpvar_24.x)) {
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = tmpvar_24.xyw;
    tmpvar_28.w = tmpvar_8.x;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.x = tmpvar_8.x;
    tmpvar_29.yzw = tmpvar_24.yzx;
    tmpvar_27 = tmpvar_29;
  };
  highp float tmpvar_30;
  tmpvar_30 = (tmpvar_27.x - min (tmpvar_27.w, tmpvar_27.y));
  highp vec3 tmpvar_31;
  tmpvar_31.x = abs(((
    (tmpvar_27.w - tmpvar_27.y)
   / 
    ((6.0 * tmpvar_30) + 1e-7)
  ) + tmpvar_27.z));
  tmpvar_31.y = tmpvar_30;
  tmpvar_31.z = tmpvar_27.x;
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_27.x - (tmpvar_30 * 0.5));
  highp vec3 tmpvar_33;
  tmpvar_33.x = tmpvar_31.x;
  tmpvar_33.y = (tmpvar_30 / ((1.0 - 
    abs(((2.0 * tmpvar_32) - 1.0))
  ) + 1e-7));
  tmpvar_33.z = tmpvar_32;
  highp vec3 tmpvar_34;
  tmpvar_34.x = (abs((
    (6.0 * tmpvar_22.x)
   - 3.0)) - 1.0);
  tmpvar_34.y = (2.0 - abs((
    (6.0 * tmpvar_22.x)
   - 2.0)));
  tmpvar_34.z = (2.0 - abs((
    (6.0 * tmpvar_22.x)
   - 4.0)));
  highp vec4 tmpvar_35;
  tmpvar_35.w = 0.0;
  tmpvar_35.xyz = (((
    clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_23) - 1.0)))
   * tmpvar_33.y)) + tmpvar_23);
  resultColor_3.xyz = mix (xlt_fbColor_1, tmpvar_35, vec4(factor_4)).xyz;
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  highp vec3 tmpvar_7;
  tmpvar_7 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_3 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_3;
      };
      factor_3 = tmpvar_12;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_13;
  highp vec2 tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (TEXTURE_GRAP, tmpvar_14);
  srcColor_13 = tmpvar_15;
  highp vec3 rgb_16;
  rgb_16 = srcColor_13.xyz;
  highp vec4 tmpvar_17;
  if ((srcColor_13.y < srcColor_13.z)) {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(-1.0, 0.6666667);
    tmpvar_18.xy = rgb_16.zy;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(0.0, -0.3333333);
    tmpvar_19.xy = rgb_16.yz;
    tmpvar_17 = tmpvar_19;
  };
  highp vec4 tmpvar_20;
  if ((srcColor_13.x < tmpvar_17.x)) {
    highp vec4 tmpvar_21;
    tmpvar_21.xyz = tmpvar_17.xyw;
    tmpvar_21.w = rgb_16.x;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.x = rgb_16.x;
    tmpvar_22.yzw = tmpvar_17.yzx;
    tmpvar_20 = tmpvar_22;
  };
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_20.x - min (tmpvar_20.w, tmpvar_20.y));
  highp vec3 tmpvar_24;
  tmpvar_24.x = abs(((
    (tmpvar_20.w - tmpvar_20.y)
   / 
    ((6.0 * tmpvar_23) + 1e-7)
  ) + tmpvar_20.z));
  tmpvar_24.y = tmpvar_23;
  tmpvar_24.z = tmpvar_20.x;
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_20.x - (tmpvar_23 * 0.5));
  highp vec4 tmpvar_26;
  if ((materialColor_4.y < materialColor_4.z)) {
    highp vec4 tmpvar_27;
    tmpvar_27.zw = vec2(-1.0, 0.6666667);
    tmpvar_27.xy = tmpvar_7.zy;
    tmpvar_26 = tmpvar_27;
  } else {
    highp vec4 tmpvar_28;
    tmpvar_28.zw = vec2(0.0, -0.3333333);
    tmpvar_28.xy = tmpvar_7.yz;
    tmpvar_26 = tmpvar_28;
  };
  highp vec4 tmpvar_29;
  if ((materialColor_4.x < tmpvar_26.x)) {
    highp vec4 tmpvar_30;
    tmpvar_30.xyz = tmpvar_26.xyw;
    tmpvar_30.w = tmpvar_7.x;
    tmpvar_29 = tmpvar_30;
  } else {
    highp vec4 tmpvar_31;
    tmpvar_31.x = tmpvar_7.x;
    tmpvar_31.yzw = tmpvar_26.yzx;
    tmpvar_29 = tmpvar_31;
  };
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_29.x - min (tmpvar_29.w, tmpvar_29.y));
  highp vec3 tmpvar_33;
  tmpvar_33.x = abs(((
    (tmpvar_29.w - tmpvar_29.y)
   / 
    ((6.0 * tmpvar_32) + 1e-7)
  ) + tmpvar_29.z));
  tmpvar_33.y = tmpvar_32;
  tmpvar_33.z = tmpvar_29.x;
  highp float tmpvar_34;
  tmpvar_34 = (tmpvar_29.x - (tmpvar_32 * 0.5));
  highp vec3 tmpvar_35;
  tmpvar_35.x = tmpvar_33.x;
  tmpvar_35.y = (tmpvar_32 / ((1.0 - 
    abs(((2.0 * tmpvar_34) - 1.0))
  ) + 1e-7));
  tmpvar_35.z = tmpvar_34;
  highp vec3 tmpvar_36;
  tmpvar_36.x = (abs((
    (6.0 * tmpvar_24.x)
   - 3.0)) - 1.0);
  tmpvar_36.y = (2.0 - abs((
    (6.0 * tmpvar_24.x)
   - 2.0)));
  tmpvar_36.z = (2.0 - abs((
    (6.0 * tmpvar_24.x)
   - 4.0)));
  highp vec4 tmpvar_37;
  tmpvar_37.w = 0.0;
  tmpvar_37.xyz = (((
    clamp (tmpvar_36, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_25) - 1.0)))
   * tmpvar_35.y)) + tmpvar_25);
  resultColor_2.xyz = mix (srcColor_13, tmpvar_37, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  highp vec3 tmpvar_8;
  tmpvar_8 = materialColor_5.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    } else {
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_10.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_11;
      lowp float tmpvar_12;
      tmpvar_12 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_11 = tmpvar_12;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_11 = 0.0;
      };
      highp float tmpvar_13;
      if ((bvtMaskColorAlpha_11 > 0.0)) {
        tmpvar_13 = (factor_4 * (1.0 - bvtMaskColorAlpha_11));
      } else {
        tmpvar_13 = factor_4;
      };
      factor_4 = tmpvar_13;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec3 rgb_14;
  rgb_14 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_15;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(-1.0, 0.6666667);
    tmpvar_16.xy = rgb_14.zy;
    tmpvar_15 = tmpvar_16;
  } else {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(0.0, -0.3333333);
    tmpvar_17.xy = rgb_14.yz;
    tmpvar_15 = tmpvar_17;
  };
  highp vec4 tmpvar_18;
  if ((xlt_fbColor_1.x < tmpvar_15.x)) {
    highp vec4 tmpvar_19;
    tmpvar_19.xyz = tmpvar_15.xyw;
    tmpvar_19.w = rgb_14.x;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.x = rgb_14.x;
    tmpvar_20.yzw = tmpvar_15.yzx;
    tmpvar_18 = tmpvar_20;
  };
  highp float tmpvar_21;
  tmpvar_21 = (tmpvar_18.x - min (tmpvar_18.w, tmpvar_18.y));
  highp vec3 tmpvar_22;
  tmpvar_22.x = abs(((
    (tmpvar_18.w - tmpvar_18.y)
   / 
    ((6.0 * tmpvar_21) + 1e-7)
  ) + tmpvar_18.z));
  tmpvar_22.y = tmpvar_21;
  tmpvar_22.z = tmpvar_18.x;
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_18.x - (tmpvar_21 * 0.5));
  highp vec3 tmpvar_24;
  tmpvar_24.x = tmpvar_22.x;
  tmpvar_24.y = (tmpvar_21 / ((1.0 - 
    abs(((2.0 * tmpvar_23) - 1.0))
  ) + 1e-7));
  tmpvar_24.z = tmpvar_23;
  highp vec4 tmpvar_25;
  if ((materialColor_5.y < materialColor_5.z)) {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(-1.0, 0.6666667);
    tmpvar_26.xy = tmpvar_8.zy;
    tmpvar_25 = tmpvar_26;
  } else {
    highp vec4 tmpvar_27;
    tmpvar_27.zw = vec2(0.0, -0.3333333);
    tmpvar_27.xy = tmpvar_8.yz;
    tmpvar_25 = tmpvar_27;
  };
  highp vec4 tmpvar_28;
  if ((materialColor_5.x < tmpvar_25.x)) {
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = tmpvar_25.xyw;
    tmpvar_29.w = tmpvar_8.x;
    tmpvar_28 = tmpvar_29;
  } else {
    highp vec4 tmpvar_30;
    tmpvar_30.x = tmpvar_8.x;
    tmpvar_30.yzw = tmpvar_25.yzx;
    tmpvar_28 = tmpvar_30;
  };
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_28.x - ((tmpvar_28.x - 
    min (tmpvar_28.w, tmpvar_28.y)
  ) * 0.5));
  highp vec3 tmpvar_32;
  tmpvar_32.x = (abs((
    (6.0 * tmpvar_22.x)
   - 3.0)) - 1.0);
  tmpvar_32.y = (2.0 - abs((
    (6.0 * tmpvar_22.x)
   - 2.0)));
  tmpvar_32.z = (2.0 - abs((
    (6.0 * tmpvar_22.x)
   - 4.0)));
  highp vec4 tmpvar_33;
  tmpvar_33.w = 0.0;
  tmpvar_33.xyz = (((
    clamp (tmpvar_32, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_31) - 1.0)))
   * tmpvar_24.y)) + tmpvar_31);
  resultColor_3.xyz = mix (xlt_fbColor_1, tmpvar_33, vec4(factor_4)).xyz;
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  highp vec3 tmpvar_7;
  tmpvar_7 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_3 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_3;
      };
      factor_3 = tmpvar_12;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_13;
  highp vec2 tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (TEXTURE_GRAP, tmpvar_14);
  srcColor_13 = tmpvar_15;
  highp vec3 rgb_16;
  rgb_16 = srcColor_13.xyz;
  highp vec4 tmpvar_17;
  if ((srcColor_13.y < srcColor_13.z)) {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(-1.0, 0.6666667);
    tmpvar_18.xy = rgb_16.zy;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(0.0, -0.3333333);
    tmpvar_19.xy = rgb_16.yz;
    tmpvar_17 = tmpvar_19;
  };
  highp vec4 tmpvar_20;
  if ((srcColor_13.x < tmpvar_17.x)) {
    highp vec4 tmpvar_21;
    tmpvar_21.xyz = tmpvar_17.xyw;
    tmpvar_21.w = rgb_16.x;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.x = rgb_16.x;
    tmpvar_22.yzw = tmpvar_17.yzx;
    tmpvar_20 = tmpvar_22;
  };
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_20.x - min (tmpvar_20.w, tmpvar_20.y));
  highp vec3 tmpvar_24;
  tmpvar_24.x = abs(((
    (tmpvar_20.w - tmpvar_20.y)
   / 
    ((6.0 * tmpvar_23) + 1e-7)
  ) + tmpvar_20.z));
  tmpvar_24.y = tmpvar_23;
  tmpvar_24.z = tmpvar_20.x;
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_20.x - (tmpvar_23 * 0.5));
  highp vec3 tmpvar_26;
  tmpvar_26.x = tmpvar_24.x;
  tmpvar_26.y = (tmpvar_23 / ((1.0 - 
    abs(((2.0 * tmpvar_25) - 1.0))
  ) + 1e-7));
  tmpvar_26.z = tmpvar_25;
  highp vec4 tmpvar_27;
  if ((materialColor_4.y < materialColor_4.z)) {
    highp vec4 tmpvar_28;
    tmpvar_28.zw = vec2(-1.0, 0.6666667);
    tmpvar_28.xy = tmpvar_7.zy;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.zw = vec2(0.0, -0.3333333);
    tmpvar_29.xy = tmpvar_7.yz;
    tmpvar_27 = tmpvar_29;
  };
  highp vec4 tmpvar_30;
  if ((materialColor_4.x < tmpvar_27.x)) {
    highp vec4 tmpvar_31;
    tmpvar_31.xyz = tmpvar_27.xyw;
    tmpvar_31.w = tmpvar_7.x;
    tmpvar_30 = tmpvar_31;
  } else {
    highp vec4 tmpvar_32;
    tmpvar_32.x = tmpvar_7.x;
    tmpvar_32.yzw = tmpvar_27.yzx;
    tmpvar_30 = tmpvar_32;
  };
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_30.x - ((tmpvar_30.x - 
    min (tmpvar_30.w, tmpvar_30.y)
  ) * 0.5));
  highp vec3 tmpvar_34;
  tmpvar_34.x = (abs((
    (6.0 * tmpvar_24.x)
   - 3.0)) - 1.0);
  tmpvar_34.y = (2.0 - abs((
    (6.0 * tmpvar_24.x)
   - 2.0)));
  tmpvar_34.z = (2.0 - abs((
    (6.0 * tmpvar_24.x)
   - 4.0)));
  highp vec4 tmpvar_35;
  tmpvar_35.w = 0.0;
  tmpvar_35.xyz = (((
    clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_33) - 1.0)))
   * tmpvar_26.y)) + tmpvar_33);
  resultColor_2.xyz = mix (srcColor_13, tmpvar_35, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  highp vec3 tmpvar_8;
  tmpvar_8 = materialColor_5.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    } else {
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_10.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_11;
      lowp float tmpvar_12;
      tmpvar_12 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_11 = tmpvar_12;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_11 = 0.0;
      };
      highp float tmpvar_13;
      if ((bvtMaskColorAlpha_11 > 0.0)) {
        tmpvar_13 = (factor_4 * (1.0 - bvtMaskColorAlpha_11));
      } else {
        tmpvar_13 = factor_4;
      };
      factor_4 = tmpvar_13;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec3 rgb_14;
  rgb_14 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_15;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(-1.0, 0.6666667);
    tmpvar_16.xy = rgb_14.zy;
    tmpvar_15 = tmpvar_16;
  } else {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(0.0, -0.3333333);
    tmpvar_17.xy = rgb_14.yz;
    tmpvar_15 = tmpvar_17;
  };
  highp vec4 tmpvar_18;
  if ((xlt_fbColor_1.x < tmpvar_15.x)) {
    highp vec4 tmpvar_19;
    tmpvar_19.xyz = tmpvar_15.xyw;
    tmpvar_19.w = rgb_14.x;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.x = rgb_14.x;
    tmpvar_20.yzw = tmpvar_15.yzx;
    tmpvar_18 = tmpvar_20;
  };
  highp float tmpvar_21;
  tmpvar_21 = (tmpvar_18.x - ((tmpvar_18.x - 
    min (tmpvar_18.w, tmpvar_18.y)
  ) * 0.5));
  highp vec4 tmpvar_22;
  if ((materialColor_5.y < materialColor_5.z)) {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(-1.0, 0.6666667);
    tmpvar_23.xy = tmpvar_8.zy;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.zw = vec2(0.0, -0.3333333);
    tmpvar_24.xy = tmpvar_8.yz;
    tmpvar_22 = tmpvar_24;
  };
  highp vec4 tmpvar_25;
  if ((materialColor_5.x < tmpvar_22.x)) {
    highp vec4 tmpvar_26;
    tmpvar_26.xyz = tmpvar_22.xyw;
    tmpvar_26.w = tmpvar_8.x;
    tmpvar_25 = tmpvar_26;
  } else {
    highp vec4 tmpvar_27;
    tmpvar_27.x = tmpvar_8.x;
    tmpvar_27.yzw = tmpvar_22.yzx;
    tmpvar_25 = tmpvar_27;
  };
  highp float tmpvar_28;
  tmpvar_28 = (tmpvar_25.x - min (tmpvar_25.w, tmpvar_25.y));
  highp vec3 tmpvar_29;
  tmpvar_29.x = abs(((
    (tmpvar_25.w - tmpvar_25.y)
   / 
    ((6.0 * tmpvar_28) + 1e-7)
  ) + tmpvar_25.z));
  tmpvar_29.y = tmpvar_28;
  tmpvar_29.z = tmpvar_25.x;
  highp float tmpvar_30;
  tmpvar_30 = (tmpvar_25.x - (tmpvar_28 * 0.5));
  highp vec3 tmpvar_31;
  tmpvar_31.x = tmpvar_29.x;
  tmpvar_31.y = (tmpvar_28 / ((1.0 - 
    abs(((2.0 * tmpvar_30) - 1.0))
  ) + 1e-7));
  tmpvar_31.z = tmpvar_30;
  highp vec3 tmpvar_32;
  tmpvar_32.x = (abs((
    (6.0 * tmpvar_29.x)
   - 3.0)) - 1.0);
  tmpvar_32.y = (2.0 - abs((
    (6.0 * tmpvar_29.x)
   - 2.0)));
  tmpvar_32.z = (2.0 - abs((
    (6.0 * tmpvar_29.x)
   - 4.0)));
  highp vec4 tmpvar_33;
  tmpvar_33.w = 0.0;
  tmpvar_33.xyz = (((
    clamp (tmpvar_32, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_21) - 1.0)))
   * tmpvar_31.y)) + tmpvar_21);
  resultColor_3.xyz = mix (xlt_fbColor_1, tmpvar_33, vec4(factor_4)).xyz;
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  highp vec3 tmpvar_7;
  tmpvar_7 = materialColor_4.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_3 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_3;
      };
      factor_3 = tmpvar_12;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_13;
  highp vec2 tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (TEXTURE_GRAP, tmpvar_14);
  srcColor_13 = tmpvar_15;
  highp vec3 rgb_16;
  rgb_16 = srcColor_13.xyz;
  highp vec4 tmpvar_17;
  if ((srcColor_13.y < srcColor_13.z)) {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(-1.0, 0.6666667);
    tmpvar_18.xy = rgb_16.zy;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(0.0, -0.3333333);
    tmpvar_19.xy = rgb_16.yz;
    tmpvar_17 = tmpvar_19;
  };
  highp vec4 tmpvar_20;
  if ((srcColor_13.x < tmpvar_17.x)) {
    highp vec4 tmpvar_21;
    tmpvar_21.xyz = tmpvar_17.xyw;
    tmpvar_21.w = rgb_16.x;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.x = rgb_16.x;
    tmpvar_22.yzw = tmpvar_17.yzx;
    tmpvar_20 = tmpvar_22;
  };
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_20.x - ((tmpvar_20.x - 
    min (tmpvar_20.w, tmpvar_20.y)
  ) * 0.5));
  highp vec4 tmpvar_24;
  if ((materialColor_4.y < materialColor_4.z)) {
    highp vec4 tmpvar_25;
    tmpvar_25.zw = vec2(-1.0, 0.6666667);
    tmpvar_25.xy = tmpvar_7.zy;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(0.0, -0.3333333);
    tmpvar_26.xy = tmpvar_7.yz;
    tmpvar_24 = tmpvar_26;
  };
  highp vec4 tmpvar_27;
  if ((materialColor_4.x < tmpvar_24.x)) {
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = tmpvar_24.xyw;
    tmpvar_28.w = tmpvar_7.x;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.x = tmpvar_7.x;
    tmpvar_29.yzw = tmpvar_24.yzx;
    tmpvar_27 = tmpvar_29;
  };
  highp float tmpvar_30;
  tmpvar_30 = (tmpvar_27.x - min (tmpvar_27.w, tmpvar_27.y));
  highp vec3 tmpvar_31;
  tmpvar_31.x = abs(((
    (tmpvar_27.w - tmpvar_27.y)
   / 
    ((6.0 * tmpvar_30) + 1e-7)
  ) + tmpvar_27.z));
  tmpvar_31.y = tmpvar_30;
  tmpvar_31.z = tmpvar_27.x;
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_27.x - (tmpvar_30 * 0.5));
  highp vec3 tmpvar_33;
  tmpvar_33.x = tmpvar_31.x;
  tmpvar_33.y = (tmpvar_30 / ((1.0 - 
    abs(((2.0 * tmpvar_32) - 1.0))
  ) + 1e-7));
  tmpvar_33.z = tmpvar_32;
  highp vec3 tmpvar_34;
  tmpvar_34.x = (abs((
    (6.0 * tmpvar_31.x)
   - 3.0)) - 1.0);
  tmpvar_34.y = (2.0 - abs((
    (6.0 * tmpvar_31.x)
   - 2.0)));
  tmpvar_34.z = (2.0 - abs((
    (6.0 * tmpvar_31.x)
   - 4.0)));
  highp vec4 tmpvar_35;
  tmpvar_35.w = 0.0;
  tmpvar_35.xyz = (((
    clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_23) - 1.0)))
   * tmpvar_33.y)) + tmpvar_23);
  resultColor_2.xyz = mix (srcColor_13, tmpvar_35, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  highp vec4 tmpvar_13;
  tmpvar_13.w = 0.0;
  tmpvar_13.xyz = ((dot (vec3(0.299, 0.587, 0.114), xlt_fbColor_1.xyz) * 1.68) * materialColor_5.xyz);
  resultColor_3.xyz = mix (xlt_fbColor_1, tmpvar_13, vec4(factor_4)).xyz;
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec4 tmpvar_15;
  tmpvar_15.w = 0.0;
  tmpvar_15.xyz = ((dot (vec3(0.299, 0.587, 0.114), srcColor_12.xyz) * 1.68) * materialColor_4.xyz);
  resultColor_2.xyz = mix (srcColor_12, tmpvar_15, vec4(factor_3)).xyz;
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, ((xlt_fbColor_1.xyz + materialColor_5.xyz) - (
    (2.0 * xlt_fbColor_1.xyz)
   * materialColor_5.xyz)), vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_12.xyz, ((srcColor_12.xyz + materialColor_4.xyz) - (
    (2.0 * srcColor_12.xyz)
   * materialColor_4.xyz)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_13;
  if ((materialColor_5.x < 0.5)) {
    tmpvar_13 = ((2.0 * materialColor_5.x) * xlt_fbColor_1.x);
  } else {
    tmpvar_13 = (1.0 - ((2.0 * 
      (1.0 - materialColor_5.x)
    ) * (1.0 - xlt_fbColor_1.x)));
  };
  highp float tmpvar_14;
  if ((materialColor_5.y < 0.5)) {
    tmpvar_14 = ((2.0 * materialColor_5.y) * xlt_fbColor_1.y);
  } else {
    tmpvar_14 = (1.0 - ((2.0 * 
      (1.0 - materialColor_5.y)
    ) * (1.0 - xlt_fbColor_1.y)));
  };
  highp float tmpvar_15;
  if ((materialColor_5.z < 0.5)) {
    tmpvar_15 = ((2.0 * materialColor_5.z) * xlt_fbColor_1.z);
  } else {
    tmpvar_15 = (1.0 - ((2.0 * 
      (1.0 - materialColor_5.z)
    ) * (1.0 - xlt_fbColor_1.z)));
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_13;
  tmpvar_16.y = tmpvar_14;
  tmpvar_16.z = tmpvar_15;
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, tmpvar_16, vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((materialColor_4.x < 0.5)) {
    tmpvar_15 = ((2.0 * materialColor_4.x) * srcColor_12.x);
  } else {
    tmpvar_15 = (1.0 - ((2.0 * 
      (1.0 - materialColor_4.x)
    ) * (1.0 - srcColor_12.x)));
  };
  highp float tmpvar_16;
  if ((materialColor_4.y < 0.5)) {
    tmpvar_16 = ((2.0 * materialColor_4.y) * srcColor_12.y);
  } else {
    tmpvar_16 = (1.0 - ((2.0 * 
      (1.0 - materialColor_4.y)
    ) * (1.0 - srcColor_12.y)));
  };
  highp float tmpvar_17;
  if ((materialColor_4.z < 0.5)) {
    tmpvar_17 = ((2.0 * materialColor_4.z) * srcColor_12.z);
  } else {
    tmpvar_17 = (1.0 - ((2.0 * 
      (1.0 - materialColor_4.z)
    ) * (1.0 - srcColor_12.z)));
  };
  highp vec3 tmpvar_18;
  tmpvar_18.x = tmpvar_15;
  tmpvar_18.y = tmpvar_16;
  tmpvar_18.z = tmpvar_17;
  resultColor_2.xyz = mix (srcColor_12.xyz, tmpvar_18, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_13;
  if ((materialColor_5.x < 0.5)) {
    highp float blend_14;
    blend_14 = (2.0 * materialColor_5.x);
    highp float tmpvar_15;
    if ((blend_14 == 0.0)) {
      tmpvar_15 = blend_14;
    } else {
      tmpvar_15 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_14)), 0.0);
    };
    tmpvar_13 = tmpvar_15;
  } else {
    highp float blend_16;
    blend_16 = (2.0 * (materialColor_5.x - 0.5));
    highp float tmpvar_17;
    if ((blend_16 == 1.0)) {
      tmpvar_17 = blend_16;
    } else {
      tmpvar_17 = min ((xlt_fbColor_1.x / (1.0 - blend_16)), 1.0);
    };
    tmpvar_13 = tmpvar_17;
  };
  highp float tmpvar_18;
  if ((materialColor_5.y < 0.5)) {
    highp float blend_19;
    blend_19 = (2.0 * materialColor_5.y);
    highp float tmpvar_20;
    if ((blend_19 == 0.0)) {
      tmpvar_20 = blend_19;
    } else {
      tmpvar_20 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_19)), 0.0);
    };
    tmpvar_18 = tmpvar_20;
  } else {
    highp float blend_21;
    blend_21 = (2.0 * (materialColor_5.y - 0.5));
    highp float tmpvar_22;
    if ((blend_21 == 1.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = min ((xlt_fbColor_1.y / (1.0 - blend_21)), 1.0);
    };
    tmpvar_18 = tmpvar_22;
  };
  highp float tmpvar_23;
  if ((materialColor_5.z < 0.5)) {
    highp float blend_24;
    blend_24 = (2.0 * materialColor_5.z);
    highp float tmpvar_25;
    if ((blend_24 == 0.0)) {
      tmpvar_25 = blend_24;
    } else {
      tmpvar_25 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_24)), 0.0);
    };
    tmpvar_23 = tmpvar_25;
  } else {
    highp float blend_26;
    blend_26 = (2.0 * (materialColor_5.z - 0.5));
    highp float tmpvar_27;
    if ((blend_26 == 1.0)) {
      tmpvar_27 = blend_26;
    } else {
      tmpvar_27 = min ((xlt_fbColor_1.z / (1.0 - blend_26)), 1.0);
    };
    tmpvar_23 = tmpvar_27;
  };
  highp vec3 tmpvar_28;
  tmpvar_28.x = tmpvar_13;
  tmpvar_28.y = tmpvar_18;
  tmpvar_28.z = tmpvar_23;
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, tmpvar_28, vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((materialColor_4.x < 0.5)) {
    highp float blend_16;
    blend_16 = (2.0 * materialColor_4.x);
    highp float tmpvar_17;
    if ((blend_16 == 0.0)) {
      tmpvar_17 = blend_16;
    } else {
      tmpvar_17 = max ((1.0 - (
        (1.0 - srcColor_12.x)
       / blend_16)), 0.0);
    };
    tmpvar_15 = tmpvar_17;
  } else {
    highp float blend_18;
    blend_18 = (2.0 * (materialColor_4.x - 0.5));
    highp float tmpvar_19;
    if ((blend_18 == 1.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = min ((srcColor_12.x / (1.0 - blend_18)), 1.0);
    };
    tmpvar_15 = tmpvar_19;
  };
  highp float tmpvar_20;
  if ((materialColor_4.y < 0.5)) {
    highp float blend_21;
    blend_21 = (2.0 * materialColor_4.y);
    highp float tmpvar_22;
    if ((blend_21 == 0.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = max ((1.0 - (
        (1.0 - srcColor_12.y)
       / blend_21)), 0.0);
    };
    tmpvar_20 = tmpvar_22;
  } else {
    highp float blend_23;
    blend_23 = (2.0 * (materialColor_4.y - 0.5));
    highp float tmpvar_24;
    if ((blend_23 == 1.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = min ((srcColor_12.y / (1.0 - blend_23)), 1.0);
    };
    tmpvar_20 = tmpvar_24;
  };
  highp float tmpvar_25;
  if ((materialColor_4.z < 0.5)) {
    highp float blend_26;
    blend_26 = (2.0 * materialColor_4.z);
    highp float tmpvar_27;
    if ((blend_26 == 0.0)) {
      tmpvar_27 = blend_26;
    } else {
      tmpvar_27 = max ((1.0 - (
        (1.0 - srcColor_12.z)
       / blend_26)), 0.0);
    };
    tmpvar_25 = tmpvar_27;
  } else {
    highp float blend_28;
    blend_28 = (2.0 * (materialColor_4.z - 0.5));
    highp float tmpvar_29;
    if ((blend_28 == 1.0)) {
      tmpvar_29 = blend_28;
    } else {
      tmpvar_29 = min ((srcColor_12.z / (1.0 - blend_28)), 1.0);
    };
    tmpvar_25 = tmpvar_29;
  };
  highp vec3 tmpvar_30;
  tmpvar_30.x = tmpvar_15;
  tmpvar_30.y = tmpvar_20;
  tmpvar_30.z = tmpvar_25;
  resultColor_2.xyz = mix (srcColor_12.xyz, tmpvar_30, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_13;
  if ((xlt_fbColor_1.x < 0.5)) {
    tmpvar_13 = ((2.0 * xlt_fbColor_1.x) * materialColor_5.x);
  } else {
    tmpvar_13 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.x)
    ) * (1.0 - materialColor_5.x)));
  };
  highp float tmpvar_14;
  if ((xlt_fbColor_1.y < 0.5)) {
    tmpvar_14 = ((2.0 * xlt_fbColor_1.y) * materialColor_5.y);
  } else {
    tmpvar_14 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.y)
    ) * (1.0 - materialColor_5.y)));
  };
  highp float tmpvar_15;
  if ((xlt_fbColor_1.z < 0.5)) {
    tmpvar_15 = ((2.0 * xlt_fbColor_1.z) * materialColor_5.z);
  } else {
    tmpvar_15 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.z)
    ) * (1.0 - materialColor_5.z)));
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_13;
  tmpvar_16.y = tmpvar_14;
  tmpvar_16.z = tmpvar_15;
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, tmpvar_16, vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((srcColor_12.x < 0.5)) {
    tmpvar_15 = ((2.0 * srcColor_12.x) * materialColor_4.x);
  } else {
    tmpvar_15 = (1.0 - ((2.0 * 
      (1.0 - srcColor_12.x)
    ) * (1.0 - materialColor_4.x)));
  };
  highp float tmpvar_16;
  if ((srcColor_12.y < 0.5)) {
    tmpvar_16 = ((2.0 * srcColor_12.y) * materialColor_4.y);
  } else {
    tmpvar_16 = (1.0 - ((2.0 * 
      (1.0 - srcColor_12.y)
    ) * (1.0 - materialColor_4.y)));
  };
  highp float tmpvar_17;
  if ((srcColor_12.z < 0.5)) {
    tmpvar_17 = ((2.0 * srcColor_12.z) * materialColor_4.z);
  } else {
    tmpvar_17 = (1.0 - ((2.0 * 
      (1.0 - srcColor_12.z)
    ) * (1.0 - materialColor_4.z)));
  };
  highp vec3 tmpvar_18;
  tmpvar_18.x = tmpvar_15;
  tmpvar_18.y = tmpvar_16;
  tmpvar_18.z = tmpvar_17;
  resultColor_2.xyz = mix (srcColor_12.xyz, tmpvar_18, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec3 blend_13;
  blend_13 = materialColor_5.xyz;
  highp float blend_14;
  blend_14 = blend_13.x;
  highp float tmpvar_15;
  if ((materialColor_5.x == 0.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.x)
     / materialColor_5.x)), 0.0);
  };
  highp float blend_16;
  blend_16 = blend_13.y;
  highp float tmpvar_17;
  if ((materialColor_5.y == 0.0)) {
    tmpvar_17 = blend_16;
  } else {
    tmpvar_17 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.y)
     / materialColor_5.y)), 0.0);
  };
  highp float blend_18;
  blend_18 = blend_13.z;
  highp float tmpvar_19;
  if ((materialColor_5.z == 0.0)) {
    tmpvar_19 = blend_18;
  } else {
    tmpvar_19 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.z)
     / materialColor_5.z)), 0.0);
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_15;
  tmpvar_20.y = tmpvar_17;
  tmpvar_20.z = tmpvar_19;
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, tmpvar_20, vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec3 blend_15;
  blend_15 = materialColor_4.xyz;
  highp float blend_16;
  blend_16 = blend_15.x;
  highp float tmpvar_17;
  if ((materialColor_4.x == 0.0)) {
    tmpvar_17 = blend_16;
  } else {
    tmpvar_17 = max ((1.0 - (
      (1.0 - srcColor_12.x)
     / materialColor_4.x)), 0.0);
  };
  highp float blend_18;
  blend_18 = blend_15.y;
  highp float tmpvar_19;
  if ((materialColor_4.y == 0.0)) {
    tmpvar_19 = blend_18;
  } else {
    tmpvar_19 = max ((1.0 - (
      (1.0 - srcColor_12.y)
     / materialColor_4.y)), 0.0);
  };
  highp float blend_20;
  blend_20 = blend_15.z;
  highp float tmpvar_21;
  if ((materialColor_4.z == 0.0)) {
    tmpvar_21 = blend_20;
  } else {
    tmpvar_21 = max ((1.0 - (
      (1.0 - srcColor_12.z)
     / materialColor_4.z)), 0.0);
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_17;
  tmpvar_22.y = tmpvar_19;
  tmpvar_22.z = tmpvar_21;
  resultColor_2.xyz = mix (srcColor_12.xyz, tmpvar_22, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec3 blend_13;
  blend_13 = materialColor_5.xyz;
  highp float blend_14;
  blend_14 = blend_13.x;
  highp float tmpvar_15;
  if ((materialColor_5.x == 1.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = min ((xlt_fbColor_1.x / (1.0 - materialColor_5.x)), 1.0);
  };
  highp float blend_16;
  blend_16 = blend_13.y;
  highp float tmpvar_17;
  if ((materialColor_5.y == 1.0)) {
    tmpvar_17 = blend_16;
  } else {
    tmpvar_17 = min ((xlt_fbColor_1.y / (1.0 - materialColor_5.y)), 1.0);
  };
  highp float blend_18;
  blend_18 = blend_13.z;
  highp float tmpvar_19;
  if ((materialColor_5.z == 1.0)) {
    tmpvar_19 = blend_18;
  } else {
    tmpvar_19 = min ((xlt_fbColor_1.z / (1.0 - materialColor_5.z)), 1.0);
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_15;
  tmpvar_20.y = tmpvar_17;
  tmpvar_20.z = tmpvar_19;
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, tmpvar_20, vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec3 blend_15;
  blend_15 = materialColor_4.xyz;
  highp float blend_16;
  blend_16 = blend_15.x;
  highp float tmpvar_17;
  if ((materialColor_4.x == 1.0)) {
    tmpvar_17 = blend_16;
  } else {
    tmpvar_17 = min ((srcColor_12.x / (1.0 - materialColor_4.x)), 1.0);
  };
  highp float blend_18;
  blend_18 = blend_15.y;
  highp float tmpvar_19;
  if ((materialColor_4.y == 1.0)) {
    tmpvar_19 = blend_18;
  } else {
    tmpvar_19 = min ((srcColor_12.y / (1.0 - materialColor_4.y)), 1.0);
  };
  highp float blend_20;
  blend_20 = blend_15.z;
  highp float tmpvar_21;
  if ((materialColor_4.z == 1.0)) {
    tmpvar_21 = blend_20;
  } else {
    tmpvar_21 = min ((srcColor_12.z / (1.0 - materialColor_4.z)), 1.0);
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_17;
  tmpvar_22.y = tmpvar_19;
  tmpvar_22.z = tmpvar_21;
  resultColor_2.xyz = mix (srcColor_12.xyz, tmpvar_22, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, ((
    ((vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * materialColor_5.xyz)) * xlt_fbColor_1.xyz)
   * xlt_fbColor_1.xyz) + (
    (vec3(2.0, 2.0, 2.0) * xlt_fbColor_1.xyz)
   * materialColor_5.xyz)), vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_12.xyz, ((
    ((vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * materialColor_4.xyz)) * srcColor_12.xyz)
   * srcColor_12.xyz) + (
    (vec3(2.0, 2.0, 2.0) * srcColor_12.xyz)
   * materialColor_4.xyz)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_13;
  highp float tmpvar_14;
  if ((materialColor_5.x < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * materialColor_5.x);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (materialColor_5.x - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((xlt_fbColor_1.x / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  if ((tmpvar_14 < 0.5)) {
    tmpvar_13 = 0.0;
  } else {
    tmpvar_13 = 1.0;
  };
  highp float tmpvar_19;
  highp float tmpvar_20;
  if ((materialColor_5.y < 0.5)) {
    highp float blend_21;
    blend_21 = (2.0 * materialColor_5.y);
    highp float tmpvar_22;
    if ((blend_21 == 0.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_21)), 0.0);
    };
    tmpvar_20 = tmpvar_22;
  } else {
    highp float blend_23;
    blend_23 = (2.0 * (materialColor_5.y - 0.5));
    highp float tmpvar_24;
    if ((blend_23 == 1.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = min ((xlt_fbColor_1.y / (1.0 - blend_23)), 1.0);
    };
    tmpvar_20 = tmpvar_24;
  };
  if ((tmpvar_20 < 0.5)) {
    tmpvar_19 = 0.0;
  } else {
    tmpvar_19 = 1.0;
  };
  highp float tmpvar_25;
  highp float tmpvar_26;
  if ((materialColor_5.z < 0.5)) {
    highp float blend_27;
    blend_27 = (2.0 * materialColor_5.z);
    highp float tmpvar_28;
    if ((blend_27 == 0.0)) {
      tmpvar_28 = blend_27;
    } else {
      tmpvar_28 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_27)), 0.0);
    };
    tmpvar_26 = tmpvar_28;
  } else {
    highp float blend_29;
    blend_29 = (2.0 * (materialColor_5.z - 0.5));
    highp float tmpvar_30;
    if ((blend_29 == 1.0)) {
      tmpvar_30 = blend_29;
    } else {
      tmpvar_30 = min ((xlt_fbColor_1.z / (1.0 - blend_29)), 1.0);
    };
    tmpvar_26 = tmpvar_30;
  };
  if ((tmpvar_26 < 0.5)) {
    tmpvar_25 = 0.0;
  } else {
    tmpvar_25 = 1.0;
  };
  highp vec3 tmpvar_31;
  tmpvar_31.x = tmpvar_13;
  tmpvar_31.y = tmpvar_19;
  tmpvar_31.z = tmpvar_25;
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, tmpvar_31, vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  highp float tmpvar_16;
  if ((materialColor_4.x < 0.5)) {
    highp float blend_17;
    blend_17 = (2.0 * materialColor_4.x);
    highp float tmpvar_18;
    if ((blend_17 == 0.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = max ((1.0 - (
        (1.0 - srcColor_12.x)
       / blend_17)), 0.0);
    };
    tmpvar_16 = tmpvar_18;
  } else {
    highp float blend_19;
    blend_19 = (2.0 * (materialColor_4.x - 0.5));
    highp float tmpvar_20;
    if ((blend_19 == 1.0)) {
      tmpvar_20 = blend_19;
    } else {
      tmpvar_20 = min ((srcColor_12.x / (1.0 - blend_19)), 1.0);
    };
    tmpvar_16 = tmpvar_20;
  };
  if ((tmpvar_16 < 0.5)) {
    tmpvar_15 = 0.0;
  } else {
    tmpvar_15 = 1.0;
  };
  highp float tmpvar_21;
  highp float tmpvar_22;
  if ((materialColor_4.y < 0.5)) {
    highp float blend_23;
    blend_23 = (2.0 * materialColor_4.y);
    highp float tmpvar_24;
    if ((blend_23 == 0.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = max ((1.0 - (
        (1.0 - srcColor_12.y)
       / blend_23)), 0.0);
    };
    tmpvar_22 = tmpvar_24;
  } else {
    highp float blend_25;
    blend_25 = (2.0 * (materialColor_4.y - 0.5));
    highp float tmpvar_26;
    if ((blend_25 == 1.0)) {
      tmpvar_26 = blend_25;
    } else {
      tmpvar_26 = min ((srcColor_12.y / (1.0 - blend_25)), 1.0);
    };
    tmpvar_22 = tmpvar_26;
  };
  if ((tmpvar_22 < 0.5)) {
    tmpvar_21 = 0.0;
  } else {
    tmpvar_21 = 1.0;
  };
  highp float tmpvar_27;
  highp float tmpvar_28;
  if ((materialColor_4.z < 0.5)) {
    highp float blend_29;
    blend_29 = (2.0 * materialColor_4.z);
    highp float tmpvar_30;
    if ((blend_29 == 0.0)) {
      tmpvar_30 = blend_29;
    } else {
      tmpvar_30 = max ((1.0 - (
        (1.0 - srcColor_12.z)
       / blend_29)), 0.0);
    };
    tmpvar_28 = tmpvar_30;
  } else {
    highp float blend_31;
    blend_31 = (2.0 * (materialColor_4.z - 0.5));
    highp float tmpvar_32;
    if ((blend_31 == 1.0)) {
      tmpvar_32 = blend_31;
    } else {
      tmpvar_32 = min ((srcColor_12.z / (1.0 - blend_31)), 1.0);
    };
    tmpvar_28 = tmpvar_32;
  };
  if ((tmpvar_28 < 0.5)) {
    tmpvar_27 = 0.0;
  } else {
    tmpvar_27 = 1.0;
  };
  highp vec3 tmpvar_33;
  tmpvar_33.x = tmpvar_15;
  tmpvar_33.y = tmpvar_21;
  tmpvar_33.z = tmpvar_27;
  resultColor_2.xyz = mix (srcColor_12.xyz, tmpvar_33, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_13;
  if ((materialColor_5.x < 0.5)) {
    tmpvar_13 = min ((2.0 * materialColor_5.x), xlt_fbColor_1.x);
  } else {
    tmpvar_13 = max ((2.0 * (materialColor_5.x - 0.5)), xlt_fbColor_1.x);
  };
  highp float tmpvar_14;
  if ((materialColor_5.y < 0.5)) {
    tmpvar_14 = min ((2.0 * materialColor_5.y), xlt_fbColor_1.y);
  } else {
    tmpvar_14 = max ((2.0 * (materialColor_5.y - 0.5)), xlt_fbColor_1.y);
  };
  highp float tmpvar_15;
  if ((materialColor_5.z < 0.5)) {
    tmpvar_15 = min ((2.0 * materialColor_5.z), xlt_fbColor_1.z);
  } else {
    tmpvar_15 = max ((2.0 * (materialColor_5.z - 0.5)), xlt_fbColor_1.z);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_13;
  tmpvar_16.y = tmpvar_14;
  tmpvar_16.z = tmpvar_15;
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, tmpvar_16, vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((materialColor_4.x < 0.5)) {
    tmpvar_15 = min ((2.0 * materialColor_4.x), srcColor_12.x);
  } else {
    tmpvar_15 = max ((2.0 * (materialColor_4.x - 0.5)), srcColor_12.x);
  };
  highp float tmpvar_16;
  if ((materialColor_4.y < 0.5)) {
    tmpvar_16 = min ((2.0 * materialColor_4.y), srcColor_12.y);
  } else {
    tmpvar_16 = max ((2.0 * (materialColor_4.y - 0.5)), srcColor_12.y);
  };
  highp float tmpvar_17;
  if ((materialColor_4.z < 0.5)) {
    tmpvar_17 = min ((2.0 * materialColor_4.z), srcColor_12.z);
  } else {
    tmpvar_17 = max ((2.0 * (materialColor_4.z - 0.5)), srcColor_12.z);
  };
  highp vec3 tmpvar_18;
  tmpvar_18.x = tmpvar_15;
  tmpvar_18.y = tmpvar_16;
  tmpvar_18.z = tmpvar_17;
  resultColor_2.xyz = mix (srcColor_12.xyz, tmpvar_18, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_13;
  if ((materialColor_5.x < 0.5)) {
    tmpvar_13 = max (((xlt_fbColor_1.x + 
      (2.0 * materialColor_5.x)
    ) - 1.0), 0.0);
  } else {
    tmpvar_13 = min ((xlt_fbColor_1.x + (2.0 * 
      (materialColor_5.x - 0.5)
    )), 1.0);
  };
  highp float tmpvar_14;
  if ((materialColor_5.y < 0.5)) {
    tmpvar_14 = max (((xlt_fbColor_1.y + 
      (2.0 * materialColor_5.y)
    ) - 1.0), 0.0);
  } else {
    tmpvar_14 = min ((xlt_fbColor_1.y + (2.0 * 
      (materialColor_5.y - 0.5)
    )), 1.0);
  };
  highp float tmpvar_15;
  if ((materialColor_5.z < 0.5)) {
    tmpvar_15 = max (((xlt_fbColor_1.z + 
      (2.0 * materialColor_5.z)
    ) - 1.0), 0.0);
  } else {
    tmpvar_15 = min ((xlt_fbColor_1.z + (2.0 * 
      (materialColor_5.z - 0.5)
    )), 1.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_13;
  tmpvar_16.y = tmpvar_14;
  tmpvar_16.z = tmpvar_15;
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, tmpvar_16, vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((materialColor_4.x < 0.5)) {
    tmpvar_15 = max (((srcColor_12.x + 
      (2.0 * materialColor_4.x)
    ) - 1.0), 0.0);
  } else {
    tmpvar_15 = min ((srcColor_12.x + (2.0 * 
      (materialColor_4.x - 0.5)
    )), 1.0);
  };
  highp float tmpvar_16;
  if ((materialColor_4.y < 0.5)) {
    tmpvar_16 = max (((srcColor_12.y + 
      (2.0 * materialColor_4.y)
    ) - 1.0), 0.0);
  } else {
    tmpvar_16 = min ((srcColor_12.y + (2.0 * 
      (materialColor_4.y - 0.5)
    )), 1.0);
  };
  highp float tmpvar_17;
  if ((materialColor_4.z < 0.5)) {
    tmpvar_17 = max (((srcColor_12.z + 
      (2.0 * materialColor_4.z)
    ) - 1.0), 0.0);
  } else {
    tmpvar_17 = min ((srcColor_12.z + (2.0 * 
      (materialColor_4.z - 0.5)
    )), 1.0);
  };
  highp vec3 tmpvar_18;
  tmpvar_18.x = tmpvar_15;
  tmpvar_18.y = tmpvar_16;
  tmpvar_18.z = tmpvar_17;
  resultColor_2.xyz = mix (srcColor_12.xyz, tmpvar_18, vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, abs((xlt_fbColor_1.xyz - materialColor_5.xyz)), vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_12.xyz, abs((srcColor_12.xyz - materialColor_4.xyz)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, max ((
    (xlt_fbColor_1.xyz + materialColor_5.xyz)
   - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0)), vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_12.xyz, max ((
    (srcColor_12.xyz + materialColor_4.xyz)
   - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_8.x);
    } else {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_10;
      lowp float tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_10 = tmpvar_11;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_10 = 0.0;
      };
      highp float tmpvar_12;
      if ((bvtMaskColorAlpha_10 > 0.0)) {
        tmpvar_12 = (factor_4 * (1.0 - bvtMaskColorAlpha_10));
      } else {
        tmpvar_12 = factor_4;
      };
      factor_4 = tmpvar_12;
    };
  };
  resultColor_3.xyz = mix (xlt_fbColor_1.xyz, max ((xlt_fbColor_1.xyz - materialColor_5.xyz), vec3(0.0, 0.0, 0.0)), vec3(factor_4));
  resultColor_3.w = 1.0;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp float factor_3;
  highp vec4 materialColor_4;
  highp float alphaValue_5;
  alphaValue_5 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_5 = 1.0;
  };
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_4 = tmpvar_6;
  factor_3 = ((materialColor_4.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_5));
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_7;
      tmpvar_7 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_7.x);
    } else {
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_3 = (factor_3 * tmpvar_8.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_9;
      lowp float tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_9 = tmpvar_10;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_9 = 0.0;
      };
      highp float tmpvar_11;
      if ((bvtMaskColorAlpha_9 > 0.0)) {
        tmpvar_11 = (factor_3 * (1.0 - bvtMaskColorAlpha_9));
      } else {
        tmpvar_11 = factor_3;
      };
      factor_3 = tmpvar_11;
    };
  };
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  resultColor_2.xyz = mix (srcColor_12.xyz, max ((srcColor_12.xyz - materialColor_4.xyz), vec3(0.0, 0.0, 0.0)), vec3(factor_3));
  resultColor_2.w = 1.0;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform sampler2D _LutMap;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec3 resColor_3;
  highp vec4 resultColor_4;
  highp float factor_5;
  highp vec4 materialColor_6;
  highp float alphaValue_7;
  alphaValue_7 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_7 = 1.0;
  };
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_6 = tmpvar_8;
  factor_5 = ((materialColor_6.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_7));
  highp vec3 tmpvar_9;
  tmpvar_9 = materialColor_6.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_5 = (factor_5 * tmpvar_10.x);
    } else {
      lowp vec4 tmpvar_11;
      tmpvar_11 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_5 = (factor_5 * tmpvar_11.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_12;
      lowp float tmpvar_13;
      tmpvar_13 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_12 = tmpvar_13;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_12 = 0.0;
      };
      highp float tmpvar_14;
      if ((bvtMaskColorAlpha_12 > 0.0)) {
        tmpvar_14 = (factor_5 * (1.0 - bvtMaskColorAlpha_12));
      } else {
        tmpvar_14 = factor_5;
      };
      factor_5 = tmpvar_14;
    };
  };
  highp vec2 tmpvar_15;
  tmpvar_15.x = tmpvar_9.x;
  tmpvar_15.y = xlt_fbColor_1.x;
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_LutMap, tmpvar_15);
  resColor_3.x = tmpvar_16.x;
  highp vec2 tmpvar_17;
  tmpvar_17.x = tmpvar_9.y;
  tmpvar_17.y = xlt_fbColor_1.y;
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture2D (_LutMap, tmpvar_17);
  resColor_3.y = tmpvar_18.y;
  highp vec2 tmpvar_19;
  tmpvar_19.x = tmpvar_9.z;
  tmpvar_19.y = xlt_fbColor_1.z;
  lowp vec4 tmpvar_20;
  tmpvar_20 = texture2D (_LutMap, tmpvar_19);
  resColor_3.z = tmpvar_20.z;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 0.0;
  tmpvar_21.xyz = resColor_3;
  resultColor_4.xyz = mix (xlt_fbColor_1, tmpvar_21, vec4(factor_5)).xyz;
  resultColor_4.w = 1.0;
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScaleInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfoBvt",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EditorMaskMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UseBvtMask",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Strength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _UseMask;
uniform highp vec4 _MaskScaleInfo;
uniform highp vec4 _MaskInfo;
uniform highp float _UseBvtMask;
uniform highp vec2 _VideoSize;
uniform highp vec4 _MaskInfoBvt;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 pos_2;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  tmpvar_5 = vec2(0.0, 0.0);
  highp vec2 tmpvar_6;
  tmpvar_6.x = (((_glesMultiTexCoord0.x * 1000.0) - _MaskInfo.x) / _MaskInfo.z);
  tmpvar_6.y = (((_glesMultiTexCoord0.y * 1500.0) - _MaskInfo.y) / _MaskInfo.w);
  if ((_glesVertex.w > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    pos_2 = tmpvar_9;
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_3 = o_11;
    tmpvar_4 = 1.0;
    if ((_UseMask > 0.1)) {
      highp vec2 tmpvar_13;
      tmpvar_13.x = ((_glesMultiTexCoord0.x * 1000.0) - _MaskScaleInfo.x);
      tmpvar_13.y = ((_glesMultiTexCoord0.y * 1500.0) - _MaskScaleInfo.y);
      tmpvar_5 = (tmpvar_13 / _MaskScaleInfo.zw);
    };
  } else {
    tmpvar_4 = tmpvar_1.z;
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    pos_2 = (LOCALWORLD_TRANSFORM * tmpvar_14);
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (pos_2 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = pos_2.zw;
    tmpvar_3 = o_15;
    if ((_UseMask > 0.1)) {
      tmpvar_5 = (o_15.xy / pos_2.w);
    } else {
      if ((_UseBvtMask > 0.1)) {
        highp vec2 tmpvar_17;
        tmpvar_17 = ((_glesVertex + 1.0) / 2.0).xy;
        highp vec2 tmpvar_18;
        tmpvar_18.x = _MaskInfoBvt.x;
        tmpvar_18.y = (_MaskInfoBvt.x + _MaskInfoBvt.z);
        highp vec2 tmpvar_19;
        tmpvar_19 = (tmpvar_18 / _VideoSize.x);
        highp vec2 tmpvar_20;
        highp float tmpvar_21;
        tmpvar_21 = (_VideoSize.y - _MaskInfoBvt.y);
        tmpvar_20.x = (tmpvar_21 - _MaskInfoBvt.w);
        tmpvar_20.y = tmpvar_21;
        highp vec2 tmpvar_22;
        tmpvar_22 = (tmpvar_20 / _VideoSize.y);
        highp vec2 tmpvar_23;
        tmpvar_23.x = ((tmpvar_17.x - tmpvar_19.x) / (tmpvar_19.y - tmpvar_19.x));
        tmpvar_23.y = (1.0 - ((tmpvar_17.y - tmpvar_22.x) / (tmpvar_22.y - tmpvar_22.x)));
        tmpvar_5 = tmpvar_23;
      };
    };
  };
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = tmpvar_6;
  gl_Position = (tmpvar_24 * pos_2);
  xlv_TEXCOORD1 = tmpvar_3;
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_5;
  xlv_TEXCOORD4 = 0.0;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform highp float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform sampler2D _MainTex;
uniform sampler2D _LutMap;
uniform highp float _UseBvtMask;
uniform highp float _Opacity;
uniform highp float _Strength;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec3 resColor_2;
  highp vec4 resultColor_3;
  highp float factor_4;
  highp vec4 materialColor_5;
  highp float alphaValue_6;
  alphaValue_6 = 0.0;
  if ((((
    (xlv_TEXCOORD0.x > 0.0)
   && 
    (xlv_TEXCOORD0.x < 1.0)
  ) && (xlv_TEXCOORD0.y > 0.0)) && (xlv_TEXCOORD0.y < 1.0))) {
    alphaValue_6 = 1.0;
  };
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_MainTex, xlv_TEXCOORD0);
  materialColor_5 = tmpvar_7;
  factor_4 = ((materialColor_5.w * _Strength) * ((_Opacity * xlv_TEXCOORD2) * alphaValue_6));
  highp vec3 tmpvar_8;
  tmpvar_8 = materialColor_5.xyz;
  if ((_UseMask > 0.1)) {
    if ((xlv_TEXCOORD4 > 0.1)) {
      lowp vec4 tmpvar_9;
      tmpvar_9 = texture2D (_EditorMaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_9.x);
    } else {
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (_MaskMap, xlv_TEXCOORD3);
      factor_4 = (factor_4 * tmpvar_10.x);
    };
  } else {
    if ((_UseBvtMask > 0.1)) {
      highp float bvtMaskColorAlpha_11;
      lowp float tmpvar_12;
      tmpvar_12 = texture2D (_MaskMap, xlv_TEXCOORD3).w;
      bvtMaskColorAlpha_11 = tmpvar_12;
      if ((((
        (xlv_TEXCOORD3.x < 0.0)
       || 
        (xlv_TEXCOORD3.y < 0.0)
      ) || (xlv_TEXCOORD3.x > 1.0)) || (xlv_TEXCOORD3.y > 1.0))) {
        bvtMaskColorAlpha_11 = 0.0;
      };
      highp float tmpvar_13;
      if ((bvtMaskColorAlpha_11 > 0.0)) {
        tmpvar_13 = (factor_4 * (1.0 - bvtMaskColorAlpha_11));
      } else {
        tmpvar_13 = factor_4;
      };
      factor_4 = tmpvar_13;
    };
  };
  highp vec4 srcColor_14;
  highp vec2 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (TEXTURE_GRAP, tmpvar_15);
  srcColor_14 = tmpvar_16;
  highp vec2 tmpvar_17;
  tmpvar_17.x = tmpvar_8.x;
  tmpvar_17.y = srcColor_14.x;
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture2D (_LutMap, tmpvar_17);
  resColor_2.x = tmpvar_18.x;
  highp vec2 tmpvar_19;
  tmpvar_19.x = tmpvar_8.y;
  tmpvar_19.y = srcColor_14.y;
  lowp vec4 tmpvar_20;
  tmpvar_20 = texture2D (_LutMap, tmpvar_19);
  resColor_2.y = tmpvar_20.y;
  highp vec2 tmpvar_21;
  tmpvar_21.x = tmpvar_8.z;
  tmpvar_21.y = srcColor_14.z;
  lowp vec4 tmpvar_22;
  tmpvar_22 = texture2D (_LutMap, tmpvar_21);
  resColor_2.z = tmpvar_22.z;
  highp vec4 tmpvar_23;
  tmpvar_23.w = 0.0;
  tmpvar_23.xyz = resColor_2;
  resultColor_3.xyz = mix (srcColor_14, tmpvar_23, vec4(factor_4)).xyz;
  resultColor_3.w = 1.0;
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
