

#DEFPARAMS
_MainTex = { "Main Tex", TEXTURE2D, "black" },
_Displacement = {"Initial Displacement", VEC2, "0.0, 0.0"},
#END

#DEFTAG
ShaderName = "face_view2D"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


CGPROGRAM
#pragma vertex vert
#pragma fragment frag

#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
	float visibility: TEXCOORD1;
};

sampler2D _MainTex;
float2 _Displacement;


v2f vert(appdata v)
{
	v2f o = (v2f)0;

    o.uv = float2(v.uv.x, 1-v.uv.y);
	o.visibility = v.vertex.z;

	float4 pos;
	float scene2DRectWidth = 0.2;
	float scene2DRectHeight = 0.3;
	float xCenter = 0.1/scene2DRectWidth;
	float yCenter = 0.12/scene2DRectHeight;
	float2 uv2pos;
	uv2pos.x = (v.uv.x - xCenter) * scene2DRectWidth;
	uv2pos.y = (v.uv.y - yCenter) * scene2DRectHeight;
	pos = float4(uv2pos.x, uv2pos.y, 0.0,1.0);
	pos = pos - float4(_Displacement.x, _Displacement.y, 0.0, 0.0);
	pos = ObjectToClipPos(pos);
	o.vertex = UniformNDC(pos);
	return o;
}


fixed4 frag(v2f i) : SV_Target
{
	float alphaValue = 0.0;
	if(i.uv.x>0.0&&i.uv.x<1.0&&i.uv.y>0.0&&i.uv.y<1.0) 
	{
	    alphaValue = 1.0;
	}

	// sample the texture
	float4 materialColor = tex2D(_MainTex, i.uv);

	float4 resultColor = float4(1.0, 1.0, 1.0, 1.0);
	float factor  = materialColor.a * smoothstep(0.5, 1.0, i.visibility);
	resultColor = float4(materialColor.r, materialColor.g, materialColor.b, factor);

	return resultColor;
}
ENDCG
#END
