

function DefineParams()
	Properties = 
	{
		
_FgTex = { "Foreground Tex", TEXTURE2D, "white" },
_BgTex = { "Background Tex", TEXTURE2D, "black" },
_MatFgToBg1 = { "", VEC3, "0, 0, 0" },
_MatFgToBg2 = { "", VEC3, "0, 0, 0" },
_MatFgToBg3 = { "", VEC3, "0, 0, 0" },
_BgSize = { "", VEC2, "1, 1" },
_BgAnchor1 = { "", VEC2, "0, 0" },
_BgAnchor2 = { "", VEC2, "0, 0" },
_BgAnchor3 = { "", VEC2, "0, 0" },
_BgAnchor4 = { "", VEC2, "0, 0" },
_AlphaAdjust = { "", FLOAT, "1" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "FaceSkin"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MatFgToBg1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MatFgToBg2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MatFgToBg3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MatFgToBg1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MatFgToBg2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MatFgToBg3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BgSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BgAnchor1",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BgAnchor2",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BgAnchor3",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BgAnchor4",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AlphaAdjust",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 _MatFgToBg1;
uniform highp vec3 _MatFgToBg2;
uniform highp vec3 _MatFgToBg3;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec2 tmpvar_1;
  highp vec3 tmpvar_2;
  tmpvar_2.z = 1.0;
  tmpvar_2.xy = ((_glesVertex.xy + 1.0) * 0.5);
  highp mat3 tmpvar_3;
  tmpvar_3[0].x = _MatFgToBg1.x;
  tmpvar_3[0].y = _MatFgToBg2.x;
  tmpvar_3[0].z = _MatFgToBg3.x;
  tmpvar_3[1].x = _MatFgToBg1.y;
  tmpvar_3[1].y = _MatFgToBg2.y;
  tmpvar_3[1].z = _MatFgToBg3.y;
  tmpvar_3[2].x = _MatFgToBg1.z;
  tmpvar_3[2].y = _MatFgToBg2.z;
  tmpvar_3[2].z = _MatFgToBg3.z;
  highp vec4 tmpvar_4;
  tmpvar_4.zw = vec2(0.0, 1.0);
  tmpvar_4.xy = (((tmpvar_2 * tmpvar_3).xy * 2.0) - 1.0);
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  tmpvar_1.x = _glesMultiTexCoord0.x;
  tmpvar_1.y = (1.0 - _glesMultiTexCoord0.y);
  xlv_TEXCOORD0 = tmpvar_1;
  gl_Position = (tmpvar_5 * tmpvar_4);
}

]===],
		psShader = [===[mat2 xll_transpose_mf2x2(mat2 m) {
  return mat2( m[0][0], m[1][0], m[0][1], m[1][1]);
}
mat3 xll_transpose_mf3x3(mat3 m) {
  return mat3( m[0][0], m[1][0], m[2][0],
               m[0][1], m[1][1], m[2][1],
               m[0][2], m[1][2], m[2][2]);
}
mat4 xll_transpose_mf4x4(mat4 m) {
  return mat4( m[0][0], m[1][0], m[2][0], m[3][0],
               m[0][1], m[1][1], m[2][1], m[3][1],
               m[0][2], m[1][2], m[2][2], m[3][2],
               m[0][3], m[1][3], m[2][3], m[3][3]);
}
#line 15
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
};
#line 9
struct appdata {
    highp vec2 vertex;
    highp vec2 uv;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 3
#line 26
#line 34
#line 21
uniform sampler2D _FgTex;
uniform sampler2D _BgTex;
uniform highp vec3 _MatFgToBg1;
uniform highp vec3 _MatFgToBg2;
#line 25
uniform highp vec3 _MatFgToBg3;
uniform highp vec2 _BgSize;
uniform highp vec2 _BgAnchor1;
uniform highp vec2 _BgAnchor2;
#line 29
uniform highp vec2 _BgAnchor3;
uniform highp vec2 _BgAnchor4;
uniform highp float _AlphaAdjust;
#line 33
#line 48
#line 56
#line 56
bool checkHSV( in highp vec3 hsv, in highp vec3 hsv1, in highp vec3 hsv2, in highp vec3 hsv3 ) {
    bool checkHue = (hsv.x < 0.1666667);
    bool checkSat = (hsv.y < 0.75);
    #line 60
    return (checkHue && checkSat);
}
#line 3
highp vec3 rgb2hsv( in highp vec3 c ) {
    highp vec4 K = vec4( 0.0, -0.3333333, 0.6666667, -1.0);
    highp vec4 p = mix( vec4( c.zy, K.wz), vec4( c.yz, K.xy), vec4( step( c.z, c.y)));
    #line 7
    highp vec4 q = mix( vec4( p.xyw, c.x), vec4( c.x, p.yzx), vec4( step( p.x, c.x)));
    highp float d = (q.x - min( q.w, q.y));
    highp float e = 1e-10;
    #line 11
    highp float v = q.x;
    highp float h = (( (d <= e) ) ? ( 0.0 ) : ( abs((q.z + ((q.w - q.y) / (6.0 * d)))) ));
    highp float s = (( (d <= e) ) ? ( 0.0 ) : ( (d / v) ));
    s = (( (v <= 0.3) ) ? ( (s * (v / 0.3)) ) : ( s ));
    #line 15
    return clamp( vec3( h, s, v), vec3( 0.0), vec3( 1.0));
}
#line 63
highp vec4 frag( in v2f i ) {
    #line 65
    highp float alpha = texture2D( _FgTex, i.uv).w;
    alpha = (1.0 - pow( (1.0 - alpha), _AlphaAdjust));
    highp mat3 mat = xll_transpose_mf3x3(mat3( _MatFgToBg1, _MatFgToBg2, _MatFgToBg3));
    #line 70
    highp vec2 bgSizeInv = vec2( (1.0 / _BgSize.x), (1.0 / _BgSize.y));
    highp vec2 bgUV1 = (_BgAnchor1 * bgSizeInv);
    highp vec2 bgUV2 = (_BgAnchor2 * bgSizeInv);
    highp vec2 bgUV3 = (_BgAnchor3 * bgSizeInv);
    #line 74
    highp vec2 bgUV4 = (_BgAnchor4 * bgSizeInv);
    highp vec2 bgUV = (vec3( i.uv, 1.0) * mat).xy;
    bgUV.y = (1.0 - bgUV.y);
    #line 78
    highp vec3 colBg = texture2D( _BgTex, bgUV).xyz;
    highp vec3 col1 = texture2D( _BgTex, bgUV1).xyz;
    highp vec3 col2 = texture2D( _BgTex, bgUV2).xyz;
    #line 82
    highp vec3 col3 = texture2D( _BgTex, bgUV3).xyz;
    highp vec3 col4 = texture2D( _BgTex, bgUV4).xyz;
    highp vec3 hsv1 = rgb2hsv( col1);
    #line 86
    highp vec3 hsv2 = rgb2hsv( col2);
    highp vec3 hsv3 = rgb2hsv( col3);
    highp vec3 hsv4 = rgb2hsv( col4);
    #line 90
    bool check1 = checkHSV( hsv1, hsv2, hsv3, hsv4);
    bool check2 = checkHSV( hsv2, hsv3, hsv4, hsv1);
    bool check3 = checkHSV( hsv3, hsv4, hsv1, hsv2);
    bool check4 = checkHSV( hsv4, hsv1, hsv2, hsv3);
    #line 95
    highp vec4 col = vec4( 0.0);
    col += (( check1 ) ? ( vec4( col1, 1.0) ) : ( 0.0 ));
    col += (( check2 ) ? ( vec4( col2, 1.0) ) : ( 0.0 ));
    col += (( check3 ) ? ( vec4( col3, 1.0) ) : ( 0.0 ));
    #line 99
    col += (( check4 ) ? ( vec4( col4, 1.0) ) : ( 0.0 ));
    highp vec4 colFinal = (( (col.w > 0.0) ) ? ( vec4( (col.xyz / col.w), alpha) ) : ( vec4( colBg, 1.0) ));
    #line 132
    return colFinal;
}
varying highp vec2 xlv_TEXCOORD0;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(97,25): error: second and third operands of ?: operator must have matching types
(97,2): error: operands to arithmetic operators must be numeric
(98,25): error: second and third operands of ?: operator must have matching types
(98,2): error: operands to arithmetic operators must be numeric
(99,25): error: second and third operands of ?: operator must have matching types
(99,2): error: operands to arithmetic operators must be numeric
(100,25): error: second and third operands of ?: operator must have matching types
(100,2): error: operands to arithmetic operators must be numeric
*/
]===],
	},
}

end
