function DefineParams()
	Properties = 
	{
		
_FgTex = { "Fg Tex", TEXTURE2D, "white" },
_FgRatio = { "Fg Ratio", VEC2, "1, 1" },
_FgPivot = { "Fg Pivot", VEC2, "0.5, 0.5" },
_Opacity = { "Opacity", FLOATRANGE, "1, 1, 0" },

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},

_BlendMode = {"Blend Mode", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_DARKEN,BLEND_MULTIPLY,BLEND_COLORBURN,BLEND_LINEARBURN,BLEND_DARKER_COLOR,BLEND_LIGHTEN,BLEND_SCREEN,BLEND_COLORDODGE,BLEND_LINEARDODGE,BLEND_LIGHTER_COLOR,BLEND_OVERLAY,BLEND_SOFTLIGHT,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_LINEARLIGHT,BLEND_PINLIGHT,BLEND_HARDMIX,BLEND_DIFFERENCE,BLEND_EXCLUSION,BLEND_SUBTRACT,BLEND_DIVIDE,BLEND_HUE,BLEND_SATURATION,BLEND_COLOR,BLEND_LUMINOSITY,BLEND_BLEND,)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "FaceParse"
RenderQueue = "Transparent+1"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 MColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_2 = tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = MColor_2.xyz;
  tmpvar_4.w = (MColor_2.w * _Opacity);
  tmpvar_1 = tmpvar_4;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DARKEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = min (MColor_3.xyz, RColor_2.xyz);
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 MColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = (MColor_2.w * _Opacity);
  highp vec4 tmpvar_5;
  tmpvar_5.xyz = (1.0 - (tmpvar_4 * (1.0 - MColor_2.xyz)));
  tmpvar_5.w = tmpvar_4;
  tmpvar_1 = tmpvar_5;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = (RColor_2.xyz - ((
    (1.0 - MColor_3.xyz)
   * 
    (1.0 - RColor_2.xyz)
  ) / (MColor_3.xyz + 0.0001)));
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = ((MColor_3.xyz + RColor_2.xyz) - 1.0);
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DARKER_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = RColor_2.xyz;
  highp vec4 tmpvar_9;
  tmpvar_9.xy = tmpvar_5.zy;
  tmpvar_9.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_10;
  tmpvar_10.xy = tmpvar_5.yz;
  tmpvar_10.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_11;
  tmpvar_11 = mix (tmpvar_9, tmpvar_10, vec4(float((MColor_3.y >= MColor_3.z))));
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = tmpvar_11.xyw;
  tmpvar_12.w = tmpvar_5.x;
  highp vec4 tmpvar_13;
  tmpvar_13.x = tmpvar_5.x;
  tmpvar_13.yzw = tmpvar_11.yzx;
  highp vec4 tmpvar_14;
  tmpvar_14 = mix (tmpvar_12, tmpvar_13, vec4(float((MColor_3.x >= tmpvar_11.x))));
  highp float tmpvar_15;
  tmpvar_15 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
  highp float tmpvar_16;
  tmpvar_16 = tmpvar_14.x;
  highp float tmpvar_17;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_17 = 0.0;
  } else {
    tmpvar_17 = abs((tmpvar_14.z + (
      (tmpvar_14.w - tmpvar_14.y)
     / 
      (6.0 * tmpvar_15)
    )));
  };
  highp float tmpvar_18;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_18 = 0.0;
  } else {
    tmpvar_18 = (tmpvar_15 / tmpvar_14.x);
  };
  highp float tmpvar_19;
  if ((tmpvar_14.x <= 0.3)) {
    tmpvar_19 = (tmpvar_18 * (tmpvar_14.x / 0.3));
  } else {
    tmpvar_19 = tmpvar_18;
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_17;
  tmpvar_20.y = tmpvar_19;
  tmpvar_20.z = tmpvar_16;
  highp vec3 tmpvar_21;
  tmpvar_21 = clamp (tmpvar_20, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_21.z - ((tmpvar_21.z * tmpvar_21.y) * 0.5));
  highp vec4 tmpvar_23;
  tmpvar_23.xy = tmpvar_8.zy;
  tmpvar_23.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_24;
  tmpvar_24.xy = tmpvar_8.yz;
  tmpvar_24.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_25;
  tmpvar_25 = mix (tmpvar_23, tmpvar_24, vec4(float((RColor_2.y >= RColor_2.z))));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = tmpvar_25.xyw;
  tmpvar_26.w = tmpvar_8.x;
  highp vec4 tmpvar_27;
  tmpvar_27.x = tmpvar_8.x;
  tmpvar_27.yzw = tmpvar_25.yzx;
  highp vec4 tmpvar_28;
  tmpvar_28 = mix (tmpvar_26, tmpvar_27, vec4(float((RColor_2.x >= tmpvar_25.x))));
  highp float tmpvar_29;
  tmpvar_29 = (tmpvar_28.x - min (tmpvar_28.w, tmpvar_28.y));
  highp float tmpvar_30;
  tmpvar_30 = tmpvar_28.x;
  highp float tmpvar_31;
  if ((tmpvar_29 <= 1e-10)) {
    tmpvar_31 = 0.0;
  } else {
    tmpvar_31 = abs((tmpvar_28.z + (
      (tmpvar_28.w - tmpvar_28.y)
     / 
      (6.0 * tmpvar_29)
    )));
  };
  highp float tmpvar_32;
  if ((tmpvar_29 <= 1e-10)) {
    tmpvar_32 = 0.0;
  } else {
    tmpvar_32 = (tmpvar_29 / tmpvar_28.x);
  };
  highp float tmpvar_33;
  if ((tmpvar_28.x <= 0.3)) {
    tmpvar_33 = (tmpvar_32 * (tmpvar_28.x / 0.3));
  } else {
    tmpvar_33 = tmpvar_32;
  };
  highp vec3 tmpvar_34;
  tmpvar_34.x = tmpvar_31;
  tmpvar_34.y = tmpvar_33;
  tmpvar_34.z = tmpvar_30;
  highp vec3 tmpvar_35;
  tmpvar_35 = clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_36;
  tmpvar_36 = float(((tmpvar_35.z - 
    ((tmpvar_35.z * tmpvar_35.y) * 0.5)
  ) >= tmpvar_22));
  highp vec4 tmpvar_37;
  tmpvar_37.xyz = ((MColor_3.xyz * tmpvar_36) + (RColor_2.xyz * (1.0 - tmpvar_36)));
  tmpvar_37.w = tmpvar_6;
  tmpvar_1 = tmpvar_37;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LIGHTEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = max (MColor_3.xyz, RColor_2.xyz);
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 MColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = (MColor_2.w * _Opacity);
  highp vec4 tmpvar_5;
  tmpvar_5.xyz = (MColor_2.xyz * tmpvar_4);
  tmpvar_5.w = tmpvar_4;
  tmpvar_1 = tmpvar_5;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = (RColor_2.xyz + ((MColor_3.xyz * RColor_2.xyz) / (
    (1.0 - MColor_3.xyz)
   + 0.0001)));
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 MColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_2 = tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = MColor_2.xyz;
  tmpvar_4.w = (MColor_2.w * _Opacity);
  tmpvar_1 = tmpvar_4;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LIGHTER_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = RColor_2.xyz;
  highp vec4 tmpvar_9;
  tmpvar_9.xy = tmpvar_5.zy;
  tmpvar_9.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_10;
  tmpvar_10.xy = tmpvar_5.yz;
  tmpvar_10.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_11;
  tmpvar_11 = mix (tmpvar_9, tmpvar_10, vec4(float((MColor_3.y >= MColor_3.z))));
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = tmpvar_11.xyw;
  tmpvar_12.w = tmpvar_5.x;
  highp vec4 tmpvar_13;
  tmpvar_13.x = tmpvar_5.x;
  tmpvar_13.yzw = tmpvar_11.yzx;
  highp vec4 tmpvar_14;
  tmpvar_14 = mix (tmpvar_12, tmpvar_13, vec4(float((MColor_3.x >= tmpvar_11.x))));
  highp float tmpvar_15;
  tmpvar_15 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
  highp float tmpvar_16;
  tmpvar_16 = tmpvar_14.x;
  highp float tmpvar_17;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_17 = 0.0;
  } else {
    tmpvar_17 = abs((tmpvar_14.z + (
      (tmpvar_14.w - tmpvar_14.y)
     / 
      (6.0 * tmpvar_15)
    )));
  };
  highp float tmpvar_18;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_18 = 0.0;
  } else {
    tmpvar_18 = (tmpvar_15 / tmpvar_14.x);
  };
  highp float tmpvar_19;
  if ((tmpvar_14.x <= 0.3)) {
    tmpvar_19 = (tmpvar_18 * (tmpvar_14.x / 0.3));
  } else {
    tmpvar_19 = tmpvar_18;
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_17;
  tmpvar_20.y = tmpvar_19;
  tmpvar_20.z = tmpvar_16;
  highp vec3 tmpvar_21;
  tmpvar_21 = clamp (tmpvar_20, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_21.z - ((tmpvar_21.z * tmpvar_21.y) * 0.5));
  highp vec4 tmpvar_23;
  tmpvar_23.xy = tmpvar_8.zy;
  tmpvar_23.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_24;
  tmpvar_24.xy = tmpvar_8.yz;
  tmpvar_24.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_25;
  tmpvar_25 = mix (tmpvar_23, tmpvar_24, vec4(float((RColor_2.y >= RColor_2.z))));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = tmpvar_25.xyw;
  tmpvar_26.w = tmpvar_8.x;
  highp vec4 tmpvar_27;
  tmpvar_27.x = tmpvar_8.x;
  tmpvar_27.yzw = tmpvar_25.yzx;
  highp vec4 tmpvar_28;
  tmpvar_28 = mix (tmpvar_26, tmpvar_27, vec4(float((RColor_2.x >= tmpvar_25.x))));
  highp float tmpvar_29;
  tmpvar_29 = (tmpvar_28.x - min (tmpvar_28.w, tmpvar_28.y));
  highp float tmpvar_30;
  tmpvar_30 = tmpvar_28.x;
  highp float tmpvar_31;
  if ((tmpvar_29 <= 1e-10)) {
    tmpvar_31 = 0.0;
  } else {
    tmpvar_31 = abs((tmpvar_28.z + (
      (tmpvar_28.w - tmpvar_28.y)
     / 
      (6.0 * tmpvar_29)
    )));
  };
  highp float tmpvar_32;
  if ((tmpvar_29 <= 1e-10)) {
    tmpvar_32 = 0.0;
  } else {
    tmpvar_32 = (tmpvar_29 / tmpvar_28.x);
  };
  highp float tmpvar_33;
  if ((tmpvar_28.x <= 0.3)) {
    tmpvar_33 = (tmpvar_32 * (tmpvar_28.x / 0.3));
  } else {
    tmpvar_33 = tmpvar_32;
  };
  highp vec3 tmpvar_34;
  tmpvar_34.x = tmpvar_31;
  tmpvar_34.y = tmpvar_33;
  tmpvar_34.z = tmpvar_30;
  highp vec3 tmpvar_35;
  tmpvar_35 = clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_36;
  tmpvar_36 = float(((tmpvar_35.z - 
    ((tmpvar_35.z * tmpvar_35.y) * 0.5)
  ) >= tmpvar_22));
  highp vec4 tmpvar_37;
  tmpvar_37.xyz = ((MColor_3.xyz * (1.0 - tmpvar_36)) + (RColor_2.xyz * tmpvar_36));
  tmpvar_37.w = tmpvar_6;
  tmpvar_1 = tmpvar_37;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = vec3(greaterThanEqual (vec3(0.5, 0.5, 0.5), RColor_2.xyz));
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = (((2.0 * MColor_3.xyz) * (RColor_2.xyz * tmpvar_6)) + ((1.0 - 
    ((2.0 * (1.0 - MColor_3.xyz)) * (1.0 - RColor_2.xyz))
  ) * (1.0 - tmpvar_6)));
  tmpvar_7.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = vec3(greaterThanEqual (vec3(0.5, 0.5, 0.5), MColor_3.xyz));
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = (((
    ((2.0 * MColor_3.xyz) * RColor_2.xyz)
   + 
    ((RColor_2.xyz * RColor_2.xyz) * (1.0 - (2.0 * MColor_3.xyz)))
  ) * tmpvar_6) + ((
    ((2.0 * (1.0 - MColor_3.xyz)) * RColor_2.xyz)
   + 
    (sqrt(RColor_2.xyz) * ((2.0 * MColor_3.xyz) - 1.0))
  ) * (1.0 - tmpvar_6)));
  tmpvar_7.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = vec3(greaterThanEqual (vec3(0.5, 0.5, 0.5), MColor_3.xyz));
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = (((2.0 * MColor_3.xyz) * (RColor_2.xyz * tmpvar_6)) + ((1.0 - 
    ((2.0 * (1.0 - MColor_3.xyz)) * (1.0 - RColor_2.xyz))
  ) * (1.0 - tmpvar_6)));
  tmpvar_7.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = vec3(greaterThanEqual (vec3(0.5, 0.5, 0.5), MColor_3.xyz));
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = (((RColor_2.xyz - 
    (((1.0 - RColor_2.xyz) * (1.0 - (2.0 * MColor_3.xyz))) / ((2.0 * MColor_3.xyz) + 0.0001))
  ) * tmpvar_6) + ((RColor_2.xyz + 
    ((RColor_2.xyz * ((2.0 * MColor_3.xyz) - 1.0)) / ((2.0 * (1.0 - MColor_3.xyz)) + 0.0001))
  ) * (1.0 - tmpvar_6)));
  tmpvar_7.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = ((RColor_2.xyz + (2.0 * MColor_3.xyz)) - 1.0);
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = vec3(greaterThanEqual (vec3(0.5, 0.5, 0.5), MColor_3.xyz));
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = ((min (RColor_2.xyz, 
    (2.0 * MColor_3.xyz)
  ) * tmpvar_6) + (min (RColor_2.xyz, 
    ((2.0 * MColor_3.xyz) - 1.0)
  ) * (1.0 - tmpvar_6)));
  tmpvar_7.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = vec3(greaterThanEqual ((MColor_3.xyz + RColor_2.xyz), vec3(1.0, 1.0, 1.0)));
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DIFFERENCE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = abs((RColor_2.xyz - MColor_3.xyz));
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = ((MColor_3.xyz + RColor_2.xyz) - ((2.0 * MColor_3.xyz) * RColor_2.xyz));
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SUBTRACT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = max ((RColor_2.xyz - MColor_3.xyz), vec3(0.0, 0.0, 0.0));
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DIVIDE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = min ((RColor_2.xyz / (MColor_3.xyz + 0.0001)), vec3(1.0, 1.0, 1.0));
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = RColor_2.xyz;
  highp vec4 tmpvar_9;
  tmpvar_9.xy = tmpvar_5.zy;
  tmpvar_9.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_10;
  tmpvar_10.xy = tmpvar_5.yz;
  tmpvar_10.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_11;
  tmpvar_11 = mix (tmpvar_9, tmpvar_10, vec4(float((MColor_3.y >= MColor_3.z))));
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = tmpvar_11.xyw;
  tmpvar_12.w = tmpvar_5.x;
  highp vec4 tmpvar_13;
  tmpvar_13.x = tmpvar_5.x;
  tmpvar_13.yzw = tmpvar_11.yzx;
  highp vec4 tmpvar_14;
  tmpvar_14 = mix (tmpvar_12, tmpvar_13, vec4(float((MColor_3.x >= tmpvar_11.x))));
  highp float tmpvar_15;
  tmpvar_15 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
  highp float tmpvar_16;
  tmpvar_16 = tmpvar_14.x;
  highp float tmpvar_17;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_17 = 0.0;
  } else {
    tmpvar_17 = abs((tmpvar_14.z + (
      (tmpvar_14.w - tmpvar_14.y)
     / 
      (6.0 * tmpvar_15)
    )));
  };
  highp float tmpvar_18;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_18 = 0.0;
  } else {
    tmpvar_18 = (tmpvar_15 / tmpvar_14.x);
  };
  highp float tmpvar_19;
  if ((tmpvar_14.x <= 0.3)) {
    tmpvar_19 = (tmpvar_18 * (tmpvar_14.x / 0.3));
  } else {
    tmpvar_19 = tmpvar_18;
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_17;
  tmpvar_20.y = tmpvar_19;
  tmpvar_20.z = tmpvar_16;
  highp vec3 tmpvar_21;
  tmpvar_21 = clamp (tmpvar_20, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = tmpvar_8.zy;
  tmpvar_22.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_23;
  tmpvar_23.xy = tmpvar_8.yz;
  tmpvar_23.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_24;
  tmpvar_24 = mix (tmpvar_22, tmpvar_23, vec4(float((RColor_2.y >= RColor_2.z))));
  highp vec4 tmpvar_25;
  tmpvar_25.xyz = tmpvar_24.xyw;
  tmpvar_25.w = tmpvar_8.x;
  highp vec4 tmpvar_26;
  tmpvar_26.x = tmpvar_8.x;
  tmpvar_26.yzw = tmpvar_24.yzx;
  highp vec4 tmpvar_27;
  tmpvar_27 = mix (tmpvar_25, tmpvar_26, vec4(float((RColor_2.x >= tmpvar_24.x))));
  highp float tmpvar_28;
  tmpvar_28 = (tmpvar_27.x - min (tmpvar_27.w, tmpvar_27.y));
  highp float tmpvar_29;
  tmpvar_29 = tmpvar_27.x;
  highp float tmpvar_30;
  if ((tmpvar_28 <= 1e-10)) {
    tmpvar_30 = 0.0;
  } else {
    tmpvar_30 = abs((tmpvar_27.z + (
      (tmpvar_27.w - tmpvar_27.y)
     / 
      (6.0 * tmpvar_28)
    )));
  };
  highp float tmpvar_31;
  if ((tmpvar_28 <= 1e-10)) {
    tmpvar_31 = 0.0;
  } else {
    tmpvar_31 = (tmpvar_28 / tmpvar_27.x);
  };
  highp float tmpvar_32;
  if ((tmpvar_27.x <= 0.3)) {
    tmpvar_32 = (tmpvar_31 * (tmpvar_27.x / 0.3));
  } else {
    tmpvar_32 = tmpvar_31;
  };
  highp vec3 tmpvar_33;
  tmpvar_33.x = tmpvar_30;
  tmpvar_33.y = tmpvar_32;
  tmpvar_33.z = tmpvar_29;
  highp vec3 tmpvar_34;
  tmpvar_34 = clamp (tmpvar_33, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_35;
  tmpvar_35 = (tmpvar_34.z - ((tmpvar_34.z * tmpvar_34.y) * 0.5));
  highp float tmpvar_36;
  tmpvar_36 = min (tmpvar_35, (1.0 - tmpvar_35));
  highp float tmpvar_37;
  if ((tmpvar_36 <= 1e-10)) {
    tmpvar_37 = 0.0;
  } else {
    tmpvar_37 = ((tmpvar_34.z - tmpvar_35) / tmpvar_36);
  };
  highp float tmpvar_38;
  tmpvar_38 = (tmpvar_35 + (tmpvar_37 * min (tmpvar_35, 
    (1.0 - tmpvar_35)
  )));
  highp float tmpvar_39;
  if ((tmpvar_38 <= 1e-10)) {
    tmpvar_39 = 0.0;
  } else {
    tmpvar_39 = ((2.0 * (tmpvar_38 - tmpvar_35)) / tmpvar_38);
  };
  highp vec4 tmpvar_40;
  tmpvar_40.xyz = clamp ((tmpvar_38 * mix (vec3(1.0, 1.0, 1.0), 
    clamp ((abs((
      (fract((tmpvar_21.xxx + vec3(1.0, 0.6666667, 0.3333333))) * 6.0)
     - vec3(3.0, 3.0, 3.0))) - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
  , vec3(tmpvar_39))), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  tmpvar_40.w = tmpvar_6;
  tmpvar_1 = tmpvar_40;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = RColor_2.xyz;
  highp vec4 tmpvar_9;
  tmpvar_9.xy = tmpvar_5.zy;
  tmpvar_9.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_10;
  tmpvar_10.xy = tmpvar_5.yz;
  tmpvar_10.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_11;
  tmpvar_11 = mix (tmpvar_9, tmpvar_10, vec4(float((MColor_3.y >= MColor_3.z))));
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = tmpvar_11.xyw;
  tmpvar_12.w = tmpvar_5.x;
  highp vec4 tmpvar_13;
  tmpvar_13.x = tmpvar_5.x;
  tmpvar_13.yzw = tmpvar_11.yzx;
  highp vec4 tmpvar_14;
  tmpvar_14 = mix (tmpvar_12, tmpvar_13, vec4(float((MColor_3.x >= tmpvar_11.x))));
  highp float tmpvar_15;
  tmpvar_15 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
  highp float tmpvar_16;
  tmpvar_16 = tmpvar_14.x;
  highp float tmpvar_17;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_17 = 0.0;
  } else {
    tmpvar_17 = abs((tmpvar_14.z + (
      (tmpvar_14.w - tmpvar_14.y)
     / 
      (6.0 * tmpvar_15)
    )));
  };
  highp float tmpvar_18;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_18 = 0.0;
  } else {
    tmpvar_18 = (tmpvar_15 / tmpvar_14.x);
  };
  highp float tmpvar_19;
  if ((tmpvar_14.x <= 0.3)) {
    tmpvar_19 = (tmpvar_18 * (tmpvar_14.x / 0.3));
  } else {
    tmpvar_19 = tmpvar_18;
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_17;
  tmpvar_20.y = tmpvar_19;
  tmpvar_20.z = tmpvar_16;
  highp vec3 tmpvar_21;
  tmpvar_21 = clamp (tmpvar_20, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_21.z - ((tmpvar_21.z * tmpvar_21.y) * 0.5));
  highp float tmpvar_23;
  tmpvar_23 = min (tmpvar_22, (1.0 - tmpvar_22));
  highp float tmpvar_24;
  if ((tmpvar_23 <= 1e-10)) {
    tmpvar_24 = 0.0;
  } else {
    tmpvar_24 = ((tmpvar_21.z - tmpvar_22) / tmpvar_23);
  };
  highp vec4 tmpvar_25;
  tmpvar_25.xy = tmpvar_8.zy;
  tmpvar_25.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_26;
  tmpvar_26.xy = tmpvar_8.yz;
  tmpvar_26.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_27;
  tmpvar_27 = mix (tmpvar_25, tmpvar_26, vec4(float((RColor_2.y >= RColor_2.z))));
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27.xyw;
  tmpvar_28.w = tmpvar_8.x;
  highp vec4 tmpvar_29;
  tmpvar_29.x = tmpvar_8.x;
  tmpvar_29.yzw = tmpvar_27.yzx;
  highp vec4 tmpvar_30;
  tmpvar_30 = mix (tmpvar_28, tmpvar_29, vec4(float((RColor_2.x >= tmpvar_27.x))));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30.x - min (tmpvar_30.w, tmpvar_30.y));
  highp float tmpvar_32;
  tmpvar_32 = tmpvar_30.x;
  highp float tmpvar_33;
  if ((tmpvar_31 <= 1e-10)) {
    tmpvar_33 = 0.0;
  } else {
    tmpvar_33 = abs((tmpvar_30.z + (
      (tmpvar_30.w - tmpvar_30.y)
     / 
      (6.0 * tmpvar_31)
    )));
  };
  highp float tmpvar_34;
  if ((tmpvar_31 <= 1e-10)) {
    tmpvar_34 = 0.0;
  } else {
    tmpvar_34 = (tmpvar_31 / tmpvar_30.x);
  };
  highp float tmpvar_35;
  if ((tmpvar_30.x <= 0.3)) {
    tmpvar_35 = (tmpvar_34 * (tmpvar_30.x / 0.3));
  } else {
    tmpvar_35 = tmpvar_34;
  };
  highp vec3 tmpvar_36;
  tmpvar_36.x = tmpvar_33;
  tmpvar_36.y = tmpvar_35;
  tmpvar_36.z = tmpvar_32;
  highp vec3 tmpvar_37;
  tmpvar_37 = clamp (tmpvar_36, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_38;
  tmpvar_38 = (tmpvar_37.z - ((tmpvar_37.z * tmpvar_37.y) * 0.5));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_38 + (tmpvar_24 * min (tmpvar_38, 
    (1.0 - tmpvar_38)
  )));
  highp float tmpvar_40;
  if ((tmpvar_39 <= 1e-10)) {
    tmpvar_40 = 0.0;
  } else {
    tmpvar_40 = ((2.0 * (tmpvar_39 - tmpvar_38)) / tmpvar_39);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.xyz = clamp ((tmpvar_39 * mix (vec3(1.0, 1.0, 1.0), 
    clamp ((abs((
      (fract((tmpvar_37.xxx + vec3(1.0, 0.6666667, 0.3333333))) * 6.0)
     - vec3(3.0, 3.0, 3.0))) - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
  , vec3(tmpvar_40))), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  tmpvar_41.w = tmpvar_6;
  tmpvar_1 = tmpvar_41;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = RColor_2.xyz;
  highp vec4 tmpvar_9;
  tmpvar_9.xy = tmpvar_5.zy;
  tmpvar_9.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_10;
  tmpvar_10.xy = tmpvar_5.yz;
  tmpvar_10.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_11;
  tmpvar_11 = mix (tmpvar_9, tmpvar_10, vec4(float((MColor_3.y >= MColor_3.z))));
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = tmpvar_11.xyw;
  tmpvar_12.w = tmpvar_5.x;
  highp vec4 tmpvar_13;
  tmpvar_13.x = tmpvar_5.x;
  tmpvar_13.yzw = tmpvar_11.yzx;
  highp vec4 tmpvar_14;
  tmpvar_14 = mix (tmpvar_12, tmpvar_13, vec4(float((MColor_3.x >= tmpvar_11.x))));
  highp float tmpvar_15;
  tmpvar_15 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
  highp float tmpvar_16;
  tmpvar_16 = tmpvar_14.x;
  highp float tmpvar_17;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_17 = 0.0;
  } else {
    tmpvar_17 = abs((tmpvar_14.z + (
      (tmpvar_14.w - tmpvar_14.y)
     / 
      (6.0 * tmpvar_15)
    )));
  };
  highp float tmpvar_18;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_18 = 0.0;
  } else {
    tmpvar_18 = (tmpvar_15 / tmpvar_14.x);
  };
  highp float tmpvar_19;
  if ((tmpvar_14.x <= 0.3)) {
    tmpvar_19 = (tmpvar_18 * (tmpvar_14.x / 0.3));
  } else {
    tmpvar_19 = tmpvar_18;
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_17;
  tmpvar_20.y = tmpvar_19;
  tmpvar_20.z = tmpvar_16;
  highp vec3 tmpvar_21;
  tmpvar_21 = clamp (tmpvar_20, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_21.z - ((tmpvar_21.z * tmpvar_21.y) * 0.5));
  highp float tmpvar_23;
  tmpvar_23 = min (tmpvar_22, (1.0 - tmpvar_22));
  highp float tmpvar_24;
  if ((tmpvar_23 <= 1e-10)) {
    tmpvar_24 = 0.0;
  } else {
    tmpvar_24 = ((tmpvar_21.z - tmpvar_22) / tmpvar_23);
  };
  highp vec4 tmpvar_25;
  tmpvar_25.xy = tmpvar_8.zy;
  tmpvar_25.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_26;
  tmpvar_26.xy = tmpvar_8.yz;
  tmpvar_26.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_27;
  tmpvar_27 = mix (tmpvar_25, tmpvar_26, vec4(float((RColor_2.y >= RColor_2.z))));
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27.xyw;
  tmpvar_28.w = tmpvar_8.x;
  highp vec4 tmpvar_29;
  tmpvar_29.x = tmpvar_8.x;
  tmpvar_29.yzw = tmpvar_27.yzx;
  highp vec4 tmpvar_30;
  tmpvar_30 = mix (tmpvar_28, tmpvar_29, vec4(float((RColor_2.x >= tmpvar_27.x))));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30.x - min (tmpvar_30.w, tmpvar_30.y));
  highp float tmpvar_32;
  tmpvar_32 = tmpvar_30.x;
  highp float tmpvar_33;
  if ((tmpvar_31 <= 1e-10)) {
    tmpvar_33 = 0.0;
  } else {
    tmpvar_33 = abs((tmpvar_30.z + (
      (tmpvar_30.w - tmpvar_30.y)
     / 
      (6.0 * tmpvar_31)
    )));
  };
  highp float tmpvar_34;
  if ((tmpvar_31 <= 1e-10)) {
    tmpvar_34 = 0.0;
  } else {
    tmpvar_34 = (tmpvar_31 / tmpvar_30.x);
  };
  highp float tmpvar_35;
  if ((tmpvar_30.x <= 0.3)) {
    tmpvar_35 = (tmpvar_34 * (tmpvar_30.x / 0.3));
  } else {
    tmpvar_35 = tmpvar_34;
  };
  highp vec3 tmpvar_36;
  tmpvar_36.x = tmpvar_33;
  tmpvar_36.y = tmpvar_35;
  tmpvar_36.z = tmpvar_32;
  highp vec3 tmpvar_37;
  tmpvar_37 = clamp (tmpvar_36, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_38;
  tmpvar_38 = (tmpvar_37.z - ((tmpvar_37.z * tmpvar_37.y) * 0.5));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_38 + (tmpvar_24 * min (tmpvar_38, 
    (1.0 - tmpvar_38)
  )));
  highp float tmpvar_40;
  if ((tmpvar_39 <= 1e-10)) {
    tmpvar_40 = 0.0;
  } else {
    tmpvar_40 = ((2.0 * (tmpvar_39 - tmpvar_38)) / tmpvar_39);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.xyz = clamp ((tmpvar_39 * mix (vec3(1.0, 1.0, 1.0), 
    clamp ((abs((
      (fract((tmpvar_21.xxx + vec3(1.0, 0.6666667, 0.3333333))) * 6.0)
     - vec3(3.0, 3.0, 3.0))) - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
  , vec3(tmpvar_40))), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  tmpvar_41.w = tmpvar_6;
  tmpvar_1 = tmpvar_41;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = RColor_2.xyz;
  highp vec4 tmpvar_9;
  tmpvar_9.xy = tmpvar_5.zy;
  tmpvar_9.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_10;
  tmpvar_10.xy = tmpvar_5.yz;
  tmpvar_10.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_11;
  tmpvar_11 = mix (tmpvar_9, tmpvar_10, vec4(float((MColor_3.y >= MColor_3.z))));
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = tmpvar_11.xyw;
  tmpvar_12.w = tmpvar_5.x;
  highp vec4 tmpvar_13;
  tmpvar_13.x = tmpvar_5.x;
  tmpvar_13.yzw = tmpvar_11.yzx;
  highp vec4 tmpvar_14;
  tmpvar_14 = mix (tmpvar_12, tmpvar_13, vec4(float((MColor_3.x >= tmpvar_11.x))));
  highp float tmpvar_15;
  tmpvar_15 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
  highp float tmpvar_16;
  tmpvar_16 = tmpvar_14.x;
  highp float tmpvar_17;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_17 = 0.0;
  } else {
    tmpvar_17 = abs((tmpvar_14.z + (
      (tmpvar_14.w - tmpvar_14.y)
     / 
      (6.0 * tmpvar_15)
    )));
  };
  highp float tmpvar_18;
  if ((tmpvar_15 <= 1e-10)) {
    tmpvar_18 = 0.0;
  } else {
    tmpvar_18 = (tmpvar_15 / tmpvar_14.x);
  };
  highp float tmpvar_19;
  if ((tmpvar_14.x <= 0.3)) {
    tmpvar_19 = (tmpvar_18 * (tmpvar_14.x / 0.3));
  } else {
    tmpvar_19 = tmpvar_18;
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_17;
  tmpvar_20.y = tmpvar_19;
  tmpvar_20.z = tmpvar_16;
  highp vec3 tmpvar_21;
  tmpvar_21 = clamp (tmpvar_20, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_21.z - ((tmpvar_21.z * tmpvar_21.y) * 0.5));
  highp vec4 tmpvar_23;
  tmpvar_23.xy = tmpvar_8.zy;
  tmpvar_23.zw = vec2(-1.0, 0.6666667);
  highp vec4 tmpvar_24;
  tmpvar_24.xy = tmpvar_8.yz;
  tmpvar_24.zw = vec2(0.0, -0.3333333);
  highp vec4 tmpvar_25;
  tmpvar_25 = mix (tmpvar_23, tmpvar_24, vec4(float((RColor_2.y >= RColor_2.z))));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = tmpvar_25.xyw;
  tmpvar_26.w = tmpvar_8.x;
  highp vec4 tmpvar_27;
  tmpvar_27.x = tmpvar_8.x;
  tmpvar_27.yzw = tmpvar_25.yzx;
  highp vec4 tmpvar_28;
  tmpvar_28 = mix (tmpvar_26, tmpvar_27, vec4(float((RColor_2.x >= tmpvar_25.x))));
  highp float tmpvar_29;
  tmpvar_29 = (tmpvar_28.x - min (tmpvar_28.w, tmpvar_28.y));
  highp float tmpvar_30;
  tmpvar_30 = tmpvar_28.x;
  highp float tmpvar_31;
  if ((tmpvar_29 <= 1e-10)) {
    tmpvar_31 = 0.0;
  } else {
    tmpvar_31 = abs((tmpvar_28.z + (
      (tmpvar_28.w - tmpvar_28.y)
     / 
      (6.0 * tmpvar_29)
    )));
  };
  highp float tmpvar_32;
  if ((tmpvar_29 <= 1e-10)) {
    tmpvar_32 = 0.0;
  } else {
    tmpvar_32 = (tmpvar_29 / tmpvar_28.x);
  };
  highp float tmpvar_33;
  if ((tmpvar_28.x <= 0.3)) {
    tmpvar_33 = (tmpvar_32 * (tmpvar_28.x / 0.3));
  } else {
    tmpvar_33 = tmpvar_32;
  };
  highp vec3 tmpvar_34;
  tmpvar_34.x = tmpvar_31;
  tmpvar_34.y = tmpvar_33;
  tmpvar_34.z = tmpvar_30;
  highp vec3 tmpvar_35;
  tmpvar_35 = clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_36;
  tmpvar_36 = (tmpvar_35.z - ((tmpvar_35.z * tmpvar_35.y) * 0.5));
  highp float tmpvar_37;
  tmpvar_37 = min (tmpvar_36, (1.0 - tmpvar_36));
  highp float tmpvar_38;
  if ((tmpvar_37 <= 1e-10)) {
    tmpvar_38 = 0.0;
  } else {
    tmpvar_38 = ((tmpvar_35.z - tmpvar_36) / tmpvar_37);
  };
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_22 + (tmpvar_38 * min (tmpvar_22, 
    (1.0 - tmpvar_22)
  )));
  highp float tmpvar_40;
  if ((tmpvar_39 <= 1e-10)) {
    tmpvar_40 = 0.0;
  } else {
    tmpvar_40 = ((2.0 * (tmpvar_39 - tmpvar_22)) / tmpvar_39);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.xyz = clamp ((tmpvar_39 * mix (vec3(1.0, 1.0, 1.0), 
    clamp ((abs((
      (fract((tmpvar_35.xxx + vec3(1.0, 0.6666667, 0.3333333))) * 6.0)
     - vec3(3.0, 3.0, 3.0))) - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
  , vec3(tmpvar_40))), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  tmpvar_41.w = tmpvar_6;
  tmpvar_1 = tmpvar_41;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgRatio",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FgTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _FgRatio;
uniform highp vec2 _FgPivot;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _FgPivot.x;
  tmpvar_1.y = (1.0 - _FgPivot.y);
  highp vec3 tmpvar_2;
  tmpvar_2.z = 0.0;
  tmpvar_2.xy = ((_glesVertex.xy - (
    (tmpvar_1 * 2.0)
   - 1.0)) * _FgRatio);
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_2;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (o_6.xy / tmpvar_3.w);
  gl_Position = (tmpvar_5 * tmpvar_3);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _FgTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_FgTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  RColor_2 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = ((MColor_3.xyz * dot (vec3(0.299, 0.587, 0.114), RColor_2.xyz)) * 1.68);
  tmpvar_6.w = (MColor_3.w * _Opacity);
  tmpvar_1 = tmpvar_6;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
