function DefineParams()
	Properties = 
	{
		
MainTex = { "main Color", TEXTURE2D, "white" },
NormalTexture = {"Normal Map", TEXTURE2D, "white"},
BkgTintTex = {"BkgTintTex Map", TEXTURE2D, "white"},
BkgMaterialTex = {"BkgMaterialTex Map", TEXTURE2D, "white"},
BkgNormalTex = {"BkgNormalTex Map", TEXTURE2D, "white"},
PatternAlbedoTex = {"PatternAlbedoTex Map", TEXTURE2D, "white"},
PatternNormalTex = {"PatternNormalTex Map", TEXTURE2D, "white"},
skybox = {"SkyBox", TEXTURECUBE, "black"},

FBkgNormalIntensity = { "FBkgNormalIntensity", FLOAT, "0.5" },
Metallic = { "Metallic", FLOAT, "0.5" },  
Smoothness = { "Smoothness", FLOAT, "0.5" },
EnvSpecIntensity = { "EnvSpecIntensity", FLOAT, "0.5" },
UseBkgNormal = { "UseBkgNormal", FLOAT, "1.0" },
UsePatternAlbedo = { "UsePatternAlbedo", FLOAT, "1.0" },
UsePatternNormal = { "UsePatternNormal", FLOAT, "1.0" },

BkgScaleOffset = { "BkgScaleOffset", VEC4, "1.0,1.0,0.0,1.0" },
Bkguv02 = { "Bkguv02", FLOAT, "1.0" },
Patternuv32 = { "Patternuv32", FLOAT, "1.0" },

SpecularColor = {"Specular Color", COLOR, "1.0,1.0,1.0,1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "StandardOpaque"
RenderQueue = "Opaque"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EnvSpecIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform lowp samplerCube skybox;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float EnvSpecIntensity;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp vec4 rgbm_4;
  highp float fresnel_5;
  highp vec3 bgTintColor_6;
  highp vec3 mainColor_7;
  highp vec3 blendedNormal_8;
  highp vec3 n2_9;
  highp vec3 n1_10;
  highp vec3 bkgNormal_11;
  highp vec3 mainNormal_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_14;
  tmpvar_14 = (CAMERA_WORLDPOSITION - tmpvar_13);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(tmpvar_14);
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_12 = tmpvar_16;
  highp vec3 tmpvar_17;
  tmpvar_17 = ((mainNormal_12 * 2.0) - 1.0);
  bkgNormal_11 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_18;
    highp float len_19;
    highp float tileCount_20;
    tileCount_20 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_21;
    tmpvar_21 = max (0.0, tileCount_20);
    tileCount_20 = tmpvar_21;
    highp float tmpvar_22;
    if ((tmpvar_21 > 0.0)) {
      tmpvar_22 = 1.0;
    } else {
      tmpvar_22 = 0.0;
    };
    len_19 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_14, tmpvar_14)
    )));
    highp float tmpvar_23;
    tmpvar_23 = clamp (len_19, 0.0, 1.0);
    len_19 = tmpvar_23;
    lowp vec2 tmpvar_24;
    tmpvar_24 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_18 = tmpvar_24;
    highp vec3 tmpvar_25;
    tmpvar_25.z = 0.0;
    tmpvar_25.xy = texNormal_18;
    bkgNormal_11.z = tmpvar_25.z;
    bkgNormal_11.xy = (((
      (texNormal_18 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_23, tmpvar_22));
    bkgNormal_11.z = sqrt((1.0 - min (
      dot (bkgNormal_11.xy, bkgNormal_11.xy)
    , 1.0)));
  };
  n1_10 = (tmpvar_17 + vec3(0.0, 0.0, 1.0));
  n2_9 = (bkgNormal_11 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_26;
  tmpvar_26 = (((n1_10 * 
    dot (n1_10, n2_9)
  ) / n1_10.z) - n2_9);
  blendedNormal_8 = tmpvar_26;
  if (!(bool(tmpvar_1))) {
    blendedNormal_8 = -(tmpvar_26);
  };
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(((
    (blendedNormal_8.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_8.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_28;
  tmpvar_28 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_29;
  tmpvar_29 = max (dot (tmpvar_27, tmpvar_15), 0.0);
  highp float tmpvar_30;
  tmpvar_30 = max (dot (tmpvar_27, normalize(
    (tmpvar_15 + tmpvar_28)
  )), 0.0);
  lowp vec3 tmpvar_31;
  tmpvar_31 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_7 = tmpvar_31;
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_6 = tmpvar_32;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_33;
    lowp vec4 tmpvar_34;
    tmpvar_34 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_33 = tmpvar_34;
    bgTintColor_6 = mix (bgTintColor_6, patternAlbedo_33.xyz, vec3((mainNormal_12.z * patternAlbedo_33.w)));
  };
  mainColor_7 = (mainColor_7 * bgTintColor_6);
  mainColor_7 = (mainColor_7 * mainColor_7);
  highp float tmpvar_35;
  tmpvar_35 = dot (tmpvar_27, tmpvar_28);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_37;
  tmpvar_37.x = Metallic;
  tmpvar_37.y = Smoothness;
  highp vec2 tmpvar_38;
  tmpvar_38 = (tmpvar_36.xy * tmpvar_37);
  highp vec2 tmpvar_39;
  tmpvar_39 = (vec2(1.0, 1.0) - tmpvar_38.yx);
  highp float tmpvar_40;
  tmpvar_40 = (1.0 - tmpvar_29);
  fresnel_5 = (tmpvar_40 * tmpvar_40);
  fresnel_5 = (fresnel_5 * fresnel_5);
  highp float tmpvar_41;
  tmpvar_41 = clamp (((tmpvar_38.x + EnvSpecIntensity) - 1.0), 0.0, 1.0);
  highp vec3 tmpvar_42;
  highp vec3 I_43;
  I_43 = -(tmpvar_15);
  tmpvar_42 = (I_43 - (2.0 * (
    dot (tmpvar_27, I_43)
   * tmpvar_27)));
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (skybox, tmpvar_42);
  rgbm_4 = tmpvar_44;
  rgbm_4.xyz = ((rgbm_4.xyz * rgbm_4.w) * 4.0);
  highp float tmpvar_45;
  tmpvar_45 = max ((tmpvar_39.x * tmpvar_39.x), 0.1);
  highp float tmpvar_46;
  tmpvar_46 = (tmpvar_45 * tmpvar_45);
  highp float tmpvar_47;
  tmpvar_47 = (((
    (tmpvar_30 * tmpvar_46)
   - tmpvar_30) * tmpvar_30) + 1.0);
  d_3 = ((0.3183099 * tmpvar_46) / ((tmpvar_47 * tmpvar_47) + 1e-7));
  highp float tmpvar_48;
  tmpvar_48 = min (d_3, 100.0);
  d_3 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (0.2209163, 1.0, tmpvar_38.x);
  finalCol_2.xyz = (((
    ((max (tmpvar_35, 0.0) * LIGHT_COLOR) + AMBIENT_COLOR)
   * mainColor_7) * tmpvar_39.y) + ((
    ((((tmpvar_48 * 
      (tmpvar_49 + ((1.0 - tmpvar_49) * fresnel_5))
    ) * max (
      ((tmpvar_35 + 1.0) * 0.5)
    , 0.0)) * SpecularColor.xyz) * LIGHT_COLOR)
   + 
    ((rgbm_4.xyz * mix (tmpvar_41, max (tmpvar_41, tmpvar_38.y), fresnel_5)) * EnvSpecIntensity)
  ) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_7, tmpvar_38.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EnvSpecIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform lowp samplerCube skybox;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float EnvSpecIntensity;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp vec4 rgbm_4;
  highp float fresnel_5;
  highp vec3 bgTintColor_6;
  highp vec3 mainColor_7;
  highp vec3 blendedNormal_8;
  highp vec3 n2_9;
  highp vec3 n1_10;
  highp vec3 bkgNormal_11;
  highp vec3 mainNormal_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_14;
  tmpvar_14 = (CAMERA_WORLDPOSITION - tmpvar_13);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(tmpvar_14);
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_12 = tmpvar_16;
  highp vec3 tmpvar_17;
  tmpvar_17 = ((mainNormal_12 * 2.0) - 1.0);
  bkgNormal_11 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_18;
    highp float len_19;
    highp float tileCount_20;
    tileCount_20 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_21;
    tmpvar_21 = max (0.0, tileCount_20);
    tileCount_20 = tmpvar_21;
    highp float tmpvar_22;
    if ((tmpvar_21 > 0.0)) {
      tmpvar_22 = 1.0;
    } else {
      tmpvar_22 = 0.0;
    };
    len_19 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_14, tmpvar_14)
    )));
    highp float tmpvar_23;
    tmpvar_23 = clamp (len_19, 0.0, 1.0);
    len_19 = tmpvar_23;
    lowp vec2 tmpvar_24;
    tmpvar_24 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_18 = tmpvar_24;
    highp vec3 tmpvar_25;
    tmpvar_25.z = 0.0;
    tmpvar_25.xy = texNormal_18;
    bkgNormal_11.z = tmpvar_25.z;
    bkgNormal_11.xy = (((
      (texNormal_18 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_23, tmpvar_22));
    bkgNormal_11.z = sqrt((1.0 - min (
      dot (bkgNormal_11.xy, bkgNormal_11.xy)
    , 1.0)));
  };
  n1_10 = (tmpvar_17 + vec3(0.0, 0.0, 1.0));
  n2_9 = (bkgNormal_11 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_26;
  tmpvar_26 = (((n1_10 * 
    dot (n1_10, n2_9)
  ) / n1_10.z) - n2_9);
  blendedNormal_8 = tmpvar_26;
  if (!(bool(tmpvar_1))) {
    blendedNormal_8 = -(tmpvar_26);
  };
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(((
    (blendedNormal_8.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_8.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_28;
  tmpvar_28 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_29;
  tmpvar_29 = max (dot (tmpvar_27, tmpvar_15), 0.0);
  highp float tmpvar_30;
  tmpvar_30 = max (dot (tmpvar_27, normalize(
    (tmpvar_15 + tmpvar_28)
  )), 0.0);
  lowp vec3 tmpvar_31;
  tmpvar_31 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_7 = tmpvar_31;
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_6 = tmpvar_32;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_33;
    lowp vec4 tmpvar_34;
    tmpvar_34 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_33 = tmpvar_34;
    bgTintColor_6 = mix (bgTintColor_6, patternAlbedo_33.xyz, vec3((mainNormal_12.z * patternAlbedo_33.w)));
  };
  mainColor_7 = (mainColor_7 * bgTintColor_6);
  mainColor_7 = (mainColor_7 * mainColor_7);
  highp float tmpvar_35;
  tmpvar_35 = dot (tmpvar_27, tmpvar_28);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_37;
  tmpvar_37.x = Metallic;
  tmpvar_37.y = Smoothness;
  highp vec2 tmpvar_38;
  tmpvar_38 = (tmpvar_36.xy * tmpvar_37);
  highp vec2 tmpvar_39;
  tmpvar_39 = (vec2(1.0, 1.0) - tmpvar_38.yx);
  highp float tmpvar_40;
  tmpvar_40 = (1.0 - tmpvar_29);
  fresnel_5 = (tmpvar_40 * tmpvar_40);
  fresnel_5 = (fresnel_5 * fresnel_5);
  highp float tmpvar_41;
  tmpvar_41 = clamp (((tmpvar_38.x + EnvSpecIntensity) - 1.0), 0.0, 1.0);
  highp vec3 tmpvar_42;
  highp vec3 I_43;
  I_43 = -(tmpvar_15);
  tmpvar_42 = (I_43 - (2.0 * (
    dot (tmpvar_27, I_43)
   * tmpvar_27)));
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (skybox, tmpvar_42);
  rgbm_4 = tmpvar_44;
  rgbm_4.xyz = ((rgbm_4.xyz * rgbm_4.w) * 4.0);
  highp float tmpvar_45;
  tmpvar_45 = max ((tmpvar_39.x * tmpvar_39.x), 0.1);
  highp float tmpvar_46;
  tmpvar_46 = (tmpvar_45 * tmpvar_45);
  highp float tmpvar_47;
  tmpvar_47 = (((
    (tmpvar_30 * tmpvar_46)
   - tmpvar_30) * tmpvar_30) + 1.0);
  d_3 = ((0.3183099 * tmpvar_46) / ((tmpvar_47 * tmpvar_47) + 1e-7));
  highp float tmpvar_48;
  tmpvar_48 = min (d_3, 100.0);
  d_3 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (0.2209163, 1.0, tmpvar_38.x);
  finalCol_2.xyz = (((
    ((max (tmpvar_35, 0.0) * LIGHT_COLOR) + AMBIENT_COLOR)
   * mainColor_7) * tmpvar_39.y) + ((
    ((((tmpvar_48 * 
      (tmpvar_49 + ((1.0 - tmpvar_49) * fresnel_5))
    ) * max (
      ((tmpvar_35 + 1.0) * 0.5)
    , 0.0)) * SpecularColor.xyz) * LIGHT_COLOR)
   + 
    ((rgbm_4.xyz * mix (tmpvar_41, max (tmpvar_41, tmpvar_38.y), fresnel_5)) * EnvSpecIntensity)
  ) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_7, tmpvar_38.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EnvSpecIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform lowp samplerCube skybox;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float EnvSpecIntensity;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp vec4 rgbm_4;
  highp float fresnel_5;
  highp vec3 bgTintColor_6;
  highp vec3 mainColor_7;
  highp vec3 blendedNormal_8;
  highp vec3 n2_9;
  highp vec3 n1_10;
  highp vec3 bkgNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_15;
    highp vec2 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 computedWeight_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_20.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_20.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    computedWeight_21 = (computedArea_22 * 0.44444);
    highp vec4 computedWeight_28;
    highp vec4 computedArea_29;
    highp vec4 computedAreaUncut_30;
    highp float tmpvar_31;
    tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_32;
    tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
    computedArea_29.x = tmpvar_32;
    computedAreaUncut_30.x = tmpvar_32;
    computedArea_29.w = tmpvar_31;
    computedAreaUncut_30.w = tmpvar_31;
    computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = min (tmpvar_20.y, 0.0);
    computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
    computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = max (tmpvar_20.y, 0.0);
    computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
    computedWeight_28 = (computedArea_29 * 0.44444);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
    fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_16.x;
    tmpvar_38.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_13.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_16.y;
    tmpvar_41.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_16.x;
    tmpvar_44.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_13.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_16.y;
    tmpvar_47.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_13.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_50;
  tmpvar_50.x = xlv_TEXCOORD1.w;
  tmpvar_50.y = xlv_TEXCOORD2.w;
  tmpvar_50.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_51;
  tmpvar_51 = (CAMERA_WORLDPOSITION - tmpvar_50);
  highp vec3 tmpvar_52;
  tmpvar_52 = normalize(tmpvar_51);
  lowp vec3 tmpvar_53;
  tmpvar_53 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_12 = tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_54 = ((mainNormal_12 * 2.0) - 1.0);
  bkgNormal_11 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_55;
    highp float len_56;
    highp float tileCount_57;
    tileCount_57 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_58;
    tmpvar_58 = max (0.0, tileCount_57);
    tileCount_57 = tmpvar_58;
    highp float tmpvar_59;
    if ((tmpvar_58 > 0.0)) {
      tmpvar_59 = 1.0;
    } else {
      tmpvar_59 = 0.0;
    };
    len_56 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_51, tmpvar_51)
    )));
    highp float tmpvar_60;
    tmpvar_60 = clamp (len_56, 0.0, 1.0);
    len_56 = tmpvar_60;
    lowp vec2 tmpvar_61;
    tmpvar_61 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_55 = tmpvar_61;
    highp vec3 tmpvar_62;
    tmpvar_62.z = 0.0;
    tmpvar_62.xy = texNormal_55;
    bkgNormal_11.z = tmpvar_62.z;
    bkgNormal_11.xy = (((
      (texNormal_55 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_60, tmpvar_59));
    bkgNormal_11.z = sqrt((1.0 - min (
      dot (bkgNormal_11.xy, bkgNormal_11.xy)
    , 1.0)));
  };
  n1_10 = (tmpvar_54 + vec3(0.0, 0.0, 1.0));
  n2_9 = (bkgNormal_11 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_63;
  tmpvar_63 = (((n1_10 * 
    dot (n1_10, n2_9)
  ) / n1_10.z) - n2_9);
  blendedNormal_8 = tmpvar_63;
  if (!(bool(tmpvar_1))) {
    blendedNormal_8 = -(tmpvar_63);
  };
  highp vec3 tmpvar_64;
  tmpvar_64 = normalize(((
    (blendedNormal_8.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_8.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_65;
  tmpvar_65 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_66;
  tmpvar_66 = max (dot (tmpvar_64, tmpvar_52), 0.0);
  highp float tmpvar_67;
  tmpvar_67 = max (dot (tmpvar_64, normalize(
    (tmpvar_52 + tmpvar_65)
  )), 0.0);
  lowp vec3 tmpvar_68;
  tmpvar_68 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_7 = tmpvar_68;
  lowp vec3 tmpvar_69;
  tmpvar_69 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_6 = tmpvar_69;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_70;
    lowp vec4 tmpvar_71;
    tmpvar_71 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_70 = tmpvar_71;
    bgTintColor_6 = mix (bgTintColor_6, patternAlbedo_70.xyz, vec3((mainNormal_12.z * patternAlbedo_70.w)));
  };
  mainColor_7 = (mainColor_7 * bgTintColor_6);
  mainColor_7 = (mainColor_7 * mainColor_7);
  highp float tmpvar_72;
  tmpvar_72 = dot (tmpvar_64, tmpvar_65);
  lowp vec4 tmpvar_73;
  tmpvar_73 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_74;
  tmpvar_74.x = Metallic;
  tmpvar_74.y = Smoothness;
  highp vec2 tmpvar_75;
  tmpvar_75 = (tmpvar_73.xy * tmpvar_74);
  highp vec2 tmpvar_76;
  tmpvar_76 = (vec2(1.0, 1.0) - tmpvar_75.yx);
  highp float tmpvar_77;
  tmpvar_77 = (1.0 - tmpvar_66);
  fresnel_5 = (tmpvar_77 * tmpvar_77);
  fresnel_5 = (fresnel_5 * fresnel_5);
  highp float tmpvar_78;
  tmpvar_78 = clamp (((tmpvar_75.x + EnvSpecIntensity) - 1.0), 0.0, 1.0);
  highp vec3 tmpvar_79;
  highp vec3 I_80;
  I_80 = -(tmpvar_52);
  tmpvar_79 = (I_80 - (2.0 * (
    dot (tmpvar_64, I_80)
   * tmpvar_64)));
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture (skybox, tmpvar_79);
  rgbm_4 = tmpvar_81;
  rgbm_4.xyz = ((rgbm_4.xyz * rgbm_4.w) * 4.0);
  highp float tmpvar_82;
  tmpvar_82 = max ((tmpvar_76.x * tmpvar_76.x), 0.1);
  highp float tmpvar_83;
  tmpvar_83 = (tmpvar_82 * tmpvar_82);
  highp float tmpvar_84;
  tmpvar_84 = (((
    (tmpvar_67 * tmpvar_83)
   - tmpvar_67) * tmpvar_67) + 1.0);
  d_3 = ((0.3183099 * tmpvar_83) / ((tmpvar_84 * tmpvar_84) + 1e-7));
  highp float tmpvar_85;
  tmpvar_85 = min (d_3, 100.0);
  d_3 = tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = mix (0.2209163, 1.0, tmpvar_75.x);
  finalCol_2.xyz = (((
    (((max (tmpvar_72, 0.0) * LIGHT_COLOR) * vec3(tmpvar_14)) + AMBIENT_COLOR)
   * mainColor_7) * tmpvar_76.y) + ((
    ((((tmpvar_85 * 
      (tmpvar_86 + ((1.0 - tmpvar_86) * fresnel_5))
    ) * max (
      ((tmpvar_72 + 1.0) * 0.5)
    , 0.0)) * SpecularColor.xyz) * LIGHT_COLOR)
   + 
    ((rgbm_4.xyz * mix (tmpvar_78, max (tmpvar_78, tmpvar_75.y), fresnel_5)) * EnvSpecIntensity)
  ) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_7, tmpvar_75.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EnvSpecIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform lowp samplerCube skybox;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float EnvSpecIntensity;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp vec4 rgbm_4;
  highp float fresnel_5;
  highp vec3 bgTintColor_6;
  highp vec3 mainColor_7;
  highp vec3 blendedNormal_8;
  highp vec3 n2_9;
  highp vec3 n1_10;
  highp vec3 bkgNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_15;
    highp vec3 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 texelsWeightsA_29;
    highp vec3 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.16 * tmpvar_34);
    texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
    texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
    texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
    texelsWeightsB_30.z = (0.16 * tmpvar_33);
    highp vec3 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_21.y;
    tmpvar_38.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.z = texelsWeightsB_30.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_29.y;
    tmpvar_41.yz = texelsWeightsB_30.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_21.y;
    tmpvar_43.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_29.y;
    tmpvar_44.yz = texelsWeightsB_30.xz;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    mediump float tmpvar_51;
    tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    mediump float tmpvar_54;
    tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.x;
    tmpvar_55.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    mediump float tmpvar_57;
    tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.y;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    mediump float tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.z;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    mediump float tmpvar_63;
    tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.x;
    tmpvar_64.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    mediump float tmpvar_66;
    tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.y;
    tmpvar_67.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    mediump float tmpvar_69;
    tmpvar_69 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.z;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    mediump float tmpvar_72;
    tmpvar_72 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_73;
  tmpvar_73.x = xlv_TEXCOORD1.w;
  tmpvar_73.y = xlv_TEXCOORD2.w;
  tmpvar_73.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_74;
  tmpvar_74 = (CAMERA_WORLDPOSITION - tmpvar_73);
  highp vec3 tmpvar_75;
  tmpvar_75 = normalize(tmpvar_74);
  lowp vec3 tmpvar_76;
  tmpvar_76 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_12 = tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_77 = ((mainNormal_12 * 2.0) - 1.0);
  bkgNormal_11 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_78;
    highp float len_79;
    highp float tileCount_80;
    tileCount_80 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_81;
    tmpvar_81 = max (0.0, tileCount_80);
    tileCount_80 = tmpvar_81;
    highp float tmpvar_82;
    if ((tmpvar_81 > 0.0)) {
      tmpvar_82 = 1.0;
    } else {
      tmpvar_82 = 0.0;
    };
    len_79 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_74, tmpvar_74)
    )));
    highp float tmpvar_83;
    tmpvar_83 = clamp (len_79, 0.0, 1.0);
    len_79 = tmpvar_83;
    lowp vec2 tmpvar_84;
    tmpvar_84 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_78 = tmpvar_84;
    highp vec3 tmpvar_85;
    tmpvar_85.z = 0.0;
    tmpvar_85.xy = texNormal_78;
    bkgNormal_11.z = tmpvar_85.z;
    bkgNormal_11.xy = (((
      (texNormal_78 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_83, tmpvar_82));
    bkgNormal_11.z = sqrt((1.0 - min (
      dot (bkgNormal_11.xy, bkgNormal_11.xy)
    , 1.0)));
  };
  n1_10 = (tmpvar_77 + vec3(0.0, 0.0, 1.0));
  n2_9 = (bkgNormal_11 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_86;
  tmpvar_86 = (((n1_10 * 
    dot (n1_10, n2_9)
  ) / n1_10.z) - n2_9);
  blendedNormal_8 = tmpvar_86;
  if (!(bool(tmpvar_1))) {
    blendedNormal_8 = -(tmpvar_86);
  };
  highp vec3 tmpvar_87;
  tmpvar_87 = normalize(((
    (blendedNormal_8.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_8.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_88;
  tmpvar_88 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_89;
  tmpvar_89 = max (dot (tmpvar_87, tmpvar_75), 0.0);
  highp float tmpvar_90;
  tmpvar_90 = max (dot (tmpvar_87, normalize(
    (tmpvar_75 + tmpvar_88)
  )), 0.0);
  lowp vec3 tmpvar_91;
  tmpvar_91 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_7 = tmpvar_91;
  lowp vec3 tmpvar_92;
  tmpvar_92 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_6 = tmpvar_92;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_93;
    lowp vec4 tmpvar_94;
    tmpvar_94 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_93 = tmpvar_94;
    bgTintColor_6 = mix (bgTintColor_6, patternAlbedo_93.xyz, vec3((mainNormal_12.z * patternAlbedo_93.w)));
  };
  mainColor_7 = (mainColor_7 * bgTintColor_6);
  mainColor_7 = (mainColor_7 * mainColor_7);
  highp float tmpvar_95;
  tmpvar_95 = dot (tmpvar_87, tmpvar_88);
  lowp vec4 tmpvar_96;
  tmpvar_96 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_97;
  tmpvar_97.x = Metallic;
  tmpvar_97.y = Smoothness;
  highp vec2 tmpvar_98;
  tmpvar_98 = (tmpvar_96.xy * tmpvar_97);
  highp vec2 tmpvar_99;
  tmpvar_99 = (vec2(1.0, 1.0) - tmpvar_98.yx);
  highp float tmpvar_100;
  tmpvar_100 = (1.0 - tmpvar_89);
  fresnel_5 = (tmpvar_100 * tmpvar_100);
  fresnel_5 = (fresnel_5 * fresnel_5);
  highp float tmpvar_101;
  tmpvar_101 = clamp (((tmpvar_98.x + EnvSpecIntensity) - 1.0), 0.0, 1.0);
  highp vec3 tmpvar_102;
  highp vec3 I_103;
  I_103 = -(tmpvar_75);
  tmpvar_102 = (I_103 - (2.0 * (
    dot (tmpvar_87, I_103)
   * tmpvar_87)));
  lowp vec4 tmpvar_104;
  tmpvar_104 = texture (skybox, tmpvar_102);
  rgbm_4 = tmpvar_104;
  rgbm_4.xyz = ((rgbm_4.xyz * rgbm_4.w) * 4.0);
  highp float tmpvar_105;
  tmpvar_105 = max ((tmpvar_99.x * tmpvar_99.x), 0.1);
  highp float tmpvar_106;
  tmpvar_106 = (tmpvar_105 * tmpvar_105);
  highp float tmpvar_107;
  tmpvar_107 = (((
    (tmpvar_90 * tmpvar_106)
   - tmpvar_90) * tmpvar_90) + 1.0);
  d_3 = ((0.3183099 * tmpvar_106) / ((tmpvar_107 * tmpvar_107) + 1e-7));
  highp float tmpvar_108;
  tmpvar_108 = min (d_3, 100.0);
  d_3 = tmpvar_108;
  highp float tmpvar_109;
  tmpvar_109 = mix (0.2209163, 1.0, tmpvar_98.x);
  finalCol_2.xyz = (((
    (((max (tmpvar_95, 0.0) * LIGHT_COLOR) * vec3(tmpvar_14)) + AMBIENT_COLOR)
   * mainColor_7) * tmpvar_99.y) + ((
    ((((tmpvar_108 * 
      (tmpvar_109 + ((1.0 - tmpvar_109) * fresnel_5))
    ) * max (
      ((tmpvar_95 + 1.0) * 0.5)
    , 0.0)) * SpecularColor.xyz) * LIGHT_COLOR)
   + 
    ((rgbm_4.xyz * mix (tmpvar_101, max (tmpvar_101, tmpvar_98.y), fresnel_5)) * EnvSpecIntensity)
  ) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_7, tmpvar_98.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EnvSpecIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform lowp samplerCube skybox;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float EnvSpecIntensity;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp vec4 rgbm_4;
  highp float fresnel_5;
  highp vec3 bgTintColor_6;
  highp vec3 mainColor_7;
  highp vec3 blendedNormal_8;
  highp vec3 n2_9;
  highp vec3 n1_10;
  highp vec3 bkgNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_15;
    highp vec4 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 texelsWeightsA_29;
    highp vec4 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.081632 * tmpvar_34);
    texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
    texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
    texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
    texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
    texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
    texelsWeightsB_30.w = (0.081632 * tmpvar_33);
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_21.yw;
    tmpvar_38.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.zw = texelsWeightsB_30.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_29.yw;
    tmpvar_41.zw = texelsWeightsB_30.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_21.yw;
    tmpvar_43.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_29.yw;
    tmpvar_44.zw = texelsWeightsB_30.yw;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    mediump float tmpvar_51;
    tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    mediump float tmpvar_54;
    tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.w;
    tmpvar_55.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    mediump float tmpvar_57;
    tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.x;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    mediump float tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.y;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    mediump float tmpvar_63;
    tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.z;
    tmpvar_64.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    mediump float tmpvar_66;
    tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.w;
    tmpvar_67.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    mediump float tmpvar_69;
    tmpvar_69 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.x;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    mediump float tmpvar_72;
    tmpvar_72 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_16.y;
    tmpvar_73.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
    tmpvar_74.z = shadowCoord_13.z;
    mediump float tmpvar_75;
    tmpvar_75 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_16.z;
    tmpvar_76.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
    tmpvar_77.z = shadowCoord_13.z;
    mediump float tmpvar_78;
    tmpvar_78 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_16.w;
    tmpvar_79.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
    tmpvar_80.z = shadowCoord_13.z;
    mediump float tmpvar_81;
    tmpvar_81 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_16.x;
    tmpvar_82.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
    tmpvar_83.z = shadowCoord_13.z;
    mediump float tmpvar_84;
    tmpvar_84 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_16.y;
    tmpvar_85.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
    tmpvar_86.z = shadowCoord_13.z;
    mediump float tmpvar_87;
    tmpvar_87 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_16.z;
    tmpvar_88.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
    tmpvar_89.z = shadowCoord_13.z;
    mediump float tmpvar_90;
    tmpvar_90 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_16.w;
    tmpvar_91.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
    tmpvar_92.z = shadowCoord_13.z;
    mediump float tmpvar_93;
    tmpvar_93 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_94;
  tmpvar_94.x = xlv_TEXCOORD1.w;
  tmpvar_94.y = xlv_TEXCOORD2.w;
  tmpvar_94.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_95;
  tmpvar_95 = (CAMERA_WORLDPOSITION - tmpvar_94);
  highp vec3 tmpvar_96;
  tmpvar_96 = normalize(tmpvar_95);
  lowp vec3 tmpvar_97;
  tmpvar_97 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_12 = tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_98 = ((mainNormal_12 * 2.0) - 1.0);
  bkgNormal_11 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_99;
    highp float len_100;
    highp float tileCount_101;
    tileCount_101 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_102;
    tmpvar_102 = max (0.0, tileCount_101);
    tileCount_101 = tmpvar_102;
    highp float tmpvar_103;
    if ((tmpvar_102 > 0.0)) {
      tmpvar_103 = 1.0;
    } else {
      tmpvar_103 = 0.0;
    };
    len_100 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_95, tmpvar_95)
    )));
    highp float tmpvar_104;
    tmpvar_104 = clamp (len_100, 0.0, 1.0);
    len_100 = tmpvar_104;
    lowp vec2 tmpvar_105;
    tmpvar_105 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_99 = tmpvar_105;
    highp vec3 tmpvar_106;
    tmpvar_106.z = 0.0;
    tmpvar_106.xy = texNormal_99;
    bkgNormal_11.z = tmpvar_106.z;
    bkgNormal_11.xy = (((
      (texNormal_99 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_104, tmpvar_103));
    bkgNormal_11.z = sqrt((1.0 - min (
      dot (bkgNormal_11.xy, bkgNormal_11.xy)
    , 1.0)));
  };
  n1_10 = (tmpvar_98 + vec3(0.0, 0.0, 1.0));
  n2_9 = (bkgNormal_11 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_107;
  tmpvar_107 = (((n1_10 * 
    dot (n1_10, n2_9)
  ) / n1_10.z) - n2_9);
  blendedNormal_8 = tmpvar_107;
  if (!(bool(tmpvar_1))) {
    blendedNormal_8 = -(tmpvar_107);
  };
  highp vec3 tmpvar_108;
  tmpvar_108 = normalize(((
    (blendedNormal_8.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_8.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_109;
  tmpvar_109 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_110;
  tmpvar_110 = max (dot (tmpvar_108, tmpvar_96), 0.0);
  highp float tmpvar_111;
  tmpvar_111 = max (dot (tmpvar_108, normalize(
    (tmpvar_96 + tmpvar_109)
  )), 0.0);
  lowp vec3 tmpvar_112;
  tmpvar_112 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_7 = tmpvar_112;
  lowp vec3 tmpvar_113;
  tmpvar_113 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_6 = tmpvar_113;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_114;
    lowp vec4 tmpvar_115;
    tmpvar_115 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_114 = tmpvar_115;
    bgTintColor_6 = mix (bgTintColor_6, patternAlbedo_114.xyz, vec3((mainNormal_12.z * patternAlbedo_114.w)));
  };
  mainColor_7 = (mainColor_7 * bgTintColor_6);
  mainColor_7 = (mainColor_7 * mainColor_7);
  highp float tmpvar_116;
  tmpvar_116 = dot (tmpvar_108, tmpvar_109);
  lowp vec4 tmpvar_117;
  tmpvar_117 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_118;
  tmpvar_118.x = Metallic;
  tmpvar_118.y = Smoothness;
  highp vec2 tmpvar_119;
  tmpvar_119 = (tmpvar_117.xy * tmpvar_118);
  highp vec2 tmpvar_120;
  tmpvar_120 = (vec2(1.0, 1.0) - tmpvar_119.yx);
  highp float tmpvar_121;
  tmpvar_121 = (1.0 - tmpvar_110);
  fresnel_5 = (tmpvar_121 * tmpvar_121);
  fresnel_5 = (fresnel_5 * fresnel_5);
  highp float tmpvar_122;
  tmpvar_122 = clamp (((tmpvar_119.x + EnvSpecIntensity) - 1.0), 0.0, 1.0);
  highp vec3 tmpvar_123;
  highp vec3 I_124;
  I_124 = -(tmpvar_96);
  tmpvar_123 = (I_124 - (2.0 * (
    dot (tmpvar_108, I_124)
   * tmpvar_108)));
  lowp vec4 tmpvar_125;
  tmpvar_125 = texture (skybox, tmpvar_123);
  rgbm_4 = tmpvar_125;
  rgbm_4.xyz = ((rgbm_4.xyz * rgbm_4.w) * 4.0);
  highp float tmpvar_126;
  tmpvar_126 = max ((tmpvar_120.x * tmpvar_120.x), 0.1);
  highp float tmpvar_127;
  tmpvar_127 = (tmpvar_126 * tmpvar_126);
  highp float tmpvar_128;
  tmpvar_128 = (((
    (tmpvar_111 * tmpvar_127)
   - tmpvar_111) * tmpvar_111) + 1.0);
  d_3 = ((0.3183099 * tmpvar_127) / ((tmpvar_128 * tmpvar_128) + 1e-7));
  highp float tmpvar_129;
  tmpvar_129 = min (d_3, 100.0);
  d_3 = tmpvar_129;
  highp float tmpvar_130;
  tmpvar_130 = mix (0.2209163, 1.0, tmpvar_119.x);
  finalCol_2.xyz = (((
    (((max (tmpvar_116, 0.0) * LIGHT_COLOR) * vec3(tmpvar_14)) + AMBIENT_COLOR)
   * mainColor_7) * tmpvar_120.y) + ((
    ((((tmpvar_129 * 
      (tmpvar_130 + ((1.0 - tmpvar_130) * fresnel_5))
    ) * max (
      ((tmpvar_116 + 1.0) * 0.5)
    , 0.0)) * SpecularColor.xyz) * LIGHT_COLOR)
   + 
    ((rgbm_4.xyz * mix (tmpvar_122, max (tmpvar_122, tmpvar_119.y), fresnel_5)) * EnvSpecIntensity)
  ) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_7, tmpvar_119.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EnvSpecIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform lowp samplerCube skybox;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float EnvSpecIntensity;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp vec4 rgbm_4;
  highp float fresnel_5;
  highp vec3 bgTintColor_6;
  highp vec3 mainColor_7;
  highp vec3 blendedNormal_8;
  highp vec3 n2_9;
  highp vec3 n1_10;
  highp vec3 bkgNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    highp vec2 tmpvar_15;
    tmpvar_15.x = LIGHT_PARAM.z;
    tmpvar_15.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_16;
    tmpvar_16.xy = tmpvar_15;
    highp float tmpvar_17;
    tmpvar_17 = (1.0/(LIGHT_PARAM.z));
    tmpvar_16.z = tmpvar_17;
    tmpvar_16.w = tmpvar_17;
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = tmpvar_16.xy;
    shadow_18 = 0.0;
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_13.xy - LIGHT_PARAM.zz);
    tmpvar_20.z = shadowCoord_13.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_18 = tmpvar_22;
    highp vec2 tmpvar_23;
    tmpvar_23.x = 0.0;
    tmpvar_23.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_13.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_13.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_18 = (tmpvar_22 + tmpvar_26);
    highp vec2 tmpvar_27;
    tmpvar_27.x = tmpvar_19.x;
    tmpvar_27.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_28;
    tmpvar_28.xy = (shadowCoord_13.xy + tmpvar_27);
    tmpvar_28.z = shadowCoord_13.z;
    highp vec4 tmpvar_29;
    tmpvar_29 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_28.xy);
    highp float tmpvar_30;
    if ((tmpvar_29.x < xlv_TEXCOORD4.z)) {
      tmpvar_30 = 0.0;
    } else {
      tmpvar_30 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_30);
    highp vec2 tmpvar_31;
    tmpvar_31.y = 0.0;
    tmpvar_31.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = (shadowCoord_13.xy + tmpvar_31);
    tmpvar_32.z = shadowCoord_13.z;
    highp vec4 tmpvar_33;
    tmpvar_33 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_32.xy);
    highp float tmpvar_34;
    if ((tmpvar_33.x < xlv_TEXCOORD4.z)) {
      tmpvar_34 = 0.0;
    } else {
      tmpvar_34 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_34);
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_13.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.y = 0.0;
    tmpvar_37.x = tmpvar_19.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_13.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_13.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = -(LIGHT_PARAM.z);
    tmpvar_41.y = tmpvar_19.y;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_13.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = 0.0;
    tmpvar_45.y = tmpvar_19.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (shadowCoord_13.xy + tmpvar_45);
    tmpvar_46.z = shadowCoord_13.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_48);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_13.xy + LIGHT_PARAM.zz);
    tmpvar_49.z = shadowCoord_13.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_51);
    shadow_18 = (shadow_18 / 9.0);
    tmpvar_14 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_52;
  tmpvar_52.x = xlv_TEXCOORD1.w;
  tmpvar_52.y = xlv_TEXCOORD2.w;
  tmpvar_52.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_53;
  tmpvar_53 = (CAMERA_WORLDPOSITION - tmpvar_52);
  highp vec3 tmpvar_54;
  tmpvar_54 = normalize(tmpvar_53);
  lowp vec3 tmpvar_55;
  tmpvar_55 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_12 = tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_56 = ((mainNormal_12 * 2.0) - 1.0);
  bkgNormal_11 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_57;
    highp float len_58;
    highp float tileCount_59;
    tileCount_59 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_60;
    tmpvar_60 = max (0.0, tileCount_59);
    tileCount_59 = tmpvar_60;
    highp float tmpvar_61;
    if ((tmpvar_60 > 0.0)) {
      tmpvar_61 = 1.0;
    } else {
      tmpvar_61 = 0.0;
    };
    len_58 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_53, tmpvar_53)
    )));
    highp float tmpvar_62;
    tmpvar_62 = clamp (len_58, 0.0, 1.0);
    len_58 = tmpvar_62;
    lowp vec2 tmpvar_63;
    tmpvar_63 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_57 = tmpvar_63;
    highp vec3 tmpvar_64;
    tmpvar_64.z = 0.0;
    tmpvar_64.xy = texNormal_57;
    bkgNormal_11.z = tmpvar_64.z;
    bkgNormal_11.xy = (((
      (texNormal_57 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_62, tmpvar_61));
    bkgNormal_11.z = sqrt((1.0 - min (
      dot (bkgNormal_11.xy, bkgNormal_11.xy)
    , 1.0)));
  };
  n1_10 = (tmpvar_56 + vec3(0.0, 0.0, 1.0));
  n2_9 = (bkgNormal_11 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_65;
  tmpvar_65 = (((n1_10 * 
    dot (n1_10, n2_9)
  ) / n1_10.z) - n2_9);
  blendedNormal_8 = tmpvar_65;
  if (!(bool(tmpvar_1))) {
    blendedNormal_8 = -(tmpvar_65);
  };
  highp vec3 tmpvar_66;
  tmpvar_66 = normalize(((
    (blendedNormal_8.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_8.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_67;
  tmpvar_67 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_68;
  tmpvar_68 = max (dot (tmpvar_66, tmpvar_54), 0.0);
  highp float tmpvar_69;
  tmpvar_69 = max (dot (tmpvar_66, normalize(
    (tmpvar_54 + tmpvar_67)
  )), 0.0);
  lowp vec3 tmpvar_70;
  tmpvar_70 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_7 = tmpvar_70;
  lowp vec3 tmpvar_71;
  tmpvar_71 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_6 = tmpvar_71;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_72;
    lowp vec4 tmpvar_73;
    tmpvar_73 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_72 = tmpvar_73;
    bgTintColor_6 = mix (bgTintColor_6, patternAlbedo_72.xyz, vec3((mainNormal_12.z * patternAlbedo_72.w)));
  };
  mainColor_7 = (mainColor_7 * bgTintColor_6);
  mainColor_7 = (mainColor_7 * mainColor_7);
  highp float tmpvar_74;
  tmpvar_74 = dot (tmpvar_66, tmpvar_67);
  lowp vec4 tmpvar_75;
  tmpvar_75 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_76;
  tmpvar_76.x = Metallic;
  tmpvar_76.y = Smoothness;
  highp vec2 tmpvar_77;
  tmpvar_77 = (tmpvar_75.xy * tmpvar_76);
  highp vec2 tmpvar_78;
  tmpvar_78 = (vec2(1.0, 1.0) - tmpvar_77.yx);
  highp float tmpvar_79;
  tmpvar_79 = (1.0 - tmpvar_68);
  fresnel_5 = (tmpvar_79 * tmpvar_79);
  fresnel_5 = (fresnel_5 * fresnel_5);
  highp float tmpvar_80;
  tmpvar_80 = clamp (((tmpvar_77.x + EnvSpecIntensity) - 1.0), 0.0, 1.0);
  highp vec3 tmpvar_81;
  highp vec3 I_82;
  I_82 = -(tmpvar_54);
  tmpvar_81 = (I_82 - (2.0 * (
    dot (tmpvar_66, I_82)
   * tmpvar_66)));
  lowp vec4 tmpvar_83;
  tmpvar_83 = texture (skybox, tmpvar_81);
  rgbm_4 = tmpvar_83;
  rgbm_4.xyz = ((rgbm_4.xyz * rgbm_4.w) * 4.0);
  highp float tmpvar_84;
  tmpvar_84 = max ((tmpvar_78.x * tmpvar_78.x), 0.1);
  highp float tmpvar_85;
  tmpvar_85 = (tmpvar_84 * tmpvar_84);
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_69 * tmpvar_85)
   - tmpvar_69) * tmpvar_69) + 1.0);
  d_3 = ((0.3183099 * tmpvar_85) / ((tmpvar_86 * tmpvar_86) + 1e-7));
  highp float tmpvar_87;
  tmpvar_87 = min (d_3, 100.0);
  d_3 = tmpvar_87;
  highp float tmpvar_88;
  tmpvar_88 = mix (0.2209163, 1.0, tmpvar_77.x);
  finalCol_2.xyz = (((
    (((max (tmpvar_74, 0.0) * LIGHT_COLOR) * vec3(tmpvar_14)) + AMBIENT_COLOR)
   * mainColor_7) * tmpvar_78.y) + ((
    ((((tmpvar_87 * 
      (tmpvar_88 + ((1.0 - tmpvar_88) * fresnel_5))
    ) * max (
      ((tmpvar_74 + 1.0) * 0.5)
    , 0.0)) * SpecularColor.xyz) * LIGHT_COLOR)
   + 
    ((rgbm_4.xyz * mix (tmpvar_80, max (tmpvar_80, tmpvar_77.y), fresnel_5)) * EnvSpecIntensity)
  ) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_7, tmpvar_77.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
}


end

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_24;
  tmpvar_24 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_24;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_24);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_26;
  tmpvar_26 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_27;
  tmpvar_27 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_27;
  lowp vec3 tmpvar_28;
  tmpvar_28 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_28;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_29;
    lowp vec4 tmpvar_30;
    tmpvar_30 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_29 = tmpvar_30;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_29.xyz, vec3((mainNormal_11.z * patternAlbedo_29.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_31;
  tmpvar_31 = max (((
    dot (tmpvar_25, tmpvar_26)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_31 * tmpvar_31);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_33;
  tmpvar_33.x = Metallic;
  tmpvar_33.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_32.xy * tmpvar_33)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_24;
  tmpvar_24 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_24;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_24);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_26;
  tmpvar_26 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_27;
  tmpvar_27 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_27;
  lowp vec3 tmpvar_28;
  tmpvar_28 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_28;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_29;
    lowp vec4 tmpvar_30;
    tmpvar_30 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_29 = tmpvar_30;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_29.xyz, vec3((mainNormal_11.z * patternAlbedo_29.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_31;
  tmpvar_31 = max (((
    dot (tmpvar_25, tmpvar_26)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_31 * tmpvar_31);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_33;
  tmpvar_33.x = Metallic;
  tmpvar_33.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_32.xy * tmpvar_33)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_24;
  tmpvar_24 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_24;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_24);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_26;
  tmpvar_26 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_27;
  tmpvar_27 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_27;
  lowp vec3 tmpvar_28;
  tmpvar_28 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_28;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_29;
    lowp vec4 tmpvar_30;
    tmpvar_30 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_29 = tmpvar_30;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_29.xyz, vec3((mainNormal_11.z * patternAlbedo_29.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_31;
  tmpvar_31 = max (((
    dot (tmpvar_25, tmpvar_26)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_31 * tmpvar_31);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_33;
  tmpvar_33.x = Metallic;
  tmpvar_33.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_32.xy * tmpvar_33)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_24;
  tmpvar_24 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_24;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_24);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_26;
  tmpvar_26 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_27;
  tmpvar_27 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_27;
  lowp vec3 tmpvar_28;
  tmpvar_28 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_28;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_29;
    lowp vec4 tmpvar_30;
    tmpvar_30 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_29 = tmpvar_30;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_29.xyz, vec3((mainNormal_11.z * patternAlbedo_29.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_31;
  tmpvar_31 = max (((
    dot (tmpvar_25, tmpvar_26)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_31 * tmpvar_31);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_33;
  tmpvar_33.x = Metallic;
  tmpvar_33.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_32.xy * tmpvar_33)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_24;
  tmpvar_24 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_24;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_24);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_26;
  tmpvar_26 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_27;
  tmpvar_27 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_27;
  lowp vec3 tmpvar_28;
  tmpvar_28 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_28;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_29;
    lowp vec4 tmpvar_30;
    tmpvar_30 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_29 = tmpvar_30;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_29.xyz, vec3((mainNormal_11.z * patternAlbedo_29.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_31;
  tmpvar_31 = max (((
    dot (tmpvar_25, tmpvar_26)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_31 * tmpvar_31);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_33;
  tmpvar_33.x = Metallic;
  tmpvar_33.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_32.xy * tmpvar_33)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_24;
  tmpvar_24 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_24;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_24);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_26;
  tmpvar_26 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_27;
  tmpvar_27 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_27;
  lowp vec3 tmpvar_28;
  tmpvar_28 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_28;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_29;
    lowp vec4 tmpvar_30;
    tmpvar_30 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_29 = tmpvar_30;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_29.xyz, vec3((mainNormal_11.z * patternAlbedo_29.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_31;
  tmpvar_31 = max (((
    dot (tmpvar_25, tmpvar_26)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_31 * tmpvar_31);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_33;
  tmpvar_33.x = Metallic;
  tmpvar_33.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_32.xy * tmpvar_33)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end