function DefineParams()
	Properties = 
	{
		
MainTex = { "main Color", TEXTURE2D, "white" },
NormalTexture = {"Normal Map", TEXTURE2D, "white"},
BkgTintTex = {"BkgTintTex Map", TEXTURE2D, "white"},
BkgMaterialTex = {"BkgMaterialTex Map", TEXTURE2D, "white"},
BkgNormalTex = {"BkgNormalTex Map", TEXTURE2D, "white"},
PatternAlbedoTex = {"PatternAlbedoTex Map", TEXTURE2D, "white"},
PatternNormalTex = {"PatternNormalTex Map", TEXTURE2D, "white"},

FBkgNormalIntensity = { "FBkgNormalIntensity", FLOAT, "0.5" },   
Metallic = { "Metallic", FLOAT, "0.5" },
Smoothness = { "Smoothness", FLOAT, "0.5" },
EnvSpecIntensity = { "EnvSpecIntensity", FLOAT, "0.5" },
UseBkgNormal = { "UseBkgNormal", FLOAT, "1.0" },
UsePatternAlbedo = { "UsePatternAlbedo", FLOAT, "1.0" },
UsePatternNormal = { "UsePatternNormal", FLOAT, "1.0" },

BkgScaleOffset = { "BkgScaleOffset", VEC4, "1.0,1.0,0.0,0.0" },
Bkguv02 = { "Bkguv02", FLOAT, "1.0" },
Patternuv32 = { "Patternuv32", FLOAT, "1.0" },

SpecularColor = {"Specular Color", COLOR, "1.0,1.0,1.0,1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "StandardOpaque"
RenderQueue = "Opaque"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp float fresnel_4;
  highp vec3 bgTintColor_5;
  highp vec3 mainColor_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_13);
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_17;
    highp float len_18;
    highp float tileCount_19;
    tileCount_19 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_20;
    tmpvar_20 = max (0.0, tileCount_19);
    tileCount_19 = tmpvar_20;
    highp float tmpvar_21;
    if ((tmpvar_20 > 0.0)) {
      tmpvar_21 = 1.0;
    } else {
      tmpvar_21 = 0.0;
    };
    len_18 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_22;
    tmpvar_22 = clamp (len_18, 0.0, 1.0);
    len_18 = tmpvar_22;
    lowp vec2 tmpvar_23;
    tmpvar_23 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_17 = tmpvar_23;
    highp vec3 tmpvar_24;
    tmpvar_24.z = 0.0;
    tmpvar_24.xy = texNormal_17;
    bkgNormal_10.z = tmpvar_24.z;
    bkgNormal_10.xy = (((
      (texNormal_17 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_22, tmpvar_21));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_25;
    highp vec2 patternNormal_26;
    lowp vec2 tmpvar_27;
    tmpvar_27 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_26 = tmpvar_27;
    highp vec3 tmpvar_28;
    tmpvar_28.z = 0.0;
    tmpvar_28.xy = ((patternNormal_26 * 2.0) - 1.0);
    patternNormal1_25.xy = tmpvar_28.xy;
    patternNormal1_25.z = sqrt((1.0 - dot (tmpvar_28.xy, tmpvar_28.xy)));
    lowp vec4 tmpvar_29;
    tmpvar_29 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_25, vec3((mainNormal_11.z * tmpvar_29.w)));
  };
  n1_9 = (tmpvar_16 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_30;
  tmpvar_30 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_30;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_30);
  };
  highp vec3 tmpvar_31;
  tmpvar_31 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_32;
  tmpvar_32 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_33;
  tmpvar_33 = max (dot (tmpvar_31, tmpvar_14), 0.0);
  highp float tmpvar_34;
  tmpvar_34 = max (dot (tmpvar_31, normalize(
    (tmpvar_14 + tmpvar_32)
  )), 0.0);
  lowp vec3 tmpvar_35;
  tmpvar_35 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_6 = tmpvar_35;
  lowp vec3 tmpvar_36;
  tmpvar_36 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_5 = tmpvar_36;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_37;
    lowp vec4 tmpvar_38;
    tmpvar_38 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_37 = tmpvar_38;
    bgTintColor_5 = mix (bgTintColor_5, patternAlbedo_37.xyz, vec3((mainNormal_11.z * patternAlbedo_37.w)));
  };
  mainColor_6 = (mainColor_6 * bgTintColor_5);
  mainColor_6 = (mainColor_6 * mainColor_6);
  highp float tmpvar_39;
  tmpvar_39 = dot (tmpvar_31, tmpvar_32);
  lowp vec4 tmpvar_40;
  tmpvar_40 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_41;
  tmpvar_41.x = Metallic;
  tmpvar_41.y = Smoothness;
  highp vec2 tmpvar_42;
  tmpvar_42 = (tmpvar_40.xy * tmpvar_41);
  highp vec2 tmpvar_43;
  tmpvar_43 = (vec2(1.0, 1.0) - tmpvar_42.yx);
  highp float tmpvar_44;
  tmpvar_44 = (1.0 - tmpvar_33);
  fresnel_4 = (tmpvar_44 * tmpvar_44);
  fresnel_4 = (fresnel_4 * fresnel_4);
  highp float tmpvar_45;
  tmpvar_45 = max ((tmpvar_43.x * tmpvar_43.x), 0.1);
  highp float tmpvar_46;
  tmpvar_46 = (tmpvar_45 * tmpvar_45);
  highp float tmpvar_47;
  tmpvar_47 = (((
    (tmpvar_34 * tmpvar_46)
   - tmpvar_34) * tmpvar_34) + 1.0);
  d_3 = ((0.3183099 * tmpvar_46) / ((tmpvar_47 * tmpvar_47) + 1e-7));
  highp float tmpvar_48;
  tmpvar_48 = min (d_3, 100.0);
  d_3 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (0.2209163, 1.0, tmpvar_42.x);
  finalCol_2.xyz = (((
    ((max (tmpvar_39, 0.0) * LIGHT_COLOR) + AMBIENT_COLOR)
   * mainColor_6) * tmpvar_43.y) + ((
    (((tmpvar_48 * (tmpvar_49 + 
      ((1.0 - tmpvar_49) * fresnel_4)
    )) * max ((
      (tmpvar_39 + 1.0)
     * 0.5), 0.0)) * SpecularColor.xyz)
   * LIGHT_COLOR) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_6, tmpvar_42.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp float fresnel_4;
  highp vec3 bgTintColor_5;
  highp vec3 mainColor_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_13);
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_17;
    highp float len_18;
    highp float tileCount_19;
    tileCount_19 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_20;
    tmpvar_20 = max (0.0, tileCount_19);
    tileCount_19 = tmpvar_20;
    highp float tmpvar_21;
    if ((tmpvar_20 > 0.0)) {
      tmpvar_21 = 1.0;
    } else {
      tmpvar_21 = 0.0;
    };
    len_18 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_22;
    tmpvar_22 = clamp (len_18, 0.0, 1.0);
    len_18 = tmpvar_22;
    lowp vec2 tmpvar_23;
    tmpvar_23 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_17 = tmpvar_23;
    highp vec3 tmpvar_24;
    tmpvar_24.z = 0.0;
    tmpvar_24.xy = texNormal_17;
    bkgNormal_10.z = tmpvar_24.z;
    bkgNormal_10.xy = (((
      (texNormal_17 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_22, tmpvar_21));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_25;
    highp vec2 patternNormal_26;
    lowp vec2 tmpvar_27;
    tmpvar_27 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_26 = tmpvar_27;
    highp vec3 tmpvar_28;
    tmpvar_28.z = 0.0;
    tmpvar_28.xy = ((patternNormal_26 * 2.0) - 1.0);
    patternNormal1_25.xy = tmpvar_28.xy;
    patternNormal1_25.z = sqrt((1.0 - dot (tmpvar_28.xy, tmpvar_28.xy)));
    lowp vec4 tmpvar_29;
    tmpvar_29 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_25, vec3((mainNormal_11.z * tmpvar_29.w)));
  };
  n1_9 = (tmpvar_16 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_30;
  tmpvar_30 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_30;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_30);
  };
  highp vec3 tmpvar_31;
  tmpvar_31 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_32;
  tmpvar_32 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_33;
  tmpvar_33 = max (dot (tmpvar_31, tmpvar_14), 0.0);
  highp float tmpvar_34;
  tmpvar_34 = max (dot (tmpvar_31, normalize(
    (tmpvar_14 + tmpvar_32)
  )), 0.0);
  lowp vec3 tmpvar_35;
  tmpvar_35 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_6 = tmpvar_35;
  lowp vec3 tmpvar_36;
  tmpvar_36 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_5 = tmpvar_36;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_37;
    lowp vec4 tmpvar_38;
    tmpvar_38 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_37 = tmpvar_38;
    bgTintColor_5 = mix (bgTintColor_5, patternAlbedo_37.xyz, vec3((mainNormal_11.z * patternAlbedo_37.w)));
  };
  mainColor_6 = (mainColor_6 * bgTintColor_5);
  mainColor_6 = (mainColor_6 * mainColor_6);
  highp float tmpvar_39;
  tmpvar_39 = dot (tmpvar_31, tmpvar_32);
  lowp vec4 tmpvar_40;
  tmpvar_40 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_41;
  tmpvar_41.x = Metallic;
  tmpvar_41.y = Smoothness;
  highp vec2 tmpvar_42;
  tmpvar_42 = (tmpvar_40.xy * tmpvar_41);
  highp vec2 tmpvar_43;
  tmpvar_43 = (vec2(1.0, 1.0) - tmpvar_42.yx);
  highp float tmpvar_44;
  tmpvar_44 = (1.0 - tmpvar_33);
  fresnel_4 = (tmpvar_44 * tmpvar_44);
  fresnel_4 = (fresnel_4 * fresnel_4);
  highp float tmpvar_45;
  tmpvar_45 = max ((tmpvar_43.x * tmpvar_43.x), 0.1);
  highp float tmpvar_46;
  tmpvar_46 = (tmpvar_45 * tmpvar_45);
  highp float tmpvar_47;
  tmpvar_47 = (((
    (tmpvar_34 * tmpvar_46)
   - tmpvar_34) * tmpvar_34) + 1.0);
  d_3 = ((0.3183099 * tmpvar_46) / ((tmpvar_47 * tmpvar_47) + 1e-7));
  highp float tmpvar_48;
  tmpvar_48 = min (d_3, 100.0);
  d_3 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (0.2209163, 1.0, tmpvar_42.x);
  finalCol_2.xyz = (((
    ((max (tmpvar_39, 0.0) * LIGHT_COLOR) + AMBIENT_COLOR)
   * mainColor_6) * tmpvar_43.y) + ((
    (((tmpvar_48 * (tmpvar_49 + 
      ((1.0 - tmpvar_49) * fresnel_4)
    )) * max ((
      (tmpvar_39 + 1.0)
     * 0.5), 0.0)) * SpecularColor.xyz)
   * LIGHT_COLOR) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_6, tmpvar_42.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp float fresnel_4;
  highp vec3 bgTintColor_5;
  highp vec3 mainColor_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = (CAMERA_WORLDPOSITION - tmpvar_49);
  highp vec3 tmpvar_51;
  tmpvar_51 = normalize(tmpvar_50);
  lowp vec3 tmpvar_52;
  tmpvar_52 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_52;
  highp vec3 tmpvar_53;
  tmpvar_53 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_54;
    highp float len_55;
    highp float tileCount_56;
    tileCount_56 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_57;
    tmpvar_57 = max (0.0, tileCount_56);
    tileCount_56 = tmpvar_57;
    highp float tmpvar_58;
    if ((tmpvar_57 > 0.0)) {
      tmpvar_58 = 1.0;
    } else {
      tmpvar_58 = 0.0;
    };
    len_55 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_50, tmpvar_50)
    )));
    highp float tmpvar_59;
    tmpvar_59 = clamp (len_55, 0.0, 1.0);
    len_55 = tmpvar_59;
    lowp vec2 tmpvar_60;
    tmpvar_60 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_54 = tmpvar_60;
    highp vec3 tmpvar_61;
    tmpvar_61.z = 0.0;
    tmpvar_61.xy = texNormal_54;
    bkgNormal_10.z = tmpvar_61.z;
    bkgNormal_10.xy = (((
      (texNormal_54 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_59, tmpvar_58));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_62;
    highp vec2 patternNormal_63;
    lowp vec2 tmpvar_64;
    tmpvar_64 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_63 = tmpvar_64;
    highp vec3 tmpvar_65;
    tmpvar_65.z = 0.0;
    tmpvar_65.xy = ((patternNormal_63 * 2.0) - 1.0);
    patternNormal1_62.xy = tmpvar_65.xy;
    patternNormal1_62.z = sqrt((1.0 - dot (tmpvar_65.xy, tmpvar_65.xy)));
    lowp vec4 tmpvar_66;
    tmpvar_66 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_62, vec3((mainNormal_11.z * tmpvar_66.w)));
  };
  n1_9 = (tmpvar_53 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_67;
  tmpvar_67 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_67;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_67);
  };
  highp vec3 tmpvar_68;
  tmpvar_68 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_69;
  tmpvar_69 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_70;
  tmpvar_70 = max (dot (tmpvar_68, tmpvar_51), 0.0);
  highp float tmpvar_71;
  tmpvar_71 = max (dot (tmpvar_68, normalize(
    (tmpvar_51 + tmpvar_69)
  )), 0.0);
  lowp vec3 tmpvar_72;
  tmpvar_72 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_6 = tmpvar_72;
  lowp vec3 tmpvar_73;
  tmpvar_73 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_5 = tmpvar_73;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_74;
    lowp vec4 tmpvar_75;
    tmpvar_75 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_74 = tmpvar_75;
    bgTintColor_5 = mix (bgTintColor_5, patternAlbedo_74.xyz, vec3((mainNormal_11.z * patternAlbedo_74.w)));
  };
  mainColor_6 = (mainColor_6 * bgTintColor_5);
  mainColor_6 = (mainColor_6 * mainColor_6);
  highp float tmpvar_76;
  tmpvar_76 = dot (tmpvar_68, tmpvar_69);
  lowp vec4 tmpvar_77;
  tmpvar_77 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_78;
  tmpvar_78.x = Metallic;
  tmpvar_78.y = Smoothness;
  highp vec2 tmpvar_79;
  tmpvar_79 = (tmpvar_77.xy * tmpvar_78);
  highp vec2 tmpvar_80;
  tmpvar_80 = (vec2(1.0, 1.0) - tmpvar_79.yx);
  highp float tmpvar_81;
  tmpvar_81 = (1.0 - tmpvar_70);
  fresnel_4 = (tmpvar_81 * tmpvar_81);
  fresnel_4 = (fresnel_4 * fresnel_4);
  highp float tmpvar_82;
  tmpvar_82 = max ((tmpvar_80.x * tmpvar_80.x), 0.1);
  highp float tmpvar_83;
  tmpvar_83 = (tmpvar_82 * tmpvar_82);
  highp float tmpvar_84;
  tmpvar_84 = (((
    (tmpvar_71 * tmpvar_83)
   - tmpvar_71) * tmpvar_71) + 1.0);
  d_3 = ((0.3183099 * tmpvar_83) / ((tmpvar_84 * tmpvar_84) + 1e-7));
  highp float tmpvar_85;
  tmpvar_85 = min (d_3, 100.0);
  d_3 = tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = mix (0.2209163, 1.0, tmpvar_79.x);
  finalCol_2.xyz = (((
    (((max (tmpvar_76, 0.0) * LIGHT_COLOR) * vec3(tmpvar_13)) + AMBIENT_COLOR)
   * mainColor_6) * tmpvar_80.y) + ((
    (((tmpvar_85 * (tmpvar_86 + 
      ((1.0 - tmpvar_86) * fresnel_4)
    )) * max ((
      (tmpvar_76 + 1.0)
     * 0.5), 0.0)) * SpecularColor.xyz)
   * LIGHT_COLOR) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_6, tmpvar_79.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp float fresnel_4;
  highp vec3 bgTintColor_5;
  highp vec3 mainColor_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_14;
    highp vec3 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec3 texelsWeightsA_20;
    highp vec3 texelsWeightsB_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_19.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_19.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    texelsWeightsA_20.x = (0.16 * tmpvar_25);
    texelsWeightsA_20.y = (0.16 * computedAreaUncut_23.y);
    texelsWeightsA_20.z = (0.16 * (computedArea_22.y + 1.0));
    texelsWeightsB_21.x = (0.16 * (computedArea_22.z + 1.0));
    texelsWeightsB_21.y = (0.16 * computedAreaUncut_23.z);
    texelsWeightsB_21.z = (0.16 * tmpvar_24);
    highp vec3 texelsWeightsA_28;
    highp vec3 texelsWeightsB_29;
    highp vec4 computedArea_30;
    highp vec4 computedAreaUncut_31;
    highp float tmpvar_32;
    tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_33;
    tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
    computedArea_30.x = tmpvar_33;
    computedAreaUncut_31.x = tmpvar_33;
    computedArea_30.w = tmpvar_32;
    computedAreaUncut_31.w = tmpvar_32;
    computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = min (tmpvar_19.y, 0.0);
    computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
    computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = max (tmpvar_19.y, 0.0);
    computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
    texelsWeightsA_28.x = (0.16 * tmpvar_33);
    texelsWeightsA_28.y = (0.16 * computedAreaUncut_31.y);
    texelsWeightsA_28.z = (0.16 * (computedArea_30.y + 1.0));
    texelsWeightsB_29.x = (0.16 * (computedArea_30.z + 1.0));
    texelsWeightsB_29.y = (0.16 * computedAreaUncut_31.z);
    texelsWeightsB_29.z = (0.16 * tmpvar_32);
    highp vec3 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_20.xz;
    tmpvar_36.z = texelsWeightsB_21.y;
    highp vec3 tmpvar_37;
    tmpvar_37.x = texelsWeightsA_20.y;
    tmpvar_37.yz = texelsWeightsB_21.xz;
    highp vec3 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec3 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_28.xz;
    tmpvar_39.z = texelsWeightsB_29.y;
    highp vec3 tmpvar_40;
    tmpvar_40.x = texelsWeightsA_28.y;
    tmpvar_40.yz = texelsWeightsB_29.xz;
    highp vec3 tmpvar_41;
    tmpvar_41 = (tmpvar_39 + tmpvar_40);
    highp vec3 tmpvar_42;
    tmpvar_42.x = texelsWeightsA_20.y;
    tmpvar_42.yz = texelsWeightsB_21.xz;
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_28.y;
    tmpvar_43.yz = texelsWeightsB_29.xz;
    fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_44;
    tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_15.x;
    tmpvar_45.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
    tmpvar_46.z = shadowCoord_12.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_15.y;
    tmpvar_48.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
    tmpvar_49.z = shadowCoord_12.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_15.z;
    tmpvar_51.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
    tmpvar_52.z = shadowCoord_12.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_15.x;
    tmpvar_54.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
    tmpvar_55.z = shadowCoord_12.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_15.y;
    tmpvar_57.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
    tmpvar_58.z = shadowCoord_12.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_15.z;
    tmpvar_60.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
    tmpvar_61.z = shadowCoord_12.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_15.x;
    tmpvar_63.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
    tmpvar_64.z = shadowCoord_12.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_15.y;
    tmpvar_66.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
    tmpvar_67.z = shadowCoord_12.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_15.z;
    tmpvar_69.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
    tmpvar_70.z = shadowCoord_12.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_71));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_72;
  tmpvar_72.x = xlv_TEXCOORD1.w;
  tmpvar_72.y = xlv_TEXCOORD2.w;
  tmpvar_72.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_73;
  tmpvar_73 = (CAMERA_WORLDPOSITION - tmpvar_72);
  highp vec3 tmpvar_74;
  tmpvar_74 = normalize(tmpvar_73);
  lowp vec3 tmpvar_75;
  tmpvar_75 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_75;
  highp vec3 tmpvar_76;
  tmpvar_76 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_77;
    highp float len_78;
    highp float tileCount_79;
    tileCount_79 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_80;
    tmpvar_80 = max (0.0, tileCount_79);
    tileCount_79 = tmpvar_80;
    highp float tmpvar_81;
    if ((tmpvar_80 > 0.0)) {
      tmpvar_81 = 1.0;
    } else {
      tmpvar_81 = 0.0;
    };
    len_78 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_73, tmpvar_73)
    )));
    highp float tmpvar_82;
    tmpvar_82 = clamp (len_78, 0.0, 1.0);
    len_78 = tmpvar_82;
    lowp vec2 tmpvar_83;
    tmpvar_83 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_77 = tmpvar_83;
    highp vec3 tmpvar_84;
    tmpvar_84.z = 0.0;
    tmpvar_84.xy = texNormal_77;
    bkgNormal_10.z = tmpvar_84.z;
    bkgNormal_10.xy = (((
      (texNormal_77 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_82, tmpvar_81));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_85;
    highp vec2 patternNormal_86;
    lowp vec2 tmpvar_87;
    tmpvar_87 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_86 = tmpvar_87;
    highp vec3 tmpvar_88;
    tmpvar_88.z = 0.0;
    tmpvar_88.xy = ((patternNormal_86 * 2.0) - 1.0);
    patternNormal1_85.xy = tmpvar_88.xy;
    patternNormal1_85.z = sqrt((1.0 - dot (tmpvar_88.xy, tmpvar_88.xy)));
    lowp vec4 tmpvar_89;
    tmpvar_89 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_85, vec3((mainNormal_11.z * tmpvar_89.w)));
  };
  n1_9 = (tmpvar_76 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_90;
  tmpvar_90 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_90;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_90);
  };
  highp vec3 tmpvar_91;
  tmpvar_91 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_92;
  tmpvar_92 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_93;
  tmpvar_93 = max (dot (tmpvar_91, tmpvar_74), 0.0);
  highp float tmpvar_94;
  tmpvar_94 = max (dot (tmpvar_91, normalize(
    (tmpvar_74 + tmpvar_92)
  )), 0.0);
  lowp vec3 tmpvar_95;
  tmpvar_95 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_6 = tmpvar_95;
  lowp vec3 tmpvar_96;
  tmpvar_96 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_5 = tmpvar_96;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_97;
    lowp vec4 tmpvar_98;
    tmpvar_98 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_97 = tmpvar_98;
    bgTintColor_5 = mix (bgTintColor_5, patternAlbedo_97.xyz, vec3((mainNormal_11.z * patternAlbedo_97.w)));
  };
  mainColor_6 = (mainColor_6 * bgTintColor_5);
  mainColor_6 = (mainColor_6 * mainColor_6);
  highp float tmpvar_99;
  tmpvar_99 = dot (tmpvar_91, tmpvar_92);
  lowp vec4 tmpvar_100;
  tmpvar_100 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_101;
  tmpvar_101.x = Metallic;
  tmpvar_101.y = Smoothness;
  highp vec2 tmpvar_102;
  tmpvar_102 = (tmpvar_100.xy * tmpvar_101);
  highp vec2 tmpvar_103;
  tmpvar_103 = (vec2(1.0, 1.0) - tmpvar_102.yx);
  highp float tmpvar_104;
  tmpvar_104 = (1.0 - tmpvar_93);
  fresnel_4 = (tmpvar_104 * tmpvar_104);
  fresnel_4 = (fresnel_4 * fresnel_4);
  highp float tmpvar_105;
  tmpvar_105 = max ((tmpvar_103.x * tmpvar_103.x), 0.1);
  highp float tmpvar_106;
  tmpvar_106 = (tmpvar_105 * tmpvar_105);
  highp float tmpvar_107;
  tmpvar_107 = (((
    (tmpvar_94 * tmpvar_106)
   - tmpvar_94) * tmpvar_94) + 1.0);
  d_3 = ((0.3183099 * tmpvar_106) / ((tmpvar_107 * tmpvar_107) + 1e-7));
  highp float tmpvar_108;
  tmpvar_108 = min (d_3, 100.0);
  d_3 = tmpvar_108;
  highp float tmpvar_109;
  tmpvar_109 = mix (0.2209163, 1.0, tmpvar_102.x);
  finalCol_2.xyz = (((
    (((max (tmpvar_99, 0.0) * LIGHT_COLOR) * vec3(tmpvar_13)) + AMBIENT_COLOR)
   * mainColor_6) * tmpvar_103.y) + ((
    (((tmpvar_108 * (tmpvar_109 + 
      ((1.0 - tmpvar_109) * fresnel_4)
    )) * max ((
      (tmpvar_99 + 1.0)
     * 0.5), 0.0)) * SpecularColor.xyz)
   * LIGHT_COLOR) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_6, tmpvar_102.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp float fresnel_4;
  highp vec3 bgTintColor_5;
  highp vec3 mainColor_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_14;
    highp vec4 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 texelsWeightsA_20;
    highp vec4 texelsWeightsB_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_19.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_19.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    texelsWeightsA_20.x = (0.081632 * tmpvar_25);
    texelsWeightsA_20.y = (0.081632 * computedAreaUncut_23.y);
    texelsWeightsA_20.z = (0.081632 * (computedAreaUncut_23.y + 1.0));
    texelsWeightsA_20.w = (0.081632 * (computedArea_22.y + 2.0));
    texelsWeightsB_21.x = (0.081632 * (computedArea_22.z + 2.0));
    texelsWeightsB_21.y = (0.081632 * (computedAreaUncut_23.z + 1.0));
    texelsWeightsB_21.z = (0.081632 * computedAreaUncut_23.z);
    texelsWeightsB_21.w = (0.081632 * tmpvar_24);
    highp vec4 texelsWeightsA_28;
    highp vec4 texelsWeightsB_29;
    highp vec4 computedArea_30;
    highp vec4 computedAreaUncut_31;
    highp float tmpvar_32;
    tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_33;
    tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
    computedArea_30.x = tmpvar_33;
    computedAreaUncut_31.x = tmpvar_33;
    computedArea_30.w = tmpvar_32;
    computedAreaUncut_31.w = tmpvar_32;
    computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = min (tmpvar_19.y, 0.0);
    computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
    computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = max (tmpvar_19.y, 0.0);
    computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
    texelsWeightsA_28.x = (0.081632 * tmpvar_33);
    texelsWeightsA_28.y = (0.081632 * computedAreaUncut_31.y);
    texelsWeightsA_28.z = (0.081632 * (computedAreaUncut_31.y + 1.0));
    texelsWeightsA_28.w = (0.081632 * (computedArea_30.y + 2.0));
    texelsWeightsB_29.x = (0.081632 * (computedArea_30.z + 2.0));
    texelsWeightsB_29.y = (0.081632 * (computedAreaUncut_31.z + 1.0));
    texelsWeightsB_29.z = (0.081632 * computedAreaUncut_31.z);
    texelsWeightsB_29.w = (0.081632 * tmpvar_32);
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_20.xz;
    tmpvar_36.zw = texelsWeightsB_21.xz;
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_20.yw;
    tmpvar_37.zw = texelsWeightsB_21.yw;
    highp vec4 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_28.xz;
    tmpvar_39.zw = texelsWeightsB_29.xz;
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_28.yw;
    tmpvar_40.zw = texelsWeightsB_29.yw;
    highp vec4 tmpvar_41;
    tmpvar_41 = (tmpvar_39 + tmpvar_40);
    highp vec4 tmpvar_42;
    tmpvar_42.xy = texelsWeightsA_20.yw;
    tmpvar_42.zw = texelsWeightsB_21.yw;
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_28.yw;
    tmpvar_43.zw = texelsWeightsB_29.yw;
    fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_44;
    tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_15.x;
    tmpvar_45.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
    tmpvar_46.z = shadowCoord_12.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_15.y;
    tmpvar_48.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
    tmpvar_49.z = shadowCoord_12.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_15.z;
    tmpvar_51.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
    tmpvar_52.z = shadowCoord_12.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_15.w;
    tmpvar_54.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
    tmpvar_55.z = shadowCoord_12.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.x) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_15.x;
    tmpvar_57.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
    tmpvar_58.z = shadowCoord_12.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_15.y;
    tmpvar_60.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
    tmpvar_61.z = shadowCoord_12.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_15.z;
    tmpvar_63.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
    tmpvar_64.z = shadowCoord_12.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_15.w;
    tmpvar_66.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
    tmpvar_67.z = shadowCoord_12.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.y) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_15.x;
    tmpvar_69.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
    tmpvar_70.z = shadowCoord_12.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_15.y;
    tmpvar_72.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_44 + tmpvar_72);
    tmpvar_73.z = shadowCoord_12.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_15.z;
    tmpvar_75.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_44 + tmpvar_75);
    tmpvar_76.z = shadowCoord_12.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_15.w;
    tmpvar_78.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_44 + tmpvar_78);
    tmpvar_79.z = shadowCoord_12.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.z) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_15.x;
    tmpvar_81.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_44 + tmpvar_81);
    tmpvar_82.z = shadowCoord_12.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.w) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_15.y;
    tmpvar_84.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_44 + tmpvar_84);
    tmpvar_85.z = shadowCoord_12.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.w) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_15.z;
    tmpvar_87.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_44 + tmpvar_87);
    tmpvar_88.z = shadowCoord_12.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.w) * tmpvar_89));
    highp vec2 tmpvar_90;
    tmpvar_90.x = fetchesOffsetsU_15.w;
    tmpvar_90.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_91;
    tmpvar_91.xy = (tmpvar_44 + tmpvar_90);
    tmpvar_91.z = shadowCoord_12.z;
    mediump float tmpvar_92;
    tmpvar_92 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_91);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.w) * tmpvar_92));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_93;
  tmpvar_93.x = xlv_TEXCOORD1.w;
  tmpvar_93.y = xlv_TEXCOORD2.w;
  tmpvar_93.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_94;
  tmpvar_94 = (CAMERA_WORLDPOSITION - tmpvar_93);
  highp vec3 tmpvar_95;
  tmpvar_95 = normalize(tmpvar_94);
  lowp vec3 tmpvar_96;
  tmpvar_96 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_96;
  highp vec3 tmpvar_97;
  tmpvar_97 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_98;
    highp float len_99;
    highp float tileCount_100;
    tileCount_100 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_101;
    tmpvar_101 = max (0.0, tileCount_100);
    tileCount_100 = tmpvar_101;
    highp float tmpvar_102;
    if ((tmpvar_101 > 0.0)) {
      tmpvar_102 = 1.0;
    } else {
      tmpvar_102 = 0.0;
    };
    len_99 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_94, tmpvar_94)
    )));
    highp float tmpvar_103;
    tmpvar_103 = clamp (len_99, 0.0, 1.0);
    len_99 = tmpvar_103;
    lowp vec2 tmpvar_104;
    tmpvar_104 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_98 = tmpvar_104;
    highp vec3 tmpvar_105;
    tmpvar_105.z = 0.0;
    tmpvar_105.xy = texNormal_98;
    bkgNormal_10.z = tmpvar_105.z;
    bkgNormal_10.xy = (((
      (texNormal_98 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_103, tmpvar_102));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_106;
    highp vec2 patternNormal_107;
    lowp vec2 tmpvar_108;
    tmpvar_108 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_107 = tmpvar_108;
    highp vec3 tmpvar_109;
    tmpvar_109.z = 0.0;
    tmpvar_109.xy = ((patternNormal_107 * 2.0) - 1.0);
    patternNormal1_106.xy = tmpvar_109.xy;
    patternNormal1_106.z = sqrt((1.0 - dot (tmpvar_109.xy, tmpvar_109.xy)));
    lowp vec4 tmpvar_110;
    tmpvar_110 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_106, vec3((mainNormal_11.z * tmpvar_110.w)));
  };
  n1_9 = (tmpvar_97 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_111;
  tmpvar_111 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_111;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_111);
  };
  highp vec3 tmpvar_112;
  tmpvar_112 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_113;
  tmpvar_113 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_114;
  tmpvar_114 = max (dot (tmpvar_112, tmpvar_95), 0.0);
  highp float tmpvar_115;
  tmpvar_115 = max (dot (tmpvar_112, normalize(
    (tmpvar_95 + tmpvar_113)
  )), 0.0);
  lowp vec3 tmpvar_116;
  tmpvar_116 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_6 = tmpvar_116;
  lowp vec3 tmpvar_117;
  tmpvar_117 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_5 = tmpvar_117;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_118;
    lowp vec4 tmpvar_119;
    tmpvar_119 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_118 = tmpvar_119;
    bgTintColor_5 = mix (bgTintColor_5, patternAlbedo_118.xyz, vec3((mainNormal_11.z * patternAlbedo_118.w)));
  };
  mainColor_6 = (mainColor_6 * bgTintColor_5);
  mainColor_6 = (mainColor_6 * mainColor_6);
  highp float tmpvar_120;
  tmpvar_120 = dot (tmpvar_112, tmpvar_113);
  lowp vec4 tmpvar_121;
  tmpvar_121 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_122;
  tmpvar_122.x = Metallic;
  tmpvar_122.y = Smoothness;
  highp vec2 tmpvar_123;
  tmpvar_123 = (tmpvar_121.xy * tmpvar_122);
  highp vec2 tmpvar_124;
  tmpvar_124 = (vec2(1.0, 1.0) - tmpvar_123.yx);
  highp float tmpvar_125;
  tmpvar_125 = (1.0 - tmpvar_114);
  fresnel_4 = (tmpvar_125 * tmpvar_125);
  fresnel_4 = (fresnel_4 * fresnel_4);
  highp float tmpvar_126;
  tmpvar_126 = max ((tmpvar_124.x * tmpvar_124.x), 0.1);
  highp float tmpvar_127;
  tmpvar_127 = (tmpvar_126 * tmpvar_126);
  highp float tmpvar_128;
  tmpvar_128 = (((
    (tmpvar_115 * tmpvar_127)
   - tmpvar_115) * tmpvar_115) + 1.0);
  d_3 = ((0.3183099 * tmpvar_127) / ((tmpvar_128 * tmpvar_128) + 1e-7));
  highp float tmpvar_129;
  tmpvar_129 = min (d_3, 100.0);
  d_3 = tmpvar_129;
  highp float tmpvar_130;
  tmpvar_130 = mix (0.2209163, 1.0, tmpvar_123.x);
  finalCol_2.xyz = (((
    (((max (tmpvar_120, 0.0) * LIGHT_COLOR) * vec3(tmpvar_13)) + AMBIENT_COLOR)
   * mainColor_6) * tmpvar_124.y) + ((
    (((tmpvar_129 * (tmpvar_130 + 
      ((1.0 - tmpvar_130) * fresnel_4)
    )) * max ((
      (tmpvar_120 + 1.0)
     * 0.5), 0.0)) * SpecularColor.xyz)
   * LIGHT_COLOR) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_6, tmpvar_123.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 SpecularColor;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float d_3;
  highp float fresnel_4;
  highp vec3 bgTintColor_5;
  highp vec3 mainColor_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    highp vec2 tmpvar_14;
    tmpvar_14.x = LIGHT_PARAM.z;
    tmpvar_14.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_15;
    tmpvar_15.xy = tmpvar_14;
    highp float tmpvar_16;
    tmpvar_16 = (1.0/(LIGHT_PARAM.z));
    tmpvar_15.z = tmpvar_16;
    tmpvar_15.w = tmpvar_16;
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = tmpvar_15.xy;
    shadow_17 = 0.0;
    highp vec3 tmpvar_19;
    tmpvar_19.xy = (shadowCoord_12.xy - LIGHT_PARAM.zz);
    tmpvar_19.z = shadowCoord_12.z;
    highp vec4 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_19.xy);
    highp float tmpvar_21;
    if ((tmpvar_20.x < xlv_TEXCOORD4.z)) {
      tmpvar_21 = 0.0;
    } else {
      tmpvar_21 = 1.0;
    };
    shadow_17 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_12.xy + tmpvar_22);
    tmpvar_23.z = shadowCoord_12.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_17 = (tmpvar_21 + tmpvar_25);
    highp vec2 tmpvar_26;
    tmpvar_26.x = tmpvar_18.x;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_12.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_12.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.y = 0.0;
    tmpvar_30.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_12.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_12.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_33);
    highp vec4 tmpvar_34;
    tmpvar_34 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_12.xy);
    highp float tmpvar_35;
    if ((tmpvar_34.x < xlv_TEXCOORD4.z)) {
      tmpvar_35 = 0.0;
    } else {
      tmpvar_35 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_35);
    highp vec2 tmpvar_36;
    tmpvar_36.y = 0.0;
    tmpvar_36.x = tmpvar_18.x;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (shadowCoord_12.xy + tmpvar_36);
    tmpvar_37.z = shadowCoord_12.z;
    highp vec4 tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = -(LIGHT_PARAM.z);
    tmpvar_40.y = tmpvar_18.y;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_12.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = 0.0;
    tmpvar_44.y = tmpvar_18.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_12.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_12.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_47);
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (shadowCoord_12.xy + LIGHT_PARAM.zz);
    tmpvar_48.z = shadowCoord_12.z;
    highp vec4 tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48.xy);
    highp float tmpvar_50;
    if ((tmpvar_49.x < xlv_TEXCOORD4.z)) {
      tmpvar_50 = 0.0;
    } else {
      tmpvar_50 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_50);
    shadow_17 = (shadow_17 / 9.0);
    tmpvar_13 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_51;
  tmpvar_51.x = xlv_TEXCOORD1.w;
  tmpvar_51.y = xlv_TEXCOORD2.w;
  tmpvar_51.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_52;
  tmpvar_52 = (CAMERA_WORLDPOSITION - tmpvar_51);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(tmpvar_52);
  lowp vec3 tmpvar_54;
  tmpvar_54 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_54;
  highp vec3 tmpvar_55;
  tmpvar_55 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_56;
    highp float len_57;
    highp float tileCount_58;
    tileCount_58 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_59;
    tmpvar_59 = max (0.0, tileCount_58);
    tileCount_58 = tmpvar_59;
    highp float tmpvar_60;
    if ((tmpvar_59 > 0.0)) {
      tmpvar_60 = 1.0;
    } else {
      tmpvar_60 = 0.0;
    };
    len_57 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_52, tmpvar_52)
    )));
    highp float tmpvar_61;
    tmpvar_61 = clamp (len_57, 0.0, 1.0);
    len_57 = tmpvar_61;
    lowp vec2 tmpvar_62;
    tmpvar_62 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_56 = tmpvar_62;
    highp vec3 tmpvar_63;
    tmpvar_63.z = 0.0;
    tmpvar_63.xy = texNormal_56;
    bkgNormal_10.z = tmpvar_63.z;
    bkgNormal_10.xy = (((
      (texNormal_56 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_61, tmpvar_60));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_64;
    highp vec2 patternNormal_65;
    lowp vec2 tmpvar_66;
    tmpvar_66 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_65 = tmpvar_66;
    highp vec3 tmpvar_67;
    tmpvar_67.z = 0.0;
    tmpvar_67.xy = ((patternNormal_65 * 2.0) - 1.0);
    patternNormal1_64.xy = tmpvar_67.xy;
    patternNormal1_64.z = sqrt((1.0 - dot (tmpvar_67.xy, tmpvar_67.xy)));
    lowp vec4 tmpvar_68;
    tmpvar_68 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_64, vec3((mainNormal_11.z * tmpvar_68.w)));
  };
  n1_9 = (tmpvar_55 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_69;
  tmpvar_69 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_69;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_69);
  };
  highp vec3 tmpvar_70;
  tmpvar_70 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_71;
  tmpvar_71 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_72;
  tmpvar_72 = max (dot (tmpvar_70, tmpvar_53), 0.0);
  highp float tmpvar_73;
  tmpvar_73 = max (dot (tmpvar_70, normalize(
    (tmpvar_53 + tmpvar_71)
  )), 0.0);
  lowp vec3 tmpvar_74;
  tmpvar_74 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_6 = tmpvar_74;
  lowp vec3 tmpvar_75;
  tmpvar_75 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_5 = tmpvar_75;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_76;
    lowp vec4 tmpvar_77;
    tmpvar_77 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_76 = tmpvar_77;
    bgTintColor_5 = mix (bgTintColor_5, patternAlbedo_76.xyz, vec3((mainNormal_11.z * patternAlbedo_76.w)));
  };
  mainColor_6 = (mainColor_6 * bgTintColor_5);
  mainColor_6 = (mainColor_6 * mainColor_6);
  highp float tmpvar_78;
  tmpvar_78 = dot (tmpvar_70, tmpvar_71);
  lowp vec4 tmpvar_79;
  tmpvar_79 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_80;
  tmpvar_80.x = Metallic;
  tmpvar_80.y = Smoothness;
  highp vec2 tmpvar_81;
  tmpvar_81 = (tmpvar_79.xy * tmpvar_80);
  highp vec2 tmpvar_82;
  tmpvar_82 = (vec2(1.0, 1.0) - tmpvar_81.yx);
  highp float tmpvar_83;
  tmpvar_83 = (1.0 - tmpvar_72);
  fresnel_4 = (tmpvar_83 * tmpvar_83);
  fresnel_4 = (fresnel_4 * fresnel_4);
  highp float tmpvar_84;
  tmpvar_84 = max ((tmpvar_82.x * tmpvar_82.x), 0.1);
  highp float tmpvar_85;
  tmpvar_85 = (tmpvar_84 * tmpvar_84);
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_73 * tmpvar_85)
   - tmpvar_73) * tmpvar_73) + 1.0);
  d_3 = ((0.3183099 * tmpvar_85) / ((tmpvar_86 * tmpvar_86) + 1e-7));
  highp float tmpvar_87;
  tmpvar_87 = min (d_3, 100.0);
  d_3 = tmpvar_87;
  highp float tmpvar_88;
  tmpvar_88 = mix (0.2209163, 1.0, tmpvar_81.x);
  finalCol_2.xyz = (((
    (((max (tmpvar_78, 0.0) * LIGHT_COLOR) * vec3(tmpvar_13)) + AMBIENT_COLOR)
   * mainColor_6) * tmpvar_82.y) + ((
    (((tmpvar_87 * (tmpvar_88 + 
      ((1.0 - tmpvar_88) * fresnel_4)
    )) * max ((
      (tmpvar_78 + 1.0)
     * 0.5), 0.0)) * SpecularColor.xyz)
   * LIGHT_COLOR) * mix (vec3(0.2209163, 0.2209163, 0.2209163), mainColor_6, tmpvar_81.xxx)));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
}


end

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_19))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_1.xyz;
  tmpvar_8.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_20)).z);
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (LOCALWORLD_TRANSFORM * tmpvar_19).xyz;
  tmpvar_8.w = 1.0;
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (LOCALWORLD_TRANSFORM * tmpvar_19).xyz;
  tmpvar_8.w = 1.0;
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (LOCALWORLD_TRANSFORM * tmpvar_19).xyz;
  tmpvar_8.w = 1.0;
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_11)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_16 * _glesNormal));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_17 * _glesTangent));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_18 * _glesBinormal));
  tmpvar_5.w = tmpvar_15.x;
  tmpvar_6.w = tmpvar_15.y;
  tmpvar_7.w = tmpvar_15.z;
  highp vec4 tmpvar_19;
  tmpvar_19.w = 1.0;
  tmpvar_19.xyz = tmpvar_1.xyz;
  tmpvar_8.xyz = (LOCALWORLD_TRANSFORM * tmpvar_19).xyz;
  tmpvar_8.w = 1.0;
  if ((Patternuv32 > 0.0)) {
    tmpvar_9.zw = tmpvar_2;
  } else {
    tmpvar_9.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_10.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_10.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_13;
  xlv_TEXCOORD4 = tmpvar_8;
  xlv_TEXCOORD5 = tmpvar_9;
  xlv_TEXCOORD6 = tmpvar_10;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Bkguv02",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Patternuv32",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgTintTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgMaterialTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternAlbedoTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PatternNormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FBkgNormalIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UseBkgNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternAlbedo",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UsePatternNormal",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BkgScaleOffset",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 BkgScaleOffset;
uniform highp float Bkguv02;
uniform highp float Patternuv32;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD5;
out highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord2.xy;
  highp vec2 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord3.xy;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10)));
  tmpvar_4.xy = _glesMultiTexCoord0.xy;
  tmpvar_4.zw = _glesMultiTexCoord1.xy;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_5.xyz = normalize((tmpvar_15 * _glesNormal));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_6.xyz = normalize((tmpvar_16 * _glesTangent));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_7.xyz = normalize((tmpvar_17 * _glesBinormal));
  tmpvar_5.w = tmpvar_14.x;
  tmpvar_6.w = tmpvar_14.y;
  tmpvar_7.w = tmpvar_14.z;
  if ((Patternuv32 > 0.0)) {
    tmpvar_8.zw = tmpvar_2;
  } else {
    tmpvar_8.zw = tmpvar_3;
  };
  if ((Bkguv02 > 0.0)) {
    tmpvar_9.xy = ((_glesMultiTexCoord2.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  } else {
    tmpvar_9.xy = ((_glesMultiTexCoord0.xy * BkgScaleOffset.xy) + BkgScaleOffset.zw);
  };
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD3 = tmpvar_7;
  gl_Position = tmpvar_12;
  xlv_TEXCOORD5 = tmpvar_8;
  xlv_TEXCOORD6 = tmpvar_9;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D BkgTintTex;
uniform sampler2D BkgMaterialTex;
uniform sampler2D BkgNormalTex;
uniform sampler2D PatternAlbedoTex;
uniform sampler2D PatternNormalTex;
uniform highp float FBkgNormalIntensity;
uniform highp float Metallic;
uniform highp float Smoothness;
uniform highp float UseBkgNormal;
uniform highp float UsePatternAlbedo;
uniform highp float UsePatternNormal;
uniform highp vec4 BkgScaleOffset;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD5;
in highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec4 finalCol_2;
  highp float nl2_3;
  highp vec3 bgTintColor_4;
  highp vec3 mainColor_5;
  highp float backLightingWeight_6;
  highp vec3 blendedNormal_7;
  highp vec3 n2_8;
  highp vec3 n1_9;
  highp vec3 bkgNormal_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = (CAMERA_WORLDPOSITION - tmpvar_12);
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (NormalTexture, xlv_TEXCOORD0.xy).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  bkgNormal_10 = vec3(0.0, 0.0, 1.0);
  if ((UseBkgNormal > 0.0)) {
    highp vec2 texNormal_16;
    highp float len_17;
    highp float tileCount_18;
    tileCount_18 = (min (abs(BkgScaleOffset.x), abs(BkgScaleOffset.y)) - 20.0);
    highp float tmpvar_19;
    tmpvar_19 = max (0.0, tileCount_18);
    tileCount_18 = tmpvar_19;
    highp float tmpvar_20;
    if ((tmpvar_19 > 0.0)) {
      tmpvar_20 = 1.0;
    } else {
      tmpvar_20 = 0.0;
    };
    len_17 = (0.9333333 - (0.3333333 * sqrt(
      dot (tmpvar_13, tmpvar_13)
    )));
    highp float tmpvar_21;
    tmpvar_21 = clamp (len_17, 0.0, 1.0);
    len_17 = tmpvar_21;
    lowp vec2 tmpvar_22;
    tmpvar_22 = texture (BkgNormalTex, xlv_TEXCOORD6.xy).xy;
    texNormal_16 = tmpvar_22;
    highp vec3 tmpvar_23;
    tmpvar_23.z = 0.0;
    tmpvar_23.xy = texNormal_16;
    bkgNormal_10.z = tmpvar_23.z;
    bkgNormal_10.xy = (((
      (texNormal_16 * 2.0)
     - 1.0) * FBkgNormalIntensity) * mix (1.0, tmpvar_21, tmpvar_20));
    bkgNormal_10.z = sqrt((1.0 - min (
      dot (bkgNormal_10.xy, bkgNormal_10.xy)
    , 1.0)));
  };
  if ((UsePatternNormal > 0.0)) {
    highp vec3 patternNormal1_24;
    highp vec2 patternNormal_25;
    lowp vec2 tmpvar_26;
    tmpvar_26 = texture (PatternNormalTex, xlv_TEXCOORD6.xy).xy;
    patternNormal_25 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27.z = 0.0;
    tmpvar_27.xy = ((patternNormal_25 * 2.0) - 1.0);
    patternNormal1_24.xy = tmpvar_27.xy;
    patternNormal1_24.z = sqrt((1.0 - dot (tmpvar_27.xy, tmpvar_27.xy)));
    lowp vec4 tmpvar_28;
    tmpvar_28 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    bkgNormal_10 = mix (bkgNormal_10, patternNormal1_24, vec3((mainNormal_11.z * tmpvar_28.w)));
  };
  n1_9 = (tmpvar_15 + vec3(0.0, 0.0, 1.0));
  n2_8 = (bkgNormal_10 * vec3(-1.0, -1.0, 1.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (((n1_9 * 
    dot (n1_9, n2_8)
  ) / n1_9.z) - n2_8);
  blendedNormal_7 = tmpvar_29;
  backLightingWeight_6 = 1.0;
  if (!(bool(tmpvar_1))) {
    blendedNormal_7 = -(tmpvar_29);
    backLightingWeight_6 = 0.0;
  };
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(((
    (blendedNormal_7.x * xlv_TEXCOORD2.xyz)
   + 
    (blendedNormal_7.y * xlv_TEXCOORD3.xyz)
  ) + (blendedNormal_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_31;
  tmpvar_31 = -(LIGHT_GIVEN_DIRECTION);
  lowp vec3 tmpvar_32;
  tmpvar_32 = texture (MainTex, xlv_TEXCOORD0.xy).xyz;
  mainColor_5 = tmpvar_32;
  lowp vec3 tmpvar_33;
  tmpvar_33 = texture (BkgTintTex, xlv_TEXCOORD0.zw).xyz;
  bgTintColor_4 = tmpvar_33;
  if ((UsePatternAlbedo > 0.0)) {
    highp vec4 patternAlbedo_34;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (PatternAlbedoTex, xlv_TEXCOORD5.zw);
    patternAlbedo_34 = tmpvar_35;
    bgTintColor_4 = mix (bgTintColor_4, patternAlbedo_34.xyz, vec3((mainNormal_11.z * patternAlbedo_34.w)));
  };
  mainColor_5 = (mainColor_5 * bgTintColor_4);
  mainColor_5 = (mainColor_5 * mainColor_5);
  highp float tmpvar_36;
  tmpvar_36 = max (((
    dot (tmpvar_30, tmpvar_31)
   + 0.5) * 0.7), 0.0);
  nl2_3 = (tmpvar_36 * tmpvar_36);
  nl2_3 = (nl2_3 * nl2_3);
  nl2_3 = (nl2_3 * nl2_3);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture (BkgMaterialTex, xlv_TEXCOORD0.zw);
  highp vec2 tmpvar_38;
  tmpvar_38.x = Metallic;
  tmpvar_38.y = Smoothness;
  finalCol_2.xyz = ((nl2_3 * LIGHT_COLOR) * ((backLightingWeight_6 * mainColor_5) * (vec2(1.0, 1.0) - 
    (tmpvar_37.xy * tmpvar_38)
  .yx).y));
  finalCol_2.w = 1.0;
  _glesFragData[0] = finalCol_2;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end