function DefineParams()
	Properties = 
	{
		
diffuseTex = { "diffuseTex", TEXTURE2D, "white" },
specularTex = {"specularTex", TEXTURE2D, "white"},

baseColor = {"baseColor", COLOR, "0.0,0.0,0.0,1.0"},
DistrubIntensity = { "DistrubIntensity", FLOAT, "0.5" },
Fresnel = { "Fresnel", FLOAT, "0.5" },

shadeColor = {"shadeColor", COLOR, "0.0,0.0,0.0,1.0"},
shift1 = { "shift1", FLOAT, "0.5" },
shift2 = { "shift2", FLOAT, "0.5" },
smoothness1 = { "smoothness1", FLOAT, "0.5" },
smoothness2 = { "smoothness2", FLOAT, "0.5" },
DefSpecular1 = { "DefSpecular1", COLOR, "1.0,1.0,1.0, 1.0" },
DefSpecular2 = { "DefSpecular2", COLOR, "1.0,1.0,1.0, 1.0" },


	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "DollHair"
RenderQueue = "Transparent"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10.x = xlv_TEXCOORD1.w;
  tmpvar_10.y = xlv_TEXCOORD2.w;
  tmpvar_10.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize((CAMERA_WORLDPOSITION - tmpvar_10));
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_12;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_13;
  tmpvar_13 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_13 * tmpvar_13)
  , 0.0001)) - 2.0);
  highp float tmpvar_14;
  tmpvar_14 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize((tmpvar_11 + tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_16, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_9 * vec3(shift2))
  )));
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_18;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_9)
  )));
  highp vec4 tmpvar_20;
  tmpvar_20.xyz = shadeColor.xyz;
  tmpvar_20.w = smoothness1;
  highp vec4 tmpvar_21;
  tmpvar_21 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_20);
  sw_5 = (tmpvar_21.w * tmpvar_21.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_17 * tmpvar_17))
    , 0.0)), tmpvar_14))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_19 * tmpvar_19)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_11, tmpvar_9), 0.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (VDotN_3 * VDotN_3);
  highp float tmpvar_23;
  tmpvar_23 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_22 * tmpvar_22) * VDotN_3)
   * 
    (1.0 - tmpvar_23)
  ) + tmpvar_23)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = max (0.0, abs(dot (tmpvar_15, tmpvar_9)));
  highp float tmpvar_24;
  tmpvar_24 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_24;
  highp vec3 tmpvar_25;
  tmpvar_25 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_21.xyz * vec3(tmpvar_24))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_25 * tmpvar_25));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_26.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_26;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10.x = xlv_TEXCOORD1.w;
  tmpvar_10.y = xlv_TEXCOORD2.w;
  tmpvar_10.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize((CAMERA_WORLDPOSITION - tmpvar_10));
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_12;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_13;
  tmpvar_13 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_13 * tmpvar_13)
  , 0.0001)) - 2.0);
  highp float tmpvar_14;
  tmpvar_14 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize((tmpvar_11 + tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_16, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_9 * vec3(shift2))
  )));
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_18;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_9)
  )));
  highp vec4 tmpvar_20;
  tmpvar_20.xyz = shadeColor.xyz;
  tmpvar_20.w = smoothness1;
  highp vec4 tmpvar_21;
  tmpvar_21 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_20);
  sw_5 = (tmpvar_21.w * tmpvar_21.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_17 * tmpvar_17))
    , 0.0)), tmpvar_14))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_19 * tmpvar_19)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_11, tmpvar_9), 0.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (VDotN_3 * VDotN_3);
  highp float tmpvar_23;
  tmpvar_23 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_22 * tmpvar_22) * VDotN_3)
   * 
    (1.0 - tmpvar_23)
  ) + tmpvar_23)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = max (0.0, abs(dot (tmpvar_15, tmpvar_9)));
  highp float tmpvar_24;
  tmpvar_24 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_24;
  highp vec3 tmpvar_25;
  tmpvar_25 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_21.xyz * vec3(tmpvar_24))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_25 * tmpvar_25));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_26.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_26;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec4 shadowCoord_9;
  shadowCoord_9 = xlv_TEXCOORD4;
  highp float tmpvar_10;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_10 = 1.0;
  } else {
    shadowCoord_9.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_11;
    highp vec2 fetchesOffsetsU_12;
    highp float shadow_13;
    highp vec2 tmpvar_14;
    tmpvar_14 = (shadowCoord_9.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_15;
    tmpvar_15 = floor((tmpvar_14 + 0.5));
    highp vec2 tmpvar_16;
    tmpvar_16 = (tmpvar_14 - tmpvar_15);
    highp vec4 computedWeight_17;
    highp vec4 computedArea_18;
    highp vec4 computedAreaUncut_19;
    highp float tmpvar_20;
    tmpvar_20 = (((tmpvar_16.x + 0.5) * (tmpvar_16.x + 0.5)) * 0.5);
    highp float tmpvar_21;
    tmpvar_21 = (tmpvar_20 - tmpvar_16.x);
    computedArea_18.x = tmpvar_21;
    computedAreaUncut_19.x = tmpvar_21;
    computedArea_18.w = tmpvar_20;
    computedAreaUncut_19.w = tmpvar_20;
    computedAreaUncut_19.y = ((1.5 - tmpvar_16.x) - 0.5);
    highp float tmpvar_22;
    tmpvar_22 = min (tmpvar_16.x, 0.0);
    computedArea_18.y = (computedAreaUncut_19.y - (tmpvar_22 * tmpvar_22));
    computedAreaUncut_19.z = ((1.5 + tmpvar_16.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = max (tmpvar_16.x, 0.0);
    computedArea_18.z = (computedAreaUncut_19.z - (tmpvar_23 * tmpvar_23));
    computedWeight_17 = (computedArea_18 * 0.44444);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_16.y + 0.5) * (tmpvar_16.y + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_16.y);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_16.y) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_16.y, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_16.y) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_16.y, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec2 tmpvar_31;
    tmpvar_31 = (computedWeight_17.xz + computedWeight_17.yw);
    highp vec2 tmpvar_32;
    tmpvar_32 = (computedWeight_24.xz + computedWeight_24.yw);
    fetchesOffsetsU_12 = (((computedWeight_17.yw / tmpvar_31) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_11 = (((computedWeight_24.yw / tmpvar_32) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_33;
    tmpvar_33 = (tmpvar_15 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_34;
    tmpvar_34.x = fetchesOffsetsU_12.x;
    tmpvar_34.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (tmpvar_33 + tmpvar_34);
    tmpvar_35.z = shadowCoord_9.z;
    mediump float tmpvar_36;
    tmpvar_36 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_35);
    shadow_13 = ((tmpvar_31.x * tmpvar_32.x) * tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_12.y;
    tmpvar_37.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_33 + tmpvar_37);
    tmpvar_38.z = shadowCoord_9.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_13 = (shadow_13 + ((tmpvar_31.y * tmpvar_32.x) * tmpvar_39));
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_12.x;
    tmpvar_40.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_33 + tmpvar_40);
    tmpvar_41.z = shadowCoord_9.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_13 = (shadow_13 + ((tmpvar_31.x * tmpvar_32.y) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_12.y;
    tmpvar_43.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_33 + tmpvar_43);
    tmpvar_44.z = shadowCoord_9.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_13 = (shadow_13 + ((tmpvar_31.y * tmpvar_32.y) * tmpvar_45));
    tmpvar_10 = mix (1.0, shadow_13, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_46;
  tmpvar_46 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_47;
  tmpvar_47.x = xlv_TEXCOORD1.w;
  tmpvar_47.y = xlv_TEXCOORD2.w;
  tmpvar_47.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_48;
  tmpvar_48 = normalize((CAMERA_WORLDPOSITION - tmpvar_47));
  lowp vec4 tmpvar_49;
  tmpvar_49 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_49;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_50;
  tmpvar_50 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_50 * tmpvar_50)
  , 0.0001)) - 2.0);
  highp float tmpvar_51;
  tmpvar_51 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize((tmpvar_48 + tmpvar_52));
  highp float tmpvar_54;
  tmpvar_54 = dot (tmpvar_53, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_46 * vec3(shift2))
  )));
  lowp vec4 tmpvar_55;
  tmpvar_55 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_55;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_56;
  tmpvar_56 = dot (tmpvar_53, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_46)
  )));
  highp vec4 tmpvar_57;
  tmpvar_57.xyz = shadeColor.xyz;
  tmpvar_57.w = smoothness1;
  highp vec4 tmpvar_58;
  tmpvar_58 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_57);
  sw_5 = (tmpvar_58.w * tmpvar_58.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_54 * tmpvar_54))
    , 0.0)), tmpvar_51))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_56 * tmpvar_56)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_48, tmpvar_46), 0.0, 1.0));
  highp float tmpvar_59;
  tmpvar_59 = (VDotN_3 * VDotN_3);
  highp float tmpvar_60;
  tmpvar_60 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_59 * tmpvar_59) * VDotN_3)
   * 
    (1.0 - tmpvar_60)
  ) + tmpvar_60)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = (max (0.0, abs(
    dot (tmpvar_52, tmpvar_46)
  )) * tmpvar_10);
  highp float tmpvar_61;
  tmpvar_61 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_61;
  highp vec3 tmpvar_62;
  tmpvar_62 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_58.xyz * vec3(tmpvar_61))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_62 * tmpvar_62));
  highp vec4 tmpvar_63;
  tmpvar_63.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_63.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_63;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec4 shadowCoord_9;
  shadowCoord_9 = xlv_TEXCOORD4;
  highp float tmpvar_10;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_10 = 1.0;
  } else {
    shadowCoord_9.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_11;
    highp vec3 fetchesOffsetsU_12;
    highp float shadow_13;
    highp vec2 tmpvar_14;
    tmpvar_14 = (shadowCoord_9.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_15;
    tmpvar_15 = floor((tmpvar_14 + 0.5));
    highp vec2 tmpvar_16;
    tmpvar_16 = (tmpvar_14 - tmpvar_15);
    highp vec3 texelsWeightsA_17;
    highp vec3 texelsWeightsB_18;
    highp vec4 computedArea_19;
    highp vec4 computedAreaUncut_20;
    highp float tmpvar_21;
    tmpvar_21 = (((tmpvar_16.x + 0.5) * (tmpvar_16.x + 0.5)) * 0.5);
    highp float tmpvar_22;
    tmpvar_22 = (tmpvar_21 - tmpvar_16.x);
    computedArea_19.x = tmpvar_22;
    computedAreaUncut_20.x = tmpvar_22;
    computedArea_19.w = tmpvar_21;
    computedAreaUncut_20.w = tmpvar_21;
    computedAreaUncut_20.y = ((1.5 - tmpvar_16.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = min (tmpvar_16.x, 0.0);
    computedArea_19.y = (computedAreaUncut_20.y - (tmpvar_23 * tmpvar_23));
    computedAreaUncut_20.z = ((1.5 + tmpvar_16.x) - 0.5);
    highp float tmpvar_24;
    tmpvar_24 = max (tmpvar_16.x, 0.0);
    computedArea_19.z = (computedAreaUncut_20.z - (tmpvar_24 * tmpvar_24));
    texelsWeightsA_17.x = (0.16 * tmpvar_22);
    texelsWeightsA_17.y = (0.16 * computedAreaUncut_20.y);
    texelsWeightsA_17.z = (0.16 * (computedArea_19.y + 1.0));
    texelsWeightsB_18.x = (0.16 * (computedArea_19.z + 1.0));
    texelsWeightsB_18.y = (0.16 * computedAreaUncut_20.z);
    texelsWeightsB_18.z = (0.16 * tmpvar_21);
    highp vec3 texelsWeightsA_25;
    highp vec3 texelsWeightsB_26;
    highp vec4 computedArea_27;
    highp vec4 computedAreaUncut_28;
    highp float tmpvar_29;
    tmpvar_29 = (((tmpvar_16.y + 0.5) * (tmpvar_16.y + 0.5)) * 0.5);
    highp float tmpvar_30;
    tmpvar_30 = (tmpvar_29 - tmpvar_16.y);
    computedArea_27.x = tmpvar_30;
    computedAreaUncut_28.x = tmpvar_30;
    computedArea_27.w = tmpvar_29;
    computedAreaUncut_28.w = tmpvar_29;
    computedAreaUncut_28.y = ((1.5 - tmpvar_16.y) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = min (tmpvar_16.y, 0.0);
    computedArea_27.y = (computedAreaUncut_28.y - (tmpvar_31 * tmpvar_31));
    computedAreaUncut_28.z = ((1.5 + tmpvar_16.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = max (tmpvar_16.y, 0.0);
    computedArea_27.z = (computedAreaUncut_28.z - (tmpvar_32 * tmpvar_32));
    texelsWeightsA_25.x = (0.16 * tmpvar_30);
    texelsWeightsA_25.y = (0.16 * computedAreaUncut_28.y);
    texelsWeightsA_25.z = (0.16 * (computedArea_27.y + 1.0));
    texelsWeightsB_26.x = (0.16 * (computedArea_27.z + 1.0));
    texelsWeightsB_26.y = (0.16 * computedAreaUncut_28.z);
    texelsWeightsB_26.z = (0.16 * tmpvar_29);
    highp vec3 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_17.xz;
    tmpvar_33.z = texelsWeightsB_18.y;
    highp vec3 tmpvar_34;
    tmpvar_34.x = texelsWeightsA_17.y;
    tmpvar_34.yz = texelsWeightsB_18.xz;
    highp vec3 tmpvar_35;
    tmpvar_35 = (tmpvar_33 + tmpvar_34);
    highp vec3 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_25.xz;
    tmpvar_36.z = texelsWeightsB_26.y;
    highp vec3 tmpvar_37;
    tmpvar_37.x = texelsWeightsA_25.y;
    tmpvar_37.yz = texelsWeightsB_26.xz;
    highp vec3 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec3 tmpvar_39;
    tmpvar_39.x = texelsWeightsA_17.y;
    tmpvar_39.yz = texelsWeightsB_18.xz;
    highp vec3 tmpvar_40;
    tmpvar_40.x = texelsWeightsA_25.y;
    tmpvar_40.yz = texelsWeightsB_26.xz;
    fetchesOffsetsU_12 = (((tmpvar_39 / tmpvar_35) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_11 = (((tmpvar_40 / tmpvar_38) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_15 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_42;
    tmpvar_42.x = fetchesOffsetsU_12.x;
    tmpvar_42.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (tmpvar_41 + tmpvar_42);
    tmpvar_43.z = shadowCoord_9.z;
    mediump float tmpvar_44;
    tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43);
    shadow_13 = ((tmpvar_35.x * tmpvar_38.x) * tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_12.y;
    tmpvar_45.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_41 + tmpvar_45);
    tmpvar_46.z = shadowCoord_9.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.x) * tmpvar_47));
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_12.z;
    tmpvar_48.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_41 + tmpvar_48);
    tmpvar_49.z = shadowCoord_9.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_12.x;
    tmpvar_51.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_41 + tmpvar_51);
    tmpvar_52.z = shadowCoord_9.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.y) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_12.y;
    tmpvar_54.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_41 + tmpvar_54);
    tmpvar_55.z = shadowCoord_9.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.y) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_12.z;
    tmpvar_57.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_41 + tmpvar_57);
    tmpvar_58.z = shadowCoord_9.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_12.x;
    tmpvar_60.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_41 + tmpvar_60);
    tmpvar_61.z = shadowCoord_9.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.z) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_12.y;
    tmpvar_63.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_41 + tmpvar_63);
    tmpvar_64.z = shadowCoord_9.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.z) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_12.z;
    tmpvar_66.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_41 + tmpvar_66);
    tmpvar_67.z = shadowCoord_9.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.z) * tmpvar_68));
    tmpvar_10 = mix (1.0, shadow_13, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_69;
  tmpvar_69 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_70;
  tmpvar_70.x = xlv_TEXCOORD1.w;
  tmpvar_70.y = xlv_TEXCOORD2.w;
  tmpvar_70.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_71;
  tmpvar_71 = normalize((CAMERA_WORLDPOSITION - tmpvar_70));
  lowp vec4 tmpvar_72;
  tmpvar_72 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_72;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_73;
  tmpvar_73 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_73 * tmpvar_73)
  , 0.0001)) - 2.0);
  highp float tmpvar_74;
  tmpvar_74 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_74;
  highp vec3 tmpvar_75;
  tmpvar_75 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_76;
  tmpvar_76 = normalize((tmpvar_71 + tmpvar_75));
  highp float tmpvar_77;
  tmpvar_77 = dot (tmpvar_76, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_69 * vec3(shift2))
  )));
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_78;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_79;
  tmpvar_79 = dot (tmpvar_76, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_69)
  )));
  highp vec4 tmpvar_80;
  tmpvar_80.xyz = shadeColor.xyz;
  tmpvar_80.w = smoothness1;
  highp vec4 tmpvar_81;
  tmpvar_81 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_80);
  sw_5 = (tmpvar_81.w * tmpvar_81.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_77 * tmpvar_77))
    , 0.0)), tmpvar_74))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_79 * tmpvar_79)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_71, tmpvar_69), 0.0, 1.0));
  highp float tmpvar_82;
  tmpvar_82 = (VDotN_3 * VDotN_3);
  highp float tmpvar_83;
  tmpvar_83 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_82 * tmpvar_82) * VDotN_3)
   * 
    (1.0 - tmpvar_83)
  ) + tmpvar_83)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = (max (0.0, abs(
    dot (tmpvar_75, tmpvar_69)
  )) * tmpvar_10);
  highp float tmpvar_84;
  tmpvar_84 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_84;
  highp vec3 tmpvar_85;
  tmpvar_85 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_81.xyz * vec3(tmpvar_84))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_85 * tmpvar_85));
  highp vec4 tmpvar_86;
  tmpvar_86.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_86.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_86;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec4 shadowCoord_9;
  shadowCoord_9 = xlv_TEXCOORD4;
  highp float tmpvar_10;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_10 = 1.0;
  } else {
    shadowCoord_9.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_11;
    highp vec4 fetchesOffsetsU_12;
    highp float shadow_13;
    highp vec2 tmpvar_14;
    tmpvar_14 = (shadowCoord_9.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_15;
    tmpvar_15 = floor((tmpvar_14 + 0.5));
    highp vec2 tmpvar_16;
    tmpvar_16 = (tmpvar_14 - tmpvar_15);
    highp vec4 texelsWeightsA_17;
    highp vec4 texelsWeightsB_18;
    highp vec4 computedArea_19;
    highp vec4 computedAreaUncut_20;
    highp float tmpvar_21;
    tmpvar_21 = (((tmpvar_16.x + 0.5) * (tmpvar_16.x + 0.5)) * 0.5);
    highp float tmpvar_22;
    tmpvar_22 = (tmpvar_21 - tmpvar_16.x);
    computedArea_19.x = tmpvar_22;
    computedAreaUncut_20.x = tmpvar_22;
    computedArea_19.w = tmpvar_21;
    computedAreaUncut_20.w = tmpvar_21;
    computedAreaUncut_20.y = ((1.5 - tmpvar_16.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = min (tmpvar_16.x, 0.0);
    computedArea_19.y = (computedAreaUncut_20.y - (tmpvar_23 * tmpvar_23));
    computedAreaUncut_20.z = ((1.5 + tmpvar_16.x) - 0.5);
    highp float tmpvar_24;
    tmpvar_24 = max (tmpvar_16.x, 0.0);
    computedArea_19.z = (computedAreaUncut_20.z - (tmpvar_24 * tmpvar_24));
    texelsWeightsA_17.x = (0.081632 * tmpvar_22);
    texelsWeightsA_17.y = (0.081632 * computedAreaUncut_20.y);
    texelsWeightsA_17.z = (0.081632 * (computedAreaUncut_20.y + 1.0));
    texelsWeightsA_17.w = (0.081632 * (computedArea_19.y + 2.0));
    texelsWeightsB_18.x = (0.081632 * (computedArea_19.z + 2.0));
    texelsWeightsB_18.y = (0.081632 * (computedAreaUncut_20.z + 1.0));
    texelsWeightsB_18.z = (0.081632 * computedAreaUncut_20.z);
    texelsWeightsB_18.w = (0.081632 * tmpvar_21);
    highp vec4 texelsWeightsA_25;
    highp vec4 texelsWeightsB_26;
    highp vec4 computedArea_27;
    highp vec4 computedAreaUncut_28;
    highp float tmpvar_29;
    tmpvar_29 = (((tmpvar_16.y + 0.5) * (tmpvar_16.y + 0.5)) * 0.5);
    highp float tmpvar_30;
    tmpvar_30 = (tmpvar_29 - tmpvar_16.y);
    computedArea_27.x = tmpvar_30;
    computedAreaUncut_28.x = tmpvar_30;
    computedArea_27.w = tmpvar_29;
    computedAreaUncut_28.w = tmpvar_29;
    computedAreaUncut_28.y = ((1.5 - tmpvar_16.y) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = min (tmpvar_16.y, 0.0);
    computedArea_27.y = (computedAreaUncut_28.y - (tmpvar_31 * tmpvar_31));
    computedAreaUncut_28.z = ((1.5 + tmpvar_16.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = max (tmpvar_16.y, 0.0);
    computedArea_27.z = (computedAreaUncut_28.z - (tmpvar_32 * tmpvar_32));
    texelsWeightsA_25.x = (0.081632 * tmpvar_30);
    texelsWeightsA_25.y = (0.081632 * computedAreaUncut_28.y);
    texelsWeightsA_25.z = (0.081632 * (computedAreaUncut_28.y + 1.0));
    texelsWeightsA_25.w = (0.081632 * (computedArea_27.y + 2.0));
    texelsWeightsB_26.x = (0.081632 * (computedArea_27.z + 2.0));
    texelsWeightsB_26.y = (0.081632 * (computedAreaUncut_28.z + 1.0));
    texelsWeightsB_26.z = (0.081632 * computedAreaUncut_28.z);
    texelsWeightsB_26.w = (0.081632 * tmpvar_29);
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_17.xz;
    tmpvar_33.zw = texelsWeightsB_18.xz;
    highp vec4 tmpvar_34;
    tmpvar_34.xy = texelsWeightsA_17.yw;
    tmpvar_34.zw = texelsWeightsB_18.yw;
    highp vec4 tmpvar_35;
    tmpvar_35 = (tmpvar_33 + tmpvar_34);
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_25.xz;
    tmpvar_36.zw = texelsWeightsB_26.xz;
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_25.yw;
    tmpvar_37.zw = texelsWeightsB_26.yw;
    highp vec4 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_17.yw;
    tmpvar_39.zw = texelsWeightsB_18.yw;
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_25.yw;
    tmpvar_40.zw = texelsWeightsB_26.yw;
    fetchesOffsetsU_12 = (((tmpvar_39 / tmpvar_35) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_11 = (((tmpvar_40 / tmpvar_38) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_15 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_42;
    tmpvar_42.x = fetchesOffsetsU_12.x;
    tmpvar_42.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (tmpvar_41 + tmpvar_42);
    tmpvar_43.z = shadowCoord_9.z;
    mediump float tmpvar_44;
    tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43);
    shadow_13 = ((tmpvar_35.x * tmpvar_38.x) * tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_12.y;
    tmpvar_45.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_41 + tmpvar_45);
    tmpvar_46.z = shadowCoord_9.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.x) * tmpvar_47));
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_12.z;
    tmpvar_48.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_41 + tmpvar_48);
    tmpvar_49.z = shadowCoord_9.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_12.w;
    tmpvar_51.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_41 + tmpvar_51);
    tmpvar_52.z = shadowCoord_9.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_13 = (shadow_13 + ((tmpvar_35.w * tmpvar_38.x) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_12.x;
    tmpvar_54.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_41 + tmpvar_54);
    tmpvar_55.z = shadowCoord_9.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.y) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_12.y;
    tmpvar_57.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_41 + tmpvar_57);
    tmpvar_58.z = shadowCoord_9.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_12.z;
    tmpvar_60.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_41 + tmpvar_60);
    tmpvar_61.z = shadowCoord_9.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.y) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_12.w;
    tmpvar_63.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_41 + tmpvar_63);
    tmpvar_64.z = shadowCoord_9.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_13 = (shadow_13 + ((tmpvar_35.w * tmpvar_38.y) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_12.x;
    tmpvar_66.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_41 + tmpvar_66);
    tmpvar_67.z = shadowCoord_9.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.z) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_12.y;
    tmpvar_69.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_41 + tmpvar_69);
    tmpvar_70.z = shadowCoord_9.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.z) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_12.z;
    tmpvar_72.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_41 + tmpvar_72);
    tmpvar_73.z = shadowCoord_9.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.z) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_12.w;
    tmpvar_75.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_41 + tmpvar_75);
    tmpvar_76.z = shadowCoord_9.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_13 = (shadow_13 + ((tmpvar_35.w * tmpvar_38.z) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_12.x;
    tmpvar_78.y = fetchesOffsetsV_11.w;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_41 + tmpvar_78);
    tmpvar_79.z = shadowCoord_9.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.w) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_12.y;
    tmpvar_81.y = fetchesOffsetsV_11.w;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_41 + tmpvar_81);
    tmpvar_82.z = shadowCoord_9.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.w) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_12.z;
    tmpvar_84.y = fetchesOffsetsV_11.w;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_41 + tmpvar_84);
    tmpvar_85.z = shadowCoord_9.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.w) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_12.w;
    tmpvar_87.y = fetchesOffsetsV_11.w;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_41 + tmpvar_87);
    tmpvar_88.z = shadowCoord_9.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_13 = (shadow_13 + ((tmpvar_35.w * tmpvar_38.w) * tmpvar_89));
    tmpvar_10 = mix (1.0, shadow_13, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_90;
  tmpvar_90 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_91;
  tmpvar_91.x = xlv_TEXCOORD1.w;
  tmpvar_91.y = xlv_TEXCOORD2.w;
  tmpvar_91.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_92;
  tmpvar_92 = normalize((CAMERA_WORLDPOSITION - tmpvar_91));
  lowp vec4 tmpvar_93;
  tmpvar_93 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_93;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_94;
  tmpvar_94 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_94 * tmpvar_94)
  , 0.0001)) - 2.0);
  highp float tmpvar_95;
  tmpvar_95 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_95;
  highp vec3 tmpvar_96;
  tmpvar_96 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_97;
  tmpvar_97 = normalize((tmpvar_92 + tmpvar_96));
  highp float tmpvar_98;
  tmpvar_98 = dot (tmpvar_97, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_90 * vec3(shift2))
  )));
  lowp vec4 tmpvar_99;
  tmpvar_99 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_99;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_100;
  tmpvar_100 = dot (tmpvar_97, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_90)
  )));
  highp vec4 tmpvar_101;
  tmpvar_101.xyz = shadeColor.xyz;
  tmpvar_101.w = smoothness1;
  highp vec4 tmpvar_102;
  tmpvar_102 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_101);
  sw_5 = (tmpvar_102.w * tmpvar_102.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_98 * tmpvar_98))
    , 0.0)), tmpvar_95))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_100 * tmpvar_100)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_92, tmpvar_90), 0.0, 1.0));
  highp float tmpvar_103;
  tmpvar_103 = (VDotN_3 * VDotN_3);
  highp float tmpvar_104;
  tmpvar_104 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_103 * tmpvar_103) * VDotN_3)
   * 
    (1.0 - tmpvar_104)
  ) + tmpvar_104)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = (max (0.0, abs(
    dot (tmpvar_96, tmpvar_90)
  )) * tmpvar_10);
  highp float tmpvar_105;
  tmpvar_105 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_105;
  highp vec3 tmpvar_106;
  tmpvar_106 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_102.xyz * vec3(tmpvar_105))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_106 * tmpvar_106));
  highp vec4 tmpvar_107;
  tmpvar_107.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_107.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_107;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec4 shadowCoord_9;
  shadowCoord_9 = xlv_TEXCOORD4;
  highp float tmpvar_10;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_10 = 1.0;
  } else {
    highp vec2 tmpvar_11;
    tmpvar_11.x = LIGHT_PARAM.z;
    tmpvar_11.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_12;
    tmpvar_12.xy = tmpvar_11;
    highp float tmpvar_13;
    tmpvar_13 = (1.0/(LIGHT_PARAM.z));
    tmpvar_12.z = tmpvar_13;
    tmpvar_12.w = tmpvar_13;
    shadowCoord_9.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_14;
    highp vec2 tmpvar_15;
    tmpvar_15 = tmpvar_12.xy;
    shadow_14 = 0.0;
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_9.xy - LIGHT_PARAM.zz);
    tmpvar_16.z = shadowCoord_9.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_14 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.x = 0.0;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_9.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_9.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_14 = (tmpvar_18 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.x = tmpvar_15.x;
    tmpvar_23.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_9.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_9.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_26);
    highp vec2 tmpvar_27;
    tmpvar_27.y = 0.0;
    tmpvar_27.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_28;
    tmpvar_28.xy = (shadowCoord_9.xy + tmpvar_27);
    tmpvar_28.z = shadowCoord_9.z;
    highp vec4 tmpvar_29;
    tmpvar_29 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_28.xy);
    highp float tmpvar_30;
    if ((tmpvar_29.x < xlv_TEXCOORD4.z)) {
      tmpvar_30 = 0.0;
    } else {
      tmpvar_30 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_30);
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_9.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.y = 0.0;
    tmpvar_33.x = tmpvar_15.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_9.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_9.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = -(LIGHT_PARAM.z);
    tmpvar_37.y = tmpvar_15.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_9.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_9.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = 0.0;
    tmpvar_41.y = tmpvar_15.y;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_9.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_9.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_44);
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_9.xy + LIGHT_PARAM.zz);
    tmpvar_45.z = shadowCoord_9.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_47);
    shadow_14 = (shadow_14 / 9.0);
    tmpvar_10 = mix (1.0, shadow_14, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_48;
  tmpvar_48 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec4 tmpvar_51;
  tmpvar_51 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_51;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_52;
  tmpvar_52 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_52 * tmpvar_52)
  , 0.0001)) - 2.0);
  highp float tmpvar_53;
  tmpvar_53 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize((tmpvar_50 + tmpvar_54));
  highp float tmpvar_56;
  tmpvar_56 = dot (tmpvar_55, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_48 * vec3(shift2))
  )));
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_57;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_58;
  tmpvar_58 = dot (tmpvar_55, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_48)
  )));
  highp vec4 tmpvar_59;
  tmpvar_59.xyz = shadeColor.xyz;
  tmpvar_59.w = smoothness1;
  highp vec4 tmpvar_60;
  tmpvar_60 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_59);
  sw_5 = (tmpvar_60.w * tmpvar_60.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_56 * tmpvar_56))
    , 0.0)), tmpvar_53))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_58 * tmpvar_58)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_50, tmpvar_48), 0.0, 1.0));
  highp float tmpvar_61;
  tmpvar_61 = (VDotN_3 * VDotN_3);
  highp float tmpvar_62;
  tmpvar_62 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_61 * tmpvar_61) * VDotN_3)
   * 
    (1.0 - tmpvar_62)
  ) + tmpvar_62)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = (max (0.0, abs(
    dot (tmpvar_54, tmpvar_48)
  )) * tmpvar_10);
  highp float tmpvar_63;
  tmpvar_63 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_60.xyz * vec3(tmpvar_63))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_64 * tmpvar_64));
  highp vec4 tmpvar_65;
  tmpvar_65.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_65.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_65;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10.x = xlv_TEXCOORD1.w;
  tmpvar_10.y = xlv_TEXCOORD2.w;
  tmpvar_10.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize((CAMERA_WORLDPOSITION - tmpvar_10));
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_12;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_13;
  tmpvar_13 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_13 * tmpvar_13)
  , 0.0001)) - 2.0);
  highp float tmpvar_14;
  tmpvar_14 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize((tmpvar_11 + tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_16, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_9 * vec3(shift2))
  )));
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_18;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_9)
  )));
  highp vec4 tmpvar_20;
  tmpvar_20.xyz = shadeColor.xyz;
  tmpvar_20.w = smoothness1;
  highp vec4 tmpvar_21;
  tmpvar_21 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_20);
  sw_5 = (tmpvar_21.w * tmpvar_21.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_17 * tmpvar_17))
    , 0.0)), tmpvar_14))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_19 * tmpvar_19)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_11, tmpvar_9), 0.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (VDotN_3 * VDotN_3);
  highp float tmpvar_23;
  tmpvar_23 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_22 * tmpvar_22) * VDotN_3)
   * 
    (1.0 - tmpvar_23)
  ) + tmpvar_23)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = max (0.0, abs(dot (tmpvar_15, tmpvar_9)));
  highp float tmpvar_24;
  tmpvar_24 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_24;
  highp vec3 tmpvar_25;
  tmpvar_25 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_21.xyz * vec3(tmpvar_24))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_25 * tmpvar_25));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_26.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_26;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10.x = xlv_TEXCOORD1.w;
  tmpvar_10.y = xlv_TEXCOORD2.w;
  tmpvar_10.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize((CAMERA_WORLDPOSITION - tmpvar_10));
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_12;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_13;
  tmpvar_13 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_13 * tmpvar_13)
  , 0.0001)) - 2.0);
  highp float tmpvar_14;
  tmpvar_14 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize((tmpvar_11 + tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_16, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_9 * vec3(shift2))
  )));
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_18;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_9)
  )));
  highp vec4 tmpvar_20;
  tmpvar_20.xyz = shadeColor.xyz;
  tmpvar_20.w = smoothness1;
  highp vec4 tmpvar_21;
  tmpvar_21 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_20);
  sw_5 = (tmpvar_21.w * tmpvar_21.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_17 * tmpvar_17))
    , 0.0)), tmpvar_14))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_19 * tmpvar_19)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_11, tmpvar_9), 0.0, 1.0));
  highp float tmpvar_22;
  tmpvar_22 = (VDotN_3 * VDotN_3);
  highp float tmpvar_23;
  tmpvar_23 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_22 * tmpvar_22) * VDotN_3)
   * 
    (1.0 - tmpvar_23)
  ) + tmpvar_23)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = max (0.0, abs(dot (tmpvar_15, tmpvar_9)));
  highp float tmpvar_24;
  tmpvar_24 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_24;
  highp vec3 tmpvar_25;
  tmpvar_25 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_21.xyz * vec3(tmpvar_24))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_25 * tmpvar_25));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_26.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_26;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec4 shadowCoord_9;
  shadowCoord_9 = xlv_TEXCOORD4;
  highp float tmpvar_10;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_10 = 1.0;
  } else {
    shadowCoord_9.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_11;
    highp vec2 fetchesOffsetsU_12;
    highp float shadow_13;
    highp vec2 tmpvar_14;
    tmpvar_14 = (shadowCoord_9.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_15;
    tmpvar_15 = floor((tmpvar_14 + 0.5));
    highp vec2 tmpvar_16;
    tmpvar_16 = (tmpvar_14 - tmpvar_15);
    highp vec4 computedWeight_17;
    highp vec4 computedArea_18;
    highp vec4 computedAreaUncut_19;
    highp float tmpvar_20;
    tmpvar_20 = (((tmpvar_16.x + 0.5) * (tmpvar_16.x + 0.5)) * 0.5);
    highp float tmpvar_21;
    tmpvar_21 = (tmpvar_20 - tmpvar_16.x);
    computedArea_18.x = tmpvar_21;
    computedAreaUncut_19.x = tmpvar_21;
    computedArea_18.w = tmpvar_20;
    computedAreaUncut_19.w = tmpvar_20;
    computedAreaUncut_19.y = ((1.5 - tmpvar_16.x) - 0.5);
    highp float tmpvar_22;
    tmpvar_22 = min (tmpvar_16.x, 0.0);
    computedArea_18.y = (computedAreaUncut_19.y - (tmpvar_22 * tmpvar_22));
    computedAreaUncut_19.z = ((1.5 + tmpvar_16.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = max (tmpvar_16.x, 0.0);
    computedArea_18.z = (computedAreaUncut_19.z - (tmpvar_23 * tmpvar_23));
    computedWeight_17 = (computedArea_18 * 0.44444);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_16.y + 0.5) * (tmpvar_16.y + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_16.y);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_16.y) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_16.y, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_16.y) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_16.y, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec2 tmpvar_31;
    tmpvar_31 = (computedWeight_17.xz + computedWeight_17.yw);
    highp vec2 tmpvar_32;
    tmpvar_32 = (computedWeight_24.xz + computedWeight_24.yw);
    fetchesOffsetsU_12 = (((computedWeight_17.yw / tmpvar_31) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_11 = (((computedWeight_24.yw / tmpvar_32) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_33;
    tmpvar_33 = (tmpvar_15 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_34;
    tmpvar_34.x = fetchesOffsetsU_12.x;
    tmpvar_34.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (tmpvar_33 + tmpvar_34);
    tmpvar_35.z = shadowCoord_9.z;
    mediump float tmpvar_36;
    tmpvar_36 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_35);
    shadow_13 = ((tmpvar_31.x * tmpvar_32.x) * tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_12.y;
    tmpvar_37.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_33 + tmpvar_37);
    tmpvar_38.z = shadowCoord_9.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_13 = (shadow_13 + ((tmpvar_31.y * tmpvar_32.x) * tmpvar_39));
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_12.x;
    tmpvar_40.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_33 + tmpvar_40);
    tmpvar_41.z = shadowCoord_9.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_13 = (shadow_13 + ((tmpvar_31.x * tmpvar_32.y) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_12.y;
    tmpvar_43.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_33 + tmpvar_43);
    tmpvar_44.z = shadowCoord_9.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_13 = (shadow_13 + ((tmpvar_31.y * tmpvar_32.y) * tmpvar_45));
    tmpvar_10 = mix (1.0, shadow_13, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_46;
  tmpvar_46 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_47;
  tmpvar_47.x = xlv_TEXCOORD1.w;
  tmpvar_47.y = xlv_TEXCOORD2.w;
  tmpvar_47.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_48;
  tmpvar_48 = normalize((CAMERA_WORLDPOSITION - tmpvar_47));
  lowp vec4 tmpvar_49;
  tmpvar_49 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_49;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_50;
  tmpvar_50 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_50 * tmpvar_50)
  , 0.0001)) - 2.0);
  highp float tmpvar_51;
  tmpvar_51 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize((tmpvar_48 + tmpvar_52));
  highp float tmpvar_54;
  tmpvar_54 = dot (tmpvar_53, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_46 * vec3(shift2))
  )));
  lowp vec4 tmpvar_55;
  tmpvar_55 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_55;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_56;
  tmpvar_56 = dot (tmpvar_53, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_46)
  )));
  highp vec4 tmpvar_57;
  tmpvar_57.xyz = shadeColor.xyz;
  tmpvar_57.w = smoothness1;
  highp vec4 tmpvar_58;
  tmpvar_58 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_57);
  sw_5 = (tmpvar_58.w * tmpvar_58.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_54 * tmpvar_54))
    , 0.0)), tmpvar_51))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_56 * tmpvar_56)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_48, tmpvar_46), 0.0, 1.0));
  highp float tmpvar_59;
  tmpvar_59 = (VDotN_3 * VDotN_3);
  highp float tmpvar_60;
  tmpvar_60 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_59 * tmpvar_59) * VDotN_3)
   * 
    (1.0 - tmpvar_60)
  ) + tmpvar_60)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = (max (0.0, abs(
    dot (tmpvar_52, tmpvar_46)
  )) * tmpvar_10);
  highp float tmpvar_61;
  tmpvar_61 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_61;
  highp vec3 tmpvar_62;
  tmpvar_62 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_58.xyz * vec3(tmpvar_61))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_62 * tmpvar_62));
  highp vec4 tmpvar_63;
  tmpvar_63.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_63.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_63;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec4 shadowCoord_9;
  shadowCoord_9 = xlv_TEXCOORD4;
  highp float tmpvar_10;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_10 = 1.0;
  } else {
    shadowCoord_9.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_11;
    highp vec3 fetchesOffsetsU_12;
    highp float shadow_13;
    highp vec2 tmpvar_14;
    tmpvar_14 = (shadowCoord_9.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_15;
    tmpvar_15 = floor((tmpvar_14 + 0.5));
    highp vec2 tmpvar_16;
    tmpvar_16 = (tmpvar_14 - tmpvar_15);
    highp vec3 texelsWeightsA_17;
    highp vec3 texelsWeightsB_18;
    highp vec4 computedArea_19;
    highp vec4 computedAreaUncut_20;
    highp float tmpvar_21;
    tmpvar_21 = (((tmpvar_16.x + 0.5) * (tmpvar_16.x + 0.5)) * 0.5);
    highp float tmpvar_22;
    tmpvar_22 = (tmpvar_21 - tmpvar_16.x);
    computedArea_19.x = tmpvar_22;
    computedAreaUncut_20.x = tmpvar_22;
    computedArea_19.w = tmpvar_21;
    computedAreaUncut_20.w = tmpvar_21;
    computedAreaUncut_20.y = ((1.5 - tmpvar_16.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = min (tmpvar_16.x, 0.0);
    computedArea_19.y = (computedAreaUncut_20.y - (tmpvar_23 * tmpvar_23));
    computedAreaUncut_20.z = ((1.5 + tmpvar_16.x) - 0.5);
    highp float tmpvar_24;
    tmpvar_24 = max (tmpvar_16.x, 0.0);
    computedArea_19.z = (computedAreaUncut_20.z - (tmpvar_24 * tmpvar_24));
    texelsWeightsA_17.x = (0.16 * tmpvar_22);
    texelsWeightsA_17.y = (0.16 * computedAreaUncut_20.y);
    texelsWeightsA_17.z = (0.16 * (computedArea_19.y + 1.0));
    texelsWeightsB_18.x = (0.16 * (computedArea_19.z + 1.0));
    texelsWeightsB_18.y = (0.16 * computedAreaUncut_20.z);
    texelsWeightsB_18.z = (0.16 * tmpvar_21);
    highp vec3 texelsWeightsA_25;
    highp vec3 texelsWeightsB_26;
    highp vec4 computedArea_27;
    highp vec4 computedAreaUncut_28;
    highp float tmpvar_29;
    tmpvar_29 = (((tmpvar_16.y + 0.5) * (tmpvar_16.y + 0.5)) * 0.5);
    highp float tmpvar_30;
    tmpvar_30 = (tmpvar_29 - tmpvar_16.y);
    computedArea_27.x = tmpvar_30;
    computedAreaUncut_28.x = tmpvar_30;
    computedArea_27.w = tmpvar_29;
    computedAreaUncut_28.w = tmpvar_29;
    computedAreaUncut_28.y = ((1.5 - tmpvar_16.y) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = min (tmpvar_16.y, 0.0);
    computedArea_27.y = (computedAreaUncut_28.y - (tmpvar_31 * tmpvar_31));
    computedAreaUncut_28.z = ((1.5 + tmpvar_16.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = max (tmpvar_16.y, 0.0);
    computedArea_27.z = (computedAreaUncut_28.z - (tmpvar_32 * tmpvar_32));
    texelsWeightsA_25.x = (0.16 * tmpvar_30);
    texelsWeightsA_25.y = (0.16 * computedAreaUncut_28.y);
    texelsWeightsA_25.z = (0.16 * (computedArea_27.y + 1.0));
    texelsWeightsB_26.x = (0.16 * (computedArea_27.z + 1.0));
    texelsWeightsB_26.y = (0.16 * computedAreaUncut_28.z);
    texelsWeightsB_26.z = (0.16 * tmpvar_29);
    highp vec3 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_17.xz;
    tmpvar_33.z = texelsWeightsB_18.y;
    highp vec3 tmpvar_34;
    tmpvar_34.x = texelsWeightsA_17.y;
    tmpvar_34.yz = texelsWeightsB_18.xz;
    highp vec3 tmpvar_35;
    tmpvar_35 = (tmpvar_33 + tmpvar_34);
    highp vec3 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_25.xz;
    tmpvar_36.z = texelsWeightsB_26.y;
    highp vec3 tmpvar_37;
    tmpvar_37.x = texelsWeightsA_25.y;
    tmpvar_37.yz = texelsWeightsB_26.xz;
    highp vec3 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec3 tmpvar_39;
    tmpvar_39.x = texelsWeightsA_17.y;
    tmpvar_39.yz = texelsWeightsB_18.xz;
    highp vec3 tmpvar_40;
    tmpvar_40.x = texelsWeightsA_25.y;
    tmpvar_40.yz = texelsWeightsB_26.xz;
    fetchesOffsetsU_12 = (((tmpvar_39 / tmpvar_35) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_11 = (((tmpvar_40 / tmpvar_38) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_15 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_42;
    tmpvar_42.x = fetchesOffsetsU_12.x;
    tmpvar_42.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (tmpvar_41 + tmpvar_42);
    tmpvar_43.z = shadowCoord_9.z;
    mediump float tmpvar_44;
    tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43);
    shadow_13 = ((tmpvar_35.x * tmpvar_38.x) * tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_12.y;
    tmpvar_45.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_41 + tmpvar_45);
    tmpvar_46.z = shadowCoord_9.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.x) * tmpvar_47));
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_12.z;
    tmpvar_48.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_41 + tmpvar_48);
    tmpvar_49.z = shadowCoord_9.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_12.x;
    tmpvar_51.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_41 + tmpvar_51);
    tmpvar_52.z = shadowCoord_9.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.y) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_12.y;
    tmpvar_54.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_41 + tmpvar_54);
    tmpvar_55.z = shadowCoord_9.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.y) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_12.z;
    tmpvar_57.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_41 + tmpvar_57);
    tmpvar_58.z = shadowCoord_9.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_12.x;
    tmpvar_60.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_41 + tmpvar_60);
    tmpvar_61.z = shadowCoord_9.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.z) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_12.y;
    tmpvar_63.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_41 + tmpvar_63);
    tmpvar_64.z = shadowCoord_9.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.z) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_12.z;
    tmpvar_66.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_41 + tmpvar_66);
    tmpvar_67.z = shadowCoord_9.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.z) * tmpvar_68));
    tmpvar_10 = mix (1.0, shadow_13, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_69;
  tmpvar_69 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_70;
  tmpvar_70.x = xlv_TEXCOORD1.w;
  tmpvar_70.y = xlv_TEXCOORD2.w;
  tmpvar_70.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_71;
  tmpvar_71 = normalize((CAMERA_WORLDPOSITION - tmpvar_70));
  lowp vec4 tmpvar_72;
  tmpvar_72 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_72;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_73;
  tmpvar_73 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_73 * tmpvar_73)
  , 0.0001)) - 2.0);
  highp float tmpvar_74;
  tmpvar_74 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_74;
  highp vec3 tmpvar_75;
  tmpvar_75 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_76;
  tmpvar_76 = normalize((tmpvar_71 + tmpvar_75));
  highp float tmpvar_77;
  tmpvar_77 = dot (tmpvar_76, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_69 * vec3(shift2))
  )));
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_78;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_79;
  tmpvar_79 = dot (tmpvar_76, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_69)
  )));
  highp vec4 tmpvar_80;
  tmpvar_80.xyz = shadeColor.xyz;
  tmpvar_80.w = smoothness1;
  highp vec4 tmpvar_81;
  tmpvar_81 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_80);
  sw_5 = (tmpvar_81.w * tmpvar_81.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_77 * tmpvar_77))
    , 0.0)), tmpvar_74))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_79 * tmpvar_79)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_71, tmpvar_69), 0.0, 1.0));
  highp float tmpvar_82;
  tmpvar_82 = (VDotN_3 * VDotN_3);
  highp float tmpvar_83;
  tmpvar_83 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_82 * tmpvar_82) * VDotN_3)
   * 
    (1.0 - tmpvar_83)
  ) + tmpvar_83)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = (max (0.0, abs(
    dot (tmpvar_75, tmpvar_69)
  )) * tmpvar_10);
  highp float tmpvar_84;
  tmpvar_84 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_84;
  highp vec3 tmpvar_85;
  tmpvar_85 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_81.xyz * vec3(tmpvar_84))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_85 * tmpvar_85));
  highp vec4 tmpvar_86;
  tmpvar_86.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_86.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_86;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec4 shadowCoord_9;
  shadowCoord_9 = xlv_TEXCOORD4;
  highp float tmpvar_10;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_10 = 1.0;
  } else {
    shadowCoord_9.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_11;
    highp vec4 fetchesOffsetsU_12;
    highp float shadow_13;
    highp vec2 tmpvar_14;
    tmpvar_14 = (shadowCoord_9.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_15;
    tmpvar_15 = floor((tmpvar_14 + 0.5));
    highp vec2 tmpvar_16;
    tmpvar_16 = (tmpvar_14 - tmpvar_15);
    highp vec4 texelsWeightsA_17;
    highp vec4 texelsWeightsB_18;
    highp vec4 computedArea_19;
    highp vec4 computedAreaUncut_20;
    highp float tmpvar_21;
    tmpvar_21 = (((tmpvar_16.x + 0.5) * (tmpvar_16.x + 0.5)) * 0.5);
    highp float tmpvar_22;
    tmpvar_22 = (tmpvar_21 - tmpvar_16.x);
    computedArea_19.x = tmpvar_22;
    computedAreaUncut_20.x = tmpvar_22;
    computedArea_19.w = tmpvar_21;
    computedAreaUncut_20.w = tmpvar_21;
    computedAreaUncut_20.y = ((1.5 - tmpvar_16.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = min (tmpvar_16.x, 0.0);
    computedArea_19.y = (computedAreaUncut_20.y - (tmpvar_23 * tmpvar_23));
    computedAreaUncut_20.z = ((1.5 + tmpvar_16.x) - 0.5);
    highp float tmpvar_24;
    tmpvar_24 = max (tmpvar_16.x, 0.0);
    computedArea_19.z = (computedAreaUncut_20.z - (tmpvar_24 * tmpvar_24));
    texelsWeightsA_17.x = (0.081632 * tmpvar_22);
    texelsWeightsA_17.y = (0.081632 * computedAreaUncut_20.y);
    texelsWeightsA_17.z = (0.081632 * (computedAreaUncut_20.y + 1.0));
    texelsWeightsA_17.w = (0.081632 * (computedArea_19.y + 2.0));
    texelsWeightsB_18.x = (0.081632 * (computedArea_19.z + 2.0));
    texelsWeightsB_18.y = (0.081632 * (computedAreaUncut_20.z + 1.0));
    texelsWeightsB_18.z = (0.081632 * computedAreaUncut_20.z);
    texelsWeightsB_18.w = (0.081632 * tmpvar_21);
    highp vec4 texelsWeightsA_25;
    highp vec4 texelsWeightsB_26;
    highp vec4 computedArea_27;
    highp vec4 computedAreaUncut_28;
    highp float tmpvar_29;
    tmpvar_29 = (((tmpvar_16.y + 0.5) * (tmpvar_16.y + 0.5)) * 0.5);
    highp float tmpvar_30;
    tmpvar_30 = (tmpvar_29 - tmpvar_16.y);
    computedArea_27.x = tmpvar_30;
    computedAreaUncut_28.x = tmpvar_30;
    computedArea_27.w = tmpvar_29;
    computedAreaUncut_28.w = tmpvar_29;
    computedAreaUncut_28.y = ((1.5 - tmpvar_16.y) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = min (tmpvar_16.y, 0.0);
    computedArea_27.y = (computedAreaUncut_28.y - (tmpvar_31 * tmpvar_31));
    computedAreaUncut_28.z = ((1.5 + tmpvar_16.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = max (tmpvar_16.y, 0.0);
    computedArea_27.z = (computedAreaUncut_28.z - (tmpvar_32 * tmpvar_32));
    texelsWeightsA_25.x = (0.081632 * tmpvar_30);
    texelsWeightsA_25.y = (0.081632 * computedAreaUncut_28.y);
    texelsWeightsA_25.z = (0.081632 * (computedAreaUncut_28.y + 1.0));
    texelsWeightsA_25.w = (0.081632 * (computedArea_27.y + 2.0));
    texelsWeightsB_26.x = (0.081632 * (computedArea_27.z + 2.0));
    texelsWeightsB_26.y = (0.081632 * (computedAreaUncut_28.z + 1.0));
    texelsWeightsB_26.z = (0.081632 * computedAreaUncut_28.z);
    texelsWeightsB_26.w = (0.081632 * tmpvar_29);
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_17.xz;
    tmpvar_33.zw = texelsWeightsB_18.xz;
    highp vec4 tmpvar_34;
    tmpvar_34.xy = texelsWeightsA_17.yw;
    tmpvar_34.zw = texelsWeightsB_18.yw;
    highp vec4 tmpvar_35;
    tmpvar_35 = (tmpvar_33 + tmpvar_34);
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_25.xz;
    tmpvar_36.zw = texelsWeightsB_26.xz;
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_25.yw;
    tmpvar_37.zw = texelsWeightsB_26.yw;
    highp vec4 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_17.yw;
    tmpvar_39.zw = texelsWeightsB_18.yw;
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_25.yw;
    tmpvar_40.zw = texelsWeightsB_26.yw;
    fetchesOffsetsU_12 = (((tmpvar_39 / tmpvar_35) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_11 = (((tmpvar_40 / tmpvar_38) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_15 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_42;
    tmpvar_42.x = fetchesOffsetsU_12.x;
    tmpvar_42.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (tmpvar_41 + tmpvar_42);
    tmpvar_43.z = shadowCoord_9.z;
    mediump float tmpvar_44;
    tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43);
    shadow_13 = ((tmpvar_35.x * tmpvar_38.x) * tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_12.y;
    tmpvar_45.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_41 + tmpvar_45);
    tmpvar_46.z = shadowCoord_9.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.x) * tmpvar_47));
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_12.z;
    tmpvar_48.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_41 + tmpvar_48);
    tmpvar_49.z = shadowCoord_9.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_12.w;
    tmpvar_51.y = fetchesOffsetsV_11.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_41 + tmpvar_51);
    tmpvar_52.z = shadowCoord_9.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_13 = (shadow_13 + ((tmpvar_35.w * tmpvar_38.x) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_12.x;
    tmpvar_54.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_41 + tmpvar_54);
    tmpvar_55.z = shadowCoord_9.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.y) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_12.y;
    tmpvar_57.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_41 + tmpvar_57);
    tmpvar_58.z = shadowCoord_9.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_12.z;
    tmpvar_60.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_41 + tmpvar_60);
    tmpvar_61.z = shadowCoord_9.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.y) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_12.w;
    tmpvar_63.y = fetchesOffsetsV_11.y;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_41 + tmpvar_63);
    tmpvar_64.z = shadowCoord_9.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_13 = (shadow_13 + ((tmpvar_35.w * tmpvar_38.y) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_12.x;
    tmpvar_66.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_41 + tmpvar_66);
    tmpvar_67.z = shadowCoord_9.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.z) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_12.y;
    tmpvar_69.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_41 + tmpvar_69);
    tmpvar_70.z = shadowCoord_9.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.z) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_12.z;
    tmpvar_72.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_41 + tmpvar_72);
    tmpvar_73.z = shadowCoord_9.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.z) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_12.w;
    tmpvar_75.y = fetchesOffsetsV_11.z;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_41 + tmpvar_75);
    tmpvar_76.z = shadowCoord_9.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_13 = (shadow_13 + ((tmpvar_35.w * tmpvar_38.z) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_12.x;
    tmpvar_78.y = fetchesOffsetsV_11.w;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_41 + tmpvar_78);
    tmpvar_79.z = shadowCoord_9.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_13 = (shadow_13 + ((tmpvar_35.x * tmpvar_38.w) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_12.y;
    tmpvar_81.y = fetchesOffsetsV_11.w;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_41 + tmpvar_81);
    tmpvar_82.z = shadowCoord_9.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_13 = (shadow_13 + ((tmpvar_35.y * tmpvar_38.w) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_12.z;
    tmpvar_84.y = fetchesOffsetsV_11.w;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_41 + tmpvar_84);
    tmpvar_85.z = shadowCoord_9.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_13 = (shadow_13 + ((tmpvar_35.z * tmpvar_38.w) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_12.w;
    tmpvar_87.y = fetchesOffsetsV_11.w;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_41 + tmpvar_87);
    tmpvar_88.z = shadowCoord_9.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_13 = (shadow_13 + ((tmpvar_35.w * tmpvar_38.w) * tmpvar_89));
    tmpvar_10 = mix (1.0, shadow_13, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_90;
  tmpvar_90 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_91;
  tmpvar_91.x = xlv_TEXCOORD1.w;
  tmpvar_91.y = xlv_TEXCOORD2.w;
  tmpvar_91.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_92;
  tmpvar_92 = normalize((CAMERA_WORLDPOSITION - tmpvar_91));
  lowp vec4 tmpvar_93;
  tmpvar_93 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_93;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_94;
  tmpvar_94 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_94 * tmpvar_94)
  , 0.0001)) - 2.0);
  highp float tmpvar_95;
  tmpvar_95 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_95;
  highp vec3 tmpvar_96;
  tmpvar_96 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_97;
  tmpvar_97 = normalize((tmpvar_92 + tmpvar_96));
  highp float tmpvar_98;
  tmpvar_98 = dot (tmpvar_97, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_90 * vec3(shift2))
  )));
  lowp vec4 tmpvar_99;
  tmpvar_99 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_99;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_100;
  tmpvar_100 = dot (tmpvar_97, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_90)
  )));
  highp vec4 tmpvar_101;
  tmpvar_101.xyz = shadeColor.xyz;
  tmpvar_101.w = smoothness1;
  highp vec4 tmpvar_102;
  tmpvar_102 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_101);
  sw_5 = (tmpvar_102.w * tmpvar_102.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_98 * tmpvar_98))
    , 0.0)), tmpvar_95))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_100 * tmpvar_100)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_92, tmpvar_90), 0.0, 1.0));
  highp float tmpvar_103;
  tmpvar_103 = (VDotN_3 * VDotN_3);
  highp float tmpvar_104;
  tmpvar_104 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_103 * tmpvar_103) * VDotN_3)
   * 
    (1.0 - tmpvar_104)
  ) + tmpvar_104)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = (max (0.0, abs(
    dot (tmpvar_96, tmpvar_90)
  )) * tmpvar_10);
  highp float tmpvar_105;
  tmpvar_105 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_105;
  highp vec3 tmpvar_106;
  tmpvar_106 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_102.xyz * vec3(tmpvar_105))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_106 * tmpvar_106));
  highp vec4 tmpvar_107;
  tmpvar_107.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_107.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_107;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 frontDiffuse_1;
  highp float maxldotn_2;
  highp float VDotN_3;
  highp vec3 compositeColor_4;
  highp float sw_5;
  highp vec4 specColor_6;
  highp float smoothness_7;
  highp vec4 albedo_8;
  highp vec4 shadowCoord_9;
  shadowCoord_9 = xlv_TEXCOORD4;
  highp float tmpvar_10;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_10 = 1.0;
  } else {
    highp vec2 tmpvar_11;
    tmpvar_11.x = LIGHT_PARAM.z;
    tmpvar_11.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_12;
    tmpvar_12.xy = tmpvar_11;
    highp float tmpvar_13;
    tmpvar_13 = (1.0/(LIGHT_PARAM.z));
    tmpvar_12.z = tmpvar_13;
    tmpvar_12.w = tmpvar_13;
    shadowCoord_9.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_14;
    highp vec2 tmpvar_15;
    tmpvar_15 = tmpvar_12.xy;
    shadow_14 = 0.0;
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_9.xy - LIGHT_PARAM.zz);
    tmpvar_16.z = shadowCoord_9.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_14 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.x = 0.0;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_9.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_9.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_14 = (tmpvar_18 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.x = tmpvar_15.x;
    tmpvar_23.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_9.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_9.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_26);
    highp vec2 tmpvar_27;
    tmpvar_27.y = 0.0;
    tmpvar_27.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_28;
    tmpvar_28.xy = (shadowCoord_9.xy + tmpvar_27);
    tmpvar_28.z = shadowCoord_9.z;
    highp vec4 tmpvar_29;
    tmpvar_29 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_28.xy);
    highp float tmpvar_30;
    if ((tmpvar_29.x < xlv_TEXCOORD4.z)) {
      tmpvar_30 = 0.0;
    } else {
      tmpvar_30 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_30);
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_9.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.y = 0.0;
    tmpvar_33.x = tmpvar_15.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_9.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_9.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = -(LIGHT_PARAM.z);
    tmpvar_37.y = tmpvar_15.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_9.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_9.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = 0.0;
    tmpvar_41.y = tmpvar_15.y;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_9.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_9.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_44);
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_9.xy + LIGHT_PARAM.zz);
    tmpvar_45.z = shadowCoord_9.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_14 = (shadow_14 + tmpvar_47);
    shadow_14 = (shadow_14 / 9.0);
    tmpvar_10 = mix (1.0, shadow_14, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_48;
  tmpvar_48 = normalize(xlv_TEXCOORD1.xyz);
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec4 tmpvar_51;
  tmpvar_51 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_8 = tmpvar_51;
  smoothness_7 = (1.0 - smoothness2);
  highp float tmpvar_52;
  tmpvar_52 = (smoothness_7 * smoothness_7);
  smoothness_7 = ((2.0 / max (
    (tmpvar_52 * tmpvar_52)
  , 0.0001)) - 2.0);
  highp float tmpvar_53;
  tmpvar_53 = max (smoothness_7, 0.0001);
  smoothness_7 = tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize((tmpvar_50 + tmpvar_54));
  highp float tmpvar_56;
  tmpvar_56 = dot (tmpvar_55, normalize((xlv_TEXCOORD2.xyz - 
    (tmpvar_48 * vec3(shift2))
  )));
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture (specularTex, xlv_TEXCOORD0);
  specColor_6 = tmpvar_57;
  sw_5 = (((
    (specColor_6.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_58;
  tmpvar_58 = dot (tmpvar_55, normalize((xlv_TEXCOORD2.xyz + 
    (sw_5 * tmpvar_48)
  )));
  highp vec4 tmpvar_59;
  tmpvar_59.xyz = shadeColor.xyz;
  tmpvar_59.w = smoothness1;
  highp vec4 tmpvar_60;
  tmpvar_60 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_59);
  sw_5 = (tmpvar_60.w * tmpvar_60.w);
  compositeColor_4 = (((DefSpecular2.xyz * vec3(
    (specColor_6.y * pow (sqrt(max (
      (1.0 - (tmpvar_56 * tmpvar_56))
    , 0.0)), tmpvar_53))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_58 * tmpvar_58)
    ), 0.0)), max (((2.0 / 
      max ((sw_5 * sw_5), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_6.xyz);
  compositeColor_4 = (compositeColor_4 * LIGHT_COLOR);
  VDotN_3 = (1.0 - clamp (dot (tmpvar_50, tmpvar_48), 0.0, 1.0));
  highp float tmpvar_61;
  tmpvar_61 = (VDotN_3 * VDotN_3);
  highp float tmpvar_62;
  tmpvar_62 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_4 = (compositeColor_4 * vec3(((
    ((tmpvar_61 * tmpvar_61) * VDotN_3)
   * 
    (1.0 - tmpvar_62)
  ) + tmpvar_62)));
  compositeColor_4 = (compositeColor_4 * specColor_6.xyz);
  maxldotn_2 = (max (0.0, abs(
    dot (tmpvar_54, tmpvar_48)
  )) * tmpvar_10);
  highp float tmpvar_63;
  tmpvar_63 = min (maxldotn_2, 1.0);
  maxldotn_2 = tmpvar_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = (baseColor.xyz * albedo_8.xyz);
  frontDiffuse_1 = (((
    (tmpvar_60.xyz * vec3(tmpvar_63))
   + shadeColor.xyz) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_1 = (frontDiffuse_1 * (tmpvar_64 * tmpvar_64));
  highp vec4 tmpvar_65;
  tmpvar_65.xyz = (compositeColor_4 + frontDiffuse_1);
  tmpvar_65.w = (albedo_8.w * baseColor.w);
  _glesFragData[0] = tmpvar_65;
}

]===],
	},
}


end

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_5;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_6;
  tmpvar_6 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_6 * tmpvar_6)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10 = (((specColor_2.yyy * LIGHT_COLOR) * (vec3(0.5, 0.5, 0.5) * vec3(tmpvar_8))) * (tmpvar_9 * tmpvar_9));
  backDiffuse_1 = (tmpvar_10 / (tmpvar_10 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_8));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_7;
    highp vec2 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 computedWeight_13;
    highp vec4 computedArea_14;
    highp vec4 computedAreaUncut_15;
    highp float tmpvar_16;
    tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
    computedArea_14.x = tmpvar_17;
    computedAreaUncut_15.x = tmpvar_17;
    computedArea_14.w = tmpvar_16;
    computedAreaUncut_15.w = tmpvar_16;
    computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_18;
    tmpvar_18 = min (tmpvar_12.x, 0.0);
    computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
    computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = max (tmpvar_12.x, 0.0);
    computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
    computedWeight_13 = (computedArea_14 * 0.44444);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_12.y, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_12.y, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec2 tmpvar_27;
    tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
    highp vec2 tmpvar_28;
    tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
    fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_29;
    tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_30;
    tmpvar_30.x = fetchesOffsetsU_8.x;
    tmpvar_30.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
    tmpvar_31.z = shadowCoord_5.z;
    mediump float tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
    shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_8.y;
    tmpvar_33.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_8.x;
    tmpvar_36.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
    tmpvar_37.z = shadowCoord_5.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_8.y;
    tmpvar_39.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
    tmpvar_40.z = shadowCoord_5.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_42;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_43;
  tmpvar_43 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_43 * tmpvar_43)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_46;
  tmpvar_46 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_47;
  tmpvar_47 = (((vec3(tmpvar_6) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_45) * tmpvar_46) * tmpvar_46));
  backDiffuse_1 = (tmpvar_47 / (tmpvar_47 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_45));
  highp vec4 tmpvar_48;
  tmpvar_48.w = 1.0;
  tmpvar_48.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_48;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_7;
    highp vec3 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec3 texelsWeightsA_13;
    highp vec3 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.16 * tmpvar_18);
    texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
    texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
    texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
    texelsWeightsB_14.z = (0.16 * tmpvar_17);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.z = texelsWeightsB_14.y;
    highp vec3 tmpvar_30;
    tmpvar_30.x = texelsWeightsA_13.y;
    tmpvar_30.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_21.y;
    tmpvar_33.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.x = texelsWeightsA_13.y;
    tmpvar_35.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_21.y;
    tmpvar_36.yz = texelsWeightsB_22.xz;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.x;
    tmpvar_47.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.y;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.z;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.x;
    tmpvar_56.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.y;
    tmpvar_59.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.z;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_65;
  tmpvar_65 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_65;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_66;
  tmpvar_66 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_66 * tmpvar_66)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_67;
  tmpvar_67 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_69;
  tmpvar_69 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_70;
  tmpvar_70 = (((vec3(tmpvar_6) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_68) * tmpvar_69) * tmpvar_69));
  backDiffuse_1 = (tmpvar_70 / (tmpvar_70 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_68));
  highp vec4 tmpvar_71;
  tmpvar_71.w = 1.0;
  tmpvar_71.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_71;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_7;
    highp vec4 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 texelsWeightsA_13;
    highp vec4 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.081632 * tmpvar_18);
    texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
    texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
    texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
    texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
    texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
    texelsWeightsB_14.w = (0.081632 * tmpvar_17);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.zw = texelsWeightsB_14.xz;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = texelsWeightsA_13.yw;
    tmpvar_30.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_21.yw;
    tmpvar_33.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_13.yw;
    tmpvar_35.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_21.yw;
    tmpvar_36.zw = texelsWeightsB_22.yw;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.w;
    tmpvar_47.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.x;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.y;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.z;
    tmpvar_56.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.w;
    tmpvar_59.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.x;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_8.y;
    tmpvar_65.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
    tmpvar_66.z = shadowCoord_5.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_8.z;
    tmpvar_68.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
    tmpvar_69.z = shadowCoord_5.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_8.w;
    tmpvar_71.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
    tmpvar_72.z = shadowCoord_5.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_8.x;
    tmpvar_74.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
    tmpvar_75.z = shadowCoord_5.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_8.y;
    tmpvar_77.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
    tmpvar_78.z = shadowCoord_5.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_8.z;
    tmpvar_80.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
    tmpvar_81.z = shadowCoord_5.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_8.w;
    tmpvar_83.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
    tmpvar_84.z = shadowCoord_5.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_86;
  tmpvar_86 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_86;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_87;
  tmpvar_87 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_87 * tmpvar_87)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_88;
  tmpvar_88 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_90;
  tmpvar_90 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_91;
  tmpvar_91 = (((vec3(tmpvar_6) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_89) * tmpvar_90) * tmpvar_90));
  backDiffuse_1 = (tmpvar_91 / (tmpvar_91 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_89));
  highp vec4 tmpvar_92;
  tmpvar_92.w = 1.0;
  tmpvar_92.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_92;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    highp vec2 tmpvar_7;
    tmpvar_7.x = LIGHT_PARAM.z;
    tmpvar_7.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_8;
    tmpvar_8.xy = tmpvar_7;
    highp float tmpvar_9;
    tmpvar_9 = (1.0/(LIGHT_PARAM.z));
    tmpvar_8.z = tmpvar_9;
    tmpvar_8.w = tmpvar_9;
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = tmpvar_8.xy;
    shadow_10 = 0.0;
    highp vec3 tmpvar_12;
    tmpvar_12.xy = (shadowCoord_5.xy - LIGHT_PARAM.zz);
    tmpvar_12.z = shadowCoord_5.z;
    highp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_12.xy);
    highp float tmpvar_14;
    if ((tmpvar_13.x < xlv_TEXCOORD4.z)) {
      tmpvar_14 = 0.0;
    } else {
      tmpvar_14 = 1.0;
    };
    shadow_10 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.x = 0.0;
    tmpvar_15.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_5.xy + tmpvar_15);
    tmpvar_16.z = shadowCoord_5.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_10 = (tmpvar_14 + tmpvar_18);
    highp vec2 tmpvar_19;
    tmpvar_19.x = tmpvar_11.x;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_5.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_5.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.y = 0.0;
    tmpvar_23.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_5.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_5.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_26);
    highp vec4 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_5.xy);
    highp float tmpvar_28;
    if ((tmpvar_27.x < xlv_TEXCOORD4.z)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_28);
    highp vec2 tmpvar_29;
    tmpvar_29.y = 0.0;
    tmpvar_29.x = tmpvar_11.x;
    highp vec3 tmpvar_30;
    tmpvar_30.xy = (shadowCoord_5.xy + tmpvar_29);
    tmpvar_30.z = shadowCoord_5.z;
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = -(LIGHT_PARAM.z);
    tmpvar_33.y = tmpvar_11.y;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_5.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = tmpvar_11.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_5.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_5.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_40);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_5.xy + LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_5.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_43);
    shadow_10 = (shadow_10 / 9.0);
    tmpvar_6 = mix (1.0, shadow_10, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_44;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_45;
  tmpvar_45 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_45 * tmpvar_45)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_48;
  tmpvar_48 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_49;
  tmpvar_49 = (((vec3(tmpvar_6) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_47) * tmpvar_48) * tmpvar_48));
  backDiffuse_1 = (tmpvar_49 / (tmpvar_49 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_47));
  highp vec4 tmpvar_50;
  tmpvar_50.w = 1.0;
  tmpvar_50.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_50;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_5;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_6;
  tmpvar_6 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_6 * tmpvar_6)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10 = (((specColor_2.yyy * LIGHT_COLOR) * (vec3(0.5, 0.5, 0.5) * vec3(tmpvar_8))) * (tmpvar_9 * tmpvar_9));
  backDiffuse_1 = (tmpvar_10 / (tmpvar_10 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_8));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec2 fetchesOffsetsV_7;
  highp vec2 fetchesOffsetsU_8;
  highp float shadow_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 computedWeight_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_12.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_12.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  computedWeight_13 = (computedArea_14 * 0.44444);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_12.y, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_12.y, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec2 tmpvar_27;
  tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
  highp vec2 tmpvar_28;
  tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
  fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_29;
  tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_30;
  tmpvar_30.x = fetchesOffsetsU_8.x;
  tmpvar_30.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_31;
  tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
  tmpvar_31.z = shadowCoord_5.z;
  mediump float tmpvar_32;
  tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
  shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
  highp vec2 tmpvar_33;
  tmpvar_33.x = fetchesOffsetsU_8.y;
  tmpvar_33.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_34;
  tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
  tmpvar_34.z = shadowCoord_5.z;
  mediump float tmpvar_35;
  tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
  highp vec2 tmpvar_36;
  tmpvar_36.x = fetchesOffsetsU_8.x;
  tmpvar_36.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_37;
  tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
  tmpvar_37.z = shadowCoord_5.z;
  mediump float tmpvar_38;
  tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
  shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
  highp vec2 tmpvar_39;
  tmpvar_39.x = fetchesOffsetsU_8.y;
  tmpvar_39.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_40;
  tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
  tmpvar_40.z = shadowCoord_5.z;
  mediump float tmpvar_41;
  tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_42;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_43;
  tmpvar_43 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_43 * tmpvar_43)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_46;
  tmpvar_46 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_47;
  tmpvar_47 = (((vec3(
    mix (1.0, shadow_9, LIGHT_PARAM.y)
  ) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_45) * tmpvar_46) * tmpvar_46));
  backDiffuse_1 = (tmpvar_47 / (tmpvar_47 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_45));
  highp vec4 tmpvar_48;
  tmpvar_48.w = 1.0;
  tmpvar_48.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_48;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec3 fetchesOffsetsV_7;
  highp vec3 fetchesOffsetsU_8;
  highp float shadow_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec3 texelsWeightsA_13;
  highp vec3 texelsWeightsB_14;
  highp vec4 computedArea_15;
  highp vec4 computedAreaUncut_16;
  highp float tmpvar_17;
  tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
  computedArea_15.x = tmpvar_18;
  computedAreaUncut_16.x = tmpvar_18;
  computedArea_15.w = tmpvar_17;
  computedAreaUncut_16.w = tmpvar_17;
  computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = min (tmpvar_12.x, 0.0);
  computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
  computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_20;
  tmpvar_20 = max (tmpvar_12.x, 0.0);
  computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
  texelsWeightsA_13.x = (0.16 * tmpvar_18);
  texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
  texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
  texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
  texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
  texelsWeightsB_14.z = (0.16 * tmpvar_17);
  highp vec3 texelsWeightsA_21;
  highp vec3 texelsWeightsB_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_12.y, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_12.y, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  texelsWeightsA_21.x = (0.16 * tmpvar_26);
  texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
  texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
  texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
  texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
  texelsWeightsB_22.z = (0.16 * tmpvar_25);
  highp vec3 tmpvar_29;
  tmpvar_29.xy = texelsWeightsA_13.xz;
  tmpvar_29.z = texelsWeightsB_14.y;
  highp vec3 tmpvar_30;
  tmpvar_30.x = texelsWeightsA_13.y;
  tmpvar_30.yz = texelsWeightsB_14.xz;
  highp vec3 tmpvar_31;
  tmpvar_31 = (tmpvar_29 + tmpvar_30);
  highp vec3 tmpvar_32;
  tmpvar_32.xy = texelsWeightsA_21.xz;
  tmpvar_32.z = texelsWeightsB_22.y;
  highp vec3 tmpvar_33;
  tmpvar_33.x = texelsWeightsA_21.y;
  tmpvar_33.yz = texelsWeightsB_22.xz;
  highp vec3 tmpvar_34;
  tmpvar_34 = (tmpvar_32 + tmpvar_33);
  highp vec3 tmpvar_35;
  tmpvar_35.x = texelsWeightsA_13.y;
  tmpvar_35.yz = texelsWeightsB_14.xz;
  highp vec3 tmpvar_36;
  tmpvar_36.x = texelsWeightsA_21.y;
  tmpvar_36.yz = texelsWeightsB_22.xz;
  fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_8.x;
  tmpvar_38.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_5.z;
  mediump float tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
  shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
  highp vec2 tmpvar_41;
  tmpvar_41.x = fetchesOffsetsU_8.y;
  tmpvar_41.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_42;
  tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
  tmpvar_42.z = shadowCoord_5.z;
  mediump float tmpvar_43;
  tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
  highp vec2 tmpvar_44;
  tmpvar_44.x = fetchesOffsetsU_8.z;
  tmpvar_44.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_45;
  tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
  tmpvar_45.z = shadowCoord_5.z;
  mediump float tmpvar_46;
  tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
  highp vec2 tmpvar_47;
  tmpvar_47.x = fetchesOffsetsU_8.x;
  tmpvar_47.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_48;
  tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
  tmpvar_48.z = shadowCoord_5.z;
  mediump float tmpvar_49;
  tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
  highp vec2 tmpvar_50;
  tmpvar_50.x = fetchesOffsetsU_8.y;
  tmpvar_50.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_51;
  tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
  tmpvar_51.z = shadowCoord_5.z;
  mediump float tmpvar_52;
  tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
  highp vec2 tmpvar_53;
  tmpvar_53.x = fetchesOffsetsU_8.z;
  tmpvar_53.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_54;
  tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
  tmpvar_54.z = shadowCoord_5.z;
  mediump float tmpvar_55;
  tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
  highp vec2 tmpvar_56;
  tmpvar_56.x = fetchesOffsetsU_8.x;
  tmpvar_56.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_57;
  tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
  tmpvar_57.z = shadowCoord_5.z;
  mediump float tmpvar_58;
  tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
  highp vec2 tmpvar_59;
  tmpvar_59.x = fetchesOffsetsU_8.y;
  tmpvar_59.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_60;
  tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
  tmpvar_60.z = shadowCoord_5.z;
  mediump float tmpvar_61;
  tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
  highp vec2 tmpvar_62;
  tmpvar_62.x = fetchesOffsetsU_8.z;
  tmpvar_62.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_63;
  tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
  tmpvar_63.z = shadowCoord_5.z;
  mediump float tmpvar_64;
  tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
  lowp vec4 tmpvar_65;
  tmpvar_65 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_65;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_66;
  tmpvar_66 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_66 * tmpvar_66)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_67;
  tmpvar_67 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_69;
  tmpvar_69 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_70;
  tmpvar_70 = (((vec3(
    mix (1.0, shadow_9, LIGHT_PARAM.y)
  ) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_68) * tmpvar_69) * tmpvar_69));
  backDiffuse_1 = (tmpvar_70 / (tmpvar_70 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_68));
  highp vec4 tmpvar_71;
  tmpvar_71.w = 1.0;
  tmpvar_71.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_71;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec4 fetchesOffsetsV_7;
  highp vec4 fetchesOffsetsU_8;
  highp float shadow_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 texelsWeightsA_13;
  highp vec4 texelsWeightsB_14;
  highp vec4 computedArea_15;
  highp vec4 computedAreaUncut_16;
  highp float tmpvar_17;
  tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
  computedArea_15.x = tmpvar_18;
  computedAreaUncut_16.x = tmpvar_18;
  computedArea_15.w = tmpvar_17;
  computedAreaUncut_16.w = tmpvar_17;
  computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = min (tmpvar_12.x, 0.0);
  computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
  computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_20;
  tmpvar_20 = max (tmpvar_12.x, 0.0);
  computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
  texelsWeightsA_13.x = (0.081632 * tmpvar_18);
  texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
  texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
  texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
  texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
  texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
  texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
  texelsWeightsB_14.w = (0.081632 * tmpvar_17);
  highp vec4 texelsWeightsA_21;
  highp vec4 texelsWeightsB_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_12.y, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_12.y, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  texelsWeightsA_21.x = (0.081632 * tmpvar_26);
  texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
  texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
  texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
  texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
  texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
  texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
  texelsWeightsB_22.w = (0.081632 * tmpvar_25);
  highp vec4 tmpvar_29;
  tmpvar_29.xy = texelsWeightsA_13.xz;
  tmpvar_29.zw = texelsWeightsB_14.xz;
  highp vec4 tmpvar_30;
  tmpvar_30.xy = texelsWeightsA_13.yw;
  tmpvar_30.zw = texelsWeightsB_14.yw;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_29 + tmpvar_30);
  highp vec4 tmpvar_32;
  tmpvar_32.xy = texelsWeightsA_21.xz;
  tmpvar_32.zw = texelsWeightsB_22.xz;
  highp vec4 tmpvar_33;
  tmpvar_33.xy = texelsWeightsA_21.yw;
  tmpvar_33.zw = texelsWeightsB_22.yw;
  highp vec4 tmpvar_34;
  tmpvar_34 = (tmpvar_32 + tmpvar_33);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = texelsWeightsA_13.yw;
  tmpvar_35.zw = texelsWeightsB_14.yw;
  highp vec4 tmpvar_36;
  tmpvar_36.xy = texelsWeightsA_21.yw;
  tmpvar_36.zw = texelsWeightsB_22.yw;
  fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_8.x;
  tmpvar_38.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_5.z;
  mediump float tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
  shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
  highp vec2 tmpvar_41;
  tmpvar_41.x = fetchesOffsetsU_8.y;
  tmpvar_41.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_42;
  tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
  tmpvar_42.z = shadowCoord_5.z;
  mediump float tmpvar_43;
  tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
  highp vec2 tmpvar_44;
  tmpvar_44.x = fetchesOffsetsU_8.z;
  tmpvar_44.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_45;
  tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
  tmpvar_45.z = shadowCoord_5.z;
  mediump float tmpvar_46;
  tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
  highp vec2 tmpvar_47;
  tmpvar_47.x = fetchesOffsetsU_8.w;
  tmpvar_47.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_48;
  tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
  tmpvar_48.z = shadowCoord_5.z;
  mediump float tmpvar_49;
  tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
  shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
  highp vec2 tmpvar_50;
  tmpvar_50.x = fetchesOffsetsU_8.x;
  tmpvar_50.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_51;
  tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
  tmpvar_51.z = shadowCoord_5.z;
  mediump float tmpvar_52;
  tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
  highp vec2 tmpvar_53;
  tmpvar_53.x = fetchesOffsetsU_8.y;
  tmpvar_53.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_54;
  tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
  tmpvar_54.z = shadowCoord_5.z;
  mediump float tmpvar_55;
  tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
  highp vec2 tmpvar_56;
  tmpvar_56.x = fetchesOffsetsU_8.z;
  tmpvar_56.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_57;
  tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
  tmpvar_57.z = shadowCoord_5.z;
  mediump float tmpvar_58;
  tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
  highp vec2 tmpvar_59;
  tmpvar_59.x = fetchesOffsetsU_8.w;
  tmpvar_59.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_60;
  tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
  tmpvar_60.z = shadowCoord_5.z;
  mediump float tmpvar_61;
  tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
  shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
  highp vec2 tmpvar_62;
  tmpvar_62.x = fetchesOffsetsU_8.x;
  tmpvar_62.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_63;
  tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
  tmpvar_63.z = shadowCoord_5.z;
  mediump float tmpvar_64;
  tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
  highp vec2 tmpvar_65;
  tmpvar_65.x = fetchesOffsetsU_8.y;
  tmpvar_65.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_66;
  tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
  tmpvar_66.z = shadowCoord_5.z;
  mediump float tmpvar_67;
  tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
  highp vec2 tmpvar_68;
  tmpvar_68.x = fetchesOffsetsU_8.z;
  tmpvar_68.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_69;
  tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
  tmpvar_69.z = shadowCoord_5.z;
  mediump float tmpvar_70;
  tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
  highp vec2 tmpvar_71;
  tmpvar_71.x = fetchesOffsetsU_8.w;
  tmpvar_71.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_72;
  tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
  tmpvar_72.z = shadowCoord_5.z;
  mediump float tmpvar_73;
  tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
  shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
  highp vec2 tmpvar_74;
  tmpvar_74.x = fetchesOffsetsU_8.x;
  tmpvar_74.y = fetchesOffsetsV_7.w;
  highp vec3 tmpvar_75;
  tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
  tmpvar_75.z = shadowCoord_5.z;
  mediump float tmpvar_76;
  tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
  highp vec2 tmpvar_77;
  tmpvar_77.x = fetchesOffsetsU_8.y;
  tmpvar_77.y = fetchesOffsetsV_7.w;
  highp vec3 tmpvar_78;
  tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
  tmpvar_78.z = shadowCoord_5.z;
  mediump float tmpvar_79;
  tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
  highp vec2 tmpvar_80;
  tmpvar_80.x = fetchesOffsetsU_8.z;
  tmpvar_80.y = fetchesOffsetsV_7.w;
  highp vec3 tmpvar_81;
  tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
  tmpvar_81.z = shadowCoord_5.z;
  mediump float tmpvar_82;
  tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
  highp vec2 tmpvar_83;
  tmpvar_83.x = fetchesOffsetsU_8.w;
  tmpvar_83.y = fetchesOffsetsV_7.w;
  highp vec3 tmpvar_84;
  tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
  tmpvar_84.z = shadowCoord_5.z;
  mediump float tmpvar_85;
  tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
  shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
  lowp vec4 tmpvar_86;
  tmpvar_86 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_86;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_87;
  tmpvar_87 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_87 * tmpvar_87)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_88;
  tmpvar_88 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_90;
  tmpvar_90 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_91;
  tmpvar_91 = (((vec3(
    mix (1.0, shadow_9, LIGHT_PARAM.y)
  ) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_89) * tmpvar_90) * tmpvar_90));
  backDiffuse_1 = (tmpvar_91 / (tmpvar_91 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_89));
  highp vec4 tmpvar_92;
  tmpvar_92.w = 1.0;
  tmpvar_92.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_92;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec2 fetchesOffsetsV_7;
  highp vec2 fetchesOffsetsU_8;
  highp float shadow_9;
  shadow_9 = 1.0;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 computedWeight_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_12.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_12.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  computedWeight_13 = (computedArea_14 * 0.44444);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_12.y, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_12.y, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec2 tmpvar_27;
  tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
  highp vec2 tmpvar_28;
  tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
  fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_29;
  tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_30;
  tmpvar_30.x = fetchesOffsetsU_8.x;
  tmpvar_30.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_31;
  tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
  tmpvar_31.z = shadowCoord_5.z;
  highp vec4 tmpvar_32;
  tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
  highp float tmpvar_33;
  if ((tmpvar_32.x < shadowCoord_5.z)) {
    tmpvar_33 = 0.0;
  } else {
    tmpvar_33 = 1.0;
  };
  shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_33);
  highp vec2 tmpvar_34;
  tmpvar_34.x = fetchesOffsetsU_8.y;
  tmpvar_34.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_35;
  tmpvar_35.xy = (tmpvar_29 + tmpvar_34);
  tmpvar_35.z = shadowCoord_5.z;
  highp vec4 tmpvar_36;
  tmpvar_36 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
  highp float tmpvar_37;
  if ((tmpvar_36.x < shadowCoord_5.z)) {
    tmpvar_37 = 0.0;
  } else {
    tmpvar_37 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_37));
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_8.x;
  tmpvar_38.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_29 + tmpvar_38);
  tmpvar_39.z = shadowCoord_5.z;
  highp vec4 tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
  highp float tmpvar_41;
  if ((tmpvar_40.x < shadowCoord_5.z)) {
    tmpvar_41 = 0.0;
  } else {
    tmpvar_41 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_41));
  highp vec2 tmpvar_42;
  tmpvar_42.x = fetchesOffsetsU_8.y;
  tmpvar_42.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_43;
  tmpvar_43.xy = (tmpvar_29 + tmpvar_42);
  tmpvar_43.z = shadowCoord_5.z;
  highp vec4 tmpvar_44;
  tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
  highp float tmpvar_45;
  if ((tmpvar_44.x < shadowCoord_5.z)) {
    tmpvar_45 = 0.0;
  } else {
    tmpvar_45 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_45));
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_46;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_47;
  tmpvar_47 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_47 * tmpvar_47)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_48;
  tmpvar_48 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_50;
  tmpvar_50 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_51;
  tmpvar_51 = (((vec3(
    mix (1.0, shadow_9, LIGHT_PARAM.y)
  ) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_49) * tmpvar_50) * tmpvar_50));
  backDiffuse_1 = (tmpvar_51 / (tmpvar_51 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_49));
  highp vec4 tmpvar_52;
  tmpvar_52.w = 1.0;
  tmpvar_52.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_52;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_5;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_6;
  tmpvar_6 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_6 * tmpvar_6)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10 = (((specColor_2.yyy * LIGHT_COLOR) * (vec3(0.5, 0.5, 0.5) * vec3(tmpvar_8))) * (tmpvar_9 * tmpvar_9));
  backDiffuse_1 = (tmpvar_10 / (tmpvar_10 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_8));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_5;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_6;
  tmpvar_6 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_6 * tmpvar_6)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10 = (((specColor_2.yyy * LIGHT_COLOR) * (vec3(0.5, 0.5, 0.5) * vec3(tmpvar_8))) * (tmpvar_9 * tmpvar_9));
  backDiffuse_1 = (tmpvar_10 / (tmpvar_10 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_8));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_5;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_6;
  tmpvar_6 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_6 * tmpvar_6)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10 = (((specColor_2.yyy * LIGHT_COLOR) * (vec3(0.5, 0.5, 0.5) * vec3(tmpvar_8))) * (tmpvar_9 * tmpvar_9));
  backDiffuse_1 = (tmpvar_10 / (tmpvar_10 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_8));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_7;
    highp vec2 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 computedWeight_13;
    highp vec4 computedArea_14;
    highp vec4 computedAreaUncut_15;
    highp float tmpvar_16;
    tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
    computedArea_14.x = tmpvar_17;
    computedAreaUncut_15.x = tmpvar_17;
    computedArea_14.w = tmpvar_16;
    computedAreaUncut_15.w = tmpvar_16;
    computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_18;
    tmpvar_18 = min (tmpvar_12.x, 0.0);
    computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
    computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = max (tmpvar_12.x, 0.0);
    computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
    computedWeight_13 = (computedArea_14 * 0.44444);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_12.y, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_12.y, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec2 tmpvar_27;
    tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
    highp vec2 tmpvar_28;
    tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
    fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_29;
    tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_30;
    tmpvar_30.x = fetchesOffsetsU_8.x;
    tmpvar_30.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
    tmpvar_31.z = shadowCoord_5.z;
    mediump float tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
    shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_8.y;
    tmpvar_33.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_8.x;
    tmpvar_36.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
    tmpvar_37.z = shadowCoord_5.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_8.y;
    tmpvar_39.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
    tmpvar_40.z = shadowCoord_5.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_42;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_43;
  tmpvar_43 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_43 * tmpvar_43)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_46;
  tmpvar_46 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_47;
  tmpvar_47 = (((vec3(tmpvar_6) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_45) * tmpvar_46) * tmpvar_46));
  backDiffuse_1 = (tmpvar_47 / (tmpvar_47 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_45));
  highp vec4 tmpvar_48;
  tmpvar_48.w = 1.0;
  tmpvar_48.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_48;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_7;
    highp vec3 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec3 texelsWeightsA_13;
    highp vec3 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.16 * tmpvar_18);
    texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
    texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
    texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
    texelsWeightsB_14.z = (0.16 * tmpvar_17);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.z = texelsWeightsB_14.y;
    highp vec3 tmpvar_30;
    tmpvar_30.x = texelsWeightsA_13.y;
    tmpvar_30.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_21.y;
    tmpvar_33.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.x = texelsWeightsA_13.y;
    tmpvar_35.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_21.y;
    tmpvar_36.yz = texelsWeightsB_22.xz;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.x;
    tmpvar_47.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.y;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.z;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.x;
    tmpvar_56.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.y;
    tmpvar_59.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.z;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_65;
  tmpvar_65 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_65;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_66;
  tmpvar_66 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_66 * tmpvar_66)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_67;
  tmpvar_67 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_69;
  tmpvar_69 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_70;
  tmpvar_70 = (((vec3(tmpvar_6) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_68) * tmpvar_69) * tmpvar_69));
  backDiffuse_1 = (tmpvar_70 / (tmpvar_70 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_68));
  highp vec4 tmpvar_71;
  tmpvar_71.w = 1.0;
  tmpvar_71.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_71;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_7;
    highp vec4 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 texelsWeightsA_13;
    highp vec4 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.081632 * tmpvar_18);
    texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
    texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
    texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
    texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
    texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
    texelsWeightsB_14.w = (0.081632 * tmpvar_17);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.zw = texelsWeightsB_14.xz;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = texelsWeightsA_13.yw;
    tmpvar_30.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_21.yw;
    tmpvar_33.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_13.yw;
    tmpvar_35.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_21.yw;
    tmpvar_36.zw = texelsWeightsB_22.yw;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.w;
    tmpvar_47.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.x;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.y;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.z;
    tmpvar_56.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.w;
    tmpvar_59.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.x;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_8.y;
    tmpvar_65.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
    tmpvar_66.z = shadowCoord_5.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_8.z;
    tmpvar_68.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
    tmpvar_69.z = shadowCoord_5.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_8.w;
    tmpvar_71.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
    tmpvar_72.z = shadowCoord_5.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_8.x;
    tmpvar_74.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
    tmpvar_75.z = shadowCoord_5.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_8.y;
    tmpvar_77.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
    tmpvar_78.z = shadowCoord_5.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_8.z;
    tmpvar_80.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
    tmpvar_81.z = shadowCoord_5.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_8.w;
    tmpvar_83.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
    tmpvar_84.z = shadowCoord_5.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_86;
  tmpvar_86 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_86;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_87;
  tmpvar_87 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_87 * tmpvar_87)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_88;
  tmpvar_88 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_90;
  tmpvar_90 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_91;
  tmpvar_91 = (((vec3(tmpvar_6) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_89) * tmpvar_90) * tmpvar_90));
  backDiffuse_1 = (tmpvar_91 / (tmpvar_91 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_89));
  highp vec4 tmpvar_92;
  tmpvar_92.w = 1.0;
  tmpvar_92.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_92;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    highp vec2 tmpvar_7;
    tmpvar_7.x = LIGHT_PARAM.z;
    tmpvar_7.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_8;
    tmpvar_8.xy = tmpvar_7;
    highp float tmpvar_9;
    tmpvar_9 = (1.0/(LIGHT_PARAM.z));
    tmpvar_8.z = tmpvar_9;
    tmpvar_8.w = tmpvar_9;
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = tmpvar_8.xy;
    shadow_10 = 0.0;
    highp vec3 tmpvar_12;
    tmpvar_12.xy = (shadowCoord_5.xy - LIGHT_PARAM.zz);
    tmpvar_12.z = shadowCoord_5.z;
    highp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_12.xy);
    highp float tmpvar_14;
    if ((tmpvar_13.x < xlv_TEXCOORD4.z)) {
      tmpvar_14 = 0.0;
    } else {
      tmpvar_14 = 1.0;
    };
    shadow_10 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.x = 0.0;
    tmpvar_15.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_5.xy + tmpvar_15);
    tmpvar_16.z = shadowCoord_5.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_10 = (tmpvar_14 + tmpvar_18);
    highp vec2 tmpvar_19;
    tmpvar_19.x = tmpvar_11.x;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_5.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_5.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.y = 0.0;
    tmpvar_23.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_5.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_5.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_26);
    highp vec4 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_5.xy);
    highp float tmpvar_28;
    if ((tmpvar_27.x < xlv_TEXCOORD4.z)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_28);
    highp vec2 tmpvar_29;
    tmpvar_29.y = 0.0;
    tmpvar_29.x = tmpvar_11.x;
    highp vec3 tmpvar_30;
    tmpvar_30.xy = (shadowCoord_5.xy + tmpvar_29);
    tmpvar_30.z = shadowCoord_5.z;
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = -(LIGHT_PARAM.z);
    tmpvar_33.y = tmpvar_11.y;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_5.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = tmpvar_11.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_5.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_5.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_40);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_5.xy + LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_5.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_43);
    shadow_10 = (shadow_10 / 9.0);
    tmpvar_6 = mix (1.0, shadow_10, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_44;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_45;
  tmpvar_45 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_45 * tmpvar_45)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_48;
  tmpvar_48 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_49;
  tmpvar_49 = (((vec3(tmpvar_6) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_47) * tmpvar_48) * tmpvar_48));
  backDiffuse_1 = (tmpvar_49 / (tmpvar_49 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_47));
  highp vec4 tmpvar_50;
  tmpvar_50.w = 1.0;
  tmpvar_50.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_50;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_5;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_6;
  tmpvar_6 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_6 * tmpvar_6)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10 = (((specColor_2.yyy * LIGHT_COLOR) * (vec3(0.5, 0.5, 0.5) * vec3(tmpvar_8))) * (tmpvar_9 * tmpvar_9));
  backDiffuse_1 = (tmpvar_10 / (tmpvar_10 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_8));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec2 fetchesOffsetsV_7;
  highp vec2 fetchesOffsetsU_8;
  highp float shadow_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 computedWeight_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_12.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_12.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  computedWeight_13 = (computedArea_14 * 0.44444);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_12.y, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_12.y, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec2 tmpvar_27;
  tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
  highp vec2 tmpvar_28;
  tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
  fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_29;
  tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_30;
  tmpvar_30.x = fetchesOffsetsU_8.x;
  tmpvar_30.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_31;
  tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
  tmpvar_31.z = shadowCoord_5.z;
  mediump float tmpvar_32;
  tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
  shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
  highp vec2 tmpvar_33;
  tmpvar_33.x = fetchesOffsetsU_8.y;
  tmpvar_33.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_34;
  tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
  tmpvar_34.z = shadowCoord_5.z;
  mediump float tmpvar_35;
  tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
  highp vec2 tmpvar_36;
  tmpvar_36.x = fetchesOffsetsU_8.x;
  tmpvar_36.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_37;
  tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
  tmpvar_37.z = shadowCoord_5.z;
  mediump float tmpvar_38;
  tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
  shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
  highp vec2 tmpvar_39;
  tmpvar_39.x = fetchesOffsetsU_8.y;
  tmpvar_39.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_40;
  tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
  tmpvar_40.z = shadowCoord_5.z;
  mediump float tmpvar_41;
  tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_42;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_43;
  tmpvar_43 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_43 * tmpvar_43)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_46;
  tmpvar_46 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_47;
  tmpvar_47 = (((vec3(
    mix (1.0, shadow_9, LIGHT_PARAM.y)
  ) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_45) * tmpvar_46) * tmpvar_46));
  backDiffuse_1 = (tmpvar_47 / (tmpvar_47 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_45));
  highp vec4 tmpvar_48;
  tmpvar_48.w = 1.0;
  tmpvar_48.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_48;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec3 fetchesOffsetsV_7;
  highp vec3 fetchesOffsetsU_8;
  highp float shadow_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec3 texelsWeightsA_13;
  highp vec3 texelsWeightsB_14;
  highp vec4 computedArea_15;
  highp vec4 computedAreaUncut_16;
  highp float tmpvar_17;
  tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
  computedArea_15.x = tmpvar_18;
  computedAreaUncut_16.x = tmpvar_18;
  computedArea_15.w = tmpvar_17;
  computedAreaUncut_16.w = tmpvar_17;
  computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = min (tmpvar_12.x, 0.0);
  computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
  computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_20;
  tmpvar_20 = max (tmpvar_12.x, 0.0);
  computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
  texelsWeightsA_13.x = (0.16 * tmpvar_18);
  texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
  texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
  texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
  texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
  texelsWeightsB_14.z = (0.16 * tmpvar_17);
  highp vec3 texelsWeightsA_21;
  highp vec3 texelsWeightsB_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_12.y, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_12.y, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  texelsWeightsA_21.x = (0.16 * tmpvar_26);
  texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
  texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
  texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
  texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
  texelsWeightsB_22.z = (0.16 * tmpvar_25);
  highp vec3 tmpvar_29;
  tmpvar_29.xy = texelsWeightsA_13.xz;
  tmpvar_29.z = texelsWeightsB_14.y;
  highp vec3 tmpvar_30;
  tmpvar_30.x = texelsWeightsA_13.y;
  tmpvar_30.yz = texelsWeightsB_14.xz;
  highp vec3 tmpvar_31;
  tmpvar_31 = (tmpvar_29 + tmpvar_30);
  highp vec3 tmpvar_32;
  tmpvar_32.xy = texelsWeightsA_21.xz;
  tmpvar_32.z = texelsWeightsB_22.y;
  highp vec3 tmpvar_33;
  tmpvar_33.x = texelsWeightsA_21.y;
  tmpvar_33.yz = texelsWeightsB_22.xz;
  highp vec3 tmpvar_34;
  tmpvar_34 = (tmpvar_32 + tmpvar_33);
  highp vec3 tmpvar_35;
  tmpvar_35.x = texelsWeightsA_13.y;
  tmpvar_35.yz = texelsWeightsB_14.xz;
  highp vec3 tmpvar_36;
  tmpvar_36.x = texelsWeightsA_21.y;
  tmpvar_36.yz = texelsWeightsB_22.xz;
  fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_8.x;
  tmpvar_38.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_5.z;
  mediump float tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
  shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
  highp vec2 tmpvar_41;
  tmpvar_41.x = fetchesOffsetsU_8.y;
  tmpvar_41.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_42;
  tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
  tmpvar_42.z = shadowCoord_5.z;
  mediump float tmpvar_43;
  tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
  highp vec2 tmpvar_44;
  tmpvar_44.x = fetchesOffsetsU_8.z;
  tmpvar_44.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_45;
  tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
  tmpvar_45.z = shadowCoord_5.z;
  mediump float tmpvar_46;
  tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
  highp vec2 tmpvar_47;
  tmpvar_47.x = fetchesOffsetsU_8.x;
  tmpvar_47.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_48;
  tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
  tmpvar_48.z = shadowCoord_5.z;
  mediump float tmpvar_49;
  tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
  highp vec2 tmpvar_50;
  tmpvar_50.x = fetchesOffsetsU_8.y;
  tmpvar_50.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_51;
  tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
  tmpvar_51.z = shadowCoord_5.z;
  mediump float tmpvar_52;
  tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
  highp vec2 tmpvar_53;
  tmpvar_53.x = fetchesOffsetsU_8.z;
  tmpvar_53.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_54;
  tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
  tmpvar_54.z = shadowCoord_5.z;
  mediump float tmpvar_55;
  tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
  highp vec2 tmpvar_56;
  tmpvar_56.x = fetchesOffsetsU_8.x;
  tmpvar_56.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_57;
  tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
  tmpvar_57.z = shadowCoord_5.z;
  mediump float tmpvar_58;
  tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
  highp vec2 tmpvar_59;
  tmpvar_59.x = fetchesOffsetsU_8.y;
  tmpvar_59.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_60;
  tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
  tmpvar_60.z = shadowCoord_5.z;
  mediump float tmpvar_61;
  tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
  highp vec2 tmpvar_62;
  tmpvar_62.x = fetchesOffsetsU_8.z;
  tmpvar_62.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_63;
  tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
  tmpvar_63.z = shadowCoord_5.z;
  mediump float tmpvar_64;
  tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
  lowp vec4 tmpvar_65;
  tmpvar_65 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_65;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_66;
  tmpvar_66 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_66 * tmpvar_66)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_67;
  tmpvar_67 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_69;
  tmpvar_69 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_70;
  tmpvar_70 = (((vec3(
    mix (1.0, shadow_9, LIGHT_PARAM.y)
  ) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_68) * tmpvar_69) * tmpvar_69));
  backDiffuse_1 = (tmpvar_70 / (tmpvar_70 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_68));
  highp vec4 tmpvar_71;
  tmpvar_71.w = 1.0;
  tmpvar_71.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_71;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec4 fetchesOffsetsV_7;
  highp vec4 fetchesOffsetsU_8;
  highp float shadow_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 texelsWeightsA_13;
  highp vec4 texelsWeightsB_14;
  highp vec4 computedArea_15;
  highp vec4 computedAreaUncut_16;
  highp float tmpvar_17;
  tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
  computedArea_15.x = tmpvar_18;
  computedAreaUncut_16.x = tmpvar_18;
  computedArea_15.w = tmpvar_17;
  computedAreaUncut_16.w = tmpvar_17;
  computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = min (tmpvar_12.x, 0.0);
  computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
  computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_20;
  tmpvar_20 = max (tmpvar_12.x, 0.0);
  computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
  texelsWeightsA_13.x = (0.081632 * tmpvar_18);
  texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
  texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
  texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
  texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
  texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
  texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
  texelsWeightsB_14.w = (0.081632 * tmpvar_17);
  highp vec4 texelsWeightsA_21;
  highp vec4 texelsWeightsB_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_12.y, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_12.y, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  texelsWeightsA_21.x = (0.081632 * tmpvar_26);
  texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
  texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
  texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
  texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
  texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
  texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
  texelsWeightsB_22.w = (0.081632 * tmpvar_25);
  highp vec4 tmpvar_29;
  tmpvar_29.xy = texelsWeightsA_13.xz;
  tmpvar_29.zw = texelsWeightsB_14.xz;
  highp vec4 tmpvar_30;
  tmpvar_30.xy = texelsWeightsA_13.yw;
  tmpvar_30.zw = texelsWeightsB_14.yw;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_29 + tmpvar_30);
  highp vec4 tmpvar_32;
  tmpvar_32.xy = texelsWeightsA_21.xz;
  tmpvar_32.zw = texelsWeightsB_22.xz;
  highp vec4 tmpvar_33;
  tmpvar_33.xy = texelsWeightsA_21.yw;
  tmpvar_33.zw = texelsWeightsB_22.yw;
  highp vec4 tmpvar_34;
  tmpvar_34 = (tmpvar_32 + tmpvar_33);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = texelsWeightsA_13.yw;
  tmpvar_35.zw = texelsWeightsB_14.yw;
  highp vec4 tmpvar_36;
  tmpvar_36.xy = texelsWeightsA_21.yw;
  tmpvar_36.zw = texelsWeightsB_22.yw;
  fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_8.x;
  tmpvar_38.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_5.z;
  mediump float tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
  shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
  highp vec2 tmpvar_41;
  tmpvar_41.x = fetchesOffsetsU_8.y;
  tmpvar_41.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_42;
  tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
  tmpvar_42.z = shadowCoord_5.z;
  mediump float tmpvar_43;
  tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
  highp vec2 tmpvar_44;
  tmpvar_44.x = fetchesOffsetsU_8.z;
  tmpvar_44.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_45;
  tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
  tmpvar_45.z = shadowCoord_5.z;
  mediump float tmpvar_46;
  tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
  highp vec2 tmpvar_47;
  tmpvar_47.x = fetchesOffsetsU_8.w;
  tmpvar_47.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_48;
  tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
  tmpvar_48.z = shadowCoord_5.z;
  mediump float tmpvar_49;
  tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
  shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
  highp vec2 tmpvar_50;
  tmpvar_50.x = fetchesOffsetsU_8.x;
  tmpvar_50.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_51;
  tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
  tmpvar_51.z = shadowCoord_5.z;
  mediump float tmpvar_52;
  tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
  highp vec2 tmpvar_53;
  tmpvar_53.x = fetchesOffsetsU_8.y;
  tmpvar_53.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_54;
  tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
  tmpvar_54.z = shadowCoord_5.z;
  mediump float tmpvar_55;
  tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
  highp vec2 tmpvar_56;
  tmpvar_56.x = fetchesOffsetsU_8.z;
  tmpvar_56.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_57;
  tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
  tmpvar_57.z = shadowCoord_5.z;
  mediump float tmpvar_58;
  tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
  highp vec2 tmpvar_59;
  tmpvar_59.x = fetchesOffsetsU_8.w;
  tmpvar_59.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_60;
  tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
  tmpvar_60.z = shadowCoord_5.z;
  mediump float tmpvar_61;
  tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
  shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
  highp vec2 tmpvar_62;
  tmpvar_62.x = fetchesOffsetsU_8.x;
  tmpvar_62.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_63;
  tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
  tmpvar_63.z = shadowCoord_5.z;
  mediump float tmpvar_64;
  tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
  highp vec2 tmpvar_65;
  tmpvar_65.x = fetchesOffsetsU_8.y;
  tmpvar_65.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_66;
  tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
  tmpvar_66.z = shadowCoord_5.z;
  mediump float tmpvar_67;
  tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
  highp vec2 tmpvar_68;
  tmpvar_68.x = fetchesOffsetsU_8.z;
  tmpvar_68.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_69;
  tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
  tmpvar_69.z = shadowCoord_5.z;
  mediump float tmpvar_70;
  tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
  highp vec2 tmpvar_71;
  tmpvar_71.x = fetchesOffsetsU_8.w;
  tmpvar_71.y = fetchesOffsetsV_7.z;
  highp vec3 tmpvar_72;
  tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
  tmpvar_72.z = shadowCoord_5.z;
  mediump float tmpvar_73;
  tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
  shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
  highp vec2 tmpvar_74;
  tmpvar_74.x = fetchesOffsetsU_8.x;
  tmpvar_74.y = fetchesOffsetsV_7.w;
  highp vec3 tmpvar_75;
  tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
  tmpvar_75.z = shadowCoord_5.z;
  mediump float tmpvar_76;
  tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
  shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
  highp vec2 tmpvar_77;
  tmpvar_77.x = fetchesOffsetsU_8.y;
  tmpvar_77.y = fetchesOffsetsV_7.w;
  highp vec3 tmpvar_78;
  tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
  tmpvar_78.z = shadowCoord_5.z;
  mediump float tmpvar_79;
  tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
  shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
  highp vec2 tmpvar_80;
  tmpvar_80.x = fetchesOffsetsU_8.z;
  tmpvar_80.y = fetchesOffsetsV_7.w;
  highp vec3 tmpvar_81;
  tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
  tmpvar_81.z = shadowCoord_5.z;
  mediump float tmpvar_82;
  tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
  shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
  highp vec2 tmpvar_83;
  tmpvar_83.x = fetchesOffsetsU_8.w;
  tmpvar_83.y = fetchesOffsetsV_7.w;
  highp vec3 tmpvar_84;
  tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
  tmpvar_84.z = shadowCoord_5.z;
  mediump float tmpvar_85;
  tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
  shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
  lowp vec4 tmpvar_86;
  tmpvar_86 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_86;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_87;
  tmpvar_87 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_87 * tmpvar_87)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_88;
  tmpvar_88 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_90;
  tmpvar_90 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_91;
  tmpvar_91 = (((vec3(
    mix (1.0, shadow_9, LIGHT_PARAM.y)
  ) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_89) * tmpvar_90) * tmpvar_90));
  backDiffuse_1 = (tmpvar_91 / (tmpvar_91 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_89));
  highp vec4 tmpvar_92;
  tmpvar_92.w = 1.0;
  tmpvar_92.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_92;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec2 fetchesOffsetsV_7;
  highp vec2 fetchesOffsetsU_8;
  highp float shadow_9;
  shadow_9 = 1.0;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 computedWeight_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_12.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_12.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  computedWeight_13 = (computedArea_14 * 0.44444);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_12.y, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_12.y, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec2 tmpvar_27;
  tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
  highp vec2 tmpvar_28;
  tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
  fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_29;
  tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_30;
  tmpvar_30.x = fetchesOffsetsU_8.x;
  tmpvar_30.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_31;
  tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
  tmpvar_31.z = shadowCoord_5.z;
  highp vec4 tmpvar_32;
  tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
  highp float tmpvar_33;
  if ((tmpvar_32.x < shadowCoord_5.z)) {
    tmpvar_33 = 0.0;
  } else {
    tmpvar_33 = 1.0;
  };
  shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_33);
  highp vec2 tmpvar_34;
  tmpvar_34.x = fetchesOffsetsU_8.y;
  tmpvar_34.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_35;
  tmpvar_35.xy = (tmpvar_29 + tmpvar_34);
  tmpvar_35.z = shadowCoord_5.z;
  highp vec4 tmpvar_36;
  tmpvar_36 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
  highp float tmpvar_37;
  if ((tmpvar_36.x < shadowCoord_5.z)) {
    tmpvar_37 = 0.0;
  } else {
    tmpvar_37 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_37));
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_8.x;
  tmpvar_38.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_29 + tmpvar_38);
  tmpvar_39.z = shadowCoord_5.z;
  highp vec4 tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
  highp float tmpvar_41;
  if ((tmpvar_40.x < shadowCoord_5.z)) {
    tmpvar_41 = 0.0;
  } else {
    tmpvar_41 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_41));
  highp vec2 tmpvar_42;
  tmpvar_42.x = fetchesOffsetsU_8.y;
  tmpvar_42.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_43;
  tmpvar_43.xy = (tmpvar_29 + tmpvar_42);
  tmpvar_43.z = shadowCoord_5.z;
  highp vec4 tmpvar_44;
  tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
  highp float tmpvar_45;
  if ((tmpvar_44.x < shadowCoord_5.z)) {
    tmpvar_45 = 0.0;
  } else {
    tmpvar_45 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_45));
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_46;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_47;
  tmpvar_47 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_47 * tmpvar_47)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_48;
  tmpvar_48 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_50;
  tmpvar_50 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_51;
  tmpvar_51 = (((vec3(
    mix (1.0, shadow_9, LIGHT_PARAM.y)
  ) * specColor_2.yyy) * (LIGHT_COLOR * vec3(0.5, 0.5, 0.5))) * ((vec3(tmpvar_49) * tmpvar_50) * tmpvar_50));
  backDiffuse_1 = (tmpvar_51 / (tmpvar_51 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_49));
  highp vec4 tmpvar_52;
  tmpvar_52.w = 1.0;
  tmpvar_52.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_52;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_5;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_6;
  tmpvar_6 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_6 * tmpvar_6)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10 = (((specColor_2.yyy * LIGHT_COLOR) * (vec3(0.5, 0.5, 0.5) * vec3(tmpvar_8))) * (tmpvar_9 * tmpvar_9));
  backDiffuse_1 = (tmpvar_10 / (tmpvar_10 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_8));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "baseColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform highp vec4 baseColor;
uniform highp float smoothness2;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec3 backDiffuse_1;
  highp vec4 specColor_2;
  highp float smoothness_3;
  highp vec4 albedo_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (diffuseTex, xlv_TEXCOORD0);
  albedo_4 = tmpvar_5;
  smoothness_3 = (1.0 - smoothness2);
  highp float tmpvar_6;
  tmpvar_6 = (smoothness_3 * smoothness_3);
  smoothness_3 = ((2.0 / max (
    (tmpvar_6 * tmpvar_6)
  , 0.0001)) - 2.0);
  smoothness_3 = max (smoothness_3, 0.0001);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (specularTex, xlv_TEXCOORD0);
  specColor_2 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = clamp (dot (-(LIGHT_GIVEN_DIRECTION), normalize(xlv_TEXCOORD1.xyz)), 0.0, 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = (baseColor.xyz * albedo_4.xyz);
  highp vec3 tmpvar_10;
  tmpvar_10 = (((specColor_2.yyy * LIGHT_COLOR) * (vec3(0.5, 0.5, 0.5) * vec3(tmpvar_8))) * (tmpvar_9 * tmpvar_9));
  backDiffuse_1 = (tmpvar_10 / (tmpvar_10 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_1 = (backDiffuse_1 * vec3(tmpvar_8));
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = (backDiffuse_1 * (albedo_4.w * baseColor.w));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end