function DefineParams()
	Properties = 
	{
		
diffuseTex = { "diffuseTex", TEXTURE2D, "white" },
specularTex = {"specularTex", TEXTURE2D, "white"},
normalTex = {"normalTex", TEXTURE2D, "white"},

colorTint = {"color tint", COLOR, "0.0,0.0,0.0,1.0"},

DistrubIntensity = { "DistrubIntensity", FLOAT, "0.5" },
Fresnel = { "Fresnel", FLOAT, "0.5" },

shadeColor = {"shadeColor", COLOR, "0.0,0.0,0.0,1.0"},
shift1 = { "shift1", FLOAT, "0.5" },
shift2 = { "shift2", FLOAT, "0.5" },
smoothness1 = { "smoothness1", FLOAT, "0.5" },
smoothness2 = { "smoothness2", FLOAT, "0.5" },
DefSpecular1 = { "DefSpecular1", COLOR, "1.0,1.0,1.0, 1.0" },
DefSpecular2 = { "DefSpecular2", COLOR, "1.0,1.0,1.0, 1.0" },

LightDir = { "Light Dir", VEC3, "0.0,0.0,1.0" },
LightColor = { "Lighit Color", COLOR, "1.0,1.0,1.0, 1.0" },
LightIntensity = {"Light Intensity", FLOAT, "1.0" },


	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","Depth"
	}

ShaderName = "DollHair"
RenderQueue = "Opaque"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((
    (tmpvar_14.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_14.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_14.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_15);
  };
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_18;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_19;
  tmpvar_19 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_19 * tmpvar_19)
  , 0.0001)) - 2.0);
  highp float tmpvar_20;
  tmpvar_20 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize((tmpvar_17 + tmpvar_21));
  highp float tmpvar_23;
  tmpvar_23 = dot (tmpvar_22, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_24;
  tmpvar_24 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_24;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_25;
  tmpvar_25 = dot (tmpvar_22, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = shadeColor.xyz;
  tmpvar_26.w = smoothness1;
  highp vec4 tmpvar_27;
  tmpvar_27 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_26);
  sw_7 = (tmpvar_27.w * tmpvar_27.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_23 * tmpvar_23))
    , 0.0)), tmpvar_20))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_25 * tmpvar_25)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_17, vNormal_11), 0.0, 1.0));
  highp float tmpvar_28;
  tmpvar_28 = (VDotN_5 * VDotN_5);
  highp float tmpvar_29;
  tmpvar_29 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_28 * tmpvar_28) * VDotN_5)
   * 
    (1.0 - tmpvar_29)
  ) + tmpvar_29)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (LightIntensity * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = abs(dot (tmpvar_21, vNormal_11));
  highp float tmpvar_30;
  tmpvar_30 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_30;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_30)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_31;
  tmpvar_31.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_31.w = 1.0;
  _glesFragData[0] = tmpvar_31;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((
    (tmpvar_14.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_14.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_14.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_15);
  };
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_18;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_19;
  tmpvar_19 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_19 * tmpvar_19)
  , 0.0001)) - 2.0);
  highp float tmpvar_20;
  tmpvar_20 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize((tmpvar_17 + tmpvar_21));
  highp float tmpvar_23;
  tmpvar_23 = dot (tmpvar_22, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_24;
  tmpvar_24 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_24;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_25;
  tmpvar_25 = dot (tmpvar_22, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = shadeColor.xyz;
  tmpvar_26.w = smoothness1;
  highp vec4 tmpvar_27;
  tmpvar_27 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_26);
  sw_7 = (tmpvar_27.w * tmpvar_27.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_23 * tmpvar_23))
    , 0.0)), tmpvar_20))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_25 * tmpvar_25)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_17, vNormal_11), 0.0, 1.0));
  highp float tmpvar_28;
  tmpvar_28 = (VDotN_5 * VDotN_5);
  highp float tmpvar_29;
  tmpvar_29 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_28 * tmpvar_28) * VDotN_5)
   * 
    (1.0 - tmpvar_29)
  ) + tmpvar_29)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (LightIntensity * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = abs(dot (tmpvar_21, vNormal_11));
  highp float tmpvar_30;
  tmpvar_30 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_30;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_30)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_31;
  tmpvar_31.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_31.w = 1.0;
  _glesFragData[0] = tmpvar_31;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_15;
    highp vec2 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 computedWeight_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_20.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_20.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    computedWeight_21 = (computedArea_22 * 0.44444);
    highp vec4 computedWeight_28;
    highp vec4 computedArea_29;
    highp vec4 computedAreaUncut_30;
    highp float tmpvar_31;
    tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_32;
    tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
    computedArea_29.x = tmpvar_32;
    computedAreaUncut_30.x = tmpvar_32;
    computedArea_29.w = tmpvar_31;
    computedAreaUncut_30.w = tmpvar_31;
    computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = min (tmpvar_20.y, 0.0);
    computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
    computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = max (tmpvar_20.y, 0.0);
    computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
    computedWeight_28 = (computedArea_29 * 0.44444);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
    fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_16.x;
    tmpvar_38.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_13.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_16.y;
    tmpvar_41.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_16.x;
    tmpvar_44.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_13.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_16.y;
    tmpvar_47.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_13.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  lowp vec3 tmpvar_50;
  tmpvar_50 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_50;
  highp vec3 tmpvar_51;
  tmpvar_51 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_52;
  tmpvar_52 = normalize(((
    (tmpvar_51.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_51.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_51.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_52;
  highp vec3 tmpvar_53;
  tmpvar_53.x = xlv_TEXCOORD1.w;
  tmpvar_53.y = xlv_TEXCOORD2.w;
  tmpvar_53.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_54;
  tmpvar_54 = normalize((CAMERA_WORLDPOSITION - tmpvar_53));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_52);
  };
  lowp vec4 tmpvar_55;
  tmpvar_55 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_55;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_56;
  tmpvar_56 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_56 * tmpvar_56)
  , 0.0001)) - 2.0);
  highp float tmpvar_57;
  tmpvar_57 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_57;
  highp vec3 tmpvar_58;
  tmpvar_58 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_59;
  tmpvar_59 = normalize((tmpvar_54 + tmpvar_58));
  highp float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_61;
  tmpvar_61 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_61;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_62;
  tmpvar_62 = dot (tmpvar_59, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_63;
  tmpvar_63.xyz = shadeColor.xyz;
  tmpvar_63.w = smoothness1;
  highp vec4 tmpvar_64;
  tmpvar_64 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_63);
  sw_7 = (tmpvar_64.w * tmpvar_64.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_60 * tmpvar_60))
    , 0.0)), tmpvar_57))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_62 * tmpvar_62)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_54, vNormal_11), 0.0, 1.0));
  highp float tmpvar_65;
  tmpvar_65 = (VDotN_5 * VDotN_5);
  highp float tmpvar_66;
  tmpvar_66 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_65 * tmpvar_65) * VDotN_5)
   * 
    (1.0 - tmpvar_66)
  ) + tmpvar_66)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (
    (LightIntensity * tmpvar_14)
   * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = (abs(dot (tmpvar_58, vNormal_11)) * tmpvar_14);
  highp float tmpvar_67;
  tmpvar_67 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_67;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_67)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_68;
  tmpvar_68.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_68.w = 1.0;
  _glesFragData[0] = tmpvar_68;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_15;
    highp vec3 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 texelsWeightsA_29;
    highp vec3 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.16 * tmpvar_34);
    texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
    texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
    texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
    texelsWeightsB_30.z = (0.16 * tmpvar_33);
    highp vec3 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_21.y;
    tmpvar_38.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.z = texelsWeightsB_30.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_29.y;
    tmpvar_41.yz = texelsWeightsB_30.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_21.y;
    tmpvar_43.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_29.y;
    tmpvar_44.yz = texelsWeightsB_30.xz;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    mediump float tmpvar_51;
    tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    mediump float tmpvar_54;
    tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.x;
    tmpvar_55.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    mediump float tmpvar_57;
    tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.y;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    mediump float tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.z;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    mediump float tmpvar_63;
    tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.x;
    tmpvar_64.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    mediump float tmpvar_66;
    tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.y;
    tmpvar_67.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    mediump float tmpvar_69;
    tmpvar_69 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.z;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    mediump float tmpvar_72;
    tmpvar_72 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  lowp vec3 tmpvar_73;
  tmpvar_73 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_73;
  highp vec3 tmpvar_74;
  tmpvar_74 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_75;
  tmpvar_75 = normalize(((
    (tmpvar_74.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_74.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_74.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_75;
  highp vec3 tmpvar_76;
  tmpvar_76.x = xlv_TEXCOORD1.w;
  tmpvar_76.y = xlv_TEXCOORD2.w;
  tmpvar_76.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_77;
  tmpvar_77 = normalize((CAMERA_WORLDPOSITION - tmpvar_76));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_75);
  };
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_78;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_79;
  tmpvar_79 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_79 * tmpvar_79)
  , 0.0001)) - 2.0);
  highp float tmpvar_80;
  tmpvar_80 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_80;
  highp vec3 tmpvar_81;
  tmpvar_81 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_82;
  tmpvar_82 = normalize((tmpvar_77 + tmpvar_81));
  highp float tmpvar_83;
  tmpvar_83 = dot (tmpvar_82, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_84;
  tmpvar_84 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_84;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_85;
  tmpvar_85 = dot (tmpvar_82, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_86;
  tmpvar_86.xyz = shadeColor.xyz;
  tmpvar_86.w = smoothness1;
  highp vec4 tmpvar_87;
  tmpvar_87 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_86);
  sw_7 = (tmpvar_87.w * tmpvar_87.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_83 * tmpvar_83))
    , 0.0)), tmpvar_80))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_85 * tmpvar_85)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_77, vNormal_11), 0.0, 1.0));
  highp float tmpvar_88;
  tmpvar_88 = (VDotN_5 * VDotN_5);
  highp float tmpvar_89;
  tmpvar_89 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_88 * tmpvar_88) * VDotN_5)
   * 
    (1.0 - tmpvar_89)
  ) + tmpvar_89)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (
    (LightIntensity * tmpvar_14)
   * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = (abs(dot (tmpvar_81, vNormal_11)) * tmpvar_14);
  highp float tmpvar_90;
  tmpvar_90 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_90;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_90)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_91;
  tmpvar_91.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_91.w = 1.0;
  _glesFragData[0] = tmpvar_91;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_15;
    highp vec4 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 texelsWeightsA_29;
    highp vec4 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.081632 * tmpvar_34);
    texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
    texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
    texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
    texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
    texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
    texelsWeightsB_30.w = (0.081632 * tmpvar_33);
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_21.yw;
    tmpvar_38.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.zw = texelsWeightsB_30.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_29.yw;
    tmpvar_41.zw = texelsWeightsB_30.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_21.yw;
    tmpvar_43.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_29.yw;
    tmpvar_44.zw = texelsWeightsB_30.yw;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    mediump float tmpvar_51;
    tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    mediump float tmpvar_54;
    tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.w;
    tmpvar_55.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    mediump float tmpvar_57;
    tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.x;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    mediump float tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.y;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    mediump float tmpvar_63;
    tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.z;
    tmpvar_64.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    mediump float tmpvar_66;
    tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.w;
    tmpvar_67.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    mediump float tmpvar_69;
    tmpvar_69 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.x;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    mediump float tmpvar_72;
    tmpvar_72 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_16.y;
    tmpvar_73.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
    tmpvar_74.z = shadowCoord_13.z;
    mediump float tmpvar_75;
    tmpvar_75 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_16.z;
    tmpvar_76.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
    tmpvar_77.z = shadowCoord_13.z;
    mediump float tmpvar_78;
    tmpvar_78 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_16.w;
    tmpvar_79.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
    tmpvar_80.z = shadowCoord_13.z;
    mediump float tmpvar_81;
    tmpvar_81 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_16.x;
    tmpvar_82.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
    tmpvar_83.z = shadowCoord_13.z;
    mediump float tmpvar_84;
    tmpvar_84 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_16.y;
    tmpvar_85.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
    tmpvar_86.z = shadowCoord_13.z;
    mediump float tmpvar_87;
    tmpvar_87 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_16.z;
    tmpvar_88.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
    tmpvar_89.z = shadowCoord_13.z;
    mediump float tmpvar_90;
    tmpvar_90 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_16.w;
    tmpvar_91.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
    tmpvar_92.z = shadowCoord_13.z;
    mediump float tmpvar_93;
    tmpvar_93 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  lowp vec3 tmpvar_94;
  tmpvar_94 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_94;
  highp vec3 tmpvar_95;
  tmpvar_95 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_96;
  tmpvar_96 = normalize(((
    (tmpvar_95.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_95.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_95.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_96;
  highp vec3 tmpvar_97;
  tmpvar_97.x = xlv_TEXCOORD1.w;
  tmpvar_97.y = xlv_TEXCOORD2.w;
  tmpvar_97.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_98;
  tmpvar_98 = normalize((CAMERA_WORLDPOSITION - tmpvar_97));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_96);
  };
  lowp vec4 tmpvar_99;
  tmpvar_99 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_99;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_100;
  tmpvar_100 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_100 * tmpvar_100)
  , 0.0001)) - 2.0);
  highp float tmpvar_101;
  tmpvar_101 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_101;
  highp vec3 tmpvar_102;
  tmpvar_102 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_103;
  tmpvar_103 = normalize((tmpvar_98 + tmpvar_102));
  highp float tmpvar_104;
  tmpvar_104 = dot (tmpvar_103, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_105;
  tmpvar_105 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_105;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_106;
  tmpvar_106 = dot (tmpvar_103, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_107;
  tmpvar_107.xyz = shadeColor.xyz;
  tmpvar_107.w = smoothness1;
  highp vec4 tmpvar_108;
  tmpvar_108 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_107);
  sw_7 = (tmpvar_108.w * tmpvar_108.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_104 * tmpvar_104))
    , 0.0)), tmpvar_101))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_106 * tmpvar_106)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_98, vNormal_11), 0.0, 1.0));
  highp float tmpvar_109;
  tmpvar_109 = (VDotN_5 * VDotN_5);
  highp float tmpvar_110;
  tmpvar_110 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_109 * tmpvar_109) * VDotN_5)
   * 
    (1.0 - tmpvar_110)
  ) + tmpvar_110)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (
    (LightIntensity * tmpvar_14)
   * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = (abs(dot (tmpvar_102, vNormal_11)) * tmpvar_14);
  highp float tmpvar_111;
  tmpvar_111 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_111;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_111)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_112;
  tmpvar_112.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_112.w = 1.0;
  _glesFragData[0] = tmpvar_112;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    highp vec2 tmpvar_15;
    tmpvar_15.x = LIGHT_PARAM.z;
    tmpvar_15.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_16;
    tmpvar_16.xy = tmpvar_15;
    highp float tmpvar_17;
    tmpvar_17 = (1.0/(LIGHT_PARAM.z));
    tmpvar_16.z = tmpvar_17;
    tmpvar_16.w = tmpvar_17;
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = tmpvar_16.xy;
    shadow_18 = 0.0;
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_13.xy - LIGHT_PARAM.zz);
    tmpvar_20.z = shadowCoord_13.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_18 = tmpvar_22;
    highp vec2 tmpvar_23;
    tmpvar_23.x = 0.0;
    tmpvar_23.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_13.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_13.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_18 = (tmpvar_22 + tmpvar_26);
    highp vec2 tmpvar_27;
    tmpvar_27.x = tmpvar_19.x;
    tmpvar_27.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_28;
    tmpvar_28.xy = (shadowCoord_13.xy + tmpvar_27);
    tmpvar_28.z = shadowCoord_13.z;
    highp vec4 tmpvar_29;
    tmpvar_29 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_28.xy);
    highp float tmpvar_30;
    if ((tmpvar_29.x < xlv_TEXCOORD4.z)) {
      tmpvar_30 = 0.0;
    } else {
      tmpvar_30 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_30);
    highp vec2 tmpvar_31;
    tmpvar_31.y = 0.0;
    tmpvar_31.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = (shadowCoord_13.xy + tmpvar_31);
    tmpvar_32.z = shadowCoord_13.z;
    highp vec4 tmpvar_33;
    tmpvar_33 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_32.xy);
    highp float tmpvar_34;
    if ((tmpvar_33.x < xlv_TEXCOORD4.z)) {
      tmpvar_34 = 0.0;
    } else {
      tmpvar_34 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_34);
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_13.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.y = 0.0;
    tmpvar_37.x = tmpvar_19.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_13.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_13.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = -(LIGHT_PARAM.z);
    tmpvar_41.y = tmpvar_19.y;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_13.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = 0.0;
    tmpvar_45.y = tmpvar_19.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (shadowCoord_13.xy + tmpvar_45);
    tmpvar_46.z = shadowCoord_13.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_48);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_13.xy + LIGHT_PARAM.zz);
    tmpvar_49.z = shadowCoord_13.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_51);
    shadow_18 = (shadow_18 / 9.0);
    tmpvar_14 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  lowp vec3 tmpvar_52;
  tmpvar_52 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_52;
  highp vec3 tmpvar_53;
  tmpvar_53 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_54;
  tmpvar_54 = normalize(((
    (tmpvar_53.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_53.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_53.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_54;
  highp vec3 tmpvar_55;
  tmpvar_55.x = xlv_TEXCOORD1.w;
  tmpvar_55.y = xlv_TEXCOORD2.w;
  tmpvar_55.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_56;
  tmpvar_56 = normalize((CAMERA_WORLDPOSITION - tmpvar_55));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_54);
  };
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_57;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_58;
  tmpvar_58 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_58 * tmpvar_58)
  , 0.0001)) - 2.0);
  highp float tmpvar_59;
  tmpvar_59 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_59;
  highp vec3 tmpvar_60;
  tmpvar_60 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_61;
  tmpvar_61 = normalize((tmpvar_56 + tmpvar_60));
  highp float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_63;
  tmpvar_63 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_63;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_64;
  tmpvar_64 = dot (tmpvar_61, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_65;
  tmpvar_65.xyz = shadeColor.xyz;
  tmpvar_65.w = smoothness1;
  highp vec4 tmpvar_66;
  tmpvar_66 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_65);
  sw_7 = (tmpvar_66.w * tmpvar_66.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_62 * tmpvar_62))
    , 0.0)), tmpvar_59))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_64 * tmpvar_64)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_56, vNormal_11), 0.0, 1.0));
  highp float tmpvar_67;
  tmpvar_67 = (VDotN_5 * VDotN_5);
  highp float tmpvar_68;
  tmpvar_68 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_67 * tmpvar_67) * VDotN_5)
   * 
    (1.0 - tmpvar_68)
  ) + tmpvar_68)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (
    (LightIntensity * tmpvar_14)
   * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = (abs(dot (tmpvar_60, vNormal_11)) * tmpvar_14);
  highp float tmpvar_69;
  tmpvar_69 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_69;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_69)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_70;
  tmpvar_70.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_70.w = 1.0;
  _glesFragData[0] = tmpvar_70;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((
    (tmpvar_14.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_14.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_14.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_15);
  };
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_18;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_19;
  tmpvar_19 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_19 * tmpvar_19)
  , 0.0001)) - 2.0);
  highp float tmpvar_20;
  tmpvar_20 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize((tmpvar_17 + tmpvar_21));
  highp float tmpvar_23;
  tmpvar_23 = dot (tmpvar_22, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_24;
  tmpvar_24 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_24;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_25;
  tmpvar_25 = dot (tmpvar_22, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = shadeColor.xyz;
  tmpvar_26.w = smoothness1;
  highp vec4 tmpvar_27;
  tmpvar_27 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_26);
  sw_7 = (tmpvar_27.w * tmpvar_27.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_23 * tmpvar_23))
    , 0.0)), tmpvar_20))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_25 * tmpvar_25)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_17, vNormal_11), 0.0, 1.0));
  highp float tmpvar_28;
  tmpvar_28 = (VDotN_5 * VDotN_5);
  highp float tmpvar_29;
  tmpvar_29 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_28 * tmpvar_28) * VDotN_5)
   * 
    (1.0 - tmpvar_29)
  ) + tmpvar_29)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (LightIntensity * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = abs(dot (tmpvar_21, vNormal_11));
  highp float tmpvar_30;
  tmpvar_30 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_30;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_30)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_31;
  tmpvar_31.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_31.w = 1.0;
  _glesFragData[0] = tmpvar_31;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((
    (tmpvar_14.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_14.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_14.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_15);
  };
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_18;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_19;
  tmpvar_19 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_19 * tmpvar_19)
  , 0.0001)) - 2.0);
  highp float tmpvar_20;
  tmpvar_20 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize((tmpvar_17 + tmpvar_21));
  highp float tmpvar_23;
  tmpvar_23 = dot (tmpvar_22, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_24;
  tmpvar_24 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_24;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_25;
  tmpvar_25 = dot (tmpvar_22, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_26;
  tmpvar_26.xyz = shadeColor.xyz;
  tmpvar_26.w = smoothness1;
  highp vec4 tmpvar_27;
  tmpvar_27 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_26);
  sw_7 = (tmpvar_27.w * tmpvar_27.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_23 * tmpvar_23))
    , 0.0)), tmpvar_20))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_25 * tmpvar_25)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_17, vNormal_11), 0.0, 1.0));
  highp float tmpvar_28;
  tmpvar_28 = (VDotN_5 * VDotN_5);
  highp float tmpvar_29;
  tmpvar_29 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_28 * tmpvar_28) * VDotN_5)
   * 
    (1.0 - tmpvar_29)
  ) + tmpvar_29)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (LightIntensity * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = abs(dot (tmpvar_21, vNormal_11));
  highp float tmpvar_30;
  tmpvar_30 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_30;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_30)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_31;
  tmpvar_31.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_31.w = 1.0;
  _glesFragData[0] = tmpvar_31;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_15;
    highp vec2 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 computedWeight_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_20.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_20.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    computedWeight_21 = (computedArea_22 * 0.44444);
    highp vec4 computedWeight_28;
    highp vec4 computedArea_29;
    highp vec4 computedAreaUncut_30;
    highp float tmpvar_31;
    tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_32;
    tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
    computedArea_29.x = tmpvar_32;
    computedAreaUncut_30.x = tmpvar_32;
    computedArea_29.w = tmpvar_31;
    computedAreaUncut_30.w = tmpvar_31;
    computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = min (tmpvar_20.y, 0.0);
    computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
    computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = max (tmpvar_20.y, 0.0);
    computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
    computedWeight_28 = (computedArea_29 * 0.44444);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
    fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_16.x;
    tmpvar_38.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_13.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_16.y;
    tmpvar_41.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_16.x;
    tmpvar_44.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_13.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_16.y;
    tmpvar_47.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_13.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  lowp vec3 tmpvar_50;
  tmpvar_50 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_50;
  highp vec3 tmpvar_51;
  tmpvar_51 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_52;
  tmpvar_52 = normalize(((
    (tmpvar_51.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_51.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_51.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_52;
  highp vec3 tmpvar_53;
  tmpvar_53.x = xlv_TEXCOORD1.w;
  tmpvar_53.y = xlv_TEXCOORD2.w;
  tmpvar_53.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_54;
  tmpvar_54 = normalize((CAMERA_WORLDPOSITION - tmpvar_53));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_52);
  };
  lowp vec4 tmpvar_55;
  tmpvar_55 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_55;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_56;
  tmpvar_56 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_56 * tmpvar_56)
  , 0.0001)) - 2.0);
  highp float tmpvar_57;
  tmpvar_57 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_57;
  highp vec3 tmpvar_58;
  tmpvar_58 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_59;
  tmpvar_59 = normalize((tmpvar_54 + tmpvar_58));
  highp float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_61;
  tmpvar_61 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_61;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_62;
  tmpvar_62 = dot (tmpvar_59, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_63;
  tmpvar_63.xyz = shadeColor.xyz;
  tmpvar_63.w = smoothness1;
  highp vec4 tmpvar_64;
  tmpvar_64 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_63);
  sw_7 = (tmpvar_64.w * tmpvar_64.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_60 * tmpvar_60))
    , 0.0)), tmpvar_57))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_62 * tmpvar_62)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_54, vNormal_11), 0.0, 1.0));
  highp float tmpvar_65;
  tmpvar_65 = (VDotN_5 * VDotN_5);
  highp float tmpvar_66;
  tmpvar_66 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_65 * tmpvar_65) * VDotN_5)
   * 
    (1.0 - tmpvar_66)
  ) + tmpvar_66)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (
    (LightIntensity * tmpvar_14)
   * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = (abs(dot (tmpvar_58, vNormal_11)) * tmpvar_14);
  highp float tmpvar_67;
  tmpvar_67 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_67;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_67)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_68;
  tmpvar_68.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_68.w = 1.0;
  _glesFragData[0] = tmpvar_68;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_15;
    highp vec3 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 texelsWeightsA_29;
    highp vec3 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.16 * tmpvar_34);
    texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
    texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
    texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
    texelsWeightsB_30.z = (0.16 * tmpvar_33);
    highp vec3 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_21.y;
    tmpvar_38.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.z = texelsWeightsB_30.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_29.y;
    tmpvar_41.yz = texelsWeightsB_30.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_21.y;
    tmpvar_43.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_29.y;
    tmpvar_44.yz = texelsWeightsB_30.xz;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    mediump float tmpvar_51;
    tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    mediump float tmpvar_54;
    tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.x;
    tmpvar_55.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    mediump float tmpvar_57;
    tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.y;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    mediump float tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.z;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    mediump float tmpvar_63;
    tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.x;
    tmpvar_64.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    mediump float tmpvar_66;
    tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.y;
    tmpvar_67.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    mediump float tmpvar_69;
    tmpvar_69 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.z;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    mediump float tmpvar_72;
    tmpvar_72 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  lowp vec3 tmpvar_73;
  tmpvar_73 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_73;
  highp vec3 tmpvar_74;
  tmpvar_74 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_75;
  tmpvar_75 = normalize(((
    (tmpvar_74.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_74.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_74.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_75;
  highp vec3 tmpvar_76;
  tmpvar_76.x = xlv_TEXCOORD1.w;
  tmpvar_76.y = xlv_TEXCOORD2.w;
  tmpvar_76.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_77;
  tmpvar_77 = normalize((CAMERA_WORLDPOSITION - tmpvar_76));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_75);
  };
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_78;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_79;
  tmpvar_79 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_79 * tmpvar_79)
  , 0.0001)) - 2.0);
  highp float tmpvar_80;
  tmpvar_80 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_80;
  highp vec3 tmpvar_81;
  tmpvar_81 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_82;
  tmpvar_82 = normalize((tmpvar_77 + tmpvar_81));
  highp float tmpvar_83;
  tmpvar_83 = dot (tmpvar_82, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_84;
  tmpvar_84 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_84;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_85;
  tmpvar_85 = dot (tmpvar_82, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_86;
  tmpvar_86.xyz = shadeColor.xyz;
  tmpvar_86.w = smoothness1;
  highp vec4 tmpvar_87;
  tmpvar_87 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_86);
  sw_7 = (tmpvar_87.w * tmpvar_87.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_83 * tmpvar_83))
    , 0.0)), tmpvar_80))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_85 * tmpvar_85)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_77, vNormal_11), 0.0, 1.0));
  highp float tmpvar_88;
  tmpvar_88 = (VDotN_5 * VDotN_5);
  highp float tmpvar_89;
  tmpvar_89 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_88 * tmpvar_88) * VDotN_5)
   * 
    (1.0 - tmpvar_89)
  ) + tmpvar_89)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (
    (LightIntensity * tmpvar_14)
   * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = (abs(dot (tmpvar_81, vNormal_11)) * tmpvar_14);
  highp float tmpvar_90;
  tmpvar_90 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_90;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_90)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_91;
  tmpvar_91.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_91.w = 1.0;
  _glesFragData[0] = tmpvar_91;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_15;
    highp vec4 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 texelsWeightsA_29;
    highp vec4 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.081632 * tmpvar_34);
    texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
    texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
    texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
    texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
    texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
    texelsWeightsB_30.w = (0.081632 * tmpvar_33);
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_21.yw;
    tmpvar_38.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.zw = texelsWeightsB_30.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_29.yw;
    tmpvar_41.zw = texelsWeightsB_30.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_21.yw;
    tmpvar_43.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_29.yw;
    tmpvar_44.zw = texelsWeightsB_30.yw;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    mediump float tmpvar_51;
    tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    mediump float tmpvar_54;
    tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.w;
    tmpvar_55.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    mediump float tmpvar_57;
    tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.x;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    mediump float tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.y;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    mediump float tmpvar_63;
    tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.z;
    tmpvar_64.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    mediump float tmpvar_66;
    tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.w;
    tmpvar_67.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    mediump float tmpvar_69;
    tmpvar_69 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.x;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    mediump float tmpvar_72;
    tmpvar_72 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_16.y;
    tmpvar_73.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
    tmpvar_74.z = shadowCoord_13.z;
    mediump float tmpvar_75;
    tmpvar_75 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_16.z;
    tmpvar_76.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
    tmpvar_77.z = shadowCoord_13.z;
    mediump float tmpvar_78;
    tmpvar_78 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_16.w;
    tmpvar_79.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
    tmpvar_80.z = shadowCoord_13.z;
    mediump float tmpvar_81;
    tmpvar_81 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_16.x;
    tmpvar_82.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
    tmpvar_83.z = shadowCoord_13.z;
    mediump float tmpvar_84;
    tmpvar_84 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_16.y;
    tmpvar_85.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
    tmpvar_86.z = shadowCoord_13.z;
    mediump float tmpvar_87;
    tmpvar_87 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_16.z;
    tmpvar_88.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
    tmpvar_89.z = shadowCoord_13.z;
    mediump float tmpvar_90;
    tmpvar_90 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_16.w;
    tmpvar_91.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
    tmpvar_92.z = shadowCoord_13.z;
    mediump float tmpvar_93;
    tmpvar_93 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  lowp vec3 tmpvar_94;
  tmpvar_94 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_94;
  highp vec3 tmpvar_95;
  tmpvar_95 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_96;
  tmpvar_96 = normalize(((
    (tmpvar_95.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_95.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_95.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_96;
  highp vec3 tmpvar_97;
  tmpvar_97.x = xlv_TEXCOORD1.w;
  tmpvar_97.y = xlv_TEXCOORD2.w;
  tmpvar_97.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_98;
  tmpvar_98 = normalize((CAMERA_WORLDPOSITION - tmpvar_97));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_96);
  };
  lowp vec4 tmpvar_99;
  tmpvar_99 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_99;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_100;
  tmpvar_100 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_100 * tmpvar_100)
  , 0.0001)) - 2.0);
  highp float tmpvar_101;
  tmpvar_101 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_101;
  highp vec3 tmpvar_102;
  tmpvar_102 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_103;
  tmpvar_103 = normalize((tmpvar_98 + tmpvar_102));
  highp float tmpvar_104;
  tmpvar_104 = dot (tmpvar_103, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_105;
  tmpvar_105 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_105;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_106;
  tmpvar_106 = dot (tmpvar_103, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_107;
  tmpvar_107.xyz = shadeColor.xyz;
  tmpvar_107.w = smoothness1;
  highp vec4 tmpvar_108;
  tmpvar_108 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_107);
  sw_7 = (tmpvar_108.w * tmpvar_108.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_104 * tmpvar_104))
    , 0.0)), tmpvar_101))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_106 * tmpvar_106)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_98, vNormal_11), 0.0, 1.0));
  highp float tmpvar_109;
  tmpvar_109 = (VDotN_5 * VDotN_5);
  highp float tmpvar_110;
  tmpvar_110 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_109 * tmpvar_109) * VDotN_5)
   * 
    (1.0 - tmpvar_110)
  ) + tmpvar_110)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (
    (LightIntensity * tmpvar_14)
   * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = (abs(dot (tmpvar_102, vNormal_11)) * tmpvar_14);
  highp float tmpvar_111;
  tmpvar_111 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_111;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_111)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_112;
  tmpvar_112.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_112.w = 1.0;
  _glesFragData[0] = tmpvar_112;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "normalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "colorTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DistrubIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "shift2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "smoothness2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular1",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DefSpecular2",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseTex;
uniform sampler2D specularTex;
uniform sampler2D normalTex;
uniform highp vec4 colorTint;
uniform highp vec4 shadeColor;
uniform highp float DistrubIntensity;
uniform highp float Fresnel;
uniform highp float shift1;
uniform highp float shift2;
uniform highp float smoothness1;
uniform highp float smoothness2;
uniform highp vec4 DefSpecular1;
uniform highp vec4 DefSpecular2;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float tmpvar_1;
  if (gl_FrontFacing) {
    tmpvar_1 = 1.0;
  } else {
    tmpvar_1 = -1.0;
  };
  highp vec3 frontDiffuse_2;
  highp float LdotN_3;
  highp vec3 backDiffuse_4;
  highp float VDotN_5;
  highp vec3 compositeColor_6;
  highp float sw_7;
  highp vec4 specColor_8;
  highp float smoothness_9;
  highp vec4 mainColor_10;
  highp vec3 vNormal_11;
  highp vec3 mainNormal_12;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    highp vec2 tmpvar_15;
    tmpvar_15.x = LIGHT_PARAM.z;
    tmpvar_15.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_16;
    tmpvar_16.xy = tmpvar_15;
    highp float tmpvar_17;
    tmpvar_17 = (1.0/(LIGHT_PARAM.z));
    tmpvar_16.z = tmpvar_17;
    tmpvar_16.w = tmpvar_17;
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = tmpvar_16.xy;
    shadow_18 = 0.0;
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_13.xy - LIGHT_PARAM.zz);
    tmpvar_20.z = shadowCoord_13.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_18 = tmpvar_22;
    highp vec2 tmpvar_23;
    tmpvar_23.x = 0.0;
    tmpvar_23.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_13.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_13.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_18 = (tmpvar_22 + tmpvar_26);
    highp vec2 tmpvar_27;
    tmpvar_27.x = tmpvar_19.x;
    tmpvar_27.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_28;
    tmpvar_28.xy = (shadowCoord_13.xy + tmpvar_27);
    tmpvar_28.z = shadowCoord_13.z;
    highp vec4 tmpvar_29;
    tmpvar_29 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_28.xy);
    highp float tmpvar_30;
    if ((tmpvar_29.x < xlv_TEXCOORD4.z)) {
      tmpvar_30 = 0.0;
    } else {
      tmpvar_30 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_30);
    highp vec2 tmpvar_31;
    tmpvar_31.y = 0.0;
    tmpvar_31.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = (shadowCoord_13.xy + tmpvar_31);
    tmpvar_32.z = shadowCoord_13.z;
    highp vec4 tmpvar_33;
    tmpvar_33 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_32.xy);
    highp float tmpvar_34;
    if ((tmpvar_33.x < xlv_TEXCOORD4.z)) {
      tmpvar_34 = 0.0;
    } else {
      tmpvar_34 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_34);
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_13.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.y = 0.0;
    tmpvar_37.x = tmpvar_19.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_13.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_13.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = -(LIGHT_PARAM.z);
    tmpvar_41.y = tmpvar_19.y;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_13.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = 0.0;
    tmpvar_45.y = tmpvar_19.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (shadowCoord_13.xy + tmpvar_45);
    tmpvar_46.z = shadowCoord_13.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_48);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_13.xy + LIGHT_PARAM.zz);
    tmpvar_49.z = shadowCoord_13.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_51);
    shadow_18 = (shadow_18 / 9.0);
    tmpvar_14 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  lowp vec3 tmpvar_52;
  tmpvar_52 = texture (normalTex, xlv_TEXCOORD0).xyz;
  mainNormal_12 = tmpvar_52;
  highp vec3 tmpvar_53;
  tmpvar_53 = ((mainNormal_12 * 2.0) - 1.0);
  highp vec3 tmpvar_54;
  tmpvar_54 = normalize(((
    (tmpvar_53.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_53.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_53.z * xlv_TEXCOORD1.xyz)));
  vNormal_11 = tmpvar_54;
  highp vec3 tmpvar_55;
  tmpvar_55.x = xlv_TEXCOORD1.w;
  tmpvar_55.y = xlv_TEXCOORD2.w;
  tmpvar_55.z = xlv_TEXCOORD2.w;
  highp vec3 tmpvar_56;
  tmpvar_56 = normalize((CAMERA_WORLDPOSITION - tmpvar_55));
  if (!(bool(tmpvar_1))) {
    vNormal_11 = -(tmpvar_54);
  };
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture (diffuseTex, xlv_TEXCOORD0);
  mainColor_10 = tmpvar_57;
  mainColor_10 = (mainColor_10 * colorTint);
  mainColor_10.xyz = (mainColor_10.xyz * mainColor_10.xyz);
  smoothness_9 = (1.0 - smoothness2);
  highp float tmpvar_58;
  tmpvar_58 = (smoothness_9 * smoothness_9);
  smoothness_9 = ((2.0 / max (
    (tmpvar_58 * tmpvar_58)
  , 0.0001)) - 2.0);
  highp float tmpvar_59;
  tmpvar_59 = max (smoothness_9, 0.0001);
  smoothness_9 = tmpvar_59;
  highp vec3 tmpvar_60;
  tmpvar_60 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_61;
  tmpvar_61 = normalize((tmpvar_56 + tmpvar_60));
  highp float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, normalize((xlv_TEXCOORD2.xyz - 
    (vNormal_11 * vec3(shift2))
  )));
  lowp vec4 tmpvar_63;
  tmpvar_63 = texture (specularTex, xlv_TEXCOORD0);
  specColor_8 = tmpvar_63;
  sw_7 = (((
    (specColor_8.w * 2.0)
   - 1.0) * DistrubIntensity) + shift1);
  highp float tmpvar_64;
  tmpvar_64 = dot (tmpvar_61, normalize((xlv_TEXCOORD2.xyz + 
    (sw_7 * vNormal_11)
  )));
  highp vec4 tmpvar_65;
  tmpvar_65.xyz = shadeColor.xyz;
  tmpvar_65.w = smoothness1;
  highp vec4 tmpvar_66;
  tmpvar_66 = (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_65);
  sw_7 = (tmpvar_66.w * tmpvar_66.w);
  compositeColor_6 = (((DefSpecular2.xyz * vec3(
    (specColor_8.y * pow (sqrt(max (
      (1.0 - (tmpvar_62 * tmpvar_62))
    , 0.0)), tmpvar_59))
  )) + (DefSpecular1.xyz * 
    pow (sqrt(max ((1.0 - 
      (tmpvar_64 * tmpvar_64)
    ), 0.0)), max (((2.0 / 
      max ((sw_7 * sw_7), 0.0001)
    ) - 2.0), 0.0001))
  )) * specColor_8.xyz);
  compositeColor_6 = (compositeColor_6 * LIGHT_COLOR);
  VDotN_5 = (1.0 - clamp (dot (tmpvar_56, vNormal_11), 0.0, 1.0));
  highp float tmpvar_67;
  tmpvar_67 = (VDotN_5 * VDotN_5);
  highp float tmpvar_68;
  tmpvar_68 = min (((smoothness1 * 0.6) + Fresnel), 1.0);
  compositeColor_6 = (compositeColor_6 * vec3(((
    ((tmpvar_67 * tmpvar_67) * VDotN_5)
   * 
    (1.0 - tmpvar_68)
  ) + tmpvar_68)));
  compositeColor_6 = (compositeColor_6 * specColor_8.xyz);
  backDiffuse_4 = (((specColor_8.y * LightColor) * (
    (LightIntensity * tmpvar_14)
   * 0.5)).xyz * mainColor_10.xyz);
  backDiffuse_4 = (backDiffuse_4 / (backDiffuse_4 + vec3(1.0, 1.0, 1.0)));
  backDiffuse_4 = (backDiffuse_4 * max (dot (
    -(LightDir)
  , vNormal_11), 0.0));
  LdotN_3 = (abs(dot (tmpvar_60, vNormal_11)) * tmpvar_14);
  highp float tmpvar_69;
  tmpvar_69 = min (LdotN_3, 1.0);
  LdotN_3 = tmpvar_69;
  frontDiffuse_2 = ((mix (shadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(tmpvar_69)) * LIGHT_COLOR) + AMBIENT_COLOR);
  frontDiffuse_2 = (frontDiffuse_2 * mainColor_10.xyz);
  highp vec4 tmpvar_70;
  tmpvar_70.xyz = (compositeColor_6 + (frontDiffuse_2 + backDiffuse_4));
  tmpvar_70.w = 1.0;
  _glesFragData[0] = tmpvar_70;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end