function DefineParams()
	Properties = 
	{
		
diffuseMap = { "diffuseMap", TEXTURE2D, "white" },
specularMap = { "specularMap", TEXTURE2D, "white" },
heightMap = { "heightMap", TEXTURE2D, "white" },

movespeed1 = { "movespeed1", FLOAT, "0.5" },
movespeed2 = { "movespeed2", FLOAT, "0.5" },  
movespeed3 = { "movespeed3", FLOAT, "0.5" },
eyeheight = { "eyeheight", FLOAT, "0.5" },

specoffset1 = { "specoffset1", VEC3, "0.0,0.0,0.0" },
specoffset2 = { "specoffset2", VEC3, "0.0,0.0,0.0" },
specoffset3 = { "specoffset3", VEC3, "0.0,0.0,0.0" },
initoffset = { "initoffset", VEC3, "0.0,0.0,0.0" },
intensity = { "intensity", VEC3, "0.0,0.0,0.0" },


in_LightDirection = { "LIGHT1DIR", VEC3, "0.0,0.0,1.0" },
LIGHT1COLOR = { "LIGHT1COLOR", COLOR, "1.0,1.0,1.0,1.0" },
Light1Intensity = { "LIGHT1INTENSITY", FLOAT, "1.0" },
 

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","Depth"
	}

ShaderName = "DollEye"
RenderQueue = "Opaque"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }
 

Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = tmpvar_9[0].xyz;
  tmpvar_12[1] = tmpvar_9[1].xyz;
  tmpvar_12[2] = tmpvar_9[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = tmpvar_9[0].xyz;
  tmpvar_14[1] = tmpvar_9[1].xyz;
  tmpvar_14[2] = tmpvar_9[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_9[0].xyz;
  tmpvar_16[1] = tmpvar_9[1].xyz;
  tmpvar_16[2] = tmpvar_9[2].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_13 * (vec3(1.0, 0.0, 0.0) * tmpvar_14)));
  xlv_TEXCOORD5 = normalize((tmpvar_15 * (vec3(0.0, 1.0, 0.0) * tmpvar_16)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float specular2_8;
  highp vec2 coord2_9;
  highp float specular1_10;
  highp vec2 coord1_11;
  highp float specular0_12;
  highp vec2 coord0_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_15;
  tmpvar_15 = dot (tmpvar_14, xlv_TEXCOORD4);
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_14, xlv_TEXCOORD5);
  highp vec2 tmpvar_17;
  tmpvar_17.x = ((-(tmpvar_15) * tmpvar_15) * tmpvar_15);
  tmpvar_17.y = -(tmpvar_15);
  coord0_13 = (tmpvar_17 * movespeed1);
  coord0_13 = (coord0_13 * specoffset1.xy);
  highp vec2 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.x;
  highp float tmpvar_19;
  tmpvar_19 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_18.y = tmpvar_19;
  coord0_13 = ((coord0_13 + initoffset.xy) + tmpvar_18);
  coord0_13.y = (1.0 - coord0_13.y);
  lowp float tmpvar_20;
  tmpvar_20 = texture2D (specularMap, coord0_13).x;
  specular0_12 = tmpvar_20;
  highp vec2 tmpvar_21;
  tmpvar_21.x = tmpvar_15;
  tmpvar_21.y = -(tmpvar_16);
  coord1_11 = (tmpvar_21 * movespeed2);
  coord1_11 = (coord1_11 * specoffset2.xy);
  highp vec2 tmpvar_22;
  tmpvar_22.x = xlv_TEXCOORD1.x;
  tmpvar_22.y = tmpvar_19;
  coord1_11 = ((coord1_11 + initoffset.xy) + tmpvar_22);
  coord1_11.y = (1.0 - coord1_11.y);
  lowp float tmpvar_23;
  tmpvar_23 = texture2D (specularMap, coord1_11).y;
  specular1_10 = tmpvar_23;
  coord2_9 = (abs(vec2(tmpvar_15)) * movespeed3);
  coord2_9 = (coord2_9 * specoffset3.xy);
  highp vec2 tmpvar_24;
  tmpvar_24.x = xlv_TEXCOORD1.x;
  tmpvar_24.y = tmpvar_19;
  coord2_9 = ((coord2_9 + initoffset.xy) + tmpvar_24);
  coord2_9.y = (1.0 - coord2_9.y);
  lowp float tmpvar_25;
  tmpvar_25 = texture2D (specularMap, coord2_9).z;
  specular2_8 = tmpvar_25;
  highp vec3 tmpvar_26;
  tmpvar_26.x = specular0_12;
  tmpvar_26.y = specular1_10;
  tmpvar_26.z = specular2_8;
  highp vec2 tmpvar_27;
  tmpvar_27.x = tmpvar_15;
  tmpvar_27.y = -(tmpvar_16);
  highp vec2 tmpvar_28;
  tmpvar_28 = ((tmpvar_27 * eyeheight) * 0.5);
  lowp float tmpvar_29;
  tmpvar_29 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_29;
  highp vec2 tmpvar_30;
  tmpvar_30.x = xlv_TEXCOORD0.x;
  highp float tmpvar_31;
  tmpvar_31 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_30.y = tmpvar_31;
  highp vec2 tmpvar_32;
  tmpvar_32 = ((vec2(height0_7) * tmpvar_28) + tmpvar_30);
  hcoord1_6.x = tmpvar_32.x;
  hcoord1_6.y = (1.0 - tmpvar_32.y);
  lowp float tmpvar_33;
  tmpvar_33 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_33;
  highp vec2 tmpvar_34;
  tmpvar_34.x = xlv_TEXCOORD0.x;
  tmpvar_34.y = tmpvar_31;
  highp vec2 tmpvar_35;
  tmpvar_35 = ((vec2(height1_5) * tmpvar_28) + tmpvar_34);
  hcoord2_4.x = tmpvar_35.x;
  hcoord2_4.y = (1.0 - tmpvar_35.y);
  lowp float tmpvar_36;
  tmpvar_36 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_36;
  highp vec2 tmpvar_37;
  tmpvar_37.x = xlv_TEXCOORD0.x;
  tmpvar_37.y = tmpvar_31;
  highp vec2 tmpvar_38;
  tmpvar_38 = ((vec2(height2_3) * tmpvar_28) + tmpvar_37);
  hcoord3_2.x = tmpvar_38.x;
  hcoord3_2.y = (1.0 - tmpvar_38.y);
  lowp vec3 tmpvar_39;
  tmpvar_39 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_39;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 tmpvar_40;
  tmpvar_40.w = 1.0;
  tmpvar_40.xyz = ((mainColor_1 + vec3(dot (tmpvar_26, intensity))) * ((LIGHT1COLOR.xyz * Light1Intensity) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_40;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = tmpvar_9[0].xyz;
  tmpvar_12[1] = tmpvar_9[1].xyz;
  tmpvar_12[2] = tmpvar_9[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = tmpvar_9[0].xyz;
  tmpvar_14[1] = tmpvar_9[1].xyz;
  tmpvar_14[2] = tmpvar_9[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_9[0].xyz;
  tmpvar_16[1] = tmpvar_9[1].xyz;
  tmpvar_16[2] = tmpvar_9[2].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_13 * (vec3(1.0, 0.0, 0.0) * tmpvar_14)));
  xlv_TEXCOORD5 = normalize((tmpvar_15 * (vec3(0.0, 1.0, 0.0) * tmpvar_16)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float specular2_8;
  highp vec2 coord2_9;
  highp float specular1_10;
  highp vec2 coord1_11;
  highp float specular0_12;
  highp vec2 coord0_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_15;
  tmpvar_15 = dot (tmpvar_14, xlv_TEXCOORD4);
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_14, xlv_TEXCOORD5);
  highp vec2 tmpvar_17;
  tmpvar_17.x = ((-(tmpvar_15) * tmpvar_15) * tmpvar_15);
  tmpvar_17.y = -(tmpvar_15);
  coord0_13 = (tmpvar_17 * movespeed1);
  coord0_13 = (coord0_13 * specoffset1.xy);
  highp vec2 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.x;
  highp float tmpvar_19;
  tmpvar_19 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_18.y = tmpvar_19;
  coord0_13 = ((coord0_13 + initoffset.xy) + tmpvar_18);
  coord0_13.y = (1.0 - coord0_13.y);
  lowp float tmpvar_20;
  tmpvar_20 = texture2D (specularMap, coord0_13).x;
  specular0_12 = tmpvar_20;
  highp vec2 tmpvar_21;
  tmpvar_21.x = tmpvar_15;
  tmpvar_21.y = -(tmpvar_16);
  coord1_11 = (tmpvar_21 * movespeed2);
  coord1_11 = (coord1_11 * specoffset2.xy);
  highp vec2 tmpvar_22;
  tmpvar_22.x = xlv_TEXCOORD1.x;
  tmpvar_22.y = tmpvar_19;
  coord1_11 = ((coord1_11 + initoffset.xy) + tmpvar_22);
  coord1_11.y = (1.0 - coord1_11.y);
  lowp float tmpvar_23;
  tmpvar_23 = texture2D (specularMap, coord1_11).y;
  specular1_10 = tmpvar_23;
  coord2_9 = (abs(vec2(tmpvar_15)) * movespeed3);
  coord2_9 = (coord2_9 * specoffset3.xy);
  highp vec2 tmpvar_24;
  tmpvar_24.x = xlv_TEXCOORD1.x;
  tmpvar_24.y = tmpvar_19;
  coord2_9 = ((coord2_9 + initoffset.xy) + tmpvar_24);
  coord2_9.y = (1.0 - coord2_9.y);
  lowp float tmpvar_25;
  tmpvar_25 = texture2D (specularMap, coord2_9).z;
  specular2_8 = tmpvar_25;
  highp vec3 tmpvar_26;
  tmpvar_26.x = specular0_12;
  tmpvar_26.y = specular1_10;
  tmpvar_26.z = specular2_8;
  highp vec2 tmpvar_27;
  tmpvar_27.x = tmpvar_15;
  tmpvar_27.y = -(tmpvar_16);
  highp vec2 tmpvar_28;
  tmpvar_28 = ((tmpvar_27 * eyeheight) * 0.5);
  lowp float tmpvar_29;
  tmpvar_29 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_29;
  highp vec2 tmpvar_30;
  tmpvar_30.x = xlv_TEXCOORD0.x;
  highp float tmpvar_31;
  tmpvar_31 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_30.y = tmpvar_31;
  highp vec2 tmpvar_32;
  tmpvar_32 = ((vec2(height0_7) * tmpvar_28) + tmpvar_30);
  hcoord1_6.x = tmpvar_32.x;
  hcoord1_6.y = (1.0 - tmpvar_32.y);
  lowp float tmpvar_33;
  tmpvar_33 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_33;
  highp vec2 tmpvar_34;
  tmpvar_34.x = xlv_TEXCOORD0.x;
  tmpvar_34.y = tmpvar_31;
  highp vec2 tmpvar_35;
  tmpvar_35 = ((vec2(height1_5) * tmpvar_28) + tmpvar_34);
  hcoord2_4.x = tmpvar_35.x;
  hcoord2_4.y = (1.0 - tmpvar_35.y);
  lowp float tmpvar_36;
  tmpvar_36 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_36;
  highp vec2 tmpvar_37;
  tmpvar_37.x = xlv_TEXCOORD0.x;
  tmpvar_37.y = tmpvar_31;
  highp vec2 tmpvar_38;
  tmpvar_38 = ((vec2(height2_3) * tmpvar_28) + tmpvar_37);
  hcoord3_2.x = tmpvar_38.x;
  hcoord3_2.y = (1.0 - tmpvar_38.y);
  lowp vec3 tmpvar_39;
  tmpvar_39 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_39;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 tmpvar_40;
  tmpvar_40.w = 1.0;
  tmpvar_40.xyz = ((mainColor_1 + vec3(dot (tmpvar_26, intensity))) * ((LIGHT1COLOR.xyz * Light1Intensity) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_40;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_10[0].xyz;
  tmpvar_15[1] = tmpvar_10[1].xyz;
  tmpvar_15[2] = tmpvar_10[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_10[0].xyz;
  tmpvar_17[1] = tmpvar_10[1].xyz;
  tmpvar_17[2] = tmpvar_10[2].xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)))
  ).xyz * 0.5) + 0.5);
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_14 * (vec3(1.0, 0.0, 0.0) * tmpvar_15)));
  xlv_TEXCOORD5 = normalize((tmpvar_16 * (vec3(0.0, 1.0, 0.0) * tmpvar_17)));
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD6 = tmpvar_2;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float totalSpecular_8;
  highp float specular2_9;
  highp vec2 coord2_10;
  highp float specular1_11;
  highp vec2 coord1_12;
  highp float specular0_13;
  highp vec2 coord0_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_15, xlv_TEXCOORD4);
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_15, xlv_TEXCOORD5);
  highp vec2 tmpvar_18;
  tmpvar_18.x = ((-(tmpvar_16) * tmpvar_16) * tmpvar_16);
  tmpvar_18.y = -(tmpvar_16);
  coord0_14 = (tmpvar_18 * movespeed1);
  coord0_14 = (coord0_14 * specoffset1.xy);
  highp vec2 tmpvar_19;
  tmpvar_19.x = xlv_TEXCOORD1.x;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_19.y = tmpvar_20;
  coord0_14 = ((coord0_14 + initoffset.xy) + tmpvar_19);
  coord0_14.y = (1.0 - coord0_14.y);
  lowp float tmpvar_21;
  tmpvar_21 = texture2D (specularMap, coord0_14).x;
  specular0_13 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22.x = tmpvar_16;
  tmpvar_22.y = -(tmpvar_17);
  coord1_12 = (tmpvar_22 * movespeed2);
  coord1_12 = (coord1_12 * specoffset2.xy);
  highp vec2 tmpvar_23;
  tmpvar_23.x = xlv_TEXCOORD1.x;
  tmpvar_23.y = tmpvar_20;
  coord1_12 = ((coord1_12 + initoffset.xy) + tmpvar_23);
  coord1_12.y = (1.0 - coord1_12.y);
  lowp float tmpvar_24;
  tmpvar_24 = texture2D (specularMap, coord1_12).y;
  specular1_11 = tmpvar_24;
  coord2_10 = (abs(vec2(tmpvar_16)) * movespeed3);
  coord2_10 = (coord2_10 * specoffset3.xy);
  highp vec2 tmpvar_25;
  tmpvar_25.x = xlv_TEXCOORD1.x;
  tmpvar_25.y = tmpvar_20;
  coord2_10 = ((coord2_10 + initoffset.xy) + tmpvar_25);
  coord2_10.y = (1.0 - coord2_10.y);
  lowp float tmpvar_26;
  tmpvar_26 = texture2D (specularMap, coord2_10).z;
  specular2_9 = tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_27.x = specular0_13;
  tmpvar_27.y = specular1_11;
  tmpvar_27.z = specular2_9;
  totalSpecular_8 = dot (tmpvar_27, intensity);
  highp vec2 tmpvar_28;
  tmpvar_28.x = tmpvar_16;
  tmpvar_28.y = -(tmpvar_17);
  highp vec2 tmpvar_29;
  tmpvar_29 = ((tmpvar_28 * eyeheight) * 0.5);
  lowp float tmpvar_30;
  tmpvar_30 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_30;
  highp vec2 tmpvar_31;
  tmpvar_31.x = xlv_TEXCOORD0.x;
  highp float tmpvar_32;
  tmpvar_32 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_31.y = tmpvar_32;
  highp vec2 tmpvar_33;
  tmpvar_33 = ((vec2(height0_7) * tmpvar_29) + tmpvar_31);
  hcoord1_6.x = tmpvar_33.x;
  hcoord1_6.y = (1.0 - tmpvar_33.y);
  lowp float tmpvar_34;
  tmpvar_34 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_34;
  highp vec2 tmpvar_35;
  tmpvar_35.x = xlv_TEXCOORD0.x;
  tmpvar_35.y = tmpvar_32;
  highp vec2 tmpvar_36;
  tmpvar_36 = ((vec2(height1_5) * tmpvar_29) + tmpvar_35);
  hcoord2_4.x = tmpvar_36.x;
  hcoord2_4.y = (1.0 - tmpvar_36.y);
  lowp float tmpvar_37;
  tmpvar_37 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_37;
  highp vec2 tmpvar_38;
  tmpvar_38.x = xlv_TEXCOORD0.x;
  tmpvar_38.y = tmpvar_32;
  highp vec2 tmpvar_39;
  tmpvar_39 = ((vec2(height2_3) * tmpvar_29) + tmpvar_38);
  hcoord3_2.x = tmpvar_39.x;
  hcoord3_2.y = (1.0 - tmpvar_39.y);
  lowp vec3 tmpvar_40;
  tmpvar_40 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_40;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 shadowCoord_41;
  shadowCoord_41 = xlv_TEXCOORD6;
  highp float tmpvar_42;
  if ((xlv_TEXCOORD6.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_42 = 1.0;
  } else {
    shadowCoord_41.y = (1.0 - xlv_TEXCOORD6.y);
    highp vec2 fetchesOffsetsV_43;
    highp vec2 fetchesOffsetsU_44;
    highp float shadow_45;
    highp vec2 tmpvar_46;
    tmpvar_46 = (shadowCoord_41.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_47;
    tmpvar_47 = floor((tmpvar_46 + 0.5));
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_46 - tmpvar_47);
    highp vec4 computedWeight_49;
    highp vec4 computedArea_50;
    highp vec4 computedAreaUncut_51;
    highp float tmpvar_52;
    tmpvar_52 = (((tmpvar_48.x + 0.5) * (tmpvar_48.x + 0.5)) * 0.5);
    highp float tmpvar_53;
    tmpvar_53 = (tmpvar_52 - tmpvar_48.x);
    computedArea_50.x = tmpvar_53;
    computedAreaUncut_51.x = tmpvar_53;
    computedArea_50.w = tmpvar_52;
    computedAreaUncut_51.w = tmpvar_52;
    computedAreaUncut_51.y = ((1.5 - tmpvar_48.x) - 0.5);
    highp float tmpvar_54;
    tmpvar_54 = min (tmpvar_48.x, 0.0);
    computedArea_50.y = (computedAreaUncut_51.y - (tmpvar_54 * tmpvar_54));
    computedAreaUncut_51.z = ((1.5 + tmpvar_48.x) - 0.5);
    highp float tmpvar_55;
    tmpvar_55 = max (tmpvar_48.x, 0.0);
    computedArea_50.z = (computedAreaUncut_51.z - (tmpvar_55 * tmpvar_55));
    computedWeight_49 = (computedArea_50 * 0.44444);
    highp vec4 computedWeight_56;
    highp vec4 computedArea_57;
    highp vec4 computedAreaUncut_58;
    highp float tmpvar_59;
    tmpvar_59 = (((tmpvar_48.y + 0.5) * (tmpvar_48.y + 0.5)) * 0.5);
    highp float tmpvar_60;
    tmpvar_60 = (tmpvar_59 - tmpvar_48.y);
    computedArea_57.x = tmpvar_60;
    computedAreaUncut_58.x = tmpvar_60;
    computedArea_57.w = tmpvar_59;
    computedAreaUncut_58.w = tmpvar_59;
    computedAreaUncut_58.y = ((1.5 - tmpvar_48.y) - 0.5);
    highp float tmpvar_61;
    tmpvar_61 = min (tmpvar_48.y, 0.0);
    computedArea_57.y = (computedAreaUncut_58.y - (tmpvar_61 * tmpvar_61));
    computedAreaUncut_58.z = ((1.5 + tmpvar_48.y) - 0.5);
    highp float tmpvar_62;
    tmpvar_62 = max (tmpvar_48.y, 0.0);
    computedArea_57.z = (computedAreaUncut_58.z - (tmpvar_62 * tmpvar_62));
    computedWeight_56 = (computedArea_57 * 0.44444);
    highp vec2 tmpvar_63;
    tmpvar_63 = (computedWeight_49.xz + computedWeight_49.yw);
    highp vec2 tmpvar_64;
    tmpvar_64 = (computedWeight_56.xz + computedWeight_56.yw);
    fetchesOffsetsU_44 = (((computedWeight_49.yw / tmpvar_63) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_43 = (((computedWeight_56.yw / tmpvar_64) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_65;
    tmpvar_65 = (tmpvar_47 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_44.x;
    tmpvar_66.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_65 + tmpvar_66);
    tmpvar_67.z = shadowCoord_41.z;
    lowp float tmpvar_68;
    tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_45 = ((tmpvar_63.x * tmpvar_64.x) * tmpvar_68);
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_44.y;
    tmpvar_69.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_65 + tmpvar_69);
    tmpvar_70.z = shadowCoord_41.z;
    lowp float tmpvar_71;
    tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_45 = (shadow_45 + ((tmpvar_63.y * tmpvar_64.x) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_44.x;
    tmpvar_72.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_65 + tmpvar_72);
    tmpvar_73.z = shadowCoord_41.z;
    lowp float tmpvar_74;
    tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_45 = (shadow_45 + ((tmpvar_63.x * tmpvar_64.y) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_44.y;
    tmpvar_75.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_65 + tmpvar_75);
    tmpvar_76.z = shadowCoord_41.z;
    lowp float tmpvar_77;
    tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_45 = (shadow_45 + ((tmpvar_63.y * tmpvar_64.y) * tmpvar_77));
    tmpvar_42 = mix (1.0, shadow_45, LIGHT_PARAM.y);
  };
  highp vec4 tmpvar_78;
  tmpvar_78.w = 1.0;
  tmpvar_78.xyz = ((mainColor_1 + vec3(totalSpecular_8)) * ((
    (LIGHT1COLOR.xyz * Light1Intensity)
   * tmpvar_42) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_78;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_10[0].xyz;
  tmpvar_15[1] = tmpvar_10[1].xyz;
  tmpvar_15[2] = tmpvar_10[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_10[0].xyz;
  tmpvar_17[1] = tmpvar_10[1].xyz;
  tmpvar_17[2] = tmpvar_10[2].xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)))
  ).xyz * 0.5) + 0.5);
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_14 * (vec3(1.0, 0.0, 0.0) * tmpvar_15)));
  xlv_TEXCOORD5 = normalize((tmpvar_16 * (vec3(0.0, 1.0, 0.0) * tmpvar_17)));
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD6 = tmpvar_2;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float totalSpecular_8;
  highp float specular2_9;
  highp vec2 coord2_10;
  highp float specular1_11;
  highp vec2 coord1_12;
  highp float specular0_13;
  highp vec2 coord0_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_15, xlv_TEXCOORD4);
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_15, xlv_TEXCOORD5);
  highp vec2 tmpvar_18;
  tmpvar_18.x = ((-(tmpvar_16) * tmpvar_16) * tmpvar_16);
  tmpvar_18.y = -(tmpvar_16);
  coord0_14 = (tmpvar_18 * movespeed1);
  coord0_14 = (coord0_14 * specoffset1.xy);
  highp vec2 tmpvar_19;
  tmpvar_19.x = xlv_TEXCOORD1.x;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_19.y = tmpvar_20;
  coord0_14 = ((coord0_14 + initoffset.xy) + tmpvar_19);
  coord0_14.y = (1.0 - coord0_14.y);
  lowp float tmpvar_21;
  tmpvar_21 = texture2D (specularMap, coord0_14).x;
  specular0_13 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22.x = tmpvar_16;
  tmpvar_22.y = -(tmpvar_17);
  coord1_12 = (tmpvar_22 * movespeed2);
  coord1_12 = (coord1_12 * specoffset2.xy);
  highp vec2 tmpvar_23;
  tmpvar_23.x = xlv_TEXCOORD1.x;
  tmpvar_23.y = tmpvar_20;
  coord1_12 = ((coord1_12 + initoffset.xy) + tmpvar_23);
  coord1_12.y = (1.0 - coord1_12.y);
  lowp float tmpvar_24;
  tmpvar_24 = texture2D (specularMap, coord1_12).y;
  specular1_11 = tmpvar_24;
  coord2_10 = (abs(vec2(tmpvar_16)) * movespeed3);
  coord2_10 = (coord2_10 * specoffset3.xy);
  highp vec2 tmpvar_25;
  tmpvar_25.x = xlv_TEXCOORD1.x;
  tmpvar_25.y = tmpvar_20;
  coord2_10 = ((coord2_10 + initoffset.xy) + tmpvar_25);
  coord2_10.y = (1.0 - coord2_10.y);
  lowp float tmpvar_26;
  tmpvar_26 = texture2D (specularMap, coord2_10).z;
  specular2_9 = tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_27.x = specular0_13;
  tmpvar_27.y = specular1_11;
  tmpvar_27.z = specular2_9;
  totalSpecular_8 = dot (tmpvar_27, intensity);
  highp vec2 tmpvar_28;
  tmpvar_28.x = tmpvar_16;
  tmpvar_28.y = -(tmpvar_17);
  highp vec2 tmpvar_29;
  tmpvar_29 = ((tmpvar_28 * eyeheight) * 0.5);
  lowp float tmpvar_30;
  tmpvar_30 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_30;
  highp vec2 tmpvar_31;
  tmpvar_31.x = xlv_TEXCOORD0.x;
  highp float tmpvar_32;
  tmpvar_32 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_31.y = tmpvar_32;
  highp vec2 tmpvar_33;
  tmpvar_33 = ((vec2(height0_7) * tmpvar_29) + tmpvar_31);
  hcoord1_6.x = tmpvar_33.x;
  hcoord1_6.y = (1.0 - tmpvar_33.y);
  lowp float tmpvar_34;
  tmpvar_34 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_34;
  highp vec2 tmpvar_35;
  tmpvar_35.x = xlv_TEXCOORD0.x;
  tmpvar_35.y = tmpvar_32;
  highp vec2 tmpvar_36;
  tmpvar_36 = ((vec2(height1_5) * tmpvar_29) + tmpvar_35);
  hcoord2_4.x = tmpvar_36.x;
  hcoord2_4.y = (1.0 - tmpvar_36.y);
  lowp float tmpvar_37;
  tmpvar_37 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_37;
  highp vec2 tmpvar_38;
  tmpvar_38.x = xlv_TEXCOORD0.x;
  tmpvar_38.y = tmpvar_32;
  highp vec2 tmpvar_39;
  tmpvar_39 = ((vec2(height2_3) * tmpvar_29) + tmpvar_38);
  hcoord3_2.x = tmpvar_39.x;
  hcoord3_2.y = (1.0 - tmpvar_39.y);
  lowp vec3 tmpvar_40;
  tmpvar_40 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_40;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 shadowCoord_41;
  shadowCoord_41 = xlv_TEXCOORD6;
  highp float tmpvar_42;
  if ((xlv_TEXCOORD6.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_42 = 1.0;
  } else {
    shadowCoord_41.y = (1.0 - xlv_TEXCOORD6.y);
    highp vec3 fetchesOffsetsV_43;
    highp vec3 fetchesOffsetsU_44;
    highp float shadow_45;
    highp vec2 tmpvar_46;
    tmpvar_46 = (shadowCoord_41.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_47;
    tmpvar_47 = floor((tmpvar_46 + 0.5));
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_46 - tmpvar_47);
    highp vec3 texelsWeightsA_49;
    highp vec3 texelsWeightsB_50;
    highp vec4 computedArea_51;
    highp vec4 computedAreaUncut_52;
    highp float tmpvar_53;
    tmpvar_53 = (((tmpvar_48.x + 0.5) * (tmpvar_48.x + 0.5)) * 0.5);
    highp float tmpvar_54;
    tmpvar_54 = (tmpvar_53 - tmpvar_48.x);
    computedArea_51.x = tmpvar_54;
    computedAreaUncut_52.x = tmpvar_54;
    computedArea_51.w = tmpvar_53;
    computedAreaUncut_52.w = tmpvar_53;
    computedAreaUncut_52.y = ((1.5 - tmpvar_48.x) - 0.5);
    highp float tmpvar_55;
    tmpvar_55 = min (tmpvar_48.x, 0.0);
    computedArea_51.y = (computedAreaUncut_52.y - (tmpvar_55 * tmpvar_55));
    computedAreaUncut_52.z = ((1.5 + tmpvar_48.x) - 0.5);
    highp float tmpvar_56;
    tmpvar_56 = max (tmpvar_48.x, 0.0);
    computedArea_51.z = (computedAreaUncut_52.z - (tmpvar_56 * tmpvar_56));
    texelsWeightsA_49.x = (0.16 * tmpvar_54);
    texelsWeightsA_49.y = (0.16 * computedAreaUncut_52.y);
    texelsWeightsA_49.z = (0.16 * (computedArea_51.y + 1.0));
    texelsWeightsB_50.x = (0.16 * (computedArea_51.z + 1.0));
    texelsWeightsB_50.y = (0.16 * computedAreaUncut_52.z);
    texelsWeightsB_50.z = (0.16 * tmpvar_53);
    highp vec3 texelsWeightsA_57;
    highp vec3 texelsWeightsB_58;
    highp vec4 computedArea_59;
    highp vec4 computedAreaUncut_60;
    highp float tmpvar_61;
    tmpvar_61 = (((tmpvar_48.y + 0.5) * (tmpvar_48.y + 0.5)) * 0.5);
    highp float tmpvar_62;
    tmpvar_62 = (tmpvar_61 - tmpvar_48.y);
    computedArea_59.x = tmpvar_62;
    computedAreaUncut_60.x = tmpvar_62;
    computedArea_59.w = tmpvar_61;
    computedAreaUncut_60.w = tmpvar_61;
    computedAreaUncut_60.y = ((1.5 - tmpvar_48.y) - 0.5);
    highp float tmpvar_63;
    tmpvar_63 = min (tmpvar_48.y, 0.0);
    computedArea_59.y = (computedAreaUncut_60.y - (tmpvar_63 * tmpvar_63));
    computedAreaUncut_60.z = ((1.5 + tmpvar_48.y) - 0.5);
    highp float tmpvar_64;
    tmpvar_64 = max (tmpvar_48.y, 0.0);
    computedArea_59.z = (computedAreaUncut_60.z - (tmpvar_64 * tmpvar_64));
    texelsWeightsA_57.x = (0.16 * tmpvar_62);
    texelsWeightsA_57.y = (0.16 * computedAreaUncut_60.y);
    texelsWeightsA_57.z = (0.16 * (computedArea_59.y + 1.0));
    texelsWeightsB_58.x = (0.16 * (computedArea_59.z + 1.0));
    texelsWeightsB_58.y = (0.16 * computedAreaUncut_60.z);
    texelsWeightsB_58.z = (0.16 * tmpvar_61);
    highp vec3 tmpvar_65;
    tmpvar_65.xy = texelsWeightsA_49.xz;
    tmpvar_65.z = texelsWeightsB_50.y;
    highp vec3 tmpvar_66;
    tmpvar_66.x = texelsWeightsA_49.y;
    tmpvar_66.yz = texelsWeightsB_50.xz;
    highp vec3 tmpvar_67;
    tmpvar_67 = (tmpvar_65 + tmpvar_66);
    highp vec3 tmpvar_68;
    tmpvar_68.xy = texelsWeightsA_57.xz;
    tmpvar_68.z = texelsWeightsB_58.y;
    highp vec3 tmpvar_69;
    tmpvar_69.x = texelsWeightsA_57.y;
    tmpvar_69.yz = texelsWeightsB_58.xz;
    highp vec3 tmpvar_70;
    tmpvar_70 = (tmpvar_68 + tmpvar_69);
    highp vec3 tmpvar_71;
    tmpvar_71.x = texelsWeightsA_49.y;
    tmpvar_71.yz = texelsWeightsB_50.xz;
    highp vec3 tmpvar_72;
    tmpvar_72.x = texelsWeightsA_57.y;
    tmpvar_72.yz = texelsWeightsB_58.xz;
    fetchesOffsetsU_44 = (((tmpvar_71 / tmpvar_67) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_43 = (((tmpvar_72 / tmpvar_70) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_73;
    tmpvar_73 = (tmpvar_47 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_44.x;
    tmpvar_74.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_73 + tmpvar_74);
    tmpvar_75.z = shadowCoord_41.z;
    lowp float tmpvar_76;
    tmpvar_76 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_45 = ((tmpvar_67.x * tmpvar_70.x) * tmpvar_76);
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_44.y;
    tmpvar_77.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_73 + tmpvar_77);
    tmpvar_78.z = shadowCoord_41.z;
    lowp float tmpvar_79;
    tmpvar_79 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.x) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_44.z;
    tmpvar_80.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_73 + tmpvar_80);
    tmpvar_81.z = shadowCoord_41.z;
    lowp float tmpvar_82;
    tmpvar_82 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.x) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_44.x;
    tmpvar_83.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_73 + tmpvar_83);
    tmpvar_84.z = shadowCoord_41.z;
    lowp float tmpvar_85;
    tmpvar_85 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.y) * tmpvar_85));
    highp vec2 tmpvar_86;
    tmpvar_86.x = fetchesOffsetsU_44.y;
    tmpvar_86.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_87;
    tmpvar_87.xy = (tmpvar_73 + tmpvar_86);
    tmpvar_87.z = shadowCoord_41.z;
    lowp float tmpvar_88;
    tmpvar_88 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_87);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.y) * tmpvar_88));
    highp vec2 tmpvar_89;
    tmpvar_89.x = fetchesOffsetsU_44.z;
    tmpvar_89.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_90;
    tmpvar_90.xy = (tmpvar_73 + tmpvar_89);
    tmpvar_90.z = shadowCoord_41.z;
    lowp float tmpvar_91;
    tmpvar_91 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_90);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.y) * tmpvar_91));
    highp vec2 tmpvar_92;
    tmpvar_92.x = fetchesOffsetsU_44.x;
    tmpvar_92.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_93;
    tmpvar_93.xy = (tmpvar_73 + tmpvar_92);
    tmpvar_93.z = shadowCoord_41.z;
    lowp float tmpvar_94;
    tmpvar_94 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_93);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.z) * tmpvar_94));
    highp vec2 tmpvar_95;
    tmpvar_95.x = fetchesOffsetsU_44.y;
    tmpvar_95.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_96;
    tmpvar_96.xy = (tmpvar_73 + tmpvar_95);
    tmpvar_96.z = shadowCoord_41.z;
    lowp float tmpvar_97;
    tmpvar_97 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_96);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.z) * tmpvar_97));
    highp vec2 tmpvar_98;
    tmpvar_98.x = fetchesOffsetsU_44.z;
    tmpvar_98.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_99;
    tmpvar_99.xy = (tmpvar_73 + tmpvar_98);
    tmpvar_99.z = shadowCoord_41.z;
    lowp float tmpvar_100;
    tmpvar_100 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_99);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.z) * tmpvar_100));
    tmpvar_42 = mix (1.0, shadow_45, LIGHT_PARAM.y);
  };
  highp vec4 tmpvar_101;
  tmpvar_101.w = 1.0;
  tmpvar_101.xyz = ((mainColor_1 + vec3(totalSpecular_8)) * ((
    (LIGHT1COLOR.xyz * Light1Intensity)
   * tmpvar_42) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_101;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_10[0].xyz;
  tmpvar_15[1] = tmpvar_10[1].xyz;
  tmpvar_15[2] = tmpvar_10[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_10[0].xyz;
  tmpvar_17[1] = tmpvar_10[1].xyz;
  tmpvar_17[2] = tmpvar_10[2].xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)))
  ).xyz * 0.5) + 0.5);
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_14 * (vec3(1.0, 0.0, 0.0) * tmpvar_15)));
  xlv_TEXCOORD5 = normalize((tmpvar_16 * (vec3(0.0, 1.0, 0.0) * tmpvar_17)));
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD6 = tmpvar_2;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float totalSpecular_8;
  highp float specular2_9;
  highp vec2 coord2_10;
  highp float specular1_11;
  highp vec2 coord1_12;
  highp float specular0_13;
  highp vec2 coord0_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_15, xlv_TEXCOORD4);
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_15, xlv_TEXCOORD5);
  highp vec2 tmpvar_18;
  tmpvar_18.x = ((-(tmpvar_16) * tmpvar_16) * tmpvar_16);
  tmpvar_18.y = -(tmpvar_16);
  coord0_14 = (tmpvar_18 * movespeed1);
  coord0_14 = (coord0_14 * specoffset1.xy);
  highp vec2 tmpvar_19;
  tmpvar_19.x = xlv_TEXCOORD1.x;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_19.y = tmpvar_20;
  coord0_14 = ((coord0_14 + initoffset.xy) + tmpvar_19);
  coord0_14.y = (1.0 - coord0_14.y);
  lowp float tmpvar_21;
  tmpvar_21 = texture2D (specularMap, coord0_14).x;
  specular0_13 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22.x = tmpvar_16;
  tmpvar_22.y = -(tmpvar_17);
  coord1_12 = (tmpvar_22 * movespeed2);
  coord1_12 = (coord1_12 * specoffset2.xy);
  highp vec2 tmpvar_23;
  tmpvar_23.x = xlv_TEXCOORD1.x;
  tmpvar_23.y = tmpvar_20;
  coord1_12 = ((coord1_12 + initoffset.xy) + tmpvar_23);
  coord1_12.y = (1.0 - coord1_12.y);
  lowp float tmpvar_24;
  tmpvar_24 = texture2D (specularMap, coord1_12).y;
  specular1_11 = tmpvar_24;
  coord2_10 = (abs(vec2(tmpvar_16)) * movespeed3);
  coord2_10 = (coord2_10 * specoffset3.xy);
  highp vec2 tmpvar_25;
  tmpvar_25.x = xlv_TEXCOORD1.x;
  tmpvar_25.y = tmpvar_20;
  coord2_10 = ((coord2_10 + initoffset.xy) + tmpvar_25);
  coord2_10.y = (1.0 - coord2_10.y);
  lowp float tmpvar_26;
  tmpvar_26 = texture2D (specularMap, coord2_10).z;
  specular2_9 = tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_27.x = specular0_13;
  tmpvar_27.y = specular1_11;
  tmpvar_27.z = specular2_9;
  totalSpecular_8 = dot (tmpvar_27, intensity);
  highp vec2 tmpvar_28;
  tmpvar_28.x = tmpvar_16;
  tmpvar_28.y = -(tmpvar_17);
  highp vec2 tmpvar_29;
  tmpvar_29 = ((tmpvar_28 * eyeheight) * 0.5);
  lowp float tmpvar_30;
  tmpvar_30 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_30;
  highp vec2 tmpvar_31;
  tmpvar_31.x = xlv_TEXCOORD0.x;
  highp float tmpvar_32;
  tmpvar_32 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_31.y = tmpvar_32;
  highp vec2 tmpvar_33;
  tmpvar_33 = ((vec2(height0_7) * tmpvar_29) + tmpvar_31);
  hcoord1_6.x = tmpvar_33.x;
  hcoord1_6.y = (1.0 - tmpvar_33.y);
  lowp float tmpvar_34;
  tmpvar_34 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_34;
  highp vec2 tmpvar_35;
  tmpvar_35.x = xlv_TEXCOORD0.x;
  tmpvar_35.y = tmpvar_32;
  highp vec2 tmpvar_36;
  tmpvar_36 = ((vec2(height1_5) * tmpvar_29) + tmpvar_35);
  hcoord2_4.x = tmpvar_36.x;
  hcoord2_4.y = (1.0 - tmpvar_36.y);
  lowp float tmpvar_37;
  tmpvar_37 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_37;
  highp vec2 tmpvar_38;
  tmpvar_38.x = xlv_TEXCOORD0.x;
  tmpvar_38.y = tmpvar_32;
  highp vec2 tmpvar_39;
  tmpvar_39 = ((vec2(height2_3) * tmpvar_29) + tmpvar_38);
  hcoord3_2.x = tmpvar_39.x;
  hcoord3_2.y = (1.0 - tmpvar_39.y);
  lowp vec3 tmpvar_40;
  tmpvar_40 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_40;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 shadowCoord_41;
  shadowCoord_41 = xlv_TEXCOORD6;
  highp float tmpvar_42;
  if ((xlv_TEXCOORD6.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_42 = 1.0;
  } else {
    shadowCoord_41.y = (1.0 - xlv_TEXCOORD6.y);
    highp vec4 fetchesOffsetsV_43;
    highp vec4 fetchesOffsetsU_44;
    highp float shadow_45;
    highp vec2 tmpvar_46;
    tmpvar_46 = (shadowCoord_41.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_47;
    tmpvar_47 = floor((tmpvar_46 + 0.5));
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_46 - tmpvar_47);
    highp vec4 texelsWeightsA_49;
    highp vec4 texelsWeightsB_50;
    highp vec4 computedArea_51;
    highp vec4 computedAreaUncut_52;
    highp float tmpvar_53;
    tmpvar_53 = (((tmpvar_48.x + 0.5) * (tmpvar_48.x + 0.5)) * 0.5);
    highp float tmpvar_54;
    tmpvar_54 = (tmpvar_53 - tmpvar_48.x);
    computedArea_51.x = tmpvar_54;
    computedAreaUncut_52.x = tmpvar_54;
    computedArea_51.w = tmpvar_53;
    computedAreaUncut_52.w = tmpvar_53;
    computedAreaUncut_52.y = ((1.5 - tmpvar_48.x) - 0.5);
    highp float tmpvar_55;
    tmpvar_55 = min (tmpvar_48.x, 0.0);
    computedArea_51.y = (computedAreaUncut_52.y - (tmpvar_55 * tmpvar_55));
    computedAreaUncut_52.z = ((1.5 + tmpvar_48.x) - 0.5);
    highp float tmpvar_56;
    tmpvar_56 = max (tmpvar_48.x, 0.0);
    computedArea_51.z = (computedAreaUncut_52.z - (tmpvar_56 * tmpvar_56));
    texelsWeightsA_49.x = (0.081632 * tmpvar_54);
    texelsWeightsA_49.y = (0.081632 * computedAreaUncut_52.y);
    texelsWeightsA_49.z = (0.081632 * (computedAreaUncut_52.y + 1.0));
    texelsWeightsA_49.w = (0.081632 * (computedArea_51.y + 2.0));
    texelsWeightsB_50.x = (0.081632 * (computedArea_51.z + 2.0));
    texelsWeightsB_50.y = (0.081632 * (computedAreaUncut_52.z + 1.0));
    texelsWeightsB_50.z = (0.081632 * computedAreaUncut_52.z);
    texelsWeightsB_50.w = (0.081632 * tmpvar_53);
    highp vec4 texelsWeightsA_57;
    highp vec4 texelsWeightsB_58;
    highp vec4 computedArea_59;
    highp vec4 computedAreaUncut_60;
    highp float tmpvar_61;
    tmpvar_61 = (((tmpvar_48.y + 0.5) * (tmpvar_48.y + 0.5)) * 0.5);
    highp float tmpvar_62;
    tmpvar_62 = (tmpvar_61 - tmpvar_48.y);
    computedArea_59.x = tmpvar_62;
    computedAreaUncut_60.x = tmpvar_62;
    computedArea_59.w = tmpvar_61;
    computedAreaUncut_60.w = tmpvar_61;
    computedAreaUncut_60.y = ((1.5 - tmpvar_48.y) - 0.5);
    highp float tmpvar_63;
    tmpvar_63 = min (tmpvar_48.y, 0.0);
    computedArea_59.y = (computedAreaUncut_60.y - (tmpvar_63 * tmpvar_63));
    computedAreaUncut_60.z = ((1.5 + tmpvar_48.y) - 0.5);
    highp float tmpvar_64;
    tmpvar_64 = max (tmpvar_48.y, 0.0);
    computedArea_59.z = (computedAreaUncut_60.z - (tmpvar_64 * tmpvar_64));
    texelsWeightsA_57.x = (0.081632 * tmpvar_62);
    texelsWeightsA_57.y = (0.081632 * computedAreaUncut_60.y);
    texelsWeightsA_57.z = (0.081632 * (computedAreaUncut_60.y + 1.0));
    texelsWeightsA_57.w = (0.081632 * (computedArea_59.y + 2.0));
    texelsWeightsB_58.x = (0.081632 * (computedArea_59.z + 2.0));
    texelsWeightsB_58.y = (0.081632 * (computedAreaUncut_60.z + 1.0));
    texelsWeightsB_58.z = (0.081632 * computedAreaUncut_60.z);
    texelsWeightsB_58.w = (0.081632 * tmpvar_61);
    highp vec4 tmpvar_65;
    tmpvar_65.xy = texelsWeightsA_49.xz;
    tmpvar_65.zw = texelsWeightsB_50.xz;
    highp vec4 tmpvar_66;
    tmpvar_66.xy = texelsWeightsA_49.yw;
    tmpvar_66.zw = texelsWeightsB_50.yw;
    highp vec4 tmpvar_67;
    tmpvar_67 = (tmpvar_65 + tmpvar_66);
    highp vec4 tmpvar_68;
    tmpvar_68.xy = texelsWeightsA_57.xz;
    tmpvar_68.zw = texelsWeightsB_58.xz;
    highp vec4 tmpvar_69;
    tmpvar_69.xy = texelsWeightsA_57.yw;
    tmpvar_69.zw = texelsWeightsB_58.yw;
    highp vec4 tmpvar_70;
    tmpvar_70 = (tmpvar_68 + tmpvar_69);
    highp vec4 tmpvar_71;
    tmpvar_71.xy = texelsWeightsA_49.yw;
    tmpvar_71.zw = texelsWeightsB_50.yw;
    highp vec4 tmpvar_72;
    tmpvar_72.xy = texelsWeightsA_57.yw;
    tmpvar_72.zw = texelsWeightsB_58.yw;
    fetchesOffsetsU_44 = (((tmpvar_71 / tmpvar_67) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_43 = (((tmpvar_72 / tmpvar_70) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_73;
    tmpvar_73 = (tmpvar_47 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_44.x;
    tmpvar_74.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_73 + tmpvar_74);
    tmpvar_75.z = shadowCoord_41.z;
    lowp float tmpvar_76;
    tmpvar_76 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_45 = ((tmpvar_67.x * tmpvar_70.x) * tmpvar_76);
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_44.y;
    tmpvar_77.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_73 + tmpvar_77);
    tmpvar_78.z = shadowCoord_41.z;
    lowp float tmpvar_79;
    tmpvar_79 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.x) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_44.z;
    tmpvar_80.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_73 + tmpvar_80);
    tmpvar_81.z = shadowCoord_41.z;
    lowp float tmpvar_82;
    tmpvar_82 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.x) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_44.w;
    tmpvar_83.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_73 + tmpvar_83);
    tmpvar_84.z = shadowCoord_41.z;
    lowp float tmpvar_85;
    tmpvar_85 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_45 = (shadow_45 + ((tmpvar_67.w * tmpvar_70.x) * tmpvar_85));
    highp vec2 tmpvar_86;
    tmpvar_86.x = fetchesOffsetsU_44.x;
    tmpvar_86.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_87;
    tmpvar_87.xy = (tmpvar_73 + tmpvar_86);
    tmpvar_87.z = shadowCoord_41.z;
    lowp float tmpvar_88;
    tmpvar_88 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_87);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.y) * tmpvar_88));
    highp vec2 tmpvar_89;
    tmpvar_89.x = fetchesOffsetsU_44.y;
    tmpvar_89.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_90;
    tmpvar_90.xy = (tmpvar_73 + tmpvar_89);
    tmpvar_90.z = shadowCoord_41.z;
    lowp float tmpvar_91;
    tmpvar_91 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_90);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.y) * tmpvar_91));
    highp vec2 tmpvar_92;
    tmpvar_92.x = fetchesOffsetsU_44.z;
    tmpvar_92.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_93;
    tmpvar_93.xy = (tmpvar_73 + tmpvar_92);
    tmpvar_93.z = shadowCoord_41.z;
    lowp float tmpvar_94;
    tmpvar_94 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_93);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.y) * tmpvar_94));
    highp vec2 tmpvar_95;
    tmpvar_95.x = fetchesOffsetsU_44.w;
    tmpvar_95.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_96;
    tmpvar_96.xy = (tmpvar_73 + tmpvar_95);
    tmpvar_96.z = shadowCoord_41.z;
    lowp float tmpvar_97;
    tmpvar_97 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_96);
    shadow_45 = (shadow_45 + ((tmpvar_67.w * tmpvar_70.y) * tmpvar_97));
    highp vec2 tmpvar_98;
    tmpvar_98.x = fetchesOffsetsU_44.x;
    tmpvar_98.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_99;
    tmpvar_99.xy = (tmpvar_73 + tmpvar_98);
    tmpvar_99.z = shadowCoord_41.z;
    lowp float tmpvar_100;
    tmpvar_100 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_99);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.z) * tmpvar_100));
    highp vec2 tmpvar_101;
    tmpvar_101.x = fetchesOffsetsU_44.y;
    tmpvar_101.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_102;
    tmpvar_102.xy = (tmpvar_73 + tmpvar_101);
    tmpvar_102.z = shadowCoord_41.z;
    lowp float tmpvar_103;
    tmpvar_103 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_102);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.z) * tmpvar_103));
    highp vec2 tmpvar_104;
    tmpvar_104.x = fetchesOffsetsU_44.z;
    tmpvar_104.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_105;
    tmpvar_105.xy = (tmpvar_73 + tmpvar_104);
    tmpvar_105.z = shadowCoord_41.z;
    lowp float tmpvar_106;
    tmpvar_106 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_105);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.z) * tmpvar_106));
    highp vec2 tmpvar_107;
    tmpvar_107.x = fetchesOffsetsU_44.w;
    tmpvar_107.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_108;
    tmpvar_108.xy = (tmpvar_73 + tmpvar_107);
    tmpvar_108.z = shadowCoord_41.z;
    lowp float tmpvar_109;
    tmpvar_109 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_108);
    shadow_45 = (shadow_45 + ((tmpvar_67.w * tmpvar_70.z) * tmpvar_109));
    highp vec2 tmpvar_110;
    tmpvar_110.x = fetchesOffsetsU_44.x;
    tmpvar_110.y = fetchesOffsetsV_43.w;
    highp vec3 tmpvar_111;
    tmpvar_111.xy = (tmpvar_73 + tmpvar_110);
    tmpvar_111.z = shadowCoord_41.z;
    lowp float tmpvar_112;
    tmpvar_112 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_111);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.w) * tmpvar_112));
    highp vec2 tmpvar_113;
    tmpvar_113.x = fetchesOffsetsU_44.y;
    tmpvar_113.y = fetchesOffsetsV_43.w;
    highp vec3 tmpvar_114;
    tmpvar_114.xy = (tmpvar_73 + tmpvar_113);
    tmpvar_114.z = shadowCoord_41.z;
    lowp float tmpvar_115;
    tmpvar_115 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_114);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.w) * tmpvar_115));
    highp vec2 tmpvar_116;
    tmpvar_116.x = fetchesOffsetsU_44.z;
    tmpvar_116.y = fetchesOffsetsV_43.w;
    highp vec3 tmpvar_117;
    tmpvar_117.xy = (tmpvar_73 + tmpvar_116);
    tmpvar_117.z = shadowCoord_41.z;
    lowp float tmpvar_118;
    tmpvar_118 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_117);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.w) * tmpvar_118));
    highp vec2 tmpvar_119;
    tmpvar_119.x = fetchesOffsetsU_44.w;
    tmpvar_119.y = fetchesOffsetsV_43.w;
    highp vec3 tmpvar_120;
    tmpvar_120.xy = (tmpvar_73 + tmpvar_119);
    tmpvar_120.z = shadowCoord_41.z;
    lowp float tmpvar_121;
    tmpvar_121 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_120);
    shadow_45 = (shadow_45 + ((tmpvar_67.w * tmpvar_70.w) * tmpvar_121));
    tmpvar_42 = mix (1.0, shadow_45, LIGHT_PARAM.y);
  };
  highp vec4 tmpvar_122;
  tmpvar_122.w = 1.0;
  tmpvar_122.xyz = ((mainColor_1 + vec3(totalSpecular_8)) * ((
    (LIGHT1COLOR.xyz * Light1Intensity)
   * tmpvar_42) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_122;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_10[0].xyz;
  tmpvar_15[1] = tmpvar_10[1].xyz;
  tmpvar_15[2] = tmpvar_10[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_10[0].xyz;
  tmpvar_17[1] = tmpvar_10[1].xyz;
  tmpvar_17[2] = tmpvar_10[2].xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)))
  ).xyz * 0.5) + 0.5);
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_14 * (vec3(1.0, 0.0, 0.0) * tmpvar_15)));
  xlv_TEXCOORD5 = normalize((tmpvar_16 * (vec3(0.0, 1.0, 0.0) * tmpvar_17)));
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD6 = tmpvar_2;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float totalSpecular_8;
  highp float specular2_9;
  highp vec2 coord2_10;
  highp float specular1_11;
  highp vec2 coord1_12;
  highp float specular0_13;
  highp vec2 coord0_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_15, xlv_TEXCOORD4);
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_15, xlv_TEXCOORD5);
  highp vec2 tmpvar_18;
  tmpvar_18.x = ((-(tmpvar_16) * tmpvar_16) * tmpvar_16);
  tmpvar_18.y = -(tmpvar_16);
  coord0_14 = (tmpvar_18 * movespeed1);
  coord0_14 = (coord0_14 * specoffset1.xy);
  highp vec2 tmpvar_19;
  tmpvar_19.x = xlv_TEXCOORD1.x;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_19.y = tmpvar_20;
  coord0_14 = ((coord0_14 + initoffset.xy) + tmpvar_19);
  coord0_14.y = (1.0 - coord0_14.y);
  lowp float tmpvar_21;
  tmpvar_21 = texture2D (specularMap, coord0_14).x;
  specular0_13 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22.x = tmpvar_16;
  tmpvar_22.y = -(tmpvar_17);
  coord1_12 = (tmpvar_22 * movespeed2);
  coord1_12 = (coord1_12 * specoffset2.xy);
  highp vec2 tmpvar_23;
  tmpvar_23.x = xlv_TEXCOORD1.x;
  tmpvar_23.y = tmpvar_20;
  coord1_12 = ((coord1_12 + initoffset.xy) + tmpvar_23);
  coord1_12.y = (1.0 - coord1_12.y);
  lowp float tmpvar_24;
  tmpvar_24 = texture2D (specularMap, coord1_12).y;
  specular1_11 = tmpvar_24;
  coord2_10 = (abs(vec2(tmpvar_16)) * movespeed3);
  coord2_10 = (coord2_10 * specoffset3.xy);
  highp vec2 tmpvar_25;
  tmpvar_25.x = xlv_TEXCOORD1.x;
  tmpvar_25.y = tmpvar_20;
  coord2_10 = ((coord2_10 + initoffset.xy) + tmpvar_25);
  coord2_10.y = (1.0 - coord2_10.y);
  lowp float tmpvar_26;
  tmpvar_26 = texture2D (specularMap, coord2_10).z;
  specular2_9 = tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_27.x = specular0_13;
  tmpvar_27.y = specular1_11;
  tmpvar_27.z = specular2_9;
  totalSpecular_8 = dot (tmpvar_27, intensity);
  highp vec2 tmpvar_28;
  tmpvar_28.x = tmpvar_16;
  tmpvar_28.y = -(tmpvar_17);
  highp vec2 tmpvar_29;
  tmpvar_29 = ((tmpvar_28 * eyeheight) * 0.5);
  lowp float tmpvar_30;
  tmpvar_30 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_30;
  highp vec2 tmpvar_31;
  tmpvar_31.x = xlv_TEXCOORD0.x;
  highp float tmpvar_32;
  tmpvar_32 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_31.y = tmpvar_32;
  highp vec2 tmpvar_33;
  tmpvar_33 = ((vec2(height0_7) * tmpvar_29) + tmpvar_31);
  hcoord1_6.x = tmpvar_33.x;
  hcoord1_6.y = (1.0 - tmpvar_33.y);
  lowp float tmpvar_34;
  tmpvar_34 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_34;
  highp vec2 tmpvar_35;
  tmpvar_35.x = xlv_TEXCOORD0.x;
  tmpvar_35.y = tmpvar_32;
  highp vec2 tmpvar_36;
  tmpvar_36 = ((vec2(height1_5) * tmpvar_29) + tmpvar_35);
  hcoord2_4.x = tmpvar_36.x;
  hcoord2_4.y = (1.0 - tmpvar_36.y);
  lowp float tmpvar_37;
  tmpvar_37 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_37;
  highp vec2 tmpvar_38;
  tmpvar_38.x = xlv_TEXCOORD0.x;
  tmpvar_38.y = tmpvar_32;
  highp vec2 tmpvar_39;
  tmpvar_39 = ((vec2(height2_3) * tmpvar_29) + tmpvar_38);
  hcoord3_2.x = tmpvar_39.x;
  hcoord3_2.y = (1.0 - tmpvar_39.y);
  lowp vec3 tmpvar_40;
  tmpvar_40 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_40;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 shadowCoord_41;
  shadowCoord_41 = xlv_TEXCOORD6;
  highp float tmpvar_42;
  if ((xlv_TEXCOORD6.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_42 = 1.0;
  } else {
    highp vec2 tmpvar_43;
    tmpvar_43.x = LIGHT_PARAM.z;
    tmpvar_43.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = tmpvar_43;
    highp float tmpvar_45;
    tmpvar_45 = (1.0/(LIGHT_PARAM.z));
    tmpvar_44.z = tmpvar_45;
    tmpvar_44.w = tmpvar_45;
    shadowCoord_41.y = (1.0 - xlv_TEXCOORD6.y);
    highp float shadow_46;
    highp vec2 tmpvar_47;
    tmpvar_47 = tmpvar_44.xy;
    shadow_46 = 0.0;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (shadowCoord_41.xy - LIGHT_PARAM.zz);
    tmpvar_48.z = shadowCoord_41.z;
    highp vec4 tmpvar_49;
    tmpvar_49 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_48.xy);
    highp float tmpvar_50;
    if ((tmpvar_49.x < xlv_TEXCOORD6.z)) {
      tmpvar_50 = 0.0;
    } else {
      tmpvar_50 = 1.0;
    };
    shadow_46 = tmpvar_50;
    highp vec2 tmpvar_51;
    tmpvar_51.x = 0.0;
    tmpvar_51.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_41.xy + tmpvar_51);
    tmpvar_52.z = shadowCoord_41.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD6.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_46 = (tmpvar_50 + tmpvar_54);
    highp vec2 tmpvar_55;
    tmpvar_55.x = tmpvar_47.x;
    tmpvar_55.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (shadowCoord_41.xy + tmpvar_55);
    tmpvar_56.z = shadowCoord_41.z;
    highp vec4 tmpvar_57;
    tmpvar_57 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_56.xy);
    highp float tmpvar_58;
    if ((tmpvar_57.x < xlv_TEXCOORD6.z)) {
      tmpvar_58 = 0.0;
    } else {
      tmpvar_58 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_58);
    highp vec2 tmpvar_59;
    tmpvar_59.y = 0.0;
    tmpvar_59.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (shadowCoord_41.xy + tmpvar_59);
    tmpvar_60.z = shadowCoord_41.z;
    highp vec4 tmpvar_61;
    tmpvar_61 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_60.xy);
    highp float tmpvar_62;
    if ((tmpvar_61.x < xlv_TEXCOORD6.z)) {
      tmpvar_62 = 0.0;
    } else {
      tmpvar_62 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_62);
    highp vec4 tmpvar_63;
    tmpvar_63 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_41.xy);
    highp float tmpvar_64;
    if ((tmpvar_63.x < xlv_TEXCOORD6.z)) {
      tmpvar_64 = 0.0;
    } else {
      tmpvar_64 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_64);
    highp vec2 tmpvar_65;
    tmpvar_65.y = 0.0;
    tmpvar_65.x = tmpvar_47.x;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (shadowCoord_41.xy + tmpvar_65);
    tmpvar_66.z = shadowCoord_41.z;
    highp vec4 tmpvar_67;
    tmpvar_67 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_66.xy);
    highp float tmpvar_68;
    if ((tmpvar_67.x < xlv_TEXCOORD6.z)) {
      tmpvar_68 = 0.0;
    } else {
      tmpvar_68 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_68);
    highp vec2 tmpvar_69;
    tmpvar_69.x = -(LIGHT_PARAM.z);
    tmpvar_69.y = tmpvar_47.y;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (shadowCoord_41.xy + tmpvar_69);
    tmpvar_70.z = shadowCoord_41.z;
    highp vec4 tmpvar_71;
    tmpvar_71 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_70.xy);
    highp float tmpvar_72;
    if ((tmpvar_71.x < xlv_TEXCOORD6.z)) {
      tmpvar_72 = 0.0;
    } else {
      tmpvar_72 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_72);
    highp vec2 tmpvar_73;
    tmpvar_73.x = 0.0;
    tmpvar_73.y = tmpvar_47.y;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (shadowCoord_41.xy + tmpvar_73);
    tmpvar_74.z = shadowCoord_41.z;
    highp vec4 tmpvar_75;
    tmpvar_75 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_74.xy);
    highp float tmpvar_76;
    if ((tmpvar_75.x < xlv_TEXCOORD6.z)) {
      tmpvar_76 = 0.0;
    } else {
      tmpvar_76 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_76);
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (shadowCoord_41.xy + LIGHT_PARAM.zz);
    tmpvar_77.z = shadowCoord_41.z;
    highp vec4 tmpvar_78;
    tmpvar_78 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_77.xy);
    highp float tmpvar_79;
    if ((tmpvar_78.x < xlv_TEXCOORD6.z)) {
      tmpvar_79 = 0.0;
    } else {
      tmpvar_79 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_79);
    shadow_46 = (shadow_46 / 9.0);
    tmpvar_42 = mix (1.0, shadow_46, LIGHT_PARAM.y);
  };
  highp vec4 tmpvar_80;
  tmpvar_80.w = 1.0;
  tmpvar_80.xyz = ((mainColor_1 + vec3(totalSpecular_8)) * ((
    (LIGHT1COLOR.xyz * Light1Intensity)
   * tmpvar_42) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_80;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp mat3 tmpvar_7;
  tmpvar_7[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_7[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_7[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_8;
  tmpvar_8[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_8[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_8[2] = LOCALWORLD_TRANSFORM[2].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_7 * vec3(1.0, 0.0, 0.0)));
  xlv_TEXCOORD5 = normalize((tmpvar_8 * vec3(0.0, 1.0, 0.0)));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float specular2_8;
  highp vec2 coord2_9;
  highp float specular1_10;
  highp vec2 coord1_11;
  highp float specular0_12;
  highp vec2 coord0_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_15;
  tmpvar_15 = dot (tmpvar_14, xlv_TEXCOORD4);
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_14, xlv_TEXCOORD5);
  highp vec2 tmpvar_17;
  tmpvar_17.x = ((-(tmpvar_15) * tmpvar_15) * tmpvar_15);
  tmpvar_17.y = -(tmpvar_15);
  coord0_13 = (tmpvar_17 * movespeed1);
  coord0_13 = (coord0_13 * specoffset1.xy);
  highp vec2 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.x;
  highp float tmpvar_19;
  tmpvar_19 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_18.y = tmpvar_19;
  coord0_13 = ((coord0_13 + initoffset.xy) + tmpvar_18);
  coord0_13.y = (1.0 - coord0_13.y);
  lowp float tmpvar_20;
  tmpvar_20 = texture2D (specularMap, coord0_13).x;
  specular0_12 = tmpvar_20;
  highp vec2 tmpvar_21;
  tmpvar_21.x = tmpvar_15;
  tmpvar_21.y = -(tmpvar_16);
  coord1_11 = (tmpvar_21 * movespeed2);
  coord1_11 = (coord1_11 * specoffset2.xy);
  highp vec2 tmpvar_22;
  tmpvar_22.x = xlv_TEXCOORD1.x;
  tmpvar_22.y = tmpvar_19;
  coord1_11 = ((coord1_11 + initoffset.xy) + tmpvar_22);
  coord1_11.y = (1.0 - coord1_11.y);
  lowp float tmpvar_23;
  tmpvar_23 = texture2D (specularMap, coord1_11).y;
  specular1_10 = tmpvar_23;
  coord2_9 = (abs(vec2(tmpvar_15)) * movespeed3);
  coord2_9 = (coord2_9 * specoffset3.xy);
  highp vec2 tmpvar_24;
  tmpvar_24.x = xlv_TEXCOORD1.x;
  tmpvar_24.y = tmpvar_19;
  coord2_9 = ((coord2_9 + initoffset.xy) + tmpvar_24);
  coord2_9.y = (1.0 - coord2_9.y);
  lowp float tmpvar_25;
  tmpvar_25 = texture2D (specularMap, coord2_9).z;
  specular2_8 = tmpvar_25;
  highp vec3 tmpvar_26;
  tmpvar_26.x = specular0_12;
  tmpvar_26.y = specular1_10;
  tmpvar_26.z = specular2_8;
  highp vec2 tmpvar_27;
  tmpvar_27.x = tmpvar_15;
  tmpvar_27.y = -(tmpvar_16);
  highp vec2 tmpvar_28;
  tmpvar_28 = ((tmpvar_27 * eyeheight) * 0.5);
  lowp float tmpvar_29;
  tmpvar_29 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_29;
  highp vec2 tmpvar_30;
  tmpvar_30.x = xlv_TEXCOORD0.x;
  highp float tmpvar_31;
  tmpvar_31 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_30.y = tmpvar_31;
  highp vec2 tmpvar_32;
  tmpvar_32 = ((vec2(height0_7) * tmpvar_28) + tmpvar_30);
  hcoord1_6.x = tmpvar_32.x;
  hcoord1_6.y = (1.0 - tmpvar_32.y);
  lowp float tmpvar_33;
  tmpvar_33 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_33;
  highp vec2 tmpvar_34;
  tmpvar_34.x = xlv_TEXCOORD0.x;
  tmpvar_34.y = tmpvar_31;
  highp vec2 tmpvar_35;
  tmpvar_35 = ((vec2(height1_5) * tmpvar_28) + tmpvar_34);
  hcoord2_4.x = tmpvar_35.x;
  hcoord2_4.y = (1.0 - tmpvar_35.y);
  lowp float tmpvar_36;
  tmpvar_36 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_36;
  highp vec2 tmpvar_37;
  tmpvar_37.x = xlv_TEXCOORD0.x;
  tmpvar_37.y = tmpvar_31;
  highp vec2 tmpvar_38;
  tmpvar_38 = ((vec2(height2_3) * tmpvar_28) + tmpvar_37);
  hcoord3_2.x = tmpvar_38.x;
  hcoord3_2.y = (1.0 - tmpvar_38.y);
  lowp vec3 tmpvar_39;
  tmpvar_39 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_39;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 tmpvar_40;
  tmpvar_40.w = 1.0;
  tmpvar_40.xyz = ((mainColor_1 + vec3(dot (tmpvar_26, intensity))) * ((LIGHT1COLOR.xyz * Light1Intensity) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_40;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp mat3 tmpvar_7;
  tmpvar_7[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_7[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_7[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_8;
  tmpvar_8[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_8[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_8[2] = LOCALWORLD_TRANSFORM[2].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_7 * vec3(1.0, 0.0, 0.0)));
  xlv_TEXCOORD5 = normalize((tmpvar_8 * vec3(0.0, 1.0, 0.0)));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float specular2_8;
  highp vec2 coord2_9;
  highp float specular1_10;
  highp vec2 coord1_11;
  highp float specular0_12;
  highp vec2 coord0_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_15;
  tmpvar_15 = dot (tmpvar_14, xlv_TEXCOORD4);
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_14, xlv_TEXCOORD5);
  highp vec2 tmpvar_17;
  tmpvar_17.x = ((-(tmpvar_15) * tmpvar_15) * tmpvar_15);
  tmpvar_17.y = -(tmpvar_15);
  coord0_13 = (tmpvar_17 * movespeed1);
  coord0_13 = (coord0_13 * specoffset1.xy);
  highp vec2 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.x;
  highp float tmpvar_19;
  tmpvar_19 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_18.y = tmpvar_19;
  coord0_13 = ((coord0_13 + initoffset.xy) + tmpvar_18);
  coord0_13.y = (1.0 - coord0_13.y);
  lowp float tmpvar_20;
  tmpvar_20 = texture2D (specularMap, coord0_13).x;
  specular0_12 = tmpvar_20;
  highp vec2 tmpvar_21;
  tmpvar_21.x = tmpvar_15;
  tmpvar_21.y = -(tmpvar_16);
  coord1_11 = (tmpvar_21 * movespeed2);
  coord1_11 = (coord1_11 * specoffset2.xy);
  highp vec2 tmpvar_22;
  tmpvar_22.x = xlv_TEXCOORD1.x;
  tmpvar_22.y = tmpvar_19;
  coord1_11 = ((coord1_11 + initoffset.xy) + tmpvar_22);
  coord1_11.y = (1.0 - coord1_11.y);
  lowp float tmpvar_23;
  tmpvar_23 = texture2D (specularMap, coord1_11).y;
  specular1_10 = tmpvar_23;
  coord2_9 = (abs(vec2(tmpvar_15)) * movespeed3);
  coord2_9 = (coord2_9 * specoffset3.xy);
  highp vec2 tmpvar_24;
  tmpvar_24.x = xlv_TEXCOORD1.x;
  tmpvar_24.y = tmpvar_19;
  coord2_9 = ((coord2_9 + initoffset.xy) + tmpvar_24);
  coord2_9.y = (1.0 - coord2_9.y);
  lowp float tmpvar_25;
  tmpvar_25 = texture2D (specularMap, coord2_9).z;
  specular2_8 = tmpvar_25;
  highp vec3 tmpvar_26;
  tmpvar_26.x = specular0_12;
  tmpvar_26.y = specular1_10;
  tmpvar_26.z = specular2_8;
  highp vec2 tmpvar_27;
  tmpvar_27.x = tmpvar_15;
  tmpvar_27.y = -(tmpvar_16);
  highp vec2 tmpvar_28;
  tmpvar_28 = ((tmpvar_27 * eyeheight) * 0.5);
  lowp float tmpvar_29;
  tmpvar_29 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_29;
  highp vec2 tmpvar_30;
  tmpvar_30.x = xlv_TEXCOORD0.x;
  highp float tmpvar_31;
  tmpvar_31 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_30.y = tmpvar_31;
  highp vec2 tmpvar_32;
  tmpvar_32 = ((vec2(height0_7) * tmpvar_28) + tmpvar_30);
  hcoord1_6.x = tmpvar_32.x;
  hcoord1_6.y = (1.0 - tmpvar_32.y);
  lowp float tmpvar_33;
  tmpvar_33 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_33;
  highp vec2 tmpvar_34;
  tmpvar_34.x = xlv_TEXCOORD0.x;
  tmpvar_34.y = tmpvar_31;
  highp vec2 tmpvar_35;
  tmpvar_35 = ((vec2(height1_5) * tmpvar_28) + tmpvar_34);
  hcoord2_4.x = tmpvar_35.x;
  hcoord2_4.y = (1.0 - tmpvar_35.y);
  lowp float tmpvar_36;
  tmpvar_36 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_36;
  highp vec2 tmpvar_37;
  tmpvar_37.x = xlv_TEXCOORD0.x;
  tmpvar_37.y = tmpvar_31;
  highp vec2 tmpvar_38;
  tmpvar_38 = ((vec2(height2_3) * tmpvar_28) + tmpvar_37);
  hcoord3_2.x = tmpvar_38.x;
  hcoord3_2.y = (1.0 - tmpvar_38.y);
  lowp vec3 tmpvar_39;
  tmpvar_39 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_39;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 tmpvar_40;
  tmpvar_40.w = 1.0;
  tmpvar_40.xyz = ((mainColor_1 + vec3(dot (tmpvar_26, intensity))) * ((LIGHT1COLOR.xyz * Light1Intensity) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_40;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_7;
  tmpvar_7[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_7[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_7[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_7 * _glesNormal));
  highp mat3 tmpvar_8;
  tmpvar_8[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_8[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_8[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  tmpvar_3.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_10))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  tmpvar_3.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_11)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * tmpvar_6).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_8 * vec3(1.0, 0.0, 0.0)));
  xlv_TEXCOORD5 = normalize((tmpvar_9 * vec3(0.0, 1.0, 0.0)));
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD6 = tmpvar_3;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float totalSpecular_8;
  highp float specular2_9;
  highp vec2 coord2_10;
  highp float specular1_11;
  highp vec2 coord1_12;
  highp float specular0_13;
  highp vec2 coord0_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_15, xlv_TEXCOORD4);
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_15, xlv_TEXCOORD5);
  highp vec2 tmpvar_18;
  tmpvar_18.x = ((-(tmpvar_16) * tmpvar_16) * tmpvar_16);
  tmpvar_18.y = -(tmpvar_16);
  coord0_14 = (tmpvar_18 * movespeed1);
  coord0_14 = (coord0_14 * specoffset1.xy);
  highp vec2 tmpvar_19;
  tmpvar_19.x = xlv_TEXCOORD1.x;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_19.y = tmpvar_20;
  coord0_14 = ((coord0_14 + initoffset.xy) + tmpvar_19);
  coord0_14.y = (1.0 - coord0_14.y);
  lowp float tmpvar_21;
  tmpvar_21 = texture2D (specularMap, coord0_14).x;
  specular0_13 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22.x = tmpvar_16;
  tmpvar_22.y = -(tmpvar_17);
  coord1_12 = (tmpvar_22 * movespeed2);
  coord1_12 = (coord1_12 * specoffset2.xy);
  highp vec2 tmpvar_23;
  tmpvar_23.x = xlv_TEXCOORD1.x;
  tmpvar_23.y = tmpvar_20;
  coord1_12 = ((coord1_12 + initoffset.xy) + tmpvar_23);
  coord1_12.y = (1.0 - coord1_12.y);
  lowp float tmpvar_24;
  tmpvar_24 = texture2D (specularMap, coord1_12).y;
  specular1_11 = tmpvar_24;
  coord2_10 = (abs(vec2(tmpvar_16)) * movespeed3);
  coord2_10 = (coord2_10 * specoffset3.xy);
  highp vec2 tmpvar_25;
  tmpvar_25.x = xlv_TEXCOORD1.x;
  tmpvar_25.y = tmpvar_20;
  coord2_10 = ((coord2_10 + initoffset.xy) + tmpvar_25);
  coord2_10.y = (1.0 - coord2_10.y);
  lowp float tmpvar_26;
  tmpvar_26 = texture2D (specularMap, coord2_10).z;
  specular2_9 = tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_27.x = specular0_13;
  tmpvar_27.y = specular1_11;
  tmpvar_27.z = specular2_9;
  totalSpecular_8 = dot (tmpvar_27, intensity);
  highp vec2 tmpvar_28;
  tmpvar_28.x = tmpvar_16;
  tmpvar_28.y = -(tmpvar_17);
  highp vec2 tmpvar_29;
  tmpvar_29 = ((tmpvar_28 * eyeheight) * 0.5);
  lowp float tmpvar_30;
  tmpvar_30 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_30;
  highp vec2 tmpvar_31;
  tmpvar_31.x = xlv_TEXCOORD0.x;
  highp float tmpvar_32;
  tmpvar_32 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_31.y = tmpvar_32;
  highp vec2 tmpvar_33;
  tmpvar_33 = ((vec2(height0_7) * tmpvar_29) + tmpvar_31);
  hcoord1_6.x = tmpvar_33.x;
  hcoord1_6.y = (1.0 - tmpvar_33.y);
  lowp float tmpvar_34;
  tmpvar_34 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_34;
  highp vec2 tmpvar_35;
  tmpvar_35.x = xlv_TEXCOORD0.x;
  tmpvar_35.y = tmpvar_32;
  highp vec2 tmpvar_36;
  tmpvar_36 = ((vec2(height1_5) * tmpvar_29) + tmpvar_35);
  hcoord2_4.x = tmpvar_36.x;
  hcoord2_4.y = (1.0 - tmpvar_36.y);
  lowp float tmpvar_37;
  tmpvar_37 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_37;
  highp vec2 tmpvar_38;
  tmpvar_38.x = xlv_TEXCOORD0.x;
  tmpvar_38.y = tmpvar_32;
  highp vec2 tmpvar_39;
  tmpvar_39 = ((vec2(height2_3) * tmpvar_29) + tmpvar_38);
  hcoord3_2.x = tmpvar_39.x;
  hcoord3_2.y = (1.0 - tmpvar_39.y);
  lowp vec3 tmpvar_40;
  tmpvar_40 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_40;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 shadowCoord_41;
  shadowCoord_41 = xlv_TEXCOORD6;
  highp float tmpvar_42;
  if ((xlv_TEXCOORD6.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_42 = 1.0;
  } else {
    shadowCoord_41.y = (1.0 - xlv_TEXCOORD6.y);
    highp vec2 fetchesOffsetsV_43;
    highp vec2 fetchesOffsetsU_44;
    highp float shadow_45;
    highp vec2 tmpvar_46;
    tmpvar_46 = (shadowCoord_41.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_47;
    tmpvar_47 = floor((tmpvar_46 + 0.5));
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_46 - tmpvar_47);
    highp vec4 computedWeight_49;
    highp vec4 computedArea_50;
    highp vec4 computedAreaUncut_51;
    highp float tmpvar_52;
    tmpvar_52 = (((tmpvar_48.x + 0.5) * (tmpvar_48.x + 0.5)) * 0.5);
    highp float tmpvar_53;
    tmpvar_53 = (tmpvar_52 - tmpvar_48.x);
    computedArea_50.x = tmpvar_53;
    computedAreaUncut_51.x = tmpvar_53;
    computedArea_50.w = tmpvar_52;
    computedAreaUncut_51.w = tmpvar_52;
    computedAreaUncut_51.y = ((1.5 - tmpvar_48.x) - 0.5);
    highp float tmpvar_54;
    tmpvar_54 = min (tmpvar_48.x, 0.0);
    computedArea_50.y = (computedAreaUncut_51.y - (tmpvar_54 * tmpvar_54));
    computedAreaUncut_51.z = ((1.5 + tmpvar_48.x) - 0.5);
    highp float tmpvar_55;
    tmpvar_55 = max (tmpvar_48.x, 0.0);
    computedArea_50.z = (computedAreaUncut_51.z - (tmpvar_55 * tmpvar_55));
    computedWeight_49 = (computedArea_50 * 0.44444);
    highp vec4 computedWeight_56;
    highp vec4 computedArea_57;
    highp vec4 computedAreaUncut_58;
    highp float tmpvar_59;
    tmpvar_59 = (((tmpvar_48.y + 0.5) * (tmpvar_48.y + 0.5)) * 0.5);
    highp float tmpvar_60;
    tmpvar_60 = (tmpvar_59 - tmpvar_48.y);
    computedArea_57.x = tmpvar_60;
    computedAreaUncut_58.x = tmpvar_60;
    computedArea_57.w = tmpvar_59;
    computedAreaUncut_58.w = tmpvar_59;
    computedAreaUncut_58.y = ((1.5 - tmpvar_48.y) - 0.5);
    highp float tmpvar_61;
    tmpvar_61 = min (tmpvar_48.y, 0.0);
    computedArea_57.y = (computedAreaUncut_58.y - (tmpvar_61 * tmpvar_61));
    computedAreaUncut_58.z = ((1.5 + tmpvar_48.y) - 0.5);
    highp float tmpvar_62;
    tmpvar_62 = max (tmpvar_48.y, 0.0);
    computedArea_57.z = (computedAreaUncut_58.z - (tmpvar_62 * tmpvar_62));
    computedWeight_56 = (computedArea_57 * 0.44444);
    highp vec2 tmpvar_63;
    tmpvar_63 = (computedWeight_49.xz + computedWeight_49.yw);
    highp vec2 tmpvar_64;
    tmpvar_64 = (computedWeight_56.xz + computedWeight_56.yw);
    fetchesOffsetsU_44 = (((computedWeight_49.yw / tmpvar_63) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_43 = (((computedWeight_56.yw / tmpvar_64) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_65;
    tmpvar_65 = (tmpvar_47 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_44.x;
    tmpvar_66.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_65 + tmpvar_66);
    tmpvar_67.z = shadowCoord_41.z;
    lowp float tmpvar_68;
    tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_45 = ((tmpvar_63.x * tmpvar_64.x) * tmpvar_68);
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_44.y;
    tmpvar_69.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_65 + tmpvar_69);
    tmpvar_70.z = shadowCoord_41.z;
    lowp float tmpvar_71;
    tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_45 = (shadow_45 + ((tmpvar_63.y * tmpvar_64.x) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_44.x;
    tmpvar_72.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_65 + tmpvar_72);
    tmpvar_73.z = shadowCoord_41.z;
    lowp float tmpvar_74;
    tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_45 = (shadow_45 + ((tmpvar_63.x * tmpvar_64.y) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_44.y;
    tmpvar_75.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_65 + tmpvar_75);
    tmpvar_76.z = shadowCoord_41.z;
    lowp float tmpvar_77;
    tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_45 = (shadow_45 + ((tmpvar_63.y * tmpvar_64.y) * tmpvar_77));
    tmpvar_42 = mix (1.0, shadow_45, LIGHT_PARAM.y);
  };
  highp vec4 tmpvar_78;
  tmpvar_78.w = 1.0;
  tmpvar_78.xyz = ((mainColor_1 + vec3(totalSpecular_8)) * ((
    (LIGHT1COLOR.xyz * Light1Intensity)
   * tmpvar_42) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_78;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_7;
  tmpvar_7[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_7[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_7[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_7 * _glesNormal));
  highp mat3 tmpvar_8;
  tmpvar_8[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_8[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_8[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  tmpvar_3.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_10))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  tmpvar_3.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_11)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * tmpvar_6).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_8 * vec3(1.0, 0.0, 0.0)));
  xlv_TEXCOORD5 = normalize((tmpvar_9 * vec3(0.0, 1.0, 0.0)));
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD6 = tmpvar_3;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float totalSpecular_8;
  highp float specular2_9;
  highp vec2 coord2_10;
  highp float specular1_11;
  highp vec2 coord1_12;
  highp float specular0_13;
  highp vec2 coord0_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_15, xlv_TEXCOORD4);
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_15, xlv_TEXCOORD5);
  highp vec2 tmpvar_18;
  tmpvar_18.x = ((-(tmpvar_16) * tmpvar_16) * tmpvar_16);
  tmpvar_18.y = -(tmpvar_16);
  coord0_14 = (tmpvar_18 * movespeed1);
  coord0_14 = (coord0_14 * specoffset1.xy);
  highp vec2 tmpvar_19;
  tmpvar_19.x = xlv_TEXCOORD1.x;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_19.y = tmpvar_20;
  coord0_14 = ((coord0_14 + initoffset.xy) + tmpvar_19);
  coord0_14.y = (1.0 - coord0_14.y);
  lowp float tmpvar_21;
  tmpvar_21 = texture2D (specularMap, coord0_14).x;
  specular0_13 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22.x = tmpvar_16;
  tmpvar_22.y = -(tmpvar_17);
  coord1_12 = (tmpvar_22 * movespeed2);
  coord1_12 = (coord1_12 * specoffset2.xy);
  highp vec2 tmpvar_23;
  tmpvar_23.x = xlv_TEXCOORD1.x;
  tmpvar_23.y = tmpvar_20;
  coord1_12 = ((coord1_12 + initoffset.xy) + tmpvar_23);
  coord1_12.y = (1.0 - coord1_12.y);
  lowp float tmpvar_24;
  tmpvar_24 = texture2D (specularMap, coord1_12).y;
  specular1_11 = tmpvar_24;
  coord2_10 = (abs(vec2(tmpvar_16)) * movespeed3);
  coord2_10 = (coord2_10 * specoffset3.xy);
  highp vec2 tmpvar_25;
  tmpvar_25.x = xlv_TEXCOORD1.x;
  tmpvar_25.y = tmpvar_20;
  coord2_10 = ((coord2_10 + initoffset.xy) + tmpvar_25);
  coord2_10.y = (1.0 - coord2_10.y);
  lowp float tmpvar_26;
  tmpvar_26 = texture2D (specularMap, coord2_10).z;
  specular2_9 = tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_27.x = specular0_13;
  tmpvar_27.y = specular1_11;
  tmpvar_27.z = specular2_9;
  totalSpecular_8 = dot (tmpvar_27, intensity);
  highp vec2 tmpvar_28;
  tmpvar_28.x = tmpvar_16;
  tmpvar_28.y = -(tmpvar_17);
  highp vec2 tmpvar_29;
  tmpvar_29 = ((tmpvar_28 * eyeheight) * 0.5);
  lowp float tmpvar_30;
  tmpvar_30 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_30;
  highp vec2 tmpvar_31;
  tmpvar_31.x = xlv_TEXCOORD0.x;
  highp float tmpvar_32;
  tmpvar_32 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_31.y = tmpvar_32;
  highp vec2 tmpvar_33;
  tmpvar_33 = ((vec2(height0_7) * tmpvar_29) + tmpvar_31);
  hcoord1_6.x = tmpvar_33.x;
  hcoord1_6.y = (1.0 - tmpvar_33.y);
  lowp float tmpvar_34;
  tmpvar_34 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_34;
  highp vec2 tmpvar_35;
  tmpvar_35.x = xlv_TEXCOORD0.x;
  tmpvar_35.y = tmpvar_32;
  highp vec2 tmpvar_36;
  tmpvar_36 = ((vec2(height1_5) * tmpvar_29) + tmpvar_35);
  hcoord2_4.x = tmpvar_36.x;
  hcoord2_4.y = (1.0 - tmpvar_36.y);
  lowp float tmpvar_37;
  tmpvar_37 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_37;
  highp vec2 tmpvar_38;
  tmpvar_38.x = xlv_TEXCOORD0.x;
  tmpvar_38.y = tmpvar_32;
  highp vec2 tmpvar_39;
  tmpvar_39 = ((vec2(height2_3) * tmpvar_29) + tmpvar_38);
  hcoord3_2.x = tmpvar_39.x;
  hcoord3_2.y = (1.0 - tmpvar_39.y);
  lowp vec3 tmpvar_40;
  tmpvar_40 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_40;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 shadowCoord_41;
  shadowCoord_41 = xlv_TEXCOORD6;
  highp float tmpvar_42;
  if ((xlv_TEXCOORD6.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_42 = 1.0;
  } else {
    shadowCoord_41.y = (1.0 - xlv_TEXCOORD6.y);
    highp vec3 fetchesOffsetsV_43;
    highp vec3 fetchesOffsetsU_44;
    highp float shadow_45;
    highp vec2 tmpvar_46;
    tmpvar_46 = (shadowCoord_41.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_47;
    tmpvar_47 = floor((tmpvar_46 + 0.5));
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_46 - tmpvar_47);
    highp vec3 texelsWeightsA_49;
    highp vec3 texelsWeightsB_50;
    highp vec4 computedArea_51;
    highp vec4 computedAreaUncut_52;
    highp float tmpvar_53;
    tmpvar_53 = (((tmpvar_48.x + 0.5) * (tmpvar_48.x + 0.5)) * 0.5);
    highp float tmpvar_54;
    tmpvar_54 = (tmpvar_53 - tmpvar_48.x);
    computedArea_51.x = tmpvar_54;
    computedAreaUncut_52.x = tmpvar_54;
    computedArea_51.w = tmpvar_53;
    computedAreaUncut_52.w = tmpvar_53;
    computedAreaUncut_52.y = ((1.5 - tmpvar_48.x) - 0.5);
    highp float tmpvar_55;
    tmpvar_55 = min (tmpvar_48.x, 0.0);
    computedArea_51.y = (computedAreaUncut_52.y - (tmpvar_55 * tmpvar_55));
    computedAreaUncut_52.z = ((1.5 + tmpvar_48.x) - 0.5);
    highp float tmpvar_56;
    tmpvar_56 = max (tmpvar_48.x, 0.0);
    computedArea_51.z = (computedAreaUncut_52.z - (tmpvar_56 * tmpvar_56));
    texelsWeightsA_49.x = (0.16 * tmpvar_54);
    texelsWeightsA_49.y = (0.16 * computedAreaUncut_52.y);
    texelsWeightsA_49.z = (0.16 * (computedArea_51.y + 1.0));
    texelsWeightsB_50.x = (0.16 * (computedArea_51.z + 1.0));
    texelsWeightsB_50.y = (0.16 * computedAreaUncut_52.z);
    texelsWeightsB_50.z = (0.16 * tmpvar_53);
    highp vec3 texelsWeightsA_57;
    highp vec3 texelsWeightsB_58;
    highp vec4 computedArea_59;
    highp vec4 computedAreaUncut_60;
    highp float tmpvar_61;
    tmpvar_61 = (((tmpvar_48.y + 0.5) * (tmpvar_48.y + 0.5)) * 0.5);
    highp float tmpvar_62;
    tmpvar_62 = (tmpvar_61 - tmpvar_48.y);
    computedArea_59.x = tmpvar_62;
    computedAreaUncut_60.x = tmpvar_62;
    computedArea_59.w = tmpvar_61;
    computedAreaUncut_60.w = tmpvar_61;
    computedAreaUncut_60.y = ((1.5 - tmpvar_48.y) - 0.5);
    highp float tmpvar_63;
    tmpvar_63 = min (tmpvar_48.y, 0.0);
    computedArea_59.y = (computedAreaUncut_60.y - (tmpvar_63 * tmpvar_63));
    computedAreaUncut_60.z = ((1.5 + tmpvar_48.y) - 0.5);
    highp float tmpvar_64;
    tmpvar_64 = max (tmpvar_48.y, 0.0);
    computedArea_59.z = (computedAreaUncut_60.z - (tmpvar_64 * tmpvar_64));
    texelsWeightsA_57.x = (0.16 * tmpvar_62);
    texelsWeightsA_57.y = (0.16 * computedAreaUncut_60.y);
    texelsWeightsA_57.z = (0.16 * (computedArea_59.y + 1.0));
    texelsWeightsB_58.x = (0.16 * (computedArea_59.z + 1.0));
    texelsWeightsB_58.y = (0.16 * computedAreaUncut_60.z);
    texelsWeightsB_58.z = (0.16 * tmpvar_61);
    highp vec3 tmpvar_65;
    tmpvar_65.xy = texelsWeightsA_49.xz;
    tmpvar_65.z = texelsWeightsB_50.y;
    highp vec3 tmpvar_66;
    tmpvar_66.x = texelsWeightsA_49.y;
    tmpvar_66.yz = texelsWeightsB_50.xz;
    highp vec3 tmpvar_67;
    tmpvar_67 = (tmpvar_65 + tmpvar_66);
    highp vec3 tmpvar_68;
    tmpvar_68.xy = texelsWeightsA_57.xz;
    tmpvar_68.z = texelsWeightsB_58.y;
    highp vec3 tmpvar_69;
    tmpvar_69.x = texelsWeightsA_57.y;
    tmpvar_69.yz = texelsWeightsB_58.xz;
    highp vec3 tmpvar_70;
    tmpvar_70 = (tmpvar_68 + tmpvar_69);
    highp vec3 tmpvar_71;
    tmpvar_71.x = texelsWeightsA_49.y;
    tmpvar_71.yz = texelsWeightsB_50.xz;
    highp vec3 tmpvar_72;
    tmpvar_72.x = texelsWeightsA_57.y;
    tmpvar_72.yz = texelsWeightsB_58.xz;
    fetchesOffsetsU_44 = (((tmpvar_71 / tmpvar_67) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_43 = (((tmpvar_72 / tmpvar_70) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_73;
    tmpvar_73 = (tmpvar_47 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_44.x;
    tmpvar_74.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_73 + tmpvar_74);
    tmpvar_75.z = shadowCoord_41.z;
    lowp float tmpvar_76;
    tmpvar_76 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_45 = ((tmpvar_67.x * tmpvar_70.x) * tmpvar_76);
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_44.y;
    tmpvar_77.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_73 + tmpvar_77);
    tmpvar_78.z = shadowCoord_41.z;
    lowp float tmpvar_79;
    tmpvar_79 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.x) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_44.z;
    tmpvar_80.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_73 + tmpvar_80);
    tmpvar_81.z = shadowCoord_41.z;
    lowp float tmpvar_82;
    tmpvar_82 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.x) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_44.x;
    tmpvar_83.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_73 + tmpvar_83);
    tmpvar_84.z = shadowCoord_41.z;
    lowp float tmpvar_85;
    tmpvar_85 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.y) * tmpvar_85));
    highp vec2 tmpvar_86;
    tmpvar_86.x = fetchesOffsetsU_44.y;
    tmpvar_86.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_87;
    tmpvar_87.xy = (tmpvar_73 + tmpvar_86);
    tmpvar_87.z = shadowCoord_41.z;
    lowp float tmpvar_88;
    tmpvar_88 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_87);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.y) * tmpvar_88));
    highp vec2 tmpvar_89;
    tmpvar_89.x = fetchesOffsetsU_44.z;
    tmpvar_89.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_90;
    tmpvar_90.xy = (tmpvar_73 + tmpvar_89);
    tmpvar_90.z = shadowCoord_41.z;
    lowp float tmpvar_91;
    tmpvar_91 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_90);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.y) * tmpvar_91));
    highp vec2 tmpvar_92;
    tmpvar_92.x = fetchesOffsetsU_44.x;
    tmpvar_92.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_93;
    tmpvar_93.xy = (tmpvar_73 + tmpvar_92);
    tmpvar_93.z = shadowCoord_41.z;
    lowp float tmpvar_94;
    tmpvar_94 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_93);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.z) * tmpvar_94));
    highp vec2 tmpvar_95;
    tmpvar_95.x = fetchesOffsetsU_44.y;
    tmpvar_95.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_96;
    tmpvar_96.xy = (tmpvar_73 + tmpvar_95);
    tmpvar_96.z = shadowCoord_41.z;
    lowp float tmpvar_97;
    tmpvar_97 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_96);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.z) * tmpvar_97));
    highp vec2 tmpvar_98;
    tmpvar_98.x = fetchesOffsetsU_44.z;
    tmpvar_98.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_99;
    tmpvar_99.xy = (tmpvar_73 + tmpvar_98);
    tmpvar_99.z = shadowCoord_41.z;
    lowp float tmpvar_100;
    tmpvar_100 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_99);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.z) * tmpvar_100));
    tmpvar_42 = mix (1.0, shadow_45, LIGHT_PARAM.y);
  };
  highp vec4 tmpvar_101;
  tmpvar_101.w = 1.0;
  tmpvar_101.xyz = ((mainColor_1 + vec3(totalSpecular_8)) * ((
    (LIGHT1COLOR.xyz * Light1Intensity)
   * tmpvar_42) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_101;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_7;
  tmpvar_7[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_7[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_7[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_7 * _glesNormal));
  highp mat3 tmpvar_8;
  tmpvar_8[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_8[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_8[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  tmpvar_3.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_10))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  tmpvar_3.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_11)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * tmpvar_6).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_8 * vec3(1.0, 0.0, 0.0)));
  xlv_TEXCOORD5 = normalize((tmpvar_9 * vec3(0.0, 1.0, 0.0)));
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD6 = tmpvar_3;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float totalSpecular_8;
  highp float specular2_9;
  highp vec2 coord2_10;
  highp float specular1_11;
  highp vec2 coord1_12;
  highp float specular0_13;
  highp vec2 coord0_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_15, xlv_TEXCOORD4);
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_15, xlv_TEXCOORD5);
  highp vec2 tmpvar_18;
  tmpvar_18.x = ((-(tmpvar_16) * tmpvar_16) * tmpvar_16);
  tmpvar_18.y = -(tmpvar_16);
  coord0_14 = (tmpvar_18 * movespeed1);
  coord0_14 = (coord0_14 * specoffset1.xy);
  highp vec2 tmpvar_19;
  tmpvar_19.x = xlv_TEXCOORD1.x;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_19.y = tmpvar_20;
  coord0_14 = ((coord0_14 + initoffset.xy) + tmpvar_19);
  coord0_14.y = (1.0 - coord0_14.y);
  lowp float tmpvar_21;
  tmpvar_21 = texture2D (specularMap, coord0_14).x;
  specular0_13 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22.x = tmpvar_16;
  tmpvar_22.y = -(tmpvar_17);
  coord1_12 = (tmpvar_22 * movespeed2);
  coord1_12 = (coord1_12 * specoffset2.xy);
  highp vec2 tmpvar_23;
  tmpvar_23.x = xlv_TEXCOORD1.x;
  tmpvar_23.y = tmpvar_20;
  coord1_12 = ((coord1_12 + initoffset.xy) + tmpvar_23);
  coord1_12.y = (1.0 - coord1_12.y);
  lowp float tmpvar_24;
  tmpvar_24 = texture2D (specularMap, coord1_12).y;
  specular1_11 = tmpvar_24;
  coord2_10 = (abs(vec2(tmpvar_16)) * movespeed3);
  coord2_10 = (coord2_10 * specoffset3.xy);
  highp vec2 tmpvar_25;
  tmpvar_25.x = xlv_TEXCOORD1.x;
  tmpvar_25.y = tmpvar_20;
  coord2_10 = ((coord2_10 + initoffset.xy) + tmpvar_25);
  coord2_10.y = (1.0 - coord2_10.y);
  lowp float tmpvar_26;
  tmpvar_26 = texture2D (specularMap, coord2_10).z;
  specular2_9 = tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_27.x = specular0_13;
  tmpvar_27.y = specular1_11;
  tmpvar_27.z = specular2_9;
  totalSpecular_8 = dot (tmpvar_27, intensity);
  highp vec2 tmpvar_28;
  tmpvar_28.x = tmpvar_16;
  tmpvar_28.y = -(tmpvar_17);
  highp vec2 tmpvar_29;
  tmpvar_29 = ((tmpvar_28 * eyeheight) * 0.5);
  lowp float tmpvar_30;
  tmpvar_30 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_30;
  highp vec2 tmpvar_31;
  tmpvar_31.x = xlv_TEXCOORD0.x;
  highp float tmpvar_32;
  tmpvar_32 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_31.y = tmpvar_32;
  highp vec2 tmpvar_33;
  tmpvar_33 = ((vec2(height0_7) * tmpvar_29) + tmpvar_31);
  hcoord1_6.x = tmpvar_33.x;
  hcoord1_6.y = (1.0 - tmpvar_33.y);
  lowp float tmpvar_34;
  tmpvar_34 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_34;
  highp vec2 tmpvar_35;
  tmpvar_35.x = xlv_TEXCOORD0.x;
  tmpvar_35.y = tmpvar_32;
  highp vec2 tmpvar_36;
  tmpvar_36 = ((vec2(height1_5) * tmpvar_29) + tmpvar_35);
  hcoord2_4.x = tmpvar_36.x;
  hcoord2_4.y = (1.0 - tmpvar_36.y);
  lowp float tmpvar_37;
  tmpvar_37 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_37;
  highp vec2 tmpvar_38;
  tmpvar_38.x = xlv_TEXCOORD0.x;
  tmpvar_38.y = tmpvar_32;
  highp vec2 tmpvar_39;
  tmpvar_39 = ((vec2(height2_3) * tmpvar_29) + tmpvar_38);
  hcoord3_2.x = tmpvar_39.x;
  hcoord3_2.y = (1.0 - tmpvar_39.y);
  lowp vec3 tmpvar_40;
  tmpvar_40 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_40;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 shadowCoord_41;
  shadowCoord_41 = xlv_TEXCOORD6;
  highp float tmpvar_42;
  if ((xlv_TEXCOORD6.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_42 = 1.0;
  } else {
    shadowCoord_41.y = (1.0 - xlv_TEXCOORD6.y);
    highp vec4 fetchesOffsetsV_43;
    highp vec4 fetchesOffsetsU_44;
    highp float shadow_45;
    highp vec2 tmpvar_46;
    tmpvar_46 = (shadowCoord_41.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_47;
    tmpvar_47 = floor((tmpvar_46 + 0.5));
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_46 - tmpvar_47);
    highp vec4 texelsWeightsA_49;
    highp vec4 texelsWeightsB_50;
    highp vec4 computedArea_51;
    highp vec4 computedAreaUncut_52;
    highp float tmpvar_53;
    tmpvar_53 = (((tmpvar_48.x + 0.5) * (tmpvar_48.x + 0.5)) * 0.5);
    highp float tmpvar_54;
    tmpvar_54 = (tmpvar_53 - tmpvar_48.x);
    computedArea_51.x = tmpvar_54;
    computedAreaUncut_52.x = tmpvar_54;
    computedArea_51.w = tmpvar_53;
    computedAreaUncut_52.w = tmpvar_53;
    computedAreaUncut_52.y = ((1.5 - tmpvar_48.x) - 0.5);
    highp float tmpvar_55;
    tmpvar_55 = min (tmpvar_48.x, 0.0);
    computedArea_51.y = (computedAreaUncut_52.y - (tmpvar_55 * tmpvar_55));
    computedAreaUncut_52.z = ((1.5 + tmpvar_48.x) - 0.5);
    highp float tmpvar_56;
    tmpvar_56 = max (tmpvar_48.x, 0.0);
    computedArea_51.z = (computedAreaUncut_52.z - (tmpvar_56 * tmpvar_56));
    texelsWeightsA_49.x = (0.081632 * tmpvar_54);
    texelsWeightsA_49.y = (0.081632 * computedAreaUncut_52.y);
    texelsWeightsA_49.z = (0.081632 * (computedAreaUncut_52.y + 1.0));
    texelsWeightsA_49.w = (0.081632 * (computedArea_51.y + 2.0));
    texelsWeightsB_50.x = (0.081632 * (computedArea_51.z + 2.0));
    texelsWeightsB_50.y = (0.081632 * (computedAreaUncut_52.z + 1.0));
    texelsWeightsB_50.z = (0.081632 * computedAreaUncut_52.z);
    texelsWeightsB_50.w = (0.081632 * tmpvar_53);
    highp vec4 texelsWeightsA_57;
    highp vec4 texelsWeightsB_58;
    highp vec4 computedArea_59;
    highp vec4 computedAreaUncut_60;
    highp float tmpvar_61;
    tmpvar_61 = (((tmpvar_48.y + 0.5) * (tmpvar_48.y + 0.5)) * 0.5);
    highp float tmpvar_62;
    tmpvar_62 = (tmpvar_61 - tmpvar_48.y);
    computedArea_59.x = tmpvar_62;
    computedAreaUncut_60.x = tmpvar_62;
    computedArea_59.w = tmpvar_61;
    computedAreaUncut_60.w = tmpvar_61;
    computedAreaUncut_60.y = ((1.5 - tmpvar_48.y) - 0.5);
    highp float tmpvar_63;
    tmpvar_63 = min (tmpvar_48.y, 0.0);
    computedArea_59.y = (computedAreaUncut_60.y - (tmpvar_63 * tmpvar_63));
    computedAreaUncut_60.z = ((1.5 + tmpvar_48.y) - 0.5);
    highp float tmpvar_64;
    tmpvar_64 = max (tmpvar_48.y, 0.0);
    computedArea_59.z = (computedAreaUncut_60.z - (tmpvar_64 * tmpvar_64));
    texelsWeightsA_57.x = (0.081632 * tmpvar_62);
    texelsWeightsA_57.y = (0.081632 * computedAreaUncut_60.y);
    texelsWeightsA_57.z = (0.081632 * (computedAreaUncut_60.y + 1.0));
    texelsWeightsA_57.w = (0.081632 * (computedArea_59.y + 2.0));
    texelsWeightsB_58.x = (0.081632 * (computedArea_59.z + 2.0));
    texelsWeightsB_58.y = (0.081632 * (computedAreaUncut_60.z + 1.0));
    texelsWeightsB_58.z = (0.081632 * computedAreaUncut_60.z);
    texelsWeightsB_58.w = (0.081632 * tmpvar_61);
    highp vec4 tmpvar_65;
    tmpvar_65.xy = texelsWeightsA_49.xz;
    tmpvar_65.zw = texelsWeightsB_50.xz;
    highp vec4 tmpvar_66;
    tmpvar_66.xy = texelsWeightsA_49.yw;
    tmpvar_66.zw = texelsWeightsB_50.yw;
    highp vec4 tmpvar_67;
    tmpvar_67 = (tmpvar_65 + tmpvar_66);
    highp vec4 tmpvar_68;
    tmpvar_68.xy = texelsWeightsA_57.xz;
    tmpvar_68.zw = texelsWeightsB_58.xz;
    highp vec4 tmpvar_69;
    tmpvar_69.xy = texelsWeightsA_57.yw;
    tmpvar_69.zw = texelsWeightsB_58.yw;
    highp vec4 tmpvar_70;
    tmpvar_70 = (tmpvar_68 + tmpvar_69);
    highp vec4 tmpvar_71;
    tmpvar_71.xy = texelsWeightsA_49.yw;
    tmpvar_71.zw = texelsWeightsB_50.yw;
    highp vec4 tmpvar_72;
    tmpvar_72.xy = texelsWeightsA_57.yw;
    tmpvar_72.zw = texelsWeightsB_58.yw;
    fetchesOffsetsU_44 = (((tmpvar_71 / tmpvar_67) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_43 = (((tmpvar_72 / tmpvar_70) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_73;
    tmpvar_73 = (tmpvar_47 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_44.x;
    tmpvar_74.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_73 + tmpvar_74);
    tmpvar_75.z = shadowCoord_41.z;
    lowp float tmpvar_76;
    tmpvar_76 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_45 = ((tmpvar_67.x * tmpvar_70.x) * tmpvar_76);
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_44.y;
    tmpvar_77.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_73 + tmpvar_77);
    tmpvar_78.z = shadowCoord_41.z;
    lowp float tmpvar_79;
    tmpvar_79 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.x) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_44.z;
    tmpvar_80.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_73 + tmpvar_80);
    tmpvar_81.z = shadowCoord_41.z;
    lowp float tmpvar_82;
    tmpvar_82 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.x) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_44.w;
    tmpvar_83.y = fetchesOffsetsV_43.x;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_73 + tmpvar_83);
    tmpvar_84.z = shadowCoord_41.z;
    lowp float tmpvar_85;
    tmpvar_85 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_45 = (shadow_45 + ((tmpvar_67.w * tmpvar_70.x) * tmpvar_85));
    highp vec2 tmpvar_86;
    tmpvar_86.x = fetchesOffsetsU_44.x;
    tmpvar_86.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_87;
    tmpvar_87.xy = (tmpvar_73 + tmpvar_86);
    tmpvar_87.z = shadowCoord_41.z;
    lowp float tmpvar_88;
    tmpvar_88 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_87);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.y) * tmpvar_88));
    highp vec2 tmpvar_89;
    tmpvar_89.x = fetchesOffsetsU_44.y;
    tmpvar_89.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_90;
    tmpvar_90.xy = (tmpvar_73 + tmpvar_89);
    tmpvar_90.z = shadowCoord_41.z;
    lowp float tmpvar_91;
    tmpvar_91 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_90);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.y) * tmpvar_91));
    highp vec2 tmpvar_92;
    tmpvar_92.x = fetchesOffsetsU_44.z;
    tmpvar_92.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_93;
    tmpvar_93.xy = (tmpvar_73 + tmpvar_92);
    tmpvar_93.z = shadowCoord_41.z;
    lowp float tmpvar_94;
    tmpvar_94 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_93);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.y) * tmpvar_94));
    highp vec2 tmpvar_95;
    tmpvar_95.x = fetchesOffsetsU_44.w;
    tmpvar_95.y = fetchesOffsetsV_43.y;
    highp vec3 tmpvar_96;
    tmpvar_96.xy = (tmpvar_73 + tmpvar_95);
    tmpvar_96.z = shadowCoord_41.z;
    lowp float tmpvar_97;
    tmpvar_97 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_96);
    shadow_45 = (shadow_45 + ((tmpvar_67.w * tmpvar_70.y) * tmpvar_97));
    highp vec2 tmpvar_98;
    tmpvar_98.x = fetchesOffsetsU_44.x;
    tmpvar_98.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_99;
    tmpvar_99.xy = (tmpvar_73 + tmpvar_98);
    tmpvar_99.z = shadowCoord_41.z;
    lowp float tmpvar_100;
    tmpvar_100 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_99);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.z) * tmpvar_100));
    highp vec2 tmpvar_101;
    tmpvar_101.x = fetchesOffsetsU_44.y;
    tmpvar_101.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_102;
    tmpvar_102.xy = (tmpvar_73 + tmpvar_101);
    tmpvar_102.z = shadowCoord_41.z;
    lowp float tmpvar_103;
    tmpvar_103 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_102);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.z) * tmpvar_103));
    highp vec2 tmpvar_104;
    tmpvar_104.x = fetchesOffsetsU_44.z;
    tmpvar_104.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_105;
    tmpvar_105.xy = (tmpvar_73 + tmpvar_104);
    tmpvar_105.z = shadowCoord_41.z;
    lowp float tmpvar_106;
    tmpvar_106 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_105);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.z) * tmpvar_106));
    highp vec2 tmpvar_107;
    tmpvar_107.x = fetchesOffsetsU_44.w;
    tmpvar_107.y = fetchesOffsetsV_43.z;
    highp vec3 tmpvar_108;
    tmpvar_108.xy = (tmpvar_73 + tmpvar_107);
    tmpvar_108.z = shadowCoord_41.z;
    lowp float tmpvar_109;
    tmpvar_109 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_108);
    shadow_45 = (shadow_45 + ((tmpvar_67.w * tmpvar_70.z) * tmpvar_109));
    highp vec2 tmpvar_110;
    tmpvar_110.x = fetchesOffsetsU_44.x;
    tmpvar_110.y = fetchesOffsetsV_43.w;
    highp vec3 tmpvar_111;
    tmpvar_111.xy = (tmpvar_73 + tmpvar_110);
    tmpvar_111.z = shadowCoord_41.z;
    lowp float tmpvar_112;
    tmpvar_112 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_111);
    shadow_45 = (shadow_45 + ((tmpvar_67.x * tmpvar_70.w) * tmpvar_112));
    highp vec2 tmpvar_113;
    tmpvar_113.x = fetchesOffsetsU_44.y;
    tmpvar_113.y = fetchesOffsetsV_43.w;
    highp vec3 tmpvar_114;
    tmpvar_114.xy = (tmpvar_73 + tmpvar_113);
    tmpvar_114.z = shadowCoord_41.z;
    lowp float tmpvar_115;
    tmpvar_115 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_114);
    shadow_45 = (shadow_45 + ((tmpvar_67.y * tmpvar_70.w) * tmpvar_115));
    highp vec2 tmpvar_116;
    tmpvar_116.x = fetchesOffsetsU_44.z;
    tmpvar_116.y = fetchesOffsetsV_43.w;
    highp vec3 tmpvar_117;
    tmpvar_117.xy = (tmpvar_73 + tmpvar_116);
    tmpvar_117.z = shadowCoord_41.z;
    lowp float tmpvar_118;
    tmpvar_118 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_117);
    shadow_45 = (shadow_45 + ((tmpvar_67.z * tmpvar_70.w) * tmpvar_118));
    highp vec2 tmpvar_119;
    tmpvar_119.x = fetchesOffsetsU_44.w;
    tmpvar_119.y = fetchesOffsetsV_43.w;
    highp vec3 tmpvar_120;
    tmpvar_120.xy = (tmpvar_73 + tmpvar_119);
    tmpvar_120.z = shadowCoord_41.z;
    lowp float tmpvar_121;
    tmpvar_121 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_120);
    shadow_45 = (shadow_45 + ((tmpvar_67.w * tmpvar_70.w) * tmpvar_121));
    tmpvar_42 = mix (1.0, shadow_45, LIGHT_PARAM.y);
  };
  highp vec4 tmpvar_122;
  tmpvar_122.w = 1.0;
  tmpvar_122.xyz = ((mainColor_1 + vec3(totalSpecular_8)) * ((
    (LIGHT1COLOR.xyz * Light1Intensity)
   * tmpvar_42) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_122;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "diffuseMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specularMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "heightMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed1",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed2",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "movespeed3",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "eyeheight",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "specoffset3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "initoffset",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "intensity",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT1COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Light1Intensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_7;
  tmpvar_7[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_7[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_7[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_7 * _glesNormal));
  highp mat3 tmpvar_8;
  tmpvar_8[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_8[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_8[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  tmpvar_3.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_10))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  tmpvar_3.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_11)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = _glesMultiTexCoord1.xy;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (LOCALWORLD_TRANSFORM * tmpvar_6).xyz;
  xlv_TEXCOORD4 = normalize((tmpvar_8 * vec3(1.0, 0.0, 0.0)));
  xlv_TEXCOORD5 = normalize((tmpvar_9 * vec3(0.0, 1.0, 0.0)));
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD6 = tmpvar_3;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;
uniform sampler2D heightMap;
uniform highp float movespeed1;
uniform highp float movespeed2;
uniform highp float movespeed3;
uniform highp float eyeheight;
uniform highp vec3 specoffset1;
uniform highp vec3 specoffset2;
uniform highp vec3 specoffset3;
uniform highp vec3 initoffset;
uniform highp vec3 intensity;
uniform highp vec4 LIGHT1COLOR;
uniform highp float Light1Intensity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 mainColor_1;
  highp vec2 hcoord3_2;
  highp float height2_3;
  highp vec2 hcoord2_4;
  highp float height1_5;
  highp vec2 hcoord1_6;
  highp float height0_7;
  highp float totalSpecular_8;
  highp float specular2_9;
  highp vec2 coord2_10;
  highp float specular1_11;
  highp vec2 coord1_12;
  highp float specular0_13;
  highp vec2 coord0_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD3));
  highp float tmpvar_16;
  tmpvar_16 = dot (tmpvar_15, xlv_TEXCOORD4);
  highp float tmpvar_17;
  tmpvar_17 = dot (tmpvar_15, xlv_TEXCOORD5);
  highp vec2 tmpvar_18;
  tmpvar_18.x = ((-(tmpvar_16) * tmpvar_16) * tmpvar_16);
  tmpvar_18.y = -(tmpvar_16);
  coord0_14 = (tmpvar_18 * movespeed1);
  coord0_14 = (coord0_14 * specoffset1.xy);
  highp vec2 tmpvar_19;
  tmpvar_19.x = xlv_TEXCOORD1.x;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - xlv_TEXCOORD1.y);
  tmpvar_19.y = tmpvar_20;
  coord0_14 = ((coord0_14 + initoffset.xy) + tmpvar_19);
  coord0_14.y = (1.0 - coord0_14.y);
  lowp float tmpvar_21;
  tmpvar_21 = texture2D (specularMap, coord0_14).x;
  specular0_13 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22.x = tmpvar_16;
  tmpvar_22.y = -(tmpvar_17);
  coord1_12 = (tmpvar_22 * movespeed2);
  coord1_12 = (coord1_12 * specoffset2.xy);
  highp vec2 tmpvar_23;
  tmpvar_23.x = xlv_TEXCOORD1.x;
  tmpvar_23.y = tmpvar_20;
  coord1_12 = ((coord1_12 + initoffset.xy) + tmpvar_23);
  coord1_12.y = (1.0 - coord1_12.y);
  lowp float tmpvar_24;
  tmpvar_24 = texture2D (specularMap, coord1_12).y;
  specular1_11 = tmpvar_24;
  coord2_10 = (abs(vec2(tmpvar_16)) * movespeed3);
  coord2_10 = (coord2_10 * specoffset3.xy);
  highp vec2 tmpvar_25;
  tmpvar_25.x = xlv_TEXCOORD1.x;
  tmpvar_25.y = tmpvar_20;
  coord2_10 = ((coord2_10 + initoffset.xy) + tmpvar_25);
  coord2_10.y = (1.0 - coord2_10.y);
  lowp float tmpvar_26;
  tmpvar_26 = texture2D (specularMap, coord2_10).z;
  specular2_9 = tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_27.x = specular0_13;
  tmpvar_27.y = specular1_11;
  tmpvar_27.z = specular2_9;
  totalSpecular_8 = dot (tmpvar_27, intensity);
  highp vec2 tmpvar_28;
  tmpvar_28.x = tmpvar_16;
  tmpvar_28.y = -(tmpvar_17);
  highp vec2 tmpvar_29;
  tmpvar_29 = ((tmpvar_28 * eyeheight) * 0.5);
  lowp float tmpvar_30;
  tmpvar_30 = texture2D (heightMap, xlv_TEXCOORD0).x;
  height0_7 = tmpvar_30;
  highp vec2 tmpvar_31;
  tmpvar_31.x = xlv_TEXCOORD0.x;
  highp float tmpvar_32;
  tmpvar_32 = (1.0 - xlv_TEXCOORD0.y);
  tmpvar_31.y = tmpvar_32;
  highp vec2 tmpvar_33;
  tmpvar_33 = ((vec2(height0_7) * tmpvar_29) + tmpvar_31);
  hcoord1_6.x = tmpvar_33.x;
  hcoord1_6.y = (1.0 - tmpvar_33.y);
  lowp float tmpvar_34;
  tmpvar_34 = texture2D (heightMap, hcoord1_6).x;
  height1_5 = tmpvar_34;
  highp vec2 tmpvar_35;
  tmpvar_35.x = xlv_TEXCOORD0.x;
  tmpvar_35.y = tmpvar_32;
  highp vec2 tmpvar_36;
  tmpvar_36 = ((vec2(height1_5) * tmpvar_29) + tmpvar_35);
  hcoord2_4.x = tmpvar_36.x;
  hcoord2_4.y = (1.0 - tmpvar_36.y);
  lowp float tmpvar_37;
  tmpvar_37 = texture2D (heightMap, hcoord2_4).x;
  height2_3 = tmpvar_37;
  highp vec2 tmpvar_38;
  tmpvar_38.x = xlv_TEXCOORD0.x;
  tmpvar_38.y = tmpvar_32;
  highp vec2 tmpvar_39;
  tmpvar_39 = ((vec2(height2_3) * tmpvar_29) + tmpvar_38);
  hcoord3_2.x = tmpvar_39.x;
  hcoord3_2.y = (1.0 - tmpvar_39.y);
  lowp vec3 tmpvar_40;
  tmpvar_40 = texture2D (diffuseMap, hcoord3_2).xyz;
  mainColor_1 = tmpvar_40;
  mainColor_1 = (mainColor_1 * mainColor_1);
  highp vec4 shadowCoord_41;
  shadowCoord_41 = xlv_TEXCOORD6;
  highp float tmpvar_42;
  if ((xlv_TEXCOORD6.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_42 = 1.0;
  } else {
    highp vec2 tmpvar_43;
    tmpvar_43.x = LIGHT_PARAM.z;
    tmpvar_43.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = tmpvar_43;
    highp float tmpvar_45;
    tmpvar_45 = (1.0/(LIGHT_PARAM.z));
    tmpvar_44.z = tmpvar_45;
    tmpvar_44.w = tmpvar_45;
    shadowCoord_41.y = (1.0 - xlv_TEXCOORD6.y);
    highp float shadow_46;
    highp vec2 tmpvar_47;
    tmpvar_47 = tmpvar_44.xy;
    shadow_46 = 0.0;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (shadowCoord_41.xy - LIGHT_PARAM.zz);
    tmpvar_48.z = shadowCoord_41.z;
    highp vec4 tmpvar_49;
    tmpvar_49 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_48.xy);
    highp float tmpvar_50;
    if ((tmpvar_49.x < xlv_TEXCOORD6.z)) {
      tmpvar_50 = 0.0;
    } else {
      tmpvar_50 = 1.0;
    };
    shadow_46 = tmpvar_50;
    highp vec2 tmpvar_51;
    tmpvar_51.x = 0.0;
    tmpvar_51.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_41.xy + tmpvar_51);
    tmpvar_52.z = shadowCoord_41.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD6.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_46 = (tmpvar_50 + tmpvar_54);
    highp vec2 tmpvar_55;
    tmpvar_55.x = tmpvar_47.x;
    tmpvar_55.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (shadowCoord_41.xy + tmpvar_55);
    tmpvar_56.z = shadowCoord_41.z;
    highp vec4 tmpvar_57;
    tmpvar_57 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_56.xy);
    highp float tmpvar_58;
    if ((tmpvar_57.x < xlv_TEXCOORD6.z)) {
      tmpvar_58 = 0.0;
    } else {
      tmpvar_58 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_58);
    highp vec2 tmpvar_59;
    tmpvar_59.y = 0.0;
    tmpvar_59.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (shadowCoord_41.xy + tmpvar_59);
    tmpvar_60.z = shadowCoord_41.z;
    highp vec4 tmpvar_61;
    tmpvar_61 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_60.xy);
    highp float tmpvar_62;
    if ((tmpvar_61.x < xlv_TEXCOORD6.z)) {
      tmpvar_62 = 0.0;
    } else {
      tmpvar_62 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_62);
    highp vec4 tmpvar_63;
    tmpvar_63 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_41.xy);
    highp float tmpvar_64;
    if ((tmpvar_63.x < xlv_TEXCOORD6.z)) {
      tmpvar_64 = 0.0;
    } else {
      tmpvar_64 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_64);
    highp vec2 tmpvar_65;
    tmpvar_65.y = 0.0;
    tmpvar_65.x = tmpvar_47.x;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (shadowCoord_41.xy + tmpvar_65);
    tmpvar_66.z = shadowCoord_41.z;
    highp vec4 tmpvar_67;
    tmpvar_67 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_66.xy);
    highp float tmpvar_68;
    if ((tmpvar_67.x < xlv_TEXCOORD6.z)) {
      tmpvar_68 = 0.0;
    } else {
      tmpvar_68 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_68);
    highp vec2 tmpvar_69;
    tmpvar_69.x = -(LIGHT_PARAM.z);
    tmpvar_69.y = tmpvar_47.y;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (shadowCoord_41.xy + tmpvar_69);
    tmpvar_70.z = shadowCoord_41.z;
    highp vec4 tmpvar_71;
    tmpvar_71 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_70.xy);
    highp float tmpvar_72;
    if ((tmpvar_71.x < xlv_TEXCOORD6.z)) {
      tmpvar_72 = 0.0;
    } else {
      tmpvar_72 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_72);
    highp vec2 tmpvar_73;
    tmpvar_73.x = 0.0;
    tmpvar_73.y = tmpvar_47.y;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (shadowCoord_41.xy + tmpvar_73);
    tmpvar_74.z = shadowCoord_41.z;
    highp vec4 tmpvar_75;
    tmpvar_75 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_74.xy);
    highp float tmpvar_76;
    if ((tmpvar_75.x < xlv_TEXCOORD6.z)) {
      tmpvar_76 = 0.0;
    } else {
      tmpvar_76 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_76);
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (shadowCoord_41.xy + LIGHT_PARAM.zz);
    tmpvar_77.z = shadowCoord_41.z;
    highp vec4 tmpvar_78;
    tmpvar_78 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_77.xy);
    highp float tmpvar_79;
    if ((tmpvar_78.x < xlv_TEXCOORD6.z)) {
      tmpvar_79 = 0.0;
    } else {
      tmpvar_79 = 1.0;
    };
    shadow_46 = (shadow_46 + tmpvar_79);
    shadow_46 = (shadow_46 / 9.0);
    tmpvar_42 = mix (1.0, shadow_46, LIGHT_PARAM.y);
  };
  highp vec4 tmpvar_80;
  tmpvar_80.w = 1.0;
  tmpvar_80.xyz = ((mainColor_1 + vec3(totalSpecular_8)) * ((
    (LIGHT1COLOR.xyz * Light1Intensity)
   * tmpvar_42) + AMBIENT_COLOR));
  gl_FragData[0] = tmpvar_80;
}

]===],
	},
}

end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[attribute vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[0].x = row0_3.x;
  tmpvar_8[0].y = row0_3.y;
  tmpvar_8[0].z = row0_3.z;
  tmpvar_8[0].w = row0_3.w;
  tmpvar_8[1].x = row1_2.x;
  tmpvar_8[1].y = row1_2.y;
  tmpvar_8[1].z = row1_2.z;
  tmpvar_8[1].w = row1_2.w;
  tmpvar_8[2].x = row2_1.x;
  tmpvar_8[2].y = row2_1.y;
  tmpvar_8[2].z = row2_1.z;
  tmpvar_8[2].w = row2_1.w;
  tmpvar_8[3].x = 0.0;
  tmpvar_8[3].y = 0.0;
  tmpvar_8[3].z = 0.0;
  tmpvar_8[3].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)));
  highp vec4 clipPos_10;
  clipPos_10.xyw = tmpvar_9.xyw;
  clipPos_10.z = (tmpvar_9.z + (LIGHT_PARAM.x / tmpvar_9.w));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_11 * clipPos_10);
}

]===],
		psShader = [===[void main ()
{
  gl_FragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[attribute vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[void main ()
{
  gl_FragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end