function DefineParams()
	Properties = 
	{
		
DiffuseTex= { "Texture Diffuse", TEXTURE2D, "white" },
TexNormal = {"Texture Normal", TEXTURE2D, "white"},
TexSpecular = {"Texture Specular", TEXTURE2D, "white"},
TexBRDF = {"Texture BRDF", TEXTURE2D, "white"},
TexSkybox = {"Texture SkyBox", TEXTURECUBE, "black"},

ColorShade = {"Shade Color", COLOR, "0.0,0.0,0.0,1.0"},
ColorShadow = {"Shadow Color", COLOR, "0.0,0.0,0.0,1.0"},
ColorSpecular = {"Specular Color", COLOR, "0.0,0.0,0.0,1.0"},

SkinTint = {"Skin Tint", COLOR, "0.0,0.0,0.0,1.0"},
SkinTintMaskTex = {"Skin Mask", TEXTURE2D, "white"},

SkinColor = {"Skin Color", COLOR, "0.933, 0.859, 0.804, 1.0"},


RegionRTint = {"Region Tint R", COLOR, "0.0,0.0,0.0,1.0"},
RegionGTint = {"Region Tint G", COLOR, "0.0,0.0,0.0,1.0"},
RegionBTint = {"Region Tint B", COLOR, "0.0,0.0,0.0,1.0"},
RegionTintMaskTex = { "Region Mask", TEXTURE2D, "white" },
RegionTintBlend = {"Region Blend Strength", VEC3, "1.0,1.0,1.0"},

Fresnel = { "Fresnel", FLOAT, "0.5" },
extraShadeRange = { "extraShadeRange", FLOAT, "0.5" },

LightDir = { "Light Dir", VEC3, "0.0,0.0,1.0" },
LightColor = { "Lighit Color", COLOR, "1.0,1.0,1.0, 1.0" },
LightIntensity = {"Light Intensity", FLOAT, "1.0" },


	}
	Attributes = 
	{
	}
	
end

  

function Init()
	PassNames = 
	{
		"ForwardBase","Depth"
	}

ShaderName = "CustomSkin_Mask"
RenderQueue = "Opaque"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((
    (tmpvar_15.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_15.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_15.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_18;
  tmpvar_18 = normalize(LightDir);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_16, tmpvar_13), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_16, normalize(
    (tmpvar_13 + tmpvar_17)
  )), 0.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_21;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_22;
  tmpvar_22 = color_10.w;
  highp float tmpvar_23;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_23 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_23 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_24;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_24 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_24 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_25;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_25 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_25 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_23 * 0.4124564)
   + 
    (tmpvar_24 * 0.3575761)
  ) + (tmpvar_25 * 0.1804375)) / 0.950456);
  highp float tmpvar_27;
  tmpvar_27 = (((tmpvar_23 * 0.2126729) + (tmpvar_24 * 0.7151522)) + (tmpvar_25 * 0.072175));
  highp float tmpvar_28;
  tmpvar_28 = (((
    (tmpvar_23 * 0.0193339)
   + 
    (tmpvar_24 * 0.119192)
  ) + (tmpvar_25 * 0.9503041)) / 1.088754);
  highp float tmpvar_29;
  if ((tmpvar_26 > 0.008856)) {
    tmpvar_29 = pow (tmpvar_26, 0.3333333);
  } else {
    tmpvar_29 = (((903.3 * tmpvar_26) + 16.0) / 116.0);
  };
  highp float tmpvar_30;
  if ((tmpvar_27 > 0.008856)) {
    tmpvar_30 = pow (tmpvar_27, 0.3333333);
  } else {
    tmpvar_30 = (((903.3 * tmpvar_27) + 16.0) / 116.0);
  };
  highp float tmpvar_31;
  if ((tmpvar_28 > 0.008856)) {
    tmpvar_31 = pow (tmpvar_28, 0.3333333);
  } else {
    tmpvar_31 = (((903.3 * tmpvar_28) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_32;
  tmpvar_32.x = (((116.0 * tmpvar_30) - 16.0) / 100.0);
  tmpvar_32.y = (((500.0 * 
    (tmpvar_29 - tmpvar_30)
  ) + 110.0) / 220.0);
  tmpvar_32.z = (((200.0 * 
    (tmpvar_30 - tmpvar_31)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_33;
  tmpvar_33 = (tmpvar_32 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_34;
  if ((color_10.x > 0.04045)) {
    tmpvar_34 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_34 = (color_10.x / 12.92);
  };
  highp float tmpvar_35;
  if ((color_10.y > 0.04045)) {
    tmpvar_35 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_35 = (color_10.y / 12.92);
  };
  highp float tmpvar_36;
  if ((color_10.z > 0.04045)) {
    tmpvar_36 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_36 = (color_10.z / 12.92);
  };
  highp float tmpvar_37;
  tmpvar_37 = (((
    (tmpvar_34 * 0.4124564)
   + 
    (tmpvar_35 * 0.3575761)
  ) + (tmpvar_36 * 0.1804375)) / 0.950456);
  highp float tmpvar_38;
  tmpvar_38 = (((tmpvar_34 * 0.2126729) + (tmpvar_35 * 0.7151522)) + (tmpvar_36 * 0.072175));
  highp float tmpvar_39;
  tmpvar_39 = (((
    (tmpvar_34 * 0.0193339)
   + 
    (tmpvar_35 * 0.119192)
  ) + (tmpvar_36 * 0.9503041)) / 1.088754);
  highp float tmpvar_40;
  if ((tmpvar_37 > 0.008856)) {
    tmpvar_40 = pow (tmpvar_37, 0.3333333);
  } else {
    tmpvar_40 = (((903.3 * tmpvar_37) + 16.0) / 116.0);
  };
  highp float tmpvar_41;
  if ((tmpvar_38 > 0.008856)) {
    tmpvar_41 = pow (tmpvar_38, 0.3333333);
  } else {
    tmpvar_41 = (((903.3 * tmpvar_38) + 16.0) / 116.0);
  };
  highp float tmpvar_42;
  if ((tmpvar_39 > 0.008856)) {
    tmpvar_42 = pow (tmpvar_39, 0.3333333);
  } else {
    tmpvar_42 = (((903.3 * tmpvar_39) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_43;
  tmpvar_43.x = (((116.0 * tmpvar_41) - 16.0) / 100.0);
  tmpvar_43.y = (((500.0 * 
    (tmpvar_40 - tmpvar_41)
  ) + 110.0) / 220.0);
  tmpvar_43.z = (((200.0 * 
    (tmpvar_41 - tmpvar_42)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_44;
  tmpvar_44 = clamp ((tmpvar_43 + tmpvar_33), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_45;
  highp float x_46;
  highp float tmpvar_47;
  tmpvar_47 = (((tmpvar_44.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_48;
  tmpvar_48 = (((
    (tmpvar_44.y * 220.0)
   - 110.0) / 500.0) + tmpvar_47);
  x_46 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = (tmpvar_47 - ((
    (tmpvar_44.z * 220.0)
   - 110.0) / 200.0));
  z_45 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = pow (tmpvar_48, 3.0);
  highp float tmpvar_51;
  tmpvar_51 = pow (tmpvar_47, 3.0);
  highp float tmpvar_52;
  tmpvar_52 = pow (tmpvar_49, 3.0);
  highp float tmpvar_53;
  if ((tmpvar_50 > 0.008856)) {
    tmpvar_53 = tmpvar_50;
  } else {
    tmpvar_53 = ((tmpvar_48 - 0.137931) / 7.787069);
  };
  x_46 = (tmpvar_53 * 0.950456);
  highp float tmpvar_54;
  if ((tmpvar_51 > 0.008856)) {
    tmpvar_54 = tmpvar_51;
  } else {
    tmpvar_54 = ((tmpvar_47 - 0.137931) / 7.787069);
  };
  highp float tmpvar_55;
  if ((tmpvar_52 > 0.008856)) {
    tmpvar_55 = tmpvar_52;
  } else {
    tmpvar_55 = ((tmpvar_49 - 0.137931) / 7.787069);
  };
  z_45 = (tmpvar_55 * 1.088754);
  highp float tmpvar_56;
  tmpvar_56 = (((x_46 * 3.240454) + (tmpvar_54 * -1.537138)) + (z_45 * -0.4985314));
  highp float tmpvar_57;
  tmpvar_57 = (((x_46 * -0.969266) + (tmpvar_54 * 1.876011)) + (z_45 * 0.041556));
  highp float tmpvar_58;
  tmpvar_58 = (((x_46 * 0.0556434) + (tmpvar_54 * -0.2040259)) + (z_45 * 1.057225));
  highp float tmpvar_59;
  if ((tmpvar_56 > 0.0031308)) {
    tmpvar_59 = ((1.055 * pow (tmpvar_56, 0.4166667)) - 0.055);
  } else {
    tmpvar_59 = (12.92 * tmpvar_56);
  };
  highp float tmpvar_60;
  if ((tmpvar_57 > 0.0031308)) {
    tmpvar_60 = ((1.055 * pow (tmpvar_57, 0.4166667)) - 0.055);
  } else {
    tmpvar_60 = (12.92 * tmpvar_57);
  };
  highp float tmpvar_61;
  if ((tmpvar_58 > 0.0031308)) {
    tmpvar_61 = ((1.055 * pow (tmpvar_58, 0.4166667)) - 0.055);
  } else {
    tmpvar_61 = (12.92 * tmpvar_58);
  };
  highp vec3 tmpvar_62;
  tmpvar_62.x = tmpvar_59;
  tmpvar_62.y = tmpvar_60;
  tmpvar_62.z = tmpvar_61;
  lowp vec3 tmpvar_63;
  tmpvar_63 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix (color_10.xyz, tmpvar_62, tmpvar_63);
  mainColor_9 = (tmpvar_64 * tmpvar_64);
  lowp vec3 tmpvar_65;
  tmpvar_65 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_65;
  highp vec4 tmpvar_66;
  tmpvar_66.w = 0.0;
  tmpvar_66.xyz = mainColor_9;
  highp vec4 tmpvar_67;
  tmpvar_67.w = 0.0;
  tmpvar_67.xyz = mainColor_9;
  highp vec4 tmpvar_68;
  tmpvar_68.w = 0.0;
  tmpvar_68.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_66, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_67, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_68, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_69;
  tmpvar_69 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = (1.0 - specular_7.x);
  highp vec2 tmpvar_71;
  tmpvar_71.x = (((
    dot (tmpvar_16, tmpvar_17)
   * 0.5) + 0.5) * 0.99);
  tmpvar_71.y = specular_7.y;
  lowp vec3 tmpvar_72;
  tmpvar_72 = texture (TexBRDF, tmpvar_71).xyz;
  brdfColor_6 = tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = max (((
    dot (tmpvar_16, tmpvar_18)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_73 * tmpvar_73);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_74;
  I_74 = -(tmpvar_13);
  reflectDir_3.xyz = (I_74 - (2.0 * (
    dot (tmpvar_16, I_74)
   * tmpvar_16)));
  reflectDir_3.w = (tmpvar_70 * 4.0);
  lowp vec4 tmpvar_75;
  tmpvar_75 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_76;
  tmpvar_76 = tmpvar_75;
  iblColor_2.w = tmpvar_76.w;
  iblColor_2.xyz = ((tmpvar_76.xyz * tmpvar_76.w) * 4.0);
  highp float tmpvar_77;
  tmpvar_77 = max ((tmpvar_70 * tmpvar_70), 0.1);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_20 * tmpvar_78)
   - tmpvar_20) * tmpvar_20) + 1.0);
  d_1 = ((0.3183099 * tmpvar_78) / ((tmpvar_79 * tmpvar_79) + 1e-7));
  highp float tmpvar_80;
  tmpvar_80 = min (d_1, 100.0);
  d_1 = tmpvar_80;
  highp vec4 tmpvar_81;
  tmpvar_81.xyz = (((
    ((tmpvar_80 * mix (1.5, 1.0, (1.0 - tmpvar_19))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_19), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((brdfColor_6 * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_19, (1.0 - specular_7.z))
  ))));
  tmpvar_81.w = tmpvar_22;
  _glesFragData[0] = tmpvar_81;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((
    (tmpvar_15.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_15.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_15.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_18;
  tmpvar_18 = normalize(LightDir);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_16, tmpvar_13), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_16, normalize(
    (tmpvar_13 + tmpvar_17)
  )), 0.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_21;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_22;
  tmpvar_22 = color_10.w;
  highp float tmpvar_23;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_23 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_23 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_24;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_24 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_24 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_25;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_25 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_25 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_23 * 0.4124564)
   + 
    (tmpvar_24 * 0.3575761)
  ) + (tmpvar_25 * 0.1804375)) / 0.950456);
  highp float tmpvar_27;
  tmpvar_27 = (((tmpvar_23 * 0.2126729) + (tmpvar_24 * 0.7151522)) + (tmpvar_25 * 0.072175));
  highp float tmpvar_28;
  tmpvar_28 = (((
    (tmpvar_23 * 0.0193339)
   + 
    (tmpvar_24 * 0.119192)
  ) + (tmpvar_25 * 0.9503041)) / 1.088754);
  highp float tmpvar_29;
  if ((tmpvar_26 > 0.008856)) {
    tmpvar_29 = pow (tmpvar_26, 0.3333333);
  } else {
    tmpvar_29 = (((903.3 * tmpvar_26) + 16.0) / 116.0);
  };
  highp float tmpvar_30;
  if ((tmpvar_27 > 0.008856)) {
    tmpvar_30 = pow (tmpvar_27, 0.3333333);
  } else {
    tmpvar_30 = (((903.3 * tmpvar_27) + 16.0) / 116.0);
  };
  highp float tmpvar_31;
  if ((tmpvar_28 > 0.008856)) {
    tmpvar_31 = pow (tmpvar_28, 0.3333333);
  } else {
    tmpvar_31 = (((903.3 * tmpvar_28) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_32;
  tmpvar_32.x = (((116.0 * tmpvar_30) - 16.0) / 100.0);
  tmpvar_32.y = (((500.0 * 
    (tmpvar_29 - tmpvar_30)
  ) + 110.0) / 220.0);
  tmpvar_32.z = (((200.0 * 
    (tmpvar_30 - tmpvar_31)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_33;
  tmpvar_33 = (tmpvar_32 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_34;
  if ((color_10.x > 0.04045)) {
    tmpvar_34 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_34 = (color_10.x / 12.92);
  };
  highp float tmpvar_35;
  if ((color_10.y > 0.04045)) {
    tmpvar_35 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_35 = (color_10.y / 12.92);
  };
  highp float tmpvar_36;
  if ((color_10.z > 0.04045)) {
    tmpvar_36 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_36 = (color_10.z / 12.92);
  };
  highp float tmpvar_37;
  tmpvar_37 = (((
    (tmpvar_34 * 0.4124564)
   + 
    (tmpvar_35 * 0.3575761)
  ) + (tmpvar_36 * 0.1804375)) / 0.950456);
  highp float tmpvar_38;
  tmpvar_38 = (((tmpvar_34 * 0.2126729) + (tmpvar_35 * 0.7151522)) + (tmpvar_36 * 0.072175));
  highp float tmpvar_39;
  tmpvar_39 = (((
    (tmpvar_34 * 0.0193339)
   + 
    (tmpvar_35 * 0.119192)
  ) + (tmpvar_36 * 0.9503041)) / 1.088754);
  highp float tmpvar_40;
  if ((tmpvar_37 > 0.008856)) {
    tmpvar_40 = pow (tmpvar_37, 0.3333333);
  } else {
    tmpvar_40 = (((903.3 * tmpvar_37) + 16.0) / 116.0);
  };
  highp float tmpvar_41;
  if ((tmpvar_38 > 0.008856)) {
    tmpvar_41 = pow (tmpvar_38, 0.3333333);
  } else {
    tmpvar_41 = (((903.3 * tmpvar_38) + 16.0) / 116.0);
  };
  highp float tmpvar_42;
  if ((tmpvar_39 > 0.008856)) {
    tmpvar_42 = pow (tmpvar_39, 0.3333333);
  } else {
    tmpvar_42 = (((903.3 * tmpvar_39) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_43;
  tmpvar_43.x = (((116.0 * tmpvar_41) - 16.0) / 100.0);
  tmpvar_43.y = (((500.0 * 
    (tmpvar_40 - tmpvar_41)
  ) + 110.0) / 220.0);
  tmpvar_43.z = (((200.0 * 
    (tmpvar_41 - tmpvar_42)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_44;
  tmpvar_44 = clamp ((tmpvar_43 + tmpvar_33), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_45;
  highp float x_46;
  highp float tmpvar_47;
  tmpvar_47 = (((tmpvar_44.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_48;
  tmpvar_48 = (((
    (tmpvar_44.y * 220.0)
   - 110.0) / 500.0) + tmpvar_47);
  x_46 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = (tmpvar_47 - ((
    (tmpvar_44.z * 220.0)
   - 110.0) / 200.0));
  z_45 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = pow (tmpvar_48, 3.0);
  highp float tmpvar_51;
  tmpvar_51 = pow (tmpvar_47, 3.0);
  highp float tmpvar_52;
  tmpvar_52 = pow (tmpvar_49, 3.0);
  highp float tmpvar_53;
  if ((tmpvar_50 > 0.008856)) {
    tmpvar_53 = tmpvar_50;
  } else {
    tmpvar_53 = ((tmpvar_48 - 0.137931) / 7.787069);
  };
  x_46 = (tmpvar_53 * 0.950456);
  highp float tmpvar_54;
  if ((tmpvar_51 > 0.008856)) {
    tmpvar_54 = tmpvar_51;
  } else {
    tmpvar_54 = ((tmpvar_47 - 0.137931) / 7.787069);
  };
  highp float tmpvar_55;
  if ((tmpvar_52 > 0.008856)) {
    tmpvar_55 = tmpvar_52;
  } else {
    tmpvar_55 = ((tmpvar_49 - 0.137931) / 7.787069);
  };
  z_45 = (tmpvar_55 * 1.088754);
  highp float tmpvar_56;
  tmpvar_56 = (((x_46 * 3.240454) + (tmpvar_54 * -1.537138)) + (z_45 * -0.4985314));
  highp float tmpvar_57;
  tmpvar_57 = (((x_46 * -0.969266) + (tmpvar_54 * 1.876011)) + (z_45 * 0.041556));
  highp float tmpvar_58;
  tmpvar_58 = (((x_46 * 0.0556434) + (tmpvar_54 * -0.2040259)) + (z_45 * 1.057225));
  highp float tmpvar_59;
  if ((tmpvar_56 > 0.0031308)) {
    tmpvar_59 = ((1.055 * pow (tmpvar_56, 0.4166667)) - 0.055);
  } else {
    tmpvar_59 = (12.92 * tmpvar_56);
  };
  highp float tmpvar_60;
  if ((tmpvar_57 > 0.0031308)) {
    tmpvar_60 = ((1.055 * pow (tmpvar_57, 0.4166667)) - 0.055);
  } else {
    tmpvar_60 = (12.92 * tmpvar_57);
  };
  highp float tmpvar_61;
  if ((tmpvar_58 > 0.0031308)) {
    tmpvar_61 = ((1.055 * pow (tmpvar_58, 0.4166667)) - 0.055);
  } else {
    tmpvar_61 = (12.92 * tmpvar_58);
  };
  highp vec3 tmpvar_62;
  tmpvar_62.x = tmpvar_59;
  tmpvar_62.y = tmpvar_60;
  tmpvar_62.z = tmpvar_61;
  lowp vec3 tmpvar_63;
  tmpvar_63 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix (color_10.xyz, tmpvar_62, tmpvar_63);
  mainColor_9 = (tmpvar_64 * tmpvar_64);
  lowp vec3 tmpvar_65;
  tmpvar_65 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_65;
  highp vec4 tmpvar_66;
  tmpvar_66.w = 0.0;
  tmpvar_66.xyz = mainColor_9;
  highp vec4 tmpvar_67;
  tmpvar_67.w = 0.0;
  tmpvar_67.xyz = mainColor_9;
  highp vec4 tmpvar_68;
  tmpvar_68.w = 0.0;
  tmpvar_68.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_66, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_67, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_68, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_69;
  tmpvar_69 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = (1.0 - specular_7.x);
  highp vec2 tmpvar_71;
  tmpvar_71.x = (((
    dot (tmpvar_16, tmpvar_17)
   * 0.5) + 0.5) * 0.99);
  tmpvar_71.y = specular_7.y;
  lowp vec3 tmpvar_72;
  tmpvar_72 = texture (TexBRDF, tmpvar_71).xyz;
  brdfColor_6 = tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = max (((
    dot (tmpvar_16, tmpvar_18)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_73 * tmpvar_73);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_74;
  I_74 = -(tmpvar_13);
  reflectDir_3.xyz = (I_74 - (2.0 * (
    dot (tmpvar_16, I_74)
   * tmpvar_16)));
  reflectDir_3.w = (tmpvar_70 * 4.0);
  lowp vec4 tmpvar_75;
  tmpvar_75 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_76;
  tmpvar_76 = tmpvar_75;
  iblColor_2.w = tmpvar_76.w;
  iblColor_2.xyz = ((tmpvar_76.xyz * tmpvar_76.w) * 4.0);
  highp float tmpvar_77;
  tmpvar_77 = max ((tmpvar_70 * tmpvar_70), 0.1);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_20 * tmpvar_78)
   - tmpvar_20) * tmpvar_20) + 1.0);
  d_1 = ((0.3183099 * tmpvar_78) / ((tmpvar_79 * tmpvar_79) + 1e-7));
  highp float tmpvar_80;
  tmpvar_80 = min (d_1, 100.0);
  d_1 = tmpvar_80;
  highp vec4 tmpvar_81;
  tmpvar_81.xyz = (((
    ((tmpvar_80 * mix (1.5, 1.0, (1.0 - tmpvar_19))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_19), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((brdfColor_6 * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_19, (1.0 - specular_7.z))
  ))));
  tmpvar_81.w = tmpvar_22;
  _glesFragData[0] = tmpvar_81;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2(2048.0, 2048.0));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec3 tmpvar_51;
  tmpvar_51 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(((
    (tmpvar_52.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_52.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_52.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(LightDir);
  highp float tmpvar_56;
  tmpvar_56 = max (dot (tmpvar_53, tmpvar_50), 0.0);
  highp float tmpvar_57;
  tmpvar_57 = max (dot (tmpvar_53, normalize(
    (tmpvar_50 + tmpvar_54)
  )), 0.0);
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_58;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_59;
  tmpvar_59 = color_10.w;
  highp float tmpvar_60;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_60 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_60 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_61;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_61 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_61 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_62;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_62 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_60 * 0.4124564)
   + 
    (tmpvar_61 * 0.3575761)
  ) + (tmpvar_62 * 0.1804375)) / 0.950456);
  highp float tmpvar_64;
  tmpvar_64 = (((tmpvar_60 * 0.2126729) + (tmpvar_61 * 0.7151522)) + (tmpvar_62 * 0.072175));
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_60 * 0.0193339)
   + 
    (tmpvar_61 * 0.119192)
  ) + (tmpvar_62 * 0.9503041)) / 1.088754);
  highp float tmpvar_66;
  if ((tmpvar_63 > 0.008856)) {
    tmpvar_66 = pow (tmpvar_63, 0.3333333);
  } else {
    tmpvar_66 = (((903.3 * tmpvar_63) + 16.0) / 116.0);
  };
  highp float tmpvar_67;
  if ((tmpvar_64 > 0.008856)) {
    tmpvar_67 = pow (tmpvar_64, 0.3333333);
  } else {
    tmpvar_67 = (((903.3 * tmpvar_64) + 16.0) / 116.0);
  };
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_69;
  tmpvar_69.x = (((116.0 * tmpvar_67) - 16.0) / 100.0);
  tmpvar_69.y = (((500.0 * 
    (tmpvar_66 - tmpvar_67)
  ) + 110.0) / 220.0);
  tmpvar_69.z = (((200.0 * 
    (tmpvar_67 - tmpvar_68)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_70;
  tmpvar_70 = (tmpvar_69 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_71;
  if ((color_10.x > 0.04045)) {
    tmpvar_71 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_71 = (color_10.x / 12.92);
  };
  highp float tmpvar_72;
  if ((color_10.y > 0.04045)) {
    tmpvar_72 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (color_10.y / 12.92);
  };
  highp float tmpvar_73;
  if ((color_10.z > 0.04045)) {
    tmpvar_73 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_73 = (color_10.z / 12.92);
  };
  highp float tmpvar_74;
  tmpvar_74 = (((
    (tmpvar_71 * 0.4124564)
   + 
    (tmpvar_72 * 0.3575761)
  ) + (tmpvar_73 * 0.1804375)) / 0.950456);
  highp float tmpvar_75;
  tmpvar_75 = (((tmpvar_71 * 0.2126729) + (tmpvar_72 * 0.7151522)) + (tmpvar_73 * 0.072175));
  highp float tmpvar_76;
  tmpvar_76 = (((
    (tmpvar_71 * 0.0193339)
   + 
    (tmpvar_72 * 0.119192)
  ) + (tmpvar_73 * 0.9503041)) / 1.088754);
  highp float tmpvar_77;
  if ((tmpvar_74 > 0.008856)) {
    tmpvar_77 = pow (tmpvar_74, 0.3333333);
  } else {
    tmpvar_77 = (((903.3 * tmpvar_74) + 16.0) / 116.0);
  };
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp float tmpvar_79;
  if ((tmpvar_76 > 0.008856)) {
    tmpvar_79 = pow (tmpvar_76, 0.3333333);
  } else {
    tmpvar_79 = (((903.3 * tmpvar_76) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_80;
  tmpvar_80.x = (((116.0 * tmpvar_78) - 16.0) / 100.0);
  tmpvar_80.y = (((500.0 * 
    (tmpvar_77 - tmpvar_78)
  ) + 110.0) / 220.0);
  tmpvar_80.z = (((200.0 * 
    (tmpvar_78 - tmpvar_79)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_81;
  tmpvar_81 = clamp ((tmpvar_80 + tmpvar_70), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_82;
  highp float x_83;
  highp float tmpvar_84;
  tmpvar_84 = (((tmpvar_81.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_81.y * 220.0)
   - 110.0) / 500.0) + tmpvar_84);
  x_83 = tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = (tmpvar_84 - ((
    (tmpvar_81.z * 220.0)
   - 110.0) / 200.0));
  z_82 = tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = pow (tmpvar_85, 3.0);
  highp float tmpvar_88;
  tmpvar_88 = pow (tmpvar_84, 3.0);
  highp float tmpvar_89;
  tmpvar_89 = pow (tmpvar_86, 3.0);
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = tmpvar_87;
  } else {
    tmpvar_90 = ((tmpvar_85 - 0.137931) / 7.787069);
  };
  x_83 = (tmpvar_90 * 0.950456);
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = tmpvar_88;
  } else {
    tmpvar_91 = ((tmpvar_84 - 0.137931) / 7.787069);
  };
  highp float tmpvar_92;
  if ((tmpvar_89 > 0.008856)) {
    tmpvar_92 = tmpvar_89;
  } else {
    tmpvar_92 = ((tmpvar_86 - 0.137931) / 7.787069);
  };
  z_82 = (tmpvar_92 * 1.088754);
  highp float tmpvar_93;
  tmpvar_93 = (((x_83 * 3.240454) + (tmpvar_91 * -1.537138)) + (z_82 * -0.4985314));
  highp float tmpvar_94;
  tmpvar_94 = (((x_83 * -0.969266) + (tmpvar_91 * 1.876011)) + (z_82 * 0.041556));
  highp float tmpvar_95;
  tmpvar_95 = (((x_83 * 0.0556434) + (tmpvar_91 * -0.2040259)) + (z_82 * 1.057225));
  highp float tmpvar_96;
  if ((tmpvar_93 > 0.0031308)) {
    tmpvar_96 = ((1.055 * pow (tmpvar_93, 0.4166667)) - 0.055);
  } else {
    tmpvar_96 = (12.92 * tmpvar_93);
  };
  highp float tmpvar_97;
  if ((tmpvar_94 > 0.0031308)) {
    tmpvar_97 = ((1.055 * pow (tmpvar_94, 0.4166667)) - 0.055);
  } else {
    tmpvar_97 = (12.92 * tmpvar_94);
  };
  highp float tmpvar_98;
  if ((tmpvar_95 > 0.0031308)) {
    tmpvar_98 = ((1.055 * pow (tmpvar_95, 0.4166667)) - 0.055);
  } else {
    tmpvar_98 = (12.92 * tmpvar_95);
  };
  highp vec3 tmpvar_99;
  tmpvar_99.x = tmpvar_96;
  tmpvar_99.y = tmpvar_97;
  tmpvar_99.z = tmpvar_98;
  lowp vec3 tmpvar_100;
  tmpvar_100 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_101;
  tmpvar_101 = mix (color_10.xyz, tmpvar_99, tmpvar_100);
  mainColor_9 = (tmpvar_101 * tmpvar_101);
  lowp vec3 tmpvar_102;
  tmpvar_102 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_102;
  highp vec4 tmpvar_103;
  tmpvar_103.w = 0.0;
  tmpvar_103.xyz = mainColor_9;
  highp vec4 tmpvar_104;
  tmpvar_104.w = 0.0;
  tmpvar_104.xyz = mainColor_9;
  highp vec4 tmpvar_105;
  tmpvar_105.w = 0.0;
  tmpvar_105.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_103, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_104, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_105, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_106;
  tmpvar_106 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_106;
  highp float tmpvar_107;
  tmpvar_107 = (1.0 - specular_7.x);
  highp vec2 tmpvar_108;
  tmpvar_108.x = (((
    dot (tmpvar_53, tmpvar_54)
   * 0.5) + 0.5) * 0.99);
  tmpvar_108.y = specular_7.y;
  lowp vec3 tmpvar_109;
  tmpvar_109 = texture (TexBRDF, tmpvar_108).xyz;
  brdfColor_6 = tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = max (((
    dot (tmpvar_53, tmpvar_55)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_110 * tmpvar_110);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_111;
  I_111 = -(tmpvar_50);
  reflectDir_3.xyz = (I_111 - (2.0 * (
    dot (tmpvar_53, I_111)
   * tmpvar_53)));
  reflectDir_3.w = (tmpvar_107 * 4.0);
  lowp vec4 tmpvar_112;
  tmpvar_112 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_113;
  tmpvar_113 = tmpvar_112;
  iblColor_2.w = tmpvar_113.w;
  iblColor_2.xyz = ((tmpvar_113.xyz * tmpvar_113.w) * 4.0);
  highp float tmpvar_114;
  tmpvar_114 = max ((tmpvar_107 * tmpvar_107), 0.1);
  highp float tmpvar_115;
  tmpvar_115 = (tmpvar_114 * tmpvar_114);
  highp float tmpvar_116;
  tmpvar_116 = (((
    (tmpvar_57 * tmpvar_115)
   - tmpvar_57) * tmpvar_57) + 1.0);
  d_1 = ((0.3183099 * tmpvar_115) / ((tmpvar_116 * tmpvar_116) + 1e-7));
  highp float tmpvar_117;
  tmpvar_117 = min (d_1, 100.0);
  d_1 = tmpvar_117;
  highp vec4 tmpvar_118;
  tmpvar_118.xyz = (((
    ((tmpvar_117 * mix (1.5, 1.0, (1.0 - tmpvar_56))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_56), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (vec3(0.855, 0.502, 0.502), brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_56, (1.0 - specular_7.z))
  ))));
  tmpvar_118.w = tmpvar_59;
  _glesFragData[0] = tmpvar_118;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2(2048.0, 2048.0));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec3 tmpvar_51;
  tmpvar_51 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(((
    (tmpvar_52.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_52.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_52.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(LightDir);
  highp float tmpvar_56;
  tmpvar_56 = max (dot (tmpvar_53, tmpvar_50), 0.0);
  highp float tmpvar_57;
  tmpvar_57 = max (dot (tmpvar_53, normalize(
    (tmpvar_50 + tmpvar_54)
  )), 0.0);
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_58;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_59;
  tmpvar_59 = color_10.w;
  highp float tmpvar_60;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_60 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_60 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_61;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_61 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_61 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_62;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_62 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_60 * 0.4124564)
   + 
    (tmpvar_61 * 0.3575761)
  ) + (tmpvar_62 * 0.1804375)) / 0.950456);
  highp float tmpvar_64;
  tmpvar_64 = (((tmpvar_60 * 0.2126729) + (tmpvar_61 * 0.7151522)) + (tmpvar_62 * 0.072175));
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_60 * 0.0193339)
   + 
    (tmpvar_61 * 0.119192)
  ) + (tmpvar_62 * 0.9503041)) / 1.088754);
  highp float tmpvar_66;
  if ((tmpvar_63 > 0.008856)) {
    tmpvar_66 = pow (tmpvar_63, 0.3333333);
  } else {
    tmpvar_66 = (((903.3 * tmpvar_63) + 16.0) / 116.0);
  };
  highp float tmpvar_67;
  if ((tmpvar_64 > 0.008856)) {
    tmpvar_67 = pow (tmpvar_64, 0.3333333);
  } else {
    tmpvar_67 = (((903.3 * tmpvar_64) + 16.0) / 116.0);
  };
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_69;
  tmpvar_69.x = (((116.0 * tmpvar_67) - 16.0) / 100.0);
  tmpvar_69.y = (((500.0 * 
    (tmpvar_66 - tmpvar_67)
  ) + 110.0) / 220.0);
  tmpvar_69.z = (((200.0 * 
    (tmpvar_67 - tmpvar_68)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_70;
  tmpvar_70 = (tmpvar_69 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_71;
  if ((color_10.x > 0.04045)) {
    tmpvar_71 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_71 = (color_10.x / 12.92);
  };
  highp float tmpvar_72;
  if ((color_10.y > 0.04045)) {
    tmpvar_72 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (color_10.y / 12.92);
  };
  highp float tmpvar_73;
  if ((color_10.z > 0.04045)) {
    tmpvar_73 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_73 = (color_10.z / 12.92);
  };
  highp float tmpvar_74;
  tmpvar_74 = (((
    (tmpvar_71 * 0.4124564)
   + 
    (tmpvar_72 * 0.3575761)
  ) + (tmpvar_73 * 0.1804375)) / 0.950456);
  highp float tmpvar_75;
  tmpvar_75 = (((tmpvar_71 * 0.2126729) + (tmpvar_72 * 0.7151522)) + (tmpvar_73 * 0.072175));
  highp float tmpvar_76;
  tmpvar_76 = (((
    (tmpvar_71 * 0.0193339)
   + 
    (tmpvar_72 * 0.119192)
  ) + (tmpvar_73 * 0.9503041)) / 1.088754);
  highp float tmpvar_77;
  if ((tmpvar_74 > 0.008856)) {
    tmpvar_77 = pow (tmpvar_74, 0.3333333);
  } else {
    tmpvar_77 = (((903.3 * tmpvar_74) + 16.0) / 116.0);
  };
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp float tmpvar_79;
  if ((tmpvar_76 > 0.008856)) {
    tmpvar_79 = pow (tmpvar_76, 0.3333333);
  } else {
    tmpvar_79 = (((903.3 * tmpvar_76) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_80;
  tmpvar_80.x = (((116.0 * tmpvar_78) - 16.0) / 100.0);
  tmpvar_80.y = (((500.0 * 
    (tmpvar_77 - tmpvar_78)
  ) + 110.0) / 220.0);
  tmpvar_80.z = (((200.0 * 
    (tmpvar_78 - tmpvar_79)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_81;
  tmpvar_81 = clamp ((tmpvar_80 + tmpvar_70), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_82;
  highp float x_83;
  highp float tmpvar_84;
  tmpvar_84 = (((tmpvar_81.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_81.y * 220.0)
   - 110.0) / 500.0) + tmpvar_84);
  x_83 = tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = (tmpvar_84 - ((
    (tmpvar_81.z * 220.0)
   - 110.0) / 200.0));
  z_82 = tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = pow (tmpvar_85, 3.0);
  highp float tmpvar_88;
  tmpvar_88 = pow (tmpvar_84, 3.0);
  highp float tmpvar_89;
  tmpvar_89 = pow (tmpvar_86, 3.0);
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = tmpvar_87;
  } else {
    tmpvar_90 = ((tmpvar_85 - 0.137931) / 7.787069);
  };
  x_83 = (tmpvar_90 * 0.950456);
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = tmpvar_88;
  } else {
    tmpvar_91 = ((tmpvar_84 - 0.137931) / 7.787069);
  };
  highp float tmpvar_92;
  if ((tmpvar_89 > 0.008856)) {
    tmpvar_92 = tmpvar_89;
  } else {
    tmpvar_92 = ((tmpvar_86 - 0.137931) / 7.787069);
  };
  z_82 = (tmpvar_92 * 1.088754);
  highp float tmpvar_93;
  tmpvar_93 = (((x_83 * 3.240454) + (tmpvar_91 * -1.537138)) + (z_82 * -0.4985314));
  highp float tmpvar_94;
  tmpvar_94 = (((x_83 * -0.969266) + (tmpvar_91 * 1.876011)) + (z_82 * 0.041556));
  highp float tmpvar_95;
  tmpvar_95 = (((x_83 * 0.0556434) + (tmpvar_91 * -0.2040259)) + (z_82 * 1.057225));
  highp float tmpvar_96;
  if ((tmpvar_93 > 0.0031308)) {
    tmpvar_96 = ((1.055 * pow (tmpvar_93, 0.4166667)) - 0.055);
  } else {
    tmpvar_96 = (12.92 * tmpvar_93);
  };
  highp float tmpvar_97;
  if ((tmpvar_94 > 0.0031308)) {
    tmpvar_97 = ((1.055 * pow (tmpvar_94, 0.4166667)) - 0.055);
  } else {
    tmpvar_97 = (12.92 * tmpvar_94);
  };
  highp float tmpvar_98;
  if ((tmpvar_95 > 0.0031308)) {
    tmpvar_98 = ((1.055 * pow (tmpvar_95, 0.4166667)) - 0.055);
  } else {
    tmpvar_98 = (12.92 * tmpvar_95);
  };
  highp vec3 tmpvar_99;
  tmpvar_99.x = tmpvar_96;
  tmpvar_99.y = tmpvar_97;
  tmpvar_99.z = tmpvar_98;
  lowp vec3 tmpvar_100;
  tmpvar_100 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_101;
  tmpvar_101 = mix (color_10.xyz, tmpvar_99, tmpvar_100);
  mainColor_9 = (tmpvar_101 * tmpvar_101);
  lowp vec3 tmpvar_102;
  tmpvar_102 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_102;
  highp vec4 tmpvar_103;
  tmpvar_103.w = 0.0;
  tmpvar_103.xyz = mainColor_9;
  highp vec4 tmpvar_104;
  tmpvar_104.w = 0.0;
  tmpvar_104.xyz = mainColor_9;
  highp vec4 tmpvar_105;
  tmpvar_105.w = 0.0;
  tmpvar_105.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_103, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_104, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_105, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_106;
  tmpvar_106 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_106;
  highp float tmpvar_107;
  tmpvar_107 = (1.0 - specular_7.x);
  highp vec2 tmpvar_108;
  tmpvar_108.x = (((
    dot (tmpvar_53, tmpvar_54)
   * 0.5) + 0.5) * 0.99);
  tmpvar_108.y = specular_7.y;
  lowp vec3 tmpvar_109;
  tmpvar_109 = texture (TexBRDF, tmpvar_108).xyz;
  brdfColor_6 = tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = max (((
    dot (tmpvar_53, tmpvar_55)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_110 * tmpvar_110);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_111;
  I_111 = -(tmpvar_50);
  reflectDir_3.xyz = (I_111 - (2.0 * (
    dot (tmpvar_53, I_111)
   * tmpvar_53)));
  reflectDir_3.w = (tmpvar_107 * 4.0);
  lowp vec4 tmpvar_112;
  tmpvar_112 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_113;
  tmpvar_113 = tmpvar_112;
  iblColor_2.w = tmpvar_113.w;
  iblColor_2.xyz = ((tmpvar_113.xyz * tmpvar_113.w) * 4.0);
  highp float tmpvar_114;
  tmpvar_114 = max ((tmpvar_107 * tmpvar_107), 0.1);
  highp float tmpvar_115;
  tmpvar_115 = (tmpvar_114 * tmpvar_114);
  highp float tmpvar_116;
  tmpvar_116 = (((
    (tmpvar_57 * tmpvar_115)
   - tmpvar_57) * tmpvar_57) + 1.0);
  d_1 = ((0.3183099 * tmpvar_115) / ((tmpvar_116 * tmpvar_116) + 1e-7));
  highp float tmpvar_117;
  tmpvar_117 = min (d_1, 100.0);
  d_1 = tmpvar_117;
  highp vec4 tmpvar_118;
  tmpvar_118.xyz = (((
    ((tmpvar_117 * mix (1.5, 1.0, (1.0 - tmpvar_56))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_56), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (vec3(0.855, 0.502, 0.502), brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_56, (1.0 - specular_7.z))
  ))));
  tmpvar_118.w = tmpvar_59;
  _glesFragData[0] = tmpvar_118;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2(2048.0, 2048.0));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec3 tmpvar_51;
  tmpvar_51 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(((
    (tmpvar_52.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_52.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_52.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(LightDir);
  highp float tmpvar_56;
  tmpvar_56 = max (dot (tmpvar_53, tmpvar_50), 0.0);
  highp float tmpvar_57;
  tmpvar_57 = max (dot (tmpvar_53, normalize(
    (tmpvar_50 + tmpvar_54)
  )), 0.0);
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_58;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_59;
  tmpvar_59 = color_10.w;
  highp float tmpvar_60;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_60 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_60 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_61;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_61 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_61 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_62;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_62 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_60 * 0.4124564)
   + 
    (tmpvar_61 * 0.3575761)
  ) + (tmpvar_62 * 0.1804375)) / 0.950456);
  highp float tmpvar_64;
  tmpvar_64 = (((tmpvar_60 * 0.2126729) + (tmpvar_61 * 0.7151522)) + (tmpvar_62 * 0.072175));
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_60 * 0.0193339)
   + 
    (tmpvar_61 * 0.119192)
  ) + (tmpvar_62 * 0.9503041)) / 1.088754);
  highp float tmpvar_66;
  if ((tmpvar_63 > 0.008856)) {
    tmpvar_66 = pow (tmpvar_63, 0.3333333);
  } else {
    tmpvar_66 = (((903.3 * tmpvar_63) + 16.0) / 116.0);
  };
  highp float tmpvar_67;
  if ((tmpvar_64 > 0.008856)) {
    tmpvar_67 = pow (tmpvar_64, 0.3333333);
  } else {
    tmpvar_67 = (((903.3 * tmpvar_64) + 16.0) / 116.0);
  };
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_69;
  tmpvar_69.x = (((116.0 * tmpvar_67) - 16.0) / 100.0);
  tmpvar_69.y = (((500.0 * 
    (tmpvar_66 - tmpvar_67)
  ) + 110.0) / 220.0);
  tmpvar_69.z = (((200.0 * 
    (tmpvar_67 - tmpvar_68)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_70;
  tmpvar_70 = (tmpvar_69 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_71;
  if ((color_10.x > 0.04045)) {
    tmpvar_71 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_71 = (color_10.x / 12.92);
  };
  highp float tmpvar_72;
  if ((color_10.y > 0.04045)) {
    tmpvar_72 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (color_10.y / 12.92);
  };
  highp float tmpvar_73;
  if ((color_10.z > 0.04045)) {
    tmpvar_73 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_73 = (color_10.z / 12.92);
  };
  highp float tmpvar_74;
  tmpvar_74 = (((
    (tmpvar_71 * 0.4124564)
   + 
    (tmpvar_72 * 0.3575761)
  ) + (tmpvar_73 * 0.1804375)) / 0.950456);
  highp float tmpvar_75;
  tmpvar_75 = (((tmpvar_71 * 0.2126729) + (tmpvar_72 * 0.7151522)) + (tmpvar_73 * 0.072175));
  highp float tmpvar_76;
  tmpvar_76 = (((
    (tmpvar_71 * 0.0193339)
   + 
    (tmpvar_72 * 0.119192)
  ) + (tmpvar_73 * 0.9503041)) / 1.088754);
  highp float tmpvar_77;
  if ((tmpvar_74 > 0.008856)) {
    tmpvar_77 = pow (tmpvar_74, 0.3333333);
  } else {
    tmpvar_77 = (((903.3 * tmpvar_74) + 16.0) / 116.0);
  };
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp float tmpvar_79;
  if ((tmpvar_76 > 0.008856)) {
    tmpvar_79 = pow (tmpvar_76, 0.3333333);
  } else {
    tmpvar_79 = (((903.3 * tmpvar_76) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_80;
  tmpvar_80.x = (((116.0 * tmpvar_78) - 16.0) / 100.0);
  tmpvar_80.y = (((500.0 * 
    (tmpvar_77 - tmpvar_78)
  ) + 110.0) / 220.0);
  tmpvar_80.z = (((200.0 * 
    (tmpvar_78 - tmpvar_79)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_81;
  tmpvar_81 = clamp ((tmpvar_80 + tmpvar_70), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_82;
  highp float x_83;
  highp float tmpvar_84;
  tmpvar_84 = (((tmpvar_81.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_81.y * 220.0)
   - 110.0) / 500.0) + tmpvar_84);
  x_83 = tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = (tmpvar_84 - ((
    (tmpvar_81.z * 220.0)
   - 110.0) / 200.0));
  z_82 = tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = pow (tmpvar_85, 3.0);
  highp float tmpvar_88;
  tmpvar_88 = pow (tmpvar_84, 3.0);
  highp float tmpvar_89;
  tmpvar_89 = pow (tmpvar_86, 3.0);
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = tmpvar_87;
  } else {
    tmpvar_90 = ((tmpvar_85 - 0.137931) / 7.787069);
  };
  x_83 = (tmpvar_90 * 0.950456);
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = tmpvar_88;
  } else {
    tmpvar_91 = ((tmpvar_84 - 0.137931) / 7.787069);
  };
  highp float tmpvar_92;
  if ((tmpvar_89 > 0.008856)) {
    tmpvar_92 = tmpvar_89;
  } else {
    tmpvar_92 = ((tmpvar_86 - 0.137931) / 7.787069);
  };
  z_82 = (tmpvar_92 * 1.088754);
  highp float tmpvar_93;
  tmpvar_93 = (((x_83 * 3.240454) + (tmpvar_91 * -1.537138)) + (z_82 * -0.4985314));
  highp float tmpvar_94;
  tmpvar_94 = (((x_83 * -0.969266) + (tmpvar_91 * 1.876011)) + (z_82 * 0.041556));
  highp float tmpvar_95;
  tmpvar_95 = (((x_83 * 0.0556434) + (tmpvar_91 * -0.2040259)) + (z_82 * 1.057225));
  highp float tmpvar_96;
  if ((tmpvar_93 > 0.0031308)) {
    tmpvar_96 = ((1.055 * pow (tmpvar_93, 0.4166667)) - 0.055);
  } else {
    tmpvar_96 = (12.92 * tmpvar_93);
  };
  highp float tmpvar_97;
  if ((tmpvar_94 > 0.0031308)) {
    tmpvar_97 = ((1.055 * pow (tmpvar_94, 0.4166667)) - 0.055);
  } else {
    tmpvar_97 = (12.92 * tmpvar_94);
  };
  highp float tmpvar_98;
  if ((tmpvar_95 > 0.0031308)) {
    tmpvar_98 = ((1.055 * pow (tmpvar_95, 0.4166667)) - 0.055);
  } else {
    tmpvar_98 = (12.92 * tmpvar_95);
  };
  highp vec3 tmpvar_99;
  tmpvar_99.x = tmpvar_96;
  tmpvar_99.y = tmpvar_97;
  tmpvar_99.z = tmpvar_98;
  lowp vec3 tmpvar_100;
  tmpvar_100 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_101;
  tmpvar_101 = mix (color_10.xyz, tmpvar_99, tmpvar_100);
  mainColor_9 = (tmpvar_101 * tmpvar_101);
  lowp vec3 tmpvar_102;
  tmpvar_102 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_102;
  highp vec4 tmpvar_103;
  tmpvar_103.w = 0.0;
  tmpvar_103.xyz = mainColor_9;
  highp vec4 tmpvar_104;
  tmpvar_104.w = 0.0;
  tmpvar_104.xyz = mainColor_9;
  highp vec4 tmpvar_105;
  tmpvar_105.w = 0.0;
  tmpvar_105.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_103, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_104, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_105, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_106;
  tmpvar_106 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_106;
  highp float tmpvar_107;
  tmpvar_107 = (1.0 - specular_7.x);
  highp vec2 tmpvar_108;
  tmpvar_108.x = (((
    dot (tmpvar_53, tmpvar_54)
   * 0.5) + 0.5) * 0.99);
  tmpvar_108.y = specular_7.y;
  lowp vec3 tmpvar_109;
  tmpvar_109 = texture (TexBRDF, tmpvar_108).xyz;
  brdfColor_6 = tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = max (((
    dot (tmpvar_53, tmpvar_55)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_110 * tmpvar_110);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_111;
  I_111 = -(tmpvar_50);
  reflectDir_3.xyz = (I_111 - (2.0 * (
    dot (tmpvar_53, I_111)
   * tmpvar_53)));
  reflectDir_3.w = (tmpvar_107 * 4.0);
  lowp vec4 tmpvar_112;
  tmpvar_112 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_113;
  tmpvar_113 = tmpvar_112;
  iblColor_2.w = tmpvar_113.w;
  iblColor_2.xyz = ((tmpvar_113.xyz * tmpvar_113.w) * 4.0);
  highp float tmpvar_114;
  tmpvar_114 = max ((tmpvar_107 * tmpvar_107), 0.1);
  highp float tmpvar_115;
  tmpvar_115 = (tmpvar_114 * tmpvar_114);
  highp float tmpvar_116;
  tmpvar_116 = (((
    (tmpvar_57 * tmpvar_115)
   - tmpvar_57) * tmpvar_57) + 1.0);
  d_1 = ((0.3183099 * tmpvar_115) / ((tmpvar_116 * tmpvar_116) + 1e-7));
  highp float tmpvar_117;
  tmpvar_117 = min (d_1, 100.0);
  d_1 = tmpvar_117;
  highp vec4 tmpvar_118;
  tmpvar_118.xyz = (((
    ((tmpvar_117 * mix (1.5, 1.0, (1.0 - tmpvar_56))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_56), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (vec3(0.855, 0.502, 0.502), brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_56, (1.0 - specular_7.z))
  ))));
  tmpvar_118.w = tmpvar_59;
  _glesFragData[0] = tmpvar_118;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    shadow_16 = 1.0;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2(2048.0, 2048.0));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_15.y;
    tmpvar_41.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_36 + tmpvar_41);
    tmpvar_42.z = shadowCoord_12.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_44));
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_15.x;
    tmpvar_45.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_36 + tmpvar_45);
    tmpvar_46.z = shadowCoord_12.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_48));
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_15.y;
    tmpvar_49.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_36 + tmpvar_49);
    tmpvar_50.z = shadowCoord_12.z;
    highp vec4 tmpvar_51;
    tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50.xy);
    highp float tmpvar_52;
    if ((tmpvar_51.x < xlv_TEXCOORD4.z)) {
      tmpvar_52 = 0.0;
    } else {
      tmpvar_52 = 1.0;
    };
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_52));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  tmpvar_53.x = xlv_TEXCOORD1.w;
  tmpvar_53.y = xlv_TEXCOORD2.w;
  tmpvar_53.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_54;
  tmpvar_54 = normalize((CAMERA_WORLDPOSITION - tmpvar_53));
  lowp vec3 tmpvar_55;
  tmpvar_55 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_56 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_57;
  tmpvar_57 = normalize(((
    (tmpvar_56.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_56.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_56.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_58;
  tmpvar_58 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_59;
  tmpvar_59 = normalize(LightDir);
  highp float tmpvar_60;
  tmpvar_60 = max (dot (tmpvar_57, tmpvar_54), 0.0);
  highp float tmpvar_61;
  tmpvar_61 = max (dot (tmpvar_57, normalize(
    (tmpvar_54 + tmpvar_58)
  )), 0.0);
  lowp vec4 tmpvar_62;
  tmpvar_62 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_62;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_63;
  tmpvar_63 = color_10.w;
  highp float tmpvar_64;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_64 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_64 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_65;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_65 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_65 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_66;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_66 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_66 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_67;
  tmpvar_67 = (((
    (tmpvar_64 * 0.4124564)
   + 
    (tmpvar_65 * 0.3575761)
  ) + (tmpvar_66 * 0.1804375)) / 0.950456);
  highp float tmpvar_68;
  tmpvar_68 = (((tmpvar_64 * 0.2126729) + (tmpvar_65 * 0.7151522)) + (tmpvar_66 * 0.072175));
  highp float tmpvar_69;
  tmpvar_69 = (((
    (tmpvar_64 * 0.0193339)
   + 
    (tmpvar_65 * 0.119192)
  ) + (tmpvar_66 * 0.9503041)) / 1.088754);
  highp float tmpvar_70;
  if ((tmpvar_67 > 0.008856)) {
    tmpvar_70 = pow (tmpvar_67, 0.3333333);
  } else {
    tmpvar_70 = (((903.3 * tmpvar_67) + 16.0) / 116.0);
  };
  highp float tmpvar_71;
  if ((tmpvar_68 > 0.008856)) {
    tmpvar_71 = pow (tmpvar_68, 0.3333333);
  } else {
    tmpvar_71 = (((903.3 * tmpvar_68) + 16.0) / 116.0);
  };
  highp float tmpvar_72;
  if ((tmpvar_69 > 0.008856)) {
    tmpvar_72 = pow (tmpvar_69, 0.3333333);
  } else {
    tmpvar_72 = (((903.3 * tmpvar_69) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_73;
  tmpvar_73.x = (((116.0 * tmpvar_71) - 16.0) / 100.0);
  tmpvar_73.y = (((500.0 * 
    (tmpvar_70 - tmpvar_71)
  ) + 110.0) / 220.0);
  tmpvar_73.z = (((200.0 * 
    (tmpvar_71 - tmpvar_72)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_74;
  tmpvar_74 = (tmpvar_73 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_75;
  if ((color_10.x > 0.04045)) {
    tmpvar_75 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_75 = (color_10.x / 12.92);
  };
  highp float tmpvar_76;
  if ((color_10.y > 0.04045)) {
    tmpvar_76 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_76 = (color_10.y / 12.92);
  };
  highp float tmpvar_77;
  if ((color_10.z > 0.04045)) {
    tmpvar_77 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_77 = (color_10.z / 12.92);
  };
  highp float tmpvar_78;
  tmpvar_78 = (((
    (tmpvar_75 * 0.4124564)
   + 
    (tmpvar_76 * 0.3575761)
  ) + (tmpvar_77 * 0.1804375)) / 0.950456);
  highp float tmpvar_79;
  tmpvar_79 = (((tmpvar_75 * 0.2126729) + (tmpvar_76 * 0.7151522)) + (tmpvar_77 * 0.072175));
  highp float tmpvar_80;
  tmpvar_80 = (((
    (tmpvar_75 * 0.0193339)
   + 
    (tmpvar_76 * 0.119192)
  ) + (tmpvar_77 * 0.9503041)) / 1.088754);
  highp float tmpvar_81;
  if ((tmpvar_78 > 0.008856)) {
    tmpvar_81 = pow (tmpvar_78, 0.3333333);
  } else {
    tmpvar_81 = (((903.3 * tmpvar_78) + 16.0) / 116.0);
  };
  highp float tmpvar_82;
  if ((tmpvar_79 > 0.008856)) {
    tmpvar_82 = pow (tmpvar_79, 0.3333333);
  } else {
    tmpvar_82 = (((903.3 * tmpvar_79) + 16.0) / 116.0);
  };
  highp float tmpvar_83;
  if ((tmpvar_80 > 0.008856)) {
    tmpvar_83 = pow (tmpvar_80, 0.3333333);
  } else {
    tmpvar_83 = (((903.3 * tmpvar_80) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_84;
  tmpvar_84.x = (((116.0 * tmpvar_82) - 16.0) / 100.0);
  tmpvar_84.y = (((500.0 * 
    (tmpvar_81 - tmpvar_82)
  ) + 110.0) / 220.0);
  tmpvar_84.z = (((200.0 * 
    (tmpvar_82 - tmpvar_83)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_85;
  tmpvar_85 = clamp ((tmpvar_84 + tmpvar_74), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_86;
  highp float x_87;
  highp float tmpvar_88;
  tmpvar_88 = (((tmpvar_85.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_89;
  tmpvar_89 = (((
    (tmpvar_85.y * 220.0)
   - 110.0) / 500.0) + tmpvar_88);
  x_87 = tmpvar_89;
  highp float tmpvar_90;
  tmpvar_90 = (tmpvar_88 - ((
    (tmpvar_85.z * 220.0)
   - 110.0) / 200.0));
  z_86 = tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = pow (tmpvar_89, 3.0);
  highp float tmpvar_92;
  tmpvar_92 = pow (tmpvar_88, 3.0);
  highp float tmpvar_93;
  tmpvar_93 = pow (tmpvar_90, 3.0);
  highp float tmpvar_94;
  if ((tmpvar_91 > 0.008856)) {
    tmpvar_94 = tmpvar_91;
  } else {
    tmpvar_94 = ((tmpvar_89 - 0.137931) / 7.787069);
  };
  x_87 = (tmpvar_94 * 0.950456);
  highp float tmpvar_95;
  if ((tmpvar_92 > 0.008856)) {
    tmpvar_95 = tmpvar_92;
  } else {
    tmpvar_95 = ((tmpvar_88 - 0.137931) / 7.787069);
  };
  highp float tmpvar_96;
  if ((tmpvar_93 > 0.008856)) {
    tmpvar_96 = tmpvar_93;
  } else {
    tmpvar_96 = ((tmpvar_90 - 0.137931) / 7.787069);
  };
  z_86 = (tmpvar_96 * 1.088754);
  highp float tmpvar_97;
  tmpvar_97 = (((x_87 * 3.240454) + (tmpvar_95 * -1.537138)) + (z_86 * -0.4985314));
  highp float tmpvar_98;
  tmpvar_98 = (((x_87 * -0.969266) + (tmpvar_95 * 1.876011)) + (z_86 * 0.041556));
  highp float tmpvar_99;
  tmpvar_99 = (((x_87 * 0.0556434) + (tmpvar_95 * -0.2040259)) + (z_86 * 1.057225));
  highp float tmpvar_100;
  if ((tmpvar_97 > 0.0031308)) {
    tmpvar_100 = ((1.055 * pow (tmpvar_97, 0.4166667)) - 0.055);
  } else {
    tmpvar_100 = (12.92 * tmpvar_97);
  };
  highp float tmpvar_101;
  if ((tmpvar_98 > 0.0031308)) {
    tmpvar_101 = ((1.055 * pow (tmpvar_98, 0.4166667)) - 0.055);
  } else {
    tmpvar_101 = (12.92 * tmpvar_98);
  };
  highp float tmpvar_102;
  if ((tmpvar_99 > 0.0031308)) {
    tmpvar_102 = ((1.055 * pow (tmpvar_99, 0.4166667)) - 0.055);
  } else {
    tmpvar_102 = (12.92 * tmpvar_99);
  };
  highp vec3 tmpvar_103;
  tmpvar_103.x = tmpvar_100;
  tmpvar_103.y = tmpvar_101;
  tmpvar_103.z = tmpvar_102;
  lowp vec3 tmpvar_104;
  tmpvar_104 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_105;
  tmpvar_105 = mix (color_10.xyz, tmpvar_103, tmpvar_104);
  mainColor_9 = (tmpvar_105 * tmpvar_105);
  lowp vec3 tmpvar_106;
  tmpvar_106 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_106;
  highp vec4 tmpvar_107;
  tmpvar_107.w = 0.0;
  tmpvar_107.xyz = mainColor_9;
  highp vec4 tmpvar_108;
  tmpvar_108.w = 0.0;
  tmpvar_108.xyz = mainColor_9;
  highp vec4 tmpvar_109;
  tmpvar_109.w = 0.0;
  tmpvar_109.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_107, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_108, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_109, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_110;
  tmpvar_110 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_110;
  highp float tmpvar_111;
  tmpvar_111 = (1.0 - specular_7.x);
  highp vec2 tmpvar_112;
  tmpvar_112.x = (((
    dot (tmpvar_57, tmpvar_58)
   * 0.5) + 0.5) * 0.99);
  tmpvar_112.y = specular_7.y;
  lowp vec3 tmpvar_113;
  tmpvar_113 = texture (TexBRDF, tmpvar_112).xyz;
  brdfColor_6 = tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = max (((
    dot (tmpvar_57, tmpvar_59)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_114 * tmpvar_114);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_115;
  I_115 = -(tmpvar_54);
  reflectDir_3.xyz = (I_115 - (2.0 * (
    dot (tmpvar_57, I_115)
   * tmpvar_57)));
  reflectDir_3.w = (tmpvar_111 * 4.0);
  lowp vec4 tmpvar_116;
  tmpvar_116 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_117;
  tmpvar_117 = tmpvar_116;
  iblColor_2.w = tmpvar_117.w;
  iblColor_2.xyz = ((tmpvar_117.xyz * tmpvar_117.w) * 4.0);
  highp float tmpvar_118;
  tmpvar_118 = max ((tmpvar_111 * tmpvar_111), 0.1);
  highp float tmpvar_119;
  tmpvar_119 = (tmpvar_118 * tmpvar_118);
  highp float tmpvar_120;
  tmpvar_120 = (((
    (tmpvar_61 * tmpvar_119)
   - tmpvar_61) * tmpvar_61) + 1.0);
  d_1 = ((0.3183099 * tmpvar_119) / ((tmpvar_120 * tmpvar_120) + 1e-7));
  highp float tmpvar_121;
  tmpvar_121 = min (d_1, 100.0);
  d_1 = tmpvar_121;
  highp vec4 tmpvar_122;
  tmpvar_122.xyz = (((
    ((tmpvar_121 * mix (1.5, 1.0, (1.0 - tmpvar_60))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_60), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (vec3(0.855, 0.502, 0.502), brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_60, (1.0 - specular_7.z))
  ))));
  tmpvar_122.w = tmpvar_63;
  _glesFragData[0] = tmpvar_122;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((
    (tmpvar_15.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_15.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_15.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_18;
  tmpvar_18 = normalize(LightDir);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_16, tmpvar_13), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_16, normalize(
    (tmpvar_13 + tmpvar_17)
  )), 0.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_21;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_22;
  tmpvar_22 = color_10.w;
  highp float tmpvar_23;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_23 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_23 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_24;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_24 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_24 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_25;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_25 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_25 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_23 * 0.4124564)
   + 
    (tmpvar_24 * 0.3575761)
  ) + (tmpvar_25 * 0.1804375)) / 0.950456);
  highp float tmpvar_27;
  tmpvar_27 = (((tmpvar_23 * 0.2126729) + (tmpvar_24 * 0.7151522)) + (tmpvar_25 * 0.072175));
  highp float tmpvar_28;
  tmpvar_28 = (((
    (tmpvar_23 * 0.0193339)
   + 
    (tmpvar_24 * 0.119192)
  ) + (tmpvar_25 * 0.9503041)) / 1.088754);
  highp float tmpvar_29;
  if ((tmpvar_26 > 0.008856)) {
    tmpvar_29 = pow (tmpvar_26, 0.3333333);
  } else {
    tmpvar_29 = (((903.3 * tmpvar_26) + 16.0) / 116.0);
  };
  highp float tmpvar_30;
  if ((tmpvar_27 > 0.008856)) {
    tmpvar_30 = pow (tmpvar_27, 0.3333333);
  } else {
    tmpvar_30 = (((903.3 * tmpvar_27) + 16.0) / 116.0);
  };
  highp float tmpvar_31;
  if ((tmpvar_28 > 0.008856)) {
    tmpvar_31 = pow (tmpvar_28, 0.3333333);
  } else {
    tmpvar_31 = (((903.3 * tmpvar_28) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_32;
  tmpvar_32.x = (((116.0 * tmpvar_30) - 16.0) / 100.0);
  tmpvar_32.y = (((500.0 * 
    (tmpvar_29 - tmpvar_30)
  ) + 110.0) / 220.0);
  tmpvar_32.z = (((200.0 * 
    (tmpvar_30 - tmpvar_31)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_33;
  tmpvar_33 = (tmpvar_32 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_34;
  if ((color_10.x > 0.04045)) {
    tmpvar_34 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_34 = (color_10.x / 12.92);
  };
  highp float tmpvar_35;
  if ((color_10.y > 0.04045)) {
    tmpvar_35 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_35 = (color_10.y / 12.92);
  };
  highp float tmpvar_36;
  if ((color_10.z > 0.04045)) {
    tmpvar_36 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_36 = (color_10.z / 12.92);
  };
  highp float tmpvar_37;
  tmpvar_37 = (((
    (tmpvar_34 * 0.4124564)
   + 
    (tmpvar_35 * 0.3575761)
  ) + (tmpvar_36 * 0.1804375)) / 0.950456);
  highp float tmpvar_38;
  tmpvar_38 = (((tmpvar_34 * 0.2126729) + (tmpvar_35 * 0.7151522)) + (tmpvar_36 * 0.072175));
  highp float tmpvar_39;
  tmpvar_39 = (((
    (tmpvar_34 * 0.0193339)
   + 
    (tmpvar_35 * 0.119192)
  ) + (tmpvar_36 * 0.9503041)) / 1.088754);
  highp float tmpvar_40;
  if ((tmpvar_37 > 0.008856)) {
    tmpvar_40 = pow (tmpvar_37, 0.3333333);
  } else {
    tmpvar_40 = (((903.3 * tmpvar_37) + 16.0) / 116.0);
  };
  highp float tmpvar_41;
  if ((tmpvar_38 > 0.008856)) {
    tmpvar_41 = pow (tmpvar_38, 0.3333333);
  } else {
    tmpvar_41 = (((903.3 * tmpvar_38) + 16.0) / 116.0);
  };
  highp float tmpvar_42;
  if ((tmpvar_39 > 0.008856)) {
    tmpvar_42 = pow (tmpvar_39, 0.3333333);
  } else {
    tmpvar_42 = (((903.3 * tmpvar_39) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_43;
  tmpvar_43.x = (((116.0 * tmpvar_41) - 16.0) / 100.0);
  tmpvar_43.y = (((500.0 * 
    (tmpvar_40 - tmpvar_41)
  ) + 110.0) / 220.0);
  tmpvar_43.z = (((200.0 * 
    (tmpvar_41 - tmpvar_42)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_44;
  tmpvar_44 = clamp ((tmpvar_43 + tmpvar_33), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_45;
  highp float x_46;
  highp float tmpvar_47;
  tmpvar_47 = (((tmpvar_44.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_48;
  tmpvar_48 = (((
    (tmpvar_44.y * 220.0)
   - 110.0) / 500.0) + tmpvar_47);
  x_46 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = (tmpvar_47 - ((
    (tmpvar_44.z * 220.0)
   - 110.0) / 200.0));
  z_45 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = pow (tmpvar_48, 3.0);
  highp float tmpvar_51;
  tmpvar_51 = pow (tmpvar_47, 3.0);
  highp float tmpvar_52;
  tmpvar_52 = pow (tmpvar_49, 3.0);
  highp float tmpvar_53;
  if ((tmpvar_50 > 0.008856)) {
    tmpvar_53 = tmpvar_50;
  } else {
    tmpvar_53 = ((tmpvar_48 - 0.137931) / 7.787069);
  };
  x_46 = (tmpvar_53 * 0.950456);
  highp float tmpvar_54;
  if ((tmpvar_51 > 0.008856)) {
    tmpvar_54 = tmpvar_51;
  } else {
    tmpvar_54 = ((tmpvar_47 - 0.137931) / 7.787069);
  };
  highp float tmpvar_55;
  if ((tmpvar_52 > 0.008856)) {
    tmpvar_55 = tmpvar_52;
  } else {
    tmpvar_55 = ((tmpvar_49 - 0.137931) / 7.787069);
  };
  z_45 = (tmpvar_55 * 1.088754);
  highp float tmpvar_56;
  tmpvar_56 = (((x_46 * 3.240454) + (tmpvar_54 * -1.537138)) + (z_45 * -0.4985314));
  highp float tmpvar_57;
  tmpvar_57 = (((x_46 * -0.969266) + (tmpvar_54 * 1.876011)) + (z_45 * 0.041556));
  highp float tmpvar_58;
  tmpvar_58 = (((x_46 * 0.0556434) + (tmpvar_54 * -0.2040259)) + (z_45 * 1.057225));
  highp float tmpvar_59;
  if ((tmpvar_56 > 0.0031308)) {
    tmpvar_59 = ((1.055 * pow (tmpvar_56, 0.4166667)) - 0.055);
  } else {
    tmpvar_59 = (12.92 * tmpvar_56);
  };
  highp float tmpvar_60;
  if ((tmpvar_57 > 0.0031308)) {
    tmpvar_60 = ((1.055 * pow (tmpvar_57, 0.4166667)) - 0.055);
  } else {
    tmpvar_60 = (12.92 * tmpvar_57);
  };
  highp float tmpvar_61;
  if ((tmpvar_58 > 0.0031308)) {
    tmpvar_61 = ((1.055 * pow (tmpvar_58, 0.4166667)) - 0.055);
  } else {
    tmpvar_61 = (12.92 * tmpvar_58);
  };
  highp vec3 tmpvar_62;
  tmpvar_62.x = tmpvar_59;
  tmpvar_62.y = tmpvar_60;
  tmpvar_62.z = tmpvar_61;
  lowp vec3 tmpvar_63;
  tmpvar_63 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix (color_10.xyz, tmpvar_62, tmpvar_63);
  mainColor_9 = (tmpvar_64 * tmpvar_64);
  lowp vec3 tmpvar_65;
  tmpvar_65 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_65;
  highp vec4 tmpvar_66;
  tmpvar_66.w = 0.0;
  tmpvar_66.xyz = mainColor_9;
  highp vec4 tmpvar_67;
  tmpvar_67.w = 0.0;
  tmpvar_67.xyz = mainColor_9;
  highp vec4 tmpvar_68;
  tmpvar_68.w = 0.0;
  tmpvar_68.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_66, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_67, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_68, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_69;
  tmpvar_69 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = (1.0 - specular_7.x);
  highp vec2 tmpvar_71;
  tmpvar_71.x = (((
    dot (tmpvar_16, tmpvar_17)
   * 0.5) + 0.5) * 0.99);
  tmpvar_71.y = specular_7.y;
  lowp vec3 tmpvar_72;
  tmpvar_72 = texture (TexBRDF, tmpvar_71).xyz;
  brdfColor_6 = tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = max (((
    dot (tmpvar_16, tmpvar_18)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_73 * tmpvar_73);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_74;
  I_74 = -(tmpvar_13);
  reflectDir_3.xyz = (I_74 - (2.0 * (
    dot (tmpvar_16, I_74)
   * tmpvar_16)));
  reflectDir_3.w = (tmpvar_70 * 4.0);
  lowp vec4 tmpvar_75;
  tmpvar_75 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_76;
  tmpvar_76 = tmpvar_75;
  iblColor_2.w = tmpvar_76.w;
  iblColor_2.xyz = ((tmpvar_76.xyz * tmpvar_76.w) * 4.0);
  highp float tmpvar_77;
  tmpvar_77 = max ((tmpvar_70 * tmpvar_70), 0.1);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_20 * tmpvar_78)
   - tmpvar_20) * tmpvar_20) + 1.0);
  d_1 = ((0.3183099 * tmpvar_78) / ((tmpvar_79 * tmpvar_79) + 1e-7));
  highp float tmpvar_80;
  tmpvar_80 = min (d_1, 100.0);
  d_1 = tmpvar_80;
  highp vec4 tmpvar_81;
  tmpvar_81.xyz = (((
    ((tmpvar_80 * mix (1.5, 1.0, (1.0 - tmpvar_19))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_19), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((brdfColor_6 * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_19, (1.0 - specular_7.z))
  ))));
  tmpvar_81.w = tmpvar_22;
  _glesFragData[0] = tmpvar_81;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((
    (tmpvar_15.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_15.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_15.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_18;
  tmpvar_18 = normalize(LightDir);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_16, tmpvar_13), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_16, normalize(
    (tmpvar_13 + tmpvar_17)
  )), 0.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_21;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_22;
  tmpvar_22 = color_10.w;
  highp float tmpvar_23;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_23 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_23 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_24;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_24 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_24 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_25;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_25 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_25 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_23 * 0.4124564)
   + 
    (tmpvar_24 * 0.3575761)
  ) + (tmpvar_25 * 0.1804375)) / 0.950456);
  highp float tmpvar_27;
  tmpvar_27 = (((tmpvar_23 * 0.2126729) + (tmpvar_24 * 0.7151522)) + (tmpvar_25 * 0.072175));
  highp float tmpvar_28;
  tmpvar_28 = (((
    (tmpvar_23 * 0.0193339)
   + 
    (tmpvar_24 * 0.119192)
  ) + (tmpvar_25 * 0.9503041)) / 1.088754);
  highp float tmpvar_29;
  if ((tmpvar_26 > 0.008856)) {
    tmpvar_29 = pow (tmpvar_26, 0.3333333);
  } else {
    tmpvar_29 = (((903.3 * tmpvar_26) + 16.0) / 116.0);
  };
  highp float tmpvar_30;
  if ((tmpvar_27 > 0.008856)) {
    tmpvar_30 = pow (tmpvar_27, 0.3333333);
  } else {
    tmpvar_30 = (((903.3 * tmpvar_27) + 16.0) / 116.0);
  };
  highp float tmpvar_31;
  if ((tmpvar_28 > 0.008856)) {
    tmpvar_31 = pow (tmpvar_28, 0.3333333);
  } else {
    tmpvar_31 = (((903.3 * tmpvar_28) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_32;
  tmpvar_32.x = (((116.0 * tmpvar_30) - 16.0) / 100.0);
  tmpvar_32.y = (((500.0 * 
    (tmpvar_29 - tmpvar_30)
  ) + 110.0) / 220.0);
  tmpvar_32.z = (((200.0 * 
    (tmpvar_30 - tmpvar_31)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_33;
  tmpvar_33 = (tmpvar_32 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_34;
  if ((color_10.x > 0.04045)) {
    tmpvar_34 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_34 = (color_10.x / 12.92);
  };
  highp float tmpvar_35;
  if ((color_10.y > 0.04045)) {
    tmpvar_35 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_35 = (color_10.y / 12.92);
  };
  highp float tmpvar_36;
  if ((color_10.z > 0.04045)) {
    tmpvar_36 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_36 = (color_10.z / 12.92);
  };
  highp float tmpvar_37;
  tmpvar_37 = (((
    (tmpvar_34 * 0.4124564)
   + 
    (tmpvar_35 * 0.3575761)
  ) + (tmpvar_36 * 0.1804375)) / 0.950456);
  highp float tmpvar_38;
  tmpvar_38 = (((tmpvar_34 * 0.2126729) + (tmpvar_35 * 0.7151522)) + (tmpvar_36 * 0.072175));
  highp float tmpvar_39;
  tmpvar_39 = (((
    (tmpvar_34 * 0.0193339)
   + 
    (tmpvar_35 * 0.119192)
  ) + (tmpvar_36 * 0.9503041)) / 1.088754);
  highp float tmpvar_40;
  if ((tmpvar_37 > 0.008856)) {
    tmpvar_40 = pow (tmpvar_37, 0.3333333);
  } else {
    tmpvar_40 = (((903.3 * tmpvar_37) + 16.0) / 116.0);
  };
  highp float tmpvar_41;
  if ((tmpvar_38 > 0.008856)) {
    tmpvar_41 = pow (tmpvar_38, 0.3333333);
  } else {
    tmpvar_41 = (((903.3 * tmpvar_38) + 16.0) / 116.0);
  };
  highp float tmpvar_42;
  if ((tmpvar_39 > 0.008856)) {
    tmpvar_42 = pow (tmpvar_39, 0.3333333);
  } else {
    tmpvar_42 = (((903.3 * tmpvar_39) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_43;
  tmpvar_43.x = (((116.0 * tmpvar_41) - 16.0) / 100.0);
  tmpvar_43.y = (((500.0 * 
    (tmpvar_40 - tmpvar_41)
  ) + 110.0) / 220.0);
  tmpvar_43.z = (((200.0 * 
    (tmpvar_41 - tmpvar_42)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_44;
  tmpvar_44 = clamp ((tmpvar_43 + tmpvar_33), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_45;
  highp float x_46;
  highp float tmpvar_47;
  tmpvar_47 = (((tmpvar_44.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_48;
  tmpvar_48 = (((
    (tmpvar_44.y * 220.0)
   - 110.0) / 500.0) + tmpvar_47);
  x_46 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = (tmpvar_47 - ((
    (tmpvar_44.z * 220.0)
   - 110.0) / 200.0));
  z_45 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = pow (tmpvar_48, 3.0);
  highp float tmpvar_51;
  tmpvar_51 = pow (tmpvar_47, 3.0);
  highp float tmpvar_52;
  tmpvar_52 = pow (tmpvar_49, 3.0);
  highp float tmpvar_53;
  if ((tmpvar_50 > 0.008856)) {
    tmpvar_53 = tmpvar_50;
  } else {
    tmpvar_53 = ((tmpvar_48 - 0.137931) / 7.787069);
  };
  x_46 = (tmpvar_53 * 0.950456);
  highp float tmpvar_54;
  if ((tmpvar_51 > 0.008856)) {
    tmpvar_54 = tmpvar_51;
  } else {
    tmpvar_54 = ((tmpvar_47 - 0.137931) / 7.787069);
  };
  highp float tmpvar_55;
  if ((tmpvar_52 > 0.008856)) {
    tmpvar_55 = tmpvar_52;
  } else {
    tmpvar_55 = ((tmpvar_49 - 0.137931) / 7.787069);
  };
  z_45 = (tmpvar_55 * 1.088754);
  highp float tmpvar_56;
  tmpvar_56 = (((x_46 * 3.240454) + (tmpvar_54 * -1.537138)) + (z_45 * -0.4985314));
  highp float tmpvar_57;
  tmpvar_57 = (((x_46 * -0.969266) + (tmpvar_54 * 1.876011)) + (z_45 * 0.041556));
  highp float tmpvar_58;
  tmpvar_58 = (((x_46 * 0.0556434) + (tmpvar_54 * -0.2040259)) + (z_45 * 1.057225));
  highp float tmpvar_59;
  if ((tmpvar_56 > 0.0031308)) {
    tmpvar_59 = ((1.055 * pow (tmpvar_56, 0.4166667)) - 0.055);
  } else {
    tmpvar_59 = (12.92 * tmpvar_56);
  };
  highp float tmpvar_60;
  if ((tmpvar_57 > 0.0031308)) {
    tmpvar_60 = ((1.055 * pow (tmpvar_57, 0.4166667)) - 0.055);
  } else {
    tmpvar_60 = (12.92 * tmpvar_57);
  };
  highp float tmpvar_61;
  if ((tmpvar_58 > 0.0031308)) {
    tmpvar_61 = ((1.055 * pow (tmpvar_58, 0.4166667)) - 0.055);
  } else {
    tmpvar_61 = (12.92 * tmpvar_58);
  };
  highp vec3 tmpvar_62;
  tmpvar_62.x = tmpvar_59;
  tmpvar_62.y = tmpvar_60;
  tmpvar_62.z = tmpvar_61;
  lowp vec3 tmpvar_63;
  tmpvar_63 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix (color_10.xyz, tmpvar_62, tmpvar_63);
  mainColor_9 = (tmpvar_64 * tmpvar_64);
  lowp vec3 tmpvar_65;
  tmpvar_65 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_65;
  highp vec4 tmpvar_66;
  tmpvar_66.w = 0.0;
  tmpvar_66.xyz = mainColor_9;
  highp vec4 tmpvar_67;
  tmpvar_67.w = 0.0;
  tmpvar_67.xyz = mainColor_9;
  highp vec4 tmpvar_68;
  tmpvar_68.w = 0.0;
  tmpvar_68.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_66, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_67, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_68, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_69;
  tmpvar_69 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = (1.0 - specular_7.x);
  highp vec2 tmpvar_71;
  tmpvar_71.x = (((
    dot (tmpvar_16, tmpvar_17)
   * 0.5) + 0.5) * 0.99);
  tmpvar_71.y = specular_7.y;
  lowp vec3 tmpvar_72;
  tmpvar_72 = texture (TexBRDF, tmpvar_71).xyz;
  brdfColor_6 = tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = max (((
    dot (tmpvar_16, tmpvar_18)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_73 * tmpvar_73);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_74;
  I_74 = -(tmpvar_13);
  reflectDir_3.xyz = (I_74 - (2.0 * (
    dot (tmpvar_16, I_74)
   * tmpvar_16)));
  reflectDir_3.w = (tmpvar_70 * 4.0);
  lowp vec4 tmpvar_75;
  tmpvar_75 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_76;
  tmpvar_76 = tmpvar_75;
  iblColor_2.w = tmpvar_76.w;
  iblColor_2.xyz = ((tmpvar_76.xyz * tmpvar_76.w) * 4.0);
  highp float tmpvar_77;
  tmpvar_77 = max ((tmpvar_70 * tmpvar_70), 0.1);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_20 * tmpvar_78)
   - tmpvar_20) * tmpvar_20) + 1.0);
  d_1 = ((0.3183099 * tmpvar_78) / ((tmpvar_79 * tmpvar_79) + 1e-7));
  highp float tmpvar_80;
  tmpvar_80 = min (d_1, 100.0);
  d_1 = tmpvar_80;
  highp vec4 tmpvar_81;
  tmpvar_81.xyz = (((
    ((tmpvar_80 * mix (1.5, 1.0, (1.0 - tmpvar_19))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_19), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((brdfColor_6 * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_19, (1.0 - specular_7.z))
  ))));
  tmpvar_81.w = tmpvar_22;
  _glesFragData[0] = tmpvar_81;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2(2048.0, 2048.0));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec3 tmpvar_51;
  tmpvar_51 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(((
    (tmpvar_52.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_52.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_52.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(LightDir);
  highp float tmpvar_56;
  tmpvar_56 = max (dot (tmpvar_53, tmpvar_50), 0.0);
  highp float tmpvar_57;
  tmpvar_57 = max (dot (tmpvar_53, normalize(
    (tmpvar_50 + tmpvar_54)
  )), 0.0);
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_58;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_59;
  tmpvar_59 = color_10.w;
  highp float tmpvar_60;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_60 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_60 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_61;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_61 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_61 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_62;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_62 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_60 * 0.4124564)
   + 
    (tmpvar_61 * 0.3575761)
  ) + (tmpvar_62 * 0.1804375)) / 0.950456);
  highp float tmpvar_64;
  tmpvar_64 = (((tmpvar_60 * 0.2126729) + (tmpvar_61 * 0.7151522)) + (tmpvar_62 * 0.072175));
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_60 * 0.0193339)
   + 
    (tmpvar_61 * 0.119192)
  ) + (tmpvar_62 * 0.9503041)) / 1.088754);
  highp float tmpvar_66;
  if ((tmpvar_63 > 0.008856)) {
    tmpvar_66 = pow (tmpvar_63, 0.3333333);
  } else {
    tmpvar_66 = (((903.3 * tmpvar_63) + 16.0) / 116.0);
  };
  highp float tmpvar_67;
  if ((tmpvar_64 > 0.008856)) {
    tmpvar_67 = pow (tmpvar_64, 0.3333333);
  } else {
    tmpvar_67 = (((903.3 * tmpvar_64) + 16.0) / 116.0);
  };
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_69;
  tmpvar_69.x = (((116.0 * tmpvar_67) - 16.0) / 100.0);
  tmpvar_69.y = (((500.0 * 
    (tmpvar_66 - tmpvar_67)
  ) + 110.0) / 220.0);
  tmpvar_69.z = (((200.0 * 
    (tmpvar_67 - tmpvar_68)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_70;
  tmpvar_70 = (tmpvar_69 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_71;
  if ((color_10.x > 0.04045)) {
    tmpvar_71 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_71 = (color_10.x / 12.92);
  };
  highp float tmpvar_72;
  if ((color_10.y > 0.04045)) {
    tmpvar_72 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (color_10.y / 12.92);
  };
  highp float tmpvar_73;
  if ((color_10.z > 0.04045)) {
    tmpvar_73 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_73 = (color_10.z / 12.92);
  };
  highp float tmpvar_74;
  tmpvar_74 = (((
    (tmpvar_71 * 0.4124564)
   + 
    (tmpvar_72 * 0.3575761)
  ) + (tmpvar_73 * 0.1804375)) / 0.950456);
  highp float tmpvar_75;
  tmpvar_75 = (((tmpvar_71 * 0.2126729) + (tmpvar_72 * 0.7151522)) + (tmpvar_73 * 0.072175));
  highp float tmpvar_76;
  tmpvar_76 = (((
    (tmpvar_71 * 0.0193339)
   + 
    (tmpvar_72 * 0.119192)
  ) + (tmpvar_73 * 0.9503041)) / 1.088754);
  highp float tmpvar_77;
  if ((tmpvar_74 > 0.008856)) {
    tmpvar_77 = pow (tmpvar_74, 0.3333333);
  } else {
    tmpvar_77 = (((903.3 * tmpvar_74) + 16.0) / 116.0);
  };
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp float tmpvar_79;
  if ((tmpvar_76 > 0.008856)) {
    tmpvar_79 = pow (tmpvar_76, 0.3333333);
  } else {
    tmpvar_79 = (((903.3 * tmpvar_76) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_80;
  tmpvar_80.x = (((116.0 * tmpvar_78) - 16.0) / 100.0);
  tmpvar_80.y = (((500.0 * 
    (tmpvar_77 - tmpvar_78)
  ) + 110.0) / 220.0);
  tmpvar_80.z = (((200.0 * 
    (tmpvar_78 - tmpvar_79)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_81;
  tmpvar_81 = clamp ((tmpvar_80 + tmpvar_70), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_82;
  highp float x_83;
  highp float tmpvar_84;
  tmpvar_84 = (((tmpvar_81.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_81.y * 220.0)
   - 110.0) / 500.0) + tmpvar_84);
  x_83 = tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = (tmpvar_84 - ((
    (tmpvar_81.z * 220.0)
   - 110.0) / 200.0));
  z_82 = tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = pow (tmpvar_85, 3.0);
  highp float tmpvar_88;
  tmpvar_88 = pow (tmpvar_84, 3.0);
  highp float tmpvar_89;
  tmpvar_89 = pow (tmpvar_86, 3.0);
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = tmpvar_87;
  } else {
    tmpvar_90 = ((tmpvar_85 - 0.137931) / 7.787069);
  };
  x_83 = (tmpvar_90 * 0.950456);
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = tmpvar_88;
  } else {
    tmpvar_91 = ((tmpvar_84 - 0.137931) / 7.787069);
  };
  highp float tmpvar_92;
  if ((tmpvar_89 > 0.008856)) {
    tmpvar_92 = tmpvar_89;
  } else {
    tmpvar_92 = ((tmpvar_86 - 0.137931) / 7.787069);
  };
  z_82 = (tmpvar_92 * 1.088754);
  highp float tmpvar_93;
  tmpvar_93 = (((x_83 * 3.240454) + (tmpvar_91 * -1.537138)) + (z_82 * -0.4985314));
  highp float tmpvar_94;
  tmpvar_94 = (((x_83 * -0.969266) + (tmpvar_91 * 1.876011)) + (z_82 * 0.041556));
  highp float tmpvar_95;
  tmpvar_95 = (((x_83 * 0.0556434) + (tmpvar_91 * -0.2040259)) + (z_82 * 1.057225));
  highp float tmpvar_96;
  if ((tmpvar_93 > 0.0031308)) {
    tmpvar_96 = ((1.055 * pow (tmpvar_93, 0.4166667)) - 0.055);
  } else {
    tmpvar_96 = (12.92 * tmpvar_93);
  };
  highp float tmpvar_97;
  if ((tmpvar_94 > 0.0031308)) {
    tmpvar_97 = ((1.055 * pow (tmpvar_94, 0.4166667)) - 0.055);
  } else {
    tmpvar_97 = (12.92 * tmpvar_94);
  };
  highp float tmpvar_98;
  if ((tmpvar_95 > 0.0031308)) {
    tmpvar_98 = ((1.055 * pow (tmpvar_95, 0.4166667)) - 0.055);
  } else {
    tmpvar_98 = (12.92 * tmpvar_95);
  };
  highp vec3 tmpvar_99;
  tmpvar_99.x = tmpvar_96;
  tmpvar_99.y = tmpvar_97;
  tmpvar_99.z = tmpvar_98;
  lowp vec3 tmpvar_100;
  tmpvar_100 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_101;
  tmpvar_101 = mix (color_10.xyz, tmpvar_99, tmpvar_100);
  mainColor_9 = (tmpvar_101 * tmpvar_101);
  lowp vec3 tmpvar_102;
  tmpvar_102 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_102;
  highp vec4 tmpvar_103;
  tmpvar_103.w = 0.0;
  tmpvar_103.xyz = mainColor_9;
  highp vec4 tmpvar_104;
  tmpvar_104.w = 0.0;
  tmpvar_104.xyz = mainColor_9;
  highp vec4 tmpvar_105;
  tmpvar_105.w = 0.0;
  tmpvar_105.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_103, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_104, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_105, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_106;
  tmpvar_106 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_106;
  highp float tmpvar_107;
  tmpvar_107 = (1.0 - specular_7.x);
  highp vec2 tmpvar_108;
  tmpvar_108.x = (((
    dot (tmpvar_53, tmpvar_54)
   * 0.5) + 0.5) * 0.99);
  tmpvar_108.y = specular_7.y;
  lowp vec3 tmpvar_109;
  tmpvar_109 = texture (TexBRDF, tmpvar_108).xyz;
  brdfColor_6 = tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = max (((
    dot (tmpvar_53, tmpvar_55)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_110 * tmpvar_110);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_111;
  I_111 = -(tmpvar_50);
  reflectDir_3.xyz = (I_111 - (2.0 * (
    dot (tmpvar_53, I_111)
   * tmpvar_53)));
  reflectDir_3.w = (tmpvar_107 * 4.0);
  lowp vec4 tmpvar_112;
  tmpvar_112 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_113;
  tmpvar_113 = tmpvar_112;
  iblColor_2.w = tmpvar_113.w;
  iblColor_2.xyz = ((tmpvar_113.xyz * tmpvar_113.w) * 4.0);
  highp float tmpvar_114;
  tmpvar_114 = max ((tmpvar_107 * tmpvar_107), 0.1);
  highp float tmpvar_115;
  tmpvar_115 = (tmpvar_114 * tmpvar_114);
  highp float tmpvar_116;
  tmpvar_116 = (((
    (tmpvar_57 * tmpvar_115)
   - tmpvar_57) * tmpvar_57) + 1.0);
  d_1 = ((0.3183099 * tmpvar_115) / ((tmpvar_116 * tmpvar_116) + 1e-7));
  highp float tmpvar_117;
  tmpvar_117 = min (d_1, 100.0);
  d_1 = tmpvar_117;
  highp vec4 tmpvar_118;
  tmpvar_118.xyz = (((
    ((tmpvar_117 * mix (1.5, 1.0, (1.0 - tmpvar_56))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_56), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (vec3(0.855, 0.502, 0.502), brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_56, (1.0 - specular_7.z))
  ))));
  tmpvar_118.w = tmpvar_59;
  _glesFragData[0] = tmpvar_118;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2(2048.0, 2048.0));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec3 tmpvar_51;
  tmpvar_51 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(((
    (tmpvar_52.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_52.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_52.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(LightDir);
  highp float tmpvar_56;
  tmpvar_56 = max (dot (tmpvar_53, tmpvar_50), 0.0);
  highp float tmpvar_57;
  tmpvar_57 = max (dot (tmpvar_53, normalize(
    (tmpvar_50 + tmpvar_54)
  )), 0.0);
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_58;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_59;
  tmpvar_59 = color_10.w;
  highp float tmpvar_60;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_60 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_60 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_61;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_61 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_61 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_62;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_62 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_60 * 0.4124564)
   + 
    (tmpvar_61 * 0.3575761)
  ) + (tmpvar_62 * 0.1804375)) / 0.950456);
  highp float tmpvar_64;
  tmpvar_64 = (((tmpvar_60 * 0.2126729) + (tmpvar_61 * 0.7151522)) + (tmpvar_62 * 0.072175));
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_60 * 0.0193339)
   + 
    (tmpvar_61 * 0.119192)
  ) + (tmpvar_62 * 0.9503041)) / 1.088754);
  highp float tmpvar_66;
  if ((tmpvar_63 > 0.008856)) {
    tmpvar_66 = pow (tmpvar_63, 0.3333333);
  } else {
    tmpvar_66 = (((903.3 * tmpvar_63) + 16.0) / 116.0);
  };
  highp float tmpvar_67;
  if ((tmpvar_64 > 0.008856)) {
    tmpvar_67 = pow (tmpvar_64, 0.3333333);
  } else {
    tmpvar_67 = (((903.3 * tmpvar_64) + 16.0) / 116.0);
  };
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_69;
  tmpvar_69.x = (((116.0 * tmpvar_67) - 16.0) / 100.0);
  tmpvar_69.y = (((500.0 * 
    (tmpvar_66 - tmpvar_67)
  ) + 110.0) / 220.0);
  tmpvar_69.z = (((200.0 * 
    (tmpvar_67 - tmpvar_68)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_70;
  tmpvar_70 = (tmpvar_69 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_71;
  if ((color_10.x > 0.04045)) {
    tmpvar_71 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_71 = (color_10.x / 12.92);
  };
  highp float tmpvar_72;
  if ((color_10.y > 0.04045)) {
    tmpvar_72 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (color_10.y / 12.92);
  };
  highp float tmpvar_73;
  if ((color_10.z > 0.04045)) {
    tmpvar_73 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_73 = (color_10.z / 12.92);
  };
  highp float tmpvar_74;
  tmpvar_74 = (((
    (tmpvar_71 * 0.4124564)
   + 
    (tmpvar_72 * 0.3575761)
  ) + (tmpvar_73 * 0.1804375)) / 0.950456);
  highp float tmpvar_75;
  tmpvar_75 = (((tmpvar_71 * 0.2126729) + (tmpvar_72 * 0.7151522)) + (tmpvar_73 * 0.072175));
  highp float tmpvar_76;
  tmpvar_76 = (((
    (tmpvar_71 * 0.0193339)
   + 
    (tmpvar_72 * 0.119192)
  ) + (tmpvar_73 * 0.9503041)) / 1.088754);
  highp float tmpvar_77;
  if ((tmpvar_74 > 0.008856)) {
    tmpvar_77 = pow (tmpvar_74, 0.3333333);
  } else {
    tmpvar_77 = (((903.3 * tmpvar_74) + 16.0) / 116.0);
  };
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp float tmpvar_79;
  if ((tmpvar_76 > 0.008856)) {
    tmpvar_79 = pow (tmpvar_76, 0.3333333);
  } else {
    tmpvar_79 = (((903.3 * tmpvar_76) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_80;
  tmpvar_80.x = (((116.0 * tmpvar_78) - 16.0) / 100.0);
  tmpvar_80.y = (((500.0 * 
    (tmpvar_77 - tmpvar_78)
  ) + 110.0) / 220.0);
  tmpvar_80.z = (((200.0 * 
    (tmpvar_78 - tmpvar_79)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_81;
  tmpvar_81 = clamp ((tmpvar_80 + tmpvar_70), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_82;
  highp float x_83;
  highp float tmpvar_84;
  tmpvar_84 = (((tmpvar_81.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_81.y * 220.0)
   - 110.0) / 500.0) + tmpvar_84);
  x_83 = tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = (tmpvar_84 - ((
    (tmpvar_81.z * 220.0)
   - 110.0) / 200.0));
  z_82 = tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = pow (tmpvar_85, 3.0);
  highp float tmpvar_88;
  tmpvar_88 = pow (tmpvar_84, 3.0);
  highp float tmpvar_89;
  tmpvar_89 = pow (tmpvar_86, 3.0);
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = tmpvar_87;
  } else {
    tmpvar_90 = ((tmpvar_85 - 0.137931) / 7.787069);
  };
  x_83 = (tmpvar_90 * 0.950456);
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = tmpvar_88;
  } else {
    tmpvar_91 = ((tmpvar_84 - 0.137931) / 7.787069);
  };
  highp float tmpvar_92;
  if ((tmpvar_89 > 0.008856)) {
    tmpvar_92 = tmpvar_89;
  } else {
    tmpvar_92 = ((tmpvar_86 - 0.137931) / 7.787069);
  };
  z_82 = (tmpvar_92 * 1.088754);
  highp float tmpvar_93;
  tmpvar_93 = (((x_83 * 3.240454) + (tmpvar_91 * -1.537138)) + (z_82 * -0.4985314));
  highp float tmpvar_94;
  tmpvar_94 = (((x_83 * -0.969266) + (tmpvar_91 * 1.876011)) + (z_82 * 0.041556));
  highp float tmpvar_95;
  tmpvar_95 = (((x_83 * 0.0556434) + (tmpvar_91 * -0.2040259)) + (z_82 * 1.057225));
  highp float tmpvar_96;
  if ((tmpvar_93 > 0.0031308)) {
    tmpvar_96 = ((1.055 * pow (tmpvar_93, 0.4166667)) - 0.055);
  } else {
    tmpvar_96 = (12.92 * tmpvar_93);
  };
  highp float tmpvar_97;
  if ((tmpvar_94 > 0.0031308)) {
    tmpvar_97 = ((1.055 * pow (tmpvar_94, 0.4166667)) - 0.055);
  } else {
    tmpvar_97 = (12.92 * tmpvar_94);
  };
  highp float tmpvar_98;
  if ((tmpvar_95 > 0.0031308)) {
    tmpvar_98 = ((1.055 * pow (tmpvar_95, 0.4166667)) - 0.055);
  } else {
    tmpvar_98 = (12.92 * tmpvar_95);
  };
  highp vec3 tmpvar_99;
  tmpvar_99.x = tmpvar_96;
  tmpvar_99.y = tmpvar_97;
  tmpvar_99.z = tmpvar_98;
  lowp vec3 tmpvar_100;
  tmpvar_100 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_101;
  tmpvar_101 = mix (color_10.xyz, tmpvar_99, tmpvar_100);
  mainColor_9 = (tmpvar_101 * tmpvar_101);
  lowp vec3 tmpvar_102;
  tmpvar_102 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_102;
  highp vec4 tmpvar_103;
  tmpvar_103.w = 0.0;
  tmpvar_103.xyz = mainColor_9;
  highp vec4 tmpvar_104;
  tmpvar_104.w = 0.0;
  tmpvar_104.xyz = mainColor_9;
  highp vec4 tmpvar_105;
  tmpvar_105.w = 0.0;
  tmpvar_105.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_103, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_104, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_105, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_106;
  tmpvar_106 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_106;
  highp float tmpvar_107;
  tmpvar_107 = (1.0 - specular_7.x);
  highp vec2 tmpvar_108;
  tmpvar_108.x = (((
    dot (tmpvar_53, tmpvar_54)
   * 0.5) + 0.5) * 0.99);
  tmpvar_108.y = specular_7.y;
  lowp vec3 tmpvar_109;
  tmpvar_109 = texture (TexBRDF, tmpvar_108).xyz;
  brdfColor_6 = tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = max (((
    dot (tmpvar_53, tmpvar_55)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_110 * tmpvar_110);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_111;
  I_111 = -(tmpvar_50);
  reflectDir_3.xyz = (I_111 - (2.0 * (
    dot (tmpvar_53, I_111)
   * tmpvar_53)));
  reflectDir_3.w = (tmpvar_107 * 4.0);
  lowp vec4 tmpvar_112;
  tmpvar_112 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_113;
  tmpvar_113 = tmpvar_112;
  iblColor_2.w = tmpvar_113.w;
  iblColor_2.xyz = ((tmpvar_113.xyz * tmpvar_113.w) * 4.0);
  highp float tmpvar_114;
  tmpvar_114 = max ((tmpvar_107 * tmpvar_107), 0.1);
  highp float tmpvar_115;
  tmpvar_115 = (tmpvar_114 * tmpvar_114);
  highp float tmpvar_116;
  tmpvar_116 = (((
    (tmpvar_57 * tmpvar_115)
   - tmpvar_57) * tmpvar_57) + 1.0);
  d_1 = ((0.3183099 * tmpvar_115) / ((tmpvar_116 * tmpvar_116) + 1e-7));
  highp float tmpvar_117;
  tmpvar_117 = min (d_1, 100.0);
  d_1 = tmpvar_117;
  highp vec4 tmpvar_118;
  tmpvar_118.xyz = (((
    ((tmpvar_117 * mix (1.5, 1.0, (1.0 - tmpvar_56))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_56), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (vec3(0.855, 0.502, 0.502), brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_56, (1.0 - specular_7.z))
  ))));
  tmpvar_118.w = tmpvar_59;
  _glesFragData[0] = tmpvar_118;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2(2048.0, 2048.0));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec3 tmpvar_51;
  tmpvar_51 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(((
    (tmpvar_52.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_52.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_52.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(LightDir);
  highp float tmpvar_56;
  tmpvar_56 = max (dot (tmpvar_53, tmpvar_50), 0.0);
  highp float tmpvar_57;
  tmpvar_57 = max (dot (tmpvar_53, normalize(
    (tmpvar_50 + tmpvar_54)
  )), 0.0);
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_58;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_59;
  tmpvar_59 = color_10.w;
  highp float tmpvar_60;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_60 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_60 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_61;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_61 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_61 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_62;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_62 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_60 * 0.4124564)
   + 
    (tmpvar_61 * 0.3575761)
  ) + (tmpvar_62 * 0.1804375)) / 0.950456);
  highp float tmpvar_64;
  tmpvar_64 = (((tmpvar_60 * 0.2126729) + (tmpvar_61 * 0.7151522)) + (tmpvar_62 * 0.072175));
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_60 * 0.0193339)
   + 
    (tmpvar_61 * 0.119192)
  ) + (tmpvar_62 * 0.9503041)) / 1.088754);
  highp float tmpvar_66;
  if ((tmpvar_63 > 0.008856)) {
    tmpvar_66 = pow (tmpvar_63, 0.3333333);
  } else {
    tmpvar_66 = (((903.3 * tmpvar_63) + 16.0) / 116.0);
  };
  highp float tmpvar_67;
  if ((tmpvar_64 > 0.008856)) {
    tmpvar_67 = pow (tmpvar_64, 0.3333333);
  } else {
    tmpvar_67 = (((903.3 * tmpvar_64) + 16.0) / 116.0);
  };
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_69;
  tmpvar_69.x = (((116.0 * tmpvar_67) - 16.0) / 100.0);
  tmpvar_69.y = (((500.0 * 
    (tmpvar_66 - tmpvar_67)
  ) + 110.0) / 220.0);
  tmpvar_69.z = (((200.0 * 
    (tmpvar_67 - tmpvar_68)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_70;
  tmpvar_70 = (tmpvar_69 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_71;
  if ((color_10.x > 0.04045)) {
    tmpvar_71 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_71 = (color_10.x / 12.92);
  };
  highp float tmpvar_72;
  if ((color_10.y > 0.04045)) {
    tmpvar_72 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (color_10.y / 12.92);
  };
  highp float tmpvar_73;
  if ((color_10.z > 0.04045)) {
    tmpvar_73 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_73 = (color_10.z / 12.92);
  };
  highp float tmpvar_74;
  tmpvar_74 = (((
    (tmpvar_71 * 0.4124564)
   + 
    (tmpvar_72 * 0.3575761)
  ) + (tmpvar_73 * 0.1804375)) / 0.950456);
  highp float tmpvar_75;
  tmpvar_75 = (((tmpvar_71 * 0.2126729) + (tmpvar_72 * 0.7151522)) + (tmpvar_73 * 0.072175));
  highp float tmpvar_76;
  tmpvar_76 = (((
    (tmpvar_71 * 0.0193339)
   + 
    (tmpvar_72 * 0.119192)
  ) + (tmpvar_73 * 0.9503041)) / 1.088754);
  highp float tmpvar_77;
  if ((tmpvar_74 > 0.008856)) {
    tmpvar_77 = pow (tmpvar_74, 0.3333333);
  } else {
    tmpvar_77 = (((903.3 * tmpvar_74) + 16.0) / 116.0);
  };
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp float tmpvar_79;
  if ((tmpvar_76 > 0.008856)) {
    tmpvar_79 = pow (tmpvar_76, 0.3333333);
  } else {
    tmpvar_79 = (((903.3 * tmpvar_76) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_80;
  tmpvar_80.x = (((116.0 * tmpvar_78) - 16.0) / 100.0);
  tmpvar_80.y = (((500.0 * 
    (tmpvar_77 - tmpvar_78)
  ) + 110.0) / 220.0);
  tmpvar_80.z = (((200.0 * 
    (tmpvar_78 - tmpvar_79)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_81;
  tmpvar_81 = clamp ((tmpvar_80 + tmpvar_70), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_82;
  highp float x_83;
  highp float tmpvar_84;
  tmpvar_84 = (((tmpvar_81.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_81.y * 220.0)
   - 110.0) / 500.0) + tmpvar_84);
  x_83 = tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = (tmpvar_84 - ((
    (tmpvar_81.z * 220.0)
   - 110.0) / 200.0));
  z_82 = tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = pow (tmpvar_85, 3.0);
  highp float tmpvar_88;
  tmpvar_88 = pow (tmpvar_84, 3.0);
  highp float tmpvar_89;
  tmpvar_89 = pow (tmpvar_86, 3.0);
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = tmpvar_87;
  } else {
    tmpvar_90 = ((tmpvar_85 - 0.137931) / 7.787069);
  };
  x_83 = (tmpvar_90 * 0.950456);
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = tmpvar_88;
  } else {
    tmpvar_91 = ((tmpvar_84 - 0.137931) / 7.787069);
  };
  highp float tmpvar_92;
  if ((tmpvar_89 > 0.008856)) {
    tmpvar_92 = tmpvar_89;
  } else {
    tmpvar_92 = ((tmpvar_86 - 0.137931) / 7.787069);
  };
  z_82 = (tmpvar_92 * 1.088754);
  highp float tmpvar_93;
  tmpvar_93 = (((x_83 * 3.240454) + (tmpvar_91 * -1.537138)) + (z_82 * -0.4985314));
  highp float tmpvar_94;
  tmpvar_94 = (((x_83 * -0.969266) + (tmpvar_91 * 1.876011)) + (z_82 * 0.041556));
  highp float tmpvar_95;
  tmpvar_95 = (((x_83 * 0.0556434) + (tmpvar_91 * -0.2040259)) + (z_82 * 1.057225));
  highp float tmpvar_96;
  if ((tmpvar_93 > 0.0031308)) {
    tmpvar_96 = ((1.055 * pow (tmpvar_93, 0.4166667)) - 0.055);
  } else {
    tmpvar_96 = (12.92 * tmpvar_93);
  };
  highp float tmpvar_97;
  if ((tmpvar_94 > 0.0031308)) {
    tmpvar_97 = ((1.055 * pow (tmpvar_94, 0.4166667)) - 0.055);
  } else {
    tmpvar_97 = (12.92 * tmpvar_94);
  };
  highp float tmpvar_98;
  if ((tmpvar_95 > 0.0031308)) {
    tmpvar_98 = ((1.055 * pow (tmpvar_95, 0.4166667)) - 0.055);
  } else {
    tmpvar_98 = (12.92 * tmpvar_95);
  };
  highp vec3 tmpvar_99;
  tmpvar_99.x = tmpvar_96;
  tmpvar_99.y = tmpvar_97;
  tmpvar_99.z = tmpvar_98;
  lowp vec3 tmpvar_100;
  tmpvar_100 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_101;
  tmpvar_101 = mix (color_10.xyz, tmpvar_99, tmpvar_100);
  mainColor_9 = (tmpvar_101 * tmpvar_101);
  lowp vec3 tmpvar_102;
  tmpvar_102 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_102;
  highp vec4 tmpvar_103;
  tmpvar_103.w = 0.0;
  tmpvar_103.xyz = mainColor_9;
  highp vec4 tmpvar_104;
  tmpvar_104.w = 0.0;
  tmpvar_104.xyz = mainColor_9;
  highp vec4 tmpvar_105;
  tmpvar_105.w = 0.0;
  tmpvar_105.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_103, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_104, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_105, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_106;
  tmpvar_106 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_106;
  highp float tmpvar_107;
  tmpvar_107 = (1.0 - specular_7.x);
  highp vec2 tmpvar_108;
  tmpvar_108.x = (((
    dot (tmpvar_53, tmpvar_54)
   * 0.5) + 0.5) * 0.99);
  tmpvar_108.y = specular_7.y;
  lowp vec3 tmpvar_109;
  tmpvar_109 = texture (TexBRDF, tmpvar_108).xyz;
  brdfColor_6 = tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = max (((
    dot (tmpvar_53, tmpvar_55)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_110 * tmpvar_110);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_111;
  I_111 = -(tmpvar_50);
  reflectDir_3.xyz = (I_111 - (2.0 * (
    dot (tmpvar_53, I_111)
   * tmpvar_53)));
  reflectDir_3.w = (tmpvar_107 * 4.0);
  lowp vec4 tmpvar_112;
  tmpvar_112 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_113;
  tmpvar_113 = tmpvar_112;
  iblColor_2.w = tmpvar_113.w;
  iblColor_2.xyz = ((tmpvar_113.xyz * tmpvar_113.w) * 4.0);
  highp float tmpvar_114;
  tmpvar_114 = max ((tmpvar_107 * tmpvar_107), 0.1);
  highp float tmpvar_115;
  tmpvar_115 = (tmpvar_114 * tmpvar_114);
  highp float tmpvar_116;
  tmpvar_116 = (((
    (tmpvar_57 * tmpvar_115)
   - tmpvar_57) * tmpvar_57) + 1.0);
  d_1 = ((0.3183099 * tmpvar_115) / ((tmpvar_116 * tmpvar_116) + 1e-7));
  highp float tmpvar_117;
  tmpvar_117 = min (d_1, 100.0);
  d_1 = tmpvar_117;
  highp vec4 tmpvar_118;
  tmpvar_118.xyz = (((
    ((tmpvar_117 * mix (1.5, 1.0, (1.0 - tmpvar_56))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_56), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (vec3(0.855, 0.502, 0.502), brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_56, (1.0 - specular_7.z))
  ))));
  tmpvar_118.w = tmpvar_59;
  _glesFragData[0] = tmpvar_118;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp vec3 LightDir;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    shadow_16 = 1.0;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2(2048.0, 2048.0));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * vec2(0.0004882813, 0.0004882813));
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_15.y;
    tmpvar_41.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_36 + tmpvar_41);
    tmpvar_42.z = shadowCoord_12.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_44));
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_15.x;
    tmpvar_45.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_36 + tmpvar_45);
    tmpvar_46.z = shadowCoord_12.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_48));
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_15.y;
    tmpvar_49.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_36 + tmpvar_49);
    tmpvar_50.z = shadowCoord_12.z;
    highp vec4 tmpvar_51;
    tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50.xy);
    highp float tmpvar_52;
    if ((tmpvar_51.x < xlv_TEXCOORD4.z)) {
      tmpvar_52 = 0.0;
    } else {
      tmpvar_52 = 1.0;
    };
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_52));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  tmpvar_53.x = xlv_TEXCOORD1.w;
  tmpvar_53.y = xlv_TEXCOORD2.w;
  tmpvar_53.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_54;
  tmpvar_54 = normalize((CAMERA_WORLDPOSITION - tmpvar_53));
  lowp vec3 tmpvar_55;
  tmpvar_55 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_56 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_57;
  tmpvar_57 = normalize(((
    (tmpvar_56.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_56.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_56.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_58;
  tmpvar_58 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_59;
  tmpvar_59 = normalize(LightDir);
  highp float tmpvar_60;
  tmpvar_60 = max (dot (tmpvar_57, tmpvar_54), 0.0);
  highp float tmpvar_61;
  tmpvar_61 = max (dot (tmpvar_57, normalize(
    (tmpvar_54 + tmpvar_58)
  )), 0.0);
  lowp vec4 tmpvar_62;
  tmpvar_62 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_62;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_63;
  tmpvar_63 = color_10.w;
  highp float tmpvar_64;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_64 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_64 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_65;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_65 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_65 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_66;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_66 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_66 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_67;
  tmpvar_67 = (((
    (tmpvar_64 * 0.4124564)
   + 
    (tmpvar_65 * 0.3575761)
  ) + (tmpvar_66 * 0.1804375)) / 0.950456);
  highp float tmpvar_68;
  tmpvar_68 = (((tmpvar_64 * 0.2126729) + (tmpvar_65 * 0.7151522)) + (tmpvar_66 * 0.072175));
  highp float tmpvar_69;
  tmpvar_69 = (((
    (tmpvar_64 * 0.0193339)
   + 
    (tmpvar_65 * 0.119192)
  ) + (tmpvar_66 * 0.9503041)) / 1.088754);
  highp float tmpvar_70;
  if ((tmpvar_67 > 0.008856)) {
    tmpvar_70 = pow (tmpvar_67, 0.3333333);
  } else {
    tmpvar_70 = (((903.3 * tmpvar_67) + 16.0) / 116.0);
  };
  highp float tmpvar_71;
  if ((tmpvar_68 > 0.008856)) {
    tmpvar_71 = pow (tmpvar_68, 0.3333333);
  } else {
    tmpvar_71 = (((903.3 * tmpvar_68) + 16.0) / 116.0);
  };
  highp float tmpvar_72;
  if ((tmpvar_69 > 0.008856)) {
    tmpvar_72 = pow (tmpvar_69, 0.3333333);
  } else {
    tmpvar_72 = (((903.3 * tmpvar_69) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_73;
  tmpvar_73.x = (((116.0 * tmpvar_71) - 16.0) / 100.0);
  tmpvar_73.y = (((500.0 * 
    (tmpvar_70 - tmpvar_71)
  ) + 110.0) / 220.0);
  tmpvar_73.z = (((200.0 * 
    (tmpvar_71 - tmpvar_72)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_74;
  tmpvar_74 = (tmpvar_73 - vec3(0.697982, 0.5643878, 0.5560098));
  highp float tmpvar_75;
  if ((color_10.x > 0.04045)) {
    tmpvar_75 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_75 = (color_10.x / 12.92);
  };
  highp float tmpvar_76;
  if ((color_10.y > 0.04045)) {
    tmpvar_76 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_76 = (color_10.y / 12.92);
  };
  highp float tmpvar_77;
  if ((color_10.z > 0.04045)) {
    tmpvar_77 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_77 = (color_10.z / 12.92);
  };
  highp float tmpvar_78;
  tmpvar_78 = (((
    (tmpvar_75 * 0.4124564)
   + 
    (tmpvar_76 * 0.3575761)
  ) + (tmpvar_77 * 0.1804375)) / 0.950456);
  highp float tmpvar_79;
  tmpvar_79 = (((tmpvar_75 * 0.2126729) + (tmpvar_76 * 0.7151522)) + (tmpvar_77 * 0.072175));
  highp float tmpvar_80;
  tmpvar_80 = (((
    (tmpvar_75 * 0.0193339)
   + 
    (tmpvar_76 * 0.119192)
  ) + (tmpvar_77 * 0.9503041)) / 1.088754);
  highp float tmpvar_81;
  if ((tmpvar_78 > 0.008856)) {
    tmpvar_81 = pow (tmpvar_78, 0.3333333);
  } else {
    tmpvar_81 = (((903.3 * tmpvar_78) + 16.0) / 116.0);
  };
  highp float tmpvar_82;
  if ((tmpvar_79 > 0.008856)) {
    tmpvar_82 = pow (tmpvar_79, 0.3333333);
  } else {
    tmpvar_82 = (((903.3 * tmpvar_79) + 16.0) / 116.0);
  };
  highp float tmpvar_83;
  if ((tmpvar_80 > 0.008856)) {
    tmpvar_83 = pow (tmpvar_80, 0.3333333);
  } else {
    tmpvar_83 = (((903.3 * tmpvar_80) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_84;
  tmpvar_84.x = (((116.0 * tmpvar_82) - 16.0) / 100.0);
  tmpvar_84.y = (((500.0 * 
    (tmpvar_81 - tmpvar_82)
  ) + 110.0) / 220.0);
  tmpvar_84.z = (((200.0 * 
    (tmpvar_82 - tmpvar_83)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_85;
  tmpvar_85 = clamp ((tmpvar_84 + tmpvar_74), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_86;
  highp float x_87;
  highp float tmpvar_88;
  tmpvar_88 = (((tmpvar_85.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_89;
  tmpvar_89 = (((
    (tmpvar_85.y * 220.0)
   - 110.0) / 500.0) + tmpvar_88);
  x_87 = tmpvar_89;
  highp float tmpvar_90;
  tmpvar_90 = (tmpvar_88 - ((
    (tmpvar_85.z * 220.0)
   - 110.0) / 200.0));
  z_86 = tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = pow (tmpvar_89, 3.0);
  highp float tmpvar_92;
  tmpvar_92 = pow (tmpvar_88, 3.0);
  highp float tmpvar_93;
  tmpvar_93 = pow (tmpvar_90, 3.0);
  highp float tmpvar_94;
  if ((tmpvar_91 > 0.008856)) {
    tmpvar_94 = tmpvar_91;
  } else {
    tmpvar_94 = ((tmpvar_89 - 0.137931) / 7.787069);
  };
  x_87 = (tmpvar_94 * 0.950456);
  highp float tmpvar_95;
  if ((tmpvar_92 > 0.008856)) {
    tmpvar_95 = tmpvar_92;
  } else {
    tmpvar_95 = ((tmpvar_88 - 0.137931) / 7.787069);
  };
  highp float tmpvar_96;
  if ((tmpvar_93 > 0.008856)) {
    tmpvar_96 = tmpvar_93;
  } else {
    tmpvar_96 = ((tmpvar_90 - 0.137931) / 7.787069);
  };
  z_86 = (tmpvar_96 * 1.088754);
  highp float tmpvar_97;
  tmpvar_97 = (((x_87 * 3.240454) + (tmpvar_95 * -1.537138)) + (z_86 * -0.4985314));
  highp float tmpvar_98;
  tmpvar_98 = (((x_87 * -0.969266) + (tmpvar_95 * 1.876011)) + (z_86 * 0.041556));
  highp float tmpvar_99;
  tmpvar_99 = (((x_87 * 0.0556434) + (tmpvar_95 * -0.2040259)) + (z_86 * 1.057225));
  highp float tmpvar_100;
  if ((tmpvar_97 > 0.0031308)) {
    tmpvar_100 = ((1.055 * pow (tmpvar_97, 0.4166667)) - 0.055);
  } else {
    tmpvar_100 = (12.92 * tmpvar_97);
  };
  highp float tmpvar_101;
  if ((tmpvar_98 > 0.0031308)) {
    tmpvar_101 = ((1.055 * pow (tmpvar_98, 0.4166667)) - 0.055);
  } else {
    tmpvar_101 = (12.92 * tmpvar_98);
  };
  highp float tmpvar_102;
  if ((tmpvar_99 > 0.0031308)) {
    tmpvar_102 = ((1.055 * pow (tmpvar_99, 0.4166667)) - 0.055);
  } else {
    tmpvar_102 = (12.92 * tmpvar_99);
  };
  highp vec3 tmpvar_103;
  tmpvar_103.x = tmpvar_100;
  tmpvar_103.y = tmpvar_101;
  tmpvar_103.z = tmpvar_102;
  lowp vec3 tmpvar_104;
  tmpvar_104 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_105;
  tmpvar_105 = mix (color_10.xyz, tmpvar_103, tmpvar_104);
  mainColor_9 = (tmpvar_105 * tmpvar_105);
  lowp vec3 tmpvar_106;
  tmpvar_106 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_106;
  highp vec4 tmpvar_107;
  tmpvar_107.w = 0.0;
  tmpvar_107.xyz = mainColor_9;
  highp vec4 tmpvar_108;
  tmpvar_108.w = 0.0;
  tmpvar_108.xyz = mainColor_9;
  highp vec4 tmpvar_109;
  tmpvar_109.w = 0.0;
  tmpvar_109.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_107, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_108, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_109, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_110;
  tmpvar_110 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_110;
  highp float tmpvar_111;
  tmpvar_111 = (1.0 - specular_7.x);
  highp vec2 tmpvar_112;
  tmpvar_112.x = (((
    dot (tmpvar_57, tmpvar_58)
   * 0.5) + 0.5) * 0.99);
  tmpvar_112.y = specular_7.y;
  lowp vec3 tmpvar_113;
  tmpvar_113 = texture (TexBRDF, tmpvar_112).xyz;
  brdfColor_6 = tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = max (((
    dot (tmpvar_57, tmpvar_59)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_114 * tmpvar_114);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * vec3(0.314, 0.314, 0.314)) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_115;
  I_115 = -(tmpvar_54);
  reflectDir_3.xyz = (I_115 - (2.0 * (
    dot (tmpvar_57, I_115)
   * tmpvar_57)));
  reflectDir_3.w = (tmpvar_111 * 4.0);
  lowp vec4 tmpvar_116;
  tmpvar_116 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_117;
  tmpvar_117 = tmpvar_116;
  iblColor_2.w = tmpvar_117.w;
  iblColor_2.xyz = ((tmpvar_117.xyz * tmpvar_117.w) * 4.0);
  highp float tmpvar_118;
  tmpvar_118 = max ((tmpvar_111 * tmpvar_111), 0.1);
  highp float tmpvar_119;
  tmpvar_119 = (tmpvar_118 * tmpvar_118);
  highp float tmpvar_120;
  tmpvar_120 = (((
    (tmpvar_61 * tmpvar_119)
   - tmpvar_61) * tmpvar_61) + 1.0);
  d_1 = ((0.3183099 * tmpvar_119) / ((tmpvar_120 * tmpvar_120) + 1e-7));
  highp float tmpvar_121;
  tmpvar_121 = min (d_1, 100.0);
  d_1 = tmpvar_121;
  highp vec4 tmpvar_122;
  tmpvar_122.xyz = (((
    ((tmpvar_121 * mix (1.5, 1.0, (1.0 - tmpvar_60))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((-0.5 * 
      pow ((1.0 - tmpvar_60), 4.0)
    ) + 1.5)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (vec3(0.855, 0.502, 0.502), brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (vec3(0.839, 0.475, 0.475), vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_60, (1.0 - specular_7.z))
  ))));
  tmpvar_122.w = tmpvar_63;
  _glesFragData[0] = tmpvar_122;
}

]===],
	},
}


end 

function Depth()

    COLOR_MASK = COLOR_RGBA
    ALPAH_MODE = { ALPAH_OFF }
    DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
    STENCIL_MODE = { STENCIL_OFF }
    LIGHT_MODE = { DEPTHPASS }
    
    
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end