

function DefineParams()
	Properties = 
	{
		
_MainTex = { "main Color", TEXTURE2D, "white" },
_UVMoveDir = { "UV Move Direction", VEC2, "0.0, 1.0" },
_MoveInterval = { "Move Interval", FLOAT, "1.0" },
_ElapsedTime = { "Elapsed Time", FLOAT, 0.0 },

_IsFilterColor = { "Is Filter Color", FLOAT, "0.0" }


	}
	Attributes = 
	{
		_IsFilterColor = "Enum(True,1.0,False,0.0)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "uvflowmove"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UVMoveDir",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MoveInterval",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ElapsedTime",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IsFilterColor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _UVMoveDir;
uniform highp float _MoveInterval;
uniform highp float _ElapsedTime;
highp vec2 xlat_mutable_UVMoveDir;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_COLOR0;
void main ()
{
  xlat_mutable_UVMoveDir.x = _UVMoveDir.x;
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 offset_2;
  highp vec2 dir_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  xlat_mutable_UVMoveDir.y = -(_UVMoveDir.y);
  dir_3 = vec2(0.0, 0.0);
  highp float tmpvar_12;
  tmpvar_12 = sqrt(dot (xlat_mutable_UVMoveDir, xlat_mutable_UVMoveDir));
  if ((tmpvar_12 > 1e-5)) {
    dir_3 = normalize(xlat_mutable_UVMoveDir);
  };
  offset_2 = vec2(0.0, 0.0);
  if ((_MoveInterval > 0.0)) {
    offset_2 = ((_ElapsedTime / _MoveInterval) * dir_3);
  };
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (_glesMultiTexCoord0.xy + offset_2);
  xlv_COLOR0 = tmpvar_1;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _MainTex;
uniform highp float _IsFilterColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_COLOR0;
void main ()
{
  highp vec4 mainColor_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (_MainTex, xlv_TEXCOORD0);
  mainColor_1 = tmpvar_2;
  highp int tmpvar_3;
  tmpvar_3 = int(_IsFilterColor);
  if ((tmpvar_3 > 0)) {
    highp vec4 tmpvar_4;
    tmpvar_4 = (1.0 - mainColor_1);
    mainColor_1 = (1.0 - (tmpvar_4 * tmpvar_4));
  };
  highp vec4 tmpvar_5;
  tmpvar_5.xyz = mainColor_1.xyz;
  tmpvar_5.w = (xlv_COLOR0.w * mainColor_1.w);
  _glesFragData[0] = tmpvar_5;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UVMoveDir",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MoveInterval",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ElapsedTime",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IsFilterColor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _UVMoveDir;
uniform highp float _MoveInterval;
uniform highp float _ElapsedTime;
highp vec2 xlat_mutable_UVMoveDir;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_COLOR0;
void main ()
{
  xlat_mutable_UVMoveDir.x = _UVMoveDir.x;
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesColor;
  highp vec2 offset_3;
  highp vec2 dir_4;
  xlat_mutable_UVMoveDir.y = -(_UVMoveDir.y);
  dir_4 = vec2(0.0, 0.0);
  highp float tmpvar_5;
  tmpvar_5 = sqrt(dot (xlat_mutable_UVMoveDir, xlat_mutable_UVMoveDir));
  if ((tmpvar_5 > 1e-5)) {
    dir_4 = normalize(xlat_mutable_UVMoveDir);
  };
  offset_3 = vec2(0.0, 0.0);
  if ((_MoveInterval > 0.0)) {
    offset_3 = ((_ElapsedTime / _MoveInterval) * dir_4);
  };
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (_glesMultiTexCoord0.xy + offset_3);
  xlv_COLOR0 = tmpvar_2;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _MainTex;
uniform highp float _IsFilterColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_COLOR0;
void main ()
{
  highp vec4 mainColor_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (_MainTex, xlv_TEXCOORD0);
  mainColor_1 = tmpvar_2;
  highp int tmpvar_3;
  tmpvar_3 = int(_IsFilterColor);
  if ((tmpvar_3 > 0)) {
    highp vec4 tmpvar_4;
    tmpvar_4 = (1.0 - mainColor_1);
    mainColor_1 = (1.0 - (tmpvar_4 * tmpvar_4));
  };
  highp vec4 tmpvar_5;
  tmpvar_5.xyz = mainColor_1.xyz;
  tmpvar_5.w = (xlv_COLOR0.w * mainColor_1.w);
  _glesFragData[0] = tmpvar_5;
}

]===],
	},
}

end
