
#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
ENABLE_TEXTURE = { "enable texture", FLOAT, "0.0"},
SIM_SPACE = {"sim space", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "trails"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
  float2 vertex : POSITION;
  float2 uv : TEXCOORD0;
  float4 in_Color : COLOR0;
  float2 in_Size : TEXCOORD3;
  float3 in_Right : TEXCOORD1;
  float3 in_Pos : TEXCOORD2;
};

struct v2f
{
  float4 vertex : SV_POSITION;
  float2 uv : TEXCOORD0;
  float4 out_SurfaceColor: COLOR0;
};

sampler2D TEXTURE_DIFFUSE;
float     ENABLE_TEXTURE;
float     SIM_SPACE;

v2f vert(appdata v)
{
  float4x4 in_LocalWorld = LOCALWORLD_TRANSFORM;
  float4x4 in_ViewProj = CAMERA_VIEWPROJ;
  float3   in_ViewOrigin = CAMERA_WORLDPOSITION;
  float    in_SimSpace = SIM_SPACE;
  
  v2f o;
  o.vertex = float4(v.vertex,0.0,1.0);
  o.out_SurfaceColor = v.in_Color;
  o.uv = v.uv;

  float flag = step(1.5, in_SimSpace);
  float4 worldPosition = float4(v.in_Pos,1.0) * flag + (1.0 - flag) * mul(in_LocalWorld, float4(v.in_Pos,1.0));
  float2 size = v.in_Size;
  float3 axisRight = normalize(v.in_Right);

  float3 diff = in_ViewOrigin - worldPosition.xyz;
  float3 axisUp =  normalize(cross(diff, axisRight));

  worldPosition.xyz += axisUp * o.vertex.y  * size.y;
  o.vertex = mul(in_ViewProj, worldPosition);
  o.vertex = UniformNDC(o.vertex);
  return o;
}

float4 frag(v2f i) : SV_Target
{
#define in_Texture TEXTURE_DIFFUSE
#define in_EnableTexture ENABLE_TEXTURE
  float flag = step(0.5,in_EnableTexture);
  float4 in_SurfaceColor = float4(tex2D(in_Texture, fmod(i.uv,1.0)));
  return i.out_SurfaceColor*(in_SurfaceColor * flag + (1.0 - flag));
}
ENDCG
#END
