

function DefineParams()
	Properties = 
	{
		
_MainTex = { "main Color", TEXTURE2D, "white" },
_MetallicGlossMap = {"Metallic Gloss", TEXTURE2D, "white"},
_BumpMap = {"Normal Map", TEXTURE2D, "bump"},
_GlossEnvMap = {"Specular IBL Map", TEXTURECUBE, "black"},
_IrradianceMap = {"Diffuse IBL Map",TEXTURECUBE,"black"},
_Smoothness = {"Smoothness", FLOAT, "0.5" },
_Metallic = { "Metallic", FLOAT, "0.5" },
_EmissionColor = {"Emission Color", COLOR, "0.0,0.0,0.0,1.0"},
_EmissionMap = {"Emission Map",TEXTURE2D,"white"},
_CutOff = { "CutOff", FLOAT, "0.2" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "StandardPbr"
RenderQueue = "TransparentCutout"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalWorld_5;
  highp vec3 normalTangent_6;
  highp vec3 emissionMapColor_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_7 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_13;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  normalWorld_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_14;
  tmpvar_14.x = xlv_TEXCOORD1.w;
  tmpvar_14.y = xlv_TEXCOORD2.w;
  tmpvar_14.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_15;
  highp vec3 tmpvar_16;
  highp vec3 I_17;
  I_17 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_14)));
  tmpvar_16 = (I_17 - (2.0 * (
    dot (normalWorld_5, I_17)
   * normalWorld_5)));
  highp mat2 tmpvar_18;
  tmpvar_18[0].x = 1.0;
  tmpvar_18[0].y = 0.0;
  tmpvar_18[1].x = -0.0;
  tmpvar_18[1].y = 1.0;
  highp vec3 tmpvar_19;
  tmpvar_19.xy = (tmpvar_18 * tmpvar_16.xz);
  tmpvar_19.z = tmpvar_16.y;
  highp vec4 tmpvar_20;
  tmpvar_20.xyz = tmpvar_19.xzy;
  tmpvar_20.w = ((1.0 - (mg_8.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_19.xzy, tmpvar_20.w);
  highp vec4 tmpvar_22;
  tmpvar_22 = tmpvar_21;
  rgbm_15.w = tmpvar_22.w;
  rgbm_15.xyz = ((tmpvar_22.xyz * tmpvar_22.w) * 6.0);
  highp vec4 rgbm_23;
  lowp vec4 tmpvar_24;
  tmpvar_24 = textureCube (_IrradianceMap, normalWorld_5);
  highp vec4 tmpvar_25;
  tmpvar_25 = tmpvar_24;
  rgbm_23.w = tmpvar_25.w;
  rgbm_23.xyz = ((tmpvar_25.xyz * tmpvar_25.w) * 6.0);
  tmpvar_2 = col_9.xyz;
  tmpvar_3 = (mg_8.x * _Metallic);
  tmpvar_4 = (mg_8.y * _Smoothness);
  highp float tmpvar_26;
  highp vec3 specularEnv_27;
  highp vec3 color_28;
  mediump float surfaceReduction_29;
  highp float perceptualRoughness_30;
  mediump vec3 tmpvar_31;
  mediump vec3 albedo_32;
  albedo_32 = tmpvar_2;
  mediump float tmpvar_33;
  tmpvar_33 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_31 = (albedo_32 * tmpvar_33);
  tmpvar_26 = 0.0;
  mediump float alpha_34;
  alpha_34 = tmpvar_26;
  tmpvar_26 = alpha_34;
  mediump float tmpvar_35;
  tmpvar_35 = (1.0 - tmpvar_4);
  perceptualRoughness_30 = tmpvar_35;
  highp float tmpvar_36;
  tmpvar_36 = abs(dot (normalize(
    (CAMERA_WORLDPOSITION - tmpvar_14)
  ), normalWorld_5));
  highp float tmpvar_37;
  tmpvar_37 = max ((perceptualRoughness_30 * perceptualRoughness_30), 0.002);
  surfaceReduction_29 = (1.0 - ((0.28 * tmpvar_37) * perceptualRoughness_30));
  color_28 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_7));
  color_28 = (color_28 + (tmpvar_31 * rgbm_23.xyz));
  mediump float cosA_38;
  cosA_38 = tmpvar_36;
  mediump float tmpvar_39;
  mediump float x_40;
  x_40 = (1.0 - cosA_38);
  tmpvar_39 = ((x_40 * x_40) * ((x_40 * x_40) * x_40));
  mediump vec3 tmpvar_41;
  tmpvar_41 = (surfaceReduction_29 * ((
    ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_32 * tmpvar_3))
   * 
    (1.0 - tmpvar_39)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_33)), 0.0, 1.0)
  ) * tmpvar_39)));
  specularEnv_27 = tmpvar_41;
  color_28 = (color_28 + (specularEnv_27 * rgbm_15.xyz));
  outColor_1.xyz = color_28;
  outColor_1.w = 1.0;
  if (((col_9.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalWorld_5;
  highp vec3 normalTangent_6;
  highp vec3 emissionMapColor_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_7 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_13;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  normalWorld_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_14;
  tmpvar_14.x = xlv_TEXCOORD1.w;
  tmpvar_14.y = xlv_TEXCOORD2.w;
  tmpvar_14.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_15;
  highp vec3 tmpvar_16;
  highp vec3 I_17;
  I_17 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_14)));
  tmpvar_16 = (I_17 - (2.0 * (
    dot (normalWorld_5, I_17)
   * normalWorld_5)));
  highp mat2 tmpvar_18;
  tmpvar_18[0].x = 1.0;
  tmpvar_18[0].y = 0.0;
  tmpvar_18[1].x = -0.0;
  tmpvar_18[1].y = 1.0;
  highp vec3 tmpvar_19;
  tmpvar_19.xy = (tmpvar_18 * tmpvar_16.xz);
  tmpvar_19.z = tmpvar_16.y;
  highp vec4 tmpvar_20;
  tmpvar_20.xyz = tmpvar_19.xzy;
  tmpvar_20.w = ((1.0 - (mg_8.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_19.xzy, tmpvar_20.w);
  highp vec4 tmpvar_22;
  tmpvar_22 = tmpvar_21;
  rgbm_15.w = tmpvar_22.w;
  rgbm_15.xyz = ((tmpvar_22.xyz * tmpvar_22.w) * 6.0);
  highp vec4 rgbm_23;
  lowp vec4 tmpvar_24;
  tmpvar_24 = textureCube (_IrradianceMap, normalWorld_5);
  highp vec4 tmpvar_25;
  tmpvar_25 = tmpvar_24;
  rgbm_23.w = tmpvar_25.w;
  rgbm_23.xyz = ((tmpvar_25.xyz * tmpvar_25.w) * 6.0);
  tmpvar_2 = col_9.xyz;
  tmpvar_3 = (mg_8.x * _Metallic);
  tmpvar_4 = (mg_8.y * _Smoothness);
  highp vec3 tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_26 = normalize((CAMERA_WORLDPOSITION - tmpvar_14));
  tmpvar_27 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_28;
  highp vec3 specularEnv_29;
  highp vec3 color_30;
  mediump float surfaceReduction_31;
  mediump float diffuseTerm_32;
  highp float perceptualRoughness_33;
  mediump vec3 tmpvar_34;
  mediump vec3 albedo_35;
  albedo_35 = tmpvar_2;
  mediump vec3 specColor_36;
  specColor_36 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_35 * tmpvar_3));
  mediump float tmpvar_37;
  tmpvar_37 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_34 = (albedo_35 * tmpvar_37);
  tmpvar_28 = 0.0;
  mediump float alpha_38;
  alpha_38 = tmpvar_28;
  tmpvar_28 = alpha_38;
  mediump float tmpvar_39;
  tmpvar_39 = (1.0 - tmpvar_4);
  perceptualRoughness_33 = tmpvar_39;
  highp vec3 tmpvar_40;
  highp vec3 inVec_41;
  inVec_41 = (tmpvar_27 + tmpvar_26);
  tmpvar_40 = (inVec_41 * inversesqrt(max (0.001, 
    dot (inVec_41, inVec_41)
  )));
  highp float tmpvar_42;
  tmpvar_42 = abs(dot (tmpvar_26, normalWorld_5));
  highp float tmpvar_43;
  tmpvar_43 = clamp (dot (normalWorld_5, tmpvar_27), 0.0, 1.0);
  highp float tmpvar_44;
  tmpvar_44 = clamp (dot (normalWorld_5, tmpvar_40), 0.0, 1.0);
  mediump float tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = clamp (dot (tmpvar_27, tmpvar_40), 0.0, 1.0);
  tmpvar_45 = tmpvar_46;
  mediump float tmpvar_47;
  mediump float NdotV_48;
  NdotV_48 = tmpvar_42;
  mediump float NdotL_49;
  NdotL_49 = tmpvar_43;
  mediump float perceptualRoughness_50;
  perceptualRoughness_50 = perceptualRoughness_33;
  mediump float tmpvar_51;
  tmpvar_51 = (0.5 + ((2.0 * tmpvar_45) * (tmpvar_45 * perceptualRoughness_50)));
  mediump float x_52;
  x_52 = (1.0 - NdotL_49);
  mediump float x_53;
  x_53 = (1.0 - NdotV_48);
  tmpvar_47 = ((1.0 + (
    (tmpvar_51 - 1.0)
   * 
    ((x_52 * x_52) * ((x_52 * x_52) * x_52))
  )) * (1.0 + (
    (tmpvar_51 - 1.0)
   * 
    ((x_53 * x_53) * ((x_53 * x_53) * x_53))
  )));
  highp float tmpvar_54;
  tmpvar_54 = (tmpvar_47 * tmpvar_43);
  diffuseTerm_32 = tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = max ((perceptualRoughness_33 * perceptualRoughness_33), 0.002);
  highp float tmpvar_56;
  tmpvar_56 = (tmpvar_55 * tmpvar_55);
  highp float tmpvar_57;
  tmpvar_57 = (((
    (tmpvar_44 * tmpvar_56)
   - tmpvar_44) * tmpvar_44) + 1.0);
  surfaceReduction_31 = (1.0 - ((0.28 * tmpvar_55) * perceptualRoughness_33));
  mediump vec3 tmpvar_58;
  mediump float x_59;
  x_59 = (1.0 - tmpvar_45);
  tmpvar_58 = (specColor_36 + ((1.0 - specColor_36) * (
    (x_59 * x_59)
   * 
    ((x_59 * x_59) * x_59)
  )));
  color_30 = (((tmpvar_34 * LIGHT_COLOR) * diffuseTerm_32) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_56) / (
        (tmpvar_57 * tmpvar_57)
       + 1e-7)) * (0.5 / (
        ((tmpvar_43 * ((tmpvar_42 * 
          (1.0 - tmpvar_55)
        ) + tmpvar_55)) + (tmpvar_42 * ((tmpvar_43 * 
          (1.0 - tmpvar_55)
        ) + tmpvar_55)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_43))
   * LIGHT_COLOR) * tmpvar_58));
  color_30 = (color_30 + (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_7)));
  color_30 = (color_30 + (tmpvar_34 * rgbm_23.xyz));
  mediump float cosA_60;
  cosA_60 = tmpvar_42;
  mediump float tmpvar_61;
  mediump float x_62;
  x_62 = (1.0 - cosA_60);
  tmpvar_61 = ((x_62 * x_62) * ((x_62 * x_62) * x_62));
  mediump vec3 tmpvar_63;
  tmpvar_63 = (surfaceReduction_31 * ((specColor_36 * 
    (1.0 - tmpvar_61)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_37)), 0.0, 1.0)
  ) * tmpvar_61)));
  specularEnv_29 = tmpvar_63;
  color_30 = (color_30 + (specularEnv_29 * rgbm_15.xyz));
  outColor_1.xyz = color_30;
  outColor_1.w = 1.0;
  if (((col_9.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_16;
  highp vec3 tmpvar_17;
  highp vec3 I_18;
  I_18 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  tmpvar_17 = (I_18 - (2.0 * (
    dot (normalWorld_6, I_18)
   * normalWorld_6)));
  highp mat2 tmpvar_19;
  tmpvar_19[0].x = 1.0;
  tmpvar_19[0].y = 0.0;
  tmpvar_19[1].x = -0.0;
  tmpvar_19[1].y = 1.0;
  highp vec3 tmpvar_20;
  tmpvar_20.xy = (tmpvar_19 * tmpvar_17.xz);
  tmpvar_20.z = tmpvar_17.y;
  highp vec4 tmpvar_21;
  tmpvar_21.xyz = tmpvar_20.xzy;
  tmpvar_21.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_20.xzy, tmpvar_21.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  rgbm_16.w = tmpvar_23.w;
  rgbm_16.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 6.0);
  highp vec4 rgbm_24;
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_24.w = tmpvar_26.w;
  rgbm_24.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  tmpvar_2 = col_10.xyz;
  tmpvar_3 = (mg_9.x * _Metallic);
  tmpvar_4 = (mg_9.y * _Smoothness);
  tmpvar_5 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  highp vec4 shadowCoord_27;
  shadowCoord_27 = xlv_TEXCOORD4;
  highp float tmpvar_28;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_28 = 1.0;
  } else {
    shadowCoord_27.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_29;
    highp vec2 fetchesOffsetsU_30;
    highp float shadow_31;
    highp vec2 tmpvar_32;
    tmpvar_32 = (shadowCoord_27.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_33;
    tmpvar_33 = floor((tmpvar_32 + 0.5));
    highp vec2 tmpvar_34;
    tmpvar_34 = (tmpvar_32 - tmpvar_33);
    highp vec4 computedWeight_35;
    highp vec4 computedArea_36;
    highp vec4 computedAreaUncut_37;
    highp float tmpvar_38;
    tmpvar_38 = (((tmpvar_34.x + 0.5) * (tmpvar_34.x + 0.5)) * 0.5);
    highp float tmpvar_39;
    tmpvar_39 = (tmpvar_38 - tmpvar_34.x);
    computedArea_36.x = tmpvar_39;
    computedAreaUncut_37.x = tmpvar_39;
    computedArea_36.w = tmpvar_38;
    computedAreaUncut_37.w = tmpvar_38;
    computedAreaUncut_37.y = ((1.5 - tmpvar_34.x) - 0.5);
    highp float tmpvar_40;
    tmpvar_40 = min (tmpvar_34.x, 0.0);
    computedArea_36.y = (computedAreaUncut_37.y - (tmpvar_40 * tmpvar_40));
    computedAreaUncut_37.z = ((1.5 + tmpvar_34.x) - 0.5);
    highp float tmpvar_41;
    tmpvar_41 = max (tmpvar_34.x, 0.0);
    computedArea_36.z = (computedAreaUncut_37.z - (tmpvar_41 * tmpvar_41));
    computedWeight_35 = (computedArea_36 * 0.44444);
    highp vec4 computedWeight_42;
    highp vec4 computedArea_43;
    highp vec4 computedAreaUncut_44;
    highp float tmpvar_45;
    tmpvar_45 = (((tmpvar_34.y + 0.5) * (tmpvar_34.y + 0.5)) * 0.5);
    highp float tmpvar_46;
    tmpvar_46 = (tmpvar_45 - tmpvar_34.y);
    computedArea_43.x = tmpvar_46;
    computedAreaUncut_44.x = tmpvar_46;
    computedArea_43.w = tmpvar_45;
    computedAreaUncut_44.w = tmpvar_45;
    computedAreaUncut_44.y = ((1.5 - tmpvar_34.y) - 0.5);
    highp float tmpvar_47;
    tmpvar_47 = min (tmpvar_34.y, 0.0);
    computedArea_43.y = (computedAreaUncut_44.y - (tmpvar_47 * tmpvar_47));
    computedAreaUncut_44.z = ((1.5 + tmpvar_34.y) - 0.5);
    highp float tmpvar_48;
    tmpvar_48 = max (tmpvar_34.y, 0.0);
    computedArea_43.z = (computedAreaUncut_44.z - (tmpvar_48 * tmpvar_48));
    computedWeight_42 = (computedArea_43 * 0.44444);
    highp vec2 tmpvar_49;
    tmpvar_49 = (computedWeight_35.xz + computedWeight_35.yw);
    highp vec2 tmpvar_50;
    tmpvar_50 = (computedWeight_42.xz + computedWeight_42.yw);
    fetchesOffsetsU_30 = (((computedWeight_35.yw / tmpvar_49) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_29 = (((computedWeight_42.yw / tmpvar_50) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_51;
    tmpvar_51 = (tmpvar_33 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_30.x;
    tmpvar_52.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_51 + tmpvar_52);
    tmpvar_53.z = shadowCoord_27.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_31 = ((tmpvar_49.x * tmpvar_50.x) * tmpvar_54);
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_30.y;
    tmpvar_55.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_51 + tmpvar_55);
    tmpvar_56.z = shadowCoord_27.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_31 = (shadow_31 + ((tmpvar_49.y * tmpvar_50.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_30.x;
    tmpvar_58.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_51 + tmpvar_58);
    tmpvar_59.z = shadowCoord_27.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_31 = (shadow_31 + ((tmpvar_49.x * tmpvar_50.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_30.y;
    tmpvar_61.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_51 + tmpvar_61);
    tmpvar_62.z = shadowCoord_27.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_31 = (shadow_31 + ((tmpvar_49.y * tmpvar_50.y) * tmpvar_63));
    tmpvar_28 = mix (1.0, shadow_31, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_64;
  highp vec3 tmpvar_65;
  tmpvar_64 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_65 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_66;
  highp vec3 specularEnv_67;
  highp vec3 color_68;
  mediump float surfaceReduction_69;
  mediump float diffuseTerm_70;
  highp float perceptualRoughness_71;
  mediump vec3 tmpvar_72;
  mediump vec3 albedo_73;
  albedo_73 = tmpvar_2;
  mediump vec3 specColor_74;
  specColor_74 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_73 * tmpvar_3));
  mediump float tmpvar_75;
  tmpvar_75 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_72 = (albedo_73 * tmpvar_75);
  tmpvar_66 = 0.0;
  mediump float alpha_76;
  alpha_76 = tmpvar_66;
  tmpvar_66 = alpha_76;
  mediump float tmpvar_77;
  tmpvar_77 = (1.0 - tmpvar_4);
  perceptualRoughness_71 = tmpvar_77;
  highp vec3 tmpvar_78;
  highp vec3 inVec_79;
  inVec_79 = (tmpvar_65 + tmpvar_64);
  tmpvar_78 = (inVec_79 * inversesqrt(max (0.001, 
    dot (inVec_79, inVec_79)
  )));
  highp float tmpvar_80;
  tmpvar_80 = abs(dot (tmpvar_64, normalWorld_6));
  highp float tmpvar_81;
  tmpvar_81 = clamp (dot (normalWorld_6, tmpvar_65), 0.0, 1.0);
  highp float tmpvar_82;
  tmpvar_82 = clamp (dot (normalWorld_6, tmpvar_78), 0.0, 1.0);
  mediump float tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = clamp (dot (tmpvar_65, tmpvar_78), 0.0, 1.0);
  tmpvar_83 = tmpvar_84;
  mediump float tmpvar_85;
  mediump float NdotV_86;
  NdotV_86 = tmpvar_80;
  mediump float NdotL_87;
  NdotL_87 = tmpvar_81;
  mediump float perceptualRoughness_88;
  perceptualRoughness_88 = perceptualRoughness_71;
  mediump float tmpvar_89;
  tmpvar_89 = (0.5 + ((2.0 * tmpvar_83) * (tmpvar_83 * perceptualRoughness_88)));
  mediump float x_90;
  x_90 = (1.0 - NdotL_87);
  mediump float x_91;
  x_91 = (1.0 - NdotV_86);
  tmpvar_85 = ((1.0 + (
    (tmpvar_89 - 1.0)
   * 
    ((x_90 * x_90) * ((x_90 * x_90) * x_90))
  )) * (1.0 + (
    (tmpvar_89 - 1.0)
   * 
    ((x_91 * x_91) * ((x_91 * x_91) * x_91))
  )));
  highp float tmpvar_92;
  tmpvar_92 = (tmpvar_85 * tmpvar_81);
  diffuseTerm_70 = tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = max ((perceptualRoughness_71 * perceptualRoughness_71), 0.002);
  highp float tmpvar_94;
  tmpvar_94 = (tmpvar_93 * tmpvar_93);
  highp float tmpvar_95;
  tmpvar_95 = (((
    (tmpvar_82 * tmpvar_94)
   - tmpvar_82) * tmpvar_82) + 1.0);
  surfaceReduction_69 = (1.0 - ((0.28 * tmpvar_93) * perceptualRoughness_71));
  mediump vec3 tmpvar_96;
  mediump float x_97;
  x_97 = (1.0 - tmpvar_83);
  tmpvar_96 = (specColor_74 + ((1.0 - specColor_74) * (
    (x_97 * x_97)
   * 
    ((x_97 * x_97) * x_97)
  )));
  color_68 = (((
    (tmpvar_72 * LIGHT_COLOR)
   * diffuseTerm_70) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_94)
       / 
        ((tmpvar_95 * tmpvar_95) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_81 * (
          (tmpvar_80 * (1.0 - tmpvar_93))
         + tmpvar_93)) + (tmpvar_80 * (
          (tmpvar_81 * (1.0 - tmpvar_93))
         + tmpvar_93))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_81)) * LIGHT_COLOR)
   * tmpvar_96)) * tmpvar_28);
  color_68 = (color_68 + tmpvar_5);
  color_68 = (color_68 + (tmpvar_72 * rgbm_24.xyz));
  mediump float cosA_98;
  cosA_98 = tmpvar_80;
  mediump float tmpvar_99;
  mediump float x_100;
  x_100 = (1.0 - cosA_98);
  tmpvar_99 = ((x_100 * x_100) * ((x_100 * x_100) * x_100));
  mediump vec3 tmpvar_101;
  tmpvar_101 = (surfaceReduction_69 * ((specColor_74 * 
    (1.0 - tmpvar_99)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_75)), 0.0, 1.0)
  ) * tmpvar_99)));
  specularEnv_67 = tmpvar_101;
  color_68 = (color_68 + (specularEnv_67 * rgbm_16.xyz));
  outColor_1.xyz = color_68;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_16;
  highp vec3 tmpvar_17;
  highp vec3 I_18;
  I_18 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  tmpvar_17 = (I_18 - (2.0 * (
    dot (normalWorld_6, I_18)
   * normalWorld_6)));
  highp mat2 tmpvar_19;
  tmpvar_19[0].x = 1.0;
  tmpvar_19[0].y = 0.0;
  tmpvar_19[1].x = -0.0;
  tmpvar_19[1].y = 1.0;
  highp vec3 tmpvar_20;
  tmpvar_20.xy = (tmpvar_19 * tmpvar_17.xz);
  tmpvar_20.z = tmpvar_17.y;
  highp vec4 tmpvar_21;
  tmpvar_21.xyz = tmpvar_20.xzy;
  tmpvar_21.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_20.xzy, tmpvar_21.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  rgbm_16.w = tmpvar_23.w;
  rgbm_16.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 6.0);
  highp vec4 rgbm_24;
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_24.w = tmpvar_26.w;
  rgbm_24.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  tmpvar_2 = col_10.xyz;
  tmpvar_3 = (mg_9.x * _Metallic);
  tmpvar_4 = (mg_9.y * _Smoothness);
  tmpvar_5 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  highp vec4 shadowCoord_27;
  shadowCoord_27 = xlv_TEXCOORD4;
  highp float tmpvar_28;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_28 = 1.0;
  } else {
    shadowCoord_27.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_29;
    highp vec3 fetchesOffsetsU_30;
    highp float shadow_31;
    highp vec2 tmpvar_32;
    tmpvar_32 = (shadowCoord_27.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_33;
    tmpvar_33 = floor((tmpvar_32 + 0.5));
    highp vec2 tmpvar_34;
    tmpvar_34 = (tmpvar_32 - tmpvar_33);
    highp vec3 texelsWeightsA_35;
    highp vec3 texelsWeightsB_36;
    highp vec4 computedArea_37;
    highp vec4 computedAreaUncut_38;
    highp float tmpvar_39;
    tmpvar_39 = (((tmpvar_34.x + 0.5) * (tmpvar_34.x + 0.5)) * 0.5);
    highp float tmpvar_40;
    tmpvar_40 = (tmpvar_39 - tmpvar_34.x);
    computedArea_37.x = tmpvar_40;
    computedAreaUncut_38.x = tmpvar_40;
    computedArea_37.w = tmpvar_39;
    computedAreaUncut_38.w = tmpvar_39;
    computedAreaUncut_38.y = ((1.5 - tmpvar_34.x) - 0.5);
    highp float tmpvar_41;
    tmpvar_41 = min (tmpvar_34.x, 0.0);
    computedArea_37.y = (computedAreaUncut_38.y - (tmpvar_41 * tmpvar_41));
    computedAreaUncut_38.z = ((1.5 + tmpvar_34.x) - 0.5);
    highp float tmpvar_42;
    tmpvar_42 = max (tmpvar_34.x, 0.0);
    computedArea_37.z = (computedAreaUncut_38.z - (tmpvar_42 * tmpvar_42));
    texelsWeightsA_35.x = (0.16 * tmpvar_40);
    texelsWeightsA_35.y = (0.16 * computedAreaUncut_38.y);
    texelsWeightsA_35.z = (0.16 * (computedArea_37.y + 1.0));
    texelsWeightsB_36.x = (0.16 * (computedArea_37.z + 1.0));
    texelsWeightsB_36.y = (0.16 * computedAreaUncut_38.z);
    texelsWeightsB_36.z = (0.16 * tmpvar_39);
    highp vec3 texelsWeightsA_43;
    highp vec3 texelsWeightsB_44;
    highp vec4 computedArea_45;
    highp vec4 computedAreaUncut_46;
    highp float tmpvar_47;
    tmpvar_47 = (((tmpvar_34.y + 0.5) * (tmpvar_34.y + 0.5)) * 0.5);
    highp float tmpvar_48;
    tmpvar_48 = (tmpvar_47 - tmpvar_34.y);
    computedArea_45.x = tmpvar_48;
    computedAreaUncut_46.x = tmpvar_48;
    computedArea_45.w = tmpvar_47;
    computedAreaUncut_46.w = tmpvar_47;
    computedAreaUncut_46.y = ((1.5 - tmpvar_34.y) - 0.5);
    highp float tmpvar_49;
    tmpvar_49 = min (tmpvar_34.y, 0.0);
    computedArea_45.y = (computedAreaUncut_46.y - (tmpvar_49 * tmpvar_49));
    computedAreaUncut_46.z = ((1.5 + tmpvar_34.y) - 0.5);
    highp float tmpvar_50;
    tmpvar_50 = max (tmpvar_34.y, 0.0);
    computedArea_45.z = (computedAreaUncut_46.z - (tmpvar_50 * tmpvar_50));
    texelsWeightsA_43.x = (0.16 * tmpvar_48);
    texelsWeightsA_43.y = (0.16 * computedAreaUncut_46.y);
    texelsWeightsA_43.z = (0.16 * (computedArea_45.y + 1.0));
    texelsWeightsB_44.x = (0.16 * (computedArea_45.z + 1.0));
    texelsWeightsB_44.y = (0.16 * computedAreaUncut_46.z);
    texelsWeightsB_44.z = (0.16 * tmpvar_47);
    highp vec3 tmpvar_51;
    tmpvar_51.xy = texelsWeightsA_35.xz;
    tmpvar_51.z = texelsWeightsB_36.y;
    highp vec3 tmpvar_52;
    tmpvar_52.x = texelsWeightsA_35.y;
    tmpvar_52.yz = texelsWeightsB_36.xz;
    highp vec3 tmpvar_53;
    tmpvar_53 = (tmpvar_51 + tmpvar_52);
    highp vec3 tmpvar_54;
    tmpvar_54.xy = texelsWeightsA_43.xz;
    tmpvar_54.z = texelsWeightsB_44.y;
    highp vec3 tmpvar_55;
    tmpvar_55.x = texelsWeightsA_43.y;
    tmpvar_55.yz = texelsWeightsB_44.xz;
    highp vec3 tmpvar_56;
    tmpvar_56 = (tmpvar_54 + tmpvar_55);
    highp vec3 tmpvar_57;
    tmpvar_57.x = texelsWeightsA_35.y;
    tmpvar_57.yz = texelsWeightsB_36.xz;
    highp vec3 tmpvar_58;
    tmpvar_58.x = texelsWeightsA_43.y;
    tmpvar_58.yz = texelsWeightsB_44.xz;
    fetchesOffsetsU_30 = (((tmpvar_57 / tmpvar_53) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_29 = (((tmpvar_58 / tmpvar_56) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_59;
    tmpvar_59 = (tmpvar_33 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_30.x;
    tmpvar_60.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_59 + tmpvar_60);
    tmpvar_61.z = shadowCoord_27.z;
    lowp float tmpvar_62;
    tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_31 = ((tmpvar_53.x * tmpvar_56.x) * tmpvar_62);
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_30.y;
    tmpvar_63.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_59 + tmpvar_63);
    tmpvar_64.z = shadowCoord_27.z;
    lowp float tmpvar_65;
    tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.x) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_30.z;
    tmpvar_66.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_59 + tmpvar_66);
    tmpvar_67.z = shadowCoord_27.z;
    lowp float tmpvar_68;
    tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.x) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_30.x;
    tmpvar_69.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_59 + tmpvar_69);
    tmpvar_70.z = shadowCoord_27.z;
    lowp float tmpvar_71;
    tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.y) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_30.y;
    tmpvar_72.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_59 + tmpvar_72);
    tmpvar_73.z = shadowCoord_27.z;
    lowp float tmpvar_74;
    tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.y) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_30.z;
    tmpvar_75.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_59 + tmpvar_75);
    tmpvar_76.z = shadowCoord_27.z;
    lowp float tmpvar_77;
    tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.y) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_30.x;
    tmpvar_78.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_59 + tmpvar_78);
    tmpvar_79.z = shadowCoord_27.z;
    lowp float tmpvar_80;
    tmpvar_80 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.z) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_30.y;
    tmpvar_81.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_59 + tmpvar_81);
    tmpvar_82.z = shadowCoord_27.z;
    lowp float tmpvar_83;
    tmpvar_83 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.z) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_30.z;
    tmpvar_84.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_59 + tmpvar_84);
    tmpvar_85.z = shadowCoord_27.z;
    lowp float tmpvar_86;
    tmpvar_86 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.z) * tmpvar_86));
    tmpvar_28 = mix (1.0, shadow_31, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_87;
  highp vec3 tmpvar_88;
  tmpvar_87 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_88 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_89;
  highp vec3 specularEnv_90;
  highp vec3 color_91;
  mediump float surfaceReduction_92;
  mediump float diffuseTerm_93;
  highp float perceptualRoughness_94;
  mediump vec3 tmpvar_95;
  mediump vec3 albedo_96;
  albedo_96 = tmpvar_2;
  mediump vec3 specColor_97;
  specColor_97 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_96 * tmpvar_3));
  mediump float tmpvar_98;
  tmpvar_98 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_95 = (albedo_96 * tmpvar_98);
  tmpvar_89 = 0.0;
  mediump float alpha_99;
  alpha_99 = tmpvar_89;
  tmpvar_89 = alpha_99;
  mediump float tmpvar_100;
  tmpvar_100 = (1.0 - tmpvar_4);
  perceptualRoughness_94 = tmpvar_100;
  highp vec3 tmpvar_101;
  highp vec3 inVec_102;
  inVec_102 = (tmpvar_88 + tmpvar_87);
  tmpvar_101 = (inVec_102 * inversesqrt(max (0.001, 
    dot (inVec_102, inVec_102)
  )));
  highp float tmpvar_103;
  tmpvar_103 = abs(dot (tmpvar_87, normalWorld_6));
  highp float tmpvar_104;
  tmpvar_104 = clamp (dot (normalWorld_6, tmpvar_88), 0.0, 1.0);
  highp float tmpvar_105;
  tmpvar_105 = clamp (dot (normalWorld_6, tmpvar_101), 0.0, 1.0);
  mediump float tmpvar_106;
  highp float tmpvar_107;
  tmpvar_107 = clamp (dot (tmpvar_88, tmpvar_101), 0.0, 1.0);
  tmpvar_106 = tmpvar_107;
  mediump float tmpvar_108;
  mediump float NdotV_109;
  NdotV_109 = tmpvar_103;
  mediump float NdotL_110;
  NdotL_110 = tmpvar_104;
  mediump float perceptualRoughness_111;
  perceptualRoughness_111 = perceptualRoughness_94;
  mediump float tmpvar_112;
  tmpvar_112 = (0.5 + ((2.0 * tmpvar_106) * (tmpvar_106 * perceptualRoughness_111)));
  mediump float x_113;
  x_113 = (1.0 - NdotL_110);
  mediump float x_114;
  x_114 = (1.0 - NdotV_109);
  tmpvar_108 = ((1.0 + (
    (tmpvar_112 - 1.0)
   * 
    ((x_113 * x_113) * ((x_113 * x_113) * x_113))
  )) * (1.0 + (
    (tmpvar_112 - 1.0)
   * 
    ((x_114 * x_114) * ((x_114 * x_114) * x_114))
  )));
  highp float tmpvar_115;
  tmpvar_115 = (tmpvar_108 * tmpvar_104);
  diffuseTerm_93 = tmpvar_115;
  highp float tmpvar_116;
  tmpvar_116 = max ((perceptualRoughness_94 * perceptualRoughness_94), 0.002);
  highp float tmpvar_117;
  tmpvar_117 = (tmpvar_116 * tmpvar_116);
  highp float tmpvar_118;
  tmpvar_118 = (((
    (tmpvar_105 * tmpvar_117)
   - tmpvar_105) * tmpvar_105) + 1.0);
  surfaceReduction_92 = (1.0 - ((0.28 * tmpvar_116) * perceptualRoughness_94));
  mediump vec3 tmpvar_119;
  mediump float x_120;
  x_120 = (1.0 - tmpvar_106);
  tmpvar_119 = (specColor_97 + ((1.0 - specColor_97) * (
    (x_120 * x_120)
   * 
    ((x_120 * x_120) * x_120)
  )));
  color_91 = (((
    (tmpvar_95 * LIGHT_COLOR)
   * diffuseTerm_93) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_117)
       / 
        ((tmpvar_118 * tmpvar_118) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_104 * (
          (tmpvar_103 * (1.0 - tmpvar_116))
         + tmpvar_116)) + (tmpvar_103 * (
          (tmpvar_104 * (1.0 - tmpvar_116))
         + tmpvar_116))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_104)) * LIGHT_COLOR)
   * tmpvar_119)) * tmpvar_28);
  color_91 = (color_91 + tmpvar_5);
  color_91 = (color_91 + (tmpvar_95 * rgbm_24.xyz));
  mediump float cosA_121;
  cosA_121 = tmpvar_103;
  mediump float tmpvar_122;
  mediump float x_123;
  x_123 = (1.0 - cosA_121);
  tmpvar_122 = ((x_123 * x_123) * ((x_123 * x_123) * x_123));
  mediump vec3 tmpvar_124;
  tmpvar_124 = (surfaceReduction_92 * ((specColor_97 * 
    (1.0 - tmpvar_122)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_98)), 0.0, 1.0)
  ) * tmpvar_122)));
  specularEnv_90 = tmpvar_124;
  color_91 = (color_91 + (specularEnv_90 * rgbm_16.xyz));
  outColor_1.xyz = color_91;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_16;
  highp vec3 tmpvar_17;
  highp vec3 I_18;
  I_18 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  tmpvar_17 = (I_18 - (2.0 * (
    dot (normalWorld_6, I_18)
   * normalWorld_6)));
  highp mat2 tmpvar_19;
  tmpvar_19[0].x = 1.0;
  tmpvar_19[0].y = 0.0;
  tmpvar_19[1].x = -0.0;
  tmpvar_19[1].y = 1.0;
  highp vec3 tmpvar_20;
  tmpvar_20.xy = (tmpvar_19 * tmpvar_17.xz);
  tmpvar_20.z = tmpvar_17.y;
  highp vec4 tmpvar_21;
  tmpvar_21.xyz = tmpvar_20.xzy;
  tmpvar_21.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_20.xzy, tmpvar_21.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  rgbm_16.w = tmpvar_23.w;
  rgbm_16.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 6.0);
  highp vec4 rgbm_24;
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_24.w = tmpvar_26.w;
  rgbm_24.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  tmpvar_2 = col_10.xyz;
  tmpvar_3 = (mg_9.x * _Metallic);
  tmpvar_4 = (mg_9.y * _Smoothness);
  tmpvar_5 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  highp vec4 shadowCoord_27;
  shadowCoord_27 = xlv_TEXCOORD4;
  highp float tmpvar_28;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_28 = 1.0;
  } else {
    shadowCoord_27.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_29;
    highp vec4 fetchesOffsetsU_30;
    highp float shadow_31;
    highp vec2 tmpvar_32;
    tmpvar_32 = (shadowCoord_27.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_33;
    tmpvar_33 = floor((tmpvar_32 + 0.5));
    highp vec2 tmpvar_34;
    tmpvar_34 = (tmpvar_32 - tmpvar_33);
    highp vec4 texelsWeightsA_35;
    highp vec4 texelsWeightsB_36;
    highp vec4 computedArea_37;
    highp vec4 computedAreaUncut_38;
    highp float tmpvar_39;
    tmpvar_39 = (((tmpvar_34.x + 0.5) * (tmpvar_34.x + 0.5)) * 0.5);
    highp float tmpvar_40;
    tmpvar_40 = (tmpvar_39 - tmpvar_34.x);
    computedArea_37.x = tmpvar_40;
    computedAreaUncut_38.x = tmpvar_40;
    computedArea_37.w = tmpvar_39;
    computedAreaUncut_38.w = tmpvar_39;
    computedAreaUncut_38.y = ((1.5 - tmpvar_34.x) - 0.5);
    highp float tmpvar_41;
    tmpvar_41 = min (tmpvar_34.x, 0.0);
    computedArea_37.y = (computedAreaUncut_38.y - (tmpvar_41 * tmpvar_41));
    computedAreaUncut_38.z = ((1.5 + tmpvar_34.x) - 0.5);
    highp float tmpvar_42;
    tmpvar_42 = max (tmpvar_34.x, 0.0);
    computedArea_37.z = (computedAreaUncut_38.z - (tmpvar_42 * tmpvar_42));
    texelsWeightsA_35.x = (0.081632 * tmpvar_40);
    texelsWeightsA_35.y = (0.081632 * computedAreaUncut_38.y);
    texelsWeightsA_35.z = (0.081632 * (computedAreaUncut_38.y + 1.0));
    texelsWeightsA_35.w = (0.081632 * (computedArea_37.y + 2.0));
    texelsWeightsB_36.x = (0.081632 * (computedArea_37.z + 2.0));
    texelsWeightsB_36.y = (0.081632 * (computedAreaUncut_38.z + 1.0));
    texelsWeightsB_36.z = (0.081632 * computedAreaUncut_38.z);
    texelsWeightsB_36.w = (0.081632 * tmpvar_39);
    highp vec4 texelsWeightsA_43;
    highp vec4 texelsWeightsB_44;
    highp vec4 computedArea_45;
    highp vec4 computedAreaUncut_46;
    highp float tmpvar_47;
    tmpvar_47 = (((tmpvar_34.y + 0.5) * (tmpvar_34.y + 0.5)) * 0.5);
    highp float tmpvar_48;
    tmpvar_48 = (tmpvar_47 - tmpvar_34.y);
    computedArea_45.x = tmpvar_48;
    computedAreaUncut_46.x = tmpvar_48;
    computedArea_45.w = tmpvar_47;
    computedAreaUncut_46.w = tmpvar_47;
    computedAreaUncut_46.y = ((1.5 - tmpvar_34.y) - 0.5);
    highp float tmpvar_49;
    tmpvar_49 = min (tmpvar_34.y, 0.0);
    computedArea_45.y = (computedAreaUncut_46.y - (tmpvar_49 * tmpvar_49));
    computedAreaUncut_46.z = ((1.5 + tmpvar_34.y) - 0.5);
    highp float tmpvar_50;
    tmpvar_50 = max (tmpvar_34.y, 0.0);
    computedArea_45.z = (computedAreaUncut_46.z - (tmpvar_50 * tmpvar_50));
    texelsWeightsA_43.x = (0.081632 * tmpvar_48);
    texelsWeightsA_43.y = (0.081632 * computedAreaUncut_46.y);
    texelsWeightsA_43.z = (0.081632 * (computedAreaUncut_46.y + 1.0));
    texelsWeightsA_43.w = (0.081632 * (computedArea_45.y + 2.0));
    texelsWeightsB_44.x = (0.081632 * (computedArea_45.z + 2.0));
    texelsWeightsB_44.y = (0.081632 * (computedAreaUncut_46.z + 1.0));
    texelsWeightsB_44.z = (0.081632 * computedAreaUncut_46.z);
    texelsWeightsB_44.w = (0.081632 * tmpvar_47);
    highp vec4 tmpvar_51;
    tmpvar_51.xy = texelsWeightsA_35.xz;
    tmpvar_51.zw = texelsWeightsB_36.xz;
    highp vec4 tmpvar_52;
    tmpvar_52.xy = texelsWeightsA_35.yw;
    tmpvar_52.zw = texelsWeightsB_36.yw;
    highp vec4 tmpvar_53;
    tmpvar_53 = (tmpvar_51 + tmpvar_52);
    highp vec4 tmpvar_54;
    tmpvar_54.xy = texelsWeightsA_43.xz;
    tmpvar_54.zw = texelsWeightsB_44.xz;
    highp vec4 tmpvar_55;
    tmpvar_55.xy = texelsWeightsA_43.yw;
    tmpvar_55.zw = texelsWeightsB_44.yw;
    highp vec4 tmpvar_56;
    tmpvar_56 = (tmpvar_54 + tmpvar_55);
    highp vec4 tmpvar_57;
    tmpvar_57.xy = texelsWeightsA_35.yw;
    tmpvar_57.zw = texelsWeightsB_36.yw;
    highp vec4 tmpvar_58;
    tmpvar_58.xy = texelsWeightsA_43.yw;
    tmpvar_58.zw = texelsWeightsB_44.yw;
    fetchesOffsetsU_30 = (((tmpvar_57 / tmpvar_53) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_29 = (((tmpvar_58 / tmpvar_56) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_59;
    tmpvar_59 = (tmpvar_33 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_30.x;
    tmpvar_60.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_59 + tmpvar_60);
    tmpvar_61.z = shadowCoord_27.z;
    lowp float tmpvar_62;
    tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_31 = ((tmpvar_53.x * tmpvar_56.x) * tmpvar_62);
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_30.y;
    tmpvar_63.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_59 + tmpvar_63);
    tmpvar_64.z = shadowCoord_27.z;
    lowp float tmpvar_65;
    tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.x) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_30.z;
    tmpvar_66.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_59 + tmpvar_66);
    tmpvar_67.z = shadowCoord_27.z;
    lowp float tmpvar_68;
    tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.x) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_30.w;
    tmpvar_69.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_59 + tmpvar_69);
    tmpvar_70.z = shadowCoord_27.z;
    lowp float tmpvar_71;
    tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_31 = (shadow_31 + ((tmpvar_53.w * tmpvar_56.x) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_30.x;
    tmpvar_72.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_59 + tmpvar_72);
    tmpvar_73.z = shadowCoord_27.z;
    lowp float tmpvar_74;
    tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.y) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_30.y;
    tmpvar_75.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_59 + tmpvar_75);
    tmpvar_76.z = shadowCoord_27.z;
    lowp float tmpvar_77;
    tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.y) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_30.z;
    tmpvar_78.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_59 + tmpvar_78);
    tmpvar_79.z = shadowCoord_27.z;
    lowp float tmpvar_80;
    tmpvar_80 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.y) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_30.w;
    tmpvar_81.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_59 + tmpvar_81);
    tmpvar_82.z = shadowCoord_27.z;
    lowp float tmpvar_83;
    tmpvar_83 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_31 = (shadow_31 + ((tmpvar_53.w * tmpvar_56.y) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_30.x;
    tmpvar_84.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_59 + tmpvar_84);
    tmpvar_85.z = shadowCoord_27.z;
    lowp float tmpvar_86;
    tmpvar_86 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.z) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_30.y;
    tmpvar_87.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_59 + tmpvar_87);
    tmpvar_88.z = shadowCoord_27.z;
    lowp float tmpvar_89;
    tmpvar_89 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.z) * tmpvar_89));
    highp vec2 tmpvar_90;
    tmpvar_90.x = fetchesOffsetsU_30.z;
    tmpvar_90.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_91;
    tmpvar_91.xy = (tmpvar_59 + tmpvar_90);
    tmpvar_91.z = shadowCoord_27.z;
    lowp float tmpvar_92;
    tmpvar_92 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_91);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.z) * tmpvar_92));
    highp vec2 tmpvar_93;
    tmpvar_93.x = fetchesOffsetsU_30.w;
    tmpvar_93.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_94;
    tmpvar_94.xy = (tmpvar_59 + tmpvar_93);
    tmpvar_94.z = shadowCoord_27.z;
    lowp float tmpvar_95;
    tmpvar_95 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_94);
    shadow_31 = (shadow_31 + ((tmpvar_53.w * tmpvar_56.z) * tmpvar_95));
    highp vec2 tmpvar_96;
    tmpvar_96.x = fetchesOffsetsU_30.x;
    tmpvar_96.y = fetchesOffsetsV_29.w;
    highp vec3 tmpvar_97;
    tmpvar_97.xy = (tmpvar_59 + tmpvar_96);
    tmpvar_97.z = shadowCoord_27.z;
    lowp float tmpvar_98;
    tmpvar_98 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_97);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.w) * tmpvar_98));
    highp vec2 tmpvar_99;
    tmpvar_99.x = fetchesOffsetsU_30.y;
    tmpvar_99.y = fetchesOffsetsV_29.w;
    highp vec3 tmpvar_100;
    tmpvar_100.xy = (tmpvar_59 + tmpvar_99);
    tmpvar_100.z = shadowCoord_27.z;
    lowp float tmpvar_101;
    tmpvar_101 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_100);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.w) * tmpvar_101));
    highp vec2 tmpvar_102;
    tmpvar_102.x = fetchesOffsetsU_30.z;
    tmpvar_102.y = fetchesOffsetsV_29.w;
    highp vec3 tmpvar_103;
    tmpvar_103.xy = (tmpvar_59 + tmpvar_102);
    tmpvar_103.z = shadowCoord_27.z;
    lowp float tmpvar_104;
    tmpvar_104 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_103);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.w) * tmpvar_104));
    highp vec2 tmpvar_105;
    tmpvar_105.x = fetchesOffsetsU_30.w;
    tmpvar_105.y = fetchesOffsetsV_29.w;
    highp vec3 tmpvar_106;
    tmpvar_106.xy = (tmpvar_59 + tmpvar_105);
    tmpvar_106.z = shadowCoord_27.z;
    lowp float tmpvar_107;
    tmpvar_107 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_106);
    shadow_31 = (shadow_31 + ((tmpvar_53.w * tmpvar_56.w) * tmpvar_107));
    tmpvar_28 = mix (1.0, shadow_31, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_108;
  highp vec3 tmpvar_109;
  tmpvar_108 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_109 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_110;
  highp vec3 specularEnv_111;
  highp vec3 color_112;
  mediump float surfaceReduction_113;
  mediump float diffuseTerm_114;
  highp float perceptualRoughness_115;
  mediump vec3 tmpvar_116;
  mediump vec3 albedo_117;
  albedo_117 = tmpvar_2;
  mediump vec3 specColor_118;
  specColor_118 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_117 * tmpvar_3));
  mediump float tmpvar_119;
  tmpvar_119 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_116 = (albedo_117 * tmpvar_119);
  tmpvar_110 = 0.0;
  mediump float alpha_120;
  alpha_120 = tmpvar_110;
  tmpvar_110 = alpha_120;
  mediump float tmpvar_121;
  tmpvar_121 = (1.0 - tmpvar_4);
  perceptualRoughness_115 = tmpvar_121;
  highp vec3 tmpvar_122;
  highp vec3 inVec_123;
  inVec_123 = (tmpvar_109 + tmpvar_108);
  tmpvar_122 = (inVec_123 * inversesqrt(max (0.001, 
    dot (inVec_123, inVec_123)
  )));
  highp float tmpvar_124;
  tmpvar_124 = abs(dot (tmpvar_108, normalWorld_6));
  highp float tmpvar_125;
  tmpvar_125 = clamp (dot (normalWorld_6, tmpvar_109), 0.0, 1.0);
  highp float tmpvar_126;
  tmpvar_126 = clamp (dot (normalWorld_6, tmpvar_122), 0.0, 1.0);
  mediump float tmpvar_127;
  highp float tmpvar_128;
  tmpvar_128 = clamp (dot (tmpvar_109, tmpvar_122), 0.0, 1.0);
  tmpvar_127 = tmpvar_128;
  mediump float tmpvar_129;
  mediump float NdotV_130;
  NdotV_130 = tmpvar_124;
  mediump float NdotL_131;
  NdotL_131 = tmpvar_125;
  mediump float perceptualRoughness_132;
  perceptualRoughness_132 = perceptualRoughness_115;
  mediump float tmpvar_133;
  tmpvar_133 = (0.5 + ((2.0 * tmpvar_127) * (tmpvar_127 * perceptualRoughness_132)));
  mediump float x_134;
  x_134 = (1.0 - NdotL_131);
  mediump float x_135;
  x_135 = (1.0 - NdotV_130);
  tmpvar_129 = ((1.0 + (
    (tmpvar_133 - 1.0)
   * 
    ((x_134 * x_134) * ((x_134 * x_134) * x_134))
  )) * (1.0 + (
    (tmpvar_133 - 1.0)
   * 
    ((x_135 * x_135) * ((x_135 * x_135) * x_135))
  )));
  highp float tmpvar_136;
  tmpvar_136 = (tmpvar_129 * tmpvar_125);
  diffuseTerm_114 = tmpvar_136;
  highp float tmpvar_137;
  tmpvar_137 = max ((perceptualRoughness_115 * perceptualRoughness_115), 0.002);
  highp float tmpvar_138;
  tmpvar_138 = (tmpvar_137 * tmpvar_137);
  highp float tmpvar_139;
  tmpvar_139 = (((
    (tmpvar_126 * tmpvar_138)
   - tmpvar_126) * tmpvar_126) + 1.0);
  surfaceReduction_113 = (1.0 - ((0.28 * tmpvar_137) * perceptualRoughness_115));
  mediump vec3 tmpvar_140;
  mediump float x_141;
  x_141 = (1.0 - tmpvar_127);
  tmpvar_140 = (specColor_118 + ((1.0 - specColor_118) * (
    (x_141 * x_141)
   * 
    ((x_141 * x_141) * x_141)
  )));
  color_112 = (((
    (tmpvar_116 * LIGHT_COLOR)
   * diffuseTerm_114) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_138)
       / 
        ((tmpvar_139 * tmpvar_139) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_125 * (
          (tmpvar_124 * (1.0 - tmpvar_137))
         + tmpvar_137)) + (tmpvar_124 * (
          (tmpvar_125 * (1.0 - tmpvar_137))
         + tmpvar_137))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_125)) * LIGHT_COLOR)
   * tmpvar_140)) * tmpvar_28);
  color_112 = (color_112 + tmpvar_5);
  color_112 = (color_112 + (tmpvar_116 * rgbm_24.xyz));
  mediump float cosA_142;
  cosA_142 = tmpvar_124;
  mediump float tmpvar_143;
  mediump float x_144;
  x_144 = (1.0 - cosA_142);
  tmpvar_143 = ((x_144 * x_144) * ((x_144 * x_144) * x_144));
  mediump vec3 tmpvar_145;
  tmpvar_145 = (surfaceReduction_113 * ((specColor_118 * 
    (1.0 - tmpvar_143)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_119)), 0.0, 1.0)
  ) * tmpvar_143)));
  specularEnv_111 = tmpvar_145;
  color_112 = (color_112 + (specularEnv_111 * rgbm_16.xyz));
  outColor_1.xyz = color_112;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_16;
  highp vec3 tmpvar_17;
  highp vec3 I_18;
  I_18 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  tmpvar_17 = (I_18 - (2.0 * (
    dot (normalWorld_6, I_18)
   * normalWorld_6)));
  highp mat2 tmpvar_19;
  tmpvar_19[0].x = 1.0;
  tmpvar_19[0].y = 0.0;
  tmpvar_19[1].x = -0.0;
  tmpvar_19[1].y = 1.0;
  highp vec3 tmpvar_20;
  tmpvar_20.xy = (tmpvar_19 * tmpvar_17.xz);
  tmpvar_20.z = tmpvar_17.y;
  highp vec4 tmpvar_21;
  tmpvar_21.xyz = tmpvar_20.xzy;
  tmpvar_21.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_20.xzy, tmpvar_21.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  rgbm_16.w = tmpvar_23.w;
  rgbm_16.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 6.0);
  highp vec4 rgbm_24;
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_24.w = tmpvar_26.w;
  rgbm_24.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  tmpvar_2 = col_10.xyz;
  tmpvar_3 = (mg_9.x * _Metallic);
  tmpvar_4 = (mg_9.y * _Smoothness);
  tmpvar_5 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  highp vec4 shadowCoord_27;
  shadowCoord_27 = xlv_TEXCOORD4;
  highp float tmpvar_28;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_28 = 1.0;
  } else {
    highp vec2 tmpvar_29;
    tmpvar_29.x = LIGHT_PARAM.z;
    tmpvar_29.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = tmpvar_29;
    highp float tmpvar_31;
    tmpvar_31 = (1.0/(LIGHT_PARAM.z));
    tmpvar_30.z = tmpvar_31;
    tmpvar_30.w = tmpvar_31;
    shadowCoord_27.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_32;
    highp vec2 tmpvar_33;
    tmpvar_33 = tmpvar_30.xy;
    shadow_32 = 0.0;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_27.xy - LIGHT_PARAM.zz);
    tmpvar_34.z = shadowCoord_27.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_32 = tmpvar_36;
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_27.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_27.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_32 = (tmpvar_36 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = tmpvar_33.x;
    tmpvar_41.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_27.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_27.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.y = 0.0;
    tmpvar_45.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (shadowCoord_27.xy + tmpvar_45);
    tmpvar_46.z = shadowCoord_27.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_48);
    highp vec4 tmpvar_49;
    tmpvar_49 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_27.xy);
    highp float tmpvar_50;
    if ((tmpvar_49.x < xlv_TEXCOORD4.z)) {
      tmpvar_50 = 0.0;
    } else {
      tmpvar_50 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_50);
    highp vec2 tmpvar_51;
    tmpvar_51.y = 0.0;
    tmpvar_51.x = tmpvar_33.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_27.xy + tmpvar_51);
    tmpvar_52.z = shadowCoord_27.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_54);
    highp vec2 tmpvar_55;
    tmpvar_55.x = -(LIGHT_PARAM.z);
    tmpvar_55.y = tmpvar_33.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (shadowCoord_27.xy + tmpvar_55);
    tmpvar_56.z = shadowCoord_27.z;
    highp vec4 tmpvar_57;
    tmpvar_57 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_56.xy);
    highp float tmpvar_58;
    if ((tmpvar_57.x < xlv_TEXCOORD4.z)) {
      tmpvar_58 = 0.0;
    } else {
      tmpvar_58 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_58);
    highp vec2 tmpvar_59;
    tmpvar_59.x = 0.0;
    tmpvar_59.y = tmpvar_33.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (shadowCoord_27.xy + tmpvar_59);
    tmpvar_60.z = shadowCoord_27.z;
    highp vec4 tmpvar_61;
    tmpvar_61 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_60.xy);
    highp float tmpvar_62;
    if ((tmpvar_61.x < xlv_TEXCOORD4.z)) {
      tmpvar_62 = 0.0;
    } else {
      tmpvar_62 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_62);
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (shadowCoord_27.xy + LIGHT_PARAM.zz);
    tmpvar_63.z = shadowCoord_27.z;
    highp vec4 tmpvar_64;
    tmpvar_64 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_63.xy);
    highp float tmpvar_65;
    if ((tmpvar_64.x < xlv_TEXCOORD4.z)) {
      tmpvar_65 = 0.0;
    } else {
      tmpvar_65 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_65);
    shadow_32 = (shadow_32 / 9.0);
    tmpvar_28 = mix (1.0, shadow_32, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_66;
  highp vec3 tmpvar_67;
  tmpvar_66 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_67 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_68;
  highp vec3 specularEnv_69;
  highp vec3 color_70;
  mediump float surfaceReduction_71;
  mediump float diffuseTerm_72;
  highp float perceptualRoughness_73;
  mediump vec3 tmpvar_74;
  mediump vec3 albedo_75;
  albedo_75 = tmpvar_2;
  mediump vec3 specColor_76;
  specColor_76 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_75 * tmpvar_3));
  mediump float tmpvar_77;
  tmpvar_77 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_74 = (albedo_75 * tmpvar_77);
  tmpvar_68 = 0.0;
  mediump float alpha_78;
  alpha_78 = tmpvar_68;
  tmpvar_68 = alpha_78;
  mediump float tmpvar_79;
  tmpvar_79 = (1.0 - tmpvar_4);
  perceptualRoughness_73 = tmpvar_79;
  highp vec3 tmpvar_80;
  highp vec3 inVec_81;
  inVec_81 = (tmpvar_67 + tmpvar_66);
  tmpvar_80 = (inVec_81 * inversesqrt(max (0.001, 
    dot (inVec_81, inVec_81)
  )));
  highp float tmpvar_82;
  tmpvar_82 = abs(dot (tmpvar_66, normalWorld_6));
  highp float tmpvar_83;
  tmpvar_83 = clamp (dot (normalWorld_6, tmpvar_67), 0.0, 1.0);
  highp float tmpvar_84;
  tmpvar_84 = clamp (dot (normalWorld_6, tmpvar_80), 0.0, 1.0);
  mediump float tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = clamp (dot (tmpvar_67, tmpvar_80), 0.0, 1.0);
  tmpvar_85 = tmpvar_86;
  mediump float tmpvar_87;
  mediump float NdotV_88;
  NdotV_88 = tmpvar_82;
  mediump float NdotL_89;
  NdotL_89 = tmpvar_83;
  mediump float perceptualRoughness_90;
  perceptualRoughness_90 = perceptualRoughness_73;
  mediump float tmpvar_91;
  tmpvar_91 = (0.5 + ((2.0 * tmpvar_85) * (tmpvar_85 * perceptualRoughness_90)));
  mediump float x_92;
  x_92 = (1.0 - NdotL_89);
  mediump float x_93;
  x_93 = (1.0 - NdotV_88);
  tmpvar_87 = ((1.0 + (
    (tmpvar_91 - 1.0)
   * 
    ((x_92 * x_92) * ((x_92 * x_92) * x_92))
  )) * (1.0 + (
    (tmpvar_91 - 1.0)
   * 
    ((x_93 * x_93) * ((x_93 * x_93) * x_93))
  )));
  highp float tmpvar_94;
  tmpvar_94 = (tmpvar_87 * tmpvar_83);
  diffuseTerm_72 = tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = max ((perceptualRoughness_73 * perceptualRoughness_73), 0.002);
  highp float tmpvar_96;
  tmpvar_96 = (tmpvar_95 * tmpvar_95);
  highp float tmpvar_97;
  tmpvar_97 = (((
    (tmpvar_84 * tmpvar_96)
   - tmpvar_84) * tmpvar_84) + 1.0);
  surfaceReduction_71 = (1.0 - ((0.28 * tmpvar_95) * perceptualRoughness_73));
  mediump vec3 tmpvar_98;
  mediump float x_99;
  x_99 = (1.0 - tmpvar_85);
  tmpvar_98 = (specColor_76 + ((1.0 - specColor_76) * (
    (x_99 * x_99)
   * 
    ((x_99 * x_99) * x_99)
  )));
  color_70 = (((
    (tmpvar_74 * LIGHT_COLOR)
   * diffuseTerm_72) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_96)
       / 
        ((tmpvar_97 * tmpvar_97) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_83 * (
          (tmpvar_82 * (1.0 - tmpvar_95))
         + tmpvar_95)) + (tmpvar_82 * (
          (tmpvar_83 * (1.0 - tmpvar_95))
         + tmpvar_95))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_83)) * LIGHT_COLOR)
   * tmpvar_98)) * tmpvar_28);
  color_70 = (color_70 + tmpvar_5);
  color_70 = (color_70 + (tmpvar_74 * rgbm_24.xyz));
  mediump float cosA_100;
  cosA_100 = tmpvar_82;
  mediump float tmpvar_101;
  mediump float x_102;
  x_102 = (1.0 - cosA_100);
  tmpvar_101 = ((x_102 * x_102) * ((x_102 * x_102) * x_102));
  mediump vec3 tmpvar_103;
  tmpvar_103 = (surfaceReduction_71 * ((specColor_76 * 
    (1.0 - tmpvar_101)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_77)), 0.0, 1.0)
  ) * tmpvar_101)));
  specularEnv_69 = tmpvar_103;
  color_70 = (color_70 + (specularEnv_69 * rgbm_16.xyz));
  outColor_1.xyz = color_70;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalWorld_5;
  highp vec3 normalTangent_6;
  highp vec3 emissionMapColor_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_7 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_13;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  normalWorld_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_14;
  tmpvar_14.x = xlv_TEXCOORD1.w;
  tmpvar_14.y = xlv_TEXCOORD2.w;
  tmpvar_14.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_15;
  highp vec3 tmpvar_16;
  highp vec3 I_17;
  I_17 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_14)));
  tmpvar_16 = (I_17 - (2.0 * (
    dot (normalWorld_5, I_17)
   * normalWorld_5)));
  highp mat2 tmpvar_18;
  tmpvar_18[0].x = 1.0;
  tmpvar_18[0].y = 0.0;
  tmpvar_18[1].x = -0.0;
  tmpvar_18[1].y = 1.0;
  highp vec3 tmpvar_19;
  tmpvar_19.xy = (tmpvar_18 * tmpvar_16.xz);
  tmpvar_19.z = tmpvar_16.y;
  highp vec4 tmpvar_20;
  tmpvar_20.xyz = tmpvar_19.xzy;
  tmpvar_20.w = ((1.0 - (mg_8.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_19.xzy, tmpvar_20.w);
  highp vec4 tmpvar_22;
  tmpvar_22 = tmpvar_21;
  rgbm_15.w = tmpvar_22.w;
  rgbm_15.xyz = ((tmpvar_22.xyz * tmpvar_22.w) * 6.0);
  highp vec4 rgbm_23;
  lowp vec4 tmpvar_24;
  tmpvar_24 = textureCube (_IrradianceMap, normalWorld_5);
  highp vec4 tmpvar_25;
  tmpvar_25 = tmpvar_24;
  rgbm_23.w = tmpvar_25.w;
  rgbm_23.xyz = ((tmpvar_25.xyz * tmpvar_25.w) * 6.0);
  tmpvar_2 = col_9.xyz;
  tmpvar_3 = (mg_8.x * _Metallic);
  tmpvar_4 = (mg_8.y * _Smoothness);
  highp float tmpvar_26;
  highp vec3 specularEnv_27;
  highp vec3 color_28;
  mediump float surfaceReduction_29;
  highp float perceptualRoughness_30;
  mediump vec3 tmpvar_31;
  mediump vec3 albedo_32;
  albedo_32 = tmpvar_2;
  mediump float tmpvar_33;
  tmpvar_33 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_31 = (albedo_32 * tmpvar_33);
  tmpvar_26 = 0.0;
  mediump float alpha_34;
  alpha_34 = tmpvar_26;
  tmpvar_26 = alpha_34;
  mediump float tmpvar_35;
  tmpvar_35 = (1.0 - tmpvar_4);
  perceptualRoughness_30 = tmpvar_35;
  highp float tmpvar_36;
  tmpvar_36 = abs(dot (normalize(
    (CAMERA_WORLDPOSITION - tmpvar_14)
  ), normalWorld_5));
  highp float tmpvar_37;
  tmpvar_37 = max ((perceptualRoughness_30 * perceptualRoughness_30), 0.002);
  surfaceReduction_29 = (1.0 - ((0.28 * tmpvar_37) * perceptualRoughness_30));
  color_28 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_7));
  color_28 = (color_28 + (tmpvar_31 * rgbm_23.xyz));
  mediump float cosA_38;
  cosA_38 = tmpvar_36;
  mediump float tmpvar_39;
  mediump float x_40;
  x_40 = (1.0 - cosA_38);
  tmpvar_39 = ((x_40 * x_40) * ((x_40 * x_40) * x_40));
  mediump vec3 tmpvar_41;
  tmpvar_41 = (surfaceReduction_29 * ((
    ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_32 * tmpvar_3))
   * 
    (1.0 - tmpvar_39)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_33)), 0.0, 1.0)
  ) * tmpvar_39)));
  specularEnv_27 = tmpvar_41;
  color_28 = (color_28 + (specularEnv_27 * rgbm_15.xyz));
  outColor_1.xyz = color_28;
  outColor_1.w = 1.0;
  if (((col_9.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalWorld_5;
  highp vec3 normalTangent_6;
  highp vec3 emissionMapColor_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_7 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_13;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  normalWorld_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_14;
  tmpvar_14.x = xlv_TEXCOORD1.w;
  tmpvar_14.y = xlv_TEXCOORD2.w;
  tmpvar_14.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_15;
  highp vec3 tmpvar_16;
  highp vec3 I_17;
  I_17 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_14)));
  tmpvar_16 = (I_17 - (2.0 * (
    dot (normalWorld_5, I_17)
   * normalWorld_5)));
  highp mat2 tmpvar_18;
  tmpvar_18[0].x = 1.0;
  tmpvar_18[0].y = 0.0;
  tmpvar_18[1].x = -0.0;
  tmpvar_18[1].y = 1.0;
  highp vec3 tmpvar_19;
  tmpvar_19.xy = (tmpvar_18 * tmpvar_16.xz);
  tmpvar_19.z = tmpvar_16.y;
  highp vec4 tmpvar_20;
  tmpvar_20.xyz = tmpvar_19.xzy;
  tmpvar_20.w = ((1.0 - (mg_8.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_19.xzy, tmpvar_20.w);
  highp vec4 tmpvar_22;
  tmpvar_22 = tmpvar_21;
  rgbm_15.w = tmpvar_22.w;
  rgbm_15.xyz = ((tmpvar_22.xyz * tmpvar_22.w) * 6.0);
  highp vec4 rgbm_23;
  lowp vec4 tmpvar_24;
  tmpvar_24 = textureCube (_IrradianceMap, normalWorld_5);
  highp vec4 tmpvar_25;
  tmpvar_25 = tmpvar_24;
  rgbm_23.w = tmpvar_25.w;
  rgbm_23.xyz = ((tmpvar_25.xyz * tmpvar_25.w) * 6.0);
  tmpvar_2 = col_9.xyz;
  tmpvar_3 = (mg_8.x * _Metallic);
  tmpvar_4 = (mg_8.y * _Smoothness);
  highp vec3 tmpvar_26;
  highp vec3 tmpvar_27;
  tmpvar_26 = normalize((CAMERA_WORLDPOSITION - tmpvar_14));
  tmpvar_27 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_28;
  highp vec3 specularEnv_29;
  highp vec3 color_30;
  mediump float surfaceReduction_31;
  mediump float diffuseTerm_32;
  highp float perceptualRoughness_33;
  mediump vec3 tmpvar_34;
  mediump vec3 albedo_35;
  albedo_35 = tmpvar_2;
  mediump vec3 specColor_36;
  specColor_36 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_35 * tmpvar_3));
  mediump float tmpvar_37;
  tmpvar_37 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_34 = (albedo_35 * tmpvar_37);
  tmpvar_28 = 0.0;
  mediump float alpha_38;
  alpha_38 = tmpvar_28;
  tmpvar_28 = alpha_38;
  mediump float tmpvar_39;
  tmpvar_39 = (1.0 - tmpvar_4);
  perceptualRoughness_33 = tmpvar_39;
  highp vec3 tmpvar_40;
  highp vec3 inVec_41;
  inVec_41 = (tmpvar_27 + tmpvar_26);
  tmpvar_40 = (inVec_41 * inversesqrt(max (0.001, 
    dot (inVec_41, inVec_41)
  )));
  highp float tmpvar_42;
  tmpvar_42 = abs(dot (tmpvar_26, normalWorld_5));
  highp float tmpvar_43;
  tmpvar_43 = clamp (dot (normalWorld_5, tmpvar_27), 0.0, 1.0);
  highp float tmpvar_44;
  tmpvar_44 = clamp (dot (normalWorld_5, tmpvar_40), 0.0, 1.0);
  mediump float tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = clamp (dot (tmpvar_27, tmpvar_40), 0.0, 1.0);
  tmpvar_45 = tmpvar_46;
  mediump float tmpvar_47;
  mediump float NdotV_48;
  NdotV_48 = tmpvar_42;
  mediump float NdotL_49;
  NdotL_49 = tmpvar_43;
  mediump float perceptualRoughness_50;
  perceptualRoughness_50 = perceptualRoughness_33;
  mediump float tmpvar_51;
  tmpvar_51 = (0.5 + ((2.0 * tmpvar_45) * (tmpvar_45 * perceptualRoughness_50)));
  mediump float x_52;
  x_52 = (1.0 - NdotL_49);
  mediump float x_53;
  x_53 = (1.0 - NdotV_48);
  tmpvar_47 = ((1.0 + (
    (tmpvar_51 - 1.0)
   * 
    ((x_52 * x_52) * ((x_52 * x_52) * x_52))
  )) * (1.0 + (
    (tmpvar_51 - 1.0)
   * 
    ((x_53 * x_53) * ((x_53 * x_53) * x_53))
  )));
  highp float tmpvar_54;
  tmpvar_54 = (tmpvar_47 * tmpvar_43);
  diffuseTerm_32 = tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = max ((perceptualRoughness_33 * perceptualRoughness_33), 0.002);
  highp float tmpvar_56;
  tmpvar_56 = (tmpvar_55 * tmpvar_55);
  highp float tmpvar_57;
  tmpvar_57 = (((
    (tmpvar_44 * tmpvar_56)
   - tmpvar_44) * tmpvar_44) + 1.0);
  surfaceReduction_31 = (1.0 - ((0.28 * tmpvar_55) * perceptualRoughness_33));
  mediump vec3 tmpvar_58;
  mediump float x_59;
  x_59 = (1.0 - tmpvar_45);
  tmpvar_58 = (specColor_36 + ((1.0 - specColor_36) * (
    (x_59 * x_59)
   * 
    ((x_59 * x_59) * x_59)
  )));
  color_30 = (((tmpvar_34 * LIGHT_COLOR) * diffuseTerm_32) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_56) / (
        (tmpvar_57 * tmpvar_57)
       + 1e-7)) * (0.5 / (
        ((tmpvar_43 * ((tmpvar_42 * 
          (1.0 - tmpvar_55)
        ) + tmpvar_55)) + (tmpvar_42 * ((tmpvar_43 * 
          (1.0 - tmpvar_55)
        ) + tmpvar_55)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_43))
   * LIGHT_COLOR) * tmpvar_58));
  color_30 = (color_30 + (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_7)));
  color_30 = (color_30 + (tmpvar_34 * rgbm_23.xyz));
  mediump float cosA_60;
  cosA_60 = tmpvar_42;
  mediump float tmpvar_61;
  mediump float x_62;
  x_62 = (1.0 - cosA_60);
  tmpvar_61 = ((x_62 * x_62) * ((x_62 * x_62) * x_62));
  mediump vec3 tmpvar_63;
  tmpvar_63 = (surfaceReduction_31 * ((specColor_36 * 
    (1.0 - tmpvar_61)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_37)), 0.0, 1.0)
  ) * tmpvar_61)));
  specularEnv_29 = tmpvar_63;
  color_30 = (color_30 + (specularEnv_29 * rgbm_15.xyz));
  outColor_1.xyz = color_30;
  outColor_1.w = 1.0;
  if (((col_9.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_16;
  highp vec3 tmpvar_17;
  highp vec3 I_18;
  I_18 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  tmpvar_17 = (I_18 - (2.0 * (
    dot (normalWorld_6, I_18)
   * normalWorld_6)));
  highp mat2 tmpvar_19;
  tmpvar_19[0].x = 1.0;
  tmpvar_19[0].y = 0.0;
  tmpvar_19[1].x = -0.0;
  tmpvar_19[1].y = 1.0;
  highp vec3 tmpvar_20;
  tmpvar_20.xy = (tmpvar_19 * tmpvar_17.xz);
  tmpvar_20.z = tmpvar_17.y;
  highp vec4 tmpvar_21;
  tmpvar_21.xyz = tmpvar_20.xzy;
  tmpvar_21.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_20.xzy, tmpvar_21.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  rgbm_16.w = tmpvar_23.w;
  rgbm_16.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 6.0);
  highp vec4 rgbm_24;
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_24.w = tmpvar_26.w;
  rgbm_24.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  tmpvar_2 = col_10.xyz;
  tmpvar_3 = (mg_9.x * _Metallic);
  tmpvar_4 = (mg_9.y * _Smoothness);
  tmpvar_5 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  highp vec4 shadowCoord_27;
  shadowCoord_27 = xlv_TEXCOORD4;
  highp float tmpvar_28;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_28 = 1.0;
  } else {
    shadowCoord_27.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_29;
    highp vec2 fetchesOffsetsU_30;
    highp float shadow_31;
    highp vec2 tmpvar_32;
    tmpvar_32 = (shadowCoord_27.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_33;
    tmpvar_33 = floor((tmpvar_32 + 0.5));
    highp vec2 tmpvar_34;
    tmpvar_34 = (tmpvar_32 - tmpvar_33);
    highp vec4 computedWeight_35;
    highp vec4 computedArea_36;
    highp vec4 computedAreaUncut_37;
    highp float tmpvar_38;
    tmpvar_38 = (((tmpvar_34.x + 0.5) * (tmpvar_34.x + 0.5)) * 0.5);
    highp float tmpvar_39;
    tmpvar_39 = (tmpvar_38 - tmpvar_34.x);
    computedArea_36.x = tmpvar_39;
    computedAreaUncut_37.x = tmpvar_39;
    computedArea_36.w = tmpvar_38;
    computedAreaUncut_37.w = tmpvar_38;
    computedAreaUncut_37.y = ((1.5 - tmpvar_34.x) - 0.5);
    highp float tmpvar_40;
    tmpvar_40 = min (tmpvar_34.x, 0.0);
    computedArea_36.y = (computedAreaUncut_37.y - (tmpvar_40 * tmpvar_40));
    computedAreaUncut_37.z = ((1.5 + tmpvar_34.x) - 0.5);
    highp float tmpvar_41;
    tmpvar_41 = max (tmpvar_34.x, 0.0);
    computedArea_36.z = (computedAreaUncut_37.z - (tmpvar_41 * tmpvar_41));
    computedWeight_35 = (computedArea_36 * 0.44444);
    highp vec4 computedWeight_42;
    highp vec4 computedArea_43;
    highp vec4 computedAreaUncut_44;
    highp float tmpvar_45;
    tmpvar_45 = (((tmpvar_34.y + 0.5) * (tmpvar_34.y + 0.5)) * 0.5);
    highp float tmpvar_46;
    tmpvar_46 = (tmpvar_45 - tmpvar_34.y);
    computedArea_43.x = tmpvar_46;
    computedAreaUncut_44.x = tmpvar_46;
    computedArea_43.w = tmpvar_45;
    computedAreaUncut_44.w = tmpvar_45;
    computedAreaUncut_44.y = ((1.5 - tmpvar_34.y) - 0.5);
    highp float tmpvar_47;
    tmpvar_47 = min (tmpvar_34.y, 0.0);
    computedArea_43.y = (computedAreaUncut_44.y - (tmpvar_47 * tmpvar_47));
    computedAreaUncut_44.z = ((1.5 + tmpvar_34.y) - 0.5);
    highp float tmpvar_48;
    tmpvar_48 = max (tmpvar_34.y, 0.0);
    computedArea_43.z = (computedAreaUncut_44.z - (tmpvar_48 * tmpvar_48));
    computedWeight_42 = (computedArea_43 * 0.44444);
    highp vec2 tmpvar_49;
    tmpvar_49 = (computedWeight_35.xz + computedWeight_35.yw);
    highp vec2 tmpvar_50;
    tmpvar_50 = (computedWeight_42.xz + computedWeight_42.yw);
    fetchesOffsetsU_30 = (((computedWeight_35.yw / tmpvar_49) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_29 = (((computedWeight_42.yw / tmpvar_50) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_51;
    tmpvar_51 = (tmpvar_33 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_30.x;
    tmpvar_52.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_51 + tmpvar_52);
    tmpvar_53.z = shadowCoord_27.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_31 = ((tmpvar_49.x * tmpvar_50.x) * tmpvar_54);
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_30.y;
    tmpvar_55.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_51 + tmpvar_55);
    tmpvar_56.z = shadowCoord_27.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_31 = (shadow_31 + ((tmpvar_49.y * tmpvar_50.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_30.x;
    tmpvar_58.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_51 + tmpvar_58);
    tmpvar_59.z = shadowCoord_27.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_31 = (shadow_31 + ((tmpvar_49.x * tmpvar_50.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_30.y;
    tmpvar_61.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_51 + tmpvar_61);
    tmpvar_62.z = shadowCoord_27.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_31 = (shadow_31 + ((tmpvar_49.y * tmpvar_50.y) * tmpvar_63));
    tmpvar_28 = mix (1.0, shadow_31, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_64;
  highp vec3 tmpvar_65;
  tmpvar_64 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_65 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_66;
  highp vec3 specularEnv_67;
  highp vec3 color_68;
  mediump float surfaceReduction_69;
  mediump float diffuseTerm_70;
  highp float perceptualRoughness_71;
  mediump vec3 tmpvar_72;
  mediump vec3 albedo_73;
  albedo_73 = tmpvar_2;
  mediump vec3 specColor_74;
  specColor_74 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_73 * tmpvar_3));
  mediump float tmpvar_75;
  tmpvar_75 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_72 = (albedo_73 * tmpvar_75);
  tmpvar_66 = 0.0;
  mediump float alpha_76;
  alpha_76 = tmpvar_66;
  tmpvar_66 = alpha_76;
  mediump float tmpvar_77;
  tmpvar_77 = (1.0 - tmpvar_4);
  perceptualRoughness_71 = tmpvar_77;
  highp vec3 tmpvar_78;
  highp vec3 inVec_79;
  inVec_79 = (tmpvar_65 + tmpvar_64);
  tmpvar_78 = (inVec_79 * inversesqrt(max (0.001, 
    dot (inVec_79, inVec_79)
  )));
  highp float tmpvar_80;
  tmpvar_80 = abs(dot (tmpvar_64, normalWorld_6));
  highp float tmpvar_81;
  tmpvar_81 = clamp (dot (normalWorld_6, tmpvar_65), 0.0, 1.0);
  highp float tmpvar_82;
  tmpvar_82 = clamp (dot (normalWorld_6, tmpvar_78), 0.0, 1.0);
  mediump float tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = clamp (dot (tmpvar_65, tmpvar_78), 0.0, 1.0);
  tmpvar_83 = tmpvar_84;
  mediump float tmpvar_85;
  mediump float NdotV_86;
  NdotV_86 = tmpvar_80;
  mediump float NdotL_87;
  NdotL_87 = tmpvar_81;
  mediump float perceptualRoughness_88;
  perceptualRoughness_88 = perceptualRoughness_71;
  mediump float tmpvar_89;
  tmpvar_89 = (0.5 + ((2.0 * tmpvar_83) * (tmpvar_83 * perceptualRoughness_88)));
  mediump float x_90;
  x_90 = (1.0 - NdotL_87);
  mediump float x_91;
  x_91 = (1.0 - NdotV_86);
  tmpvar_85 = ((1.0 + (
    (tmpvar_89 - 1.0)
   * 
    ((x_90 * x_90) * ((x_90 * x_90) * x_90))
  )) * (1.0 + (
    (tmpvar_89 - 1.0)
   * 
    ((x_91 * x_91) * ((x_91 * x_91) * x_91))
  )));
  highp float tmpvar_92;
  tmpvar_92 = (tmpvar_85 * tmpvar_81);
  diffuseTerm_70 = tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = max ((perceptualRoughness_71 * perceptualRoughness_71), 0.002);
  highp float tmpvar_94;
  tmpvar_94 = (tmpvar_93 * tmpvar_93);
  highp float tmpvar_95;
  tmpvar_95 = (((
    (tmpvar_82 * tmpvar_94)
   - tmpvar_82) * tmpvar_82) + 1.0);
  surfaceReduction_69 = (1.0 - ((0.28 * tmpvar_93) * perceptualRoughness_71));
  mediump vec3 tmpvar_96;
  mediump float x_97;
  x_97 = (1.0 - tmpvar_83);
  tmpvar_96 = (specColor_74 + ((1.0 - specColor_74) * (
    (x_97 * x_97)
   * 
    ((x_97 * x_97) * x_97)
  )));
  color_68 = (((
    (tmpvar_72 * LIGHT_COLOR)
   * diffuseTerm_70) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_94)
       / 
        ((tmpvar_95 * tmpvar_95) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_81 * (
          (tmpvar_80 * (1.0 - tmpvar_93))
         + tmpvar_93)) + (tmpvar_80 * (
          (tmpvar_81 * (1.0 - tmpvar_93))
         + tmpvar_93))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_81)) * LIGHT_COLOR)
   * tmpvar_96)) * tmpvar_28);
  color_68 = (color_68 + tmpvar_5);
  color_68 = (color_68 + (tmpvar_72 * rgbm_24.xyz));
  mediump float cosA_98;
  cosA_98 = tmpvar_80;
  mediump float tmpvar_99;
  mediump float x_100;
  x_100 = (1.0 - cosA_98);
  tmpvar_99 = ((x_100 * x_100) * ((x_100 * x_100) * x_100));
  mediump vec3 tmpvar_101;
  tmpvar_101 = (surfaceReduction_69 * ((specColor_74 * 
    (1.0 - tmpvar_99)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_75)), 0.0, 1.0)
  ) * tmpvar_99)));
  specularEnv_67 = tmpvar_101;
  color_68 = (color_68 + (specularEnv_67 * rgbm_16.xyz));
  outColor_1.xyz = color_68;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_16;
  highp vec3 tmpvar_17;
  highp vec3 I_18;
  I_18 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  tmpvar_17 = (I_18 - (2.0 * (
    dot (normalWorld_6, I_18)
   * normalWorld_6)));
  highp mat2 tmpvar_19;
  tmpvar_19[0].x = 1.0;
  tmpvar_19[0].y = 0.0;
  tmpvar_19[1].x = -0.0;
  tmpvar_19[1].y = 1.0;
  highp vec3 tmpvar_20;
  tmpvar_20.xy = (tmpvar_19 * tmpvar_17.xz);
  tmpvar_20.z = tmpvar_17.y;
  highp vec4 tmpvar_21;
  tmpvar_21.xyz = tmpvar_20.xzy;
  tmpvar_21.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_20.xzy, tmpvar_21.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  rgbm_16.w = tmpvar_23.w;
  rgbm_16.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 6.0);
  highp vec4 rgbm_24;
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_24.w = tmpvar_26.w;
  rgbm_24.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  tmpvar_2 = col_10.xyz;
  tmpvar_3 = (mg_9.x * _Metallic);
  tmpvar_4 = (mg_9.y * _Smoothness);
  tmpvar_5 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  highp vec4 shadowCoord_27;
  shadowCoord_27 = xlv_TEXCOORD4;
  highp float tmpvar_28;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_28 = 1.0;
  } else {
    shadowCoord_27.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_29;
    highp vec3 fetchesOffsetsU_30;
    highp float shadow_31;
    highp vec2 tmpvar_32;
    tmpvar_32 = (shadowCoord_27.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_33;
    tmpvar_33 = floor((tmpvar_32 + 0.5));
    highp vec2 tmpvar_34;
    tmpvar_34 = (tmpvar_32 - tmpvar_33);
    highp vec3 texelsWeightsA_35;
    highp vec3 texelsWeightsB_36;
    highp vec4 computedArea_37;
    highp vec4 computedAreaUncut_38;
    highp float tmpvar_39;
    tmpvar_39 = (((tmpvar_34.x + 0.5) * (tmpvar_34.x + 0.5)) * 0.5);
    highp float tmpvar_40;
    tmpvar_40 = (tmpvar_39 - tmpvar_34.x);
    computedArea_37.x = tmpvar_40;
    computedAreaUncut_38.x = tmpvar_40;
    computedArea_37.w = tmpvar_39;
    computedAreaUncut_38.w = tmpvar_39;
    computedAreaUncut_38.y = ((1.5 - tmpvar_34.x) - 0.5);
    highp float tmpvar_41;
    tmpvar_41 = min (tmpvar_34.x, 0.0);
    computedArea_37.y = (computedAreaUncut_38.y - (tmpvar_41 * tmpvar_41));
    computedAreaUncut_38.z = ((1.5 + tmpvar_34.x) - 0.5);
    highp float tmpvar_42;
    tmpvar_42 = max (tmpvar_34.x, 0.0);
    computedArea_37.z = (computedAreaUncut_38.z - (tmpvar_42 * tmpvar_42));
    texelsWeightsA_35.x = (0.16 * tmpvar_40);
    texelsWeightsA_35.y = (0.16 * computedAreaUncut_38.y);
    texelsWeightsA_35.z = (0.16 * (computedArea_37.y + 1.0));
    texelsWeightsB_36.x = (0.16 * (computedArea_37.z + 1.0));
    texelsWeightsB_36.y = (0.16 * computedAreaUncut_38.z);
    texelsWeightsB_36.z = (0.16 * tmpvar_39);
    highp vec3 texelsWeightsA_43;
    highp vec3 texelsWeightsB_44;
    highp vec4 computedArea_45;
    highp vec4 computedAreaUncut_46;
    highp float tmpvar_47;
    tmpvar_47 = (((tmpvar_34.y + 0.5) * (tmpvar_34.y + 0.5)) * 0.5);
    highp float tmpvar_48;
    tmpvar_48 = (tmpvar_47 - tmpvar_34.y);
    computedArea_45.x = tmpvar_48;
    computedAreaUncut_46.x = tmpvar_48;
    computedArea_45.w = tmpvar_47;
    computedAreaUncut_46.w = tmpvar_47;
    computedAreaUncut_46.y = ((1.5 - tmpvar_34.y) - 0.5);
    highp float tmpvar_49;
    tmpvar_49 = min (tmpvar_34.y, 0.0);
    computedArea_45.y = (computedAreaUncut_46.y - (tmpvar_49 * tmpvar_49));
    computedAreaUncut_46.z = ((1.5 + tmpvar_34.y) - 0.5);
    highp float tmpvar_50;
    tmpvar_50 = max (tmpvar_34.y, 0.0);
    computedArea_45.z = (computedAreaUncut_46.z - (tmpvar_50 * tmpvar_50));
    texelsWeightsA_43.x = (0.16 * tmpvar_48);
    texelsWeightsA_43.y = (0.16 * computedAreaUncut_46.y);
    texelsWeightsA_43.z = (0.16 * (computedArea_45.y + 1.0));
    texelsWeightsB_44.x = (0.16 * (computedArea_45.z + 1.0));
    texelsWeightsB_44.y = (0.16 * computedAreaUncut_46.z);
    texelsWeightsB_44.z = (0.16 * tmpvar_47);
    highp vec3 tmpvar_51;
    tmpvar_51.xy = texelsWeightsA_35.xz;
    tmpvar_51.z = texelsWeightsB_36.y;
    highp vec3 tmpvar_52;
    tmpvar_52.x = texelsWeightsA_35.y;
    tmpvar_52.yz = texelsWeightsB_36.xz;
    highp vec3 tmpvar_53;
    tmpvar_53 = (tmpvar_51 + tmpvar_52);
    highp vec3 tmpvar_54;
    tmpvar_54.xy = texelsWeightsA_43.xz;
    tmpvar_54.z = texelsWeightsB_44.y;
    highp vec3 tmpvar_55;
    tmpvar_55.x = texelsWeightsA_43.y;
    tmpvar_55.yz = texelsWeightsB_44.xz;
    highp vec3 tmpvar_56;
    tmpvar_56 = (tmpvar_54 + tmpvar_55);
    highp vec3 tmpvar_57;
    tmpvar_57.x = texelsWeightsA_35.y;
    tmpvar_57.yz = texelsWeightsB_36.xz;
    highp vec3 tmpvar_58;
    tmpvar_58.x = texelsWeightsA_43.y;
    tmpvar_58.yz = texelsWeightsB_44.xz;
    fetchesOffsetsU_30 = (((tmpvar_57 / tmpvar_53) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_29 = (((tmpvar_58 / tmpvar_56) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_59;
    tmpvar_59 = (tmpvar_33 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_30.x;
    tmpvar_60.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_59 + tmpvar_60);
    tmpvar_61.z = shadowCoord_27.z;
    lowp float tmpvar_62;
    tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_31 = ((tmpvar_53.x * tmpvar_56.x) * tmpvar_62);
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_30.y;
    tmpvar_63.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_59 + tmpvar_63);
    tmpvar_64.z = shadowCoord_27.z;
    lowp float tmpvar_65;
    tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.x) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_30.z;
    tmpvar_66.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_59 + tmpvar_66);
    tmpvar_67.z = shadowCoord_27.z;
    lowp float tmpvar_68;
    tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.x) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_30.x;
    tmpvar_69.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_59 + tmpvar_69);
    tmpvar_70.z = shadowCoord_27.z;
    lowp float tmpvar_71;
    tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.y) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_30.y;
    tmpvar_72.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_59 + tmpvar_72);
    tmpvar_73.z = shadowCoord_27.z;
    lowp float tmpvar_74;
    tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.y) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_30.z;
    tmpvar_75.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_59 + tmpvar_75);
    tmpvar_76.z = shadowCoord_27.z;
    lowp float tmpvar_77;
    tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.y) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_30.x;
    tmpvar_78.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_59 + tmpvar_78);
    tmpvar_79.z = shadowCoord_27.z;
    lowp float tmpvar_80;
    tmpvar_80 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.z) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_30.y;
    tmpvar_81.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_59 + tmpvar_81);
    tmpvar_82.z = shadowCoord_27.z;
    lowp float tmpvar_83;
    tmpvar_83 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.z) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_30.z;
    tmpvar_84.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_59 + tmpvar_84);
    tmpvar_85.z = shadowCoord_27.z;
    lowp float tmpvar_86;
    tmpvar_86 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.z) * tmpvar_86));
    tmpvar_28 = mix (1.0, shadow_31, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_87;
  highp vec3 tmpvar_88;
  tmpvar_87 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_88 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_89;
  highp vec3 specularEnv_90;
  highp vec3 color_91;
  mediump float surfaceReduction_92;
  mediump float diffuseTerm_93;
  highp float perceptualRoughness_94;
  mediump vec3 tmpvar_95;
  mediump vec3 albedo_96;
  albedo_96 = tmpvar_2;
  mediump vec3 specColor_97;
  specColor_97 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_96 * tmpvar_3));
  mediump float tmpvar_98;
  tmpvar_98 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_95 = (albedo_96 * tmpvar_98);
  tmpvar_89 = 0.0;
  mediump float alpha_99;
  alpha_99 = tmpvar_89;
  tmpvar_89 = alpha_99;
  mediump float tmpvar_100;
  tmpvar_100 = (1.0 - tmpvar_4);
  perceptualRoughness_94 = tmpvar_100;
  highp vec3 tmpvar_101;
  highp vec3 inVec_102;
  inVec_102 = (tmpvar_88 + tmpvar_87);
  tmpvar_101 = (inVec_102 * inversesqrt(max (0.001, 
    dot (inVec_102, inVec_102)
  )));
  highp float tmpvar_103;
  tmpvar_103 = abs(dot (tmpvar_87, normalWorld_6));
  highp float tmpvar_104;
  tmpvar_104 = clamp (dot (normalWorld_6, tmpvar_88), 0.0, 1.0);
  highp float tmpvar_105;
  tmpvar_105 = clamp (dot (normalWorld_6, tmpvar_101), 0.0, 1.0);
  mediump float tmpvar_106;
  highp float tmpvar_107;
  tmpvar_107 = clamp (dot (tmpvar_88, tmpvar_101), 0.0, 1.0);
  tmpvar_106 = tmpvar_107;
  mediump float tmpvar_108;
  mediump float NdotV_109;
  NdotV_109 = tmpvar_103;
  mediump float NdotL_110;
  NdotL_110 = tmpvar_104;
  mediump float perceptualRoughness_111;
  perceptualRoughness_111 = perceptualRoughness_94;
  mediump float tmpvar_112;
  tmpvar_112 = (0.5 + ((2.0 * tmpvar_106) * (tmpvar_106 * perceptualRoughness_111)));
  mediump float x_113;
  x_113 = (1.0 - NdotL_110);
  mediump float x_114;
  x_114 = (1.0 - NdotV_109);
  tmpvar_108 = ((1.0 + (
    (tmpvar_112 - 1.0)
   * 
    ((x_113 * x_113) * ((x_113 * x_113) * x_113))
  )) * (1.0 + (
    (tmpvar_112 - 1.0)
   * 
    ((x_114 * x_114) * ((x_114 * x_114) * x_114))
  )));
  highp float tmpvar_115;
  tmpvar_115 = (tmpvar_108 * tmpvar_104);
  diffuseTerm_93 = tmpvar_115;
  highp float tmpvar_116;
  tmpvar_116 = max ((perceptualRoughness_94 * perceptualRoughness_94), 0.002);
  highp float tmpvar_117;
  tmpvar_117 = (tmpvar_116 * tmpvar_116);
  highp float tmpvar_118;
  tmpvar_118 = (((
    (tmpvar_105 * tmpvar_117)
   - tmpvar_105) * tmpvar_105) + 1.0);
  surfaceReduction_92 = (1.0 - ((0.28 * tmpvar_116) * perceptualRoughness_94));
  mediump vec3 tmpvar_119;
  mediump float x_120;
  x_120 = (1.0 - tmpvar_106);
  tmpvar_119 = (specColor_97 + ((1.0 - specColor_97) * (
    (x_120 * x_120)
   * 
    ((x_120 * x_120) * x_120)
  )));
  color_91 = (((
    (tmpvar_95 * LIGHT_COLOR)
   * diffuseTerm_93) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_117)
       / 
        ((tmpvar_118 * tmpvar_118) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_104 * (
          (tmpvar_103 * (1.0 - tmpvar_116))
         + tmpvar_116)) + (tmpvar_103 * (
          (tmpvar_104 * (1.0 - tmpvar_116))
         + tmpvar_116))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_104)) * LIGHT_COLOR)
   * tmpvar_119)) * tmpvar_28);
  color_91 = (color_91 + tmpvar_5);
  color_91 = (color_91 + (tmpvar_95 * rgbm_24.xyz));
  mediump float cosA_121;
  cosA_121 = tmpvar_103;
  mediump float tmpvar_122;
  mediump float x_123;
  x_123 = (1.0 - cosA_121);
  tmpvar_122 = ((x_123 * x_123) * ((x_123 * x_123) * x_123));
  mediump vec3 tmpvar_124;
  tmpvar_124 = (surfaceReduction_92 * ((specColor_97 * 
    (1.0 - tmpvar_122)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_98)), 0.0, 1.0)
  ) * tmpvar_122)));
  specularEnv_90 = tmpvar_124;
  color_91 = (color_91 + (specularEnv_90 * rgbm_16.xyz));
  outColor_1.xyz = color_91;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_16;
  highp vec3 tmpvar_17;
  highp vec3 I_18;
  I_18 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  tmpvar_17 = (I_18 - (2.0 * (
    dot (normalWorld_6, I_18)
   * normalWorld_6)));
  highp mat2 tmpvar_19;
  tmpvar_19[0].x = 1.0;
  tmpvar_19[0].y = 0.0;
  tmpvar_19[1].x = -0.0;
  tmpvar_19[1].y = 1.0;
  highp vec3 tmpvar_20;
  tmpvar_20.xy = (tmpvar_19 * tmpvar_17.xz);
  tmpvar_20.z = tmpvar_17.y;
  highp vec4 tmpvar_21;
  tmpvar_21.xyz = tmpvar_20.xzy;
  tmpvar_21.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_20.xzy, tmpvar_21.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  rgbm_16.w = tmpvar_23.w;
  rgbm_16.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 6.0);
  highp vec4 rgbm_24;
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_24.w = tmpvar_26.w;
  rgbm_24.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  tmpvar_2 = col_10.xyz;
  tmpvar_3 = (mg_9.x * _Metallic);
  tmpvar_4 = (mg_9.y * _Smoothness);
  tmpvar_5 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  highp vec4 shadowCoord_27;
  shadowCoord_27 = xlv_TEXCOORD4;
  highp float tmpvar_28;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_28 = 1.0;
  } else {
    shadowCoord_27.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_29;
    highp vec4 fetchesOffsetsU_30;
    highp float shadow_31;
    highp vec2 tmpvar_32;
    tmpvar_32 = (shadowCoord_27.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_33;
    tmpvar_33 = floor((tmpvar_32 + 0.5));
    highp vec2 tmpvar_34;
    tmpvar_34 = (tmpvar_32 - tmpvar_33);
    highp vec4 texelsWeightsA_35;
    highp vec4 texelsWeightsB_36;
    highp vec4 computedArea_37;
    highp vec4 computedAreaUncut_38;
    highp float tmpvar_39;
    tmpvar_39 = (((tmpvar_34.x + 0.5) * (tmpvar_34.x + 0.5)) * 0.5);
    highp float tmpvar_40;
    tmpvar_40 = (tmpvar_39 - tmpvar_34.x);
    computedArea_37.x = tmpvar_40;
    computedAreaUncut_38.x = tmpvar_40;
    computedArea_37.w = tmpvar_39;
    computedAreaUncut_38.w = tmpvar_39;
    computedAreaUncut_38.y = ((1.5 - tmpvar_34.x) - 0.5);
    highp float tmpvar_41;
    tmpvar_41 = min (tmpvar_34.x, 0.0);
    computedArea_37.y = (computedAreaUncut_38.y - (tmpvar_41 * tmpvar_41));
    computedAreaUncut_38.z = ((1.5 + tmpvar_34.x) - 0.5);
    highp float tmpvar_42;
    tmpvar_42 = max (tmpvar_34.x, 0.0);
    computedArea_37.z = (computedAreaUncut_38.z - (tmpvar_42 * tmpvar_42));
    texelsWeightsA_35.x = (0.081632 * tmpvar_40);
    texelsWeightsA_35.y = (0.081632 * computedAreaUncut_38.y);
    texelsWeightsA_35.z = (0.081632 * (computedAreaUncut_38.y + 1.0));
    texelsWeightsA_35.w = (0.081632 * (computedArea_37.y + 2.0));
    texelsWeightsB_36.x = (0.081632 * (computedArea_37.z + 2.0));
    texelsWeightsB_36.y = (0.081632 * (computedAreaUncut_38.z + 1.0));
    texelsWeightsB_36.z = (0.081632 * computedAreaUncut_38.z);
    texelsWeightsB_36.w = (0.081632 * tmpvar_39);
    highp vec4 texelsWeightsA_43;
    highp vec4 texelsWeightsB_44;
    highp vec4 computedArea_45;
    highp vec4 computedAreaUncut_46;
    highp float tmpvar_47;
    tmpvar_47 = (((tmpvar_34.y + 0.5) * (tmpvar_34.y + 0.5)) * 0.5);
    highp float tmpvar_48;
    tmpvar_48 = (tmpvar_47 - tmpvar_34.y);
    computedArea_45.x = tmpvar_48;
    computedAreaUncut_46.x = tmpvar_48;
    computedArea_45.w = tmpvar_47;
    computedAreaUncut_46.w = tmpvar_47;
    computedAreaUncut_46.y = ((1.5 - tmpvar_34.y) - 0.5);
    highp float tmpvar_49;
    tmpvar_49 = min (tmpvar_34.y, 0.0);
    computedArea_45.y = (computedAreaUncut_46.y - (tmpvar_49 * tmpvar_49));
    computedAreaUncut_46.z = ((1.5 + tmpvar_34.y) - 0.5);
    highp float tmpvar_50;
    tmpvar_50 = max (tmpvar_34.y, 0.0);
    computedArea_45.z = (computedAreaUncut_46.z - (tmpvar_50 * tmpvar_50));
    texelsWeightsA_43.x = (0.081632 * tmpvar_48);
    texelsWeightsA_43.y = (0.081632 * computedAreaUncut_46.y);
    texelsWeightsA_43.z = (0.081632 * (computedAreaUncut_46.y + 1.0));
    texelsWeightsA_43.w = (0.081632 * (computedArea_45.y + 2.0));
    texelsWeightsB_44.x = (0.081632 * (computedArea_45.z + 2.0));
    texelsWeightsB_44.y = (0.081632 * (computedAreaUncut_46.z + 1.0));
    texelsWeightsB_44.z = (0.081632 * computedAreaUncut_46.z);
    texelsWeightsB_44.w = (0.081632 * tmpvar_47);
    highp vec4 tmpvar_51;
    tmpvar_51.xy = texelsWeightsA_35.xz;
    tmpvar_51.zw = texelsWeightsB_36.xz;
    highp vec4 tmpvar_52;
    tmpvar_52.xy = texelsWeightsA_35.yw;
    tmpvar_52.zw = texelsWeightsB_36.yw;
    highp vec4 tmpvar_53;
    tmpvar_53 = (tmpvar_51 + tmpvar_52);
    highp vec4 tmpvar_54;
    tmpvar_54.xy = texelsWeightsA_43.xz;
    tmpvar_54.zw = texelsWeightsB_44.xz;
    highp vec4 tmpvar_55;
    tmpvar_55.xy = texelsWeightsA_43.yw;
    tmpvar_55.zw = texelsWeightsB_44.yw;
    highp vec4 tmpvar_56;
    tmpvar_56 = (tmpvar_54 + tmpvar_55);
    highp vec4 tmpvar_57;
    tmpvar_57.xy = texelsWeightsA_35.yw;
    tmpvar_57.zw = texelsWeightsB_36.yw;
    highp vec4 tmpvar_58;
    tmpvar_58.xy = texelsWeightsA_43.yw;
    tmpvar_58.zw = texelsWeightsB_44.yw;
    fetchesOffsetsU_30 = (((tmpvar_57 / tmpvar_53) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_29 = (((tmpvar_58 / tmpvar_56) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_59;
    tmpvar_59 = (tmpvar_33 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_30.x;
    tmpvar_60.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_59 + tmpvar_60);
    tmpvar_61.z = shadowCoord_27.z;
    lowp float tmpvar_62;
    tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_31 = ((tmpvar_53.x * tmpvar_56.x) * tmpvar_62);
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_30.y;
    tmpvar_63.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_59 + tmpvar_63);
    tmpvar_64.z = shadowCoord_27.z;
    lowp float tmpvar_65;
    tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.x) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_30.z;
    tmpvar_66.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_59 + tmpvar_66);
    tmpvar_67.z = shadowCoord_27.z;
    lowp float tmpvar_68;
    tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.x) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_30.w;
    tmpvar_69.y = fetchesOffsetsV_29.x;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_59 + tmpvar_69);
    tmpvar_70.z = shadowCoord_27.z;
    lowp float tmpvar_71;
    tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_31 = (shadow_31 + ((tmpvar_53.w * tmpvar_56.x) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_30.x;
    tmpvar_72.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_59 + tmpvar_72);
    tmpvar_73.z = shadowCoord_27.z;
    lowp float tmpvar_74;
    tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.y) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_30.y;
    tmpvar_75.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_59 + tmpvar_75);
    tmpvar_76.z = shadowCoord_27.z;
    lowp float tmpvar_77;
    tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.y) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_30.z;
    tmpvar_78.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_59 + tmpvar_78);
    tmpvar_79.z = shadowCoord_27.z;
    lowp float tmpvar_80;
    tmpvar_80 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.y) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_30.w;
    tmpvar_81.y = fetchesOffsetsV_29.y;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_59 + tmpvar_81);
    tmpvar_82.z = shadowCoord_27.z;
    lowp float tmpvar_83;
    tmpvar_83 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_31 = (shadow_31 + ((tmpvar_53.w * tmpvar_56.y) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_30.x;
    tmpvar_84.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_59 + tmpvar_84);
    tmpvar_85.z = shadowCoord_27.z;
    lowp float tmpvar_86;
    tmpvar_86 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.z) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_30.y;
    tmpvar_87.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_59 + tmpvar_87);
    tmpvar_88.z = shadowCoord_27.z;
    lowp float tmpvar_89;
    tmpvar_89 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.z) * tmpvar_89));
    highp vec2 tmpvar_90;
    tmpvar_90.x = fetchesOffsetsU_30.z;
    tmpvar_90.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_91;
    tmpvar_91.xy = (tmpvar_59 + tmpvar_90);
    tmpvar_91.z = shadowCoord_27.z;
    lowp float tmpvar_92;
    tmpvar_92 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_91);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.z) * tmpvar_92));
    highp vec2 tmpvar_93;
    tmpvar_93.x = fetchesOffsetsU_30.w;
    tmpvar_93.y = fetchesOffsetsV_29.z;
    highp vec3 tmpvar_94;
    tmpvar_94.xy = (tmpvar_59 + tmpvar_93);
    tmpvar_94.z = shadowCoord_27.z;
    lowp float tmpvar_95;
    tmpvar_95 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_94);
    shadow_31 = (shadow_31 + ((tmpvar_53.w * tmpvar_56.z) * tmpvar_95));
    highp vec2 tmpvar_96;
    tmpvar_96.x = fetchesOffsetsU_30.x;
    tmpvar_96.y = fetchesOffsetsV_29.w;
    highp vec3 tmpvar_97;
    tmpvar_97.xy = (tmpvar_59 + tmpvar_96);
    tmpvar_97.z = shadowCoord_27.z;
    lowp float tmpvar_98;
    tmpvar_98 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_97);
    shadow_31 = (shadow_31 + ((tmpvar_53.x * tmpvar_56.w) * tmpvar_98));
    highp vec2 tmpvar_99;
    tmpvar_99.x = fetchesOffsetsU_30.y;
    tmpvar_99.y = fetchesOffsetsV_29.w;
    highp vec3 tmpvar_100;
    tmpvar_100.xy = (tmpvar_59 + tmpvar_99);
    tmpvar_100.z = shadowCoord_27.z;
    lowp float tmpvar_101;
    tmpvar_101 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_100);
    shadow_31 = (shadow_31 + ((tmpvar_53.y * tmpvar_56.w) * tmpvar_101));
    highp vec2 tmpvar_102;
    tmpvar_102.x = fetchesOffsetsU_30.z;
    tmpvar_102.y = fetchesOffsetsV_29.w;
    highp vec3 tmpvar_103;
    tmpvar_103.xy = (tmpvar_59 + tmpvar_102);
    tmpvar_103.z = shadowCoord_27.z;
    lowp float tmpvar_104;
    tmpvar_104 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_103);
    shadow_31 = (shadow_31 + ((tmpvar_53.z * tmpvar_56.w) * tmpvar_104));
    highp vec2 tmpvar_105;
    tmpvar_105.x = fetchesOffsetsU_30.w;
    tmpvar_105.y = fetchesOffsetsV_29.w;
    highp vec3 tmpvar_106;
    tmpvar_106.xy = (tmpvar_59 + tmpvar_105);
    tmpvar_106.z = shadowCoord_27.z;
    lowp float tmpvar_107;
    tmpvar_107 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_106);
    shadow_31 = (shadow_31 + ((tmpvar_53.w * tmpvar_56.w) * tmpvar_107));
    tmpvar_28 = mix (1.0, shadow_31, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_108;
  highp vec3 tmpvar_109;
  tmpvar_108 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_109 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_110;
  highp vec3 specularEnv_111;
  highp vec3 color_112;
  mediump float surfaceReduction_113;
  mediump float diffuseTerm_114;
  highp float perceptualRoughness_115;
  mediump vec3 tmpvar_116;
  mediump vec3 albedo_117;
  albedo_117 = tmpvar_2;
  mediump vec3 specColor_118;
  specColor_118 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_117 * tmpvar_3));
  mediump float tmpvar_119;
  tmpvar_119 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_116 = (albedo_117 * tmpvar_119);
  tmpvar_110 = 0.0;
  mediump float alpha_120;
  alpha_120 = tmpvar_110;
  tmpvar_110 = alpha_120;
  mediump float tmpvar_121;
  tmpvar_121 = (1.0 - tmpvar_4);
  perceptualRoughness_115 = tmpvar_121;
  highp vec3 tmpvar_122;
  highp vec3 inVec_123;
  inVec_123 = (tmpvar_109 + tmpvar_108);
  tmpvar_122 = (inVec_123 * inversesqrt(max (0.001, 
    dot (inVec_123, inVec_123)
  )));
  highp float tmpvar_124;
  tmpvar_124 = abs(dot (tmpvar_108, normalWorld_6));
  highp float tmpvar_125;
  tmpvar_125 = clamp (dot (normalWorld_6, tmpvar_109), 0.0, 1.0);
  highp float tmpvar_126;
  tmpvar_126 = clamp (dot (normalWorld_6, tmpvar_122), 0.0, 1.0);
  mediump float tmpvar_127;
  highp float tmpvar_128;
  tmpvar_128 = clamp (dot (tmpvar_109, tmpvar_122), 0.0, 1.0);
  tmpvar_127 = tmpvar_128;
  mediump float tmpvar_129;
  mediump float NdotV_130;
  NdotV_130 = tmpvar_124;
  mediump float NdotL_131;
  NdotL_131 = tmpvar_125;
  mediump float perceptualRoughness_132;
  perceptualRoughness_132 = perceptualRoughness_115;
  mediump float tmpvar_133;
  tmpvar_133 = (0.5 + ((2.0 * tmpvar_127) * (tmpvar_127 * perceptualRoughness_132)));
  mediump float x_134;
  x_134 = (1.0 - NdotL_131);
  mediump float x_135;
  x_135 = (1.0 - NdotV_130);
  tmpvar_129 = ((1.0 + (
    (tmpvar_133 - 1.0)
   * 
    ((x_134 * x_134) * ((x_134 * x_134) * x_134))
  )) * (1.0 + (
    (tmpvar_133 - 1.0)
   * 
    ((x_135 * x_135) * ((x_135 * x_135) * x_135))
  )));
  highp float tmpvar_136;
  tmpvar_136 = (tmpvar_129 * tmpvar_125);
  diffuseTerm_114 = tmpvar_136;
  highp float tmpvar_137;
  tmpvar_137 = max ((perceptualRoughness_115 * perceptualRoughness_115), 0.002);
  highp float tmpvar_138;
  tmpvar_138 = (tmpvar_137 * tmpvar_137);
  highp float tmpvar_139;
  tmpvar_139 = (((
    (tmpvar_126 * tmpvar_138)
   - tmpvar_126) * tmpvar_126) + 1.0);
  surfaceReduction_113 = (1.0 - ((0.28 * tmpvar_137) * perceptualRoughness_115));
  mediump vec3 tmpvar_140;
  mediump float x_141;
  x_141 = (1.0 - tmpvar_127);
  tmpvar_140 = (specColor_118 + ((1.0 - specColor_118) * (
    (x_141 * x_141)
   * 
    ((x_141 * x_141) * x_141)
  )));
  color_112 = (((
    (tmpvar_116 * LIGHT_COLOR)
   * diffuseTerm_114) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_138)
       / 
        ((tmpvar_139 * tmpvar_139) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_125 * (
          (tmpvar_124 * (1.0 - tmpvar_137))
         + tmpvar_137)) + (tmpvar_124 * (
          (tmpvar_125 * (1.0 - tmpvar_137))
         + tmpvar_137))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_125)) * LIGHT_COLOR)
   * tmpvar_140)) * tmpvar_28);
  color_112 = (color_112 + tmpvar_5);
  color_112 = (color_112 + (tmpvar_116 * rgbm_24.xyz));
  mediump float cosA_142;
  cosA_142 = tmpvar_124;
  mediump float tmpvar_143;
  mediump float x_144;
  x_144 = (1.0 - cosA_142);
  tmpvar_143 = ((x_144 * x_144) * ((x_144 * x_144) * x_144));
  mediump vec3 tmpvar_145;
  tmpvar_145 = (surfaceReduction_113 * ((specColor_118 * 
    (1.0 - tmpvar_143)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_119)), 0.0, 1.0)
  ) * tmpvar_143)));
  specularEnv_111 = tmpvar_145;
  color_112 = (color_112 + (specularEnv_111 * rgbm_16.xyz));
  outColor_1.xyz = color_112;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_16;
  highp vec3 tmpvar_17;
  highp vec3 I_18;
  I_18 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  tmpvar_17 = (I_18 - (2.0 * (
    dot (normalWorld_6, I_18)
   * normalWorld_6)));
  highp mat2 tmpvar_19;
  tmpvar_19[0].x = 1.0;
  tmpvar_19[0].y = 0.0;
  tmpvar_19[1].x = -0.0;
  tmpvar_19[1].y = 1.0;
  highp vec3 tmpvar_20;
  tmpvar_20.xy = (tmpvar_19 * tmpvar_17.xz);
  tmpvar_20.z = tmpvar_17.y;
  highp vec4 tmpvar_21;
  tmpvar_21.xyz = tmpvar_20.xzy;
  tmpvar_21.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_20.xzy, tmpvar_21.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  rgbm_16.w = tmpvar_23.w;
  rgbm_16.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 6.0);
  highp vec4 rgbm_24;
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_24.w = tmpvar_26.w;
  rgbm_24.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  tmpvar_2 = col_10.xyz;
  tmpvar_3 = (mg_9.x * _Metallic);
  tmpvar_4 = (mg_9.y * _Smoothness);
  tmpvar_5 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  highp vec4 shadowCoord_27;
  shadowCoord_27 = xlv_TEXCOORD4;
  highp float tmpvar_28;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_28 = 1.0;
  } else {
    highp vec2 tmpvar_29;
    tmpvar_29.x = LIGHT_PARAM.z;
    tmpvar_29.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = tmpvar_29;
    highp float tmpvar_31;
    tmpvar_31 = (1.0/(LIGHT_PARAM.z));
    tmpvar_30.z = tmpvar_31;
    tmpvar_30.w = tmpvar_31;
    shadowCoord_27.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_32;
    highp vec2 tmpvar_33;
    tmpvar_33 = tmpvar_30.xy;
    shadow_32 = 0.0;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_27.xy - LIGHT_PARAM.zz);
    tmpvar_34.z = shadowCoord_27.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_32 = tmpvar_36;
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_27.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_27.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_32 = (tmpvar_36 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = tmpvar_33.x;
    tmpvar_41.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_27.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_27.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.y = 0.0;
    tmpvar_45.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (shadowCoord_27.xy + tmpvar_45);
    tmpvar_46.z = shadowCoord_27.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_48);
    highp vec4 tmpvar_49;
    tmpvar_49 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_27.xy);
    highp float tmpvar_50;
    if ((tmpvar_49.x < xlv_TEXCOORD4.z)) {
      tmpvar_50 = 0.0;
    } else {
      tmpvar_50 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_50);
    highp vec2 tmpvar_51;
    tmpvar_51.y = 0.0;
    tmpvar_51.x = tmpvar_33.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_27.xy + tmpvar_51);
    tmpvar_52.z = shadowCoord_27.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_54);
    highp vec2 tmpvar_55;
    tmpvar_55.x = -(LIGHT_PARAM.z);
    tmpvar_55.y = tmpvar_33.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (shadowCoord_27.xy + tmpvar_55);
    tmpvar_56.z = shadowCoord_27.z;
    highp vec4 tmpvar_57;
    tmpvar_57 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_56.xy);
    highp float tmpvar_58;
    if ((tmpvar_57.x < xlv_TEXCOORD4.z)) {
      tmpvar_58 = 0.0;
    } else {
      tmpvar_58 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_58);
    highp vec2 tmpvar_59;
    tmpvar_59.x = 0.0;
    tmpvar_59.y = tmpvar_33.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (shadowCoord_27.xy + tmpvar_59);
    tmpvar_60.z = shadowCoord_27.z;
    highp vec4 tmpvar_61;
    tmpvar_61 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_60.xy);
    highp float tmpvar_62;
    if ((tmpvar_61.x < xlv_TEXCOORD4.z)) {
      tmpvar_62 = 0.0;
    } else {
      tmpvar_62 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_62);
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (shadowCoord_27.xy + LIGHT_PARAM.zz);
    tmpvar_63.z = shadowCoord_27.z;
    highp vec4 tmpvar_64;
    tmpvar_64 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_63.xy);
    highp float tmpvar_65;
    if ((tmpvar_64.x < xlv_TEXCOORD4.z)) {
      tmpvar_65 = 0.0;
    } else {
      tmpvar_65 = 1.0;
    };
    shadow_32 = (shadow_32 + tmpvar_65);
    shadow_32 = (shadow_32 / 9.0);
    tmpvar_28 = mix (1.0, shadow_32, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_66;
  highp vec3 tmpvar_67;
  tmpvar_66 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_67 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_68;
  highp vec3 specularEnv_69;
  highp vec3 color_70;
  mediump float surfaceReduction_71;
  mediump float diffuseTerm_72;
  highp float perceptualRoughness_73;
  mediump vec3 tmpvar_74;
  mediump vec3 albedo_75;
  albedo_75 = tmpvar_2;
  mediump vec3 specColor_76;
  specColor_76 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_75 * tmpvar_3));
  mediump float tmpvar_77;
  tmpvar_77 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_74 = (albedo_75 * tmpvar_77);
  tmpvar_68 = 0.0;
  mediump float alpha_78;
  alpha_78 = tmpvar_68;
  tmpvar_68 = alpha_78;
  mediump float tmpvar_79;
  tmpvar_79 = (1.0 - tmpvar_4);
  perceptualRoughness_73 = tmpvar_79;
  highp vec3 tmpvar_80;
  highp vec3 inVec_81;
  inVec_81 = (tmpvar_67 + tmpvar_66);
  tmpvar_80 = (inVec_81 * inversesqrt(max (0.001, 
    dot (inVec_81, inVec_81)
  )));
  highp float tmpvar_82;
  tmpvar_82 = abs(dot (tmpvar_66, normalWorld_6));
  highp float tmpvar_83;
  tmpvar_83 = clamp (dot (normalWorld_6, tmpvar_67), 0.0, 1.0);
  highp float tmpvar_84;
  tmpvar_84 = clamp (dot (normalWorld_6, tmpvar_80), 0.0, 1.0);
  mediump float tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = clamp (dot (tmpvar_67, tmpvar_80), 0.0, 1.0);
  tmpvar_85 = tmpvar_86;
  mediump float tmpvar_87;
  mediump float NdotV_88;
  NdotV_88 = tmpvar_82;
  mediump float NdotL_89;
  NdotL_89 = tmpvar_83;
  mediump float perceptualRoughness_90;
  perceptualRoughness_90 = perceptualRoughness_73;
  mediump float tmpvar_91;
  tmpvar_91 = (0.5 + ((2.0 * tmpvar_85) * (tmpvar_85 * perceptualRoughness_90)));
  mediump float x_92;
  x_92 = (1.0 - NdotL_89);
  mediump float x_93;
  x_93 = (1.0 - NdotV_88);
  tmpvar_87 = ((1.0 + (
    (tmpvar_91 - 1.0)
   * 
    ((x_92 * x_92) * ((x_92 * x_92) * x_92))
  )) * (1.0 + (
    (tmpvar_91 - 1.0)
   * 
    ((x_93 * x_93) * ((x_93 * x_93) * x_93))
  )));
  highp float tmpvar_94;
  tmpvar_94 = (tmpvar_87 * tmpvar_83);
  diffuseTerm_72 = tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = max ((perceptualRoughness_73 * perceptualRoughness_73), 0.002);
  highp float tmpvar_96;
  tmpvar_96 = (tmpvar_95 * tmpvar_95);
  highp float tmpvar_97;
  tmpvar_97 = (((
    (tmpvar_84 * tmpvar_96)
   - tmpvar_84) * tmpvar_84) + 1.0);
  surfaceReduction_71 = (1.0 - ((0.28 * tmpvar_95) * perceptualRoughness_73));
  mediump vec3 tmpvar_98;
  mediump float x_99;
  x_99 = (1.0 - tmpvar_85);
  tmpvar_98 = (specColor_76 + ((1.0 - specColor_76) * (
    (x_99 * x_99)
   * 
    ((x_99 * x_99) * x_99)
  )));
  color_70 = (((
    (tmpvar_74 * LIGHT_COLOR)
   * diffuseTerm_72) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_96)
       / 
        ((tmpvar_97 * tmpvar_97) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_83 * (
          (tmpvar_82 * (1.0 - tmpvar_95))
         + tmpvar_95)) + (tmpvar_82 * (
          (tmpvar_83 * (1.0 - tmpvar_95))
         + tmpvar_95))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_83)) * LIGHT_COLOR)
   * tmpvar_98)) * tmpvar_28);
  color_70 = (color_70 + tmpvar_5);
  color_70 = (color_70 + (tmpvar_74 * rgbm_24.xyz));
  mediump float cosA_100;
  cosA_100 = tmpvar_82;
  mediump float tmpvar_101;
  mediump float x_102;
  x_102 = (1.0 - cosA_100);
  tmpvar_101 = ((x_102 * x_102) * ((x_102 * x_102) * x_102));
  mediump vec3 tmpvar_103;
  tmpvar_103 = (surfaceReduction_71 * ((specColor_76 * 
    (1.0 - tmpvar_101)
  ) + (vec3(
    clamp ((tmpvar_4 + (1.0 - tmpvar_77)), 0.0, 1.0)
  ) * tmpvar_101)));
  specularEnv_69 = tmpvar_103;
  color_70 = (color_70 + (specularEnv_69 * rgbm_16.xyz));
  outColor_1.xyz = color_70;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
}


end

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_15;
  mediump float diffuseTerm_16;
  highp float perceptualRoughness_17;
  mediump vec3 tmpvar_18;
  mediump vec3 albedo_19;
  albedo_19 = tmpvar_2;
  mediump vec3 specColor_20;
  specColor_20 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_19 * tmpvar_3));
  tmpvar_18 = (albedo_19 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_15 = 0.0;
  mediump float alpha_21;
  alpha_21 = tmpvar_15;
  tmpvar_15 = alpha_21;
  mediump float tmpvar_22;
  tmpvar_22 = (1.0 - tmpvar_4);
  perceptualRoughness_17 = tmpvar_22;
  highp vec3 tmpvar_23;
  highp vec3 inVec_24;
  inVec_24 = (tmpvar_13 + tmpvar_12);
  tmpvar_23 = (inVec_24 * inversesqrt(max (0.001, 
    dot (inVec_24, inVec_24)
  )));
  highp float tmpvar_25;
  tmpvar_25 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_26;
  tmpvar_26 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_27;
  tmpvar_27 = clamp (dot (tmpvar_14, tmpvar_23), 0.0, 1.0);
  mediump float tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_13, tmpvar_23), 0.0, 1.0);
  tmpvar_28 = tmpvar_29;
  mediump float tmpvar_30;
  mediump float NdotV_31;
  NdotV_31 = tmpvar_25;
  mediump float NdotL_32;
  NdotL_32 = tmpvar_26;
  mediump float perceptualRoughness_33;
  perceptualRoughness_33 = perceptualRoughness_17;
  mediump float tmpvar_34;
  tmpvar_34 = (0.5 + ((2.0 * tmpvar_28) * (tmpvar_28 * perceptualRoughness_33)));
  mediump float x_35;
  x_35 = (1.0 - NdotL_32);
  mediump float x_36;
  x_36 = (1.0 - NdotV_31);
  tmpvar_30 = ((1.0 + (
    (tmpvar_34 - 1.0)
   * 
    ((x_35 * x_35) * ((x_35 * x_35) * x_35))
  )) * (1.0 + (
    (tmpvar_34 - 1.0)
   * 
    ((x_36 * x_36) * ((x_36 * x_36) * x_36))
  )));
  highp float tmpvar_37;
  tmpvar_37 = (tmpvar_30 * tmpvar_26);
  diffuseTerm_16 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = max ((perceptualRoughness_17 * perceptualRoughness_17), 0.002);
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_38 * tmpvar_38);
  highp float tmpvar_40;
  tmpvar_40 = (((
    (tmpvar_27 * tmpvar_39)
   - tmpvar_27) * tmpvar_27) + 1.0);
  mediump vec3 tmpvar_41;
  mediump float x_42;
  x_42 = (1.0 - tmpvar_28);
  tmpvar_41 = (specColor_20 + ((1.0 - specColor_20) * (
    (x_42 * x_42)
   * 
    ((x_42 * x_42) * x_42)
  )));
  outColor_1.xyz = (((tmpvar_18 * LIGHT_COLOR) * diffuseTerm_16) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_39) / (
        (tmpvar_40 * tmpvar_40)
       + 1e-7)) * (0.5 / (
        ((tmpvar_26 * ((tmpvar_25 * 
          (1.0 - tmpvar_38)
        ) + tmpvar_38)) + (tmpvar_25 * ((tmpvar_26 * 
          (1.0 - tmpvar_38)
        ) + tmpvar_38)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_26))
   * LIGHT_COLOR) * tmpvar_41));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_15;
    highp vec2 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 computedWeight_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_20.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_20.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    computedWeight_21 = (computedArea_22 * 0.44444);
    highp vec4 computedWeight_28;
    highp vec4 computedArea_29;
    highp vec4 computedAreaUncut_30;
    highp float tmpvar_31;
    tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_32;
    tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
    computedArea_29.x = tmpvar_32;
    computedAreaUncut_30.x = tmpvar_32;
    computedArea_29.w = tmpvar_31;
    computedAreaUncut_30.w = tmpvar_31;
    computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = min (tmpvar_20.y, 0.0);
    computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
    computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = max (tmpvar_20.y, 0.0);
    computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
    computedWeight_28 = (computedArea_29 * 0.44444);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
    fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_16.x;
    tmpvar_38.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_13.z;
    lowp float tmpvar_40;
    tmpvar_40 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_16.y;
    tmpvar_41.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_16.x;
    tmpvar_44.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_13.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_16.y;
    tmpvar_47.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_13.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_50;
  highp vec3 tmpvar_51;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_51 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_52;
  mediump float diffuseTerm_53;
  highp float perceptualRoughness_54;
  mediump vec3 tmpvar_55;
  mediump vec3 albedo_56;
  albedo_56 = tmpvar_2;
  mediump vec3 specColor_57;
  specColor_57 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_56 * tmpvar_3));
  tmpvar_55 = (albedo_56 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_52 = 0.0;
  mediump float alpha_58;
  alpha_58 = tmpvar_52;
  tmpvar_52 = alpha_58;
  mediump float tmpvar_59;
  tmpvar_59 = (1.0 - tmpvar_4);
  perceptualRoughness_54 = tmpvar_59;
  highp vec3 tmpvar_60;
  highp vec3 inVec_61;
  inVec_61 = (tmpvar_51 + tmpvar_50);
  tmpvar_60 = (inVec_61 * inversesqrt(max (0.001, 
    dot (inVec_61, inVec_61)
  )));
  highp float tmpvar_62;
  tmpvar_62 = abs(dot (tmpvar_50, tmpvar_5));
  highp float tmpvar_63;
  tmpvar_63 = clamp (dot (tmpvar_5, tmpvar_51), 0.0, 1.0);
  highp float tmpvar_64;
  tmpvar_64 = clamp (dot (tmpvar_5, tmpvar_60), 0.0, 1.0);
  mediump float tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_51, tmpvar_60), 0.0, 1.0);
  tmpvar_65 = tmpvar_66;
  mediump float tmpvar_67;
  mediump float NdotV_68;
  NdotV_68 = tmpvar_62;
  mediump float NdotL_69;
  NdotL_69 = tmpvar_63;
  mediump float perceptualRoughness_70;
  perceptualRoughness_70 = perceptualRoughness_54;
  mediump float tmpvar_71;
  tmpvar_71 = (0.5 + ((2.0 * tmpvar_65) * (tmpvar_65 * perceptualRoughness_70)));
  mediump float x_72;
  x_72 = (1.0 - NdotL_69);
  mediump float x_73;
  x_73 = (1.0 - NdotV_68);
  tmpvar_67 = ((1.0 + (
    (tmpvar_71 - 1.0)
   * 
    ((x_72 * x_72) * ((x_72 * x_72) * x_72))
  )) * (1.0 + (
    (tmpvar_71 - 1.0)
   * 
    ((x_73 * x_73) * ((x_73 * x_73) * x_73))
  )));
  highp float tmpvar_74;
  tmpvar_74 = (tmpvar_67 * tmpvar_63);
  diffuseTerm_53 = tmpvar_74;
  highp float tmpvar_75;
  tmpvar_75 = max ((perceptualRoughness_54 * perceptualRoughness_54), 0.002);
  highp float tmpvar_76;
  tmpvar_76 = (tmpvar_75 * tmpvar_75);
  highp float tmpvar_77;
  tmpvar_77 = (((
    (tmpvar_64 * tmpvar_76)
   - tmpvar_64) * tmpvar_64) + 1.0);
  mediump vec3 tmpvar_78;
  mediump float x_79;
  x_79 = (1.0 - tmpvar_65);
  tmpvar_78 = (specColor_57 + ((1.0 - specColor_57) * (
    (x_79 * x_79)
   * 
    ((x_79 * x_79) * x_79)
  )));
  outColor_1.xyz = (((
    (tmpvar_55 * LIGHT_COLOR)
   * diffuseTerm_53) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_76)
       / 
        ((tmpvar_77 * tmpvar_77) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_63 * (
          (tmpvar_62 * (1.0 - tmpvar_75))
         + tmpvar_75)) + (tmpvar_62 * (
          (tmpvar_63 * (1.0 - tmpvar_75))
         + tmpvar_75))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_63)) * LIGHT_COLOR)
   * tmpvar_78)) * tmpvar_14);
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_15;
    highp vec3 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 texelsWeightsA_29;
    highp vec3 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.16 * tmpvar_34);
    texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
    texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
    texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
    texelsWeightsB_30.z = (0.16 * tmpvar_33);
    highp vec3 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_21.y;
    tmpvar_38.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.z = texelsWeightsB_30.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_29.y;
    tmpvar_41.yz = texelsWeightsB_30.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_21.y;
    tmpvar_43.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_29.y;
    tmpvar_44.yz = texelsWeightsB_30.xz;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    lowp float tmpvar_48;
    tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.x;
    tmpvar_55.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.y;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.z;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.x;
    tmpvar_64.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.y;
    tmpvar_67.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.z;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_73;
  highp vec3 tmpvar_74;
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_74 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_75;
  mediump float diffuseTerm_76;
  highp float perceptualRoughness_77;
  mediump vec3 tmpvar_78;
  mediump vec3 albedo_79;
  albedo_79 = tmpvar_2;
  mediump vec3 specColor_80;
  specColor_80 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_79 * tmpvar_3));
  tmpvar_78 = (albedo_79 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_75 = 0.0;
  mediump float alpha_81;
  alpha_81 = tmpvar_75;
  tmpvar_75 = alpha_81;
  mediump float tmpvar_82;
  tmpvar_82 = (1.0 - tmpvar_4);
  perceptualRoughness_77 = tmpvar_82;
  highp vec3 tmpvar_83;
  highp vec3 inVec_84;
  inVec_84 = (tmpvar_74 + tmpvar_73);
  tmpvar_83 = (inVec_84 * inversesqrt(max (0.001, 
    dot (inVec_84, inVec_84)
  )));
  highp float tmpvar_85;
  tmpvar_85 = abs(dot (tmpvar_73, tmpvar_5));
  highp float tmpvar_86;
  tmpvar_86 = clamp (dot (tmpvar_5, tmpvar_74), 0.0, 1.0);
  highp float tmpvar_87;
  tmpvar_87 = clamp (dot (tmpvar_5, tmpvar_83), 0.0, 1.0);
  mediump float tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_74, tmpvar_83), 0.0, 1.0);
  tmpvar_88 = tmpvar_89;
  mediump float tmpvar_90;
  mediump float NdotV_91;
  NdotV_91 = tmpvar_85;
  mediump float NdotL_92;
  NdotL_92 = tmpvar_86;
  mediump float perceptualRoughness_93;
  perceptualRoughness_93 = perceptualRoughness_77;
  mediump float tmpvar_94;
  tmpvar_94 = (0.5 + ((2.0 * tmpvar_88) * (tmpvar_88 * perceptualRoughness_93)));
  mediump float x_95;
  x_95 = (1.0 - NdotL_92);
  mediump float x_96;
  x_96 = (1.0 - NdotV_91);
  tmpvar_90 = ((1.0 + (
    (tmpvar_94 - 1.0)
   * 
    ((x_95 * x_95) * ((x_95 * x_95) * x_95))
  )) * (1.0 + (
    (tmpvar_94 - 1.0)
   * 
    ((x_96 * x_96) * ((x_96 * x_96) * x_96))
  )));
  highp float tmpvar_97;
  tmpvar_97 = (tmpvar_90 * tmpvar_86);
  diffuseTerm_76 = tmpvar_97;
  highp float tmpvar_98;
  tmpvar_98 = max ((perceptualRoughness_77 * perceptualRoughness_77), 0.002);
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_98 * tmpvar_98);
  highp float tmpvar_100;
  tmpvar_100 = (((
    (tmpvar_87 * tmpvar_99)
   - tmpvar_87) * tmpvar_87) + 1.0);
  mediump vec3 tmpvar_101;
  mediump float x_102;
  x_102 = (1.0 - tmpvar_88);
  tmpvar_101 = (specColor_80 + ((1.0 - specColor_80) * (
    (x_102 * x_102)
   * 
    ((x_102 * x_102) * x_102)
  )));
  outColor_1.xyz = (((
    (tmpvar_78 * LIGHT_COLOR)
   * diffuseTerm_76) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_99)
       / 
        ((tmpvar_100 * tmpvar_100) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_86 * (
          (tmpvar_85 * (1.0 - tmpvar_98))
         + tmpvar_98)) + (tmpvar_85 * (
          (tmpvar_86 * (1.0 - tmpvar_98))
         + tmpvar_98))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_86)) * LIGHT_COLOR)
   * tmpvar_101)) * tmpvar_14);
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_15;
    highp vec4 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 texelsWeightsA_29;
    highp vec4 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.081632 * tmpvar_34);
    texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
    texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
    texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
    texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
    texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
    texelsWeightsB_30.w = (0.081632 * tmpvar_33);
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_21.yw;
    tmpvar_38.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.zw = texelsWeightsB_30.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_29.yw;
    tmpvar_41.zw = texelsWeightsB_30.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_21.yw;
    tmpvar_43.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_29.yw;
    tmpvar_44.zw = texelsWeightsB_30.yw;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    lowp float tmpvar_48;
    tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.w;
    tmpvar_55.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.x;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.y;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.z;
    tmpvar_64.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.w;
    tmpvar_67.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.x;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_16.y;
    tmpvar_73.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
    tmpvar_74.z = shadowCoord_13.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_16.z;
    tmpvar_76.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
    tmpvar_77.z = shadowCoord_13.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_16.w;
    tmpvar_79.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
    tmpvar_80.z = shadowCoord_13.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_16.x;
    tmpvar_82.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
    tmpvar_83.z = shadowCoord_13.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_16.y;
    tmpvar_85.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
    tmpvar_86.z = shadowCoord_13.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_16.z;
    tmpvar_88.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
    tmpvar_89.z = shadowCoord_13.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_16.w;
    tmpvar_91.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
    tmpvar_92.z = shadowCoord_13.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_94;
  highp vec3 tmpvar_95;
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_95 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_96;
  mediump float diffuseTerm_97;
  highp float perceptualRoughness_98;
  mediump vec3 tmpvar_99;
  mediump vec3 albedo_100;
  albedo_100 = tmpvar_2;
  mediump vec3 specColor_101;
  specColor_101 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_100 * tmpvar_3));
  tmpvar_99 = (albedo_100 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_96 = 0.0;
  mediump float alpha_102;
  alpha_102 = tmpvar_96;
  tmpvar_96 = alpha_102;
  mediump float tmpvar_103;
  tmpvar_103 = (1.0 - tmpvar_4);
  perceptualRoughness_98 = tmpvar_103;
  highp vec3 tmpvar_104;
  highp vec3 inVec_105;
  inVec_105 = (tmpvar_95 + tmpvar_94);
  tmpvar_104 = (inVec_105 * inversesqrt(max (0.001, 
    dot (inVec_105, inVec_105)
  )));
  highp float tmpvar_106;
  tmpvar_106 = abs(dot (tmpvar_94, tmpvar_5));
  highp float tmpvar_107;
  tmpvar_107 = clamp (dot (tmpvar_5, tmpvar_95), 0.0, 1.0);
  highp float tmpvar_108;
  tmpvar_108 = clamp (dot (tmpvar_5, tmpvar_104), 0.0, 1.0);
  mediump float tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_95, tmpvar_104), 0.0, 1.0);
  tmpvar_109 = tmpvar_110;
  mediump float tmpvar_111;
  mediump float NdotV_112;
  NdotV_112 = tmpvar_106;
  mediump float NdotL_113;
  NdotL_113 = tmpvar_107;
  mediump float perceptualRoughness_114;
  perceptualRoughness_114 = perceptualRoughness_98;
  mediump float tmpvar_115;
  tmpvar_115 = (0.5 + ((2.0 * tmpvar_109) * (tmpvar_109 * perceptualRoughness_114)));
  mediump float x_116;
  x_116 = (1.0 - NdotL_113);
  mediump float x_117;
  x_117 = (1.0 - NdotV_112);
  tmpvar_111 = ((1.0 + (
    (tmpvar_115 - 1.0)
   * 
    ((x_116 * x_116) * ((x_116 * x_116) * x_116))
  )) * (1.0 + (
    (tmpvar_115 - 1.0)
   * 
    ((x_117 * x_117) * ((x_117 * x_117) * x_117))
  )));
  highp float tmpvar_118;
  tmpvar_118 = (tmpvar_111 * tmpvar_107);
  diffuseTerm_97 = tmpvar_118;
  highp float tmpvar_119;
  tmpvar_119 = max ((perceptualRoughness_98 * perceptualRoughness_98), 0.002);
  highp float tmpvar_120;
  tmpvar_120 = (tmpvar_119 * tmpvar_119);
  highp float tmpvar_121;
  tmpvar_121 = (((
    (tmpvar_108 * tmpvar_120)
   - tmpvar_108) * tmpvar_108) + 1.0);
  mediump vec3 tmpvar_122;
  mediump float x_123;
  x_123 = (1.0 - tmpvar_109);
  tmpvar_122 = (specColor_101 + ((1.0 - specColor_101) * (
    (x_123 * x_123)
   * 
    ((x_123 * x_123) * x_123)
  )));
  outColor_1.xyz = (((
    (tmpvar_99 * LIGHT_COLOR)
   * diffuseTerm_97) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_120)
       / 
        ((tmpvar_121 * tmpvar_121) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_107 * (
          (tmpvar_106 * (1.0 - tmpvar_119))
         + tmpvar_119)) + (tmpvar_106 * (
          (tmpvar_107 * (1.0 - tmpvar_119))
         + tmpvar_119))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_107)) * LIGHT_COLOR)
   * tmpvar_122)) * tmpvar_14);
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    highp vec2 tmpvar_15;
    tmpvar_15.x = LIGHT_PARAM.z;
    tmpvar_15.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_16;
    tmpvar_16.xy = tmpvar_15;
    highp float tmpvar_17;
    tmpvar_17 = (1.0/(LIGHT_PARAM.z));
    tmpvar_16.z = tmpvar_17;
    tmpvar_16.w = tmpvar_17;
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = tmpvar_16.xy;
    shadow_18 = 0.0;
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_13.xy - LIGHT_PARAM.zz);
    tmpvar_20.z = shadowCoord_13.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_18 = tmpvar_22;
    highp vec2 tmpvar_23;
    tmpvar_23.x = 0.0;
    tmpvar_23.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_13.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_13.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_18 = (tmpvar_22 + tmpvar_26);
    highp vec2 tmpvar_27;
    tmpvar_27.x = tmpvar_19.x;
    tmpvar_27.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_28;
    tmpvar_28.xy = (shadowCoord_13.xy + tmpvar_27);
    tmpvar_28.z = shadowCoord_13.z;
    highp vec4 tmpvar_29;
    tmpvar_29 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_28.xy);
    highp float tmpvar_30;
    if ((tmpvar_29.x < xlv_TEXCOORD4.z)) {
      tmpvar_30 = 0.0;
    } else {
      tmpvar_30 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_30);
    highp vec2 tmpvar_31;
    tmpvar_31.y = 0.0;
    tmpvar_31.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = (shadowCoord_13.xy + tmpvar_31);
    tmpvar_32.z = shadowCoord_13.z;
    highp vec4 tmpvar_33;
    tmpvar_33 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_32.xy);
    highp float tmpvar_34;
    if ((tmpvar_33.x < xlv_TEXCOORD4.z)) {
      tmpvar_34 = 0.0;
    } else {
      tmpvar_34 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_34);
    highp vec4 tmpvar_35;
    tmpvar_35 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_13.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.y = 0.0;
    tmpvar_37.x = tmpvar_19.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_13.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_13.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = -(LIGHT_PARAM.z);
    tmpvar_41.y = tmpvar_19.y;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_13.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = 0.0;
    tmpvar_45.y = tmpvar_19.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (shadowCoord_13.xy + tmpvar_45);
    tmpvar_46.z = shadowCoord_13.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_48);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_13.xy + LIGHT_PARAM.zz);
    tmpvar_49.z = shadowCoord_13.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_51);
    shadow_18 = (shadow_18 / 9.0);
    tmpvar_14 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_52;
  highp vec3 tmpvar_53;
  tmpvar_52 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_53 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_54;
  mediump float diffuseTerm_55;
  highp float perceptualRoughness_56;
  mediump vec3 tmpvar_57;
  mediump vec3 albedo_58;
  albedo_58 = tmpvar_2;
  mediump vec3 specColor_59;
  specColor_59 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_58 * tmpvar_3));
  tmpvar_57 = (albedo_58 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_54 = 0.0;
  mediump float alpha_60;
  alpha_60 = tmpvar_54;
  tmpvar_54 = alpha_60;
  mediump float tmpvar_61;
  tmpvar_61 = (1.0 - tmpvar_4);
  perceptualRoughness_56 = tmpvar_61;
  highp vec3 tmpvar_62;
  highp vec3 inVec_63;
  inVec_63 = (tmpvar_53 + tmpvar_52);
  tmpvar_62 = (inVec_63 * inversesqrt(max (0.001, 
    dot (inVec_63, inVec_63)
  )));
  highp float tmpvar_64;
  tmpvar_64 = abs(dot (tmpvar_52, tmpvar_5));
  highp float tmpvar_65;
  tmpvar_65 = clamp (dot (tmpvar_5, tmpvar_53), 0.0, 1.0);
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_5, tmpvar_62), 0.0, 1.0);
  mediump float tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_53, tmpvar_62), 0.0, 1.0);
  tmpvar_67 = tmpvar_68;
  mediump float tmpvar_69;
  mediump float NdotV_70;
  NdotV_70 = tmpvar_64;
  mediump float NdotL_71;
  NdotL_71 = tmpvar_65;
  mediump float perceptualRoughness_72;
  perceptualRoughness_72 = perceptualRoughness_56;
  mediump float tmpvar_73;
  tmpvar_73 = (0.5 + ((2.0 * tmpvar_67) * (tmpvar_67 * perceptualRoughness_72)));
  mediump float x_74;
  x_74 = (1.0 - NdotL_71);
  mediump float x_75;
  x_75 = (1.0 - NdotV_70);
  tmpvar_69 = ((1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_74 * x_74) * ((x_74 * x_74) * x_74))
  )) * (1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )));
  highp float tmpvar_76;
  tmpvar_76 = (tmpvar_69 * tmpvar_65);
  diffuseTerm_55 = tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = max ((perceptualRoughness_56 * perceptualRoughness_56), 0.002);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_66 * tmpvar_78)
   - tmpvar_66) * tmpvar_66) + 1.0);
  mediump vec3 tmpvar_80;
  mediump float x_81;
  x_81 = (1.0 - tmpvar_67);
  tmpvar_80 = (specColor_59 + ((1.0 - specColor_59) * (
    (x_81 * x_81)
   * 
    ((x_81 * x_81) * x_81)
  )));
  outColor_1.xyz = (((
    (tmpvar_57 * LIGHT_COLOR)
   * diffuseTerm_55) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_78)
       / 
        ((tmpvar_79 * tmpvar_79) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_65 * (
          (tmpvar_64 * (1.0 - tmpvar_77))
         + tmpvar_77)) + (tmpvar_64 * (
          (tmpvar_65 * (1.0 - tmpvar_77))
         + tmpvar_77))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_65)) * LIGHT_COLOR)
   * tmpvar_80)) * tmpvar_14);
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 lightDir_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_14 = normalize(tmpvar_15);
  tmpvar_13 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 tmpvar_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  tmpvar_20 = (albedo_21 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_23;
  alpha_23 = tmpvar_17;
  tmpvar_17 = alpha_23;
  mediump float tmpvar_24;
  tmpvar_24 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_24;
  highp vec3 tmpvar_25;
  highp vec3 inVec_26;
  inVec_26 = (lightDir_14 + tmpvar_12);
  tmpvar_25 = (inVec_26 * inversesqrt(max (0.001, 
    dot (inVec_26, inVec_26)
  )));
  highp float tmpvar_27;
  tmpvar_27 = abs(dot (tmpvar_12, tmpvar_13));
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_13, lightDir_14), 0.0, 1.0);
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_13, tmpvar_25), 0.0, 1.0);
  mediump float tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (lightDir_14, tmpvar_25), 0.0, 1.0);
  tmpvar_30 = tmpvar_31;
  mediump float tmpvar_32;
  mediump float NdotV_33;
  NdotV_33 = tmpvar_27;
  mediump float NdotL_34;
  NdotL_34 = tmpvar_28;
  mediump float perceptualRoughness_35;
  perceptualRoughness_35 = perceptualRoughness_19;
  mediump float tmpvar_36;
  tmpvar_36 = (0.5 + ((2.0 * tmpvar_30) * (tmpvar_30 * perceptualRoughness_35)));
  mediump float x_37;
  x_37 = (1.0 - NdotL_34);
  mediump float x_38;
  x_38 = (1.0 - NdotV_33);
  tmpvar_32 = ((1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )) * (1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_32 * tmpvar_28);
  diffuseTerm_18 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_40 * tmpvar_40);
  highp float tmpvar_42;
  tmpvar_42 = (((
    (tmpvar_29 * tmpvar_41)
   - tmpvar_29) * tmpvar_29) + 1.0);
  mediump vec3 tmpvar_43;
  mediump float x_44;
  x_44 = (1.0 - tmpvar_30);
  tmpvar_43 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_44 * x_44)
   * 
    ((x_44 * x_44) * x_44)
  )));
  outColor_1.xyz = (((
    (tmpvar_20 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_41)
       / 
        ((tmpvar_42 * tmpvar_42) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_28 * (
          (tmpvar_27 * (1.0 - tmpvar_40))
         + tmpvar_40)) + (tmpvar_27 * (
          (tmpvar_28 * (1.0 - tmpvar_40))
         + tmpvar_40))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_28)) * LIGHT_COLOR)
   * tmpvar_43)) * ((
    (1.0 - tmpvar_16)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y)) + ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (lightDir_14, 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec2 fetchesOffsetsV_14;
  highp vec2 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_19.x, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_19.x, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec4 computedWeight_27;
  highp vec4 computedArea_28;
  highp vec4 computedAreaUncut_29;
  highp float tmpvar_30;
  tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
  computedArea_28.x = tmpvar_31;
  computedAreaUncut_29.x = tmpvar_31;
  computedArea_28.w = tmpvar_30;
  computedAreaUncut_29.w = tmpvar_30;
  computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_32;
  tmpvar_32 = min (tmpvar_19.y, 0.0);
  computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
  computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_33;
  tmpvar_33 = max (tmpvar_19.y, 0.0);
  computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
  computedWeight_27 = (computedArea_28 * 0.44444);
  highp vec2 tmpvar_34;
  tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
  highp vec2 tmpvar_35;
  tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
  fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_36;
  tmpvar_36 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37.x = fetchesOffsetsU_15.x;
  tmpvar_37.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_38;
  tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
  tmpvar_38.z = shadowCoord_12.z;
  lowp float tmpvar_39;
  tmpvar_39 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_38);
  shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
  highp vec2 tmpvar_40;
  tmpvar_40.x = fetchesOffsetsU_15.y;
  tmpvar_40.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_41;
  tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
  tmpvar_41.z = shadowCoord_12.z;
  lowp float tmpvar_42;
  tmpvar_42 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_41);
  shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_15.x;
  tmpvar_43.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
  tmpvar_44.z = shadowCoord_12.z;
  lowp float tmpvar_45;
  tmpvar_45 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_44);
  shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_15.y;
  tmpvar_46.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
  tmpvar_47.z = shadowCoord_12.z;
  lowp float tmpvar_48;
  tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
  highp vec3 tmpvar_49;
  highp vec3 tmpvar_50;
  highp vec3 lightDir_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_53;
  tmpvar_53 = clamp ((sqrt(
    dot (tmpvar_52, tmpvar_52)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_51 = normalize(tmpvar_52);
  tmpvar_50 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_49 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_54;
  mediump float diffuseTerm_55;
  highp float perceptualRoughness_56;
  mediump vec3 tmpvar_57;
  mediump vec3 albedo_58;
  albedo_58 = tmpvar_2;
  mediump vec3 specColor_59;
  specColor_59 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_58 * tmpvar_3));
  tmpvar_57 = (albedo_58 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_54 = 0.0;
  mediump float alpha_60;
  alpha_60 = tmpvar_54;
  tmpvar_54 = alpha_60;
  mediump float tmpvar_61;
  tmpvar_61 = (1.0 - tmpvar_4);
  perceptualRoughness_56 = tmpvar_61;
  highp vec3 tmpvar_62;
  highp vec3 inVec_63;
  inVec_63 = (lightDir_51 + tmpvar_49);
  tmpvar_62 = (inVec_63 * inversesqrt(max (0.001, 
    dot (inVec_63, inVec_63)
  )));
  highp float tmpvar_64;
  tmpvar_64 = abs(dot (tmpvar_49, tmpvar_50));
  highp float tmpvar_65;
  tmpvar_65 = clamp (dot (tmpvar_50, lightDir_51), 0.0, 1.0);
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_50, tmpvar_62), 0.0, 1.0);
  mediump float tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (lightDir_51, tmpvar_62), 0.0, 1.0);
  tmpvar_67 = tmpvar_68;
  mediump float tmpvar_69;
  mediump float NdotV_70;
  NdotV_70 = tmpvar_64;
  mediump float NdotL_71;
  NdotL_71 = tmpvar_65;
  mediump float perceptualRoughness_72;
  perceptualRoughness_72 = perceptualRoughness_56;
  mediump float tmpvar_73;
  tmpvar_73 = (0.5 + ((2.0 * tmpvar_67) * (tmpvar_67 * perceptualRoughness_72)));
  mediump float x_74;
  x_74 = (1.0 - NdotL_71);
  mediump float x_75;
  x_75 = (1.0 - NdotV_70);
  tmpvar_69 = ((1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_74 * x_74) * ((x_74 * x_74) * x_74))
  )) * (1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )));
  highp float tmpvar_76;
  tmpvar_76 = (tmpvar_69 * tmpvar_65);
  diffuseTerm_55 = tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = max ((perceptualRoughness_56 * perceptualRoughness_56), 0.002);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_66 * tmpvar_78)
   - tmpvar_66) * tmpvar_66) + 1.0);
  mediump vec3 tmpvar_80;
  mediump float x_81;
  x_81 = (1.0 - tmpvar_67);
  tmpvar_80 = (specColor_59 + ((1.0 - specColor_59) * (
    (x_81 * x_81)
   * 
    ((x_81 * x_81) * x_81)
  )));
  outColor_1.xyz = (((
    (tmpvar_57 * LIGHT_COLOR)
   * diffuseTerm_55) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_78)
       / 
        ((tmpvar_79 * tmpvar_79) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_65 * (
          (tmpvar_64 * (1.0 - tmpvar_77))
         + tmpvar_77)) + (tmpvar_64 * (
          (tmpvar_65 * (1.0 - tmpvar_77))
         + tmpvar_77))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_65)) * LIGHT_COLOR)
   * tmpvar_80)) * ((
    ((1.0 - tmpvar_53) / ((LIGHT_ATTENUATION.x + (tmpvar_53 * LIGHT_ATTENUATION.y)) + ((tmpvar_53 * tmpvar_53) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_51, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec3 fetchesOffsetsV_14;
  highp vec3 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec3 texelsWeightsA_20;
  highp vec3 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_19.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_19.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.16 * tmpvar_25);
  texelsWeightsA_20.y = (0.16 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.16 * (computedArea_22.y + 1.0));
  texelsWeightsB_21.x = (0.16 * (computedArea_22.z + 1.0));
  texelsWeightsB_21.y = (0.16 * computedAreaUncut_23.z);
  texelsWeightsB_21.z = (0.16 * tmpvar_24);
  highp vec3 texelsWeightsA_28;
  highp vec3 texelsWeightsB_29;
  highp vec4 computedArea_30;
  highp vec4 computedAreaUncut_31;
  highp float tmpvar_32;
  tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
  computedArea_30.x = tmpvar_33;
  computedAreaUncut_31.x = tmpvar_33;
  computedArea_30.w = tmpvar_32;
  computedAreaUncut_31.w = tmpvar_32;
  computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = min (tmpvar_19.y, 0.0);
  computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
  computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = max (tmpvar_19.y, 0.0);
  computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
  texelsWeightsA_28.x = (0.16 * tmpvar_33);
  texelsWeightsA_28.y = (0.16 * computedAreaUncut_31.y);
  texelsWeightsA_28.z = (0.16 * (computedArea_30.y + 1.0));
  texelsWeightsB_29.x = (0.16 * (computedArea_30.z + 1.0));
  texelsWeightsB_29.y = (0.16 * computedAreaUncut_31.z);
  texelsWeightsB_29.z = (0.16 * tmpvar_32);
  highp vec3 tmpvar_36;
  tmpvar_36.xy = texelsWeightsA_20.xz;
  tmpvar_36.z = texelsWeightsB_21.y;
  highp vec3 tmpvar_37;
  tmpvar_37.x = texelsWeightsA_20.y;
  tmpvar_37.yz = texelsWeightsB_21.xz;
  highp vec3 tmpvar_38;
  tmpvar_38 = (tmpvar_36 + tmpvar_37);
  highp vec3 tmpvar_39;
  tmpvar_39.xy = texelsWeightsA_28.xz;
  tmpvar_39.z = texelsWeightsB_29.y;
  highp vec3 tmpvar_40;
  tmpvar_40.x = texelsWeightsA_28.y;
  tmpvar_40.yz = texelsWeightsB_29.xz;
  highp vec3 tmpvar_41;
  tmpvar_41 = (tmpvar_39 + tmpvar_40);
  highp vec3 tmpvar_42;
  tmpvar_42.x = texelsWeightsA_20.y;
  tmpvar_42.yz = texelsWeightsB_21.xz;
  highp vec3 tmpvar_43;
  tmpvar_43.x = texelsWeightsA_28.y;
  tmpvar_43.yz = texelsWeightsB_29.xz;
  fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_44;
  tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_45;
  tmpvar_45.x = fetchesOffsetsU_15.x;
  tmpvar_45.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_46;
  tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
  tmpvar_46.z = shadowCoord_12.z;
  lowp float tmpvar_47;
  tmpvar_47 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_46);
  shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
  highp vec2 tmpvar_48;
  tmpvar_48.x = fetchesOffsetsU_15.y;
  tmpvar_48.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_49;
  tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
  tmpvar_49.z = shadowCoord_12.z;
  lowp float tmpvar_50;
  tmpvar_50 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_49);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
  highp vec2 tmpvar_51;
  tmpvar_51.x = fetchesOffsetsU_15.z;
  tmpvar_51.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_52;
  tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
  tmpvar_52.z = shadowCoord_12.z;
  lowp float tmpvar_53;
  tmpvar_53 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_52);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
  highp vec2 tmpvar_54;
  tmpvar_54.x = fetchesOffsetsU_15.x;
  tmpvar_54.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_55;
  tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
  tmpvar_55.z = shadowCoord_12.z;
  lowp float tmpvar_56;
  tmpvar_56 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_55);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_56));
  highp vec2 tmpvar_57;
  tmpvar_57.x = fetchesOffsetsU_15.y;
  tmpvar_57.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_58;
  tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
  tmpvar_58.z = shadowCoord_12.z;
  lowp float tmpvar_59;
  tmpvar_59 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_58);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_59));
  highp vec2 tmpvar_60;
  tmpvar_60.x = fetchesOffsetsU_15.z;
  tmpvar_60.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_61;
  tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
  tmpvar_61.z = shadowCoord_12.z;
  lowp float tmpvar_62;
  tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_62));
  highp vec2 tmpvar_63;
  tmpvar_63.x = fetchesOffsetsU_15.x;
  tmpvar_63.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_64;
  tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
  tmpvar_64.z = shadowCoord_12.z;
  lowp float tmpvar_65;
  tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_65));
  highp vec2 tmpvar_66;
  tmpvar_66.x = fetchesOffsetsU_15.y;
  tmpvar_66.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_67;
  tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
  tmpvar_67.z = shadowCoord_12.z;
  lowp float tmpvar_68;
  tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_68));
  highp vec2 tmpvar_69;
  tmpvar_69.x = fetchesOffsetsU_15.z;
  tmpvar_69.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_70;
  tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
  tmpvar_70.z = shadowCoord_12.z;
  lowp float tmpvar_71;
  tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_71));
  highp vec3 tmpvar_72;
  highp vec3 tmpvar_73;
  highp vec3 lightDir_74;
  highp vec3 tmpvar_75;
  tmpvar_75 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_76;
  tmpvar_76 = clamp ((sqrt(
    dot (tmpvar_75, tmpvar_75)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_74 = normalize(tmpvar_75);
  tmpvar_73 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_72 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_77;
  mediump float diffuseTerm_78;
  highp float perceptualRoughness_79;
  mediump vec3 tmpvar_80;
  mediump vec3 albedo_81;
  albedo_81 = tmpvar_2;
  mediump vec3 specColor_82;
  specColor_82 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_81 * tmpvar_3));
  tmpvar_80 = (albedo_81 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_77 = 0.0;
  mediump float alpha_83;
  alpha_83 = tmpvar_77;
  tmpvar_77 = alpha_83;
  mediump float tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_4);
  perceptualRoughness_79 = tmpvar_84;
  highp vec3 tmpvar_85;
  highp vec3 inVec_86;
  inVec_86 = (lightDir_74 + tmpvar_72);
  tmpvar_85 = (inVec_86 * inversesqrt(max (0.001, 
    dot (inVec_86, inVec_86)
  )));
  highp float tmpvar_87;
  tmpvar_87 = abs(dot (tmpvar_72, tmpvar_73));
  highp float tmpvar_88;
  tmpvar_88 = clamp (dot (tmpvar_73, lightDir_74), 0.0, 1.0);
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_73, tmpvar_85), 0.0, 1.0);
  mediump float tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (lightDir_74, tmpvar_85), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  mediump float tmpvar_92;
  mediump float NdotV_93;
  NdotV_93 = tmpvar_87;
  mediump float NdotL_94;
  NdotL_94 = tmpvar_88;
  mediump float perceptualRoughness_95;
  perceptualRoughness_95 = perceptualRoughness_79;
  mediump float tmpvar_96;
  tmpvar_96 = (0.5 + ((2.0 * tmpvar_90) * (tmpvar_90 * perceptualRoughness_95)));
  mediump float x_97;
  x_97 = (1.0 - NdotL_94);
  mediump float x_98;
  x_98 = (1.0 - NdotV_93);
  tmpvar_92 = ((1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_97 * x_97) * ((x_97 * x_97) * x_97))
  )) * (1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_98 * x_98) * ((x_98 * x_98) * x_98))
  )));
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_92 * tmpvar_88);
  diffuseTerm_78 = tmpvar_99;
  highp float tmpvar_100;
  tmpvar_100 = max ((perceptualRoughness_79 * perceptualRoughness_79), 0.002);
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_100 * tmpvar_100);
  highp float tmpvar_102;
  tmpvar_102 = (((
    (tmpvar_89 * tmpvar_101)
   - tmpvar_89) * tmpvar_89) + 1.0);
  mediump vec3 tmpvar_103;
  mediump float x_104;
  x_104 = (1.0 - tmpvar_90);
  tmpvar_103 = (specColor_82 + ((1.0 - specColor_82) * (
    (x_104 * x_104)
   * 
    ((x_104 * x_104) * x_104)
  )));
  outColor_1.xyz = (((
    (tmpvar_80 * LIGHT_COLOR)
   * diffuseTerm_78) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_101)
       / 
        ((tmpvar_102 * tmpvar_102) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_88 * (
          (tmpvar_87 * (1.0 - tmpvar_100))
         + tmpvar_100)) + (tmpvar_87 * (
          (tmpvar_88 * (1.0 - tmpvar_100))
         + tmpvar_100))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_88)) * LIGHT_COLOR)
   * tmpvar_103)) * ((
    ((1.0 - tmpvar_76) / ((LIGHT_ATTENUATION.x + (tmpvar_76 * LIGHT_ATTENUATION.y)) + ((tmpvar_76 * tmpvar_76) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_74, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec4 fetchesOffsetsV_14;
  highp vec4 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec4 texelsWeightsA_20;
  highp vec4 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_19.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_19.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.081632 * tmpvar_25);
  texelsWeightsA_20.y = (0.081632 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.081632 * (computedAreaUncut_23.y + 1.0));
  texelsWeightsA_20.w = (0.081632 * (computedArea_22.y + 2.0));
  texelsWeightsB_21.x = (0.081632 * (computedArea_22.z + 2.0));
  texelsWeightsB_21.y = (0.081632 * (computedAreaUncut_23.z + 1.0));
  texelsWeightsB_21.z = (0.081632 * computedAreaUncut_23.z);
  texelsWeightsB_21.w = (0.081632 * tmpvar_24);
  highp vec4 texelsWeightsA_28;
  highp vec4 texelsWeightsB_29;
  highp vec4 computedArea_30;
  highp vec4 computedAreaUncut_31;
  highp float tmpvar_32;
  tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
  computedArea_30.x = tmpvar_33;
  computedAreaUncut_31.x = tmpvar_33;
  computedArea_30.w = tmpvar_32;
  computedAreaUncut_31.w = tmpvar_32;
  computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = min (tmpvar_19.y, 0.0);
  computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
  computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = max (tmpvar_19.y, 0.0);
  computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
  texelsWeightsA_28.x = (0.081632 * tmpvar_33);
  texelsWeightsA_28.y = (0.081632 * computedAreaUncut_31.y);
  texelsWeightsA_28.z = (0.081632 * (computedAreaUncut_31.y + 1.0));
  texelsWeightsA_28.w = (0.081632 * (computedArea_30.y + 2.0));
  texelsWeightsB_29.x = (0.081632 * (computedArea_30.z + 2.0));
  texelsWeightsB_29.y = (0.081632 * (computedAreaUncut_31.z + 1.0));
  texelsWeightsB_29.z = (0.081632 * computedAreaUncut_31.z);
  texelsWeightsB_29.w = (0.081632 * tmpvar_32);
  highp vec4 tmpvar_36;
  tmpvar_36.xy = texelsWeightsA_20.xz;
  tmpvar_36.zw = texelsWeightsB_21.xz;
  highp vec4 tmpvar_37;
  tmpvar_37.xy = texelsWeightsA_20.yw;
  tmpvar_37.zw = texelsWeightsB_21.yw;
  highp vec4 tmpvar_38;
  tmpvar_38 = (tmpvar_36 + tmpvar_37);
  highp vec4 tmpvar_39;
  tmpvar_39.xy = texelsWeightsA_28.xz;
  tmpvar_39.zw = texelsWeightsB_29.xz;
  highp vec4 tmpvar_40;
  tmpvar_40.xy = texelsWeightsA_28.yw;
  tmpvar_40.zw = texelsWeightsB_29.yw;
  highp vec4 tmpvar_41;
  tmpvar_41 = (tmpvar_39 + tmpvar_40);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = texelsWeightsA_20.yw;
  tmpvar_42.zw = texelsWeightsB_21.yw;
  highp vec4 tmpvar_43;
  tmpvar_43.xy = texelsWeightsA_28.yw;
  tmpvar_43.zw = texelsWeightsB_29.yw;
  fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_44;
  tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_45;
  tmpvar_45.x = fetchesOffsetsU_15.x;
  tmpvar_45.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_46;
  tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
  tmpvar_46.z = shadowCoord_12.z;
  lowp float tmpvar_47;
  tmpvar_47 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_46);
  shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
  highp vec2 tmpvar_48;
  tmpvar_48.x = fetchesOffsetsU_15.y;
  tmpvar_48.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_49;
  tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
  tmpvar_49.z = shadowCoord_12.z;
  lowp float tmpvar_50;
  tmpvar_50 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_49);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
  highp vec2 tmpvar_51;
  tmpvar_51.x = fetchesOffsetsU_15.z;
  tmpvar_51.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_52;
  tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
  tmpvar_52.z = shadowCoord_12.z;
  lowp float tmpvar_53;
  tmpvar_53 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_52);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
  highp vec2 tmpvar_54;
  tmpvar_54.x = fetchesOffsetsU_15.w;
  tmpvar_54.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_55;
  tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
  tmpvar_55.z = shadowCoord_12.z;
  lowp float tmpvar_56;
  tmpvar_56 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_55);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.x) * tmpvar_56));
  highp vec2 tmpvar_57;
  tmpvar_57.x = fetchesOffsetsU_15.x;
  tmpvar_57.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_58;
  tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
  tmpvar_58.z = shadowCoord_12.z;
  lowp float tmpvar_59;
  tmpvar_59 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_58);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_59));
  highp vec2 tmpvar_60;
  tmpvar_60.x = fetchesOffsetsU_15.y;
  tmpvar_60.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_61;
  tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
  tmpvar_61.z = shadowCoord_12.z;
  lowp float tmpvar_62;
  tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_62));
  highp vec2 tmpvar_63;
  tmpvar_63.x = fetchesOffsetsU_15.z;
  tmpvar_63.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_64;
  tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
  tmpvar_64.z = shadowCoord_12.z;
  lowp float tmpvar_65;
  tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_65));
  highp vec2 tmpvar_66;
  tmpvar_66.x = fetchesOffsetsU_15.w;
  tmpvar_66.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_67;
  tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
  tmpvar_67.z = shadowCoord_12.z;
  lowp float tmpvar_68;
  tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.y) * tmpvar_68));
  highp vec2 tmpvar_69;
  tmpvar_69.x = fetchesOffsetsU_15.x;
  tmpvar_69.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_70;
  tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
  tmpvar_70.z = shadowCoord_12.z;
  lowp float tmpvar_71;
  tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_71));
  highp vec2 tmpvar_72;
  tmpvar_72.x = fetchesOffsetsU_15.y;
  tmpvar_72.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = (tmpvar_44 + tmpvar_72);
  tmpvar_73.z = shadowCoord_12.z;
  lowp float tmpvar_74;
  tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_74));
  highp vec2 tmpvar_75;
  tmpvar_75.x = fetchesOffsetsU_15.z;
  tmpvar_75.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_76;
  tmpvar_76.xy = (tmpvar_44 + tmpvar_75);
  tmpvar_76.z = shadowCoord_12.z;
  lowp float tmpvar_77;
  tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_77));
  highp vec2 tmpvar_78;
  tmpvar_78.x = fetchesOffsetsU_15.w;
  tmpvar_78.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_79;
  tmpvar_79.xy = (tmpvar_44 + tmpvar_78);
  tmpvar_79.z = shadowCoord_12.z;
  lowp float tmpvar_80;
  tmpvar_80 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_79);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.z) * tmpvar_80));
  highp vec2 tmpvar_81;
  tmpvar_81.x = fetchesOffsetsU_15.x;
  tmpvar_81.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_82;
  tmpvar_82.xy = (tmpvar_44 + tmpvar_81);
  tmpvar_82.z = shadowCoord_12.z;
  lowp float tmpvar_83;
  tmpvar_83 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_82);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.w) * tmpvar_83));
  highp vec2 tmpvar_84;
  tmpvar_84.x = fetchesOffsetsU_15.y;
  tmpvar_84.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_85;
  tmpvar_85.xy = (tmpvar_44 + tmpvar_84);
  tmpvar_85.z = shadowCoord_12.z;
  lowp float tmpvar_86;
  tmpvar_86 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_85);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.w) * tmpvar_86));
  highp vec2 tmpvar_87;
  tmpvar_87.x = fetchesOffsetsU_15.z;
  tmpvar_87.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_88;
  tmpvar_88.xy = (tmpvar_44 + tmpvar_87);
  tmpvar_88.z = shadowCoord_12.z;
  lowp float tmpvar_89;
  tmpvar_89 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_88);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.w) * tmpvar_89));
  highp vec2 tmpvar_90;
  tmpvar_90.x = fetchesOffsetsU_15.w;
  tmpvar_90.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_91;
  tmpvar_91.xy = (tmpvar_44 + tmpvar_90);
  tmpvar_91.z = shadowCoord_12.z;
  lowp float tmpvar_92;
  tmpvar_92 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_91);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.w) * tmpvar_92));
  highp vec3 tmpvar_93;
  highp vec3 tmpvar_94;
  highp vec3 lightDir_95;
  highp vec3 tmpvar_96;
  tmpvar_96 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_97;
  tmpvar_97 = clamp ((sqrt(
    dot (tmpvar_96, tmpvar_96)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_95 = normalize(tmpvar_96);
  tmpvar_94 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_93 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_98;
  mediump float diffuseTerm_99;
  highp float perceptualRoughness_100;
  mediump vec3 tmpvar_101;
  mediump vec3 albedo_102;
  albedo_102 = tmpvar_2;
  mediump vec3 specColor_103;
  specColor_103 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_102 * tmpvar_3));
  tmpvar_101 = (albedo_102 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_98 = 0.0;
  mediump float alpha_104;
  alpha_104 = tmpvar_98;
  tmpvar_98 = alpha_104;
  mediump float tmpvar_105;
  tmpvar_105 = (1.0 - tmpvar_4);
  perceptualRoughness_100 = tmpvar_105;
  highp vec3 tmpvar_106;
  highp vec3 inVec_107;
  inVec_107 = (lightDir_95 + tmpvar_93);
  tmpvar_106 = (inVec_107 * inversesqrt(max (0.001, 
    dot (inVec_107, inVec_107)
  )));
  highp float tmpvar_108;
  tmpvar_108 = abs(dot (tmpvar_93, tmpvar_94));
  highp float tmpvar_109;
  tmpvar_109 = clamp (dot (tmpvar_94, lightDir_95), 0.0, 1.0);
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_94, tmpvar_106), 0.0, 1.0);
  mediump float tmpvar_111;
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (lightDir_95, tmpvar_106), 0.0, 1.0);
  tmpvar_111 = tmpvar_112;
  mediump float tmpvar_113;
  mediump float NdotV_114;
  NdotV_114 = tmpvar_108;
  mediump float NdotL_115;
  NdotL_115 = tmpvar_109;
  mediump float perceptualRoughness_116;
  perceptualRoughness_116 = perceptualRoughness_100;
  mediump float tmpvar_117;
  tmpvar_117 = (0.5 + ((2.0 * tmpvar_111) * (tmpvar_111 * perceptualRoughness_116)));
  mediump float x_118;
  x_118 = (1.0 - NdotL_115);
  mediump float x_119;
  x_119 = (1.0 - NdotV_114);
  tmpvar_113 = ((1.0 + (
    (tmpvar_117 - 1.0)
   * 
    ((x_118 * x_118) * ((x_118 * x_118) * x_118))
  )) * (1.0 + (
    (tmpvar_117 - 1.0)
   * 
    ((x_119 * x_119) * ((x_119 * x_119) * x_119))
  )));
  highp float tmpvar_120;
  tmpvar_120 = (tmpvar_113 * tmpvar_109);
  diffuseTerm_99 = tmpvar_120;
  highp float tmpvar_121;
  tmpvar_121 = max ((perceptualRoughness_100 * perceptualRoughness_100), 0.002);
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_121 * tmpvar_121);
  highp float tmpvar_123;
  tmpvar_123 = (((
    (tmpvar_110 * tmpvar_122)
   - tmpvar_110) * tmpvar_110) + 1.0);
  mediump vec3 tmpvar_124;
  mediump float x_125;
  x_125 = (1.0 - tmpvar_111);
  tmpvar_124 = (specColor_103 + ((1.0 - specColor_103) * (
    (x_125 * x_125)
   * 
    ((x_125 * x_125) * x_125)
  )));
  outColor_1.xyz = (((
    (tmpvar_101 * LIGHT_COLOR)
   * diffuseTerm_99) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_122)
       / 
        ((tmpvar_123 * tmpvar_123) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_109 * (
          (tmpvar_108 * (1.0 - tmpvar_121))
         + tmpvar_121)) + (tmpvar_108 * (
          (tmpvar_109 * (1.0 - tmpvar_121))
         + tmpvar_121))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_109)) * LIGHT_COLOR)
   * tmpvar_124)) * ((
    ((1.0 - tmpvar_97) / ((LIGHT_ATTENUATION.x + (tmpvar_97 * LIGHT_ATTENUATION.y)) + ((tmpvar_97 * tmpvar_97) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_95, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalWorld_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  normalWorld_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec2 fetchesOffsetsV_15;
  highp vec2 fetchesOffsetsU_16;
  highp float shadow_17;
  shadow_17 = 1.0;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec4 computedWeight_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_20.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_20.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  computedWeight_21 = (computedArea_22 * 0.44444);
  highp vec4 computedWeight_28;
  highp vec4 computedArea_29;
  highp vec4 computedAreaUncut_30;
  highp float tmpvar_31;
  tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
  computedArea_29.x = tmpvar_32;
  computedAreaUncut_30.x = tmpvar_32;
  computedArea_29.w = tmpvar_31;
  computedAreaUncut_30.w = tmpvar_31;
  computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_33;
  tmpvar_33 = min (tmpvar_20.y, 0.0);
  computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
  computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = max (tmpvar_20.y, 0.0);
  computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
  computedWeight_28 = (computedArea_29 * 0.44444);
  highp vec2 tmpvar_35;
  tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
  highp vec2 tmpvar_36;
  tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
  fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_16.x;
  tmpvar_38.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_13.z;
  highp vec4 tmpvar_40;
  tmpvar_40 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
  highp float tmpvar_41;
  if ((tmpvar_40.x < shadowCoord_13.z)) {
    tmpvar_41 = 0.0;
  } else {
    tmpvar_41 = 1.0;
  };
  shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_41);
  highp vec2 tmpvar_42;
  tmpvar_42.x = fetchesOffsetsU_16.y;
  tmpvar_42.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_43;
  tmpvar_43.xy = (tmpvar_37 + tmpvar_42);
  tmpvar_43.z = shadowCoord_13.z;
  highp vec4 tmpvar_44;
  tmpvar_44 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
  highp float tmpvar_45;
  if ((tmpvar_44.x < shadowCoord_13.z)) {
    tmpvar_45 = 0.0;
  } else {
    tmpvar_45 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_16.x;
  tmpvar_46.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_37 + tmpvar_46);
  tmpvar_47.z = shadowCoord_13.z;
  highp vec4 tmpvar_48;
  tmpvar_48 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_47.xy);
  highp float tmpvar_49;
  if ((tmpvar_48.x < shadowCoord_13.z)) {
    tmpvar_49 = 0.0;
  } else {
    tmpvar_49 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_49));
  highp vec2 tmpvar_50;
  tmpvar_50.x = fetchesOffsetsU_16.y;
  tmpvar_50.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_51;
  tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
  tmpvar_51.z = shadowCoord_13.z;
  highp vec4 tmpvar_52;
  tmpvar_52 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_51.xy);
  highp float tmpvar_53;
  if ((tmpvar_52.x < shadowCoord_13.z)) {
    tmpvar_53 = 0.0;
  } else {
    tmpvar_53 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_53));
  highp vec3 tmpvar_54;
  highp vec3 lightDir_55;
  highp vec3 tmpvar_56;
  tmpvar_56 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_57;
  tmpvar_57 = clamp ((sqrt(
    dot (tmpvar_56, tmpvar_56)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_55 = normalize(tmpvar_56);
  tmpvar_54 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 tmpvar_61;
  mediump vec3 albedo_62;
  albedo_62 = tmpvar_2;
  mediump vec3 specColor_63;
  specColor_63 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_62 * tmpvar_3));
  tmpvar_61 = (albedo_62 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_58 = 0.0;
  mediump float alpha_64;
  alpha_64 = tmpvar_58;
  tmpvar_58 = alpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (lightDir_55 + tmpvar_54);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_54, normalWorld_5));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (normalWorld_5, lightDir_55), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (normalWorld_5, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (lightDir_55, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_60;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_59 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_63 + ((1.0 - specColor_63) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  outColor_1.xyz = (((
    (tmpvar_61 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * ((
    ((1.0 - tmpvar_57) / ((LIGHT_ATTENUATION.x + (tmpvar_57 * LIGHT_ATTENUATION.y)) + ((tmpvar_57 * tmpvar_57) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_55, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = normalize(tmpvar_15);
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 tmpvar_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  tmpvar_20 = (albedo_21 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_23;
  alpha_23 = tmpvar_17;
  tmpvar_17 = alpha_23;
  mediump float tmpvar_24;
  tmpvar_24 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_24;
  highp vec3 tmpvar_25;
  highp vec3 inVec_26;
  inVec_26 = (tmpvar_13 + tmpvar_12);
  tmpvar_25 = (inVec_26 * inversesqrt(max (0.001, 
    dot (inVec_26, inVec_26)
  )));
  highp float tmpvar_27;
  tmpvar_27 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_14, tmpvar_25), 0.0, 1.0);
  mediump float tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_13, tmpvar_25), 0.0, 1.0);
  tmpvar_30 = tmpvar_31;
  mediump float tmpvar_32;
  mediump float NdotV_33;
  NdotV_33 = tmpvar_27;
  mediump float NdotL_34;
  NdotL_34 = tmpvar_28;
  mediump float perceptualRoughness_35;
  perceptualRoughness_35 = perceptualRoughness_19;
  mediump float tmpvar_36;
  tmpvar_36 = (0.5 + ((2.0 * tmpvar_30) * (tmpvar_30 * perceptualRoughness_35)));
  mediump float x_37;
  x_37 = (1.0 - NdotL_34);
  mediump float x_38;
  x_38 = (1.0 - NdotV_33);
  tmpvar_32 = ((1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )) * (1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_32 * tmpvar_28);
  diffuseTerm_18 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_40 * tmpvar_40);
  highp float tmpvar_42;
  tmpvar_42 = (((
    (tmpvar_29 * tmpvar_41)
   - tmpvar_29) * tmpvar_29) + 1.0);
  mediump vec3 tmpvar_43;
  mediump float x_44;
  x_44 = (1.0 - tmpvar_30);
  tmpvar_43 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_44 * x_44)
   * 
    ((x_44 * x_44) * x_44)
  )));
  outColor_1.xyz = (((
    (tmpvar_20 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_41)
       / 
        ((tmpvar_42 * tmpvar_42) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_28 * (
          (tmpvar_27 * (1.0 - tmpvar_40))
         + tmpvar_40)) + (tmpvar_27 * (
          (tmpvar_28 * (1.0 - tmpvar_40))
         + tmpvar_40))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_28)) * LIGHT_COLOR)
   * tmpvar_43)) * ((1.0 - tmpvar_16) / (
    (LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z)
  )));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = normalize(tmpvar_15);
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 tmpvar_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  tmpvar_20 = (albedo_21 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_23;
  alpha_23 = tmpvar_17;
  tmpvar_17 = alpha_23;
  mediump float tmpvar_24;
  tmpvar_24 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_24;
  highp vec3 tmpvar_25;
  highp vec3 inVec_26;
  inVec_26 = (tmpvar_13 + tmpvar_12);
  tmpvar_25 = (inVec_26 * inversesqrt(max (0.001, 
    dot (inVec_26, inVec_26)
  )));
  highp float tmpvar_27;
  tmpvar_27 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_14, tmpvar_25), 0.0, 1.0);
  mediump float tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_13, tmpvar_25), 0.0, 1.0);
  tmpvar_30 = tmpvar_31;
  mediump float tmpvar_32;
  mediump float NdotV_33;
  NdotV_33 = tmpvar_27;
  mediump float NdotL_34;
  NdotL_34 = tmpvar_28;
  mediump float perceptualRoughness_35;
  perceptualRoughness_35 = perceptualRoughness_19;
  mediump float tmpvar_36;
  tmpvar_36 = (0.5 + ((2.0 * tmpvar_30) * (tmpvar_30 * perceptualRoughness_35)));
  mediump float x_37;
  x_37 = (1.0 - NdotL_34);
  mediump float x_38;
  x_38 = (1.0 - NdotV_33);
  tmpvar_32 = ((1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )) * (1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_32 * tmpvar_28);
  diffuseTerm_18 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_40 * tmpvar_40);
  highp float tmpvar_42;
  tmpvar_42 = (((
    (tmpvar_29 * tmpvar_41)
   - tmpvar_29) * tmpvar_29) + 1.0);
  mediump vec3 tmpvar_43;
  mediump float x_44;
  x_44 = (1.0 - tmpvar_30);
  tmpvar_43 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_44 * x_44)
   * 
    ((x_44 * x_44) * x_44)
  )));
  outColor_1.xyz = (((
    (tmpvar_20 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_41)
       / 
        ((tmpvar_42 * tmpvar_42) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_28 * (
          (tmpvar_27 * (1.0 - tmpvar_40))
         + tmpvar_40)) + (tmpvar_27 * (
          (tmpvar_28 * (1.0 - tmpvar_40))
         + tmpvar_40))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_28)) * LIGHT_COLOR)
   * tmpvar_43)) * ((1.0 - tmpvar_16) / (
    (LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z)
  )));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_15;
  mediump float diffuseTerm_16;
  highp float perceptualRoughness_17;
  mediump vec3 tmpvar_18;
  mediump vec3 albedo_19;
  albedo_19 = tmpvar_2;
  mediump vec3 specColor_20;
  specColor_20 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_19 * tmpvar_3));
  tmpvar_18 = (albedo_19 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_15 = 0.0;
  mediump float alpha_21;
  alpha_21 = tmpvar_15;
  tmpvar_15 = alpha_21;
  mediump float tmpvar_22;
  tmpvar_22 = (1.0 - tmpvar_4);
  perceptualRoughness_17 = tmpvar_22;
  highp vec3 tmpvar_23;
  highp vec3 inVec_24;
  inVec_24 = (tmpvar_13 + tmpvar_12);
  tmpvar_23 = (inVec_24 * inversesqrt(max (0.001, 
    dot (inVec_24, inVec_24)
  )));
  highp float tmpvar_25;
  tmpvar_25 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_26;
  tmpvar_26 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_27;
  tmpvar_27 = clamp (dot (tmpvar_14, tmpvar_23), 0.0, 1.0);
  mediump float tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_13, tmpvar_23), 0.0, 1.0);
  tmpvar_28 = tmpvar_29;
  mediump float tmpvar_30;
  mediump float NdotV_31;
  NdotV_31 = tmpvar_25;
  mediump float NdotL_32;
  NdotL_32 = tmpvar_26;
  mediump float perceptualRoughness_33;
  perceptualRoughness_33 = perceptualRoughness_17;
  mediump float tmpvar_34;
  tmpvar_34 = (0.5 + ((2.0 * tmpvar_28) * (tmpvar_28 * perceptualRoughness_33)));
  mediump float x_35;
  x_35 = (1.0 - NdotL_32);
  mediump float x_36;
  x_36 = (1.0 - NdotV_31);
  tmpvar_30 = ((1.0 + (
    (tmpvar_34 - 1.0)
   * 
    ((x_35 * x_35) * ((x_35 * x_35) * x_35))
  )) * (1.0 + (
    (tmpvar_34 - 1.0)
   * 
    ((x_36 * x_36) * ((x_36 * x_36) * x_36))
  )));
  highp float tmpvar_37;
  tmpvar_37 = (tmpvar_30 * tmpvar_26);
  diffuseTerm_16 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = max ((perceptualRoughness_17 * perceptualRoughness_17), 0.002);
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_38 * tmpvar_38);
  highp float tmpvar_40;
  tmpvar_40 = (((
    (tmpvar_27 * tmpvar_39)
   - tmpvar_27) * tmpvar_27) + 1.0);
  mediump vec3 tmpvar_41;
  mediump float x_42;
  x_42 = (1.0 - tmpvar_28);
  tmpvar_41 = (specColor_20 + ((1.0 - specColor_20) * (
    (x_42 * x_42)
   * 
    ((x_42 * x_42) * x_42)
  )));
  outColor_1.xyz = (((tmpvar_18 * LIGHT_COLOR) * diffuseTerm_16) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_39) / (
        (tmpvar_40 * tmpvar_40)
       + 1e-7)) * (0.5 / (
        ((tmpvar_26 * ((tmpvar_25 * 
          (1.0 - tmpvar_38)
        ) + tmpvar_38)) + (tmpvar_25 * ((tmpvar_26 * 
          (1.0 - tmpvar_38)
        ) + tmpvar_38)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_26))
   * LIGHT_COLOR) * tmpvar_41));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_15;
    highp vec2 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 computedWeight_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_20.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_20.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    computedWeight_21 = (computedArea_22 * 0.44444);
    highp vec4 computedWeight_28;
    highp vec4 computedArea_29;
    highp vec4 computedAreaUncut_30;
    highp float tmpvar_31;
    tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_32;
    tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
    computedArea_29.x = tmpvar_32;
    computedAreaUncut_30.x = tmpvar_32;
    computedArea_29.w = tmpvar_31;
    computedAreaUncut_30.w = tmpvar_31;
    computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = min (tmpvar_20.y, 0.0);
    computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
    computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = max (tmpvar_20.y, 0.0);
    computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
    computedWeight_28 = (computedArea_29 * 0.44444);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
    fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_16.x;
    tmpvar_38.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_13.z;
    lowp float tmpvar_40;
    tmpvar_40 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_16.y;
    tmpvar_41.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_16.x;
    tmpvar_44.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_13.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_16.y;
    tmpvar_47.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_13.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_50;
  highp vec3 tmpvar_51;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_51 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_52;
  mediump float diffuseTerm_53;
  highp float perceptualRoughness_54;
  mediump vec3 tmpvar_55;
  mediump vec3 albedo_56;
  albedo_56 = tmpvar_2;
  mediump vec3 specColor_57;
  specColor_57 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_56 * tmpvar_3));
  tmpvar_55 = (albedo_56 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_52 = 0.0;
  mediump float alpha_58;
  alpha_58 = tmpvar_52;
  tmpvar_52 = alpha_58;
  mediump float tmpvar_59;
  tmpvar_59 = (1.0 - tmpvar_4);
  perceptualRoughness_54 = tmpvar_59;
  highp vec3 tmpvar_60;
  highp vec3 inVec_61;
  inVec_61 = (tmpvar_51 + tmpvar_50);
  tmpvar_60 = (inVec_61 * inversesqrt(max (0.001, 
    dot (inVec_61, inVec_61)
  )));
  highp float tmpvar_62;
  tmpvar_62 = abs(dot (tmpvar_50, tmpvar_5));
  highp float tmpvar_63;
  tmpvar_63 = clamp (dot (tmpvar_5, tmpvar_51), 0.0, 1.0);
  highp float tmpvar_64;
  tmpvar_64 = clamp (dot (tmpvar_5, tmpvar_60), 0.0, 1.0);
  mediump float tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_51, tmpvar_60), 0.0, 1.0);
  tmpvar_65 = tmpvar_66;
  mediump float tmpvar_67;
  mediump float NdotV_68;
  NdotV_68 = tmpvar_62;
  mediump float NdotL_69;
  NdotL_69 = tmpvar_63;
  mediump float perceptualRoughness_70;
  perceptualRoughness_70 = perceptualRoughness_54;
  mediump float tmpvar_71;
  tmpvar_71 = (0.5 + ((2.0 * tmpvar_65) * (tmpvar_65 * perceptualRoughness_70)));
  mediump float x_72;
  x_72 = (1.0 - NdotL_69);
  mediump float x_73;
  x_73 = (1.0 - NdotV_68);
  tmpvar_67 = ((1.0 + (
    (tmpvar_71 - 1.0)
   * 
    ((x_72 * x_72) * ((x_72 * x_72) * x_72))
  )) * (1.0 + (
    (tmpvar_71 - 1.0)
   * 
    ((x_73 * x_73) * ((x_73 * x_73) * x_73))
  )));
  highp float tmpvar_74;
  tmpvar_74 = (tmpvar_67 * tmpvar_63);
  diffuseTerm_53 = tmpvar_74;
  highp float tmpvar_75;
  tmpvar_75 = max ((perceptualRoughness_54 * perceptualRoughness_54), 0.002);
  highp float tmpvar_76;
  tmpvar_76 = (tmpvar_75 * tmpvar_75);
  highp float tmpvar_77;
  tmpvar_77 = (((
    (tmpvar_64 * tmpvar_76)
   - tmpvar_64) * tmpvar_64) + 1.0);
  mediump vec3 tmpvar_78;
  mediump float x_79;
  x_79 = (1.0 - tmpvar_65);
  tmpvar_78 = (specColor_57 + ((1.0 - specColor_57) * (
    (x_79 * x_79)
   * 
    ((x_79 * x_79) * x_79)
  )));
  outColor_1.xyz = (((
    (tmpvar_55 * LIGHT_COLOR)
   * diffuseTerm_53) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_76)
       / 
        ((tmpvar_77 * tmpvar_77) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_63 * (
          (tmpvar_62 * (1.0 - tmpvar_75))
         + tmpvar_75)) + (tmpvar_62 * (
          (tmpvar_63 * (1.0 - tmpvar_75))
         + tmpvar_75))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_63)) * LIGHT_COLOR)
   * tmpvar_78)) * tmpvar_14);
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_15;
    highp vec3 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 texelsWeightsA_29;
    highp vec3 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.16 * tmpvar_34);
    texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
    texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
    texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
    texelsWeightsB_30.z = (0.16 * tmpvar_33);
    highp vec3 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_21.y;
    tmpvar_38.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.z = texelsWeightsB_30.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_29.y;
    tmpvar_41.yz = texelsWeightsB_30.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_21.y;
    tmpvar_43.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_29.y;
    tmpvar_44.yz = texelsWeightsB_30.xz;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    lowp float tmpvar_48;
    tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.x;
    tmpvar_55.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.y;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.z;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.x;
    tmpvar_64.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.y;
    tmpvar_67.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.z;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_73;
  highp vec3 tmpvar_74;
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_74 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_75;
  mediump float diffuseTerm_76;
  highp float perceptualRoughness_77;
  mediump vec3 tmpvar_78;
  mediump vec3 albedo_79;
  albedo_79 = tmpvar_2;
  mediump vec3 specColor_80;
  specColor_80 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_79 * tmpvar_3));
  tmpvar_78 = (albedo_79 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_75 = 0.0;
  mediump float alpha_81;
  alpha_81 = tmpvar_75;
  tmpvar_75 = alpha_81;
  mediump float tmpvar_82;
  tmpvar_82 = (1.0 - tmpvar_4);
  perceptualRoughness_77 = tmpvar_82;
  highp vec3 tmpvar_83;
  highp vec3 inVec_84;
  inVec_84 = (tmpvar_74 + tmpvar_73);
  tmpvar_83 = (inVec_84 * inversesqrt(max (0.001, 
    dot (inVec_84, inVec_84)
  )));
  highp float tmpvar_85;
  tmpvar_85 = abs(dot (tmpvar_73, tmpvar_5));
  highp float tmpvar_86;
  tmpvar_86 = clamp (dot (tmpvar_5, tmpvar_74), 0.0, 1.0);
  highp float tmpvar_87;
  tmpvar_87 = clamp (dot (tmpvar_5, tmpvar_83), 0.0, 1.0);
  mediump float tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_74, tmpvar_83), 0.0, 1.0);
  tmpvar_88 = tmpvar_89;
  mediump float tmpvar_90;
  mediump float NdotV_91;
  NdotV_91 = tmpvar_85;
  mediump float NdotL_92;
  NdotL_92 = tmpvar_86;
  mediump float perceptualRoughness_93;
  perceptualRoughness_93 = perceptualRoughness_77;
  mediump float tmpvar_94;
  tmpvar_94 = (0.5 + ((2.0 * tmpvar_88) * (tmpvar_88 * perceptualRoughness_93)));
  mediump float x_95;
  x_95 = (1.0 - NdotL_92);
  mediump float x_96;
  x_96 = (1.0 - NdotV_91);
  tmpvar_90 = ((1.0 + (
    (tmpvar_94 - 1.0)
   * 
    ((x_95 * x_95) * ((x_95 * x_95) * x_95))
  )) * (1.0 + (
    (tmpvar_94 - 1.0)
   * 
    ((x_96 * x_96) * ((x_96 * x_96) * x_96))
  )));
  highp float tmpvar_97;
  tmpvar_97 = (tmpvar_90 * tmpvar_86);
  diffuseTerm_76 = tmpvar_97;
  highp float tmpvar_98;
  tmpvar_98 = max ((perceptualRoughness_77 * perceptualRoughness_77), 0.002);
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_98 * tmpvar_98);
  highp float tmpvar_100;
  tmpvar_100 = (((
    (tmpvar_87 * tmpvar_99)
   - tmpvar_87) * tmpvar_87) + 1.0);
  mediump vec3 tmpvar_101;
  mediump float x_102;
  x_102 = (1.0 - tmpvar_88);
  tmpvar_101 = (specColor_80 + ((1.0 - specColor_80) * (
    (x_102 * x_102)
   * 
    ((x_102 * x_102) * x_102)
  )));
  outColor_1.xyz = (((
    (tmpvar_78 * LIGHT_COLOR)
   * diffuseTerm_76) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_99)
       / 
        ((tmpvar_100 * tmpvar_100) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_86 * (
          (tmpvar_85 * (1.0 - tmpvar_98))
         + tmpvar_98)) + (tmpvar_85 * (
          (tmpvar_86 * (1.0 - tmpvar_98))
         + tmpvar_98))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_86)) * LIGHT_COLOR)
   * tmpvar_101)) * tmpvar_14);
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_15;
    highp vec4 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 texelsWeightsA_29;
    highp vec4 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.081632 * tmpvar_34);
    texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
    texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
    texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
    texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
    texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
    texelsWeightsB_30.w = (0.081632 * tmpvar_33);
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_21.yw;
    tmpvar_38.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.zw = texelsWeightsB_30.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_29.yw;
    tmpvar_41.zw = texelsWeightsB_30.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_21.yw;
    tmpvar_43.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_29.yw;
    tmpvar_44.zw = texelsWeightsB_30.yw;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    lowp float tmpvar_48;
    tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.w;
    tmpvar_55.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.x;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.y;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.z;
    tmpvar_64.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.w;
    tmpvar_67.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.x;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_16.y;
    tmpvar_73.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
    tmpvar_74.z = shadowCoord_13.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_16.z;
    tmpvar_76.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
    tmpvar_77.z = shadowCoord_13.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_16.w;
    tmpvar_79.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
    tmpvar_80.z = shadowCoord_13.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_16.x;
    tmpvar_82.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
    tmpvar_83.z = shadowCoord_13.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_16.y;
    tmpvar_85.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
    tmpvar_86.z = shadowCoord_13.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_16.z;
    tmpvar_88.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
    tmpvar_89.z = shadowCoord_13.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_16.w;
    tmpvar_91.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
    tmpvar_92.z = shadowCoord_13.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_94;
  highp vec3 tmpvar_95;
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_95 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_96;
  mediump float diffuseTerm_97;
  highp float perceptualRoughness_98;
  mediump vec3 tmpvar_99;
  mediump vec3 albedo_100;
  albedo_100 = tmpvar_2;
  mediump vec3 specColor_101;
  specColor_101 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_100 * tmpvar_3));
  tmpvar_99 = (albedo_100 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_96 = 0.0;
  mediump float alpha_102;
  alpha_102 = tmpvar_96;
  tmpvar_96 = alpha_102;
  mediump float tmpvar_103;
  tmpvar_103 = (1.0 - tmpvar_4);
  perceptualRoughness_98 = tmpvar_103;
  highp vec3 tmpvar_104;
  highp vec3 inVec_105;
  inVec_105 = (tmpvar_95 + tmpvar_94);
  tmpvar_104 = (inVec_105 * inversesqrt(max (0.001, 
    dot (inVec_105, inVec_105)
  )));
  highp float tmpvar_106;
  tmpvar_106 = abs(dot (tmpvar_94, tmpvar_5));
  highp float tmpvar_107;
  tmpvar_107 = clamp (dot (tmpvar_5, tmpvar_95), 0.0, 1.0);
  highp float tmpvar_108;
  tmpvar_108 = clamp (dot (tmpvar_5, tmpvar_104), 0.0, 1.0);
  mediump float tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_95, tmpvar_104), 0.0, 1.0);
  tmpvar_109 = tmpvar_110;
  mediump float tmpvar_111;
  mediump float NdotV_112;
  NdotV_112 = tmpvar_106;
  mediump float NdotL_113;
  NdotL_113 = tmpvar_107;
  mediump float perceptualRoughness_114;
  perceptualRoughness_114 = perceptualRoughness_98;
  mediump float tmpvar_115;
  tmpvar_115 = (0.5 + ((2.0 * tmpvar_109) * (tmpvar_109 * perceptualRoughness_114)));
  mediump float x_116;
  x_116 = (1.0 - NdotL_113);
  mediump float x_117;
  x_117 = (1.0 - NdotV_112);
  tmpvar_111 = ((1.0 + (
    (tmpvar_115 - 1.0)
   * 
    ((x_116 * x_116) * ((x_116 * x_116) * x_116))
  )) * (1.0 + (
    (tmpvar_115 - 1.0)
   * 
    ((x_117 * x_117) * ((x_117 * x_117) * x_117))
  )));
  highp float tmpvar_118;
  tmpvar_118 = (tmpvar_111 * tmpvar_107);
  diffuseTerm_97 = tmpvar_118;
  highp float tmpvar_119;
  tmpvar_119 = max ((perceptualRoughness_98 * perceptualRoughness_98), 0.002);
  highp float tmpvar_120;
  tmpvar_120 = (tmpvar_119 * tmpvar_119);
  highp float tmpvar_121;
  tmpvar_121 = (((
    (tmpvar_108 * tmpvar_120)
   - tmpvar_108) * tmpvar_108) + 1.0);
  mediump vec3 tmpvar_122;
  mediump float x_123;
  x_123 = (1.0 - tmpvar_109);
  tmpvar_122 = (specColor_101 + ((1.0 - specColor_101) * (
    (x_123 * x_123)
   * 
    ((x_123 * x_123) * x_123)
  )));
  outColor_1.xyz = (((
    (tmpvar_99 * LIGHT_COLOR)
   * diffuseTerm_97) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_120)
       / 
        ((tmpvar_121 * tmpvar_121) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_107 * (
          (tmpvar_106 * (1.0 - tmpvar_119))
         + tmpvar_119)) + (tmpvar_106 * (
          (tmpvar_107 * (1.0 - tmpvar_119))
         + tmpvar_119))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_107)) * LIGHT_COLOR)
   * tmpvar_122)) * tmpvar_14);
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    highp vec2 tmpvar_15;
    tmpvar_15.x = LIGHT_PARAM.z;
    tmpvar_15.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_16;
    tmpvar_16.xy = tmpvar_15;
    highp float tmpvar_17;
    tmpvar_17 = (1.0/(LIGHT_PARAM.z));
    tmpvar_16.z = tmpvar_17;
    tmpvar_16.w = tmpvar_17;
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = tmpvar_16.xy;
    shadow_18 = 0.0;
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_13.xy - LIGHT_PARAM.zz);
    tmpvar_20.z = shadowCoord_13.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_18 = tmpvar_22;
    highp vec2 tmpvar_23;
    tmpvar_23.x = 0.0;
    tmpvar_23.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_13.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_13.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_18 = (tmpvar_22 + tmpvar_26);
    highp vec2 tmpvar_27;
    tmpvar_27.x = tmpvar_19.x;
    tmpvar_27.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_28;
    tmpvar_28.xy = (shadowCoord_13.xy + tmpvar_27);
    tmpvar_28.z = shadowCoord_13.z;
    highp vec4 tmpvar_29;
    tmpvar_29 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_28.xy);
    highp float tmpvar_30;
    if ((tmpvar_29.x < xlv_TEXCOORD4.z)) {
      tmpvar_30 = 0.0;
    } else {
      tmpvar_30 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_30);
    highp vec2 tmpvar_31;
    tmpvar_31.y = 0.0;
    tmpvar_31.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = (shadowCoord_13.xy + tmpvar_31);
    tmpvar_32.z = shadowCoord_13.z;
    highp vec4 tmpvar_33;
    tmpvar_33 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_32.xy);
    highp float tmpvar_34;
    if ((tmpvar_33.x < xlv_TEXCOORD4.z)) {
      tmpvar_34 = 0.0;
    } else {
      tmpvar_34 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_34);
    highp vec4 tmpvar_35;
    tmpvar_35 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_13.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.y = 0.0;
    tmpvar_37.x = tmpvar_19.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_13.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_13.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = -(LIGHT_PARAM.z);
    tmpvar_41.y = tmpvar_19.y;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_13.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = 0.0;
    tmpvar_45.y = tmpvar_19.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (shadowCoord_13.xy + tmpvar_45);
    tmpvar_46.z = shadowCoord_13.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_48);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_13.xy + LIGHT_PARAM.zz);
    tmpvar_49.z = shadowCoord_13.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_51);
    shadow_18 = (shadow_18 / 9.0);
    tmpvar_14 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_52;
  highp vec3 tmpvar_53;
  tmpvar_52 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_53 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_54;
  mediump float diffuseTerm_55;
  highp float perceptualRoughness_56;
  mediump vec3 tmpvar_57;
  mediump vec3 albedo_58;
  albedo_58 = tmpvar_2;
  mediump vec3 specColor_59;
  specColor_59 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_58 * tmpvar_3));
  tmpvar_57 = (albedo_58 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_54 = 0.0;
  mediump float alpha_60;
  alpha_60 = tmpvar_54;
  tmpvar_54 = alpha_60;
  mediump float tmpvar_61;
  tmpvar_61 = (1.0 - tmpvar_4);
  perceptualRoughness_56 = tmpvar_61;
  highp vec3 tmpvar_62;
  highp vec3 inVec_63;
  inVec_63 = (tmpvar_53 + tmpvar_52);
  tmpvar_62 = (inVec_63 * inversesqrt(max (0.001, 
    dot (inVec_63, inVec_63)
  )));
  highp float tmpvar_64;
  tmpvar_64 = abs(dot (tmpvar_52, tmpvar_5));
  highp float tmpvar_65;
  tmpvar_65 = clamp (dot (tmpvar_5, tmpvar_53), 0.0, 1.0);
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_5, tmpvar_62), 0.0, 1.0);
  mediump float tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_53, tmpvar_62), 0.0, 1.0);
  tmpvar_67 = tmpvar_68;
  mediump float tmpvar_69;
  mediump float NdotV_70;
  NdotV_70 = tmpvar_64;
  mediump float NdotL_71;
  NdotL_71 = tmpvar_65;
  mediump float perceptualRoughness_72;
  perceptualRoughness_72 = perceptualRoughness_56;
  mediump float tmpvar_73;
  tmpvar_73 = (0.5 + ((2.0 * tmpvar_67) * (tmpvar_67 * perceptualRoughness_72)));
  mediump float x_74;
  x_74 = (1.0 - NdotL_71);
  mediump float x_75;
  x_75 = (1.0 - NdotV_70);
  tmpvar_69 = ((1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_74 * x_74) * ((x_74 * x_74) * x_74))
  )) * (1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )));
  highp float tmpvar_76;
  tmpvar_76 = (tmpvar_69 * tmpvar_65);
  diffuseTerm_55 = tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = max ((perceptualRoughness_56 * perceptualRoughness_56), 0.002);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_66 * tmpvar_78)
   - tmpvar_66) * tmpvar_66) + 1.0);
  mediump vec3 tmpvar_80;
  mediump float x_81;
  x_81 = (1.0 - tmpvar_67);
  tmpvar_80 = (specColor_59 + ((1.0 - specColor_59) * (
    (x_81 * x_81)
   * 
    ((x_81 * x_81) * x_81)
  )));
  outColor_1.xyz = (((
    (tmpvar_57 * LIGHT_COLOR)
   * diffuseTerm_55) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_78)
       / 
        ((tmpvar_79 * tmpvar_79) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_65 * (
          (tmpvar_64 * (1.0 - tmpvar_77))
         + tmpvar_77)) + (tmpvar_64 * (
          (tmpvar_65 * (1.0 - tmpvar_77))
         + tmpvar_77))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_65)) * LIGHT_COLOR)
   * tmpvar_80)) * tmpvar_14);
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 lightDir_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_14 = normalize(tmpvar_15);
  tmpvar_13 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 tmpvar_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  tmpvar_20 = (albedo_21 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_23;
  alpha_23 = tmpvar_17;
  tmpvar_17 = alpha_23;
  mediump float tmpvar_24;
  tmpvar_24 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_24;
  highp vec3 tmpvar_25;
  highp vec3 inVec_26;
  inVec_26 = (lightDir_14 + tmpvar_12);
  tmpvar_25 = (inVec_26 * inversesqrt(max (0.001, 
    dot (inVec_26, inVec_26)
  )));
  highp float tmpvar_27;
  tmpvar_27 = abs(dot (tmpvar_12, tmpvar_13));
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_13, lightDir_14), 0.0, 1.0);
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_13, tmpvar_25), 0.0, 1.0);
  mediump float tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (lightDir_14, tmpvar_25), 0.0, 1.0);
  tmpvar_30 = tmpvar_31;
  mediump float tmpvar_32;
  mediump float NdotV_33;
  NdotV_33 = tmpvar_27;
  mediump float NdotL_34;
  NdotL_34 = tmpvar_28;
  mediump float perceptualRoughness_35;
  perceptualRoughness_35 = perceptualRoughness_19;
  mediump float tmpvar_36;
  tmpvar_36 = (0.5 + ((2.0 * tmpvar_30) * (tmpvar_30 * perceptualRoughness_35)));
  mediump float x_37;
  x_37 = (1.0 - NdotL_34);
  mediump float x_38;
  x_38 = (1.0 - NdotV_33);
  tmpvar_32 = ((1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )) * (1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_32 * tmpvar_28);
  diffuseTerm_18 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_40 * tmpvar_40);
  highp float tmpvar_42;
  tmpvar_42 = (((
    (tmpvar_29 * tmpvar_41)
   - tmpvar_29) * tmpvar_29) + 1.0);
  mediump vec3 tmpvar_43;
  mediump float x_44;
  x_44 = (1.0 - tmpvar_30);
  tmpvar_43 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_44 * x_44)
   * 
    ((x_44 * x_44) * x_44)
  )));
  outColor_1.xyz = (((
    (tmpvar_20 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_41)
       / 
        ((tmpvar_42 * tmpvar_42) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_28 * (
          (tmpvar_27 * (1.0 - tmpvar_40))
         + tmpvar_40)) + (tmpvar_27 * (
          (tmpvar_28 * (1.0 - tmpvar_40))
         + tmpvar_40))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_28)) * LIGHT_COLOR)
   * tmpvar_43)) * ((
    (1.0 - tmpvar_16)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y)) + ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (lightDir_14, 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec2 fetchesOffsetsV_14;
  highp vec2 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_19.x, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_19.x, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec4 computedWeight_27;
  highp vec4 computedArea_28;
  highp vec4 computedAreaUncut_29;
  highp float tmpvar_30;
  tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
  computedArea_28.x = tmpvar_31;
  computedAreaUncut_29.x = tmpvar_31;
  computedArea_28.w = tmpvar_30;
  computedAreaUncut_29.w = tmpvar_30;
  computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_32;
  tmpvar_32 = min (tmpvar_19.y, 0.0);
  computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
  computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_33;
  tmpvar_33 = max (tmpvar_19.y, 0.0);
  computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
  computedWeight_27 = (computedArea_28 * 0.44444);
  highp vec2 tmpvar_34;
  tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
  highp vec2 tmpvar_35;
  tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
  fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_36;
  tmpvar_36 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37.x = fetchesOffsetsU_15.x;
  tmpvar_37.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_38;
  tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
  tmpvar_38.z = shadowCoord_12.z;
  lowp float tmpvar_39;
  tmpvar_39 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_38);
  shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
  highp vec2 tmpvar_40;
  tmpvar_40.x = fetchesOffsetsU_15.y;
  tmpvar_40.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_41;
  tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
  tmpvar_41.z = shadowCoord_12.z;
  lowp float tmpvar_42;
  tmpvar_42 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_41);
  shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_15.x;
  tmpvar_43.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
  tmpvar_44.z = shadowCoord_12.z;
  lowp float tmpvar_45;
  tmpvar_45 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_44);
  shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_15.y;
  tmpvar_46.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
  tmpvar_47.z = shadowCoord_12.z;
  lowp float tmpvar_48;
  tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
  highp vec3 tmpvar_49;
  highp vec3 tmpvar_50;
  highp vec3 lightDir_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_53;
  tmpvar_53 = clamp ((sqrt(
    dot (tmpvar_52, tmpvar_52)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_51 = normalize(tmpvar_52);
  tmpvar_50 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_49 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_54;
  mediump float diffuseTerm_55;
  highp float perceptualRoughness_56;
  mediump vec3 tmpvar_57;
  mediump vec3 albedo_58;
  albedo_58 = tmpvar_2;
  mediump vec3 specColor_59;
  specColor_59 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_58 * tmpvar_3));
  tmpvar_57 = (albedo_58 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_54 = 0.0;
  mediump float alpha_60;
  alpha_60 = tmpvar_54;
  tmpvar_54 = alpha_60;
  mediump float tmpvar_61;
  tmpvar_61 = (1.0 - tmpvar_4);
  perceptualRoughness_56 = tmpvar_61;
  highp vec3 tmpvar_62;
  highp vec3 inVec_63;
  inVec_63 = (lightDir_51 + tmpvar_49);
  tmpvar_62 = (inVec_63 * inversesqrt(max (0.001, 
    dot (inVec_63, inVec_63)
  )));
  highp float tmpvar_64;
  tmpvar_64 = abs(dot (tmpvar_49, tmpvar_50));
  highp float tmpvar_65;
  tmpvar_65 = clamp (dot (tmpvar_50, lightDir_51), 0.0, 1.0);
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_50, tmpvar_62), 0.0, 1.0);
  mediump float tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (lightDir_51, tmpvar_62), 0.0, 1.0);
  tmpvar_67 = tmpvar_68;
  mediump float tmpvar_69;
  mediump float NdotV_70;
  NdotV_70 = tmpvar_64;
  mediump float NdotL_71;
  NdotL_71 = tmpvar_65;
  mediump float perceptualRoughness_72;
  perceptualRoughness_72 = perceptualRoughness_56;
  mediump float tmpvar_73;
  tmpvar_73 = (0.5 + ((2.0 * tmpvar_67) * (tmpvar_67 * perceptualRoughness_72)));
  mediump float x_74;
  x_74 = (1.0 - NdotL_71);
  mediump float x_75;
  x_75 = (1.0 - NdotV_70);
  tmpvar_69 = ((1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_74 * x_74) * ((x_74 * x_74) * x_74))
  )) * (1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )));
  highp float tmpvar_76;
  tmpvar_76 = (tmpvar_69 * tmpvar_65);
  diffuseTerm_55 = tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = max ((perceptualRoughness_56 * perceptualRoughness_56), 0.002);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_66 * tmpvar_78)
   - tmpvar_66) * tmpvar_66) + 1.0);
  mediump vec3 tmpvar_80;
  mediump float x_81;
  x_81 = (1.0 - tmpvar_67);
  tmpvar_80 = (specColor_59 + ((1.0 - specColor_59) * (
    (x_81 * x_81)
   * 
    ((x_81 * x_81) * x_81)
  )));
  outColor_1.xyz = (((
    (tmpvar_57 * LIGHT_COLOR)
   * diffuseTerm_55) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_78)
       / 
        ((tmpvar_79 * tmpvar_79) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_65 * (
          (tmpvar_64 * (1.0 - tmpvar_77))
         + tmpvar_77)) + (tmpvar_64 * (
          (tmpvar_65 * (1.0 - tmpvar_77))
         + tmpvar_77))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_65)) * LIGHT_COLOR)
   * tmpvar_80)) * ((
    ((1.0 - tmpvar_53) / ((LIGHT_ATTENUATION.x + (tmpvar_53 * LIGHT_ATTENUATION.y)) + ((tmpvar_53 * tmpvar_53) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_51, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec3 fetchesOffsetsV_14;
  highp vec3 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec3 texelsWeightsA_20;
  highp vec3 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_19.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_19.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.16 * tmpvar_25);
  texelsWeightsA_20.y = (0.16 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.16 * (computedArea_22.y + 1.0));
  texelsWeightsB_21.x = (0.16 * (computedArea_22.z + 1.0));
  texelsWeightsB_21.y = (0.16 * computedAreaUncut_23.z);
  texelsWeightsB_21.z = (0.16 * tmpvar_24);
  highp vec3 texelsWeightsA_28;
  highp vec3 texelsWeightsB_29;
  highp vec4 computedArea_30;
  highp vec4 computedAreaUncut_31;
  highp float tmpvar_32;
  tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
  computedArea_30.x = tmpvar_33;
  computedAreaUncut_31.x = tmpvar_33;
  computedArea_30.w = tmpvar_32;
  computedAreaUncut_31.w = tmpvar_32;
  computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = min (tmpvar_19.y, 0.0);
  computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
  computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = max (tmpvar_19.y, 0.0);
  computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
  texelsWeightsA_28.x = (0.16 * tmpvar_33);
  texelsWeightsA_28.y = (0.16 * computedAreaUncut_31.y);
  texelsWeightsA_28.z = (0.16 * (computedArea_30.y + 1.0));
  texelsWeightsB_29.x = (0.16 * (computedArea_30.z + 1.0));
  texelsWeightsB_29.y = (0.16 * computedAreaUncut_31.z);
  texelsWeightsB_29.z = (0.16 * tmpvar_32);
  highp vec3 tmpvar_36;
  tmpvar_36.xy = texelsWeightsA_20.xz;
  tmpvar_36.z = texelsWeightsB_21.y;
  highp vec3 tmpvar_37;
  tmpvar_37.x = texelsWeightsA_20.y;
  tmpvar_37.yz = texelsWeightsB_21.xz;
  highp vec3 tmpvar_38;
  tmpvar_38 = (tmpvar_36 + tmpvar_37);
  highp vec3 tmpvar_39;
  tmpvar_39.xy = texelsWeightsA_28.xz;
  tmpvar_39.z = texelsWeightsB_29.y;
  highp vec3 tmpvar_40;
  tmpvar_40.x = texelsWeightsA_28.y;
  tmpvar_40.yz = texelsWeightsB_29.xz;
  highp vec3 tmpvar_41;
  tmpvar_41 = (tmpvar_39 + tmpvar_40);
  highp vec3 tmpvar_42;
  tmpvar_42.x = texelsWeightsA_20.y;
  tmpvar_42.yz = texelsWeightsB_21.xz;
  highp vec3 tmpvar_43;
  tmpvar_43.x = texelsWeightsA_28.y;
  tmpvar_43.yz = texelsWeightsB_29.xz;
  fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_44;
  tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_45;
  tmpvar_45.x = fetchesOffsetsU_15.x;
  tmpvar_45.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_46;
  tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
  tmpvar_46.z = shadowCoord_12.z;
  lowp float tmpvar_47;
  tmpvar_47 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_46);
  shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
  highp vec2 tmpvar_48;
  tmpvar_48.x = fetchesOffsetsU_15.y;
  tmpvar_48.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_49;
  tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
  tmpvar_49.z = shadowCoord_12.z;
  lowp float tmpvar_50;
  tmpvar_50 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_49);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
  highp vec2 tmpvar_51;
  tmpvar_51.x = fetchesOffsetsU_15.z;
  tmpvar_51.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_52;
  tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
  tmpvar_52.z = shadowCoord_12.z;
  lowp float tmpvar_53;
  tmpvar_53 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_52);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
  highp vec2 tmpvar_54;
  tmpvar_54.x = fetchesOffsetsU_15.x;
  tmpvar_54.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_55;
  tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
  tmpvar_55.z = shadowCoord_12.z;
  lowp float tmpvar_56;
  tmpvar_56 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_55);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_56));
  highp vec2 tmpvar_57;
  tmpvar_57.x = fetchesOffsetsU_15.y;
  tmpvar_57.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_58;
  tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
  tmpvar_58.z = shadowCoord_12.z;
  lowp float tmpvar_59;
  tmpvar_59 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_58);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_59));
  highp vec2 tmpvar_60;
  tmpvar_60.x = fetchesOffsetsU_15.z;
  tmpvar_60.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_61;
  tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
  tmpvar_61.z = shadowCoord_12.z;
  lowp float tmpvar_62;
  tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_62));
  highp vec2 tmpvar_63;
  tmpvar_63.x = fetchesOffsetsU_15.x;
  tmpvar_63.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_64;
  tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
  tmpvar_64.z = shadowCoord_12.z;
  lowp float tmpvar_65;
  tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_65));
  highp vec2 tmpvar_66;
  tmpvar_66.x = fetchesOffsetsU_15.y;
  tmpvar_66.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_67;
  tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
  tmpvar_67.z = shadowCoord_12.z;
  lowp float tmpvar_68;
  tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_68));
  highp vec2 tmpvar_69;
  tmpvar_69.x = fetchesOffsetsU_15.z;
  tmpvar_69.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_70;
  tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
  tmpvar_70.z = shadowCoord_12.z;
  lowp float tmpvar_71;
  tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_71));
  highp vec3 tmpvar_72;
  highp vec3 tmpvar_73;
  highp vec3 lightDir_74;
  highp vec3 tmpvar_75;
  tmpvar_75 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_76;
  tmpvar_76 = clamp ((sqrt(
    dot (tmpvar_75, tmpvar_75)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_74 = normalize(tmpvar_75);
  tmpvar_73 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_72 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_77;
  mediump float diffuseTerm_78;
  highp float perceptualRoughness_79;
  mediump vec3 tmpvar_80;
  mediump vec3 albedo_81;
  albedo_81 = tmpvar_2;
  mediump vec3 specColor_82;
  specColor_82 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_81 * tmpvar_3));
  tmpvar_80 = (albedo_81 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_77 = 0.0;
  mediump float alpha_83;
  alpha_83 = tmpvar_77;
  tmpvar_77 = alpha_83;
  mediump float tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_4);
  perceptualRoughness_79 = tmpvar_84;
  highp vec3 tmpvar_85;
  highp vec3 inVec_86;
  inVec_86 = (lightDir_74 + tmpvar_72);
  tmpvar_85 = (inVec_86 * inversesqrt(max (0.001, 
    dot (inVec_86, inVec_86)
  )));
  highp float tmpvar_87;
  tmpvar_87 = abs(dot (tmpvar_72, tmpvar_73));
  highp float tmpvar_88;
  tmpvar_88 = clamp (dot (tmpvar_73, lightDir_74), 0.0, 1.0);
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_73, tmpvar_85), 0.0, 1.0);
  mediump float tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (lightDir_74, tmpvar_85), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  mediump float tmpvar_92;
  mediump float NdotV_93;
  NdotV_93 = tmpvar_87;
  mediump float NdotL_94;
  NdotL_94 = tmpvar_88;
  mediump float perceptualRoughness_95;
  perceptualRoughness_95 = perceptualRoughness_79;
  mediump float tmpvar_96;
  tmpvar_96 = (0.5 + ((2.0 * tmpvar_90) * (tmpvar_90 * perceptualRoughness_95)));
  mediump float x_97;
  x_97 = (1.0 - NdotL_94);
  mediump float x_98;
  x_98 = (1.0 - NdotV_93);
  tmpvar_92 = ((1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_97 * x_97) * ((x_97 * x_97) * x_97))
  )) * (1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_98 * x_98) * ((x_98 * x_98) * x_98))
  )));
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_92 * tmpvar_88);
  diffuseTerm_78 = tmpvar_99;
  highp float tmpvar_100;
  tmpvar_100 = max ((perceptualRoughness_79 * perceptualRoughness_79), 0.002);
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_100 * tmpvar_100);
  highp float tmpvar_102;
  tmpvar_102 = (((
    (tmpvar_89 * tmpvar_101)
   - tmpvar_89) * tmpvar_89) + 1.0);
  mediump vec3 tmpvar_103;
  mediump float x_104;
  x_104 = (1.0 - tmpvar_90);
  tmpvar_103 = (specColor_82 + ((1.0 - specColor_82) * (
    (x_104 * x_104)
   * 
    ((x_104 * x_104) * x_104)
  )));
  outColor_1.xyz = (((
    (tmpvar_80 * LIGHT_COLOR)
   * diffuseTerm_78) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_101)
       / 
        ((tmpvar_102 * tmpvar_102) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_88 * (
          (tmpvar_87 * (1.0 - tmpvar_100))
         + tmpvar_100)) + (tmpvar_87 * (
          (tmpvar_88 * (1.0 - tmpvar_100))
         + tmpvar_100))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_88)) * LIGHT_COLOR)
   * tmpvar_103)) * ((
    ((1.0 - tmpvar_76) / ((LIGHT_ATTENUATION.x + (tmpvar_76 * LIGHT_ATTENUATION.y)) + ((tmpvar_76 * tmpvar_76) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_74, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec4 fetchesOffsetsV_14;
  highp vec4 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec4 texelsWeightsA_20;
  highp vec4 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_19.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_19.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.081632 * tmpvar_25);
  texelsWeightsA_20.y = (0.081632 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.081632 * (computedAreaUncut_23.y + 1.0));
  texelsWeightsA_20.w = (0.081632 * (computedArea_22.y + 2.0));
  texelsWeightsB_21.x = (0.081632 * (computedArea_22.z + 2.0));
  texelsWeightsB_21.y = (0.081632 * (computedAreaUncut_23.z + 1.0));
  texelsWeightsB_21.z = (0.081632 * computedAreaUncut_23.z);
  texelsWeightsB_21.w = (0.081632 * tmpvar_24);
  highp vec4 texelsWeightsA_28;
  highp vec4 texelsWeightsB_29;
  highp vec4 computedArea_30;
  highp vec4 computedAreaUncut_31;
  highp float tmpvar_32;
  tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
  computedArea_30.x = tmpvar_33;
  computedAreaUncut_31.x = tmpvar_33;
  computedArea_30.w = tmpvar_32;
  computedAreaUncut_31.w = tmpvar_32;
  computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = min (tmpvar_19.y, 0.0);
  computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
  computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = max (tmpvar_19.y, 0.0);
  computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
  texelsWeightsA_28.x = (0.081632 * tmpvar_33);
  texelsWeightsA_28.y = (0.081632 * computedAreaUncut_31.y);
  texelsWeightsA_28.z = (0.081632 * (computedAreaUncut_31.y + 1.0));
  texelsWeightsA_28.w = (0.081632 * (computedArea_30.y + 2.0));
  texelsWeightsB_29.x = (0.081632 * (computedArea_30.z + 2.0));
  texelsWeightsB_29.y = (0.081632 * (computedAreaUncut_31.z + 1.0));
  texelsWeightsB_29.z = (0.081632 * computedAreaUncut_31.z);
  texelsWeightsB_29.w = (0.081632 * tmpvar_32);
  highp vec4 tmpvar_36;
  tmpvar_36.xy = texelsWeightsA_20.xz;
  tmpvar_36.zw = texelsWeightsB_21.xz;
  highp vec4 tmpvar_37;
  tmpvar_37.xy = texelsWeightsA_20.yw;
  tmpvar_37.zw = texelsWeightsB_21.yw;
  highp vec4 tmpvar_38;
  tmpvar_38 = (tmpvar_36 + tmpvar_37);
  highp vec4 tmpvar_39;
  tmpvar_39.xy = texelsWeightsA_28.xz;
  tmpvar_39.zw = texelsWeightsB_29.xz;
  highp vec4 tmpvar_40;
  tmpvar_40.xy = texelsWeightsA_28.yw;
  tmpvar_40.zw = texelsWeightsB_29.yw;
  highp vec4 tmpvar_41;
  tmpvar_41 = (tmpvar_39 + tmpvar_40);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = texelsWeightsA_20.yw;
  tmpvar_42.zw = texelsWeightsB_21.yw;
  highp vec4 tmpvar_43;
  tmpvar_43.xy = texelsWeightsA_28.yw;
  tmpvar_43.zw = texelsWeightsB_29.yw;
  fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_44;
  tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_45;
  tmpvar_45.x = fetchesOffsetsU_15.x;
  tmpvar_45.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_46;
  tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
  tmpvar_46.z = shadowCoord_12.z;
  lowp float tmpvar_47;
  tmpvar_47 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_46);
  shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
  highp vec2 tmpvar_48;
  tmpvar_48.x = fetchesOffsetsU_15.y;
  tmpvar_48.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_49;
  tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
  tmpvar_49.z = shadowCoord_12.z;
  lowp float tmpvar_50;
  tmpvar_50 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_49);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
  highp vec2 tmpvar_51;
  tmpvar_51.x = fetchesOffsetsU_15.z;
  tmpvar_51.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_52;
  tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
  tmpvar_52.z = shadowCoord_12.z;
  lowp float tmpvar_53;
  tmpvar_53 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_52);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
  highp vec2 tmpvar_54;
  tmpvar_54.x = fetchesOffsetsU_15.w;
  tmpvar_54.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_55;
  tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
  tmpvar_55.z = shadowCoord_12.z;
  lowp float tmpvar_56;
  tmpvar_56 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_55);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.x) * tmpvar_56));
  highp vec2 tmpvar_57;
  tmpvar_57.x = fetchesOffsetsU_15.x;
  tmpvar_57.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_58;
  tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
  tmpvar_58.z = shadowCoord_12.z;
  lowp float tmpvar_59;
  tmpvar_59 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_58);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_59));
  highp vec2 tmpvar_60;
  tmpvar_60.x = fetchesOffsetsU_15.y;
  tmpvar_60.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_61;
  tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
  tmpvar_61.z = shadowCoord_12.z;
  lowp float tmpvar_62;
  tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_62));
  highp vec2 tmpvar_63;
  tmpvar_63.x = fetchesOffsetsU_15.z;
  tmpvar_63.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_64;
  tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
  tmpvar_64.z = shadowCoord_12.z;
  lowp float tmpvar_65;
  tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_65));
  highp vec2 tmpvar_66;
  tmpvar_66.x = fetchesOffsetsU_15.w;
  tmpvar_66.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_67;
  tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
  tmpvar_67.z = shadowCoord_12.z;
  lowp float tmpvar_68;
  tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.y) * tmpvar_68));
  highp vec2 tmpvar_69;
  tmpvar_69.x = fetchesOffsetsU_15.x;
  tmpvar_69.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_70;
  tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
  tmpvar_70.z = shadowCoord_12.z;
  lowp float tmpvar_71;
  tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_71));
  highp vec2 tmpvar_72;
  tmpvar_72.x = fetchesOffsetsU_15.y;
  tmpvar_72.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = (tmpvar_44 + tmpvar_72);
  tmpvar_73.z = shadowCoord_12.z;
  lowp float tmpvar_74;
  tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_74));
  highp vec2 tmpvar_75;
  tmpvar_75.x = fetchesOffsetsU_15.z;
  tmpvar_75.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_76;
  tmpvar_76.xy = (tmpvar_44 + tmpvar_75);
  tmpvar_76.z = shadowCoord_12.z;
  lowp float tmpvar_77;
  tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_77));
  highp vec2 tmpvar_78;
  tmpvar_78.x = fetchesOffsetsU_15.w;
  tmpvar_78.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_79;
  tmpvar_79.xy = (tmpvar_44 + tmpvar_78);
  tmpvar_79.z = shadowCoord_12.z;
  lowp float tmpvar_80;
  tmpvar_80 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_79);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.z) * tmpvar_80));
  highp vec2 tmpvar_81;
  tmpvar_81.x = fetchesOffsetsU_15.x;
  tmpvar_81.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_82;
  tmpvar_82.xy = (tmpvar_44 + tmpvar_81);
  tmpvar_82.z = shadowCoord_12.z;
  lowp float tmpvar_83;
  tmpvar_83 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_82);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.w) * tmpvar_83));
  highp vec2 tmpvar_84;
  tmpvar_84.x = fetchesOffsetsU_15.y;
  tmpvar_84.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_85;
  tmpvar_85.xy = (tmpvar_44 + tmpvar_84);
  tmpvar_85.z = shadowCoord_12.z;
  lowp float tmpvar_86;
  tmpvar_86 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_85);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.w) * tmpvar_86));
  highp vec2 tmpvar_87;
  tmpvar_87.x = fetchesOffsetsU_15.z;
  tmpvar_87.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_88;
  tmpvar_88.xy = (tmpvar_44 + tmpvar_87);
  tmpvar_88.z = shadowCoord_12.z;
  lowp float tmpvar_89;
  tmpvar_89 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_88);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.w) * tmpvar_89));
  highp vec2 tmpvar_90;
  tmpvar_90.x = fetchesOffsetsU_15.w;
  tmpvar_90.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_91;
  tmpvar_91.xy = (tmpvar_44 + tmpvar_90);
  tmpvar_91.z = shadowCoord_12.z;
  lowp float tmpvar_92;
  tmpvar_92 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_91);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.w) * tmpvar_92));
  highp vec3 tmpvar_93;
  highp vec3 tmpvar_94;
  highp vec3 lightDir_95;
  highp vec3 tmpvar_96;
  tmpvar_96 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_97;
  tmpvar_97 = clamp ((sqrt(
    dot (tmpvar_96, tmpvar_96)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_95 = normalize(tmpvar_96);
  tmpvar_94 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_93 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_98;
  mediump float diffuseTerm_99;
  highp float perceptualRoughness_100;
  mediump vec3 tmpvar_101;
  mediump vec3 albedo_102;
  albedo_102 = tmpvar_2;
  mediump vec3 specColor_103;
  specColor_103 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_102 * tmpvar_3));
  tmpvar_101 = (albedo_102 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_98 = 0.0;
  mediump float alpha_104;
  alpha_104 = tmpvar_98;
  tmpvar_98 = alpha_104;
  mediump float tmpvar_105;
  tmpvar_105 = (1.0 - tmpvar_4);
  perceptualRoughness_100 = tmpvar_105;
  highp vec3 tmpvar_106;
  highp vec3 inVec_107;
  inVec_107 = (lightDir_95 + tmpvar_93);
  tmpvar_106 = (inVec_107 * inversesqrt(max (0.001, 
    dot (inVec_107, inVec_107)
  )));
  highp float tmpvar_108;
  tmpvar_108 = abs(dot (tmpvar_93, tmpvar_94));
  highp float tmpvar_109;
  tmpvar_109 = clamp (dot (tmpvar_94, lightDir_95), 0.0, 1.0);
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_94, tmpvar_106), 0.0, 1.0);
  mediump float tmpvar_111;
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (lightDir_95, tmpvar_106), 0.0, 1.0);
  tmpvar_111 = tmpvar_112;
  mediump float tmpvar_113;
  mediump float NdotV_114;
  NdotV_114 = tmpvar_108;
  mediump float NdotL_115;
  NdotL_115 = tmpvar_109;
  mediump float perceptualRoughness_116;
  perceptualRoughness_116 = perceptualRoughness_100;
  mediump float tmpvar_117;
  tmpvar_117 = (0.5 + ((2.0 * tmpvar_111) * (tmpvar_111 * perceptualRoughness_116)));
  mediump float x_118;
  x_118 = (1.0 - NdotL_115);
  mediump float x_119;
  x_119 = (1.0 - NdotV_114);
  tmpvar_113 = ((1.0 + (
    (tmpvar_117 - 1.0)
   * 
    ((x_118 * x_118) * ((x_118 * x_118) * x_118))
  )) * (1.0 + (
    (tmpvar_117 - 1.0)
   * 
    ((x_119 * x_119) * ((x_119 * x_119) * x_119))
  )));
  highp float tmpvar_120;
  tmpvar_120 = (tmpvar_113 * tmpvar_109);
  diffuseTerm_99 = tmpvar_120;
  highp float tmpvar_121;
  tmpvar_121 = max ((perceptualRoughness_100 * perceptualRoughness_100), 0.002);
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_121 * tmpvar_121);
  highp float tmpvar_123;
  tmpvar_123 = (((
    (tmpvar_110 * tmpvar_122)
   - tmpvar_110) * tmpvar_110) + 1.0);
  mediump vec3 tmpvar_124;
  mediump float x_125;
  x_125 = (1.0 - tmpvar_111);
  tmpvar_124 = (specColor_103 + ((1.0 - specColor_103) * (
    (x_125 * x_125)
   * 
    ((x_125 * x_125) * x_125)
  )));
  outColor_1.xyz = (((
    (tmpvar_101 * LIGHT_COLOR)
   * diffuseTerm_99) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_122)
       / 
        ((tmpvar_123 * tmpvar_123) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_109 * (
          (tmpvar_108 * (1.0 - tmpvar_121))
         + tmpvar_121)) + (tmpvar_108 * (
          (tmpvar_109 * (1.0 - tmpvar_121))
         + tmpvar_121))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_109)) * LIGHT_COLOR)
   * tmpvar_124)) * ((
    ((1.0 - tmpvar_97) / ((LIGHT_ATTENUATION.x + (tmpvar_97 * LIGHT_ATTENUATION.y)) + ((tmpvar_97 * tmpvar_97) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_95, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalWorld_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  normalWorld_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * _Metallic);
  tmpvar_4 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec2 fetchesOffsetsV_15;
  highp vec2 fetchesOffsetsU_16;
  highp float shadow_17;
  shadow_17 = 1.0;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec4 computedWeight_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_20.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_20.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  computedWeight_21 = (computedArea_22 * 0.44444);
  highp vec4 computedWeight_28;
  highp vec4 computedArea_29;
  highp vec4 computedAreaUncut_30;
  highp float tmpvar_31;
  tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
  computedArea_29.x = tmpvar_32;
  computedAreaUncut_30.x = tmpvar_32;
  computedArea_29.w = tmpvar_31;
  computedAreaUncut_30.w = tmpvar_31;
  computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_33;
  tmpvar_33 = min (tmpvar_20.y, 0.0);
  computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
  computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = max (tmpvar_20.y, 0.0);
  computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
  computedWeight_28 = (computedArea_29 * 0.44444);
  highp vec2 tmpvar_35;
  tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
  highp vec2 tmpvar_36;
  tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
  fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_16.x;
  tmpvar_38.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_13.z;
  highp vec4 tmpvar_40;
  tmpvar_40 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
  highp float tmpvar_41;
  if ((tmpvar_40.x < shadowCoord_13.z)) {
    tmpvar_41 = 0.0;
  } else {
    tmpvar_41 = 1.0;
  };
  shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_41);
  highp vec2 tmpvar_42;
  tmpvar_42.x = fetchesOffsetsU_16.y;
  tmpvar_42.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_43;
  tmpvar_43.xy = (tmpvar_37 + tmpvar_42);
  tmpvar_43.z = shadowCoord_13.z;
  highp vec4 tmpvar_44;
  tmpvar_44 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
  highp float tmpvar_45;
  if ((tmpvar_44.x < shadowCoord_13.z)) {
    tmpvar_45 = 0.0;
  } else {
    tmpvar_45 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_16.x;
  tmpvar_46.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_37 + tmpvar_46);
  tmpvar_47.z = shadowCoord_13.z;
  highp vec4 tmpvar_48;
  tmpvar_48 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_47.xy);
  highp float tmpvar_49;
  if ((tmpvar_48.x < shadowCoord_13.z)) {
    tmpvar_49 = 0.0;
  } else {
    tmpvar_49 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_49));
  highp vec2 tmpvar_50;
  tmpvar_50.x = fetchesOffsetsU_16.y;
  tmpvar_50.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_51;
  tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
  tmpvar_51.z = shadowCoord_13.z;
  highp vec4 tmpvar_52;
  tmpvar_52 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_51.xy);
  highp float tmpvar_53;
  if ((tmpvar_52.x < shadowCoord_13.z)) {
    tmpvar_53 = 0.0;
  } else {
    tmpvar_53 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_53));
  highp vec3 tmpvar_54;
  highp vec3 lightDir_55;
  highp vec3 tmpvar_56;
  tmpvar_56 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_57;
  tmpvar_57 = clamp ((sqrt(
    dot (tmpvar_56, tmpvar_56)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_55 = normalize(tmpvar_56);
  tmpvar_54 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 tmpvar_61;
  mediump vec3 albedo_62;
  albedo_62 = tmpvar_2;
  mediump vec3 specColor_63;
  specColor_63 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_62 * tmpvar_3));
  tmpvar_61 = (albedo_62 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_58 = 0.0;
  mediump float alpha_64;
  alpha_64 = tmpvar_58;
  tmpvar_58 = alpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (lightDir_55 + tmpvar_54);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_54, normalWorld_5));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (normalWorld_5, lightDir_55), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (normalWorld_5, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (lightDir_55, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_60;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_59 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_63 + ((1.0 - specColor_63) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  outColor_1.xyz = (((
    (tmpvar_61 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * ((
    ((1.0 - tmpvar_57) / ((LIGHT_ATTENUATION.x + (tmpvar_57 * LIGHT_ATTENUATION.y)) + ((tmpvar_57 * tmpvar_57) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_55, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = normalize(tmpvar_15);
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 tmpvar_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  tmpvar_20 = (albedo_21 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_23;
  alpha_23 = tmpvar_17;
  tmpvar_17 = alpha_23;
  mediump float tmpvar_24;
  tmpvar_24 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_24;
  highp vec3 tmpvar_25;
  highp vec3 inVec_26;
  inVec_26 = (tmpvar_13 + tmpvar_12);
  tmpvar_25 = (inVec_26 * inversesqrt(max (0.001, 
    dot (inVec_26, inVec_26)
  )));
  highp float tmpvar_27;
  tmpvar_27 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_14, tmpvar_25), 0.0, 1.0);
  mediump float tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_13, tmpvar_25), 0.0, 1.0);
  tmpvar_30 = tmpvar_31;
  mediump float tmpvar_32;
  mediump float NdotV_33;
  NdotV_33 = tmpvar_27;
  mediump float NdotL_34;
  NdotL_34 = tmpvar_28;
  mediump float perceptualRoughness_35;
  perceptualRoughness_35 = perceptualRoughness_19;
  mediump float tmpvar_36;
  tmpvar_36 = (0.5 + ((2.0 * tmpvar_30) * (tmpvar_30 * perceptualRoughness_35)));
  mediump float x_37;
  x_37 = (1.0 - NdotL_34);
  mediump float x_38;
  x_38 = (1.0 - NdotV_33);
  tmpvar_32 = ((1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )) * (1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_32 * tmpvar_28);
  diffuseTerm_18 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_40 * tmpvar_40);
  highp float tmpvar_42;
  tmpvar_42 = (((
    (tmpvar_29 * tmpvar_41)
   - tmpvar_29) * tmpvar_29) + 1.0);
  mediump vec3 tmpvar_43;
  mediump float x_44;
  x_44 = (1.0 - tmpvar_30);
  tmpvar_43 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_44 * x_44)
   * 
    ((x_44 * x_44) * x_44)
  )));
  outColor_1.xyz = (((
    (tmpvar_20 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_41)
       / 
        ((tmpvar_42 * tmpvar_42) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_28 * (
          (tmpvar_27 * (1.0 - tmpvar_40))
         + tmpvar_40)) + (tmpvar_27 * (
          (tmpvar_28 * (1.0 - tmpvar_40))
         + tmpvar_40))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_28)) * LIGHT_COLOR)
   * tmpvar_43)) * ((1.0 - tmpvar_16) / (
    (LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z)
  )));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * _Metallic);
  tmpvar_4 = (mg_6.y * _Smoothness);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = normalize(tmpvar_15);
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 tmpvar_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  tmpvar_20 = (albedo_21 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_23;
  alpha_23 = tmpvar_17;
  tmpvar_17 = alpha_23;
  mediump float tmpvar_24;
  tmpvar_24 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_24;
  highp vec3 tmpvar_25;
  highp vec3 inVec_26;
  inVec_26 = (tmpvar_13 + tmpvar_12);
  tmpvar_25 = (inVec_26 * inversesqrt(max (0.001, 
    dot (inVec_26, inVec_26)
  )));
  highp float tmpvar_27;
  tmpvar_27 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_14, tmpvar_25), 0.0, 1.0);
  mediump float tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_13, tmpvar_25), 0.0, 1.0);
  tmpvar_30 = tmpvar_31;
  mediump float tmpvar_32;
  mediump float NdotV_33;
  NdotV_33 = tmpvar_27;
  mediump float NdotL_34;
  NdotL_34 = tmpvar_28;
  mediump float perceptualRoughness_35;
  perceptualRoughness_35 = perceptualRoughness_19;
  mediump float tmpvar_36;
  tmpvar_36 = (0.5 + ((2.0 * tmpvar_30) * (tmpvar_30 * perceptualRoughness_35)));
  mediump float x_37;
  x_37 = (1.0 - NdotL_34);
  mediump float x_38;
  x_38 = (1.0 - NdotV_33);
  tmpvar_32 = ((1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )) * (1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_32 * tmpvar_28);
  diffuseTerm_18 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_40 * tmpvar_40);
  highp float tmpvar_42;
  tmpvar_42 = (((
    (tmpvar_29 * tmpvar_41)
   - tmpvar_29) * tmpvar_29) + 1.0);
  mediump vec3 tmpvar_43;
  mediump float x_44;
  x_44 = (1.0 - tmpvar_30);
  tmpvar_43 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_44 * x_44)
   * 
    ((x_44 * x_44) * x_44)
  )));
  outColor_1.xyz = (((
    (tmpvar_20 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_41)
       / 
        ((tmpvar_42 * tmpvar_42) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_28 * (
          (tmpvar_27 * (1.0 - tmpvar_40))
         + tmpvar_40)) + (tmpvar_27 * (
          (tmpvar_28 * (1.0 - tmpvar_40))
         + tmpvar_40))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_28)) * LIGHT_COLOR)
   * tmpvar_43)) * ((1.0 - tmpvar_16) / (
    (LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z)
  )));
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
}

 
end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[attribute vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[0].x = row0_3.x;
  tmpvar_8[0].y = row0_3.y;
  tmpvar_8[0].z = row0_3.z;
  tmpvar_8[0].w = row0_3.w;
  tmpvar_8[1].x = row1_2.x;
  tmpvar_8[1].y = row1_2.y;
  tmpvar_8[1].z = row1_2.z;
  tmpvar_8[1].w = row1_2.w;
  tmpvar_8[2].x = row2_1.x;
  tmpvar_8[2].y = row2_1.y;
  tmpvar_8[2].z = row2_1.z;
  tmpvar_8[2].w = row2_1.w;
  tmpvar_8[3].x = 0.0;
  tmpvar_8[3].y = 0.0;
  tmpvar_8[3].z = 0.0;
  tmpvar_8[3].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)));
  highp vec4 clipPos_10;
  clipPos_10.xyw = tmpvar_9.xyw;
  clipPos_10.z = (tmpvar_9.z + (LIGHT_PARAM.x / tmpvar_9.w));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_11 * clipPos_10);
}

]===],
		psShader = [===[void main ()
{
  gl_FragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[attribute vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[void main ()
{
  gl_FragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end
