

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
[Enum(BlendFunc)]
_BlendSrc = {"blendsrc", FLOAT, "4.0"},
[Enum(BlendFunc)]
_BlendDst = {"blenddst", FLOAT, "5.0"},
#END

#DEFTAG
ShaderName = "spine3d"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
    float4 color : COLOR0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
    float4 color : COLOR0;
};

sampler2D TEXTURE_DIFFUSE;


v2f vert(appdata v)
{
    v2f o;
    float4 pos = ObjectToClipPos(float4(v.vertex * 0.001,0.0,1.0));
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    o.color = v.color;
    return o;
}

float4 frag(v2f i) : SV_Target
{
    float4 col = tex2D(TEXTURE_DIFFUSE, i.uv);
    col = col * i.color;
    return col;
}
ENDCG
#END
