

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },

_BlendSrc = {"blendsrc", FLOAT, "4.0"},

_BlendDst = {"blenddst", FLOAT, "5.0"},

	}
	Attributes = 
	{
		_BlendSrc = "Enum(BlendFunc)", 
		_BlendDst = "Enum(BlendFunc)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "spine3d"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_COLOR0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.zw = vec2(0.0, 1.0);
  tmpvar_1.xy = (_glesVertex.xy * 0.001);
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
  xlv_COLOR0 = _glesColor;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_COLOR0;
void main ()
{
  highp vec4 col_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_1 = tmpvar_2;
  col_1 = (col_1 * xlv_COLOR0);
  gl_FragData[0] = col_1;
}

]===],
	},
}

end
