

function DefineParams()
	Properties = 
	{
		
_MainTex = { "main Color", TEXTURE2D, "white" },
_Gloss = { "specular Gloss", FLOAT, "0.5" },
_Specular = { "specular Color", FLOAT, "0.5"},
_CutOff = { "CutOff", FLOAT, "0.2" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "Specular"
RenderQueue = "TransparentCutout+100"
end 

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = tmpvar_8[uint(0)].xyz;
  tmpvar_11[1u] = tmpvar_8[1u].xyz;
  tmpvar_11[2u] = tmpvar_8[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_10 * (_glesNormal * tmpvar_11)));
  gl_Position = (tmpvar_9 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_8)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  outColor_1.xyz = (AMBIENT_COLOR * col_2.xyz);
  outColor_1.w = 1.0;
  if (((col_2.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = tmpvar_8[uint(0)].xyz;
  tmpvar_11[1u] = tmpvar_8[1u].xyz;
  tmpvar_11[2u] = tmpvar_8[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_10 * (_glesNormal * tmpvar_11)));
  gl_Position = (tmpvar_9 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_8)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3);
  tmpvar_4 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_5, tmpvar_4), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_4 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_5), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) + (AMBIENT_COLOR * col_2.xyz));
  outColor_1.w = 1.0;
  if (((col_2.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_7;
    highp vec2 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 computedWeight_13;
    highp vec4 computedArea_14;
    highp vec4 computedAreaUncut_15;
    highp float tmpvar_16;
    tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
    computedArea_14.x = tmpvar_17;
    computedAreaUncut_15.x = tmpvar_17;
    computedArea_14.w = tmpvar_16;
    computedAreaUncut_15.w = tmpvar_16;
    computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_18;
    tmpvar_18 = min (tmpvar_12.x, 0.0);
    computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
    computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = max (tmpvar_12.x, 0.0);
    computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
    computedWeight_13 = (computedArea_14 * 0.44444);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_12.y, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_12.y, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec2 tmpvar_27;
    tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
    highp vec2 tmpvar_28;
    tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
    fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_29;
    tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_30;
    tmpvar_30.x = fetchesOffsetsU_8.x;
    tmpvar_30.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
    tmpvar_31.z = shadowCoord_5.z;
    mediump float tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
    shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_8.y;
    tmpvar_33.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_8.x;
    tmpvar_36.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
    tmpvar_37.z = shadowCoord_5.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_8.y;
    tmpvar_39.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
    tmpvar_40.z = shadowCoord_5.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_42;
  tmpvar_42 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_2, tmpvar_42), 0.0, 1.0) * LIGHT_COLOR) * col_3.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_42 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_2)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * tmpvar_6) + (AMBIENT_COLOR * col_3.xyz));
  outColor_1.w = 1.0;
  if (((col_3.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_7;
    highp vec3 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec3 texelsWeightsA_13;
    highp vec3 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.16 * tmpvar_18);
    texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
    texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
    texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
    texelsWeightsB_14.z = (0.16 * tmpvar_17);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.z = texelsWeightsB_14.y;
    highp vec3 tmpvar_30;
    tmpvar_30.x = texelsWeightsA_13.y;
    tmpvar_30.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_21.y;
    tmpvar_33.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.x = texelsWeightsA_13.y;
    tmpvar_35.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_21.y;
    tmpvar_36.yz = texelsWeightsB_22.xz;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.x;
    tmpvar_47.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.y;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.z;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.x;
    tmpvar_56.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.y;
    tmpvar_59.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.z;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_65;
  tmpvar_65 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_2, tmpvar_65), 0.0, 1.0) * LIGHT_COLOR) * col_3.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_65 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_2)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * tmpvar_6) + (AMBIENT_COLOR * col_3.xyz));
  outColor_1.w = 1.0;
  if (((col_3.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_7;
    highp vec4 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 texelsWeightsA_13;
    highp vec4 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.081632 * tmpvar_18);
    texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
    texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
    texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
    texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
    texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
    texelsWeightsB_14.w = (0.081632 * tmpvar_17);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.zw = texelsWeightsB_14.xz;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = texelsWeightsA_13.yw;
    tmpvar_30.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_21.yw;
    tmpvar_33.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_13.yw;
    tmpvar_35.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_21.yw;
    tmpvar_36.zw = texelsWeightsB_22.yw;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.w;
    tmpvar_47.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.x;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.y;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.z;
    tmpvar_56.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.w;
    tmpvar_59.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.x;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_8.y;
    tmpvar_65.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
    tmpvar_66.z = shadowCoord_5.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_8.z;
    tmpvar_68.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
    tmpvar_69.z = shadowCoord_5.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_8.w;
    tmpvar_71.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
    tmpvar_72.z = shadowCoord_5.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_8.x;
    tmpvar_74.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
    tmpvar_75.z = shadowCoord_5.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_8.y;
    tmpvar_77.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
    tmpvar_78.z = shadowCoord_5.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_8.z;
    tmpvar_80.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
    tmpvar_81.z = shadowCoord_5.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_8.w;
    tmpvar_83.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
    tmpvar_84.z = shadowCoord_5.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_86;
  tmpvar_86 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_2, tmpvar_86), 0.0, 1.0) * LIGHT_COLOR) * col_3.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_86 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_2)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * tmpvar_6) + (AMBIENT_COLOR * col_3.xyz));
  outColor_1.w = 1.0;
  if (((col_3.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    highp vec2 tmpvar_7;
    tmpvar_7.x = LIGHT_PARAM.z;
    tmpvar_7.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_8;
    tmpvar_8.xy = tmpvar_7;
    highp float tmpvar_9;
    tmpvar_9 = (1.0/(LIGHT_PARAM.z));
    tmpvar_8.z = tmpvar_9;
    tmpvar_8.w = tmpvar_9;
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = tmpvar_8.xy;
    shadow_10 = 0.0;
    highp vec3 tmpvar_12;
    tmpvar_12.xy = (shadowCoord_5.xy - LIGHT_PARAM.zz);
    tmpvar_12.z = shadowCoord_5.z;
    highp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_12.xy);
    highp float tmpvar_14;
    if ((tmpvar_13.x < xlv_TEXCOORD4.z)) {
      tmpvar_14 = 0.0;
    } else {
      tmpvar_14 = 1.0;
    };
    shadow_10 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.x = 0.0;
    tmpvar_15.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_5.xy + tmpvar_15);
    tmpvar_16.z = shadowCoord_5.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_10 = (tmpvar_14 + tmpvar_18);
    highp vec2 tmpvar_19;
    tmpvar_19.x = tmpvar_11.x;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_5.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_5.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.y = 0.0;
    tmpvar_23.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_5.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_5.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_26);
    highp vec4 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_5.xy);
    highp float tmpvar_28;
    if ((tmpvar_27.x < xlv_TEXCOORD4.z)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_28);
    highp vec2 tmpvar_29;
    tmpvar_29.y = 0.0;
    tmpvar_29.x = tmpvar_11.x;
    highp vec3 tmpvar_30;
    tmpvar_30.xy = (shadowCoord_5.xy + tmpvar_29);
    tmpvar_30.z = shadowCoord_5.z;
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = -(LIGHT_PARAM.z);
    tmpvar_33.y = tmpvar_11.y;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_5.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = tmpvar_11.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_5.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_5.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_40);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_5.xy + LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_5.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_43);
    shadow_10 = (shadow_10 / 9.0);
    tmpvar_6 = mix (1.0, shadow_10, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_44;
  tmpvar_44 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_2, tmpvar_44), 0.0, 1.0) * LIGHT_COLOR) * col_3.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_44 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_2)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * tmpvar_6) + (AMBIENT_COLOR * col_3.xyz));
  outColor_1.w = 1.0;
  if (((col_3.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_5;
  tmpvar_5[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_5[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_5[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_5 * _glesNormal));
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  outColor_1.xyz = (AMBIENT_COLOR * col_2.xyz);
  outColor_1.w = 1.0;
  if (((col_2.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_5;
  tmpvar_5[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_5[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_5[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_5 * _glesNormal));
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3);
  tmpvar_4 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_5, tmpvar_4), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_4 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_5), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) + (AMBIENT_COLOR * col_2.xyz));
  outColor_1.w = 1.0;
  if (((col_2.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_7))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_7;
    highp vec2 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 computedWeight_13;
    highp vec4 computedArea_14;
    highp vec4 computedAreaUncut_15;
    highp float tmpvar_16;
    tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
    computedArea_14.x = tmpvar_17;
    computedAreaUncut_15.x = tmpvar_17;
    computedArea_14.w = tmpvar_16;
    computedAreaUncut_15.w = tmpvar_16;
    computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_18;
    tmpvar_18 = min (tmpvar_12.x, 0.0);
    computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
    computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = max (tmpvar_12.x, 0.0);
    computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
    computedWeight_13 = (computedArea_14 * 0.44444);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_12.y, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_12.y, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec2 tmpvar_27;
    tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
    highp vec2 tmpvar_28;
    tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
    fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_29;
    tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_30;
    tmpvar_30.x = fetchesOffsetsU_8.x;
    tmpvar_30.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
    tmpvar_31.z = shadowCoord_5.z;
    mediump float tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
    shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_8.y;
    tmpvar_33.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_8.x;
    tmpvar_36.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
    tmpvar_37.z = shadowCoord_5.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_8.y;
    tmpvar_39.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
    tmpvar_40.z = shadowCoord_5.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_42;
  tmpvar_42 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_2, tmpvar_42), 0.0, 1.0) * LIGHT_COLOR) * col_3.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_42 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_2)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * tmpvar_6) + (AMBIENT_COLOR * col_3.xyz));
  outColor_1.w = 1.0;
  if (((col_3.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_7))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_7;
    highp vec3 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec3 texelsWeightsA_13;
    highp vec3 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.16 * tmpvar_18);
    texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
    texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
    texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
    texelsWeightsB_14.z = (0.16 * tmpvar_17);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.z = texelsWeightsB_14.y;
    highp vec3 tmpvar_30;
    tmpvar_30.x = texelsWeightsA_13.y;
    tmpvar_30.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_21.y;
    tmpvar_33.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.x = texelsWeightsA_13.y;
    tmpvar_35.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_21.y;
    tmpvar_36.yz = texelsWeightsB_22.xz;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.x;
    tmpvar_47.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.y;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.z;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.x;
    tmpvar_56.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.y;
    tmpvar_59.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.z;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_65;
  tmpvar_65 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_2, tmpvar_65), 0.0, 1.0) * LIGHT_COLOR) * col_3.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_65 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_2)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * tmpvar_6) + (AMBIENT_COLOR * col_3.xyz));
  outColor_1.w = 1.0;
  if (((col_3.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_7))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_7;
    highp vec4 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 texelsWeightsA_13;
    highp vec4 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.081632 * tmpvar_18);
    texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
    texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
    texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
    texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
    texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
    texelsWeightsB_14.w = (0.081632 * tmpvar_17);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.zw = texelsWeightsB_14.xz;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = texelsWeightsA_13.yw;
    tmpvar_30.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_21.yw;
    tmpvar_33.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_13.yw;
    tmpvar_35.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_21.yw;
    tmpvar_36.zw = texelsWeightsB_22.yw;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.w;
    tmpvar_47.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.x;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.y;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.z;
    tmpvar_56.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.w;
    tmpvar_59.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.x;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_8.y;
    tmpvar_65.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
    tmpvar_66.z = shadowCoord_5.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_8.z;
    tmpvar_68.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
    tmpvar_69.z = shadowCoord_5.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_8.w;
    tmpvar_71.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
    tmpvar_72.z = shadowCoord_5.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_8.x;
    tmpvar_74.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
    tmpvar_75.z = shadowCoord_5.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_8.y;
    tmpvar_77.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
    tmpvar_78.z = shadowCoord_5.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_8.z;
    tmpvar_80.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
    tmpvar_81.z = shadowCoord_5.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_8.w;
    tmpvar_83.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
    tmpvar_84.z = shadowCoord_5.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_86;
  tmpvar_86 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_2, tmpvar_86), 0.0, 1.0) * LIGHT_COLOR) * col_3.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_86 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_2)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * tmpvar_6) + (AMBIENT_COLOR * col_3.xyz));
  outColor_1.w = 1.0;
  if (((col_3.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_7))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
uniform highp float _CutOff;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    highp vec2 tmpvar_7;
    tmpvar_7.x = LIGHT_PARAM.z;
    tmpvar_7.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_8;
    tmpvar_8.xy = tmpvar_7;
    highp float tmpvar_9;
    tmpvar_9 = (1.0/(LIGHT_PARAM.z));
    tmpvar_8.z = tmpvar_9;
    tmpvar_8.w = tmpvar_9;
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = tmpvar_8.xy;
    shadow_10 = 0.0;
    highp vec3 tmpvar_12;
    tmpvar_12.xy = (shadowCoord_5.xy - LIGHT_PARAM.zz);
    tmpvar_12.z = shadowCoord_5.z;
    highp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_12.xy);
    highp float tmpvar_14;
    if ((tmpvar_13.x < xlv_TEXCOORD4.z)) {
      tmpvar_14 = 0.0;
    } else {
      tmpvar_14 = 1.0;
    };
    shadow_10 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.x = 0.0;
    tmpvar_15.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_5.xy + tmpvar_15);
    tmpvar_16.z = shadowCoord_5.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_10 = (tmpvar_14 + tmpvar_18);
    highp vec2 tmpvar_19;
    tmpvar_19.x = tmpvar_11.x;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_5.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_5.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.y = 0.0;
    tmpvar_23.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_5.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_5.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_26);
    highp vec4 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_5.xy);
    highp float tmpvar_28;
    if ((tmpvar_27.x < xlv_TEXCOORD4.z)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_28);
    highp vec2 tmpvar_29;
    tmpvar_29.y = 0.0;
    tmpvar_29.x = tmpvar_11.x;
    highp vec3 tmpvar_30;
    tmpvar_30.xy = (shadowCoord_5.xy + tmpvar_29);
    tmpvar_30.z = shadowCoord_5.z;
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = -(LIGHT_PARAM.z);
    tmpvar_33.y = tmpvar_11.y;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_5.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = tmpvar_11.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_5.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_5.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_40);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_5.xy + LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_5.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_43);
    shadow_10 = (shadow_10 / 9.0);
    tmpvar_6 = mix (1.0, shadow_10, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_44;
  tmpvar_44 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_2, tmpvar_44), 0.0, 1.0) * LIGHT_COLOR) * col_3.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_44 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_2)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * tmpvar_6) + (AMBIENT_COLOR * col_3.xyz));
  outColor_1.w = 1.0;
  if (((col_3.w - _CutOff) <= 0.0)) {
    discard;
  };
  _glesFragData[0] = outColor_1;
}

]===],
	},
}

end

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = tmpvar_8[uint(0)].xyz;
  tmpvar_11[1u] = tmpvar_8[1u].xyz;
  tmpvar_11[2u] = tmpvar_8[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_10 * (_glesNormal * tmpvar_11)));
  gl_Position = (tmpvar_9 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_8)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3);
  tmpvar_4 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    clamp (dot (tmpvar_5, tmpvar_4), 0.0, 1.0)
   * LIGHT_COLOR) * col_2.xyz) + ((
    pow (clamp (dot (normalize(
      (tmpvar_4 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2)))
    ), tmpvar_5), 0.0, 1.0), (_Gloss * 128.0))
   * vec3(_Specular)) * LIGHT_COLOR));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_7;
    highp vec2 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 computedWeight_13;
    highp vec4 computedArea_14;
    highp vec4 computedAreaUncut_15;
    highp float tmpvar_16;
    tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
    computedArea_14.x = tmpvar_17;
    computedAreaUncut_15.x = tmpvar_17;
    computedArea_14.w = tmpvar_16;
    computedAreaUncut_15.w = tmpvar_16;
    computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_18;
    tmpvar_18 = min (tmpvar_12.x, 0.0);
    computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
    computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = max (tmpvar_12.x, 0.0);
    computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
    computedWeight_13 = (computedArea_14 * 0.44444);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_12.y, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_12.y, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec2 tmpvar_27;
    tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
    highp vec2 tmpvar_28;
    tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
    fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_29;
    tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_30;
    tmpvar_30.x = fetchesOffsetsU_8.x;
    tmpvar_30.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
    tmpvar_31.z = shadowCoord_5.z;
    mediump float tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
    shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_8.y;
    tmpvar_33.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_8.x;
    tmpvar_36.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
    tmpvar_37.z = shadowCoord_5.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_8.y;
    tmpvar_39.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
    tmpvar_40.z = shadowCoord_5.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_42;
  tmpvar_42 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_2, tmpvar_42), 0.0, 1.0) * LIGHT_COLOR)
   * col_3.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_42 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_2), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * tmpvar_6);
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_7;
    highp vec3 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec3 texelsWeightsA_13;
    highp vec3 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.16 * tmpvar_18);
    texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
    texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
    texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
    texelsWeightsB_14.z = (0.16 * tmpvar_17);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.z = texelsWeightsB_14.y;
    highp vec3 tmpvar_30;
    tmpvar_30.x = texelsWeightsA_13.y;
    tmpvar_30.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_21.y;
    tmpvar_33.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.x = texelsWeightsA_13.y;
    tmpvar_35.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_21.y;
    tmpvar_36.yz = texelsWeightsB_22.xz;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.x;
    tmpvar_47.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.y;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.z;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.x;
    tmpvar_56.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.y;
    tmpvar_59.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.z;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_65;
  tmpvar_65 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_2, tmpvar_65), 0.0, 1.0) * LIGHT_COLOR)
   * col_3.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_65 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_2), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * tmpvar_6);
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_7;
    highp vec4 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 texelsWeightsA_13;
    highp vec4 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.081632 * tmpvar_18);
    texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
    texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
    texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
    texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
    texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
    texelsWeightsB_14.w = (0.081632 * tmpvar_17);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.zw = texelsWeightsB_14.xz;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = texelsWeightsA_13.yw;
    tmpvar_30.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_21.yw;
    tmpvar_33.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_13.yw;
    tmpvar_35.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_21.yw;
    tmpvar_36.zw = texelsWeightsB_22.yw;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.w;
    tmpvar_47.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.x;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.y;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.z;
    tmpvar_56.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.w;
    tmpvar_59.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.x;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_8.y;
    tmpvar_65.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
    tmpvar_66.z = shadowCoord_5.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_8.z;
    tmpvar_68.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
    tmpvar_69.z = shadowCoord_5.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_8.w;
    tmpvar_71.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
    tmpvar_72.z = shadowCoord_5.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_8.x;
    tmpvar_74.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
    tmpvar_75.z = shadowCoord_5.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_8.y;
    tmpvar_77.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
    tmpvar_78.z = shadowCoord_5.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_8.z;
    tmpvar_80.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
    tmpvar_81.z = shadowCoord_5.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_8.w;
    tmpvar_83.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
    tmpvar_84.z = shadowCoord_5.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_86;
  tmpvar_86 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_2, tmpvar_86), 0.0, 1.0) * LIGHT_COLOR)
   * col_3.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_86 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_2), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * tmpvar_6);
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    highp vec2 tmpvar_7;
    tmpvar_7.x = LIGHT_PARAM.z;
    tmpvar_7.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_8;
    tmpvar_8.xy = tmpvar_7;
    highp float tmpvar_9;
    tmpvar_9 = (1.0/(LIGHT_PARAM.z));
    tmpvar_8.z = tmpvar_9;
    tmpvar_8.w = tmpvar_9;
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = tmpvar_8.xy;
    shadow_10 = 0.0;
    highp vec3 tmpvar_12;
    tmpvar_12.xy = (shadowCoord_5.xy - LIGHT_PARAM.zz);
    tmpvar_12.z = shadowCoord_5.z;
    highp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_12.xy);
    highp float tmpvar_14;
    if ((tmpvar_13.x < xlv_TEXCOORD4.z)) {
      tmpvar_14 = 0.0;
    } else {
      tmpvar_14 = 1.0;
    };
    shadow_10 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.x = 0.0;
    tmpvar_15.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_5.xy + tmpvar_15);
    tmpvar_16.z = shadowCoord_5.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_10 = (tmpvar_14 + tmpvar_18);
    highp vec2 tmpvar_19;
    tmpvar_19.x = tmpvar_11.x;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_5.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_5.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.y = 0.0;
    tmpvar_23.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_5.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_5.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_26);
    highp vec4 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_5.xy);
    highp float tmpvar_28;
    if ((tmpvar_27.x < xlv_TEXCOORD4.z)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_28);
    highp vec2 tmpvar_29;
    tmpvar_29.y = 0.0;
    tmpvar_29.x = tmpvar_11.x;
    highp vec3 tmpvar_30;
    tmpvar_30.xy = (shadowCoord_5.xy + tmpvar_29);
    tmpvar_30.z = shadowCoord_5.z;
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = -(LIGHT_PARAM.z);
    tmpvar_33.y = tmpvar_11.y;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_5.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = tmpvar_11.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_5.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_5.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_40);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_5.xy + LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_5.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_43);
    shadow_10 = (shadow_10 / 9.0);
    tmpvar_6 = mix (1.0, shadow_10, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_44;
  tmpvar_44 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_2, tmpvar_44), 0.0, 1.0) * LIGHT_COLOR)
   * col_3.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_44 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_2), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * tmpvar_6);
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = tmpvar_8[uint(0)].xyz;
  tmpvar_11[1u] = tmpvar_8[1u].xyz;
  tmpvar_11[2u] = tmpvar_8[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_10 * (_glesNormal * tmpvar_11)));
  gl_Position = (tmpvar_9 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_8)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 lightDir_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_7;
  tmpvar_7 = clamp ((sqrt(
    dot (tmpvar_6, tmpvar_6)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_5 = normalize(tmpvar_6);
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_4, lightDir_5), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_5 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_4), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    (1.0 - tmpvar_7)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_7 * LIGHT_ATTENUATION.y)) + ((tmpvar_7 * tmpvar_7) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (lightDir_5, 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  tmpvar_1.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec4 shadowCoord_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_4.w = tmpvar_5.w;
  shadowCoord_4.xyz = (tmpvar_5.xyz / tmpvar_5.w);
  shadowCoord_4.xyz = ((shadowCoord_4.xyz * 0.5) + 0.5);
  shadowCoord_4.y = (1.0 - shadowCoord_4.y);
  highp vec2 fetchesOffsetsV_6;
  highp vec2 fetchesOffsetsU_7;
  highp float shadow_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = (shadowCoord_4.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_10;
  tmpvar_10 = floor((tmpvar_9 + 0.5));
  highp vec2 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 computedWeight_12;
  highp vec4 computedArea_13;
  highp vec4 computedAreaUncut_14;
  highp float tmpvar_15;
  tmpvar_15 = (((tmpvar_11.x + 0.5) * (tmpvar_11.x + 0.5)) * 0.5);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 - tmpvar_11.x);
  computedArea_13.x = tmpvar_16;
  computedAreaUncut_14.x = tmpvar_16;
  computedArea_13.w = tmpvar_15;
  computedAreaUncut_14.w = tmpvar_15;
  computedAreaUncut_14.y = ((1.5 - tmpvar_11.x) - 0.5);
  highp float tmpvar_17;
  tmpvar_17 = min (tmpvar_11.x, 0.0);
  computedArea_13.y = (computedAreaUncut_14.y - (tmpvar_17 * tmpvar_17));
  computedAreaUncut_14.z = ((1.5 + tmpvar_11.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = max (tmpvar_11.x, 0.0);
  computedArea_13.z = (computedAreaUncut_14.z - (tmpvar_18 * tmpvar_18));
  computedWeight_12 = (computedArea_13 * 0.44444);
  highp vec4 computedWeight_19;
  highp vec4 computedArea_20;
  highp vec4 computedAreaUncut_21;
  highp float tmpvar_22;
  tmpvar_22 = (((tmpvar_11.y + 0.5) * (tmpvar_11.y + 0.5)) * 0.5);
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_22 - tmpvar_11.y);
  computedArea_20.x = tmpvar_23;
  computedAreaUncut_21.x = tmpvar_23;
  computedArea_20.w = tmpvar_22;
  computedAreaUncut_21.w = tmpvar_22;
  computedAreaUncut_21.y = ((1.5 - tmpvar_11.y) - 0.5);
  highp float tmpvar_24;
  tmpvar_24 = min (tmpvar_11.y, 0.0);
  computedArea_20.y = (computedAreaUncut_21.y - (tmpvar_24 * tmpvar_24));
  computedAreaUncut_21.z = ((1.5 + tmpvar_11.y) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = max (tmpvar_11.y, 0.0);
  computedArea_20.z = (computedAreaUncut_21.z - (tmpvar_25 * tmpvar_25));
  computedWeight_19 = (computedArea_20 * 0.44444);
  highp vec2 tmpvar_26;
  tmpvar_26 = (computedWeight_12.xz + computedWeight_12.yw);
  highp vec2 tmpvar_27;
  tmpvar_27 = (computedWeight_19.xz + computedWeight_19.yw);
  fetchesOffsetsU_7 = (((computedWeight_12.yw / tmpvar_26) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_6 = (((computedWeight_19.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_28;
  tmpvar_28 = (tmpvar_10 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_29;
  tmpvar_29.x = fetchesOffsetsU_7.x;
  tmpvar_29.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_30;
  tmpvar_30.xy = (tmpvar_28 + tmpvar_29);
  tmpvar_30.z = shadowCoord_4.z;
  mediump float tmpvar_31;
  tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30);
  shadow_8 = ((tmpvar_26.x * tmpvar_27.x) * tmpvar_31);
  highp vec2 tmpvar_32;
  tmpvar_32.x = fetchesOffsetsU_7.y;
  tmpvar_32.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_33;
  tmpvar_33.xy = (tmpvar_28 + tmpvar_32);
  tmpvar_33.z = shadowCoord_4.z;
  mediump float tmpvar_34;
  tmpvar_34 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_33);
  shadow_8 = (shadow_8 + ((tmpvar_26.y * tmpvar_27.x) * tmpvar_34));
  highp vec2 tmpvar_35;
  tmpvar_35.x = fetchesOffsetsU_7.x;
  tmpvar_35.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_36;
  tmpvar_36.xy = (tmpvar_28 + tmpvar_35);
  tmpvar_36.z = shadowCoord_4.z;
  mediump float tmpvar_37;
  tmpvar_37 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_36);
  shadow_8 = (shadow_8 + ((tmpvar_26.x * tmpvar_27.y) * tmpvar_37));
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_7.y;
  tmpvar_38.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_28 + tmpvar_38);
  tmpvar_39.z = shadowCoord_4.z;
  mediump float tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
  shadow_8 = (shadow_8 + ((tmpvar_26.y * tmpvar_27.y) * tmpvar_40));
  highp vec3 tmpvar_41;
  highp vec3 lightDir_42;
  highp vec3 tmpvar_43;
  tmpvar_43 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_44;
  tmpvar_44 = clamp ((sqrt(
    dot (tmpvar_43, tmpvar_43)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_42 = normalize(tmpvar_43);
  tmpvar_41 = normalize(xlv_TEXCOORD3);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_41, lightDir_42), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_42 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_41), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    ((1.0 - tmpvar_44) / ((LIGHT_ATTENUATION.x + (tmpvar_44 * LIGHT_ATTENUATION.y)) + ((tmpvar_44 * tmpvar_44) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_42, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_8, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  tmpvar_1.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec4 shadowCoord_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_4.w = tmpvar_5.w;
  shadowCoord_4.xyz = (tmpvar_5.xyz / tmpvar_5.w);
  shadowCoord_4.xyz = ((shadowCoord_4.xyz * 0.5) + 0.5);
  shadowCoord_4.y = (1.0 - shadowCoord_4.y);
  highp vec3 fetchesOffsetsV_6;
  highp vec3 fetchesOffsetsU_7;
  highp float shadow_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = (shadowCoord_4.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_10;
  tmpvar_10 = floor((tmpvar_9 + 0.5));
  highp vec2 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec3 texelsWeightsA_12;
  highp vec3 texelsWeightsB_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_11.x + 0.5) * (tmpvar_11.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_11.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_11.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_11.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_11.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_11.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  texelsWeightsA_12.x = (0.16 * tmpvar_17);
  texelsWeightsA_12.y = (0.16 * computedAreaUncut_15.y);
  texelsWeightsA_12.z = (0.16 * (computedArea_14.y + 1.0));
  texelsWeightsB_13.x = (0.16 * (computedArea_14.z + 1.0));
  texelsWeightsB_13.y = (0.16 * computedAreaUncut_15.z);
  texelsWeightsB_13.z = (0.16 * tmpvar_16);
  highp vec3 texelsWeightsA_20;
  highp vec3 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_11.y + 0.5) * (tmpvar_11.y + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_11.y);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_11.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_11.y, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_11.y) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_11.y, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.16 * tmpvar_25);
  texelsWeightsA_20.y = (0.16 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.16 * (computedArea_22.y + 1.0));
  texelsWeightsB_21.x = (0.16 * (computedArea_22.z + 1.0));
  texelsWeightsB_21.y = (0.16 * computedAreaUncut_23.z);
  texelsWeightsB_21.z = (0.16 * tmpvar_24);
  highp vec3 tmpvar_28;
  tmpvar_28.xy = texelsWeightsA_12.xz;
  tmpvar_28.z = texelsWeightsB_13.y;
  highp vec3 tmpvar_29;
  tmpvar_29.x = texelsWeightsA_12.y;
  tmpvar_29.yz = texelsWeightsB_13.xz;
  highp vec3 tmpvar_30;
  tmpvar_30 = (tmpvar_28 + tmpvar_29);
  highp vec3 tmpvar_31;
  tmpvar_31.xy = texelsWeightsA_20.xz;
  tmpvar_31.z = texelsWeightsB_21.y;
  highp vec3 tmpvar_32;
  tmpvar_32.x = texelsWeightsA_20.y;
  tmpvar_32.yz = texelsWeightsB_21.xz;
  highp vec3 tmpvar_33;
  tmpvar_33 = (tmpvar_31 + tmpvar_32);
  highp vec3 tmpvar_34;
  tmpvar_34.x = texelsWeightsA_12.y;
  tmpvar_34.yz = texelsWeightsB_13.xz;
  highp vec3 tmpvar_35;
  tmpvar_35.x = texelsWeightsA_20.y;
  tmpvar_35.yz = texelsWeightsB_21.xz;
  fetchesOffsetsU_7 = (((tmpvar_34 / tmpvar_30) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_6 = (((tmpvar_35 / tmpvar_33) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_36;
  tmpvar_36 = (tmpvar_10 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37.x = fetchesOffsetsU_7.x;
  tmpvar_37.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_38;
  tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
  tmpvar_38.z = shadowCoord_4.z;
  mediump float tmpvar_39;
  tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
  shadow_8 = ((tmpvar_30.x * tmpvar_33.x) * tmpvar_39);
  highp vec2 tmpvar_40;
  tmpvar_40.x = fetchesOffsetsU_7.y;
  tmpvar_40.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_41;
  tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
  tmpvar_41.z = shadowCoord_4.z;
  mediump float tmpvar_42;
  tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.x) * tmpvar_42));
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_7.z;
  tmpvar_43.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
  tmpvar_44.z = shadowCoord_4.z;
  mediump float tmpvar_45;
  tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.x) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_7.x;
  tmpvar_46.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
  tmpvar_47.z = shadowCoord_4.z;
  mediump float tmpvar_48;
  tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.y) * tmpvar_48));
  highp vec2 tmpvar_49;
  tmpvar_49.x = fetchesOffsetsU_7.y;
  tmpvar_49.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_50;
  tmpvar_50.xy = (tmpvar_36 + tmpvar_49);
  tmpvar_50.z = shadowCoord_4.z;
  mediump float tmpvar_51;
  tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.y) * tmpvar_51));
  highp vec2 tmpvar_52;
  tmpvar_52.x = fetchesOffsetsU_7.z;
  tmpvar_52.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_53;
  tmpvar_53.xy = (tmpvar_36 + tmpvar_52);
  tmpvar_53.z = shadowCoord_4.z;
  mediump float tmpvar_54;
  tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.y) * tmpvar_54));
  highp vec2 tmpvar_55;
  tmpvar_55.x = fetchesOffsetsU_7.x;
  tmpvar_55.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_56;
  tmpvar_56.xy = (tmpvar_36 + tmpvar_55);
  tmpvar_56.z = shadowCoord_4.z;
  mediump float tmpvar_57;
  tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.z) * tmpvar_57));
  highp vec2 tmpvar_58;
  tmpvar_58.x = fetchesOffsetsU_7.y;
  tmpvar_58.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_59;
  tmpvar_59.xy = (tmpvar_36 + tmpvar_58);
  tmpvar_59.z = shadowCoord_4.z;
  mediump float tmpvar_60;
  tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.z) * tmpvar_60));
  highp vec2 tmpvar_61;
  tmpvar_61.x = fetchesOffsetsU_7.z;
  tmpvar_61.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_62;
  tmpvar_62.xy = (tmpvar_36 + tmpvar_61);
  tmpvar_62.z = shadowCoord_4.z;
  mediump float tmpvar_63;
  tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.z) * tmpvar_63));
  highp vec3 tmpvar_64;
  highp vec3 lightDir_65;
  highp vec3 tmpvar_66;
  tmpvar_66 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_67;
  tmpvar_67 = clamp ((sqrt(
    dot (tmpvar_66, tmpvar_66)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_65 = normalize(tmpvar_66);
  tmpvar_64 = normalize(xlv_TEXCOORD3);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_64, lightDir_65), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_65 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_64), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    ((1.0 - tmpvar_67) / ((LIGHT_ATTENUATION.x + (tmpvar_67 * LIGHT_ATTENUATION.y)) + ((tmpvar_67 * tmpvar_67) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_65, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_8, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  tmpvar_1.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec4 shadowCoord_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_4.w = tmpvar_5.w;
  shadowCoord_4.xyz = (tmpvar_5.xyz / tmpvar_5.w);
  shadowCoord_4.xyz = ((shadowCoord_4.xyz * 0.5) + 0.5);
  shadowCoord_4.y = (1.0 - shadowCoord_4.y);
  highp vec4 fetchesOffsetsV_6;
  highp vec4 fetchesOffsetsU_7;
  highp float shadow_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = (shadowCoord_4.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_10;
  tmpvar_10 = floor((tmpvar_9 + 0.5));
  highp vec2 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 texelsWeightsA_12;
  highp vec4 texelsWeightsB_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_11.x + 0.5) * (tmpvar_11.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_11.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_11.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_11.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_11.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_11.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  texelsWeightsA_12.x = (0.081632 * tmpvar_17);
  texelsWeightsA_12.y = (0.081632 * computedAreaUncut_15.y);
  texelsWeightsA_12.z = (0.081632 * (computedAreaUncut_15.y + 1.0));
  texelsWeightsA_12.w = (0.081632 * (computedArea_14.y + 2.0));
  texelsWeightsB_13.x = (0.081632 * (computedArea_14.z + 2.0));
  texelsWeightsB_13.y = (0.081632 * (computedAreaUncut_15.z + 1.0));
  texelsWeightsB_13.z = (0.081632 * computedAreaUncut_15.z);
  texelsWeightsB_13.w = (0.081632 * tmpvar_16);
  highp vec4 texelsWeightsA_20;
  highp vec4 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_11.y + 0.5) * (tmpvar_11.y + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_11.y);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_11.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_11.y, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_11.y) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_11.y, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.081632 * tmpvar_25);
  texelsWeightsA_20.y = (0.081632 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.081632 * (computedAreaUncut_23.y + 1.0));
  texelsWeightsA_20.w = (0.081632 * (computedArea_22.y + 2.0));
  texelsWeightsB_21.x = (0.081632 * (computedArea_22.z + 2.0));
  texelsWeightsB_21.y = (0.081632 * (computedAreaUncut_23.z + 1.0));
  texelsWeightsB_21.z = (0.081632 * computedAreaUncut_23.z);
  texelsWeightsB_21.w = (0.081632 * tmpvar_24);
  highp vec4 tmpvar_28;
  tmpvar_28.xy = texelsWeightsA_12.xz;
  tmpvar_28.zw = texelsWeightsB_13.xz;
  highp vec4 tmpvar_29;
  tmpvar_29.xy = texelsWeightsA_12.yw;
  tmpvar_29.zw = texelsWeightsB_13.yw;
  highp vec4 tmpvar_30;
  tmpvar_30 = (tmpvar_28 + tmpvar_29);
  highp vec4 tmpvar_31;
  tmpvar_31.xy = texelsWeightsA_20.xz;
  tmpvar_31.zw = texelsWeightsB_21.xz;
  highp vec4 tmpvar_32;
  tmpvar_32.xy = texelsWeightsA_20.yw;
  tmpvar_32.zw = texelsWeightsB_21.yw;
  highp vec4 tmpvar_33;
  tmpvar_33 = (tmpvar_31 + tmpvar_32);
  highp vec4 tmpvar_34;
  tmpvar_34.xy = texelsWeightsA_12.yw;
  tmpvar_34.zw = texelsWeightsB_13.yw;
  highp vec4 tmpvar_35;
  tmpvar_35.xy = texelsWeightsA_20.yw;
  tmpvar_35.zw = texelsWeightsB_21.yw;
  fetchesOffsetsU_7 = (((tmpvar_34 / tmpvar_30) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_6 = (((tmpvar_35 / tmpvar_33) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_36;
  tmpvar_36 = (tmpvar_10 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37.x = fetchesOffsetsU_7.x;
  tmpvar_37.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_38;
  tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
  tmpvar_38.z = shadowCoord_4.z;
  mediump float tmpvar_39;
  tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
  shadow_8 = ((tmpvar_30.x * tmpvar_33.x) * tmpvar_39);
  highp vec2 tmpvar_40;
  tmpvar_40.x = fetchesOffsetsU_7.y;
  tmpvar_40.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_41;
  tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
  tmpvar_41.z = shadowCoord_4.z;
  mediump float tmpvar_42;
  tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.x) * tmpvar_42));
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_7.z;
  tmpvar_43.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
  tmpvar_44.z = shadowCoord_4.z;
  mediump float tmpvar_45;
  tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.x) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_7.w;
  tmpvar_46.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
  tmpvar_47.z = shadowCoord_4.z;
  mediump float tmpvar_48;
  tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_8 = (shadow_8 + ((tmpvar_30.w * tmpvar_33.x) * tmpvar_48));
  highp vec2 tmpvar_49;
  tmpvar_49.x = fetchesOffsetsU_7.x;
  tmpvar_49.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_50;
  tmpvar_50.xy = (tmpvar_36 + tmpvar_49);
  tmpvar_50.z = shadowCoord_4.z;
  mediump float tmpvar_51;
  tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.y) * tmpvar_51));
  highp vec2 tmpvar_52;
  tmpvar_52.x = fetchesOffsetsU_7.y;
  tmpvar_52.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_53;
  tmpvar_53.xy = (tmpvar_36 + tmpvar_52);
  tmpvar_53.z = shadowCoord_4.z;
  mediump float tmpvar_54;
  tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.y) * tmpvar_54));
  highp vec2 tmpvar_55;
  tmpvar_55.x = fetchesOffsetsU_7.z;
  tmpvar_55.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_56;
  tmpvar_56.xy = (tmpvar_36 + tmpvar_55);
  tmpvar_56.z = shadowCoord_4.z;
  mediump float tmpvar_57;
  tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.y) * tmpvar_57));
  highp vec2 tmpvar_58;
  tmpvar_58.x = fetchesOffsetsU_7.w;
  tmpvar_58.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_59;
  tmpvar_59.xy = (tmpvar_36 + tmpvar_58);
  tmpvar_59.z = shadowCoord_4.z;
  mediump float tmpvar_60;
  tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
  shadow_8 = (shadow_8 + ((tmpvar_30.w * tmpvar_33.y) * tmpvar_60));
  highp vec2 tmpvar_61;
  tmpvar_61.x = fetchesOffsetsU_7.x;
  tmpvar_61.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_62;
  tmpvar_62.xy = (tmpvar_36 + tmpvar_61);
  tmpvar_62.z = shadowCoord_4.z;
  mediump float tmpvar_63;
  tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.z) * tmpvar_63));
  highp vec2 tmpvar_64;
  tmpvar_64.x = fetchesOffsetsU_7.y;
  tmpvar_64.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_65;
  tmpvar_65.xy = (tmpvar_36 + tmpvar_64);
  tmpvar_65.z = shadowCoord_4.z;
  mediump float tmpvar_66;
  tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.z) * tmpvar_66));
  highp vec2 tmpvar_67;
  tmpvar_67.x = fetchesOffsetsU_7.z;
  tmpvar_67.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_68;
  tmpvar_68.xy = (tmpvar_36 + tmpvar_67);
  tmpvar_68.z = shadowCoord_4.z;
  mediump float tmpvar_69;
  tmpvar_69 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_68);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.z) * tmpvar_69));
  highp vec2 tmpvar_70;
  tmpvar_70.x = fetchesOffsetsU_7.w;
  tmpvar_70.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = (tmpvar_36 + tmpvar_70);
  tmpvar_71.z = shadowCoord_4.z;
  mediump float tmpvar_72;
  tmpvar_72 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_71);
  shadow_8 = (shadow_8 + ((tmpvar_30.w * tmpvar_33.z) * tmpvar_72));
  highp vec2 tmpvar_73;
  tmpvar_73.x = fetchesOffsetsU_7.x;
  tmpvar_73.y = fetchesOffsetsV_6.w;
  highp vec3 tmpvar_74;
  tmpvar_74.xy = (tmpvar_36 + tmpvar_73);
  tmpvar_74.z = shadowCoord_4.z;
  mediump float tmpvar_75;
  tmpvar_75 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_74);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.w) * tmpvar_75));
  highp vec2 tmpvar_76;
  tmpvar_76.x = fetchesOffsetsU_7.y;
  tmpvar_76.y = fetchesOffsetsV_6.w;
  highp vec3 tmpvar_77;
  tmpvar_77.xy = (tmpvar_36 + tmpvar_76);
  tmpvar_77.z = shadowCoord_4.z;
  mediump float tmpvar_78;
  tmpvar_78 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_77);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.w) * tmpvar_78));
  highp vec2 tmpvar_79;
  tmpvar_79.x = fetchesOffsetsU_7.z;
  tmpvar_79.y = fetchesOffsetsV_6.w;
  highp vec3 tmpvar_80;
  tmpvar_80.xy = (tmpvar_36 + tmpvar_79);
  tmpvar_80.z = shadowCoord_4.z;
  mediump float tmpvar_81;
  tmpvar_81 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_80);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.w) * tmpvar_81));
  highp vec2 tmpvar_82;
  tmpvar_82.x = fetchesOffsetsU_7.w;
  tmpvar_82.y = fetchesOffsetsV_6.w;
  highp vec3 tmpvar_83;
  tmpvar_83.xy = (tmpvar_36 + tmpvar_82);
  tmpvar_83.z = shadowCoord_4.z;
  mediump float tmpvar_84;
  tmpvar_84 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_83);
  shadow_8 = (shadow_8 + ((tmpvar_30.w * tmpvar_33.w) * tmpvar_84));
  highp vec3 tmpvar_85;
  highp vec3 lightDir_86;
  highp vec3 tmpvar_87;
  tmpvar_87 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_88;
  tmpvar_88 = clamp ((sqrt(
    dot (tmpvar_87, tmpvar_87)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_86 = normalize(tmpvar_87);
  tmpvar_85 = normalize(xlv_TEXCOORD3);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_85, lightDir_86), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_86 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_85), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    ((1.0 - tmpvar_88) / ((LIGHT_ATTENUATION.x + (tmpvar_88 * LIGHT_ATTENUATION.y)) + ((tmpvar_88 * tmpvar_88) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_86, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_8, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = tmpvar_9[uint(0)].xyz;
  tmpvar_12[1u] = tmpvar_9[1u].xyz;
  tmpvar_12[2u] = tmpvar_9[2u].xyz;
  tmpvar_1.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  tmpvar_1.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec2 fetchesOffsetsV_7;
  highp vec2 fetchesOffsetsU_8;
  highp float shadow_9;
  shadow_9 = 1.0;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 computedWeight_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_12.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_12.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  computedWeight_13 = (computedArea_14 * 0.44444);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_12.y, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_12.y, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec2 tmpvar_27;
  tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
  highp vec2 tmpvar_28;
  tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
  fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_29;
  tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_30;
  tmpvar_30.x = fetchesOffsetsU_8.x;
  tmpvar_30.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_31;
  tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
  tmpvar_31.z = shadowCoord_5.z;
  highp vec4 tmpvar_32;
  tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
  highp float tmpvar_33;
  if ((tmpvar_32.x < shadowCoord_5.z)) {
    tmpvar_33 = 0.0;
  } else {
    tmpvar_33 = 1.0;
  };
  shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_33);
  highp vec2 tmpvar_34;
  tmpvar_34.x = fetchesOffsetsU_8.y;
  tmpvar_34.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_35;
  tmpvar_35.xy = (tmpvar_29 + tmpvar_34);
  tmpvar_35.z = shadowCoord_5.z;
  highp vec4 tmpvar_36;
  tmpvar_36 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
  highp float tmpvar_37;
  if ((tmpvar_36.x < shadowCoord_5.z)) {
    tmpvar_37 = 0.0;
  } else {
    tmpvar_37 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_37));
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_8.x;
  tmpvar_38.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_29 + tmpvar_38);
  tmpvar_39.z = shadowCoord_5.z;
  highp vec4 tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
  highp float tmpvar_41;
  if ((tmpvar_40.x < shadowCoord_5.z)) {
    tmpvar_41 = 0.0;
  } else {
    tmpvar_41 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_41));
  highp vec2 tmpvar_42;
  tmpvar_42.x = fetchesOffsetsU_8.y;
  tmpvar_42.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_43;
  tmpvar_43.xy = (tmpvar_29 + tmpvar_42);
  tmpvar_43.z = shadowCoord_5.z;
  highp vec4 tmpvar_44;
  tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
  highp float tmpvar_45;
  if ((tmpvar_44.x < shadowCoord_5.z)) {
    tmpvar_45 = 0.0;
  } else {
    tmpvar_45 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_45));
  highp vec3 lightDir_46;
  highp vec3 tmpvar_47;
  tmpvar_47 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_48;
  tmpvar_48 = clamp ((sqrt(
    dot (tmpvar_47, tmpvar_47)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_46 = normalize(tmpvar_47);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_4, lightDir_46), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_46 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_4), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    ((1.0 - tmpvar_48) / ((LIGHT_ATTENUATION.x + (tmpvar_48 * LIGHT_ATTENUATION.y)) + ((tmpvar_48 * tmpvar_48) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_46, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_9, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = tmpvar_8[uint(0)].xyz;
  tmpvar_11[1u] = tmpvar_8[1u].xyz;
  tmpvar_11[2u] = tmpvar_8[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_10 * (_glesNormal * tmpvar_11)));
  gl_Position = (tmpvar_9 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_8)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_7;
  tmpvar_7 = clamp ((sqrt(
    dot (tmpvar_6, tmpvar_6)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_5 = normalize(xlv_TEXCOORD3);
  tmpvar_4 = normalize(tmpvar_6);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_5, tmpvar_4), 0.0, 1.0) * LIGHT_COLOR) * col_2.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_4 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_5)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * (
    (1.0 - tmpvar_7)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_7 * LIGHT_ATTENUATION.y)) + ((tmpvar_7 * tmpvar_7) * LIGHT_ATTENUATION.z))
  )) + (AMBIENT_COLOR * col_2.xyz));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = tmpvar_8[uint(0)].xyz;
  tmpvar_11[1u] = tmpvar_8[1u].xyz;
  tmpvar_11[2u] = tmpvar_8[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_10 * (_glesNormal * tmpvar_11)));
  gl_Position = (tmpvar_9 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_8)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_7;
  tmpvar_7 = clamp ((sqrt(
    dot (tmpvar_6, tmpvar_6)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_5 = normalize(xlv_TEXCOORD3);
  tmpvar_4 = normalize(tmpvar_6);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_5, tmpvar_4), 0.0, 1.0) * LIGHT_COLOR) * col_2.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_4 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_5)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * (
    (1.0 - tmpvar_7)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_7 * LIGHT_ATTENUATION.y)) + ((tmpvar_7 * tmpvar_7) * LIGHT_ATTENUATION.z))
  )) + (AMBIENT_COLOR * col_2.xyz));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_5;
  tmpvar_5[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_5[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_5[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_5 * _glesNormal));
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3);
  tmpvar_4 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    clamp (dot (tmpvar_5, tmpvar_4), 0.0, 1.0)
   * LIGHT_COLOR) * col_2.xyz) + ((
    pow (clamp (dot (normalize(
      (tmpvar_4 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2)))
    ), tmpvar_5), 0.0, 1.0), (_Gloss * 128.0))
   * vec3(_Specular)) * LIGHT_COLOR));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_7))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_7;
    highp vec2 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 computedWeight_13;
    highp vec4 computedArea_14;
    highp vec4 computedAreaUncut_15;
    highp float tmpvar_16;
    tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
    computedArea_14.x = tmpvar_17;
    computedAreaUncut_15.x = tmpvar_17;
    computedArea_14.w = tmpvar_16;
    computedAreaUncut_15.w = tmpvar_16;
    computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_18;
    tmpvar_18 = min (tmpvar_12.x, 0.0);
    computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
    computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = max (tmpvar_12.x, 0.0);
    computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
    computedWeight_13 = (computedArea_14 * 0.44444);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_12.y, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_12.y, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec2 tmpvar_27;
    tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
    highp vec2 tmpvar_28;
    tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
    fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_29;
    tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_30;
    tmpvar_30.x = fetchesOffsetsU_8.x;
    tmpvar_30.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
    tmpvar_31.z = shadowCoord_5.z;
    mediump float tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
    shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_8.y;
    tmpvar_33.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_8.x;
    tmpvar_36.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
    tmpvar_37.z = shadowCoord_5.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_8.y;
    tmpvar_39.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
    tmpvar_40.z = shadowCoord_5.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_42;
  tmpvar_42 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_2, tmpvar_42), 0.0, 1.0) * LIGHT_COLOR)
   * col_3.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_42 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_2), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * tmpvar_6);
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_7))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_7;
    highp vec3 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec3 texelsWeightsA_13;
    highp vec3 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.16 * tmpvar_18);
    texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
    texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
    texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
    texelsWeightsB_14.z = (0.16 * tmpvar_17);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.z = texelsWeightsB_14.y;
    highp vec3 tmpvar_30;
    tmpvar_30.x = texelsWeightsA_13.y;
    tmpvar_30.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_21.y;
    tmpvar_33.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.x = texelsWeightsA_13.y;
    tmpvar_35.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_21.y;
    tmpvar_36.yz = texelsWeightsB_22.xz;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.x;
    tmpvar_47.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.y;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.z;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.x;
    tmpvar_56.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.y;
    tmpvar_59.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.z;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_65;
  tmpvar_65 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_2, tmpvar_65), 0.0, 1.0) * LIGHT_COLOR)
   * col_3.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_65 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_2), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * tmpvar_6);
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_7))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_7;
    highp vec4 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 texelsWeightsA_13;
    highp vec4 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.081632 * tmpvar_18);
    texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
    texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
    texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
    texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
    texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
    texelsWeightsB_14.w = (0.081632 * tmpvar_17);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.zw = texelsWeightsB_14.xz;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = texelsWeightsA_13.yw;
    tmpvar_30.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_21.yw;
    tmpvar_33.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_13.yw;
    tmpvar_35.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_21.yw;
    tmpvar_36.zw = texelsWeightsB_22.yw;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.w;
    tmpvar_47.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.x;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.y;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.z;
    tmpvar_56.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.w;
    tmpvar_59.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.x;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_8.y;
    tmpvar_65.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
    tmpvar_66.z = shadowCoord_5.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_8.z;
    tmpvar_68.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
    tmpvar_69.z = shadowCoord_5.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_8.w;
    tmpvar_71.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
    tmpvar_72.z = shadowCoord_5.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_8.x;
    tmpvar_74.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
    tmpvar_75.z = shadowCoord_5.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_8.y;
    tmpvar_77.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
    tmpvar_78.z = shadowCoord_5.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_8.z;
    tmpvar_80.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
    tmpvar_81.z = shadowCoord_5.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_8.w;
    tmpvar_83.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
    tmpvar_84.z = shadowCoord_5.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_86;
  tmpvar_86 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_2, tmpvar_86), 0.0, 1.0) * LIGHT_COLOR)
   * col_3.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_86 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_2), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * tmpvar_6);
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_7))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  tmpvar_2 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    highp vec2 tmpvar_7;
    tmpvar_7.x = LIGHT_PARAM.z;
    tmpvar_7.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_8;
    tmpvar_8.xy = tmpvar_7;
    highp float tmpvar_9;
    tmpvar_9 = (1.0/(LIGHT_PARAM.z));
    tmpvar_8.z = tmpvar_9;
    tmpvar_8.w = tmpvar_9;
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = tmpvar_8.xy;
    shadow_10 = 0.0;
    highp vec3 tmpvar_12;
    tmpvar_12.xy = (shadowCoord_5.xy - LIGHT_PARAM.zz);
    tmpvar_12.z = shadowCoord_5.z;
    highp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_12.xy);
    highp float tmpvar_14;
    if ((tmpvar_13.x < xlv_TEXCOORD4.z)) {
      tmpvar_14 = 0.0;
    } else {
      tmpvar_14 = 1.0;
    };
    shadow_10 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.x = 0.0;
    tmpvar_15.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_5.xy + tmpvar_15);
    tmpvar_16.z = shadowCoord_5.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_10 = (tmpvar_14 + tmpvar_18);
    highp vec2 tmpvar_19;
    tmpvar_19.x = tmpvar_11.x;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_5.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_5.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.y = 0.0;
    tmpvar_23.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_5.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_5.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_26);
    highp vec4 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_5.xy);
    highp float tmpvar_28;
    if ((tmpvar_27.x < xlv_TEXCOORD4.z)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_28);
    highp vec2 tmpvar_29;
    tmpvar_29.y = 0.0;
    tmpvar_29.x = tmpvar_11.x;
    highp vec3 tmpvar_30;
    tmpvar_30.xy = (shadowCoord_5.xy + tmpvar_29);
    tmpvar_30.z = shadowCoord_5.z;
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = -(LIGHT_PARAM.z);
    tmpvar_33.y = tmpvar_11.y;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_5.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = tmpvar_11.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_5.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_5.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_40);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_5.xy + LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_5.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_43);
    shadow_10 = (shadow_10 / 9.0);
    tmpvar_6 = mix (1.0, shadow_10, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_44;
  tmpvar_44 = -(LIGHT_GIVEN_DIRECTION);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_2, tmpvar_44), 0.0, 1.0) * LIGHT_COLOR)
   * col_3.xyz) + (
    (pow (clamp (dot (
      normalize((tmpvar_44 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_2), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * tmpvar_6);
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_5;
  tmpvar_5[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_5[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_5[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_5 * _glesNormal));
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 lightDir_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_7;
  tmpvar_7 = clamp ((sqrt(
    dot (tmpvar_6, tmpvar_6)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_5 = normalize(tmpvar_6);
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_4, lightDir_5), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_5 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_4), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    (1.0 - tmpvar_7)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_7 * LIGHT_ATTENUATION.y)) + ((tmpvar_7 * tmpvar_7) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (lightDir_5, 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  tmpvar_2.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec4 shadowCoord_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_4.w = tmpvar_5.w;
  shadowCoord_4.xyz = (tmpvar_5.xyz / tmpvar_5.w);
  shadowCoord_4.xyz = ((shadowCoord_4.xyz * 0.5) + 0.5);
  shadowCoord_4.y = (1.0 - shadowCoord_4.y);
  highp vec2 fetchesOffsetsV_6;
  highp vec2 fetchesOffsetsU_7;
  highp float shadow_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = (shadowCoord_4.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_10;
  tmpvar_10 = floor((tmpvar_9 + 0.5));
  highp vec2 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 computedWeight_12;
  highp vec4 computedArea_13;
  highp vec4 computedAreaUncut_14;
  highp float tmpvar_15;
  tmpvar_15 = (((tmpvar_11.x + 0.5) * (tmpvar_11.x + 0.5)) * 0.5);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 - tmpvar_11.x);
  computedArea_13.x = tmpvar_16;
  computedAreaUncut_14.x = tmpvar_16;
  computedArea_13.w = tmpvar_15;
  computedAreaUncut_14.w = tmpvar_15;
  computedAreaUncut_14.y = ((1.5 - tmpvar_11.x) - 0.5);
  highp float tmpvar_17;
  tmpvar_17 = min (tmpvar_11.x, 0.0);
  computedArea_13.y = (computedAreaUncut_14.y - (tmpvar_17 * tmpvar_17));
  computedAreaUncut_14.z = ((1.5 + tmpvar_11.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = max (tmpvar_11.x, 0.0);
  computedArea_13.z = (computedAreaUncut_14.z - (tmpvar_18 * tmpvar_18));
  computedWeight_12 = (computedArea_13 * 0.44444);
  highp vec4 computedWeight_19;
  highp vec4 computedArea_20;
  highp vec4 computedAreaUncut_21;
  highp float tmpvar_22;
  tmpvar_22 = (((tmpvar_11.y + 0.5) * (tmpvar_11.y + 0.5)) * 0.5);
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_22 - tmpvar_11.y);
  computedArea_20.x = tmpvar_23;
  computedAreaUncut_21.x = tmpvar_23;
  computedArea_20.w = tmpvar_22;
  computedAreaUncut_21.w = tmpvar_22;
  computedAreaUncut_21.y = ((1.5 - tmpvar_11.y) - 0.5);
  highp float tmpvar_24;
  tmpvar_24 = min (tmpvar_11.y, 0.0);
  computedArea_20.y = (computedAreaUncut_21.y - (tmpvar_24 * tmpvar_24));
  computedAreaUncut_21.z = ((1.5 + tmpvar_11.y) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = max (tmpvar_11.y, 0.0);
  computedArea_20.z = (computedAreaUncut_21.z - (tmpvar_25 * tmpvar_25));
  computedWeight_19 = (computedArea_20 * 0.44444);
  highp vec2 tmpvar_26;
  tmpvar_26 = (computedWeight_12.xz + computedWeight_12.yw);
  highp vec2 tmpvar_27;
  tmpvar_27 = (computedWeight_19.xz + computedWeight_19.yw);
  fetchesOffsetsU_7 = (((computedWeight_12.yw / tmpvar_26) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_6 = (((computedWeight_19.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_28;
  tmpvar_28 = (tmpvar_10 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_29;
  tmpvar_29.x = fetchesOffsetsU_7.x;
  tmpvar_29.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_30;
  tmpvar_30.xy = (tmpvar_28 + tmpvar_29);
  tmpvar_30.z = shadowCoord_4.z;
  mediump float tmpvar_31;
  tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30);
  shadow_8 = ((tmpvar_26.x * tmpvar_27.x) * tmpvar_31);
  highp vec2 tmpvar_32;
  tmpvar_32.x = fetchesOffsetsU_7.y;
  tmpvar_32.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_33;
  tmpvar_33.xy = (tmpvar_28 + tmpvar_32);
  tmpvar_33.z = shadowCoord_4.z;
  mediump float tmpvar_34;
  tmpvar_34 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_33);
  shadow_8 = (shadow_8 + ((tmpvar_26.y * tmpvar_27.x) * tmpvar_34));
  highp vec2 tmpvar_35;
  tmpvar_35.x = fetchesOffsetsU_7.x;
  tmpvar_35.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_36;
  tmpvar_36.xy = (tmpvar_28 + tmpvar_35);
  tmpvar_36.z = shadowCoord_4.z;
  mediump float tmpvar_37;
  tmpvar_37 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_36);
  shadow_8 = (shadow_8 + ((tmpvar_26.x * tmpvar_27.y) * tmpvar_37));
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_7.y;
  tmpvar_38.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_28 + tmpvar_38);
  tmpvar_39.z = shadowCoord_4.z;
  mediump float tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
  shadow_8 = (shadow_8 + ((tmpvar_26.y * tmpvar_27.y) * tmpvar_40));
  highp vec3 tmpvar_41;
  highp vec3 lightDir_42;
  highp vec3 tmpvar_43;
  tmpvar_43 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_44;
  tmpvar_44 = clamp ((sqrt(
    dot (tmpvar_43, tmpvar_43)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_42 = normalize(tmpvar_43);
  tmpvar_41 = normalize(xlv_TEXCOORD3);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_41, lightDir_42), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_42 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_41), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    ((1.0 - tmpvar_44) / ((LIGHT_ATTENUATION.x + (tmpvar_44 * LIGHT_ATTENUATION.y)) + ((tmpvar_44 * tmpvar_44) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_42, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_8, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  tmpvar_2.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec4 shadowCoord_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_4.w = tmpvar_5.w;
  shadowCoord_4.xyz = (tmpvar_5.xyz / tmpvar_5.w);
  shadowCoord_4.xyz = ((shadowCoord_4.xyz * 0.5) + 0.5);
  shadowCoord_4.y = (1.0 - shadowCoord_4.y);
  highp vec3 fetchesOffsetsV_6;
  highp vec3 fetchesOffsetsU_7;
  highp float shadow_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = (shadowCoord_4.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_10;
  tmpvar_10 = floor((tmpvar_9 + 0.5));
  highp vec2 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec3 texelsWeightsA_12;
  highp vec3 texelsWeightsB_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_11.x + 0.5) * (tmpvar_11.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_11.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_11.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_11.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_11.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_11.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  texelsWeightsA_12.x = (0.16 * tmpvar_17);
  texelsWeightsA_12.y = (0.16 * computedAreaUncut_15.y);
  texelsWeightsA_12.z = (0.16 * (computedArea_14.y + 1.0));
  texelsWeightsB_13.x = (0.16 * (computedArea_14.z + 1.0));
  texelsWeightsB_13.y = (0.16 * computedAreaUncut_15.z);
  texelsWeightsB_13.z = (0.16 * tmpvar_16);
  highp vec3 texelsWeightsA_20;
  highp vec3 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_11.y + 0.5) * (tmpvar_11.y + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_11.y);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_11.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_11.y, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_11.y) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_11.y, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.16 * tmpvar_25);
  texelsWeightsA_20.y = (0.16 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.16 * (computedArea_22.y + 1.0));
  texelsWeightsB_21.x = (0.16 * (computedArea_22.z + 1.0));
  texelsWeightsB_21.y = (0.16 * computedAreaUncut_23.z);
  texelsWeightsB_21.z = (0.16 * tmpvar_24);
  highp vec3 tmpvar_28;
  tmpvar_28.xy = texelsWeightsA_12.xz;
  tmpvar_28.z = texelsWeightsB_13.y;
  highp vec3 tmpvar_29;
  tmpvar_29.x = texelsWeightsA_12.y;
  tmpvar_29.yz = texelsWeightsB_13.xz;
  highp vec3 tmpvar_30;
  tmpvar_30 = (tmpvar_28 + tmpvar_29);
  highp vec3 tmpvar_31;
  tmpvar_31.xy = texelsWeightsA_20.xz;
  tmpvar_31.z = texelsWeightsB_21.y;
  highp vec3 tmpvar_32;
  tmpvar_32.x = texelsWeightsA_20.y;
  tmpvar_32.yz = texelsWeightsB_21.xz;
  highp vec3 tmpvar_33;
  tmpvar_33 = (tmpvar_31 + tmpvar_32);
  highp vec3 tmpvar_34;
  tmpvar_34.x = texelsWeightsA_12.y;
  tmpvar_34.yz = texelsWeightsB_13.xz;
  highp vec3 tmpvar_35;
  tmpvar_35.x = texelsWeightsA_20.y;
  tmpvar_35.yz = texelsWeightsB_21.xz;
  fetchesOffsetsU_7 = (((tmpvar_34 / tmpvar_30) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_6 = (((tmpvar_35 / tmpvar_33) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_36;
  tmpvar_36 = (tmpvar_10 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37.x = fetchesOffsetsU_7.x;
  tmpvar_37.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_38;
  tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
  tmpvar_38.z = shadowCoord_4.z;
  mediump float tmpvar_39;
  tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
  shadow_8 = ((tmpvar_30.x * tmpvar_33.x) * tmpvar_39);
  highp vec2 tmpvar_40;
  tmpvar_40.x = fetchesOffsetsU_7.y;
  tmpvar_40.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_41;
  tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
  tmpvar_41.z = shadowCoord_4.z;
  mediump float tmpvar_42;
  tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.x) * tmpvar_42));
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_7.z;
  tmpvar_43.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
  tmpvar_44.z = shadowCoord_4.z;
  mediump float tmpvar_45;
  tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.x) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_7.x;
  tmpvar_46.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
  tmpvar_47.z = shadowCoord_4.z;
  mediump float tmpvar_48;
  tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.y) * tmpvar_48));
  highp vec2 tmpvar_49;
  tmpvar_49.x = fetchesOffsetsU_7.y;
  tmpvar_49.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_50;
  tmpvar_50.xy = (tmpvar_36 + tmpvar_49);
  tmpvar_50.z = shadowCoord_4.z;
  mediump float tmpvar_51;
  tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.y) * tmpvar_51));
  highp vec2 tmpvar_52;
  tmpvar_52.x = fetchesOffsetsU_7.z;
  tmpvar_52.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_53;
  tmpvar_53.xy = (tmpvar_36 + tmpvar_52);
  tmpvar_53.z = shadowCoord_4.z;
  mediump float tmpvar_54;
  tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.y) * tmpvar_54));
  highp vec2 tmpvar_55;
  tmpvar_55.x = fetchesOffsetsU_7.x;
  tmpvar_55.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_56;
  tmpvar_56.xy = (tmpvar_36 + tmpvar_55);
  tmpvar_56.z = shadowCoord_4.z;
  mediump float tmpvar_57;
  tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.z) * tmpvar_57));
  highp vec2 tmpvar_58;
  tmpvar_58.x = fetchesOffsetsU_7.y;
  tmpvar_58.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_59;
  tmpvar_59.xy = (tmpvar_36 + tmpvar_58);
  tmpvar_59.z = shadowCoord_4.z;
  mediump float tmpvar_60;
  tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.z) * tmpvar_60));
  highp vec2 tmpvar_61;
  tmpvar_61.x = fetchesOffsetsU_7.z;
  tmpvar_61.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_62;
  tmpvar_62.xy = (tmpvar_36 + tmpvar_61);
  tmpvar_62.z = shadowCoord_4.z;
  mediump float tmpvar_63;
  tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.z) * tmpvar_63));
  highp vec3 tmpvar_64;
  highp vec3 lightDir_65;
  highp vec3 tmpvar_66;
  tmpvar_66 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_67;
  tmpvar_67 = clamp ((sqrt(
    dot (tmpvar_66, tmpvar_66)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_65 = normalize(tmpvar_66);
  tmpvar_64 = normalize(xlv_TEXCOORD3);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_64, lightDir_65), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_65 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_64), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    ((1.0 - tmpvar_67) / ((LIGHT_ATTENUATION.x + (tmpvar_67 * LIGHT_ATTENUATION.y)) + ((tmpvar_67 * tmpvar_67) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_65, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_8, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  tmpvar_2.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec4 shadowCoord_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_4.w = tmpvar_5.w;
  shadowCoord_4.xyz = (tmpvar_5.xyz / tmpvar_5.w);
  shadowCoord_4.xyz = ((shadowCoord_4.xyz * 0.5) + 0.5);
  shadowCoord_4.y = (1.0 - shadowCoord_4.y);
  highp vec4 fetchesOffsetsV_6;
  highp vec4 fetchesOffsetsU_7;
  highp float shadow_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = (shadowCoord_4.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_10;
  tmpvar_10 = floor((tmpvar_9 + 0.5));
  highp vec2 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 texelsWeightsA_12;
  highp vec4 texelsWeightsB_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_11.x + 0.5) * (tmpvar_11.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_11.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_11.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_11.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_11.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_11.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  texelsWeightsA_12.x = (0.081632 * tmpvar_17);
  texelsWeightsA_12.y = (0.081632 * computedAreaUncut_15.y);
  texelsWeightsA_12.z = (0.081632 * (computedAreaUncut_15.y + 1.0));
  texelsWeightsA_12.w = (0.081632 * (computedArea_14.y + 2.0));
  texelsWeightsB_13.x = (0.081632 * (computedArea_14.z + 2.0));
  texelsWeightsB_13.y = (0.081632 * (computedAreaUncut_15.z + 1.0));
  texelsWeightsB_13.z = (0.081632 * computedAreaUncut_15.z);
  texelsWeightsB_13.w = (0.081632 * tmpvar_16);
  highp vec4 texelsWeightsA_20;
  highp vec4 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_11.y + 0.5) * (tmpvar_11.y + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_11.y);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_11.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_11.y, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_11.y) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_11.y, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.081632 * tmpvar_25);
  texelsWeightsA_20.y = (0.081632 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.081632 * (computedAreaUncut_23.y + 1.0));
  texelsWeightsA_20.w = (0.081632 * (computedArea_22.y + 2.0));
  texelsWeightsB_21.x = (0.081632 * (computedArea_22.z + 2.0));
  texelsWeightsB_21.y = (0.081632 * (computedAreaUncut_23.z + 1.0));
  texelsWeightsB_21.z = (0.081632 * computedAreaUncut_23.z);
  texelsWeightsB_21.w = (0.081632 * tmpvar_24);
  highp vec4 tmpvar_28;
  tmpvar_28.xy = texelsWeightsA_12.xz;
  tmpvar_28.zw = texelsWeightsB_13.xz;
  highp vec4 tmpvar_29;
  tmpvar_29.xy = texelsWeightsA_12.yw;
  tmpvar_29.zw = texelsWeightsB_13.yw;
  highp vec4 tmpvar_30;
  tmpvar_30 = (tmpvar_28 + tmpvar_29);
  highp vec4 tmpvar_31;
  tmpvar_31.xy = texelsWeightsA_20.xz;
  tmpvar_31.zw = texelsWeightsB_21.xz;
  highp vec4 tmpvar_32;
  tmpvar_32.xy = texelsWeightsA_20.yw;
  tmpvar_32.zw = texelsWeightsB_21.yw;
  highp vec4 tmpvar_33;
  tmpvar_33 = (tmpvar_31 + tmpvar_32);
  highp vec4 tmpvar_34;
  tmpvar_34.xy = texelsWeightsA_12.yw;
  tmpvar_34.zw = texelsWeightsB_13.yw;
  highp vec4 tmpvar_35;
  tmpvar_35.xy = texelsWeightsA_20.yw;
  tmpvar_35.zw = texelsWeightsB_21.yw;
  fetchesOffsetsU_7 = (((tmpvar_34 / tmpvar_30) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_6 = (((tmpvar_35 / tmpvar_33) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_36;
  tmpvar_36 = (tmpvar_10 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37.x = fetchesOffsetsU_7.x;
  tmpvar_37.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_38;
  tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
  tmpvar_38.z = shadowCoord_4.z;
  mediump float tmpvar_39;
  tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
  shadow_8 = ((tmpvar_30.x * tmpvar_33.x) * tmpvar_39);
  highp vec2 tmpvar_40;
  tmpvar_40.x = fetchesOffsetsU_7.y;
  tmpvar_40.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_41;
  tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
  tmpvar_41.z = shadowCoord_4.z;
  mediump float tmpvar_42;
  tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.x) * tmpvar_42));
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_7.z;
  tmpvar_43.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
  tmpvar_44.z = shadowCoord_4.z;
  mediump float tmpvar_45;
  tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.x) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_7.w;
  tmpvar_46.y = fetchesOffsetsV_6.x;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
  tmpvar_47.z = shadowCoord_4.z;
  mediump float tmpvar_48;
  tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_8 = (shadow_8 + ((tmpvar_30.w * tmpvar_33.x) * tmpvar_48));
  highp vec2 tmpvar_49;
  tmpvar_49.x = fetchesOffsetsU_7.x;
  tmpvar_49.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_50;
  tmpvar_50.xy = (tmpvar_36 + tmpvar_49);
  tmpvar_50.z = shadowCoord_4.z;
  mediump float tmpvar_51;
  tmpvar_51 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_50);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.y) * tmpvar_51));
  highp vec2 tmpvar_52;
  tmpvar_52.x = fetchesOffsetsU_7.y;
  tmpvar_52.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_53;
  tmpvar_53.xy = (tmpvar_36 + tmpvar_52);
  tmpvar_53.z = shadowCoord_4.z;
  mediump float tmpvar_54;
  tmpvar_54 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_53);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.y) * tmpvar_54));
  highp vec2 tmpvar_55;
  tmpvar_55.x = fetchesOffsetsU_7.z;
  tmpvar_55.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_56;
  tmpvar_56.xy = (tmpvar_36 + tmpvar_55);
  tmpvar_56.z = shadowCoord_4.z;
  mediump float tmpvar_57;
  tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.y) * tmpvar_57));
  highp vec2 tmpvar_58;
  tmpvar_58.x = fetchesOffsetsU_7.w;
  tmpvar_58.y = fetchesOffsetsV_6.y;
  highp vec3 tmpvar_59;
  tmpvar_59.xy = (tmpvar_36 + tmpvar_58);
  tmpvar_59.z = shadowCoord_4.z;
  mediump float tmpvar_60;
  tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
  shadow_8 = (shadow_8 + ((tmpvar_30.w * tmpvar_33.y) * tmpvar_60));
  highp vec2 tmpvar_61;
  tmpvar_61.x = fetchesOffsetsU_7.x;
  tmpvar_61.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_62;
  tmpvar_62.xy = (tmpvar_36 + tmpvar_61);
  tmpvar_62.z = shadowCoord_4.z;
  mediump float tmpvar_63;
  tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.z) * tmpvar_63));
  highp vec2 tmpvar_64;
  tmpvar_64.x = fetchesOffsetsU_7.y;
  tmpvar_64.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_65;
  tmpvar_65.xy = (tmpvar_36 + tmpvar_64);
  tmpvar_65.z = shadowCoord_4.z;
  mediump float tmpvar_66;
  tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.z) * tmpvar_66));
  highp vec2 tmpvar_67;
  tmpvar_67.x = fetchesOffsetsU_7.z;
  tmpvar_67.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_68;
  tmpvar_68.xy = (tmpvar_36 + tmpvar_67);
  tmpvar_68.z = shadowCoord_4.z;
  mediump float tmpvar_69;
  tmpvar_69 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_68);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.z) * tmpvar_69));
  highp vec2 tmpvar_70;
  tmpvar_70.x = fetchesOffsetsU_7.w;
  tmpvar_70.y = fetchesOffsetsV_6.z;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = (tmpvar_36 + tmpvar_70);
  tmpvar_71.z = shadowCoord_4.z;
  mediump float tmpvar_72;
  tmpvar_72 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_71);
  shadow_8 = (shadow_8 + ((tmpvar_30.w * tmpvar_33.z) * tmpvar_72));
  highp vec2 tmpvar_73;
  tmpvar_73.x = fetchesOffsetsU_7.x;
  tmpvar_73.y = fetchesOffsetsV_6.w;
  highp vec3 tmpvar_74;
  tmpvar_74.xy = (tmpvar_36 + tmpvar_73);
  tmpvar_74.z = shadowCoord_4.z;
  mediump float tmpvar_75;
  tmpvar_75 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_74);
  shadow_8 = (shadow_8 + ((tmpvar_30.x * tmpvar_33.w) * tmpvar_75));
  highp vec2 tmpvar_76;
  tmpvar_76.x = fetchesOffsetsU_7.y;
  tmpvar_76.y = fetchesOffsetsV_6.w;
  highp vec3 tmpvar_77;
  tmpvar_77.xy = (tmpvar_36 + tmpvar_76);
  tmpvar_77.z = shadowCoord_4.z;
  mediump float tmpvar_78;
  tmpvar_78 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_77);
  shadow_8 = (shadow_8 + ((tmpvar_30.y * tmpvar_33.w) * tmpvar_78));
  highp vec2 tmpvar_79;
  tmpvar_79.x = fetchesOffsetsU_7.z;
  tmpvar_79.y = fetchesOffsetsV_6.w;
  highp vec3 tmpvar_80;
  tmpvar_80.xy = (tmpvar_36 + tmpvar_79);
  tmpvar_80.z = shadowCoord_4.z;
  mediump float tmpvar_81;
  tmpvar_81 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_80);
  shadow_8 = (shadow_8 + ((tmpvar_30.z * tmpvar_33.w) * tmpvar_81));
  highp vec2 tmpvar_82;
  tmpvar_82.x = fetchesOffsetsU_7.w;
  tmpvar_82.y = fetchesOffsetsV_6.w;
  highp vec3 tmpvar_83;
  tmpvar_83.xy = (tmpvar_36 + tmpvar_82);
  tmpvar_83.z = shadowCoord_4.z;
  mediump float tmpvar_84;
  tmpvar_84 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_83);
  shadow_8 = (shadow_8 + ((tmpvar_30.w * tmpvar_33.w) * tmpvar_84));
  highp vec3 tmpvar_85;
  highp vec3 lightDir_86;
  highp vec3 tmpvar_87;
  tmpvar_87 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_88;
  tmpvar_88 = clamp ((sqrt(
    dot (tmpvar_87, tmpvar_87)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_86 = normalize(tmpvar_87);
  tmpvar_85 = normalize(xlv_TEXCOORD3);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_85, lightDir_86), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_86 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_85), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    ((1.0 - tmpvar_88) / ((LIGHT_ATTENUATION.x + (tmpvar_88 * LIGHT_ATTENUATION.y)) + ((tmpvar_88 * tmpvar_88) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_86, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_8, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_6;
  tmpvar_6[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_6[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_6[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  tmpvar_2.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_5).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_6 * _glesNormal));
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec4 shadowCoord_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_5.w = tmpvar_6.w;
  shadowCoord_5.xyz = (tmpvar_6.xyz / tmpvar_6.w);
  shadowCoord_5.xyz = ((shadowCoord_5.xyz * 0.5) + 0.5);
  shadowCoord_5.y = (1.0 - shadowCoord_5.y);
  highp vec2 fetchesOffsetsV_7;
  highp vec2 fetchesOffsetsU_8;
  highp float shadow_9;
  shadow_9 = 1.0;
  highp vec2 tmpvar_10;
  tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_11;
  tmpvar_11 = floor((tmpvar_10 + 0.5));
  highp vec2 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 computedWeight_13;
  highp vec4 computedArea_14;
  highp vec4 computedAreaUncut_15;
  highp float tmpvar_16;
  tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
  highp float tmpvar_17;
  tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
  computedArea_14.x = tmpvar_17;
  computedAreaUncut_15.x = tmpvar_17;
  computedArea_14.w = tmpvar_16;
  computedAreaUncut_15.w = tmpvar_16;
  computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
  highp float tmpvar_18;
  tmpvar_18 = min (tmpvar_12.x, 0.0);
  computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
  computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
  highp float tmpvar_19;
  tmpvar_19 = max (tmpvar_12.x, 0.0);
  computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
  computedWeight_13 = (computedArea_14 * 0.44444);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_12.y, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_12.y, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec2 tmpvar_27;
  tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
  highp vec2 tmpvar_28;
  tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
  fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_29;
  tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_30;
  tmpvar_30.x = fetchesOffsetsU_8.x;
  tmpvar_30.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_31;
  tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
  tmpvar_31.z = shadowCoord_5.z;
  highp vec4 tmpvar_32;
  tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
  highp float tmpvar_33;
  if ((tmpvar_32.x < shadowCoord_5.z)) {
    tmpvar_33 = 0.0;
  } else {
    tmpvar_33 = 1.0;
  };
  shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_33);
  highp vec2 tmpvar_34;
  tmpvar_34.x = fetchesOffsetsU_8.y;
  tmpvar_34.y = fetchesOffsetsV_7.x;
  highp vec3 tmpvar_35;
  tmpvar_35.xy = (tmpvar_29 + tmpvar_34);
  tmpvar_35.z = shadowCoord_5.z;
  highp vec4 tmpvar_36;
  tmpvar_36 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
  highp float tmpvar_37;
  if ((tmpvar_36.x < shadowCoord_5.z)) {
    tmpvar_37 = 0.0;
  } else {
    tmpvar_37 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_37));
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_8.x;
  tmpvar_38.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_29 + tmpvar_38);
  tmpvar_39.z = shadowCoord_5.z;
  highp vec4 tmpvar_40;
  tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
  highp float tmpvar_41;
  if ((tmpvar_40.x < shadowCoord_5.z)) {
    tmpvar_41 = 0.0;
  } else {
    tmpvar_41 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_41));
  highp vec2 tmpvar_42;
  tmpvar_42.x = fetchesOffsetsU_8.y;
  tmpvar_42.y = fetchesOffsetsV_7.y;
  highp vec3 tmpvar_43;
  tmpvar_43.xy = (tmpvar_29 + tmpvar_42);
  tmpvar_43.z = shadowCoord_5.z;
  highp vec4 tmpvar_44;
  tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
  highp float tmpvar_45;
  if ((tmpvar_44.x < shadowCoord_5.z)) {
    tmpvar_45 = 0.0;
  } else {
    tmpvar_45 = 1.0;
  };
  shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_45));
  highp vec3 lightDir_46;
  highp vec3 tmpvar_47;
  tmpvar_47 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_48;
  tmpvar_48 = clamp ((sqrt(
    dot (tmpvar_47, tmpvar_47)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_46 = normalize(tmpvar_47);
  outColor_1.xyz = (((
    (clamp (dot (tmpvar_4, lightDir_46), 0.0, 1.0) * LIGHT_COLOR)
   * col_2.xyz) + (
    (pow (clamp (dot (
      normalize((lightDir_46 + normalize((CAMERA_WORLDPOSITION - xlv_TEXCOORD2))))
    , tmpvar_4), 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular))
   * LIGHT_COLOR)) * ((
    ((1.0 - tmpvar_48) / ((LIGHT_ATTENUATION.x + (tmpvar_48 * LIGHT_ATTENUATION.y)) + ((tmpvar_48 * tmpvar_48) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_46, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_9, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_5;
  tmpvar_5[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_5[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_5[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_5 * _glesNormal));
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_7;
  tmpvar_7 = clamp ((sqrt(
    dot (tmpvar_6, tmpvar_6)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_5 = normalize(xlv_TEXCOORD3);
  tmpvar_4 = normalize(tmpvar_6);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_5, tmpvar_4), 0.0, 1.0) * LIGHT_COLOR) * col_2.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_4 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_5)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * (
    (1.0 - tmpvar_7)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_7 * LIGHT_ATTENUATION.y)) + ((tmpvar_7 * tmpvar_7) * LIGHT_ATTENUATION.z))
  )) + (AMBIENT_COLOR * col_2.xyz));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Gloss",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Specular",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_5;
  tmpvar_5[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_5[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_5[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = normalize((tmpvar_5 * _glesNormal));
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform highp float _Gloss;
uniform highp float _Specular;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp vec3 tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (LIGHT_POSITION - xlv_TEXCOORD2);
  highp float tmpvar_7;
  tmpvar_7 = clamp ((sqrt(
    dot (tmpvar_6, tmpvar_6)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_5 = normalize(xlv_TEXCOORD3);
  tmpvar_4 = normalize(tmpvar_6);
  outColor_1.xyz = (((
    ((clamp (dot (tmpvar_5, tmpvar_4), 0.0, 1.0) * LIGHT_COLOR) * col_2.xyz)
   + 
    ((pow (clamp (
      dot (normalize((tmpvar_4 + normalize(
        (CAMERA_WORLDPOSITION - xlv_TEXCOORD2)
      ))), tmpvar_5)
    , 0.0, 1.0), (_Gloss * 128.0)) * vec3(_Specular)) * LIGHT_COLOR)
  ) * (
    (1.0 - tmpvar_7)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_7 * LIGHT_ATTENUATION.y)) + ((tmpvar_7 * tmpvar_7) * LIGHT_ATTENUATION.z))
  )) + (AMBIENT_COLOR * col_2.xyz));
  outColor_1.w = 1.0;
  _glesFragData[0] = outColor_1;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)));
  highp vec4 clipPos_10;
  clipPos_10.xyw = tmpvar_9.xyw;
  clipPos_10.z = (tmpvar_9.z + (LIGHT_PARAM.x / tmpvar_9.w));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_11 * clipPos_10);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end
