

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
_TexOffset = { "uv offset", VEC2, "0.0, 0.0"},
_TexTilling = { "uv tilling", VEC2, "1.0, 1.0"},
_Alpha = {"alpha", FLOATRANGE, "1.0, 1, 0"},
[Keywords(BLEND_NORMAL, BLEND_MULTIPLY, BLEND_SCREEN, BLEND_HUE, BLEND_SATURATION, BLEND_LUMINOSITY, BLEND_COLOR, BLEND_BLEND, BLEND_EXCLUSION, BLEND_HARDLIGHT, BLEND_VIVIDLIGHT, BLEND_OVERLAY, BLEND_COLORBURN, BLEND_COLORDODGE, BLEND_SOFTLIGHT, BLEND_HARDMIX, BLEND_PINLIGHT, BLEND_LINEARLIGHT, BLEND_DIFF, BLEND_LINEARBURN, BLEND_SUB, BLEND_LUT, BLEND_ADD)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_Opacity = { "Opacity", FLOATRANGE, "1.0, 1, 0" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
_DefMode = { "Def Mode", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "sdfbackground"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND,  "%_BlendSrc",  "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fbfetch
#pragma multi_compile BLEND_NORMAL BLEND_MULTIPLY BLEND_SCREEN BLEND_HUE BLEND_SATURATION BLEND_LUMINOSITY BLEND_COLOR BLEND_BLEND BLEND_EXCLUSION BLEND_HARDLIGHT BLEND_VIVIDLIGHT BLEND_OVERLAY BLEND_COLORBURN BLEND_COLORDODGE BLEND_SOFTLIGHT BLEND_HARDMIX BLEND_PINLIGHT BLEND_LINEARLIGHT BLEND_DIFF BLEND_LINEARBURN BLEND_SUB BLEND_LUT BLEND_ADD
#include "common.inc"
#include "blendfunc_plenty.inc"
#include "light.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
    float4 screenPos : TEXCOORD4;
};

sampler2D TEXTURE_DIFFUSE;
float2 _TexOffset;
float2 _TexTilling;
float _Alpha;
float _Opacity;
sampler2D _LutMap;
float _DefMode;

v2f vert(appdata v)
{
    v2f o;
    float4 pos =ObjectToClipPos(float3(v.vertex * 0.01,0.0));
    o.screenPos = ComputeScreenPos(pos);
    o.vertex = UniformNDC(pos);
    o.uv = TRANSFORM_TEX(v.uv.xy * 0.01, _TexOffset, _TexTilling);
    return o;
}

float4 GetSourceColor(v2f i, float4 fbColor)
{
#ifdef FRAMEBUFFER_FETCH
    return fbColor;
#else
    float2 uvCoord = i.screenPos.xy / i.screenPos.w;
    float4 srcColor = tex2D(TEXTURE_GRAP, uvCoord);
    return srcColor;
#endif
}

#ifdef FRAMEBUFFER_FETCH
void frag(v2f i, inout float4 fbColor:COLOR0)
#else
fixed4 frag(v2f i) : SV_Target
#endif
{
    float4 blendColor = tex2D(TEXTURE_DIFFUSE,i.uv);
    float4 resultColor = float4(1.0, 1.0, 1.0, 1.0);
    float  factor = _Opacity * blendColor.a;

    #ifdef FRAMEBUFFER_FETCH
    float4 fbc = fbColor;
    #else
    float4 fbc = resultColor;
    #endif

    #ifdef BLEND_NORMAL
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
    #elif BLEND_MULTIPLY
    float4 whiteColor = float4(1.0, 1.0, 1.0, 1.0);
    blendColor = whiteColor - factor * (whiteColor - blendColor);
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
    #elif BLEND_SCREEN
    blendColor = factor * blendColor;
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
    #elif BLEND_HUE
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(blendHSL.r, baseHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
    #elif BLEND_SATURATION
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(baseHSL.r, blendHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
    #elif BLEND_LUMINOSITY
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(baseHSL.r, baseHSL.g, blendHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
    #elif BLEND_COLOR
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(blendHSL.r, blendHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
    #elif BLEND_BLEND
    float4 srcColor = GetSourceColor(i, fbc);
    float imgIntensity = dot(float3(0.2990,0.5870,0.1140), srcColor.rgb);
    float3 resIntColor = (imgIntensity * 1.68) * blendColor.rgb;
    resultColor.rgb = resIntColor;
    resultColor.a = factor;
    #elif BLEND_EXCLUSION
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendExclusion(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_HARDLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendHardLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_VIVIDLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendVividLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_OVERLAY
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendOverlay(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_COLORBURN
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendColorBurn(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_COLORDODGE
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendColorDodge(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_SOFTLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendSoftLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_HARDMIX
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendHardMix(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_PINLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendPinLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_LINEARLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendLinearLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_DIFF
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendDiff(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_LINEARBURN
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendLinearBurn(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_SUB
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendSub(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_LUT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.r = tex2D(_LutMap, float2(blendColor.r, srcColor.r)).r;
    resultColor.g = tex2D(_LutMap, float2(blendColor.g, srcColor.g)).g;
    resultColor.b = tex2D(_LutMap, float2(blendColor.b, srcColor.b)).b;
    resultColor.a = factor;
    #elif BLEND_ADD
    blendColor = blendColor * factor;
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
    #endif
    resultColor.a = resultColor.a * _Alpha;
    #ifndef FRAMEBUFFER_FETCH
    return resultColor;
    #else
    fbColor = resultColor;
    #endif
}
ENDCG
#END
