function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
ENABLE_TEXTURE = { "enable texture", FLOAT, "0.0"},
SIM_SPACE = {"sim space", FLOAT, "0.0"},
TEXTUREMODE = {"texture mode", FLOAT, "2.0"},
WORLD_SCALE = {"world scale", FLOAT, "1.0"},
_Opacity = { "Opacity", FLOATRANGE, "1.0, 1, 0" },

_BlendMode = {"Blend Mode", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_DefMode = { "Def Mode", FLOAT, "0.0"},
_LutMap = {"Lut Map", TEXTURE2D, "white" },

	}
	Attributes = 
	{
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_MULTIPLY,BLEND_SCREEN,BLEND_HUE,BLEND_SATURATION,BLEND_LUMINOSITY,BLEND_COLOR,BLEND_BLEND,BLEND_EXCLUSION,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_OVERLAY,BLEND_COLORBURN,BLEND_COLORDODGE,BLEND_SOFTLIGHT,BLEND_HARDMIX,BLEND_PINLIGHT,BLEND_LINEARLIGHT,BLEND_DIFF,BLEND_LINEARBURN,BLEND_SUB,BLEND_LUT,BLEND_ADD)", 
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "particle_trail"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst" , ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 in_SurfaceColor_1;
  highp float tmpvar_2;
  tmpvar_2 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_3;
  tmpvar_3 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_4;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_4 = tmpvar_3.x;
  } else {
    tmpvar_4 = -(tmpvar_3.x);
  };
  highp float tmpvar_5;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_5 = tmpvar_3.y;
  } else {
    tmpvar_5 = -(tmpvar_3.y);
  };
  highp vec2 tmpvar_6;
  tmpvar_6.x = tmpvar_4;
  tmpvar_6.y = tmpvar_5;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, tmpvar_6);
  in_SurfaceColor_1 = tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8 = (xlv_TEXCOORD3 * ((in_SurfaceColor_1 * tmpvar_2) + (1.0 - tmpvar_2)));
  highp vec4 tmpvar_9;
  tmpvar_9.xyz = tmpvar_8.xyz;
  tmpvar_9.w = (_Opacity * tmpvar_8.w);
  gl_FragData[0] = tmpvar_9;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 in_SurfaceColor_2;
  highp float tmpvar_3;
  tmpvar_3 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_4;
  tmpvar_4 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_5;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_5 = tmpvar_4.x;
  } else {
    tmpvar_5 = -(tmpvar_4.x);
  };
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_6 = tmpvar_4.y;
  } else {
    tmpvar_6 = -(tmpvar_4.y);
  };
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_5;
  tmpvar_7.y = tmpvar_6;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_DIFFUSE, tmpvar_7);
  in_SurfaceColor_2 = tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (xlv_TEXCOORD3 * ((in_SurfaceColor_2 * tmpvar_3) + (1.0 - tmpvar_3)));
  highp vec4 tmpvar_10;
  tmpvar_10.xyz = tmpvar_9.xyz;
  tmpvar_10.w = (_Opacity * tmpvar_9.w);
  tmpvar_1 = tmpvar_10;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 in_SurfaceColor_1;
  highp float tmpvar_2;
  tmpvar_2 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_3;
  tmpvar_3 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_4;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_4 = tmpvar_3.x;
  } else {
    tmpvar_4 = -(tmpvar_3.x);
  };
  highp float tmpvar_5;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_5 = tmpvar_3.y;
  } else {
    tmpvar_5 = -(tmpvar_3.y);
  };
  highp vec2 tmpvar_6;
  tmpvar_6.x = tmpvar_4;
  tmpvar_6.y = tmpvar_5;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, tmpvar_6);
  in_SurfaceColor_1 = tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8 = (xlv_TEXCOORD3 * ((in_SurfaceColor_1 * tmpvar_2) + (1.0 - tmpvar_2)));
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_8.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_8))).xyz;
  gl_FragData[0] = tmpvar_9;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 in_SurfaceColor_2;
  highp float tmpvar_3;
  tmpvar_3 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_4;
  tmpvar_4 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_5;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_5 = tmpvar_4.x;
  } else {
    tmpvar_5 = -(tmpvar_4.x);
  };
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_6 = tmpvar_4.y;
  } else {
    tmpvar_6 = -(tmpvar_4.y);
  };
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_5;
  tmpvar_7.y = tmpvar_6;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_DIFFUSE, tmpvar_7);
  in_SurfaceColor_2 = tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (xlv_TEXCOORD3 * ((in_SurfaceColor_2 * tmpvar_3) + (1.0 - tmpvar_3)));
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_9.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_9))).xyz;
  tmpvar_1 = tmpvar_10;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 in_SurfaceColor_1;
  highp float tmpvar_2;
  tmpvar_2 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_3;
  tmpvar_3 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_4;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_4 = tmpvar_3.x;
  } else {
    tmpvar_4 = -(tmpvar_3.x);
  };
  highp float tmpvar_5;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_5 = tmpvar_3.y;
  } else {
    tmpvar_5 = -(tmpvar_3.y);
  };
  highp vec2 tmpvar_6;
  tmpvar_6.x = tmpvar_4;
  tmpvar_6.y = tmpvar_5;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, tmpvar_6);
  in_SurfaceColor_1 = tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8 = (xlv_TEXCOORD3 * ((in_SurfaceColor_1 * tmpvar_2) + (1.0 - tmpvar_2)));
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = ((_Opacity * tmpvar_8.w) * tmpvar_8).xyz;
  gl_FragData[0] = tmpvar_9;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 in_SurfaceColor_2;
  highp float tmpvar_3;
  tmpvar_3 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_4;
  tmpvar_4 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_5;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_5 = tmpvar_4.x;
  } else {
    tmpvar_5 = -(tmpvar_4.x);
  };
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_6 = tmpvar_4.y;
  } else {
    tmpvar_6 = -(tmpvar_4.y);
  };
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_5;
  tmpvar_7.y = tmpvar_6;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_DIFFUSE, tmpvar_7);
  in_SurfaceColor_2 = tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (xlv_TEXCOORD3 * ((in_SurfaceColor_2 * tmpvar_3) + (1.0 - tmpvar_3)));
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = ((_Opacity * tmpvar_9.w) * tmpvar_9).xyz;
  tmpvar_1 = tmpvar_10;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_12;
  tmpvar_12 = (_Opacity * tmpvar_11.w);
  highp vec3 rgb_13;
  rgb_13 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_14;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_15;
    tmpvar_15.zw = vec2(-1.0, 0.6666667);
    tmpvar_15.xy = rgb_13.zy;
    tmpvar_14 = tmpvar_15;
  } else {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(0.0, -0.3333333);
    tmpvar_16.xy = rgb_13.yz;
    tmpvar_14 = tmpvar_16;
  };
  highp vec4 tmpvar_17;
  if ((xlt_fbColor_1.x < tmpvar_14.x)) {
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = tmpvar_14.xyw;
    tmpvar_18.w = rgb_13.x;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.x = rgb_13.x;
    tmpvar_19.yzw = tmpvar_14.yzx;
    tmpvar_17 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_17.x - min (tmpvar_17.w, tmpvar_17.y));
  highp vec3 tmpvar_21;
  tmpvar_21.x = abs(((
    (tmpvar_17.w - tmpvar_17.y)
   / 
    ((6.0 * tmpvar_20) + 1e-7)
  ) + tmpvar_17.z));
  tmpvar_21.y = tmpvar_20;
  tmpvar_21.z = tmpvar_17.x;
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_17.x - (tmpvar_20 * 0.5));
  highp vec3 tmpvar_23;
  tmpvar_23.x = tmpvar_21.x;
  tmpvar_23.y = (tmpvar_20 / ((1.0 - 
    abs(((2.0 * tmpvar_22) - 1.0))
  ) + 1e-7));
  tmpvar_23.z = tmpvar_22;
  highp vec3 rgb_24;
  rgb_24 = tmpvar_11.xyz;
  highp vec4 tmpvar_25;
  if ((tmpvar_11.y < tmpvar_11.z)) {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(-1.0, 0.6666667);
    tmpvar_26.xy = rgb_24.zy;
    tmpvar_25 = tmpvar_26;
  } else {
    highp vec4 tmpvar_27;
    tmpvar_27.zw = vec2(0.0, -0.3333333);
    tmpvar_27.xy = rgb_24.yz;
    tmpvar_25 = tmpvar_27;
  };
  highp vec4 tmpvar_28;
  if ((tmpvar_11.x < tmpvar_25.x)) {
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = tmpvar_25.xyw;
    tmpvar_29.w = rgb_24.x;
    tmpvar_28 = tmpvar_29;
  } else {
    highp vec4 tmpvar_30;
    tmpvar_30.x = rgb_24.x;
    tmpvar_30.yzw = tmpvar_25.yzx;
    tmpvar_28 = tmpvar_30;
  };
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_28.x - min (tmpvar_28.w, tmpvar_28.y));
  highp vec3 tmpvar_32;
  tmpvar_32.x = abs(((
    (tmpvar_28.w - tmpvar_28.y)
   / 
    ((6.0 * tmpvar_31) + 1e-7)
  ) + tmpvar_28.z));
  tmpvar_32.y = tmpvar_31;
  tmpvar_32.z = tmpvar_28.x;
  highp vec3 tmpvar_33;
  tmpvar_33.x = (abs((
    (6.0 * tmpvar_32.x)
   - 3.0)) - 1.0);
  tmpvar_33.y = (2.0 - abs((
    (6.0 * tmpvar_32.x)
   - 2.0)));
  tmpvar_33.z = (2.0 - abs((
    (6.0 * tmpvar_32.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_33, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_22) - 1.0)))
   * tmpvar_23.y)) + tmpvar_22);
  resultColor_3.w = tmpvar_12;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = (_Opacity * tmpvar_10.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec3 rgb_15;
  rgb_15 = srcColor_12.xyz;
  highp vec4 tmpvar_16;
  if ((srcColor_12.y < srcColor_12.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((srcColor_12.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - min (tmpvar_19.w, tmpvar_19.y));
  highp vec3 tmpvar_23;
  tmpvar_23.x = abs(((
    (tmpvar_19.w - tmpvar_19.y)
   / 
    ((6.0 * tmpvar_22) + 1e-7)
  ) + tmpvar_19.z));
  tmpvar_23.y = tmpvar_22;
  tmpvar_23.z = tmpvar_19.x;
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_19.x - (tmpvar_22 * 0.5));
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_23.x;
  tmpvar_25.y = (tmpvar_22 / ((1.0 - 
    abs(((2.0 * tmpvar_24) - 1.0))
  ) + 1e-7));
  tmpvar_25.z = tmpvar_24;
  highp vec3 rgb_26;
  rgb_26 = tmpvar_10.xyz;
  highp vec4 tmpvar_27;
  if ((tmpvar_10.y < tmpvar_10.z)) {
    highp vec4 tmpvar_28;
    tmpvar_28.zw = vec2(-1.0, 0.6666667);
    tmpvar_28.xy = rgb_26.zy;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.zw = vec2(0.0, -0.3333333);
    tmpvar_29.xy = rgb_26.yz;
    tmpvar_27 = tmpvar_29;
  };
  highp vec4 tmpvar_30;
  if ((tmpvar_10.x < tmpvar_27.x)) {
    highp vec4 tmpvar_31;
    tmpvar_31.xyz = tmpvar_27.xyw;
    tmpvar_31.w = rgb_26.x;
    tmpvar_30 = tmpvar_31;
  } else {
    highp vec4 tmpvar_32;
    tmpvar_32.x = rgb_26.x;
    tmpvar_32.yzw = tmpvar_27.yzx;
    tmpvar_30 = tmpvar_32;
  };
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_30.x - min (tmpvar_30.w, tmpvar_30.y));
  highp vec3 tmpvar_34;
  tmpvar_34.x = abs(((
    (tmpvar_30.w - tmpvar_30.y)
   / 
    ((6.0 * tmpvar_33) + 1e-7)
  ) + tmpvar_30.z));
  tmpvar_34.y = tmpvar_33;
  tmpvar_34.z = tmpvar_30.x;
  highp vec3 tmpvar_35;
  tmpvar_35.x = (abs((
    (6.0 * tmpvar_34.x)
   - 3.0)) - 1.0);
  tmpvar_35.y = (2.0 - abs((
    (6.0 * tmpvar_34.x)
   - 2.0)));
  tmpvar_35.z = (2.0 - abs((
    (6.0 * tmpvar_34.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_35, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_24) - 1.0)))
   * tmpvar_25.y)) + tmpvar_24);
  resultColor_2.w = tmpvar_11;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_12;
  tmpvar_12 = (_Opacity * tmpvar_11.w);
  highp vec3 rgb_13;
  rgb_13 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_14;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_15;
    tmpvar_15.zw = vec2(-1.0, 0.6666667);
    tmpvar_15.xy = rgb_13.zy;
    tmpvar_14 = tmpvar_15;
  } else {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(0.0, -0.3333333);
    tmpvar_16.xy = rgb_13.yz;
    tmpvar_14 = tmpvar_16;
  };
  highp vec4 tmpvar_17;
  if ((xlt_fbColor_1.x < tmpvar_14.x)) {
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = tmpvar_14.xyw;
    tmpvar_18.w = rgb_13.x;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.x = rgb_13.x;
    tmpvar_19.yzw = tmpvar_14.yzx;
    tmpvar_17 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_17.x - min (tmpvar_17.w, tmpvar_17.y));
  highp vec3 tmpvar_21;
  tmpvar_21.x = abs(((
    (tmpvar_17.w - tmpvar_17.y)
   / 
    ((6.0 * tmpvar_20) + 1e-7)
  ) + tmpvar_17.z));
  tmpvar_21.y = tmpvar_20;
  tmpvar_21.z = tmpvar_17.x;
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_17.x - (tmpvar_20 * 0.5));
  highp vec3 rgb_23;
  rgb_23 = tmpvar_11.xyz;
  highp vec4 tmpvar_24;
  if ((tmpvar_11.y < tmpvar_11.z)) {
    highp vec4 tmpvar_25;
    tmpvar_25.zw = vec2(-1.0, 0.6666667);
    tmpvar_25.xy = rgb_23.zy;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(0.0, -0.3333333);
    tmpvar_26.xy = rgb_23.yz;
    tmpvar_24 = tmpvar_26;
  };
  highp vec4 tmpvar_27;
  if ((tmpvar_11.x < tmpvar_24.x)) {
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = tmpvar_24.xyw;
    tmpvar_28.w = rgb_23.x;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.x = rgb_23.x;
    tmpvar_29.yzw = tmpvar_24.yzx;
    tmpvar_27 = tmpvar_29;
  };
  highp float tmpvar_30;
  tmpvar_30 = (tmpvar_27.x - min (tmpvar_27.w, tmpvar_27.y));
  highp vec3 tmpvar_31;
  tmpvar_31.x = abs(((
    (tmpvar_27.w - tmpvar_27.y)
   / 
    ((6.0 * tmpvar_30) + 1e-7)
  ) + tmpvar_27.z));
  tmpvar_31.y = tmpvar_30;
  tmpvar_31.z = tmpvar_27.x;
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_27.x - (tmpvar_30 * 0.5));
  highp vec3 tmpvar_33;
  tmpvar_33.x = tmpvar_31.x;
  tmpvar_33.y = (tmpvar_30 / ((1.0 - 
    abs(((2.0 * tmpvar_32) - 1.0))
  ) + 1e-7));
  tmpvar_33.z = tmpvar_32;
  highp vec3 tmpvar_34;
  tmpvar_34.x = (abs((
    (6.0 * tmpvar_21.x)
   - 3.0)) - 1.0);
  tmpvar_34.y = (2.0 - abs((
    (6.0 * tmpvar_21.x)
   - 2.0)));
  tmpvar_34.z = (2.0 - abs((
    (6.0 * tmpvar_21.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_22) - 1.0)))
   * tmpvar_33.y)) + tmpvar_22);
  resultColor_3.w = tmpvar_12;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = (_Opacity * tmpvar_10.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec3 rgb_15;
  rgb_15 = srcColor_12.xyz;
  highp vec4 tmpvar_16;
  if ((srcColor_12.y < srcColor_12.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((srcColor_12.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - min (tmpvar_19.w, tmpvar_19.y));
  highp vec3 tmpvar_23;
  tmpvar_23.x = abs(((
    (tmpvar_19.w - tmpvar_19.y)
   / 
    ((6.0 * tmpvar_22) + 1e-7)
  ) + tmpvar_19.z));
  tmpvar_23.y = tmpvar_22;
  tmpvar_23.z = tmpvar_19.x;
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_19.x - (tmpvar_22 * 0.5));
  highp vec3 rgb_25;
  rgb_25 = tmpvar_10.xyz;
  highp vec4 tmpvar_26;
  if ((tmpvar_10.y < tmpvar_10.z)) {
    highp vec4 tmpvar_27;
    tmpvar_27.zw = vec2(-1.0, 0.6666667);
    tmpvar_27.xy = rgb_25.zy;
    tmpvar_26 = tmpvar_27;
  } else {
    highp vec4 tmpvar_28;
    tmpvar_28.zw = vec2(0.0, -0.3333333);
    tmpvar_28.xy = rgb_25.yz;
    tmpvar_26 = tmpvar_28;
  };
  highp vec4 tmpvar_29;
  if ((tmpvar_10.x < tmpvar_26.x)) {
    highp vec4 tmpvar_30;
    tmpvar_30.xyz = tmpvar_26.xyw;
    tmpvar_30.w = rgb_25.x;
    tmpvar_29 = tmpvar_30;
  } else {
    highp vec4 tmpvar_31;
    tmpvar_31.x = rgb_25.x;
    tmpvar_31.yzw = tmpvar_26.yzx;
    tmpvar_29 = tmpvar_31;
  };
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_29.x - min (tmpvar_29.w, tmpvar_29.y));
  highp vec3 tmpvar_33;
  tmpvar_33.x = abs(((
    (tmpvar_29.w - tmpvar_29.y)
   / 
    ((6.0 * tmpvar_32) + 1e-7)
  ) + tmpvar_29.z));
  tmpvar_33.y = tmpvar_32;
  tmpvar_33.z = tmpvar_29.x;
  highp float tmpvar_34;
  tmpvar_34 = (tmpvar_29.x - (tmpvar_32 * 0.5));
  highp vec3 tmpvar_35;
  tmpvar_35.x = tmpvar_33.x;
  tmpvar_35.y = (tmpvar_32 / ((1.0 - 
    abs(((2.0 * tmpvar_34) - 1.0))
  ) + 1e-7));
  tmpvar_35.z = tmpvar_34;
  highp vec3 tmpvar_36;
  tmpvar_36.x = (abs((
    (6.0 * tmpvar_23.x)
   - 3.0)) - 1.0);
  tmpvar_36.y = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 2.0)));
  tmpvar_36.z = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_36, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_24) - 1.0)))
   * tmpvar_35.y)) + tmpvar_24);
  resultColor_2.w = tmpvar_11;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_12;
  tmpvar_12 = (_Opacity * tmpvar_11.w);
  highp vec3 rgb_13;
  rgb_13 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_14;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_15;
    tmpvar_15.zw = vec2(-1.0, 0.6666667);
    tmpvar_15.xy = rgb_13.zy;
    tmpvar_14 = tmpvar_15;
  } else {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(0.0, -0.3333333);
    tmpvar_16.xy = rgb_13.yz;
    tmpvar_14 = tmpvar_16;
  };
  highp vec4 tmpvar_17;
  if ((xlt_fbColor_1.x < tmpvar_14.x)) {
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = tmpvar_14.xyw;
    tmpvar_18.w = rgb_13.x;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.x = rgb_13.x;
    tmpvar_19.yzw = tmpvar_14.yzx;
    tmpvar_17 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_17.x - min (tmpvar_17.w, tmpvar_17.y));
  highp vec3 tmpvar_21;
  tmpvar_21.x = abs(((
    (tmpvar_17.w - tmpvar_17.y)
   / 
    ((6.0 * tmpvar_20) + 1e-7)
  ) + tmpvar_17.z));
  tmpvar_21.y = tmpvar_20;
  tmpvar_21.z = tmpvar_17.x;
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_17.x - (tmpvar_20 * 0.5));
  highp vec3 tmpvar_23;
  tmpvar_23.x = tmpvar_21.x;
  tmpvar_23.y = (tmpvar_20 / ((1.0 - 
    abs(((2.0 * tmpvar_22) - 1.0))
  ) + 1e-7));
  tmpvar_23.z = tmpvar_22;
  highp vec3 rgb_24;
  rgb_24 = tmpvar_11.xyz;
  highp vec4 tmpvar_25;
  if ((tmpvar_11.y < tmpvar_11.z)) {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(-1.0, 0.6666667);
    tmpvar_26.xy = rgb_24.zy;
    tmpvar_25 = tmpvar_26;
  } else {
    highp vec4 tmpvar_27;
    tmpvar_27.zw = vec2(0.0, -0.3333333);
    tmpvar_27.xy = rgb_24.yz;
    tmpvar_25 = tmpvar_27;
  };
  highp vec4 tmpvar_28;
  if ((tmpvar_11.x < tmpvar_25.x)) {
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = tmpvar_25.xyw;
    tmpvar_29.w = rgb_24.x;
    tmpvar_28 = tmpvar_29;
  } else {
    highp vec4 tmpvar_30;
    tmpvar_30.x = rgb_24.x;
    tmpvar_30.yzw = tmpvar_25.yzx;
    tmpvar_28 = tmpvar_30;
  };
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_28.x - ((tmpvar_28.x - 
    min (tmpvar_28.w, tmpvar_28.y)
  ) * 0.5));
  highp vec3 tmpvar_32;
  tmpvar_32.x = (abs((
    (6.0 * tmpvar_21.x)
   - 3.0)) - 1.0);
  tmpvar_32.y = (2.0 - abs((
    (6.0 * tmpvar_21.x)
   - 2.0)));
  tmpvar_32.z = (2.0 - abs((
    (6.0 * tmpvar_21.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_32, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_31) - 1.0)))
   * tmpvar_23.y)) + tmpvar_31);
  resultColor_3.w = tmpvar_12;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = (_Opacity * tmpvar_10.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec3 rgb_15;
  rgb_15 = srcColor_12.xyz;
  highp vec4 tmpvar_16;
  if ((srcColor_12.y < srcColor_12.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((srcColor_12.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - min (tmpvar_19.w, tmpvar_19.y));
  highp vec3 tmpvar_23;
  tmpvar_23.x = abs(((
    (tmpvar_19.w - tmpvar_19.y)
   / 
    ((6.0 * tmpvar_22) + 1e-7)
  ) + tmpvar_19.z));
  tmpvar_23.y = tmpvar_22;
  tmpvar_23.z = tmpvar_19.x;
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_19.x - (tmpvar_22 * 0.5));
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_23.x;
  tmpvar_25.y = (tmpvar_22 / ((1.0 - 
    abs(((2.0 * tmpvar_24) - 1.0))
  ) + 1e-7));
  tmpvar_25.z = tmpvar_24;
  highp vec3 rgb_26;
  rgb_26 = tmpvar_10.xyz;
  highp vec4 tmpvar_27;
  if ((tmpvar_10.y < tmpvar_10.z)) {
    highp vec4 tmpvar_28;
    tmpvar_28.zw = vec2(-1.0, 0.6666667);
    tmpvar_28.xy = rgb_26.zy;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.zw = vec2(0.0, -0.3333333);
    tmpvar_29.xy = rgb_26.yz;
    tmpvar_27 = tmpvar_29;
  };
  highp vec4 tmpvar_30;
  if ((tmpvar_10.x < tmpvar_27.x)) {
    highp vec4 tmpvar_31;
    tmpvar_31.xyz = tmpvar_27.xyw;
    tmpvar_31.w = rgb_26.x;
    tmpvar_30 = tmpvar_31;
  } else {
    highp vec4 tmpvar_32;
    tmpvar_32.x = rgb_26.x;
    tmpvar_32.yzw = tmpvar_27.yzx;
    tmpvar_30 = tmpvar_32;
  };
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_30.x - ((tmpvar_30.x - 
    min (tmpvar_30.w, tmpvar_30.y)
  ) * 0.5));
  highp vec3 tmpvar_34;
  tmpvar_34.x = (abs((
    (6.0 * tmpvar_23.x)
   - 3.0)) - 1.0);
  tmpvar_34.y = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 2.0)));
  tmpvar_34.z = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_33) - 1.0)))
   * tmpvar_25.y)) + tmpvar_33);
  resultColor_2.w = tmpvar_11;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_12;
  tmpvar_12 = (_Opacity * tmpvar_11.w);
  highp vec3 rgb_13;
  rgb_13 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_14;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_15;
    tmpvar_15.zw = vec2(-1.0, 0.6666667);
    tmpvar_15.xy = rgb_13.zy;
    tmpvar_14 = tmpvar_15;
  } else {
    highp vec4 tmpvar_16;
    tmpvar_16.zw = vec2(0.0, -0.3333333);
    tmpvar_16.xy = rgb_13.yz;
    tmpvar_14 = tmpvar_16;
  };
  highp vec4 tmpvar_17;
  if ((xlt_fbColor_1.x < tmpvar_14.x)) {
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = tmpvar_14.xyw;
    tmpvar_18.w = rgb_13.x;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.x = rgb_13.x;
    tmpvar_19.yzw = tmpvar_14.yzx;
    tmpvar_17 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_17.x - ((tmpvar_17.x - 
    min (tmpvar_17.w, tmpvar_17.y)
  ) * 0.5));
  highp vec3 rgb_21;
  rgb_21 = tmpvar_11.xyz;
  highp vec4 tmpvar_22;
  if ((tmpvar_11.y < tmpvar_11.z)) {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(-1.0, 0.6666667);
    tmpvar_23.xy = rgb_21.zy;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.zw = vec2(0.0, -0.3333333);
    tmpvar_24.xy = rgb_21.yz;
    tmpvar_22 = tmpvar_24;
  };
  highp vec4 tmpvar_25;
  if ((tmpvar_11.x < tmpvar_22.x)) {
    highp vec4 tmpvar_26;
    tmpvar_26.xyz = tmpvar_22.xyw;
    tmpvar_26.w = rgb_21.x;
    tmpvar_25 = tmpvar_26;
  } else {
    highp vec4 tmpvar_27;
    tmpvar_27.x = rgb_21.x;
    tmpvar_27.yzw = tmpvar_22.yzx;
    tmpvar_25 = tmpvar_27;
  };
  highp float tmpvar_28;
  tmpvar_28 = (tmpvar_25.x - min (tmpvar_25.w, tmpvar_25.y));
  highp vec3 tmpvar_29;
  tmpvar_29.x = abs(((
    (tmpvar_25.w - tmpvar_25.y)
   / 
    ((6.0 * tmpvar_28) + 1e-7)
  ) + tmpvar_25.z));
  tmpvar_29.y = tmpvar_28;
  tmpvar_29.z = tmpvar_25.x;
  highp float tmpvar_30;
  tmpvar_30 = (tmpvar_25.x - (tmpvar_28 * 0.5));
  highp vec3 tmpvar_31;
  tmpvar_31.x = tmpvar_29.x;
  tmpvar_31.y = (tmpvar_28 / ((1.0 - 
    abs(((2.0 * tmpvar_30) - 1.0))
  ) + 1e-7));
  tmpvar_31.z = tmpvar_30;
  highp vec3 tmpvar_32;
  tmpvar_32.x = (abs((
    (6.0 * tmpvar_29.x)
   - 3.0)) - 1.0);
  tmpvar_32.y = (2.0 - abs((
    (6.0 * tmpvar_29.x)
   - 2.0)));
  tmpvar_32.z = (2.0 - abs((
    (6.0 * tmpvar_29.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_32, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_20) - 1.0)))
   * tmpvar_31.y)) + tmpvar_20);
  resultColor_3.w = tmpvar_12;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = (_Opacity * tmpvar_10.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec3 rgb_15;
  rgb_15 = srcColor_12.xyz;
  highp vec4 tmpvar_16;
  if ((srcColor_12.y < srcColor_12.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((srcColor_12.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - ((tmpvar_19.x - 
    min (tmpvar_19.w, tmpvar_19.y)
  ) * 0.5));
  highp vec3 rgb_23;
  rgb_23 = tmpvar_10.xyz;
  highp vec4 tmpvar_24;
  if ((tmpvar_10.y < tmpvar_10.z)) {
    highp vec4 tmpvar_25;
    tmpvar_25.zw = vec2(-1.0, 0.6666667);
    tmpvar_25.xy = rgb_23.zy;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.zw = vec2(0.0, -0.3333333);
    tmpvar_26.xy = rgb_23.yz;
    tmpvar_24 = tmpvar_26;
  };
  highp vec4 tmpvar_27;
  if ((tmpvar_10.x < tmpvar_24.x)) {
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = tmpvar_24.xyw;
    tmpvar_28.w = rgb_23.x;
    tmpvar_27 = tmpvar_28;
  } else {
    highp vec4 tmpvar_29;
    tmpvar_29.x = rgb_23.x;
    tmpvar_29.yzw = tmpvar_24.yzx;
    tmpvar_27 = tmpvar_29;
  };
  highp float tmpvar_30;
  tmpvar_30 = (tmpvar_27.x - min (tmpvar_27.w, tmpvar_27.y));
  highp vec3 tmpvar_31;
  tmpvar_31.x = abs(((
    (tmpvar_27.w - tmpvar_27.y)
   / 
    ((6.0 * tmpvar_30) + 1e-7)
  ) + tmpvar_27.z));
  tmpvar_31.y = tmpvar_30;
  tmpvar_31.z = tmpvar_27.x;
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_27.x - (tmpvar_30 * 0.5));
  highp vec3 tmpvar_33;
  tmpvar_33.x = tmpvar_31.x;
  tmpvar_33.y = (tmpvar_30 / ((1.0 - 
    abs(((2.0 * tmpvar_32) - 1.0))
  ) + 1e-7));
  tmpvar_33.z = tmpvar_32;
  highp vec3 tmpvar_34;
  tmpvar_34.x = (abs((
    (6.0 * tmpvar_31.x)
   - 3.0)) - 1.0);
  tmpvar_34.y = (2.0 - abs((
    (6.0 * tmpvar_31.x)
   - 2.0)));
  tmpvar_34.z = (2.0 - abs((
    (6.0 * tmpvar_31.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_34, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_22) - 1.0)))
   * tmpvar_33.y)) + tmpvar_22);
  resultColor_2.w = tmpvar_11;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3.xyz = ((dot (vec3(0.299, 0.587, 0.114), xlt_fbColor_1.xyz) * 1.68) * tmpvar_11.xyz);
  resultColor_3.w = (_Opacity * tmpvar_11.w);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  highp vec4 srcColor_11;
  highp vec2 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (TEXTURE_GRAP, tmpvar_12);
  srcColor_11 = tmpvar_13;
  resultColor_2.xyz = ((dot (vec3(0.299, 0.587, 0.114), srcColor_11.xyz) * 1.68) * tmpvar_10.xyz);
  resultColor_2.w = (_Opacity * tmpvar_10.w);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3.xyz = ((xlt_fbColor_1.xyz + tmpvar_11.xyz) - ((2.0 * xlt_fbColor_1.xyz) * tmpvar_11.xyz));
  resultColor_3.w = (_Opacity * tmpvar_11.w);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  highp vec4 srcColor_11;
  highp vec2 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (TEXTURE_GRAP, tmpvar_12);
  srcColor_11 = tmpvar_13;
  resultColor_2.xyz = ((srcColor_11.xyz + tmpvar_10.xyz) - ((2.0 * srcColor_11.xyz) * tmpvar_10.xyz));
  resultColor_2.w = (_Opacity * tmpvar_10.w);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_12;
  tmpvar_12 = (_Opacity * tmpvar_11.w);
  highp float tmpvar_13;
  if ((tmpvar_11.x < 0.5)) {
    tmpvar_13 = ((2.0 * tmpvar_11.x) * xlt_fbColor_1.x);
  } else {
    tmpvar_13 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_11.x)
    ) * (1.0 - xlt_fbColor_1.x)));
  };
  highp float tmpvar_14;
  if ((tmpvar_11.y < 0.5)) {
    tmpvar_14 = ((2.0 * tmpvar_11.y) * xlt_fbColor_1.y);
  } else {
    tmpvar_14 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_11.y)
    ) * (1.0 - xlt_fbColor_1.y)));
  };
  highp float tmpvar_15;
  if ((tmpvar_11.z < 0.5)) {
    tmpvar_15 = ((2.0 * tmpvar_11.z) * xlt_fbColor_1.z);
  } else {
    tmpvar_15 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_11.z)
    ) * (1.0 - xlt_fbColor_1.z)));
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_13;
  tmpvar_16.y = tmpvar_14;
  tmpvar_16.z = tmpvar_15;
  resultColor_3.xyz = tmpvar_16;
  resultColor_3.w = tmpvar_12;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = (_Opacity * tmpvar_10.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((tmpvar_10.x < 0.5)) {
    tmpvar_15 = ((2.0 * tmpvar_10.x) * srcColor_12.x);
  } else {
    tmpvar_15 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_10.x)
    ) * (1.0 - srcColor_12.x)));
  };
  highp float tmpvar_16;
  if ((tmpvar_10.y < 0.5)) {
    tmpvar_16 = ((2.0 * tmpvar_10.y) * srcColor_12.y);
  } else {
    tmpvar_16 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_10.y)
    ) * (1.0 - srcColor_12.y)));
  };
  highp float tmpvar_17;
  if ((tmpvar_10.z < 0.5)) {
    tmpvar_17 = ((2.0 * tmpvar_10.z) * srcColor_12.z);
  } else {
    tmpvar_17 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_10.z)
    ) * (1.0 - srcColor_12.z)));
  };
  highp vec3 tmpvar_18;
  tmpvar_18.x = tmpvar_15;
  tmpvar_18.y = tmpvar_16;
  tmpvar_18.z = tmpvar_17;
  resultColor_2.xyz = tmpvar_18;
  resultColor_2.w = tmpvar_11;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  highp vec4 in_SurfaceColor_5;
  highp float tmpvar_6;
  tmpvar_6 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_7;
  tmpvar_7 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_8;
  tmpvar_10.y = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_DIFFUSE, tmpvar_10);
  in_SurfaceColor_5 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD3 * ((in_SurfaceColor_5 * tmpvar_6) + (1.0 - tmpvar_6)));
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_12.w);
  highp float tmpvar_13;
  if ((tmpvar_12.x < 0.5)) {
    highp float blend_14;
    blend_14 = (2.0 * tmpvar_12.x);
    highp float tmpvar_15;
    if ((blend_14 == 0.0)) {
      tmpvar_15 = blend_14;
    } else {
      tmpvar_15 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_14)), 0.0);
    };
    tmpvar_13 = tmpvar_15;
  } else {
    highp float blend_16;
    blend_16 = (2.0 * (tmpvar_12.x - 0.5));
    highp float tmpvar_17;
    if ((blend_16 == 1.0)) {
      tmpvar_17 = blend_16;
    } else {
      tmpvar_17 = min ((xlt_fbColor_1.x / (1.0 - blend_16)), 1.0);
    };
    tmpvar_13 = tmpvar_17;
  };
  highp float tmpvar_18;
  if ((tmpvar_12.y < 0.5)) {
    highp float blend_19;
    blend_19 = (2.0 * tmpvar_12.y);
    highp float tmpvar_20;
    if ((blend_19 == 0.0)) {
      tmpvar_20 = blend_19;
    } else {
      tmpvar_20 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_19)), 0.0);
    };
    tmpvar_18 = tmpvar_20;
  } else {
    highp float blend_21;
    blend_21 = (2.0 * (tmpvar_12.y - 0.5));
    highp float tmpvar_22;
    if ((blend_21 == 1.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = min ((xlt_fbColor_1.y / (1.0 - blend_21)), 1.0);
    };
    tmpvar_18 = tmpvar_22;
  };
  highp float tmpvar_23;
  if ((tmpvar_12.z < 0.5)) {
    highp float blend_24;
    blend_24 = (2.0 * tmpvar_12.z);
    highp float tmpvar_25;
    if ((blend_24 == 0.0)) {
      tmpvar_25 = blend_24;
    } else {
      tmpvar_25 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_24)), 0.0);
    };
    tmpvar_23 = tmpvar_25;
  } else {
    highp float blend_26;
    blend_26 = (2.0 * (tmpvar_12.z - 0.5));
    highp float tmpvar_27;
    if ((blend_26 == 1.0)) {
      tmpvar_27 = blend_26;
    } else {
      tmpvar_27 = min ((xlt_fbColor_1.z / (1.0 - blend_26)), 1.0);
    };
    tmpvar_23 = tmpvar_27;
  };
  highp vec3 tmpvar_28;
  tmpvar_28.x = tmpvar_13;
  tmpvar_28.y = tmpvar_18;
  tmpvar_28.z = tmpvar_23;
  resultColor_4.xyz = tmpvar_28;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_11.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((tmpvar_11.x < 0.5)) {
    highp float blend_16;
    blend_16 = (2.0 * tmpvar_11.x);
    highp float tmpvar_17;
    if ((blend_16 == 0.0)) {
      tmpvar_17 = blend_16;
    } else {
      tmpvar_17 = max ((1.0 - (
        (1.0 - srcColor_12.x)
       / blend_16)), 0.0);
    };
    tmpvar_15 = tmpvar_17;
  } else {
    highp float blend_18;
    blend_18 = (2.0 * (tmpvar_11.x - 0.5));
    highp float tmpvar_19;
    if ((blend_18 == 1.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = min ((srcColor_12.x / (1.0 - blend_18)), 1.0);
    };
    tmpvar_15 = tmpvar_19;
  };
  highp float tmpvar_20;
  if ((tmpvar_11.y < 0.5)) {
    highp float blend_21;
    blend_21 = (2.0 * tmpvar_11.y);
    highp float tmpvar_22;
    if ((blend_21 == 0.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = max ((1.0 - (
        (1.0 - srcColor_12.y)
       / blend_21)), 0.0);
    };
    tmpvar_20 = tmpvar_22;
  } else {
    highp float blend_23;
    blend_23 = (2.0 * (tmpvar_11.y - 0.5));
    highp float tmpvar_24;
    if ((blend_23 == 1.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = min ((srcColor_12.y / (1.0 - blend_23)), 1.0);
    };
    tmpvar_20 = tmpvar_24;
  };
  highp float tmpvar_25;
  if ((tmpvar_11.z < 0.5)) {
    highp float blend_26;
    blend_26 = (2.0 * tmpvar_11.z);
    highp float tmpvar_27;
    if ((blend_26 == 0.0)) {
      tmpvar_27 = blend_26;
    } else {
      tmpvar_27 = max ((1.0 - (
        (1.0 - srcColor_12.z)
       / blend_26)), 0.0);
    };
    tmpvar_25 = tmpvar_27;
  } else {
    highp float blend_28;
    blend_28 = (2.0 * (tmpvar_11.z - 0.5));
    highp float tmpvar_29;
    if ((blend_28 == 1.0)) {
      tmpvar_29 = blend_28;
    } else {
      tmpvar_29 = min ((srcColor_12.z / (1.0 - blend_28)), 1.0);
    };
    tmpvar_25 = tmpvar_29;
  };
  highp vec3 tmpvar_30;
  tmpvar_30.x = tmpvar_15;
  tmpvar_30.y = tmpvar_20;
  tmpvar_30.z = tmpvar_25;
  resultColor_3.xyz = tmpvar_30;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_12;
  tmpvar_12 = (_Opacity * tmpvar_11.w);
  highp float tmpvar_13;
  if ((xlt_fbColor_1.x < 0.5)) {
    tmpvar_13 = ((2.0 * xlt_fbColor_1.x) * tmpvar_11.x);
  } else {
    tmpvar_13 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.x)
    ) * (1.0 - tmpvar_11.x)));
  };
  highp float tmpvar_14;
  if ((xlt_fbColor_1.y < 0.5)) {
    tmpvar_14 = ((2.0 * xlt_fbColor_1.y) * tmpvar_11.y);
  } else {
    tmpvar_14 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.y)
    ) * (1.0 - tmpvar_11.y)));
  };
  highp float tmpvar_15;
  if ((xlt_fbColor_1.z < 0.5)) {
    tmpvar_15 = ((2.0 * xlt_fbColor_1.z) * tmpvar_11.z);
  } else {
    tmpvar_15 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.z)
    ) * (1.0 - tmpvar_11.z)));
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_13;
  tmpvar_16.y = tmpvar_14;
  tmpvar_16.z = tmpvar_15;
  resultColor_3.xyz = tmpvar_16;
  resultColor_3.w = tmpvar_12;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = (_Opacity * tmpvar_10.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((srcColor_12.x < 0.5)) {
    tmpvar_15 = ((2.0 * srcColor_12.x) * tmpvar_10.x);
  } else {
    tmpvar_15 = (1.0 - ((2.0 * 
      (1.0 - srcColor_12.x)
    ) * (1.0 - tmpvar_10.x)));
  };
  highp float tmpvar_16;
  if ((srcColor_12.y < 0.5)) {
    tmpvar_16 = ((2.0 * srcColor_12.y) * tmpvar_10.y);
  } else {
    tmpvar_16 = (1.0 - ((2.0 * 
      (1.0 - srcColor_12.y)
    ) * (1.0 - tmpvar_10.y)));
  };
  highp float tmpvar_17;
  if ((srcColor_12.z < 0.5)) {
    tmpvar_17 = ((2.0 * srcColor_12.z) * tmpvar_10.z);
  } else {
    tmpvar_17 = (1.0 - ((2.0 * 
      (1.0 - srcColor_12.z)
    ) * (1.0 - tmpvar_10.z)));
  };
  highp vec3 tmpvar_18;
  tmpvar_18.x = tmpvar_15;
  tmpvar_18.y = tmpvar_16;
  tmpvar_18.z = tmpvar_17;
  resultColor_2.xyz = tmpvar_18;
  resultColor_2.w = tmpvar_11;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_12;
  tmpvar_12 = (_Opacity * tmpvar_11.w);
  highp vec3 blend_13;
  blend_13 = tmpvar_11.xyz;
  highp float blend_14;
  blend_14 = blend_13.x;
  highp float tmpvar_15;
  if ((tmpvar_11.x == 0.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.x)
     / tmpvar_11.x)), 0.0);
  };
  highp float blend_16;
  blend_16 = blend_13.y;
  highp float tmpvar_17;
  if ((tmpvar_11.y == 0.0)) {
    tmpvar_17 = blend_16;
  } else {
    tmpvar_17 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.y)
     / tmpvar_11.y)), 0.0);
  };
  highp float blend_18;
  blend_18 = blend_13.z;
  highp float tmpvar_19;
  if ((tmpvar_11.z == 0.0)) {
    tmpvar_19 = blend_18;
  } else {
    tmpvar_19 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.z)
     / tmpvar_11.z)), 0.0);
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_15;
  tmpvar_20.y = tmpvar_17;
  tmpvar_20.z = tmpvar_19;
  resultColor_3.xyz = tmpvar_20;
  resultColor_3.w = tmpvar_12;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = (_Opacity * tmpvar_10.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec3 blend_15;
  blend_15 = tmpvar_10.xyz;
  highp float blend_16;
  blend_16 = blend_15.x;
  highp float tmpvar_17;
  if ((tmpvar_10.x == 0.0)) {
    tmpvar_17 = blend_16;
  } else {
    tmpvar_17 = max ((1.0 - (
      (1.0 - srcColor_12.x)
     / tmpvar_10.x)), 0.0);
  };
  highp float blend_18;
  blend_18 = blend_15.y;
  highp float tmpvar_19;
  if ((tmpvar_10.y == 0.0)) {
    tmpvar_19 = blend_18;
  } else {
    tmpvar_19 = max ((1.0 - (
      (1.0 - srcColor_12.y)
     / tmpvar_10.y)), 0.0);
  };
  highp float blend_20;
  blend_20 = blend_15.z;
  highp float tmpvar_21;
  if ((tmpvar_10.z == 0.0)) {
    tmpvar_21 = blend_20;
  } else {
    tmpvar_21 = max ((1.0 - (
      (1.0 - srcColor_12.z)
     / tmpvar_10.z)), 0.0);
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_17;
  tmpvar_22.y = tmpvar_19;
  tmpvar_22.z = tmpvar_21;
  resultColor_2.xyz = tmpvar_22;
  resultColor_2.w = tmpvar_11;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_12;
  tmpvar_12 = (_Opacity * tmpvar_11.w);
  highp vec3 blend_13;
  blend_13 = tmpvar_11.xyz;
  highp float blend_14;
  blend_14 = blend_13.x;
  highp float tmpvar_15;
  if ((tmpvar_11.x == 1.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = min ((xlt_fbColor_1.x / (1.0 - tmpvar_11.x)), 1.0);
  };
  highp float blend_16;
  blend_16 = blend_13.y;
  highp float tmpvar_17;
  if ((tmpvar_11.y == 1.0)) {
    tmpvar_17 = blend_16;
  } else {
    tmpvar_17 = min ((xlt_fbColor_1.y / (1.0 - tmpvar_11.y)), 1.0);
  };
  highp float blend_18;
  blend_18 = blend_13.z;
  highp float tmpvar_19;
  if ((tmpvar_11.z == 1.0)) {
    tmpvar_19 = blend_18;
  } else {
    tmpvar_19 = min ((xlt_fbColor_1.z / (1.0 - tmpvar_11.z)), 1.0);
  };
  highp vec3 tmpvar_20;
  tmpvar_20.x = tmpvar_15;
  tmpvar_20.y = tmpvar_17;
  tmpvar_20.z = tmpvar_19;
  resultColor_3.xyz = tmpvar_20;
  resultColor_3.w = tmpvar_12;
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = (_Opacity * tmpvar_10.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp vec3 blend_15;
  blend_15 = tmpvar_10.xyz;
  highp float blend_16;
  blend_16 = blend_15.x;
  highp float tmpvar_17;
  if ((tmpvar_10.x == 1.0)) {
    tmpvar_17 = blend_16;
  } else {
    tmpvar_17 = min ((srcColor_12.x / (1.0 - tmpvar_10.x)), 1.0);
  };
  highp float blend_18;
  blend_18 = blend_15.y;
  highp float tmpvar_19;
  if ((tmpvar_10.y == 1.0)) {
    tmpvar_19 = blend_18;
  } else {
    tmpvar_19 = min ((srcColor_12.y / (1.0 - tmpvar_10.y)), 1.0);
  };
  highp float blend_20;
  blend_20 = blend_15.z;
  highp float tmpvar_21;
  if ((tmpvar_10.z == 1.0)) {
    tmpvar_21 = blend_20;
  } else {
    tmpvar_21 = min ((srcColor_12.z / (1.0 - tmpvar_10.z)), 1.0);
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_17;
  tmpvar_22.y = tmpvar_19;
  tmpvar_22.z = tmpvar_21;
  resultColor_2.xyz = tmpvar_22;
  resultColor_2.w = tmpvar_11;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_11.xyz))
   * xlt_fbColor_1.xyz) * xlt_fbColor_1.xyz) + ((vec3(2.0, 2.0, 2.0) * xlt_fbColor_1.xyz) * tmpvar_11.xyz));
  resultColor_3.w = (_Opacity * tmpvar_11.w);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  highp vec4 srcColor_11;
  highp vec2 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (TEXTURE_GRAP, tmpvar_12);
  srcColor_11 = tmpvar_13;
  resultColor_2.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_10.xyz))
   * srcColor_11.xyz) * srcColor_11.xyz) + ((vec3(2.0, 2.0, 2.0) * srcColor_11.xyz) * tmpvar_10.xyz));
  resultColor_2.w = (_Opacity * tmpvar_10.w);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  highp vec4 in_SurfaceColor_5;
  highp float tmpvar_6;
  tmpvar_6 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_7;
  tmpvar_7 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_8;
  tmpvar_10.y = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_DIFFUSE, tmpvar_10);
  in_SurfaceColor_5 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD3 * ((in_SurfaceColor_5 * tmpvar_6) + (1.0 - tmpvar_6)));
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_12.w);
  highp float tmpvar_13;
  highp float tmpvar_14;
  if ((tmpvar_12.x < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * tmpvar_12.x);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (tmpvar_12.x - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((xlt_fbColor_1.x / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  if ((tmpvar_14 < 0.5)) {
    tmpvar_13 = 0.0;
  } else {
    tmpvar_13 = 1.0;
  };
  highp float tmpvar_19;
  highp float tmpvar_20;
  if ((tmpvar_12.y < 0.5)) {
    highp float blend_21;
    blend_21 = (2.0 * tmpvar_12.y);
    highp float tmpvar_22;
    if ((blend_21 == 0.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_21)), 0.0);
    };
    tmpvar_20 = tmpvar_22;
  } else {
    highp float blend_23;
    blend_23 = (2.0 * (tmpvar_12.y - 0.5));
    highp float tmpvar_24;
    if ((blend_23 == 1.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = min ((xlt_fbColor_1.y / (1.0 - blend_23)), 1.0);
    };
    tmpvar_20 = tmpvar_24;
  };
  if ((tmpvar_20 < 0.5)) {
    tmpvar_19 = 0.0;
  } else {
    tmpvar_19 = 1.0;
  };
  highp float tmpvar_25;
  highp float tmpvar_26;
  if ((tmpvar_12.z < 0.5)) {
    highp float blend_27;
    blend_27 = (2.0 * tmpvar_12.z);
    highp float tmpvar_28;
    if ((blend_27 == 0.0)) {
      tmpvar_28 = blend_27;
    } else {
      tmpvar_28 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_27)), 0.0);
    };
    tmpvar_26 = tmpvar_28;
  } else {
    highp float blend_29;
    blend_29 = (2.0 * (tmpvar_12.z - 0.5));
    highp float tmpvar_30;
    if ((blend_29 == 1.0)) {
      tmpvar_30 = blend_29;
    } else {
      tmpvar_30 = min ((xlt_fbColor_1.z / (1.0 - blend_29)), 1.0);
    };
    tmpvar_26 = tmpvar_30;
  };
  if ((tmpvar_26 < 0.5)) {
    tmpvar_25 = 0.0;
  } else {
    tmpvar_25 = 1.0;
  };
  highp vec3 tmpvar_31;
  tmpvar_31.x = tmpvar_13;
  tmpvar_31.y = tmpvar_19;
  tmpvar_31.z = tmpvar_25;
  resultColor_4.xyz = tmpvar_31;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_11.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  highp float tmpvar_16;
  if ((tmpvar_11.x < 0.5)) {
    highp float blend_17;
    blend_17 = (2.0 * tmpvar_11.x);
    highp float tmpvar_18;
    if ((blend_17 == 0.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = max ((1.0 - (
        (1.0 - srcColor_12.x)
       / blend_17)), 0.0);
    };
    tmpvar_16 = tmpvar_18;
  } else {
    highp float blend_19;
    blend_19 = (2.0 * (tmpvar_11.x - 0.5));
    highp float tmpvar_20;
    if ((blend_19 == 1.0)) {
      tmpvar_20 = blend_19;
    } else {
      tmpvar_20 = min ((srcColor_12.x / (1.0 - blend_19)), 1.0);
    };
    tmpvar_16 = tmpvar_20;
  };
  if ((tmpvar_16 < 0.5)) {
    tmpvar_15 = 0.0;
  } else {
    tmpvar_15 = 1.0;
  };
  highp float tmpvar_21;
  highp float tmpvar_22;
  if ((tmpvar_11.y < 0.5)) {
    highp float blend_23;
    blend_23 = (2.0 * tmpvar_11.y);
    highp float tmpvar_24;
    if ((blend_23 == 0.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = max ((1.0 - (
        (1.0 - srcColor_12.y)
       / blend_23)), 0.0);
    };
    tmpvar_22 = tmpvar_24;
  } else {
    highp float blend_25;
    blend_25 = (2.0 * (tmpvar_11.y - 0.5));
    highp float tmpvar_26;
    if ((blend_25 == 1.0)) {
      tmpvar_26 = blend_25;
    } else {
      tmpvar_26 = min ((srcColor_12.y / (1.0 - blend_25)), 1.0);
    };
    tmpvar_22 = tmpvar_26;
  };
  if ((tmpvar_22 < 0.5)) {
    tmpvar_21 = 0.0;
  } else {
    tmpvar_21 = 1.0;
  };
  highp float tmpvar_27;
  highp float tmpvar_28;
  if ((tmpvar_11.z < 0.5)) {
    highp float blend_29;
    blend_29 = (2.0 * tmpvar_11.z);
    highp float tmpvar_30;
    if ((blend_29 == 0.0)) {
      tmpvar_30 = blend_29;
    } else {
      tmpvar_30 = max ((1.0 - (
        (1.0 - srcColor_12.z)
       / blend_29)), 0.0);
    };
    tmpvar_28 = tmpvar_30;
  } else {
    highp float blend_31;
    blend_31 = (2.0 * (tmpvar_11.z - 0.5));
    highp float tmpvar_32;
    if ((blend_31 == 1.0)) {
      tmpvar_32 = blend_31;
    } else {
      tmpvar_32 = min ((srcColor_12.z / (1.0 - blend_31)), 1.0);
    };
    tmpvar_28 = tmpvar_32;
  };
  if ((tmpvar_28 < 0.5)) {
    tmpvar_27 = 0.0;
  } else {
    tmpvar_27 = 1.0;
  };
  highp vec3 tmpvar_33;
  tmpvar_33.x = tmpvar_15;
  tmpvar_33.y = tmpvar_21;
  tmpvar_33.z = tmpvar_27;
  resultColor_3.xyz = tmpvar_33;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  highp vec4 in_SurfaceColor_5;
  highp float tmpvar_6;
  tmpvar_6 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_7;
  tmpvar_7 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_8;
  tmpvar_10.y = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_DIFFUSE, tmpvar_10);
  in_SurfaceColor_5 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD3 * ((in_SurfaceColor_5 * tmpvar_6) + (1.0 - tmpvar_6)));
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_12.w);
  highp float tmpvar_13;
  if ((tmpvar_12.x < 0.5)) {
    tmpvar_13 = min ((2.0 * tmpvar_12.x), xlt_fbColor_1.x);
  } else {
    tmpvar_13 = max ((2.0 * (tmpvar_12.x - 0.5)), xlt_fbColor_1.x);
  };
  highp float tmpvar_14;
  if ((tmpvar_12.y < 0.5)) {
    tmpvar_14 = min ((2.0 * tmpvar_12.y), xlt_fbColor_1.y);
  } else {
    tmpvar_14 = max ((2.0 * (tmpvar_12.y - 0.5)), xlt_fbColor_1.y);
  };
  highp float tmpvar_15;
  if ((tmpvar_12.z < 0.5)) {
    tmpvar_15 = min ((2.0 * tmpvar_12.z), xlt_fbColor_1.z);
  } else {
    tmpvar_15 = max ((2.0 * (tmpvar_12.z - 0.5)), xlt_fbColor_1.z);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_13;
  tmpvar_16.y = tmpvar_14;
  tmpvar_16.z = tmpvar_15;
  resultColor_4.xyz = tmpvar_16;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_11.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((tmpvar_11.x < 0.5)) {
    tmpvar_15 = min ((2.0 * tmpvar_11.x), srcColor_12.x);
  } else {
    tmpvar_15 = max ((2.0 * (tmpvar_11.x - 0.5)), srcColor_12.x);
  };
  highp float tmpvar_16;
  if ((tmpvar_11.y < 0.5)) {
    tmpvar_16 = min ((2.0 * tmpvar_11.y), srcColor_12.y);
  } else {
    tmpvar_16 = max ((2.0 * (tmpvar_11.y - 0.5)), srcColor_12.y);
  };
  highp float tmpvar_17;
  if ((tmpvar_11.z < 0.5)) {
    tmpvar_17 = min ((2.0 * tmpvar_11.z), srcColor_12.z);
  } else {
    tmpvar_17 = max ((2.0 * (tmpvar_11.z - 0.5)), srcColor_12.z);
  };
  highp vec3 tmpvar_18;
  tmpvar_18.x = tmpvar_15;
  tmpvar_18.y = tmpvar_16;
  tmpvar_18.z = tmpvar_17;
  resultColor_3.xyz = tmpvar_18;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  highp vec4 in_SurfaceColor_5;
  highp float tmpvar_6;
  tmpvar_6 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_7;
  tmpvar_7 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_8;
  tmpvar_10.y = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (TEXTURE_DIFFUSE, tmpvar_10);
  in_SurfaceColor_5 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD3 * ((in_SurfaceColor_5 * tmpvar_6) + (1.0 - tmpvar_6)));
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_12.w);
  highp float tmpvar_13;
  if ((tmpvar_12.x < 0.5)) {
    tmpvar_13 = max (((xlt_fbColor_1.x + 
      (2.0 * tmpvar_12.x)
    ) - 1.0), 0.0);
  } else {
    tmpvar_13 = min ((xlt_fbColor_1.x + (2.0 * 
      (tmpvar_12.x - 0.5)
    )), 1.0);
  };
  highp float tmpvar_14;
  if ((tmpvar_12.y < 0.5)) {
    tmpvar_14 = max (((xlt_fbColor_1.y + 
      (2.0 * tmpvar_12.y)
    ) - 1.0), 0.0);
  } else {
    tmpvar_14 = min ((xlt_fbColor_1.y + (2.0 * 
      (tmpvar_12.y - 0.5)
    )), 1.0);
  };
  highp float tmpvar_15;
  if ((tmpvar_12.z < 0.5)) {
    tmpvar_15 = max (((xlt_fbColor_1.z + 
      (2.0 * tmpvar_12.z)
    ) - 1.0), 0.0);
  } else {
    tmpvar_15 = min ((xlt_fbColor_1.z + (2.0 * 
      (tmpvar_12.z - 0.5)
    )), 1.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_13;
  tmpvar_16.y = tmpvar_14;
  tmpvar_16.z = tmpvar_15;
  resultColor_4.xyz = tmpvar_16;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_11.w);
  highp vec4 srcColor_12;
  highp vec2 tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (TEXTURE_GRAP, tmpvar_13);
  srcColor_12 = tmpvar_14;
  highp float tmpvar_15;
  if ((tmpvar_11.x < 0.5)) {
    tmpvar_15 = max (((srcColor_12.x + 
      (2.0 * tmpvar_11.x)
    ) - 1.0), 0.0);
  } else {
    tmpvar_15 = min ((srcColor_12.x + (2.0 * 
      (tmpvar_11.x - 0.5)
    )), 1.0);
  };
  highp float tmpvar_16;
  if ((tmpvar_11.y < 0.5)) {
    tmpvar_16 = max (((srcColor_12.y + 
      (2.0 * tmpvar_11.y)
    ) - 1.0), 0.0);
  } else {
    tmpvar_16 = min ((srcColor_12.y + (2.0 * 
      (tmpvar_11.y - 0.5)
    )), 1.0);
  };
  highp float tmpvar_17;
  if ((tmpvar_11.z < 0.5)) {
    tmpvar_17 = max (((srcColor_12.z + 
      (2.0 * tmpvar_11.z)
    ) - 1.0), 0.0);
  } else {
    tmpvar_17 = min ((srcColor_12.z + (2.0 * 
      (tmpvar_11.z - 0.5)
    )), 1.0);
  };
  highp vec3 tmpvar_18;
  tmpvar_18.x = tmpvar_15;
  tmpvar_18.y = tmpvar_16;
  tmpvar_18.z = tmpvar_17;
  resultColor_3.xyz = tmpvar_18;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3.xyz = abs((xlt_fbColor_1.xyz - tmpvar_11.xyz));
  resultColor_3.w = (_Opacity * tmpvar_11.w);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  highp vec4 srcColor_11;
  highp vec2 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (TEXTURE_GRAP, tmpvar_12);
  srcColor_11 = tmpvar_13;
  resultColor_2.xyz = abs((srcColor_11.xyz - tmpvar_10.xyz));
  resultColor_2.w = (_Opacity * tmpvar_10.w);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3.xyz = max (((xlt_fbColor_1.xyz + tmpvar_11.xyz) - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0));
  resultColor_3.w = (_Opacity * tmpvar_11.w);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  highp vec4 srcColor_11;
  highp vec2 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (TEXTURE_GRAP, tmpvar_12);
  srcColor_11 = tmpvar_13;
  resultColor_2.xyz = max (((srcColor_11.xyz + tmpvar_10.xyz) - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0));
  resultColor_2.w = (_Opacity * tmpvar_10.w);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  resultColor_3.xyz = max ((xlt_fbColor_1.xyz - tmpvar_11.xyz), vec3(0.0, 0.0, 0.0));
  resultColor_3.w = (_Opacity * tmpvar_11.w);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  highp vec4 srcColor_11;
  highp vec2 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (TEXTURE_GRAP, tmpvar_12);
  srcColor_11 = tmpvar_13;
  resultColor_2.xyz = max ((srcColor_11.xyz - tmpvar_10.xyz), vec3(0.0, 0.0, 0.0));
  resultColor_2.w = (_Opacity * tmpvar_10.w);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform sampler2D _LutMap;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 in_SurfaceColor_4;
  highp float tmpvar_5;
  tmpvar_5 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_6;
  tmpvar_6 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  highp float tmpvar_8;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  highp vec2 tmpvar_9;
  tmpvar_9.x = tmpvar_7;
  tmpvar_9.y = tmpvar_8;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, tmpvar_9);
  in_SurfaceColor_4 = tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD3 * ((in_SurfaceColor_4 * tmpvar_5) + (1.0 - tmpvar_5)));
  highp vec2 tmpvar_12;
  tmpvar_12.x = tmpvar_11.x;
  tmpvar_12.y = xlt_fbColor_1.x;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_LutMap, tmpvar_12);
  resultColor_3.x = tmpvar_13.x;
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_11.y;
  tmpvar_14.y = xlt_fbColor_1.y;
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (_LutMap, tmpvar_14);
  resultColor_3.y = tmpvar_15.y;
  highp vec2 tmpvar_16;
  tmpvar_16.x = tmpvar_11.z;
  tmpvar_16.y = xlt_fbColor_1.z;
  lowp vec4 tmpvar_17;
  tmpvar_17 = texture2D (_LutMap, tmpvar_16);
  resultColor_3.z = tmpvar_17.z;
  resultColor_3.w = (_Opacity * tmpvar_11.w);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform sampler2D _LutMap;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 in_SurfaceColor_3;
  highp float tmpvar_4;
  tmpvar_4 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_5;
  tmpvar_5 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_6 = tmpvar_5.x;
  } else {
    tmpvar_6 = -(tmpvar_5.x);
  };
  highp float tmpvar_7;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_7 = tmpvar_5.y;
  } else {
    tmpvar_7 = -(tmpvar_5.y);
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_6;
  tmpvar_8.y = tmpvar_7;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_DIFFUSE, tmpvar_8);
  in_SurfaceColor_3 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD3 * ((in_SurfaceColor_3 * tmpvar_4) + (1.0 - tmpvar_4)));
  highp vec4 srcColor_11;
  highp vec2 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (TEXTURE_GRAP, tmpvar_12);
  srcColor_11 = tmpvar_13;
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_10.x;
  tmpvar_14.y = srcColor_11.x;
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (_LutMap, tmpvar_14);
  resultColor_2.x = tmpvar_15.x;
  highp vec2 tmpvar_16;
  tmpvar_16.x = tmpvar_10.y;
  tmpvar_16.y = srcColor_11.y;
  lowp vec4 tmpvar_17;
  tmpvar_17 = texture2D (_LutMap, tmpvar_16);
  resultColor_2.y = tmpvar_17.y;
  highp vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_10.z;
  tmpvar_18.y = srcColor_11.z;
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2D (_LutMap, tmpvar_18);
  resultColor_2.z = tmpvar_19.z;
  resultColor_2.w = (_Opacity * tmpvar_10.w);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 in_SurfaceColor_1;
  highp float tmpvar_2;
  tmpvar_2 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_3;
  tmpvar_3 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_4;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_4 = tmpvar_3.x;
  } else {
    tmpvar_4 = -(tmpvar_3.x);
  };
  highp float tmpvar_5;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_5 = tmpvar_3.y;
  } else {
    tmpvar_5 = -(tmpvar_3.y);
  };
  highp vec2 tmpvar_6;
  tmpvar_6.x = tmpvar_4;
  tmpvar_6.y = tmpvar_5;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, tmpvar_6);
  in_SurfaceColor_1 = tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8 = (xlv_TEXCOORD3 * ((in_SurfaceColor_1 * tmpvar_2) + (1.0 - tmpvar_2)));
  highp float tmpvar_9;
  tmpvar_9 = (_Opacity * tmpvar_8.w);
  highp vec4 tmpvar_10;
  tmpvar_10.xyz = (tmpvar_8 * tmpvar_9).xyz;
  tmpvar_10.w = tmpvar_9;
  gl_FragData[0] = tmpvar_10;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "20",
				varRegIndex = "0",
				varRegCount = "20",
			},
			{
				varName = "TEXTUREMODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ENABLE_TEXTURE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesColor;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 COLOR_ARRAY[20];
uniform highp float TEXTUREMODE;
uniform highp float WORLD_SCALE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord3;
  highp vec3 tmpvar_3;
  tmpvar_3 = _glesMultiTexCoord2.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4 = tmpvar_1;
  highp vec4 worldPosition_5;
  highp vec2 uv_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_8 = tmpvar_2.z;
  } else {
    tmpvar_8 = -(_glesMultiTexCoord3.z);
  };
  highp float tmpvar_9;
  tmpvar_9 = tmpvar_2.x;
  highp float tmpvar_10;
  if ((_glesMultiTexCoord3.z > 0.0)) {
    tmpvar_10 = 1.0;
  } else {
    tmpvar_10 = 0.0;
  };
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(0.0, 0.0, 1.0);
  tmpvar_11.y = (tmpvar_10 - 0.5);
  tmpvar_7 = tmpvar_11;
  highp int tmpvar_12;
  tmpvar_12 = int(((_glesMultiTexCoord3.x / _glesMultiTexCoord3.y) * 19.0));
  highp vec4 tmpvar_13;
  tmpvar_13 = COLOR_ARRAY[tmpvar_12];
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_8 * WORLD_SCALE);
  if ((TEXTUREMODE == 2.0)) {
    highp vec2 tmpvar_15;
    tmpvar_15.x = (_glesMultiTexCoord3.x / _glesMultiTexCoord3.y);
    tmpvar_15.y = tmpvar_10;
    uv_6 = tmpvar_15;
  } else {
    if ((TEXTUREMODE == 3.0)) {
      highp vec2 tmpvar_16;
      tmpvar_16.x = tmpvar_9;
      tmpvar_16.y = tmpvar_10;
      uv_6 = tmpvar_16;
    } else {
      highp vec2 tmpvar_17;
      tmpvar_17.x = (_glesMultiTexCoord3.x * tmpvar_8);
      tmpvar_17.y = tmpvar_10;
      uv_6 = tmpvar_17;
    };
  };
  highp float tmpvar_18;
  if ((_glesMultiTexCoord3.w > 0.0)) {
    tmpvar_18 = tmpvar_1.w;
  } else {
    tmpvar_18 = 0.0;
  };
  tmpvar_4.w = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((SIM_SPACE >= 1.5));
  highp vec4 tmpvar_20;
  tmpvar_20.w = 1.0;
  tmpvar_20.xyz = tmpvar_3;
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = tmpvar_3;
  highp vec4 tmpvar_22;
  tmpvar_22 = ((tmpvar_20 * tmpvar_19) + ((1.0 - tmpvar_19) * (LOCALWORLD_TRANSFORM * tmpvar_21)));
  worldPosition_5.w = tmpvar_22.w;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(_glesMultiTexCoord1.xyz);
  highp vec3 tmpvar_24;
  tmpvar_24 = (CAMERA_WORLDPOSITION - tmpvar_22.xyz);
  worldPosition_5.xyz = (tmpvar_22.xyz + ((
    normalize(((tmpvar_24.yzx * tmpvar_23.zxy) - (tmpvar_24.zxy * tmpvar_23.yzx)))
   * tmpvar_11.y) * tmpvar_14));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = uv_6;
  xlv_TEXCOORD3 = (tmpvar_4 * tmpvar_13);
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float ENABLE_TEXTURE;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 in_SurfaceColor_2;
  highp float tmpvar_3;
  tmpvar_3 = float((ENABLE_TEXTURE >= 0.5));
  highp vec2 tmpvar_4;
  tmpvar_4 = fract(abs(xlv_TEXCOORD0));
  highp float tmpvar_5;
  if ((xlv_TEXCOORD0.x >= 0.0)) {
    tmpvar_5 = tmpvar_4.x;
  } else {
    tmpvar_5 = -(tmpvar_4.x);
  };
  highp float tmpvar_6;
  if ((xlv_TEXCOORD0.y >= 0.0)) {
    tmpvar_6 = tmpvar_4.y;
  } else {
    tmpvar_6 = -(tmpvar_4.y);
  };
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_5;
  tmpvar_7.y = tmpvar_6;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_DIFFUSE, tmpvar_7);
  in_SurfaceColor_2 = tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (xlv_TEXCOORD3 * ((in_SurfaceColor_2 * tmpvar_3) + (1.0 - tmpvar_3)));
  highp float tmpvar_10;
  tmpvar_10 = (_Opacity * tmpvar_9.w);
  highp vec4 tmpvar_11;
  tmpvar_11.xyz = (tmpvar_9 * tmpvar_10).xyz;
  tmpvar_11.w = tmpvar_10;
  tmpvar_1 = tmpvar_11;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
