

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
_FadeFactor = { "factor", FLOATRANGE, "1.0, 10.0, 0.0" },
_UVYMin = { "src Min", FLOATRANGE, "0.9, 1.0, 0.8" },
_UVYFactor = { "_UVY bottom Factor", FLOATRANGE, "0.0, 2.0, 1.0" },
MESH_PARTICLE_COLOR = { "particle Color", VEC4, "1.0,1.0,1.0,1.0"},
#END

#DEFTAG
ShaderName = "particle_mesh"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float3 normal: NORMAL; 
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
	float blurFactor: TEXCOORD1;
};

sampler2D TEXTURE_DIFFUSE;
float4    MESH_PARTICLE_COLOR;
float _FadeFactor;
float _UVYMin;
float _UVYFactor;

v2f vert(appdata v)
{ 
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	
	//边缘虚化
	float3 cpos = CAMERA_WORLDPOSITION;
	
	float3 worldNormal = ObjectToWorldNormal(v.normal);
	float3 worldPos = ObjectToWorldPos(v.vertex);
	
	float3 viewDir = normalize(worldPos-cpos);
	worldNormal = normalize(worldNormal);
	
	o.blurFactor = abs(dot(viewDir, worldNormal));							
	o.vertex = UniformNDC(pos);
	o.uv = v.uv;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	//sample the texture
	float4 col = tex2D(TEXTURE_DIFFUSE, i.uv) * MESH_PARTICLE_COLOR;
	col.a = col.a * i.blurFactor * _FadeFactor * pow(i.uv.y, 3);
	
	if(i.uv.y > _UVYMin)
		col.a = col.a * pow(1.0 - (i.uv.y - _UVYMin)  / (1.0 - _UVYMin), _UVYFactor);

	return col;
}
ENDCG
#END
