
function DefineParams()
	Properties = 
	{
		
AXIS_RIGHT = { "axis right",  VEC3, "0.0,0.0,0.0" },
AXIS_UP = { "axis up",  VEC3, "0.0,0.0,0.0" },

ORIENT = { "orient",  FLOAT, "1.0" },
LOCK_Y = { "lock y",  FLOAT, "1.0" },
SIM_SPACE = {"sim space", FLOAT, "0.0"},
IMAGE_INFO = {"image info", VEC4, "0.0,0.0,1.0,1.0"},
STRETCHED_SCALE = {"stretched scale", VEC2, "0.0,1.0"},
ROTATE_CENTER = {"rotate center", VEC4, "1.0,1.0,1.0,0.0"},
PIVOT_OFFSET_SCALE = {"pivot offset scale", VEC3, "0.0,0.0,0.0"},
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_MainTexTile = { "Main Tex Tile", VEC2, "1.0,1.0"},
_MainTexOffset = { "Main Tex Offset", VEC2, "0.0,0.0"},
_Color = { "Color", COLOR, "1.0,1.0,1.0,1.0"},
_ColorScale = { "Color Scale", FLOAT, "1.0"},
_MainTex_UV_Speed = { "MainTex UV Speed", VEC2, "0.0,0.0"},
_DisortTex = { "Disort Tex", TEXTURE2D, "white"},
_Itensity = { "Itensity", FLOAT, "0.0"},
_DisortTex_UV_Speed = { "DisortTex UV Speed", VEC2, "0.0,0.0"},
_MaskTex = { "Mask Tex", TEXTURE2D, "white"},
_MaskTexTile = { "Mask Tex Tile", VEC2, "1.0,1.0"},
_MaskTexOffset = { "Mask Tex Offset", VEC2, "0.0,0.0"},
_Power = {"Power", FLOAT, "1.0"},

_Disort = {"Disort", FLOAT, "1.0"},

_BlendMode = {"Blend Mode", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_DefMode = { "Def Mode", FLOAT, "0.0"},

_FadeScale = {"Fade Scale", FLOAT, "1.0"},
_EdgeSmoothScale = {"Edge Smooth Scale", FLOAT, "1.0"},
_Tex2 = { "Tex2", TEXTURE2D, "white" },
_Tex2_UV_Speed = { "Tex2 UV Speed", VEC2, "0.0,0.0"},
_Tex2Tile = { "Tex2 Tile", VEC2, "1.0,1.0"},
_Tex2Offset = { "Tex2 Offset", VEC2, "0.0,0.0"},


	}
	Attributes = 
	{
		ORIENT = "Keywords(VIEWPLANE,VIEWPOSITION,AXIS,VELOCITY)", 
		_Disort = "Keywords(DISORT_ON,DISORT_OFF)", 
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_ADD)", 
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "particle_billboard_uv_disort"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"VIEWPLANE","DISORT_ON","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp float tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].x;
  tmpvar_11.y = CAMERA_VIEW[1].x;
  tmpvar_11.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_12;
  tmpvar_12.x = CAMERA_VIEW[0].y;
  tmpvar_12.y = CAMERA_VIEW[1].y;
  tmpvar_12.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_12));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(((tmpvar_11.yzx * axisUp_3.zxy) - (tmpvar_11.zxy * axisUp_3.yzx)));
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[0].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[0].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[0].z = -(tmpvar_17);
  tmpvar_20[1].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[0].x = tmpvar_11.x;
  tmpvar_21[0].y = tmpvar_11.y;
  tmpvar_21[0].z = tmpvar_11.z;
  tmpvar_21[1].x = axisUp_3.x;
  tmpvar_21[1].y = axisUp_3.y;
  tmpvar_21[1].z = axisUp_3.z;
  tmpvar_21[2].x = tmpvar_13.x;
  tmpvar_21[2].y = tmpvar_13.y;
  tmpvar_21[2].z = tmpvar_13.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_5);
  tmpvar_5 = tmpvar_25;
  tmpvar_6 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_26;
  v_26.x = tmpvar_21[0].z;
  v_26.y = tmpvar_21[1].z;
  v_26.z = tmpvar_21[2].z;
  tmpvar_6 = (tmpvar_6 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_4.xyz)), v_26))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_25;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_6;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _DisortTex;
uniform highp float _Itensity;
uniform highp vec2 _DisortTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = ((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset);
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + (_DisortTex_UV_Speed * SYSTEM_TIME));
  lowp float tmpvar_8;
  tmpvar_8 = texture2D (_DisortTex, tmpvar_7).x;
  distort_4 = tmpvar_8;
  uv_MainTex_5 = ((tmpvar_6 + (_MainTex_UV_Speed * SYSTEM_TIME)) + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, uv_MainTex_5);
  mainColor_3 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_Tex2, tmpvar_10);
  Tex2Color_2 = tmpvar_11;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_12;
  tmpvar_12 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_MaskTex, tmpvar_12);
  maskColor_1 = tmpvar_13;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * xlv_TEXCOORD2.xyz));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VIEWPOSITION","DISORT_ON","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp float tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_12;
  tmpvar_12.x = CAMERA_VIEW[0].y;
  tmpvar_12.y = CAMERA_VIEW[1].y;
  tmpvar_12.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(((tmpvar_12.yzx * axisForward_4.zxy) - (tmpvar_12.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_13.zxy) - (axisForward_4.zxy * tmpvar_13.yzx))
  )));
  highp vec3 tmpvar_14;
  tmpvar_14 = ((tmpvar_13.yzx * axisUp_3.zxy) - (tmpvar_13.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[0].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[0].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[0].z = -(tmpvar_18);
  tmpvar_21[1].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[0].x = tmpvar_13.x;
  tmpvar_22[0].y = tmpvar_13.y;
  tmpvar_22[0].z = tmpvar_13.z;
  tmpvar_22[1].x = axisUp_3.x;
  tmpvar_22[1].y = axisUp_3.y;
  tmpvar_22[1].z = axisUp_3.z;
  tmpvar_22[2].x = tmpvar_14.x;
  tmpvar_22[2].y = tmpvar_14.y;
  tmpvar_22[2].z = tmpvar_14.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_6);
  tmpvar_6 = tmpvar_26;
  tmpvar_7 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_27;
  v_27.x = tmpvar_22[0].z;
  v_27.y = tmpvar_22[1].z;
  v_27.z = tmpvar_22[2].z;
  tmpvar_7 = (tmpvar_7 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_5.xyz)), v_27))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_7;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _DisortTex;
uniform highp float _Itensity;
uniform highp vec2 _DisortTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = ((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset);
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + (_DisortTex_UV_Speed * SYSTEM_TIME));
  lowp float tmpvar_8;
  tmpvar_8 = texture2D (_DisortTex, tmpvar_7).x;
  distort_4 = tmpvar_8;
  uv_MainTex_5 = ((tmpvar_6 + (_MainTex_UV_Speed * SYSTEM_TIME)) + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, uv_MainTex_5);
  mainColor_3 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_Tex2, tmpvar_10);
  Tex2Color_2 = tmpvar_11;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_12;
  tmpvar_12 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_MaskTex, tmpvar_12);
  maskColor_1 = tmpvar_13;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * xlv_TEXCOORD2.xyz));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"AXIS","DISORT_ON","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_11;
  tmpvar_11 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_12);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_13;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_14;
    tmpvar_14 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_14;
    highp vec3 tmpvar_15;
    tmpvar_15 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
    axisRight_4 = tmpvar_15;
    axisUp_3 = ((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = cos(_glesNormal.z);
  highp float tmpvar_21;
  tmpvar_21 = sin(_glesNormal.z);
  highp mat3 tmpvar_22;
  tmpvar_22[0].x = (tmpvar_20 * tmpvar_18);
  tmpvar_22[0].y = (tmpvar_18 * tmpvar_21);
  tmpvar_22[0].z = -(tmpvar_19);
  tmpvar_22[1].x = (((tmpvar_20 * tmpvar_19) * tmpvar_17) - (tmpvar_16 * tmpvar_21));
  tmpvar_22[1].y = ((tmpvar_20 * tmpvar_16) + ((tmpvar_21 * tmpvar_19) * tmpvar_17));
  tmpvar_22[1].z = (tmpvar_18 * tmpvar_17);
  tmpvar_22[2].x = ((tmpvar_21 * tmpvar_17) + ((tmpvar_20 * tmpvar_16) * tmpvar_19));
  tmpvar_22[2].y = (((tmpvar_16 * tmpvar_19) * tmpvar_21) - (tmpvar_20 * tmpvar_17));
  tmpvar_22[2].z = (tmpvar_18 * tmpvar_16);
  highp mat3 tmpvar_23;
  tmpvar_23[0].x = axisRight_4.x;
  tmpvar_23[0].y = axisRight_4.y;
  tmpvar_23[0].z = axisRight_4.z;
  tmpvar_23[1].x = axisUp_3.x;
  tmpvar_23[1].y = axisUp_3.y;
  tmpvar_23[1].z = axisUp_3.z;
  tmpvar_23[2].x = axisForward_5.x;
  tmpvar_23[2].y = axisForward_5.y;
  tmpvar_23[2].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_23 * tmpvar_22) * (
    ((tmpvar_9.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_11.xyx)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_10.x >= 0.0));
  uv_2.x = ((tmpvar_24 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_10.y >= 0.0));
  uv_2.y = ((tmpvar_25 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_25) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_7);
  tmpvar_7 = tmpvar_27;
  tmpvar_8 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_28;
  v_28.x = tmpvar_23[0].z;
  v_28.y = tmpvar_23[1].z;
  v_28.z = tmpvar_23[2].z;
  tmpvar_8 = (tmpvar_8 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_6.xyz)), v_28))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_8;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _DisortTex;
uniform highp float _Itensity;
uniform highp vec2 _DisortTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = ((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset);
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + (_DisortTex_UV_Speed * SYSTEM_TIME));
  lowp float tmpvar_8;
  tmpvar_8 = texture2D (_DisortTex, tmpvar_7).x;
  distort_4 = tmpvar_8;
  uv_MainTex_5 = ((tmpvar_6 + (_MainTex_UV_Speed * SYSTEM_TIME)) + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, uv_MainTex_5);
  mainColor_3 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_Tex2, tmpvar_10);
  Tex2Color_2 = tmpvar_11;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_12;
  tmpvar_12 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_MaskTex, tmpvar_12);
  maskColor_1 = tmpvar_13;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * xlv_TEXCOORD2.xyz));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VELOCITY","DISORT_ON","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_11;
  tmpvar_11 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_12;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_13;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_13);
    highp vec4 tmpvar_14;
    tmpvar_14.w = 0.0;
    tmpvar_14.xyz = tmpvar_12;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(velocity_6);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((axisForward_3.yzx * tmpvar_15.zxy) - (axisForward_3.zxy * tmpvar_15.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize(((tmpvar_15.yzx * tmpvar_16.zxy) - (tmpvar_15.zxy * tmpvar_16.yzx)));
  axisForward_3 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.x);
  highp float tmpvar_20;
  tmpvar_20 = cos(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = sin(_glesNormal.y);
  highp float tmpvar_22;
  tmpvar_22 = cos(_glesNormal.z);
  highp float tmpvar_23;
  tmpvar_23 = sin(_glesNormal.z);
  highp mat3 tmpvar_24;
  tmpvar_24[0].x = (tmpvar_22 * tmpvar_20);
  tmpvar_24[0].y = (tmpvar_20 * tmpvar_23);
  tmpvar_24[0].z = -(tmpvar_21);
  tmpvar_24[1].x = (((tmpvar_22 * tmpvar_21) * tmpvar_19) - (tmpvar_18 * tmpvar_23));
  tmpvar_24[1].y = ((tmpvar_22 * tmpvar_18) + ((tmpvar_23 * tmpvar_21) * tmpvar_19));
  tmpvar_24[1].z = (tmpvar_20 * tmpvar_19);
  tmpvar_24[2].x = ((tmpvar_23 * tmpvar_19) + ((tmpvar_22 * tmpvar_18) * tmpvar_21));
  tmpvar_24[2].y = (((tmpvar_18 * tmpvar_21) * tmpvar_23) - (tmpvar_22 * tmpvar_19));
  tmpvar_24[2].z = (tmpvar_20 * tmpvar_18);
  highp mat3 tmpvar_25;
  tmpvar_25[0].x = tmpvar_15.x;
  tmpvar_25[0].y = tmpvar_15.y;
  tmpvar_25[0].z = tmpvar_15.z;
  tmpvar_25[1].x = tmpvar_16.x;
  tmpvar_25[1].y = tmpvar_16.y;
  tmpvar_25[1].z = tmpvar_16.z;
  tmpvar_25[2].x = tmpvar_17.x;
  tmpvar_25[2].y = tmpvar_17.y;
  tmpvar_25[2].z = tmpvar_17.z;
  highp vec3 tmpvar_26;
  tmpvar_26.z = 0.0;
  tmpvar_26.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_25 * tmpvar_24) * (
    ((tmpvar_9.xyz * tmpvar_26) + PIVOT_OFFSET_SCALE)
   * tmpvar_11.xyx)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_10.x >= 0.0));
  uv_2.x = ((tmpvar_27 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_10.y >= 0.0));
  uv_2.y = ((tmpvar_28 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_28) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 tmpvar_29;
  tmpvar_29.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_29.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_30;
  tmpvar_30 = (tmpvar_29 * tmpvar_7);
  tmpvar_7 = tmpvar_30;
  tmpvar_8 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_31;
  v_31.x = tmpvar_25[0].z;
  v_31.y = tmpvar_25[1].z;
  v_31.z = tmpvar_25[2].z;
  tmpvar_8 = (tmpvar_8 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_4.xyz)), v_31))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_30;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_8;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _DisortTex;
uniform highp float _Itensity;
uniform highp vec2 _DisortTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = ((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset);
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + (_DisortTex_UV_Speed * SYSTEM_TIME));
  lowp float tmpvar_8;
  tmpvar_8 = texture2D (_DisortTex, tmpvar_7).x;
  distort_4 = tmpvar_8;
  uv_MainTex_5 = ((tmpvar_6 + (_MainTex_UV_Speed * SYSTEM_TIME)) + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, uv_MainTex_5);
  mainColor_3 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_Tex2, tmpvar_10);
  Tex2Color_2 = tmpvar_11;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_12;
  tmpvar_12 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_MaskTex, tmpvar_12);
  maskColor_1 = tmpvar_13;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * xlv_TEXCOORD2.xyz));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VIEWPLANE","DISORT_OFF","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp float tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].x;
  tmpvar_11.y = CAMERA_VIEW[1].x;
  tmpvar_11.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_12;
  tmpvar_12.x = CAMERA_VIEW[0].y;
  tmpvar_12.y = CAMERA_VIEW[1].y;
  tmpvar_12.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_12));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(((tmpvar_11.yzx * axisUp_3.zxy) - (tmpvar_11.zxy * axisUp_3.yzx)));
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[0].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[0].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[0].z = -(tmpvar_17);
  tmpvar_20[1].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[0].x = tmpvar_11.x;
  tmpvar_21[0].y = tmpvar_11.y;
  tmpvar_21[0].z = tmpvar_11.z;
  tmpvar_21[1].x = axisUp_3.x;
  tmpvar_21[1].y = axisUp_3.y;
  tmpvar_21[1].z = axisUp_3.z;
  tmpvar_21[2].x = tmpvar_13.x;
  tmpvar_21[2].y = tmpvar_13.y;
  tmpvar_21[2].z = tmpvar_13.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_5);
  tmpvar_5 = tmpvar_25;
  tmpvar_6 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_26;
  v_26.x = tmpvar_21[0].z;
  v_26.y = tmpvar_21[1].z;
  v_26.z = tmpvar_21[2].z;
  tmpvar_6 = (tmpvar_6 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_4.xyz)), v_26))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_25;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_6;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp vec2 tmpvar_4;
  tmpvar_4 = (((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset) + (_MainTex_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, tmpvar_4);
  mainColor_3 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex2, tmpvar_6);
  Tex2Color_2 = tmpvar_7;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_8;
  tmpvar_8 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MaskTex, tmpvar_8);
  maskColor_1 = tmpvar_9;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * xlv_TEXCOORD2.xyz));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VIEWPOSITION","DISORT_OFF","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp float tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_12;
  tmpvar_12.x = CAMERA_VIEW[0].y;
  tmpvar_12.y = CAMERA_VIEW[1].y;
  tmpvar_12.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(((tmpvar_12.yzx * axisForward_4.zxy) - (tmpvar_12.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_13.zxy) - (axisForward_4.zxy * tmpvar_13.yzx))
  )));
  highp vec3 tmpvar_14;
  tmpvar_14 = ((tmpvar_13.yzx * axisUp_3.zxy) - (tmpvar_13.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[0].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[0].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[0].z = -(tmpvar_18);
  tmpvar_21[1].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[0].x = tmpvar_13.x;
  tmpvar_22[0].y = tmpvar_13.y;
  tmpvar_22[0].z = tmpvar_13.z;
  tmpvar_22[1].x = axisUp_3.x;
  tmpvar_22[1].y = axisUp_3.y;
  tmpvar_22[1].z = axisUp_3.z;
  tmpvar_22[2].x = tmpvar_14.x;
  tmpvar_22[2].y = tmpvar_14.y;
  tmpvar_22[2].z = tmpvar_14.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_6);
  tmpvar_6 = tmpvar_26;
  tmpvar_7 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_27;
  v_27.x = tmpvar_22[0].z;
  v_27.y = tmpvar_22[1].z;
  v_27.z = tmpvar_22[2].z;
  tmpvar_7 = (tmpvar_7 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_5.xyz)), v_27))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_7;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp vec2 tmpvar_4;
  tmpvar_4 = (((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset) + (_MainTex_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, tmpvar_4);
  mainColor_3 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex2, tmpvar_6);
  Tex2Color_2 = tmpvar_7;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_8;
  tmpvar_8 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MaskTex, tmpvar_8);
  maskColor_1 = tmpvar_9;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * xlv_TEXCOORD2.xyz));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"AXIS","DISORT_OFF","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_11;
  tmpvar_11 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_12);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_13;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_14;
    tmpvar_14 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_14;
    highp vec3 tmpvar_15;
    tmpvar_15 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
    axisRight_4 = tmpvar_15;
    axisUp_3 = ((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = cos(_glesNormal.z);
  highp float tmpvar_21;
  tmpvar_21 = sin(_glesNormal.z);
  highp mat3 tmpvar_22;
  tmpvar_22[0].x = (tmpvar_20 * tmpvar_18);
  tmpvar_22[0].y = (tmpvar_18 * tmpvar_21);
  tmpvar_22[0].z = -(tmpvar_19);
  tmpvar_22[1].x = (((tmpvar_20 * tmpvar_19) * tmpvar_17) - (tmpvar_16 * tmpvar_21));
  tmpvar_22[1].y = ((tmpvar_20 * tmpvar_16) + ((tmpvar_21 * tmpvar_19) * tmpvar_17));
  tmpvar_22[1].z = (tmpvar_18 * tmpvar_17);
  tmpvar_22[2].x = ((tmpvar_21 * tmpvar_17) + ((tmpvar_20 * tmpvar_16) * tmpvar_19));
  tmpvar_22[2].y = (((tmpvar_16 * tmpvar_19) * tmpvar_21) - (tmpvar_20 * tmpvar_17));
  tmpvar_22[2].z = (tmpvar_18 * tmpvar_16);
  highp mat3 tmpvar_23;
  tmpvar_23[0].x = axisRight_4.x;
  tmpvar_23[0].y = axisRight_4.y;
  tmpvar_23[0].z = axisRight_4.z;
  tmpvar_23[1].x = axisUp_3.x;
  tmpvar_23[1].y = axisUp_3.y;
  tmpvar_23[1].z = axisUp_3.z;
  tmpvar_23[2].x = axisForward_5.x;
  tmpvar_23[2].y = axisForward_5.y;
  tmpvar_23[2].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_23 * tmpvar_22) * (
    ((tmpvar_9.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_11.xyx)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_10.x >= 0.0));
  uv_2.x = ((tmpvar_24 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_10.y >= 0.0));
  uv_2.y = ((tmpvar_25 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_25) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_7);
  tmpvar_7 = tmpvar_27;
  tmpvar_8 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_28;
  v_28.x = tmpvar_23[0].z;
  v_28.y = tmpvar_23[1].z;
  v_28.z = tmpvar_23[2].z;
  tmpvar_8 = (tmpvar_8 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_6.xyz)), v_28))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_8;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp vec2 tmpvar_4;
  tmpvar_4 = (((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset) + (_MainTex_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, tmpvar_4);
  mainColor_3 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex2, tmpvar_6);
  Tex2Color_2 = tmpvar_7;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_8;
  tmpvar_8 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MaskTex, tmpvar_8);
  maskColor_1 = tmpvar_9;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * xlv_TEXCOORD2.xyz));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VELOCITY","DISORT_OFF","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_11;
  tmpvar_11 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_12;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_13;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_13);
    highp vec4 tmpvar_14;
    tmpvar_14.w = 0.0;
    tmpvar_14.xyz = tmpvar_12;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(velocity_6);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((axisForward_3.yzx * tmpvar_15.zxy) - (axisForward_3.zxy * tmpvar_15.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize(((tmpvar_15.yzx * tmpvar_16.zxy) - (tmpvar_15.zxy * tmpvar_16.yzx)));
  axisForward_3 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.x);
  highp float tmpvar_20;
  tmpvar_20 = cos(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = sin(_glesNormal.y);
  highp float tmpvar_22;
  tmpvar_22 = cos(_glesNormal.z);
  highp float tmpvar_23;
  tmpvar_23 = sin(_glesNormal.z);
  highp mat3 tmpvar_24;
  tmpvar_24[0].x = (tmpvar_22 * tmpvar_20);
  tmpvar_24[0].y = (tmpvar_20 * tmpvar_23);
  tmpvar_24[0].z = -(tmpvar_21);
  tmpvar_24[1].x = (((tmpvar_22 * tmpvar_21) * tmpvar_19) - (tmpvar_18 * tmpvar_23));
  tmpvar_24[1].y = ((tmpvar_22 * tmpvar_18) + ((tmpvar_23 * tmpvar_21) * tmpvar_19));
  tmpvar_24[1].z = (tmpvar_20 * tmpvar_19);
  tmpvar_24[2].x = ((tmpvar_23 * tmpvar_19) + ((tmpvar_22 * tmpvar_18) * tmpvar_21));
  tmpvar_24[2].y = (((tmpvar_18 * tmpvar_21) * tmpvar_23) - (tmpvar_22 * tmpvar_19));
  tmpvar_24[2].z = (tmpvar_20 * tmpvar_18);
  highp mat3 tmpvar_25;
  tmpvar_25[0].x = tmpvar_15.x;
  tmpvar_25[0].y = tmpvar_15.y;
  tmpvar_25[0].z = tmpvar_15.z;
  tmpvar_25[1].x = tmpvar_16.x;
  tmpvar_25[1].y = tmpvar_16.y;
  tmpvar_25[1].z = tmpvar_16.z;
  tmpvar_25[2].x = tmpvar_17.x;
  tmpvar_25[2].y = tmpvar_17.y;
  tmpvar_25[2].z = tmpvar_17.z;
  highp vec3 tmpvar_26;
  tmpvar_26.z = 0.0;
  tmpvar_26.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_25 * tmpvar_24) * (
    ((tmpvar_9.xyz * tmpvar_26) + PIVOT_OFFSET_SCALE)
   * tmpvar_11.xyx)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_10.x >= 0.0));
  uv_2.x = ((tmpvar_27 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_10.y >= 0.0));
  uv_2.y = ((tmpvar_28 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_28) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 tmpvar_29;
  tmpvar_29.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_29.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_30;
  tmpvar_30 = (tmpvar_29 * tmpvar_7);
  tmpvar_7 = tmpvar_30;
  tmpvar_8 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_31;
  v_31.x = tmpvar_25[0].z;
  v_31.y = tmpvar_25[1].z;
  v_31.z = tmpvar_25[2].z;
  tmpvar_8 = (tmpvar_8 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_4.xyz)), v_31))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_30;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_8;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp vec2 tmpvar_4;
  tmpvar_4 = (((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset) + (_MainTex_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, tmpvar_4);
  mainColor_3 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex2, tmpvar_6);
  Tex2Color_2 = tmpvar_7;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_8;
  tmpvar_8 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MaskTex, tmpvar_8);
  maskColor_1 = tmpvar_9;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * xlv_TEXCOORD2.xyz));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VIEWPLANE","DISORT_ON","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp float tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].x;
  tmpvar_11.y = CAMERA_VIEW[1].x;
  tmpvar_11.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_12;
  tmpvar_12.x = CAMERA_VIEW[0].y;
  tmpvar_12.y = CAMERA_VIEW[1].y;
  tmpvar_12.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_12));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(((tmpvar_11.yzx * axisUp_3.zxy) - (tmpvar_11.zxy * axisUp_3.yzx)));
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[0].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[0].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[0].z = -(tmpvar_17);
  tmpvar_20[1].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[0].x = tmpvar_11.x;
  tmpvar_21[0].y = tmpvar_11.y;
  tmpvar_21[0].z = tmpvar_11.z;
  tmpvar_21[1].x = axisUp_3.x;
  tmpvar_21[1].y = axisUp_3.y;
  tmpvar_21[1].z = axisUp_3.z;
  tmpvar_21[2].x = tmpvar_13.x;
  tmpvar_21[2].y = tmpvar_13.y;
  tmpvar_21[2].z = tmpvar_13.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_5);
  tmpvar_5 = tmpvar_25;
  tmpvar_6 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_26;
  v_26.x = tmpvar_21[0].z;
  v_26.y = tmpvar_21[1].z;
  v_26.z = tmpvar_21[2].z;
  tmpvar_6 = (tmpvar_6 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_4.xyz)), v_26))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_25;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_6;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _DisortTex;
uniform highp float _Itensity;
uniform highp vec2 _DisortTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = ((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset);
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + (_DisortTex_UV_Speed * SYSTEM_TIME));
  lowp float tmpvar_8;
  tmpvar_8 = texture2D (_DisortTex, tmpvar_7).x;
  distort_4 = tmpvar_8;
  uv_MainTex_5 = ((tmpvar_6 + (_MainTex_UV_Speed * SYSTEM_TIME)) + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, uv_MainTex_5);
  mainColor_3 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_Tex2, tmpvar_10);
  Tex2Color_2 = tmpvar_11;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_12;
  tmpvar_12 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_MaskTex, tmpvar_12);
  maskColor_1 = tmpvar_13;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * ((_ColorScale * xlv_TEXCOORD2.xyz) * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VIEWPOSITION","DISORT_ON","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp float tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_12;
  tmpvar_12.x = CAMERA_VIEW[0].y;
  tmpvar_12.y = CAMERA_VIEW[1].y;
  tmpvar_12.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(((tmpvar_12.yzx * axisForward_4.zxy) - (tmpvar_12.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_13.zxy) - (axisForward_4.zxy * tmpvar_13.yzx))
  )));
  highp vec3 tmpvar_14;
  tmpvar_14 = ((tmpvar_13.yzx * axisUp_3.zxy) - (tmpvar_13.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[0].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[0].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[0].z = -(tmpvar_18);
  tmpvar_21[1].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[0].x = tmpvar_13.x;
  tmpvar_22[0].y = tmpvar_13.y;
  tmpvar_22[0].z = tmpvar_13.z;
  tmpvar_22[1].x = axisUp_3.x;
  tmpvar_22[1].y = axisUp_3.y;
  tmpvar_22[1].z = axisUp_3.z;
  tmpvar_22[2].x = tmpvar_14.x;
  tmpvar_22[2].y = tmpvar_14.y;
  tmpvar_22[2].z = tmpvar_14.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_6);
  tmpvar_6 = tmpvar_26;
  tmpvar_7 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_27;
  v_27.x = tmpvar_22[0].z;
  v_27.y = tmpvar_22[1].z;
  v_27.z = tmpvar_22[2].z;
  tmpvar_7 = (tmpvar_7 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_5.xyz)), v_27))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_7;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _DisortTex;
uniform highp float _Itensity;
uniform highp vec2 _DisortTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = ((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset);
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + (_DisortTex_UV_Speed * SYSTEM_TIME));
  lowp float tmpvar_8;
  tmpvar_8 = texture2D (_DisortTex, tmpvar_7).x;
  distort_4 = tmpvar_8;
  uv_MainTex_5 = ((tmpvar_6 + (_MainTex_UV_Speed * SYSTEM_TIME)) + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, uv_MainTex_5);
  mainColor_3 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_Tex2, tmpvar_10);
  Tex2Color_2 = tmpvar_11;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_12;
  tmpvar_12 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_MaskTex, tmpvar_12);
  maskColor_1 = tmpvar_13;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * ((_ColorScale * xlv_TEXCOORD2.xyz) * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"AXIS","DISORT_ON","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_11;
  tmpvar_11 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_12);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_13;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_14;
    tmpvar_14 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_14;
    highp vec3 tmpvar_15;
    tmpvar_15 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
    axisRight_4 = tmpvar_15;
    axisUp_3 = ((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = cos(_glesNormal.z);
  highp float tmpvar_21;
  tmpvar_21 = sin(_glesNormal.z);
  highp mat3 tmpvar_22;
  tmpvar_22[0].x = (tmpvar_20 * tmpvar_18);
  tmpvar_22[0].y = (tmpvar_18 * tmpvar_21);
  tmpvar_22[0].z = -(tmpvar_19);
  tmpvar_22[1].x = (((tmpvar_20 * tmpvar_19) * tmpvar_17) - (tmpvar_16 * tmpvar_21));
  tmpvar_22[1].y = ((tmpvar_20 * tmpvar_16) + ((tmpvar_21 * tmpvar_19) * tmpvar_17));
  tmpvar_22[1].z = (tmpvar_18 * tmpvar_17);
  tmpvar_22[2].x = ((tmpvar_21 * tmpvar_17) + ((tmpvar_20 * tmpvar_16) * tmpvar_19));
  tmpvar_22[2].y = (((tmpvar_16 * tmpvar_19) * tmpvar_21) - (tmpvar_20 * tmpvar_17));
  tmpvar_22[2].z = (tmpvar_18 * tmpvar_16);
  highp mat3 tmpvar_23;
  tmpvar_23[0].x = axisRight_4.x;
  tmpvar_23[0].y = axisRight_4.y;
  tmpvar_23[0].z = axisRight_4.z;
  tmpvar_23[1].x = axisUp_3.x;
  tmpvar_23[1].y = axisUp_3.y;
  tmpvar_23[1].z = axisUp_3.z;
  tmpvar_23[2].x = axisForward_5.x;
  tmpvar_23[2].y = axisForward_5.y;
  tmpvar_23[2].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_23 * tmpvar_22) * (
    ((tmpvar_9.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_11.xyx)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_10.x >= 0.0));
  uv_2.x = ((tmpvar_24 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_10.y >= 0.0));
  uv_2.y = ((tmpvar_25 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_25) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_7);
  tmpvar_7 = tmpvar_27;
  tmpvar_8 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_28;
  v_28.x = tmpvar_23[0].z;
  v_28.y = tmpvar_23[1].z;
  v_28.z = tmpvar_23[2].z;
  tmpvar_8 = (tmpvar_8 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_6.xyz)), v_28))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_8;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _DisortTex;
uniform highp float _Itensity;
uniform highp vec2 _DisortTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = ((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset);
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + (_DisortTex_UV_Speed * SYSTEM_TIME));
  lowp float tmpvar_8;
  tmpvar_8 = texture2D (_DisortTex, tmpvar_7).x;
  distort_4 = tmpvar_8;
  uv_MainTex_5 = ((tmpvar_6 + (_MainTex_UV_Speed * SYSTEM_TIME)) + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, uv_MainTex_5);
  mainColor_3 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_Tex2, tmpvar_10);
  Tex2Color_2 = tmpvar_11;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_12;
  tmpvar_12 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_MaskTex, tmpvar_12);
  maskColor_1 = tmpvar_13;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * ((_ColorScale * xlv_TEXCOORD2.xyz) * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VELOCITY","DISORT_ON","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_11;
  tmpvar_11 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_12;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_13;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_13);
    highp vec4 tmpvar_14;
    tmpvar_14.w = 0.0;
    tmpvar_14.xyz = tmpvar_12;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(velocity_6);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((axisForward_3.yzx * tmpvar_15.zxy) - (axisForward_3.zxy * tmpvar_15.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize(((tmpvar_15.yzx * tmpvar_16.zxy) - (tmpvar_15.zxy * tmpvar_16.yzx)));
  axisForward_3 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.x);
  highp float tmpvar_20;
  tmpvar_20 = cos(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = sin(_glesNormal.y);
  highp float tmpvar_22;
  tmpvar_22 = cos(_glesNormal.z);
  highp float tmpvar_23;
  tmpvar_23 = sin(_glesNormal.z);
  highp mat3 tmpvar_24;
  tmpvar_24[0].x = (tmpvar_22 * tmpvar_20);
  tmpvar_24[0].y = (tmpvar_20 * tmpvar_23);
  tmpvar_24[0].z = -(tmpvar_21);
  tmpvar_24[1].x = (((tmpvar_22 * tmpvar_21) * tmpvar_19) - (tmpvar_18 * tmpvar_23));
  tmpvar_24[1].y = ((tmpvar_22 * tmpvar_18) + ((tmpvar_23 * tmpvar_21) * tmpvar_19));
  tmpvar_24[1].z = (tmpvar_20 * tmpvar_19);
  tmpvar_24[2].x = ((tmpvar_23 * tmpvar_19) + ((tmpvar_22 * tmpvar_18) * tmpvar_21));
  tmpvar_24[2].y = (((tmpvar_18 * tmpvar_21) * tmpvar_23) - (tmpvar_22 * tmpvar_19));
  tmpvar_24[2].z = (tmpvar_20 * tmpvar_18);
  highp mat3 tmpvar_25;
  tmpvar_25[0].x = tmpvar_15.x;
  tmpvar_25[0].y = tmpvar_15.y;
  tmpvar_25[0].z = tmpvar_15.z;
  tmpvar_25[1].x = tmpvar_16.x;
  tmpvar_25[1].y = tmpvar_16.y;
  tmpvar_25[1].z = tmpvar_16.z;
  tmpvar_25[2].x = tmpvar_17.x;
  tmpvar_25[2].y = tmpvar_17.y;
  tmpvar_25[2].z = tmpvar_17.z;
  highp vec3 tmpvar_26;
  tmpvar_26.z = 0.0;
  tmpvar_26.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_25 * tmpvar_24) * (
    ((tmpvar_9.xyz * tmpvar_26) + PIVOT_OFFSET_SCALE)
   * tmpvar_11.xyx)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_10.x >= 0.0));
  uv_2.x = ((tmpvar_27 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_10.y >= 0.0));
  uv_2.y = ((tmpvar_28 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_28) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 tmpvar_29;
  tmpvar_29.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_29.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_30;
  tmpvar_30 = (tmpvar_29 * tmpvar_7);
  tmpvar_7 = tmpvar_30;
  tmpvar_8 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_31;
  v_31.x = tmpvar_25[0].z;
  v_31.y = tmpvar_25[1].z;
  v_31.z = tmpvar_25[2].z;
  tmpvar_8 = (tmpvar_8 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_4.xyz)), v_31))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_30;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_8;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _DisortTex;
uniform highp float _Itensity;
uniform highp vec2 _DisortTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = ((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset);
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + (_DisortTex_UV_Speed * SYSTEM_TIME));
  lowp float tmpvar_8;
  tmpvar_8 = texture2D (_DisortTex, tmpvar_7).x;
  distort_4 = tmpvar_8;
  uv_MainTex_5 = ((tmpvar_6 + (_MainTex_UV_Speed * SYSTEM_TIME)) + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, uv_MainTex_5);
  mainColor_3 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_Tex2, tmpvar_10);
  Tex2Color_2 = tmpvar_11;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_12;
  tmpvar_12 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_MaskTex, tmpvar_12);
  maskColor_1 = tmpvar_13;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * ((_ColorScale * xlv_TEXCOORD2.xyz) * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VIEWPLANE","DISORT_OFF","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp float tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].x;
  tmpvar_11.y = CAMERA_VIEW[1].x;
  tmpvar_11.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_12;
  tmpvar_12.x = CAMERA_VIEW[0].y;
  tmpvar_12.y = CAMERA_VIEW[1].y;
  tmpvar_12.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_12));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(((tmpvar_11.yzx * axisUp_3.zxy) - (tmpvar_11.zxy * axisUp_3.yzx)));
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[0].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[0].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[0].z = -(tmpvar_17);
  tmpvar_20[1].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[0].x = tmpvar_11.x;
  tmpvar_21[0].y = tmpvar_11.y;
  tmpvar_21[0].z = tmpvar_11.z;
  tmpvar_21[1].x = axisUp_3.x;
  tmpvar_21[1].y = axisUp_3.y;
  tmpvar_21[1].z = axisUp_3.z;
  tmpvar_21[2].x = tmpvar_13.x;
  tmpvar_21[2].y = tmpvar_13.y;
  tmpvar_21[2].z = tmpvar_13.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 tmpvar_24;
  tmpvar_24.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_24.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_5);
  tmpvar_5 = tmpvar_25;
  tmpvar_6 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_26;
  v_26.x = tmpvar_21[0].z;
  v_26.y = tmpvar_21[1].z;
  v_26.z = tmpvar_21[2].z;
  tmpvar_6 = (tmpvar_6 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_4.xyz)), v_26))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_25;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_6;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp vec2 tmpvar_4;
  tmpvar_4 = (((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset) + (_MainTex_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, tmpvar_4);
  mainColor_3 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex2, tmpvar_6);
  Tex2Color_2 = tmpvar_7;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_8;
  tmpvar_8 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MaskTex, tmpvar_8);
  maskColor_1 = tmpvar_9;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * ((_ColorScale * xlv_TEXCOORD2.xyz) * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VIEWPOSITION","DISORT_OFF","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp float tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_12;
  tmpvar_12.x = CAMERA_VIEW[0].y;
  tmpvar_12.y = CAMERA_VIEW[1].y;
  tmpvar_12.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(((tmpvar_12.yzx * axisForward_4.zxy) - (tmpvar_12.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_13.zxy) - (axisForward_4.zxy * tmpvar_13.yzx))
  )));
  highp vec3 tmpvar_14;
  tmpvar_14 = ((tmpvar_13.yzx * axisUp_3.zxy) - (tmpvar_13.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[0].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[0].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[0].z = -(tmpvar_18);
  tmpvar_21[1].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[0].x = tmpvar_13.x;
  tmpvar_22[0].y = tmpvar_13.y;
  tmpvar_22[0].z = tmpvar_13.z;
  tmpvar_22[1].x = axisUp_3.x;
  tmpvar_22[1].y = axisUp_3.y;
  tmpvar_22[1].z = axisUp_3.z;
  tmpvar_22[2].x = tmpvar_14.x;
  tmpvar_22[2].y = tmpvar_14.y;
  tmpvar_22[2].z = tmpvar_14.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_6);
  tmpvar_6 = tmpvar_26;
  tmpvar_7 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_27;
  v_27.x = tmpvar_22[0].z;
  v_27.y = tmpvar_22[1].z;
  v_27.z = tmpvar_22[2].z;
  tmpvar_7 = (tmpvar_7 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_5.xyz)), v_27))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_7;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp vec2 tmpvar_4;
  tmpvar_4 = (((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset) + (_MainTex_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, tmpvar_4);
  mainColor_3 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex2, tmpvar_6);
  Tex2Color_2 = tmpvar_7;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_8;
  tmpvar_8 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MaskTex, tmpvar_8);
  maskColor_1 = tmpvar_9;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * ((_ColorScale * xlv_TEXCOORD2.xyz) * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"AXIS","DISORT_OFF","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_11;
  tmpvar_11 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_12);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_13;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_14;
    tmpvar_14 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_14;
    highp vec3 tmpvar_15;
    tmpvar_15 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
    axisRight_4 = tmpvar_15;
    axisUp_3 = ((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = cos(_glesNormal.z);
  highp float tmpvar_21;
  tmpvar_21 = sin(_glesNormal.z);
  highp mat3 tmpvar_22;
  tmpvar_22[0].x = (tmpvar_20 * tmpvar_18);
  tmpvar_22[0].y = (tmpvar_18 * tmpvar_21);
  tmpvar_22[0].z = -(tmpvar_19);
  tmpvar_22[1].x = (((tmpvar_20 * tmpvar_19) * tmpvar_17) - (tmpvar_16 * tmpvar_21));
  tmpvar_22[1].y = ((tmpvar_20 * tmpvar_16) + ((tmpvar_21 * tmpvar_19) * tmpvar_17));
  tmpvar_22[1].z = (tmpvar_18 * tmpvar_17);
  tmpvar_22[2].x = ((tmpvar_21 * tmpvar_17) + ((tmpvar_20 * tmpvar_16) * tmpvar_19));
  tmpvar_22[2].y = (((tmpvar_16 * tmpvar_19) * tmpvar_21) - (tmpvar_20 * tmpvar_17));
  tmpvar_22[2].z = (tmpvar_18 * tmpvar_16);
  highp mat3 tmpvar_23;
  tmpvar_23[0].x = axisRight_4.x;
  tmpvar_23[0].y = axisRight_4.y;
  tmpvar_23[0].z = axisRight_4.z;
  tmpvar_23[1].x = axisUp_3.x;
  tmpvar_23[1].y = axisUp_3.y;
  tmpvar_23[1].z = axisUp_3.z;
  tmpvar_23[2].x = axisForward_5.x;
  tmpvar_23[2].y = axisForward_5.y;
  tmpvar_23[2].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_23 * tmpvar_22) * (
    ((tmpvar_9.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_11.xyx)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_10.x >= 0.0));
  uv_2.x = ((tmpvar_24 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_10.y >= 0.0));
  uv_2.y = ((tmpvar_25 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_25) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_7);
  tmpvar_7 = tmpvar_27;
  tmpvar_8 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_28;
  v_28.x = tmpvar_23[0].z;
  v_28.y = tmpvar_23[1].z;
  v_28.z = tmpvar_23[2].z;
  tmpvar_8 = (tmpvar_8 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_6.xyz)), v_28))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_8;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp vec2 tmpvar_4;
  tmpvar_4 = (((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset) + (_MainTex_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, tmpvar_4);
  mainColor_3 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex2, tmpvar_6);
  Tex2Color_2 = tmpvar_7;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_8;
  tmpvar_8 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MaskTex, tmpvar_8);
  maskColor_1 = tmpvar_9;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * ((_ColorScale * xlv_TEXCOORD2.xyz) * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"VELOCITY","DISORT_OFF","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
attribute vec4 _glesMultiTexCoord2;
attribute vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_11;
  tmpvar_11 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_12;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_13;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_13);
    highp vec4 tmpvar_14;
    tmpvar_14.w = 0.0;
    tmpvar_14.xyz = tmpvar_12;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_14).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(velocity_6);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((axisForward_3.yzx * tmpvar_15.zxy) - (axisForward_3.zxy * tmpvar_15.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize(((tmpvar_15.yzx * tmpvar_16.zxy) - (tmpvar_15.zxy * tmpvar_16.yzx)));
  axisForward_3 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.x);
  highp float tmpvar_20;
  tmpvar_20 = cos(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = sin(_glesNormal.y);
  highp float tmpvar_22;
  tmpvar_22 = cos(_glesNormal.z);
  highp float tmpvar_23;
  tmpvar_23 = sin(_glesNormal.z);
  highp mat3 tmpvar_24;
  tmpvar_24[0].x = (tmpvar_22 * tmpvar_20);
  tmpvar_24[0].y = (tmpvar_20 * tmpvar_23);
  tmpvar_24[0].z = -(tmpvar_21);
  tmpvar_24[1].x = (((tmpvar_22 * tmpvar_21) * tmpvar_19) - (tmpvar_18 * tmpvar_23));
  tmpvar_24[1].y = ((tmpvar_22 * tmpvar_18) + ((tmpvar_23 * tmpvar_21) * tmpvar_19));
  tmpvar_24[1].z = (tmpvar_20 * tmpvar_19);
  tmpvar_24[2].x = ((tmpvar_23 * tmpvar_19) + ((tmpvar_22 * tmpvar_18) * tmpvar_21));
  tmpvar_24[2].y = (((tmpvar_18 * tmpvar_21) * tmpvar_23) - (tmpvar_22 * tmpvar_19));
  tmpvar_24[2].z = (tmpvar_20 * tmpvar_18);
  highp mat3 tmpvar_25;
  tmpvar_25[0].x = tmpvar_15.x;
  tmpvar_25[0].y = tmpvar_15.y;
  tmpvar_25[0].z = tmpvar_15.z;
  tmpvar_25[1].x = tmpvar_16.x;
  tmpvar_25[1].y = tmpvar_16.y;
  tmpvar_25[1].z = tmpvar_16.z;
  tmpvar_25[2].x = tmpvar_17.x;
  tmpvar_25[2].y = tmpvar_17.y;
  tmpvar_25[2].z = tmpvar_17.z;
  highp vec3 tmpvar_26;
  tmpvar_26.z = 0.0;
  tmpvar_26.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_25 * tmpvar_24) * (
    ((tmpvar_9.xyz * tmpvar_26) + PIVOT_OFFSET_SCALE)
   * tmpvar_11.xyx)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_10.x >= 0.0));
  uv_2.x = ((tmpvar_27 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_10.y >= 0.0));
  uv_2.y = ((tmpvar_28 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_28) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 tmpvar_29;
  tmpvar_29.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_29.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_30;
  tmpvar_30 = (tmpvar_29 * tmpvar_7);
  tmpvar_7 = tmpvar_30;
  tmpvar_8 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp vec3 v_31;
  v_31.x = tmpvar_25[0].z;
  v_31.y = tmpvar_25[1].z;
  v_31.z = tmpvar_25[2].z;
  tmpvar_8 = (tmpvar_8 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - worldPosition_4.xyz)), v_31))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  gl_Position = tmpvar_30;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_8;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MainTex_UV_Speed;
uniform sampler2D _MaskTex;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp vec2 tmpvar_4;
  tmpvar_4 = (((xlv_TEXCOORD0 * _MainTexTile) + _MainTexOffset) + (_MainTex_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, tmpvar_4);
  mainColor_3 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD0 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex2, tmpvar_6);
  Tex2Color_2 = tmpvar_7;
  mainColor_3 = (mainColor_3 * Tex2Color_2);
  highp vec2 tmpvar_8;
  tmpvar_8 = ((xlv_TEXCOORD0 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MaskTex, tmpvar_8);
  maskColor_1 = tmpvar_9;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * 
    (_ColorScale * xlv_TEXCOORD2.w)
  ) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * ((_ColorScale * xlv_TEXCOORD2.xyz) * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
}

end
