
function DefineParams()
	Properties = 
	{
		
PARTICLE_GLOBAL_OFFSET = {"Global Offeset", VEC3, "0.0,0.0,0.0"},
PARTICLE_GLOBAL_SCALE = {"Global Scale", VEC3, "1.0,1.0,1.0"},
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },

_BlendSrc = {"blendsrc", FLOAT, "4.0"},

_BlendDst = {"blenddst", FLOAT, "5.0"},

	}
	Attributes = 
	{
		_BlendSrc = "Enum(BlendFunc)", 
		_BlendDst = "Enum(BlendFunc)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "ParticleBlend"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA 
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}



Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PARTICLE_GLOBAL_OFFSET",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PARTICLE_GLOBAL_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SYSTEM_TIME;
uniform highp vec3 PARTICLE_GLOBAL_OFFSET;
uniform highp vec3 PARTICLE_GLOBAL_SCALE;
in highp vec3 _glesBinormal;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_COLOR0;
void main ()
{
  highp vec4 out_Position_1;
  highp vec3 out_Offset_2;
  highp vec2 tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = sin(_glesMultiTexCoord1.x);
  highp float tmpvar_5;
  tmpvar_5 = cos(_glesMultiTexCoord1.x);
  highp float tmpvar_6;
  tmpvar_6 = sin(_glesMultiTexCoord1.y);
  highp float tmpvar_7;
  tmpvar_7 = cos(_glesMultiTexCoord1.y);
  highp float tmpvar_8;
  tmpvar_8 = sin(_glesMultiTexCoord1.z);
  highp float tmpvar_9;
  tmpvar_9 = cos(_glesMultiTexCoord1.z);
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)].x = (tmpvar_9 * tmpvar_7);
  tmpvar_10[uint(0)].y = (tmpvar_7 * tmpvar_8);
  tmpvar_10[uint(0)].z = -(tmpvar_6);
  tmpvar_10[1u].x = (((tmpvar_9 * tmpvar_6) * tmpvar_4) - (tmpvar_5 * tmpvar_8));
  tmpvar_10[1u].y = ((tmpvar_9 * tmpvar_5) + ((tmpvar_8 * tmpvar_6) * tmpvar_4));
  tmpvar_10[1u].z = (tmpvar_7 * tmpvar_4);
  tmpvar_10[2u].x = ((tmpvar_8 * tmpvar_4) + ((tmpvar_9 * tmpvar_5) * tmpvar_6));
  tmpvar_10[2u].y = ((tmpvar_5 * tmpvar_8) - (tmpvar_9 * tmpvar_4));
  tmpvar_10[2u].z = (tmpvar_7 * tmpvar_5);
  highp vec3 tmpvar_11;
  tmpvar_11.z = 0.0;
  tmpvar_11.xy = _glesMultiTexCoord3.xy;
  out_Offset_2 = ((tmpvar_11 * _glesMultiTexCoord2.x) * PARTICLE_GLOBAL_SCALE);
  out_Offset_2 = (tmpvar_10 * out_Offset_2);
  highp vec3 x_12;
  x_12 = (_glesVertex.xyz + out_Offset_2);
  out_Offset_2 = ((out_Offset_2 * (_glesMultiTexCoord2.y * 
    cos((sqrt(dot (x_12, x_12)) * SYSTEM_TIME))
  )) + out_Offset_2);
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (_glesVertex.xyz + PARTICLE_GLOBAL_OFFSET);
  highp vec4 tmpvar_14;
  tmpvar_14 = (CAMERA_VIEW * tmpvar_13);
  out_Position_1.w = tmpvar_14.w;
  out_Position_1.xyz = (tmpvar_14.xyz + out_Offset_2);
  out_Position_1 = (CAMERA_PROJECTION * out_Position_1);
  highp vec4 tmpvar_15;
  tmpvar_15.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_15.y = DEVICE_COORDINATE_Y_FLIP;
  highp int tmpvar_16;
  highp int tmpvar_17;
  tmpvar_17 = int(_glesBinormal.x);
  highp int tmpvar_18;
  tmpvar_18 = int(_glesBinormal.z);
  tmpvar_16 = (tmpvar_18 / tmpvar_17);
  highp float tmpvar_19;
  tmpvar_19 = (float((tmpvar_18 - 
    (tmpvar_16 * tmpvar_17)
  )) / _glesBinormal.x);
  highp vec2 tmpvar_20;
  tmpvar_20.x = tmpvar_19;
  tmpvar_20.y = (float(tmpvar_16) / _glesBinormal.y);
  tmpvar_3.x = (tmpvar_19 + (_glesMultiTexCoord0.x * (1.0/(_glesBinormal.x))));
  tmpvar_3.y = (tmpvar_20.y + (_glesMultiTexCoord0.y * (1.0/(_glesBinormal.y))));
  xlv_TEXCOORD0 = tmpvar_3;
  gl_Position = (tmpvar_15 * out_Position_1);
  xlv_COLOR0 = _glesColor;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_COLOR0;
void main ()
{
  highp vec4 in_SurfaceColor_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  in_SurfaceColor_1 = tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3 = (in_SurfaceColor_1 * xlv_COLOR0);
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
}

end

