

#DEFPARAMS
_DiffuseTex = { "Diffuse Tex", TEXTURE2D, "white" },
_MetallicTex = {"Metallic Tex", TEXTURE2D, "white"},
_NormalTex = {"Normal Tex", TEXTURE2D, "bump"},
_RoughnessTex = {"Rough nessTex", TEXTURE2D, "white"},

_Opacity = { "Opacity", FLOAT, "1.0" },
_CutOff = { "CutOff", FLOAT, "0.0" },
_DiffuseValue = { "Diffuse Value", FLOAT, "1.0" },
_EmissiveValue = { "Emissive Value", FLOAT, "1.0" },
_NormalValue = { "Normal Value", FLOAT, "1.0" },
_MetallicValue = { "Metallic Value", FLOAT, "1.0" },
_RoughnessValue = { "Roughness Value", FLOAT, "1.0" },
_EmissiveColor = {"Emissive Color", COLOR, "1.0, 1.0, 1.0, 1.0"},

[Enum(RenderQueue)]
_RenderQueue = {"Render Queue", FLOAT, "1000"},
[Enum(BlendOnOff)]
_BlendState = {"Blend State", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
[Enum(DepthMode)]
_DepthMask = {"Depth Mask", FLOAT, "1.0"},
[Enum(CullMode)]
_CullMode = {"Cull Mode", FLOAT, "0.0"},
[Keywords(ALPHAPREMULTIPLY_ON, ALPHAPREMULTIPLY_OFF)]
_AlphaPreMultiply = {"Alpha Pre Multiply", FLOAT, "1.0"},
[Keywords(ALPHATEST_ON, ALPHATEST_OFF)]
_ALPHATEST_ON = {"Alpha Test On", FLOAT, "1.0"},





#END

#DEFTAG
ShaderName = "EmissionGloss"
RenderQueue = "%_RenderQueue"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { "%_CullMode", "%_DepthMask", DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#pragma multi_compile ALPHAPREMULTIPLY_ON ALPHAPREMULTIPLY_OFF
#pragma multi_compile ALPHATEST_ON ALPHATEST_OFF
#include "lightpbr.inc"

struct appdata
{
    float4 vertex : POSITION;
    float3 normal : NORMAL;
    float3 binoraml : BINORMAL;
    float3 tangent : TANGENT;
    float2 uv : TEXCOORD0;
    ANI_ATTRIBUTE
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 worldnormal : TEXCOORD1;
    float4 worldtangent : TEXCOORD2;
    float4 worldbinormal : TEXCOORD3;
    float4 screenPos : TEXCOORD5;
    float4 vertex : SV_POSITION;
    SHADOW_COORDS(4)
};

sampler2D _DiffuseTex;
sampler2D _MetallicTex;
sampler2D _NormalTex;
sampler2D _RoughnessTex;

float _CutOff;
float _Opacity;

float _DiffuseValue;
float _EmissiveValue;
float _NormalValue;
float _MetallicValue;
float _RoughnessValue;
float4 _EmissiveColor;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);

    v2f o;
    float4 pos = ObjectToClipPos(v.vertex);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
    o.screenPos = ComputeScreenPos(pos);
    o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
    o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
    o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

    o.worldnormal.w = worldpos.x;
    o.worldtangent.w = worldpos.y;
    o.worldbinormal.w = worldpos.z;

    TRANSFER_SHADOW(o, v.vertex);
    return o;
}

float4 frag(v2f i) : SV_Target
{
// sample the texture
    float4 col = tex2D(_DiffuseTex, i.uv);
	float4 diffuseColor = col*_DiffuseValue;
	float4 metallicColor = tex2D(_DiffuseTex, i.uv);
    float4 roughnessColor = tex2D(_RoughnessTex, i.uv);
	float4 normalColor = tex2D(_NormalTex, i.uv);
	float4 color0 = (0.0,0.0,1.0,0.0);
	
	float3 normalWorld = lerp(color0, normalColor, _NormalValue);
	
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	
    SurfaceStandardInput input;
	
	input.albedo = diffuseColor.rgb;
    input.metallic = metallicColor.r * _MetallicValue;
    input.smoothness = roughnessColor.a * _RoughnessValue;
    input.worldNormal = normalWorld; 
    input.worldPos = worldPos;
    input.emission = (diffuseColor*_EmissiveValue *_EmissiveColor).rgb;
    input.specularIbl = float3(0.0, 0.0, 0.0);
    input.diffuseIbl = float3(0.0, 0.0, 0.0);
    input.alpha = diffuseColor.a;
    input.atten = SHADOW_ATTEN(i);

    float4 outColor;
    outColor.xyz = PBR_LightCalc(input);
    #ifdef ALPHATEST_ON
    outColor.w = 1.0;
    if (col.a - _CutOff <= 0) {discard; }
#else
#ifdef ALPHAPREMULTIPLY_ON
outColor.w = input.alpha *  _Opacity;
#else
outColor.w = 1.0;
#endif
#endif

return outColor;
}
ENDCG

#END

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", ONE, ONE, ONE }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#pragma multi_compile ALPHATEST_ON ALPHATEST_OFF
#pragma multi_compile ALPHAPREMULTIPLY_ON ALPHAPREMULTIPLY_OFF
#include "lightpbr.inc"

struct appdata
{
    float4 vertex : POSITION;
    float3 normal : NORMAL;
    float3 binoraml : BINORMAL;
    float3 tangent : TANGENT;
    float2 uv : TEXCOORD0;
    ANI_ATTRIBUTE
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 worldnormal : TEXCOORD1;
    float4 worldtangent : TEXCOORD2;
    float4 worldbinormal : TEXCOORD3;
    float4 vertex : SV_POSITION;
    SHADOW_COORDS(4)
};

sampler2D _DiffuseTex;
sampler2D _MetallicTex;
sampler2D _NormalTex;
float _CutOff;
float _Opacity;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);

    v2f o;
    float4 pos = ObjectToClipPos(v.vertex);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
    o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
    o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
    o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

    o.worldnormal.w = worldpos.x;
    o.worldtangent.w = worldpos.y;
    o.worldbinormal.w = worldpos.z;

    TRANSFER_SHADOW(o, v.vertex);
    return o;
}

float4 frag(v2f i) : SV_Target
{
// sample the texture
    float4 col = tex2D(_DiffuseTex, i.uv);
    float2 mg = tex2D(_MetallicTex, i.uv).ra;
    float3 normalTangent = tex2D(_NormalTex, i.uv).rgb;
    normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
    float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldbinormal.xyz
+ normalTangent.z * i.worldnormal.xyz;
    normalWorld.xyz = normalize(normalWorld.xyz);

    SurfaceStandardInput input;
    input.albedo = col.rgb;
    input.metallic = mg.r * 0.5;
    input.smoothness = mg.g * 0.5;
    input.worldNormal = normalWorld; 
    input.worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
    input.emission = float3(0.0, 0.0, 0.0);
    input.atten = SHADOW_ATTEN(i);
    input.alpha = col.a;
    input.specularIbl = float3(0.0, 0.0, 0.0);
    input.diffuseIbl = float3(0.0, 0.0, 0.0);

	float4 outColor;
	outColor.xyz = PBR_LightCalc(input);
	outColor.w = 1.0;
	#ifdef ALPHATEST_ON
		outColor.w = 1.0;
		if (col.a - _CutOff <= 0) {discard; }
	#else
		#ifdef ALPHAPREMULTIPLY_ON
			outColor.w = input.alpha *  _Opacity;
		#else
			outColor.w = 1.0;
		#endif
	#endif
	
	return outColor;
}
ENDCG

#END

#DEFPASS Depth
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { DEPTHPASS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "lightpbr.inc"
#pragma multi_compile_skin
	#pragma multi_compile_skin

struct appdata
{
    float4 vertex : POSITION;
    float3 normal : NORMAL;
    ANI_ATTRIBUTE
};

struct v2f
{
    float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);

    float4 clipPos = ObjectToClipPos(v.vertex);
    clipPos = ApplyShadowBias(clipPos);

    v2f o;
    o.vertex = UniformNDC(clipPos);
    return o;
}

float4 frag(v2f i) : SV_Target
{
    return float4(0.0, 0.0, 0.0, 1.0);
}
ENDCG
#END

