

function DefineParams()
	Properties = 
	{
		
_DiffuseTex = { "Diffuse Tex", TEXTURE2D, "white" },
_MetallicTex = {"Metallic Tex", TEXTURE2D, "white"},
_NormalTex = {"Normal Tex", TEXTURE2D, "bump"},
_RoughnessTex = {"Rough nessTex", TEXTURE2D, "white"},

_Opacity = { "Opacity", FLOAT, "1.0" },
_CutOff = { "CutOff", FLOAT, "0.0" },
_DiffuseValue = { "Diffuse Value", FLOAT, "1.0" },
_EmissiveValue = { "Emissive Value", FLOAT, "1.0" },
_NormalValue = { "Normal Value", FLOAT, "1.0" },
_MetallicValue = { "Metallic Value", FLOAT, "1.0" },
_RoughnessValue = { "Roughness Value", FLOAT, "1.0" },
_EmissiveColor = {"Emissive Color", COLOR, "1.0, 1.0, 1.0, 1.0"},


_RenderQueue = {"Render Queue", FLOAT, "1000"},

_BlendState = {"Blend State", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},

_DepthMask = {"Depth Mask", FLOAT, "1.0"},

_CullMode = {"Cull Mode", FLOAT, "0.0"},

_AlphaPreMultiply = {"Alpha Pre Multiply", FLOAT, "1.0"},

_ALPHATEST_ON = {"Alpha Test On", FLOAT, "1.0"},






	}
	Attributes = 
	{
		_RenderQueue = "Enum(RenderQueue)", 
		_BlendState = "Enum(BlendOnOff)", 
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
		_DepthMask = "Enum(DepthMode)", 
		_CullMode = "Enum(CullMode)", 
		_AlphaPreMultiply = "Keywords(ALPHAPREMULTIPLY_ON,ALPHAPREMULTIPLY_OFF)", 
		_ALPHATEST_ON = "Keywords(ALPHATEST_ON,ALPHATEST_OFF)", 
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "EmissionGloss"
RenderQueue = "%_RenderQueue"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { "%_CullMode", "%_DepthMask", DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp vec4 o_15;
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_12 * 0.5);
  o_15.zw = tmpvar_16.zw;
  o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
  o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
  o_15.zw = tmpvar_12.zw;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_11[0].xyz;
  tmpvar_18[1] = tmpvar_11[1].xyz;
  tmpvar_18[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_11[0].xyz;
  tmpvar_20[1] = tmpvar_11[1].xyz;
  tmpvar_20[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_21[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_21[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[0] = tmpvar_11[0].xyz;
  tmpvar_22[1] = tmpvar_11[1].xyz;
  tmpvar_22[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_15;
  gl_Position = (tmpvar_13 * tmpvar_12);
}

]===],
		psShader = [===[uniform sampler2D _DiffuseTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _MetallicValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  mediump float tmpvar_2;
  highp vec4 metallicColor_3;
  highp vec4 col_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_4 = tmpvar_5;
  metallicColor_3 = tmpvar_5;
  tmpvar_2 = (metallicColor_3.x * _MetallicValue);
  highp float tmpvar_6;
  mediump float tmpvar_7;
  tmpvar_7 = (0.7790837 - (tmpvar_2 * 0.7790837));
  tmpvar_6 = 0.0;
  mediump float alpha_8;
  alpha_8 = tmpvar_6;
  mediump float outModifiedAlpha_9;
  outModifiedAlpha_9 = ((1.0 - tmpvar_7) + (alpha_8 * tmpvar_7));
  tmpvar_6 = outModifiedAlpha_9;
  outColor_1.xyz = ((col_4 * _DiffuseValue) * (_EmissiveValue * _EmissiveColor)).xyz;
  outColor_1.w = 1.0;
  if (((col_4.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp vec4 o_15;
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_12 * 0.5);
  o_15.zw = tmpvar_16.zw;
  o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
  o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
  o_15.zw = tmpvar_12.zw;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_11[0].xyz;
  tmpvar_18[1] = tmpvar_11[1].xyz;
  tmpvar_18[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_11[0].xyz;
  tmpvar_20[1] = tmpvar_11[1].xyz;
  tmpvar_20[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_21[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_21[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[0] = tmpvar_11[0].xyz;
  tmpvar_22[1] = tmpvar_11[1].xyz;
  tmpvar_22[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_15;
  gl_Position = (tmpvar_13 * tmpvar_12);
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec4 normalColor_5;
  highp vec4 roughnessColor_6;
  highp vec4 metallicColor_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (col_8 * _DiffuseValue);
  metallicColor_7 = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_6 = tmpvar_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_5 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_10.xyz;
  tmpvar_3 = (metallicColor_7.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_6.w * _RoughnessValue);
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (normalColor_5 * vec4(_NormalValue)).xyz;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_17;
  highp vec3 color_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  mediump float tmpvar_23;
  tmpvar_23 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_17 = 0.0;
  mediump vec3 diffColor_24;
  mediump float alpha_25;
  alpha_25 = tmpvar_17;
  mediump float outModifiedAlpha_26;
  diffColor_24 = ((albedo_21 * tmpvar_23) * alpha_25);
  outModifiedAlpha_26 = ((1.0 - tmpvar_23) + (alpha_25 * tmpvar_23));
  tmpvar_17 = outModifiedAlpha_26;
  mediump float tmpvar_27;
  tmpvar_27 = (1.0 - tmpvar_4);
  perceptualRoughness_20 = tmpvar_27;
  highp vec3 tmpvar_28;
  highp vec3 inVec_29;
  inVec_29 = (tmpvar_15 + tmpvar_14);
  tmpvar_28 = (inVec_29 * inversesqrt(max (0.001, 
    dot (inVec_29, inVec_29)
  )));
  highp float tmpvar_30;
  tmpvar_30 = abs(dot (tmpvar_14, tmpvar_16));
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_16, tmpvar_15), 0.0, 1.0);
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_16, tmpvar_28), 0.0, 1.0);
  mediump float tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = clamp (dot (tmpvar_15, tmpvar_28), 0.0, 1.0);
  tmpvar_33 = tmpvar_34;
  mediump float tmpvar_35;
  mediump float NdotV_36;
  NdotV_36 = tmpvar_30;
  mediump float NdotL_37;
  NdotL_37 = tmpvar_31;
  mediump float perceptualRoughness_38;
  perceptualRoughness_38 = perceptualRoughness_20;
  mediump float tmpvar_39;
  tmpvar_39 = (0.5 + ((2.0 * tmpvar_33) * (tmpvar_33 * perceptualRoughness_38)));
  mediump float x_40;
  x_40 = (1.0 - NdotL_37);
  mediump float x_41;
  x_41 = (1.0 - NdotV_36);
  tmpvar_35 = ((1.0 + (
    (tmpvar_39 - 1.0)
   * 
    ((x_40 * x_40) * ((x_40 * x_40) * x_40))
  )) * (1.0 + (
    (tmpvar_39 - 1.0)
   * 
    ((x_41 * x_41) * ((x_41 * x_41) * x_41))
  )));
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_35 * tmpvar_31);
  diffuseTerm_19 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_44;
  tmpvar_44 = (tmpvar_43 * tmpvar_43);
  highp float tmpvar_45;
  tmpvar_45 = (((
    (tmpvar_32 * tmpvar_44)
   - tmpvar_32) * tmpvar_32) + 1.0);
  mediump vec3 tmpvar_46;
  mediump float x_47;
  x_47 = (1.0 - tmpvar_33);
  tmpvar_46 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_47 * x_47)
   * 
    ((x_47 * x_47) * x_47)
  )));
  color_18 = (((diffColor_24 * LIGHT_COLOR) * diffuseTerm_19) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_44) / (
        (tmpvar_45 * tmpvar_45)
       + 1e-7)) * (0.5 / (
        ((tmpvar_31 * ((tmpvar_30 * 
          (1.0 - tmpvar_43)
        ) + tmpvar_43)) + (tmpvar_30 * ((tmpvar_31 * 
          (1.0 - tmpvar_43)
        ) + tmpvar_43)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_31))
   * LIGHT_COLOR) * tmpvar_46));
  color_18 = (color_18 + ((tmpvar_10 * _EmissiveValue) * _EmissiveColor).xyz);
  outColor_1.xyz = color_18;
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_18;
    highp vec2 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_23.x);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_23.x, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_23.x, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec4 computedWeight_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_23.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_23.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_23.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    computedWeight_31 = (computedArea_32 * 0.44444);
    highp vec2 tmpvar_38;
    tmpvar_38 = (computedWeight_24.xz + computedWeight_24.yw);
    highp vec2 tmpvar_39;
    tmpvar_39 = (computedWeight_31.xz + computedWeight_31.yw);
    fetchesOffsetsU_19 = (((computedWeight_24.yw / tmpvar_38) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_18 = (((computedWeight_31.yw / tmpvar_39) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_19.x;
    tmpvar_41.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_16.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_20 = ((tmpvar_38.x * tmpvar_39.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_19.y;
    tmpvar_44.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_19.x;
    tmpvar_47.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_16.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_20 = (shadow_20 + ((tmpvar_38.x * tmpvar_39.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_19.y;
    tmpvar_50.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_16.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.y) * tmpvar_52));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  highp vec3 color_56;
  mediump float diffuseTerm_57;
  highp float perceptualRoughness_58;
  mediump vec3 albedo_59;
  albedo_59 = tmpvar_2;
  mediump vec3 specColor_60;
  specColor_60 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_59 * tmpvar_3));
  mediump float tmpvar_61;
  tmpvar_61 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_55 = 0.0;
  mediump vec3 diffColor_62;
  mediump float alpha_63;
  alpha_63 = tmpvar_55;
  mediump float outModifiedAlpha_64;
  diffColor_62 = ((albedo_59 * tmpvar_61) * alpha_63);
  outModifiedAlpha_64 = ((1.0 - tmpvar_61) + (alpha_63 * tmpvar_61));
  tmpvar_55 = outModifiedAlpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_58 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (tmpvar_54 + tmpvar_53);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_6, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_54, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_58;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_57 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_58 * perceptualRoughness_58), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_60 + ((1.0 - specColor_60) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  color_56 = (((
    (diffColor_62 * LIGHT_COLOR)
   * diffuseTerm_57) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * tmpvar_17);
  color_56 = (color_56 + tmpvar_5);
  outColor_1.xyz = color_56;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_18;
    highp vec3 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 texelsWeightsA_32;
    highp vec3 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.16 * tmpvar_37);
    texelsWeightsA_32.y = (0.16 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.16 * (computedArea_34.y + 1.0));
    texelsWeightsB_33.x = (0.16 * (computedArea_34.z + 1.0));
    texelsWeightsB_33.y = (0.16 * computedAreaUncut_35.z);
    texelsWeightsB_33.z = (0.16 * tmpvar_36);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_24.y;
    tmpvar_41.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.z = texelsWeightsB_33.y;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_32.y;
    tmpvar_44.yz = texelsWeightsB_33.xz;
    highp vec3 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec3 tmpvar_46;
    tmpvar_46.x = texelsWeightsA_24.y;
    tmpvar_46.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_47;
    tmpvar_47.x = texelsWeightsA_32.y;
    tmpvar_47.yz = texelsWeightsB_33.xz;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.x;
    tmpvar_58.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.y;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.z;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.x;
    tmpvar_67.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.y;
    tmpvar_70.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.z;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_75));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_76 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_78;
  highp vec3 color_79;
  mediump float diffuseTerm_80;
  highp float perceptualRoughness_81;
  mediump vec3 albedo_82;
  albedo_82 = tmpvar_2;
  mediump vec3 specColor_83;
  specColor_83 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_82 * tmpvar_3));
  mediump float tmpvar_84;
  tmpvar_84 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_78 = 0.0;
  mediump vec3 diffColor_85;
  mediump float alpha_86;
  alpha_86 = tmpvar_78;
  mediump float outModifiedAlpha_87;
  diffColor_85 = ((albedo_82 * tmpvar_84) * alpha_86);
  outModifiedAlpha_87 = ((1.0 - tmpvar_84) + (alpha_86 * tmpvar_84));
  tmpvar_78 = outModifiedAlpha_87;
  mediump float tmpvar_88;
  tmpvar_88 = (1.0 - tmpvar_4);
  perceptualRoughness_81 = tmpvar_88;
  highp vec3 tmpvar_89;
  highp vec3 inVec_90;
  inVec_90 = (tmpvar_77 + tmpvar_76);
  tmpvar_89 = (inVec_90 * inversesqrt(max (0.001, 
    dot (inVec_90, inVec_90)
  )));
  highp float tmpvar_91;
  tmpvar_91 = abs(dot (tmpvar_76, tmpvar_6));
  highp float tmpvar_92;
  tmpvar_92 = clamp (dot (tmpvar_6, tmpvar_77), 0.0, 1.0);
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_6, tmpvar_89), 0.0, 1.0);
  mediump float tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = clamp (dot (tmpvar_77, tmpvar_89), 0.0, 1.0);
  tmpvar_94 = tmpvar_95;
  mediump float tmpvar_96;
  mediump float NdotV_97;
  NdotV_97 = tmpvar_91;
  mediump float NdotL_98;
  NdotL_98 = tmpvar_92;
  mediump float perceptualRoughness_99;
  perceptualRoughness_99 = perceptualRoughness_81;
  mediump float tmpvar_100;
  tmpvar_100 = (0.5 + ((2.0 * tmpvar_94) * (tmpvar_94 * perceptualRoughness_99)));
  mediump float x_101;
  x_101 = (1.0 - NdotL_98);
  mediump float x_102;
  x_102 = (1.0 - NdotV_97);
  tmpvar_96 = ((1.0 + (
    (tmpvar_100 - 1.0)
   * 
    ((x_101 * x_101) * ((x_101 * x_101) * x_101))
  )) * (1.0 + (
    (tmpvar_100 - 1.0)
   * 
    ((x_102 * x_102) * ((x_102 * x_102) * x_102))
  )));
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_96 * tmpvar_92);
  diffuseTerm_80 = tmpvar_103;
  highp float tmpvar_104;
  tmpvar_104 = max ((perceptualRoughness_81 * perceptualRoughness_81), 0.002);
  highp float tmpvar_105;
  tmpvar_105 = (tmpvar_104 * tmpvar_104);
  highp float tmpvar_106;
  tmpvar_106 = (((
    (tmpvar_93 * tmpvar_105)
   - tmpvar_93) * tmpvar_93) + 1.0);
  mediump vec3 tmpvar_107;
  mediump float x_108;
  x_108 = (1.0 - tmpvar_94);
  tmpvar_107 = (specColor_83 + ((1.0 - specColor_83) * (
    (x_108 * x_108)
   * 
    ((x_108 * x_108) * x_108)
  )));
  color_79 = (((
    (diffColor_85 * LIGHT_COLOR)
   * diffuseTerm_80) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_105)
       / 
        ((tmpvar_106 * tmpvar_106) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_92 * (
          (tmpvar_91 * (1.0 - tmpvar_104))
         + tmpvar_104)) + (tmpvar_91 * (
          (tmpvar_92 * (1.0 - tmpvar_104))
         + tmpvar_104))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_92)) * LIGHT_COLOR)
   * tmpvar_107)) * tmpvar_17);
  color_79 = (color_79 + tmpvar_5);
  outColor_1.xyz = color_79;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_18;
    highp vec4 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 texelsWeightsA_32;
    highp vec4 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.081632 * tmpvar_37);
    texelsWeightsA_32.y = (0.081632 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.081632 * (computedAreaUncut_35.y + 1.0));
    texelsWeightsA_32.w = (0.081632 * (computedArea_34.y + 2.0));
    texelsWeightsB_33.x = (0.081632 * (computedArea_34.z + 2.0));
    texelsWeightsB_33.y = (0.081632 * (computedAreaUncut_35.z + 1.0));
    texelsWeightsB_33.z = (0.081632 * computedAreaUncut_35.z);
    texelsWeightsB_33.w = (0.081632 * tmpvar_36);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_24.yw;
    tmpvar_41.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.zw = texelsWeightsB_33.xz;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_32.yw;
    tmpvar_44.zw = texelsWeightsB_33.yw;
    highp vec4 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec4 tmpvar_46;
    tmpvar_46.xy = texelsWeightsA_24.yw;
    tmpvar_46.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_47;
    tmpvar_47.xy = texelsWeightsA_32.yw;
    tmpvar_47.zw = texelsWeightsB_33.yw;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.w;
    tmpvar_58.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.x;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.y;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.z;
    tmpvar_67.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.w;
    tmpvar_70.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.y) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.x;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_19.y;
    tmpvar_76.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_48 + tmpvar_76);
    tmpvar_77.z = shadowCoord_16.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_19.z;
    tmpvar_79.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_48 + tmpvar_79);
    tmpvar_80.z = shadowCoord_16.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_19.w;
    tmpvar_82.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_48 + tmpvar_82);
    tmpvar_83.z = shadowCoord_16.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.z) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_19.x;
    tmpvar_85.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_48 + tmpvar_85);
    tmpvar_86.z = shadowCoord_16.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_19.y;
    tmpvar_88.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_48 + tmpvar_88);
    tmpvar_89.z = shadowCoord_16.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_19.z;
    tmpvar_91.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_48 + tmpvar_91);
    tmpvar_92.z = shadowCoord_16.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.w) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_19.w;
    tmpvar_94.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_48 + tmpvar_94);
    tmpvar_95.z = shadowCoord_16.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.w) * tmpvar_96));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_97 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_99;
  highp vec3 color_100;
  mediump float diffuseTerm_101;
  highp float perceptualRoughness_102;
  mediump vec3 albedo_103;
  albedo_103 = tmpvar_2;
  mediump vec3 specColor_104;
  specColor_104 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_103 * tmpvar_3));
  mediump float tmpvar_105;
  tmpvar_105 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_99 = 0.0;
  mediump vec3 diffColor_106;
  mediump float alpha_107;
  alpha_107 = tmpvar_99;
  mediump float outModifiedAlpha_108;
  diffColor_106 = ((albedo_103 * tmpvar_105) * alpha_107);
  outModifiedAlpha_108 = ((1.0 - tmpvar_105) + (alpha_107 * tmpvar_105));
  tmpvar_99 = outModifiedAlpha_108;
  mediump float tmpvar_109;
  tmpvar_109 = (1.0 - tmpvar_4);
  perceptualRoughness_102 = tmpvar_109;
  highp vec3 tmpvar_110;
  highp vec3 inVec_111;
  inVec_111 = (tmpvar_98 + tmpvar_97);
  tmpvar_110 = (inVec_111 * inversesqrt(max (0.001, 
    dot (inVec_111, inVec_111)
  )));
  highp float tmpvar_112;
  tmpvar_112 = abs(dot (tmpvar_97, tmpvar_6));
  highp float tmpvar_113;
  tmpvar_113 = clamp (dot (tmpvar_6, tmpvar_98), 0.0, 1.0);
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_6, tmpvar_110), 0.0, 1.0);
  mediump float tmpvar_115;
  highp float tmpvar_116;
  tmpvar_116 = clamp (dot (tmpvar_98, tmpvar_110), 0.0, 1.0);
  tmpvar_115 = tmpvar_116;
  mediump float tmpvar_117;
  mediump float NdotV_118;
  NdotV_118 = tmpvar_112;
  mediump float NdotL_119;
  NdotL_119 = tmpvar_113;
  mediump float perceptualRoughness_120;
  perceptualRoughness_120 = perceptualRoughness_102;
  mediump float tmpvar_121;
  tmpvar_121 = (0.5 + ((2.0 * tmpvar_115) * (tmpvar_115 * perceptualRoughness_120)));
  mediump float x_122;
  x_122 = (1.0 - NdotL_119);
  mediump float x_123;
  x_123 = (1.0 - NdotV_118);
  tmpvar_117 = ((1.0 + (
    (tmpvar_121 - 1.0)
   * 
    ((x_122 * x_122) * ((x_122 * x_122) * x_122))
  )) * (1.0 + (
    (tmpvar_121 - 1.0)
   * 
    ((x_123 * x_123) * ((x_123 * x_123) * x_123))
  )));
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_117 * tmpvar_113);
  diffuseTerm_101 = tmpvar_124;
  highp float tmpvar_125;
  tmpvar_125 = max ((perceptualRoughness_102 * perceptualRoughness_102), 0.002);
  highp float tmpvar_126;
  tmpvar_126 = (tmpvar_125 * tmpvar_125);
  highp float tmpvar_127;
  tmpvar_127 = (((
    (tmpvar_114 * tmpvar_126)
   - tmpvar_114) * tmpvar_114) + 1.0);
  mediump vec3 tmpvar_128;
  mediump float x_129;
  x_129 = (1.0 - tmpvar_115);
  tmpvar_128 = (specColor_104 + ((1.0 - specColor_104) * (
    (x_129 * x_129)
   * 
    ((x_129 * x_129) * x_129)
  )));
  color_100 = (((
    (diffColor_106 * LIGHT_COLOR)
   * diffuseTerm_101) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_126)
       / 
        ((tmpvar_127 * tmpvar_127) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_113 * (
          (tmpvar_112 * (1.0 - tmpvar_125))
         + tmpvar_125)) + (tmpvar_112 * (
          (tmpvar_113 * (1.0 - tmpvar_125))
         + tmpvar_125))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_113)) * LIGHT_COLOR)
   * tmpvar_128)) * tmpvar_17);
  color_100 = (color_100 + tmpvar_5);
  outColor_1.xyz = color_100;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    highp vec2 tmpvar_18;
    tmpvar_18.x = LIGHT_PARAM.z;
    tmpvar_18.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_19;
    tmpvar_19.xy = tmpvar_18;
    highp float tmpvar_20;
    tmpvar_20 = (1.0/(LIGHT_PARAM.z));
    tmpvar_19.z = tmpvar_20;
    tmpvar_19.w = tmpvar_20;
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_21;
    highp vec2 tmpvar_22;
    tmpvar_22 = tmpvar_19.xy;
    shadow_21 = 0.0;
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_16.xy - LIGHT_PARAM.zz);
    tmpvar_23.z = shadowCoord_16.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_21 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_16.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_16.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_21 = (tmpvar_25 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_22.x;
    tmpvar_30.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_16.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_16.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_33);
    highp vec2 tmpvar_34;
    tmpvar_34.y = 0.0;
    tmpvar_34.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (shadowCoord_16.xy + tmpvar_34);
    tmpvar_35.z = shadowCoord_16.z;
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_37);
    highp vec4 tmpvar_38;
    tmpvar_38 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_16.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.y = 0.0;
    tmpvar_40.x = tmpvar_22.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_16.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_16.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = -(LIGHT_PARAM.z);
    tmpvar_44.y = tmpvar_22.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_16.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = 0.0;
    tmpvar_48.y = tmpvar_22.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_16.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_16.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_51);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_16.xy + LIGHT_PARAM.zz);
    tmpvar_52.z = shadowCoord_16.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_54);
    shadow_21 = (shadow_21 / 9.0);
    tmpvar_17 = mix (1.0, shadow_21, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_57;
  highp vec3 color_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 albedo_61;
  albedo_61 = tmpvar_2;
  mediump vec3 specColor_62;
  specColor_62 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_61 * tmpvar_3));
  mediump float tmpvar_63;
  tmpvar_63 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_57 = 0.0;
  mediump vec3 diffColor_64;
  mediump float alpha_65;
  alpha_65 = tmpvar_57;
  mediump float outModifiedAlpha_66;
  diffColor_64 = ((albedo_61 * tmpvar_63) * alpha_65);
  outModifiedAlpha_66 = ((1.0 - tmpvar_63) + (alpha_65 * tmpvar_63));
  tmpvar_57 = outModifiedAlpha_66;
  mediump float tmpvar_67;
  tmpvar_67 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_67;
  highp vec3 tmpvar_68;
  highp vec3 inVec_69;
  inVec_69 = (tmpvar_56 + tmpvar_55);
  tmpvar_68 = (inVec_69 * inversesqrt(max (0.001, 
    dot (inVec_69, inVec_69)
  )));
  highp float tmpvar_70;
  tmpvar_70 = abs(dot (tmpvar_55, tmpvar_6));
  highp float tmpvar_71;
  tmpvar_71 = clamp (dot (tmpvar_6, tmpvar_56), 0.0, 1.0);
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_6, tmpvar_68), 0.0, 1.0);
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = clamp (dot (tmpvar_56, tmpvar_68), 0.0, 1.0);
  tmpvar_73 = tmpvar_74;
  mediump float tmpvar_75;
  mediump float NdotV_76;
  NdotV_76 = tmpvar_70;
  mediump float NdotL_77;
  NdotL_77 = tmpvar_71;
  mediump float perceptualRoughness_78;
  perceptualRoughness_78 = perceptualRoughness_60;
  mediump float tmpvar_79;
  tmpvar_79 = (0.5 + ((2.0 * tmpvar_73) * (tmpvar_73 * perceptualRoughness_78)));
  mediump float x_80;
  x_80 = (1.0 - NdotL_77);
  mediump float x_81;
  x_81 = (1.0 - NdotV_76);
  tmpvar_75 = ((1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_80 * x_80) * ((x_80 * x_80) * x_80))
  )) * (1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_81 * x_81) * ((x_81 * x_81) * x_81))
  )));
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_75 * tmpvar_71);
  diffuseTerm_59 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_84;
  tmpvar_84 = (tmpvar_83 * tmpvar_83);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_72 * tmpvar_84)
   - tmpvar_72) * tmpvar_72) + 1.0);
  mediump vec3 tmpvar_86;
  mediump float x_87;
  x_87 = (1.0 - tmpvar_73);
  tmpvar_86 = (specColor_62 + ((1.0 - specColor_62) * (
    (x_87 * x_87)
   * 
    ((x_87 * x_87) * x_87)
  )));
  color_58 = (((
    (diffColor_64 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_84)
       / 
        ((tmpvar_85 * tmpvar_85) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_71 * (
          (tmpvar_70 * (1.0 - tmpvar_83))
         + tmpvar_83)) + (tmpvar_70 * (
          (tmpvar_71 * (1.0 - tmpvar_83))
         + tmpvar_83))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_71)) * LIGHT_COLOR)
   * tmpvar_86)) * tmpvar_17);
  color_58 = (color_58 + tmpvar_5);
  outColor_1.xyz = color_58;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp vec4 o_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_5 * 0.5);
  o_10.zw = tmpvar_11.zw;
  o_10.xy = (tmpvar_11.xy + tmpvar_11.ww);
  o_10.y = ((2.0 * tmpvar_11.w) - o_10.y);
  o_10.zw = tmpvar_5.zw;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_10;
  gl_Position = (tmpvar_7 * tmpvar_5);
}

]===],
		psShader = [===[uniform sampler2D _DiffuseTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _MetallicValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  mediump float tmpvar_2;
  highp vec4 metallicColor_3;
  highp vec4 col_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_4 = tmpvar_5;
  metallicColor_3 = tmpvar_5;
  tmpvar_2 = (metallicColor_3.x * _MetallicValue);
  highp float tmpvar_6;
  mediump float tmpvar_7;
  tmpvar_7 = (0.7790837 - (tmpvar_2 * 0.7790837));
  tmpvar_6 = 0.0;
  mediump float alpha_8;
  alpha_8 = tmpvar_6;
  mediump float outModifiedAlpha_9;
  outModifiedAlpha_9 = ((1.0 - tmpvar_7) + (alpha_8 * tmpvar_7));
  tmpvar_6 = outModifiedAlpha_9;
  outColor_1.xyz = ((col_4 * _DiffuseValue) * (_EmissiveValue * _EmissiveColor)).xyz;
  outColor_1.w = 1.0;
  if (((col_4.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp vec4 o_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_5 * 0.5);
  o_10.zw = tmpvar_11.zw;
  o_10.xy = (tmpvar_11.xy + tmpvar_11.ww);
  o_10.y = ((2.0 * tmpvar_11.w) - o_10.y);
  o_10.zw = tmpvar_5.zw;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_10;
  gl_Position = (tmpvar_7 * tmpvar_5);
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec4 normalColor_5;
  highp vec4 roughnessColor_6;
  highp vec4 metallicColor_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (col_8 * _DiffuseValue);
  metallicColor_7 = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_6 = tmpvar_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_5 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_10.xyz;
  tmpvar_3 = (metallicColor_7.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_6.w * _RoughnessValue);
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (normalColor_5 * vec4(_NormalValue)).xyz;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_17;
  highp vec3 color_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  mediump float tmpvar_23;
  tmpvar_23 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_17 = 0.0;
  mediump vec3 diffColor_24;
  mediump float alpha_25;
  alpha_25 = tmpvar_17;
  mediump float outModifiedAlpha_26;
  diffColor_24 = ((albedo_21 * tmpvar_23) * alpha_25);
  outModifiedAlpha_26 = ((1.0 - tmpvar_23) + (alpha_25 * tmpvar_23));
  tmpvar_17 = outModifiedAlpha_26;
  mediump float tmpvar_27;
  tmpvar_27 = (1.0 - tmpvar_4);
  perceptualRoughness_20 = tmpvar_27;
  highp vec3 tmpvar_28;
  highp vec3 inVec_29;
  inVec_29 = (tmpvar_15 + tmpvar_14);
  tmpvar_28 = (inVec_29 * inversesqrt(max (0.001, 
    dot (inVec_29, inVec_29)
  )));
  highp float tmpvar_30;
  tmpvar_30 = abs(dot (tmpvar_14, tmpvar_16));
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_16, tmpvar_15), 0.0, 1.0);
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_16, tmpvar_28), 0.0, 1.0);
  mediump float tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = clamp (dot (tmpvar_15, tmpvar_28), 0.0, 1.0);
  tmpvar_33 = tmpvar_34;
  mediump float tmpvar_35;
  mediump float NdotV_36;
  NdotV_36 = tmpvar_30;
  mediump float NdotL_37;
  NdotL_37 = tmpvar_31;
  mediump float perceptualRoughness_38;
  perceptualRoughness_38 = perceptualRoughness_20;
  mediump float tmpvar_39;
  tmpvar_39 = (0.5 + ((2.0 * tmpvar_33) * (tmpvar_33 * perceptualRoughness_38)));
  mediump float x_40;
  x_40 = (1.0 - NdotL_37);
  mediump float x_41;
  x_41 = (1.0 - NdotV_36);
  tmpvar_35 = ((1.0 + (
    (tmpvar_39 - 1.0)
   * 
    ((x_40 * x_40) * ((x_40 * x_40) * x_40))
  )) * (1.0 + (
    (tmpvar_39 - 1.0)
   * 
    ((x_41 * x_41) * ((x_41 * x_41) * x_41))
  )));
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_35 * tmpvar_31);
  diffuseTerm_19 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_44;
  tmpvar_44 = (tmpvar_43 * tmpvar_43);
  highp float tmpvar_45;
  tmpvar_45 = (((
    (tmpvar_32 * tmpvar_44)
   - tmpvar_32) * tmpvar_32) + 1.0);
  mediump vec3 tmpvar_46;
  mediump float x_47;
  x_47 = (1.0 - tmpvar_33);
  tmpvar_46 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_47 * x_47)
   * 
    ((x_47 * x_47) * x_47)
  )));
  color_18 = (((diffColor_24 * LIGHT_COLOR) * diffuseTerm_19) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_44) / (
        (tmpvar_45 * tmpvar_45)
       + 1e-7)) * (0.5 / (
        ((tmpvar_31 * ((tmpvar_30 * 
          (1.0 - tmpvar_43)
        ) + tmpvar_43)) + (tmpvar_30 * ((tmpvar_31 * 
          (1.0 - tmpvar_43)
        ) + tmpvar_43)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_31))
   * LIGHT_COLOR) * tmpvar_46));
  color_18 = (color_18 + ((tmpvar_10 * _EmissiveValue) * _EmissiveColor).xyz);
  outColor_1.xyz = color_18;
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_18;
    highp vec2 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_23.x);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_23.x, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_23.x, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec4 computedWeight_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_23.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_23.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_23.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    computedWeight_31 = (computedArea_32 * 0.44444);
    highp vec2 tmpvar_38;
    tmpvar_38 = (computedWeight_24.xz + computedWeight_24.yw);
    highp vec2 tmpvar_39;
    tmpvar_39 = (computedWeight_31.xz + computedWeight_31.yw);
    fetchesOffsetsU_19 = (((computedWeight_24.yw / tmpvar_38) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_18 = (((computedWeight_31.yw / tmpvar_39) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_19.x;
    tmpvar_41.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_16.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_20 = ((tmpvar_38.x * tmpvar_39.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_19.y;
    tmpvar_44.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_19.x;
    tmpvar_47.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_16.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_20 = (shadow_20 + ((tmpvar_38.x * tmpvar_39.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_19.y;
    tmpvar_50.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_16.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.y) * tmpvar_52));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  highp vec3 color_56;
  mediump float diffuseTerm_57;
  highp float perceptualRoughness_58;
  mediump vec3 albedo_59;
  albedo_59 = tmpvar_2;
  mediump vec3 specColor_60;
  specColor_60 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_59 * tmpvar_3));
  mediump float tmpvar_61;
  tmpvar_61 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_55 = 0.0;
  mediump vec3 diffColor_62;
  mediump float alpha_63;
  alpha_63 = tmpvar_55;
  mediump float outModifiedAlpha_64;
  diffColor_62 = ((albedo_59 * tmpvar_61) * alpha_63);
  outModifiedAlpha_64 = ((1.0 - tmpvar_61) + (alpha_63 * tmpvar_61));
  tmpvar_55 = outModifiedAlpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_58 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (tmpvar_54 + tmpvar_53);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_6, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_54, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_58;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_57 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_58 * perceptualRoughness_58), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_60 + ((1.0 - specColor_60) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  color_56 = (((
    (diffColor_62 * LIGHT_COLOR)
   * diffuseTerm_57) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * tmpvar_17);
  color_56 = (color_56 + tmpvar_5);
  outColor_1.xyz = color_56;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_18;
    highp vec3 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 texelsWeightsA_32;
    highp vec3 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.16 * tmpvar_37);
    texelsWeightsA_32.y = (0.16 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.16 * (computedArea_34.y + 1.0));
    texelsWeightsB_33.x = (0.16 * (computedArea_34.z + 1.0));
    texelsWeightsB_33.y = (0.16 * computedAreaUncut_35.z);
    texelsWeightsB_33.z = (0.16 * tmpvar_36);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_24.y;
    tmpvar_41.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.z = texelsWeightsB_33.y;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_32.y;
    tmpvar_44.yz = texelsWeightsB_33.xz;
    highp vec3 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec3 tmpvar_46;
    tmpvar_46.x = texelsWeightsA_24.y;
    tmpvar_46.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_47;
    tmpvar_47.x = texelsWeightsA_32.y;
    tmpvar_47.yz = texelsWeightsB_33.xz;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.x;
    tmpvar_58.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.y;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.z;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.x;
    tmpvar_67.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.y;
    tmpvar_70.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.z;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_75));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_76 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_78;
  highp vec3 color_79;
  mediump float diffuseTerm_80;
  highp float perceptualRoughness_81;
  mediump vec3 albedo_82;
  albedo_82 = tmpvar_2;
  mediump vec3 specColor_83;
  specColor_83 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_82 * tmpvar_3));
  mediump float tmpvar_84;
  tmpvar_84 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_78 = 0.0;
  mediump vec3 diffColor_85;
  mediump float alpha_86;
  alpha_86 = tmpvar_78;
  mediump float outModifiedAlpha_87;
  diffColor_85 = ((albedo_82 * tmpvar_84) * alpha_86);
  outModifiedAlpha_87 = ((1.0 - tmpvar_84) + (alpha_86 * tmpvar_84));
  tmpvar_78 = outModifiedAlpha_87;
  mediump float tmpvar_88;
  tmpvar_88 = (1.0 - tmpvar_4);
  perceptualRoughness_81 = tmpvar_88;
  highp vec3 tmpvar_89;
  highp vec3 inVec_90;
  inVec_90 = (tmpvar_77 + tmpvar_76);
  tmpvar_89 = (inVec_90 * inversesqrt(max (0.001, 
    dot (inVec_90, inVec_90)
  )));
  highp float tmpvar_91;
  tmpvar_91 = abs(dot (tmpvar_76, tmpvar_6));
  highp float tmpvar_92;
  tmpvar_92 = clamp (dot (tmpvar_6, tmpvar_77), 0.0, 1.0);
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_6, tmpvar_89), 0.0, 1.0);
  mediump float tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = clamp (dot (tmpvar_77, tmpvar_89), 0.0, 1.0);
  tmpvar_94 = tmpvar_95;
  mediump float tmpvar_96;
  mediump float NdotV_97;
  NdotV_97 = tmpvar_91;
  mediump float NdotL_98;
  NdotL_98 = tmpvar_92;
  mediump float perceptualRoughness_99;
  perceptualRoughness_99 = perceptualRoughness_81;
  mediump float tmpvar_100;
  tmpvar_100 = (0.5 + ((2.0 * tmpvar_94) * (tmpvar_94 * perceptualRoughness_99)));
  mediump float x_101;
  x_101 = (1.0 - NdotL_98);
  mediump float x_102;
  x_102 = (1.0 - NdotV_97);
  tmpvar_96 = ((1.0 + (
    (tmpvar_100 - 1.0)
   * 
    ((x_101 * x_101) * ((x_101 * x_101) * x_101))
  )) * (1.0 + (
    (tmpvar_100 - 1.0)
   * 
    ((x_102 * x_102) * ((x_102 * x_102) * x_102))
  )));
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_96 * tmpvar_92);
  diffuseTerm_80 = tmpvar_103;
  highp float tmpvar_104;
  tmpvar_104 = max ((perceptualRoughness_81 * perceptualRoughness_81), 0.002);
  highp float tmpvar_105;
  tmpvar_105 = (tmpvar_104 * tmpvar_104);
  highp float tmpvar_106;
  tmpvar_106 = (((
    (tmpvar_93 * tmpvar_105)
   - tmpvar_93) * tmpvar_93) + 1.0);
  mediump vec3 tmpvar_107;
  mediump float x_108;
  x_108 = (1.0 - tmpvar_94);
  tmpvar_107 = (specColor_83 + ((1.0 - specColor_83) * (
    (x_108 * x_108)
   * 
    ((x_108 * x_108) * x_108)
  )));
  color_79 = (((
    (diffColor_85 * LIGHT_COLOR)
   * diffuseTerm_80) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_105)
       / 
        ((tmpvar_106 * tmpvar_106) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_92 * (
          (tmpvar_91 * (1.0 - tmpvar_104))
         + tmpvar_104)) + (tmpvar_91 * (
          (tmpvar_92 * (1.0 - tmpvar_104))
         + tmpvar_104))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_92)) * LIGHT_COLOR)
   * tmpvar_107)) * tmpvar_17);
  color_79 = (color_79 + tmpvar_5);
  outColor_1.xyz = color_79;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_18;
    highp vec4 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 texelsWeightsA_32;
    highp vec4 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.081632 * tmpvar_37);
    texelsWeightsA_32.y = (0.081632 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.081632 * (computedAreaUncut_35.y + 1.0));
    texelsWeightsA_32.w = (0.081632 * (computedArea_34.y + 2.0));
    texelsWeightsB_33.x = (0.081632 * (computedArea_34.z + 2.0));
    texelsWeightsB_33.y = (0.081632 * (computedAreaUncut_35.z + 1.0));
    texelsWeightsB_33.z = (0.081632 * computedAreaUncut_35.z);
    texelsWeightsB_33.w = (0.081632 * tmpvar_36);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_24.yw;
    tmpvar_41.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.zw = texelsWeightsB_33.xz;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_32.yw;
    tmpvar_44.zw = texelsWeightsB_33.yw;
    highp vec4 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec4 tmpvar_46;
    tmpvar_46.xy = texelsWeightsA_24.yw;
    tmpvar_46.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_47;
    tmpvar_47.xy = texelsWeightsA_32.yw;
    tmpvar_47.zw = texelsWeightsB_33.yw;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.w;
    tmpvar_58.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.x;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.y;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.z;
    tmpvar_67.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.w;
    tmpvar_70.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.y) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.x;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_19.y;
    tmpvar_76.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_48 + tmpvar_76);
    tmpvar_77.z = shadowCoord_16.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_19.z;
    tmpvar_79.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_48 + tmpvar_79);
    tmpvar_80.z = shadowCoord_16.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_19.w;
    tmpvar_82.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_48 + tmpvar_82);
    tmpvar_83.z = shadowCoord_16.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.z) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_19.x;
    tmpvar_85.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_48 + tmpvar_85);
    tmpvar_86.z = shadowCoord_16.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_19.y;
    tmpvar_88.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_48 + tmpvar_88);
    tmpvar_89.z = shadowCoord_16.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_19.z;
    tmpvar_91.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_48 + tmpvar_91);
    tmpvar_92.z = shadowCoord_16.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.w) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_19.w;
    tmpvar_94.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_48 + tmpvar_94);
    tmpvar_95.z = shadowCoord_16.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.w) * tmpvar_96));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_97 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_99;
  highp vec3 color_100;
  mediump float diffuseTerm_101;
  highp float perceptualRoughness_102;
  mediump vec3 albedo_103;
  albedo_103 = tmpvar_2;
  mediump vec3 specColor_104;
  specColor_104 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_103 * tmpvar_3));
  mediump float tmpvar_105;
  tmpvar_105 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_99 = 0.0;
  mediump vec3 diffColor_106;
  mediump float alpha_107;
  alpha_107 = tmpvar_99;
  mediump float outModifiedAlpha_108;
  diffColor_106 = ((albedo_103 * tmpvar_105) * alpha_107);
  outModifiedAlpha_108 = ((1.0 - tmpvar_105) + (alpha_107 * tmpvar_105));
  tmpvar_99 = outModifiedAlpha_108;
  mediump float tmpvar_109;
  tmpvar_109 = (1.0 - tmpvar_4);
  perceptualRoughness_102 = tmpvar_109;
  highp vec3 tmpvar_110;
  highp vec3 inVec_111;
  inVec_111 = (tmpvar_98 + tmpvar_97);
  tmpvar_110 = (inVec_111 * inversesqrt(max (0.001, 
    dot (inVec_111, inVec_111)
  )));
  highp float tmpvar_112;
  tmpvar_112 = abs(dot (tmpvar_97, tmpvar_6));
  highp float tmpvar_113;
  tmpvar_113 = clamp (dot (tmpvar_6, tmpvar_98), 0.0, 1.0);
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_6, tmpvar_110), 0.0, 1.0);
  mediump float tmpvar_115;
  highp float tmpvar_116;
  tmpvar_116 = clamp (dot (tmpvar_98, tmpvar_110), 0.0, 1.0);
  tmpvar_115 = tmpvar_116;
  mediump float tmpvar_117;
  mediump float NdotV_118;
  NdotV_118 = tmpvar_112;
  mediump float NdotL_119;
  NdotL_119 = tmpvar_113;
  mediump float perceptualRoughness_120;
  perceptualRoughness_120 = perceptualRoughness_102;
  mediump float tmpvar_121;
  tmpvar_121 = (0.5 + ((2.0 * tmpvar_115) * (tmpvar_115 * perceptualRoughness_120)));
  mediump float x_122;
  x_122 = (1.0 - NdotL_119);
  mediump float x_123;
  x_123 = (1.0 - NdotV_118);
  tmpvar_117 = ((1.0 + (
    (tmpvar_121 - 1.0)
   * 
    ((x_122 * x_122) * ((x_122 * x_122) * x_122))
  )) * (1.0 + (
    (tmpvar_121 - 1.0)
   * 
    ((x_123 * x_123) * ((x_123 * x_123) * x_123))
  )));
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_117 * tmpvar_113);
  diffuseTerm_101 = tmpvar_124;
  highp float tmpvar_125;
  tmpvar_125 = max ((perceptualRoughness_102 * perceptualRoughness_102), 0.002);
  highp float tmpvar_126;
  tmpvar_126 = (tmpvar_125 * tmpvar_125);
  highp float tmpvar_127;
  tmpvar_127 = (((
    (tmpvar_114 * tmpvar_126)
   - tmpvar_114) * tmpvar_114) + 1.0);
  mediump vec3 tmpvar_128;
  mediump float x_129;
  x_129 = (1.0 - tmpvar_115);
  tmpvar_128 = (specColor_104 + ((1.0 - specColor_104) * (
    (x_129 * x_129)
   * 
    ((x_129 * x_129) * x_129)
  )));
  color_100 = (((
    (diffColor_106 * LIGHT_COLOR)
   * diffuseTerm_101) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_126)
       / 
        ((tmpvar_127 * tmpvar_127) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_113 * (
          (tmpvar_112 * (1.0 - tmpvar_125))
         + tmpvar_125)) + (tmpvar_112 * (
          (tmpvar_113 * (1.0 - tmpvar_125))
         + tmpvar_125))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_113)) * LIGHT_COLOR)
   * tmpvar_128)) * tmpvar_17);
  color_100 = (color_100 + tmpvar_5);
  outColor_1.xyz = color_100;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    highp vec2 tmpvar_18;
    tmpvar_18.x = LIGHT_PARAM.z;
    tmpvar_18.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_19;
    tmpvar_19.xy = tmpvar_18;
    highp float tmpvar_20;
    tmpvar_20 = (1.0/(LIGHT_PARAM.z));
    tmpvar_19.z = tmpvar_20;
    tmpvar_19.w = tmpvar_20;
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_21;
    highp vec2 tmpvar_22;
    tmpvar_22 = tmpvar_19.xy;
    shadow_21 = 0.0;
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_16.xy - LIGHT_PARAM.zz);
    tmpvar_23.z = shadowCoord_16.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_21 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_16.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_16.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_21 = (tmpvar_25 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_22.x;
    tmpvar_30.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_16.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_16.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_33);
    highp vec2 tmpvar_34;
    tmpvar_34.y = 0.0;
    tmpvar_34.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (shadowCoord_16.xy + tmpvar_34);
    tmpvar_35.z = shadowCoord_16.z;
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_37);
    highp vec4 tmpvar_38;
    tmpvar_38 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_16.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.y = 0.0;
    tmpvar_40.x = tmpvar_22.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_16.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_16.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = -(LIGHT_PARAM.z);
    tmpvar_44.y = tmpvar_22.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_16.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = 0.0;
    tmpvar_48.y = tmpvar_22.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_16.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_16.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_51);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_16.xy + LIGHT_PARAM.zz);
    tmpvar_52.z = shadowCoord_16.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_54);
    shadow_21 = (shadow_21 / 9.0);
    tmpvar_17 = mix (1.0, shadow_21, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_57;
  highp vec3 color_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 albedo_61;
  albedo_61 = tmpvar_2;
  mediump vec3 specColor_62;
  specColor_62 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_61 * tmpvar_3));
  mediump float tmpvar_63;
  tmpvar_63 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_57 = 0.0;
  mediump vec3 diffColor_64;
  mediump float alpha_65;
  alpha_65 = tmpvar_57;
  mediump float outModifiedAlpha_66;
  diffColor_64 = ((albedo_61 * tmpvar_63) * alpha_65);
  outModifiedAlpha_66 = ((1.0 - tmpvar_63) + (alpha_65 * tmpvar_63));
  tmpvar_57 = outModifiedAlpha_66;
  mediump float tmpvar_67;
  tmpvar_67 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_67;
  highp vec3 tmpvar_68;
  highp vec3 inVec_69;
  inVec_69 = (tmpvar_56 + tmpvar_55);
  tmpvar_68 = (inVec_69 * inversesqrt(max (0.001, 
    dot (inVec_69, inVec_69)
  )));
  highp float tmpvar_70;
  tmpvar_70 = abs(dot (tmpvar_55, tmpvar_6));
  highp float tmpvar_71;
  tmpvar_71 = clamp (dot (tmpvar_6, tmpvar_56), 0.0, 1.0);
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_6, tmpvar_68), 0.0, 1.0);
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = clamp (dot (tmpvar_56, tmpvar_68), 0.0, 1.0);
  tmpvar_73 = tmpvar_74;
  mediump float tmpvar_75;
  mediump float NdotV_76;
  NdotV_76 = tmpvar_70;
  mediump float NdotL_77;
  NdotL_77 = tmpvar_71;
  mediump float perceptualRoughness_78;
  perceptualRoughness_78 = perceptualRoughness_60;
  mediump float tmpvar_79;
  tmpvar_79 = (0.5 + ((2.0 * tmpvar_73) * (tmpvar_73 * perceptualRoughness_78)));
  mediump float x_80;
  x_80 = (1.0 - NdotL_77);
  mediump float x_81;
  x_81 = (1.0 - NdotV_76);
  tmpvar_75 = ((1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_80 * x_80) * ((x_80 * x_80) * x_80))
  )) * (1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_81 * x_81) * ((x_81 * x_81) * x_81))
  )));
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_75 * tmpvar_71);
  diffuseTerm_59 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_84;
  tmpvar_84 = (tmpvar_83 * tmpvar_83);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_72 * tmpvar_84)
   - tmpvar_72) * tmpvar_72) + 1.0);
  mediump vec3 tmpvar_86;
  mediump float x_87;
  x_87 = (1.0 - tmpvar_73);
  tmpvar_86 = (specColor_62 + ((1.0 - specColor_62) * (
    (x_87 * x_87)
   * 
    ((x_87 * x_87) * x_87)
  )));
  color_58 = (((
    (diffColor_64 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_84)
       / 
        ((tmpvar_85 * tmpvar_85) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_71 * (
          (tmpvar_70 * (1.0 - tmpvar_83))
         + tmpvar_83)) + (tmpvar_70 * (
          (tmpvar_71 * (1.0 - tmpvar_83))
         + tmpvar_83))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_71)) * LIGHT_COLOR)
   * tmpvar_86)) * tmpvar_17);
  color_58 = (color_58 + tmpvar_5);
  outColor_1.xyz = color_58;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp vec4 o_15;
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_12 * 0.5);
  o_15.zw = tmpvar_16.zw;
  o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
  o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
  o_15.zw = tmpvar_12.zw;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_11[0].xyz;
  tmpvar_18[1] = tmpvar_11[1].xyz;
  tmpvar_18[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_11[0].xyz;
  tmpvar_20[1] = tmpvar_11[1].xyz;
  tmpvar_20[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_21[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_21[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[0] = tmpvar_11[0].xyz;
  tmpvar_22[1] = tmpvar_11[1].xyz;
  tmpvar_22[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_15;
  gl_Position = (tmpvar_13 * tmpvar_12);
}

]===],
		psShader = [===[uniform sampler2D _DiffuseTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = 0.0;
  mediump float alpha_5;
  alpha_5 = tmpvar_4;
  tmpvar_4 = alpha_5;
  outColor_1.xyz = ((col_2 * _DiffuseValue) * (_EmissiveValue * _EmissiveColor)).xyz;
  outColor_1.w = 1.0;
  if (((col_2.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp vec4 o_15;
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_12 * 0.5);
  o_15.zw = tmpvar_16.zw;
  o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
  o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
  o_15.zw = tmpvar_12.zw;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_11[0].xyz;
  tmpvar_18[1] = tmpvar_11[1].xyz;
  tmpvar_18[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_11[0].xyz;
  tmpvar_20[1] = tmpvar_11[1].xyz;
  tmpvar_20[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_21[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_21[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[0] = tmpvar_11[0].xyz;
  tmpvar_22[1] = tmpvar_11[1].xyz;
  tmpvar_22[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_15;
  gl_Position = (tmpvar_13 * tmpvar_12);
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec4 normalColor_5;
  highp vec4 roughnessColor_6;
  highp vec4 metallicColor_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (col_8 * _DiffuseValue);
  metallicColor_7 = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_6 = tmpvar_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_5 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_10.xyz;
  tmpvar_3 = (metallicColor_7.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_6.w * _RoughnessValue);
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (normalColor_5 * vec4(_NormalValue)).xyz;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_17;
  highp vec3 color_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_2;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_22 * tmpvar_3));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_17;
  tmpvar_17 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_4);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (tmpvar_15 + tmpvar_14);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_14, tmpvar_16));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_16, tmpvar_15), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_16, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_15, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  color_18 = (((tmpvar_21 * LIGHT_COLOR) * diffuseTerm_19) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_42) / (
        (tmpvar_43 * tmpvar_43)
       + 1e-7)) * (0.5 / (
        ((tmpvar_29 * ((tmpvar_28 * 
          (1.0 - tmpvar_41)
        ) + tmpvar_41)) + (tmpvar_28 * ((tmpvar_29 * 
          (1.0 - tmpvar_41)
        ) + tmpvar_41)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_29))
   * LIGHT_COLOR) * tmpvar_44));
  color_18 = (color_18 + ((tmpvar_10 * _EmissiveValue) * _EmissiveColor).xyz);
  outColor_1.xyz = color_18;
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_18;
    highp vec2 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_23.x);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_23.x, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_23.x, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec4 computedWeight_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_23.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_23.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_23.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    computedWeight_31 = (computedArea_32 * 0.44444);
    highp vec2 tmpvar_38;
    tmpvar_38 = (computedWeight_24.xz + computedWeight_24.yw);
    highp vec2 tmpvar_39;
    tmpvar_39 = (computedWeight_31.xz + computedWeight_31.yw);
    fetchesOffsetsU_19 = (((computedWeight_24.yw / tmpvar_38) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_18 = (((computedWeight_31.yw / tmpvar_39) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_19.x;
    tmpvar_41.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_16.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_20 = ((tmpvar_38.x * tmpvar_39.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_19.y;
    tmpvar_44.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_19.x;
    tmpvar_47.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_16.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_20 = (shadow_20 + ((tmpvar_38.x * tmpvar_39.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_19.y;
    tmpvar_50.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_16.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.y) * tmpvar_52));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  highp vec3 color_56;
  mediump float diffuseTerm_57;
  highp float perceptualRoughness_58;
  mediump vec3 tmpvar_59;
  mediump vec3 albedo_60;
  albedo_60 = tmpvar_2;
  mediump vec3 specColor_61;
  specColor_61 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_60 * tmpvar_3));
  tmpvar_59 = (albedo_60 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_55 = 0.0;
  mediump float alpha_62;
  alpha_62 = tmpvar_55;
  tmpvar_55 = alpha_62;
  mediump float tmpvar_63;
  tmpvar_63 = (1.0 - tmpvar_4);
  perceptualRoughness_58 = tmpvar_63;
  highp vec3 tmpvar_64;
  highp vec3 inVec_65;
  inVec_65 = (tmpvar_54 + tmpvar_53);
  tmpvar_64 = (inVec_65 * inversesqrt(max (0.001, 
    dot (inVec_65, inVec_65)
  )));
  highp float tmpvar_66;
  tmpvar_66 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_6, tmpvar_64), 0.0, 1.0);
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_54, tmpvar_64), 0.0, 1.0);
  tmpvar_69 = tmpvar_70;
  mediump float tmpvar_71;
  mediump float NdotV_72;
  NdotV_72 = tmpvar_66;
  mediump float NdotL_73;
  NdotL_73 = tmpvar_67;
  mediump float perceptualRoughness_74;
  perceptualRoughness_74 = perceptualRoughness_58;
  mediump float tmpvar_75;
  tmpvar_75 = (0.5 + ((2.0 * tmpvar_69) * (tmpvar_69 * perceptualRoughness_74)));
  mediump float x_76;
  x_76 = (1.0 - NdotL_73);
  mediump float x_77;
  x_77 = (1.0 - NdotV_72);
  tmpvar_71 = ((1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )) * (1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_77 * x_77) * ((x_77 * x_77) * x_77))
  )));
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_71 * tmpvar_67);
  diffuseTerm_57 = tmpvar_78;
  highp float tmpvar_79;
  tmpvar_79 = max ((perceptualRoughness_58 * perceptualRoughness_58), 0.002);
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_79 * tmpvar_79);
  highp float tmpvar_81;
  tmpvar_81 = (((
    (tmpvar_68 * tmpvar_80)
   - tmpvar_68) * tmpvar_68) + 1.0);
  mediump vec3 tmpvar_82;
  mediump float x_83;
  x_83 = (1.0 - tmpvar_69);
  tmpvar_82 = (specColor_61 + ((1.0 - specColor_61) * (
    (x_83 * x_83)
   * 
    ((x_83 * x_83) * x_83)
  )));
  color_56 = (((
    (tmpvar_59 * LIGHT_COLOR)
   * diffuseTerm_57) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_80)
       / 
        ((tmpvar_81 * tmpvar_81) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_67 * (
          (tmpvar_66 * (1.0 - tmpvar_79))
         + tmpvar_79)) + (tmpvar_66 * (
          (tmpvar_67 * (1.0 - tmpvar_79))
         + tmpvar_79))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_67)) * LIGHT_COLOR)
   * tmpvar_82)) * tmpvar_17);
  color_56 = (color_56 + tmpvar_5);
  outColor_1.xyz = color_56;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_18;
    highp vec3 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 texelsWeightsA_32;
    highp vec3 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.16 * tmpvar_37);
    texelsWeightsA_32.y = (0.16 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.16 * (computedArea_34.y + 1.0));
    texelsWeightsB_33.x = (0.16 * (computedArea_34.z + 1.0));
    texelsWeightsB_33.y = (0.16 * computedAreaUncut_35.z);
    texelsWeightsB_33.z = (0.16 * tmpvar_36);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_24.y;
    tmpvar_41.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.z = texelsWeightsB_33.y;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_32.y;
    tmpvar_44.yz = texelsWeightsB_33.xz;
    highp vec3 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec3 tmpvar_46;
    tmpvar_46.x = texelsWeightsA_24.y;
    tmpvar_46.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_47;
    tmpvar_47.x = texelsWeightsA_32.y;
    tmpvar_47.yz = texelsWeightsB_33.xz;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.x;
    tmpvar_58.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.y;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.z;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.x;
    tmpvar_67.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.y;
    tmpvar_70.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.z;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_75));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_76 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_78;
  highp vec3 color_79;
  mediump float diffuseTerm_80;
  highp float perceptualRoughness_81;
  mediump vec3 tmpvar_82;
  mediump vec3 albedo_83;
  albedo_83 = tmpvar_2;
  mediump vec3 specColor_84;
  specColor_84 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_83 * tmpvar_3));
  tmpvar_82 = (albedo_83 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_78 = 0.0;
  mediump float alpha_85;
  alpha_85 = tmpvar_78;
  tmpvar_78 = alpha_85;
  mediump float tmpvar_86;
  tmpvar_86 = (1.0 - tmpvar_4);
  perceptualRoughness_81 = tmpvar_86;
  highp vec3 tmpvar_87;
  highp vec3 inVec_88;
  inVec_88 = (tmpvar_77 + tmpvar_76);
  tmpvar_87 = (inVec_88 * inversesqrt(max (0.001, 
    dot (inVec_88, inVec_88)
  )));
  highp float tmpvar_89;
  tmpvar_89 = abs(dot (tmpvar_76, tmpvar_6));
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_6, tmpvar_77), 0.0, 1.0);
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_6, tmpvar_87), 0.0, 1.0);
  mediump float tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_77, tmpvar_87), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  mediump float tmpvar_94;
  mediump float NdotV_95;
  NdotV_95 = tmpvar_89;
  mediump float NdotL_96;
  NdotL_96 = tmpvar_90;
  mediump float perceptualRoughness_97;
  perceptualRoughness_97 = perceptualRoughness_81;
  mediump float tmpvar_98;
  tmpvar_98 = (0.5 + ((2.0 * tmpvar_92) * (tmpvar_92 * perceptualRoughness_97)));
  mediump float x_99;
  x_99 = (1.0 - NdotL_96);
  mediump float x_100;
  x_100 = (1.0 - NdotV_95);
  tmpvar_94 = ((1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )) * (1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_100 * x_100) * ((x_100 * x_100) * x_100))
  )));
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_94 * tmpvar_90);
  diffuseTerm_80 = tmpvar_101;
  highp float tmpvar_102;
  tmpvar_102 = max ((perceptualRoughness_81 * perceptualRoughness_81), 0.002);
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_102 * tmpvar_102);
  highp float tmpvar_104;
  tmpvar_104 = (((
    (tmpvar_91 * tmpvar_103)
   - tmpvar_91) * tmpvar_91) + 1.0);
  mediump vec3 tmpvar_105;
  mediump float x_106;
  x_106 = (1.0 - tmpvar_92);
  tmpvar_105 = (specColor_84 + ((1.0 - specColor_84) * (
    (x_106 * x_106)
   * 
    ((x_106 * x_106) * x_106)
  )));
  color_79 = (((
    (tmpvar_82 * LIGHT_COLOR)
   * diffuseTerm_80) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_103)
       / 
        ((tmpvar_104 * tmpvar_104) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_90 * (
          (tmpvar_89 * (1.0 - tmpvar_102))
         + tmpvar_102)) + (tmpvar_89 * (
          (tmpvar_90 * (1.0 - tmpvar_102))
         + tmpvar_102))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_90)) * LIGHT_COLOR)
   * tmpvar_105)) * tmpvar_17);
  color_79 = (color_79 + tmpvar_5);
  outColor_1.xyz = color_79;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_18;
    highp vec4 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 texelsWeightsA_32;
    highp vec4 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.081632 * tmpvar_37);
    texelsWeightsA_32.y = (0.081632 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.081632 * (computedAreaUncut_35.y + 1.0));
    texelsWeightsA_32.w = (0.081632 * (computedArea_34.y + 2.0));
    texelsWeightsB_33.x = (0.081632 * (computedArea_34.z + 2.0));
    texelsWeightsB_33.y = (0.081632 * (computedAreaUncut_35.z + 1.0));
    texelsWeightsB_33.z = (0.081632 * computedAreaUncut_35.z);
    texelsWeightsB_33.w = (0.081632 * tmpvar_36);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_24.yw;
    tmpvar_41.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.zw = texelsWeightsB_33.xz;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_32.yw;
    tmpvar_44.zw = texelsWeightsB_33.yw;
    highp vec4 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec4 tmpvar_46;
    tmpvar_46.xy = texelsWeightsA_24.yw;
    tmpvar_46.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_47;
    tmpvar_47.xy = texelsWeightsA_32.yw;
    tmpvar_47.zw = texelsWeightsB_33.yw;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.w;
    tmpvar_58.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.x;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.y;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.z;
    tmpvar_67.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.w;
    tmpvar_70.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.y) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.x;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_19.y;
    tmpvar_76.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_48 + tmpvar_76);
    tmpvar_77.z = shadowCoord_16.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_19.z;
    tmpvar_79.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_48 + tmpvar_79);
    tmpvar_80.z = shadowCoord_16.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_19.w;
    tmpvar_82.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_48 + tmpvar_82);
    tmpvar_83.z = shadowCoord_16.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.z) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_19.x;
    tmpvar_85.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_48 + tmpvar_85);
    tmpvar_86.z = shadowCoord_16.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_19.y;
    tmpvar_88.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_48 + tmpvar_88);
    tmpvar_89.z = shadowCoord_16.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_19.z;
    tmpvar_91.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_48 + tmpvar_91);
    tmpvar_92.z = shadowCoord_16.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.w) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_19.w;
    tmpvar_94.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_48 + tmpvar_94);
    tmpvar_95.z = shadowCoord_16.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.w) * tmpvar_96));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_97 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_99;
  highp vec3 color_100;
  mediump float diffuseTerm_101;
  highp float perceptualRoughness_102;
  mediump vec3 tmpvar_103;
  mediump vec3 albedo_104;
  albedo_104 = tmpvar_2;
  mediump vec3 specColor_105;
  specColor_105 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_104 * tmpvar_3));
  tmpvar_103 = (albedo_104 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_99 = 0.0;
  mediump float alpha_106;
  alpha_106 = tmpvar_99;
  tmpvar_99 = alpha_106;
  mediump float tmpvar_107;
  tmpvar_107 = (1.0 - tmpvar_4);
  perceptualRoughness_102 = tmpvar_107;
  highp vec3 tmpvar_108;
  highp vec3 inVec_109;
  inVec_109 = (tmpvar_98 + tmpvar_97);
  tmpvar_108 = (inVec_109 * inversesqrt(max (0.001, 
    dot (inVec_109, inVec_109)
  )));
  highp float tmpvar_110;
  tmpvar_110 = abs(dot (tmpvar_97, tmpvar_6));
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_6, tmpvar_98), 0.0, 1.0);
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (tmpvar_6, tmpvar_108), 0.0, 1.0);
  mediump float tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_98, tmpvar_108), 0.0, 1.0);
  tmpvar_113 = tmpvar_114;
  mediump float tmpvar_115;
  mediump float NdotV_116;
  NdotV_116 = tmpvar_110;
  mediump float NdotL_117;
  NdotL_117 = tmpvar_111;
  mediump float perceptualRoughness_118;
  perceptualRoughness_118 = perceptualRoughness_102;
  mediump float tmpvar_119;
  tmpvar_119 = (0.5 + ((2.0 * tmpvar_113) * (tmpvar_113 * perceptualRoughness_118)));
  mediump float x_120;
  x_120 = (1.0 - NdotL_117);
  mediump float x_121;
  x_121 = (1.0 - NdotV_116);
  tmpvar_115 = ((1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )) * (1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_121 * x_121) * ((x_121 * x_121) * x_121))
  )));
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_115 * tmpvar_111);
  diffuseTerm_101 = tmpvar_122;
  highp float tmpvar_123;
  tmpvar_123 = max ((perceptualRoughness_102 * perceptualRoughness_102), 0.002);
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_123 * tmpvar_123);
  highp float tmpvar_125;
  tmpvar_125 = (((
    (tmpvar_112 * tmpvar_124)
   - tmpvar_112) * tmpvar_112) + 1.0);
  mediump vec3 tmpvar_126;
  mediump float x_127;
  x_127 = (1.0 - tmpvar_113);
  tmpvar_126 = (specColor_105 + ((1.0 - specColor_105) * (
    (x_127 * x_127)
   * 
    ((x_127 * x_127) * x_127)
  )));
  color_100 = (((
    (tmpvar_103 * LIGHT_COLOR)
   * diffuseTerm_101) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_124)
       / 
        ((tmpvar_125 * tmpvar_125) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_111 * (
          (tmpvar_110 * (1.0 - tmpvar_123))
         + tmpvar_123)) + (tmpvar_110 * (
          (tmpvar_111 * (1.0 - tmpvar_123))
         + tmpvar_123))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_111)) * LIGHT_COLOR)
   * tmpvar_126)) * tmpvar_17);
  color_100 = (color_100 + tmpvar_5);
  outColor_1.xyz = color_100;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    highp vec2 tmpvar_18;
    tmpvar_18.x = LIGHT_PARAM.z;
    tmpvar_18.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_19;
    tmpvar_19.xy = tmpvar_18;
    highp float tmpvar_20;
    tmpvar_20 = (1.0/(LIGHT_PARAM.z));
    tmpvar_19.z = tmpvar_20;
    tmpvar_19.w = tmpvar_20;
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_21;
    highp vec2 tmpvar_22;
    tmpvar_22 = tmpvar_19.xy;
    shadow_21 = 0.0;
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_16.xy - LIGHT_PARAM.zz);
    tmpvar_23.z = shadowCoord_16.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_21 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_16.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_16.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_21 = (tmpvar_25 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_22.x;
    tmpvar_30.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_16.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_16.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_33);
    highp vec2 tmpvar_34;
    tmpvar_34.y = 0.0;
    tmpvar_34.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (shadowCoord_16.xy + tmpvar_34);
    tmpvar_35.z = shadowCoord_16.z;
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_37);
    highp vec4 tmpvar_38;
    tmpvar_38 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_16.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.y = 0.0;
    tmpvar_40.x = tmpvar_22.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_16.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_16.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = -(LIGHT_PARAM.z);
    tmpvar_44.y = tmpvar_22.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_16.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = 0.0;
    tmpvar_48.y = tmpvar_22.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_16.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_16.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_51);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_16.xy + LIGHT_PARAM.zz);
    tmpvar_52.z = shadowCoord_16.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_54);
    shadow_21 = (shadow_21 / 9.0);
    tmpvar_17 = mix (1.0, shadow_21, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_57;
  highp vec3 color_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 tmpvar_61;
  mediump vec3 albedo_62;
  albedo_62 = tmpvar_2;
  mediump vec3 specColor_63;
  specColor_63 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_62 * tmpvar_3));
  tmpvar_61 = (albedo_62 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_57 = 0.0;
  mediump float alpha_64;
  alpha_64 = tmpvar_57;
  tmpvar_57 = alpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (tmpvar_56 + tmpvar_55);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_55, tmpvar_6));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_6, tmpvar_56), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_6, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_56, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_60;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_59 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_63 + ((1.0 - specColor_63) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  color_58 = (((
    (tmpvar_61 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * tmpvar_17);
  color_58 = (color_58 + tmpvar_5);
  outColor_1.xyz = color_58;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp vec4 o_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_5 * 0.5);
  o_10.zw = tmpvar_11.zw;
  o_10.xy = (tmpvar_11.xy + tmpvar_11.ww);
  o_10.y = ((2.0 * tmpvar_11.w) - o_10.y);
  o_10.zw = tmpvar_5.zw;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_10;
  gl_Position = (tmpvar_7 * tmpvar_5);
}

]===],
		psShader = [===[uniform sampler2D _DiffuseTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = 0.0;
  mediump float alpha_5;
  alpha_5 = tmpvar_4;
  tmpvar_4 = alpha_5;
  outColor_1.xyz = ((col_2 * _DiffuseValue) * (_EmissiveValue * _EmissiveColor)).xyz;
  outColor_1.w = 1.0;
  if (((col_2.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp vec4 o_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_5 * 0.5);
  o_10.zw = tmpvar_11.zw;
  o_10.xy = (tmpvar_11.xy + tmpvar_11.ww);
  o_10.y = ((2.0 * tmpvar_11.w) - o_10.y);
  o_10.zw = tmpvar_5.zw;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_10;
  gl_Position = (tmpvar_7 * tmpvar_5);
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec4 normalColor_5;
  highp vec4 roughnessColor_6;
  highp vec4 metallicColor_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (col_8 * _DiffuseValue);
  metallicColor_7 = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_6 = tmpvar_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_5 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_10.xyz;
  tmpvar_3 = (metallicColor_7.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_6.w * _RoughnessValue);
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (normalColor_5 * vec4(_NormalValue)).xyz;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_17;
  highp vec3 color_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_2;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_22 * tmpvar_3));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_17;
  tmpvar_17 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_4);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (tmpvar_15 + tmpvar_14);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_14, tmpvar_16));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_16, tmpvar_15), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_16, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_15, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  color_18 = (((tmpvar_21 * LIGHT_COLOR) * diffuseTerm_19) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_42) / (
        (tmpvar_43 * tmpvar_43)
       + 1e-7)) * (0.5 / (
        ((tmpvar_29 * ((tmpvar_28 * 
          (1.0 - tmpvar_41)
        ) + tmpvar_41)) + (tmpvar_28 * ((tmpvar_29 * 
          (1.0 - tmpvar_41)
        ) + tmpvar_41)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_29))
   * LIGHT_COLOR) * tmpvar_44));
  color_18 = (color_18 + ((tmpvar_10 * _EmissiveValue) * _EmissiveColor).xyz);
  outColor_1.xyz = color_18;
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_18;
    highp vec2 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_23.x);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_23.x, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_23.x, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec4 computedWeight_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_23.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_23.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_23.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    computedWeight_31 = (computedArea_32 * 0.44444);
    highp vec2 tmpvar_38;
    tmpvar_38 = (computedWeight_24.xz + computedWeight_24.yw);
    highp vec2 tmpvar_39;
    tmpvar_39 = (computedWeight_31.xz + computedWeight_31.yw);
    fetchesOffsetsU_19 = (((computedWeight_24.yw / tmpvar_38) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_18 = (((computedWeight_31.yw / tmpvar_39) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_19.x;
    tmpvar_41.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_16.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_20 = ((tmpvar_38.x * tmpvar_39.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_19.y;
    tmpvar_44.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_19.x;
    tmpvar_47.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_16.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_20 = (shadow_20 + ((tmpvar_38.x * tmpvar_39.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_19.y;
    tmpvar_50.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_16.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.y) * tmpvar_52));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  highp vec3 color_56;
  mediump float diffuseTerm_57;
  highp float perceptualRoughness_58;
  mediump vec3 tmpvar_59;
  mediump vec3 albedo_60;
  albedo_60 = tmpvar_2;
  mediump vec3 specColor_61;
  specColor_61 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_60 * tmpvar_3));
  tmpvar_59 = (albedo_60 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_55 = 0.0;
  mediump float alpha_62;
  alpha_62 = tmpvar_55;
  tmpvar_55 = alpha_62;
  mediump float tmpvar_63;
  tmpvar_63 = (1.0 - tmpvar_4);
  perceptualRoughness_58 = tmpvar_63;
  highp vec3 tmpvar_64;
  highp vec3 inVec_65;
  inVec_65 = (tmpvar_54 + tmpvar_53);
  tmpvar_64 = (inVec_65 * inversesqrt(max (0.001, 
    dot (inVec_65, inVec_65)
  )));
  highp float tmpvar_66;
  tmpvar_66 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_6, tmpvar_64), 0.0, 1.0);
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_54, tmpvar_64), 0.0, 1.0);
  tmpvar_69 = tmpvar_70;
  mediump float tmpvar_71;
  mediump float NdotV_72;
  NdotV_72 = tmpvar_66;
  mediump float NdotL_73;
  NdotL_73 = tmpvar_67;
  mediump float perceptualRoughness_74;
  perceptualRoughness_74 = perceptualRoughness_58;
  mediump float tmpvar_75;
  tmpvar_75 = (0.5 + ((2.0 * tmpvar_69) * (tmpvar_69 * perceptualRoughness_74)));
  mediump float x_76;
  x_76 = (1.0 - NdotL_73);
  mediump float x_77;
  x_77 = (1.0 - NdotV_72);
  tmpvar_71 = ((1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )) * (1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_77 * x_77) * ((x_77 * x_77) * x_77))
  )));
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_71 * tmpvar_67);
  diffuseTerm_57 = tmpvar_78;
  highp float tmpvar_79;
  tmpvar_79 = max ((perceptualRoughness_58 * perceptualRoughness_58), 0.002);
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_79 * tmpvar_79);
  highp float tmpvar_81;
  tmpvar_81 = (((
    (tmpvar_68 * tmpvar_80)
   - tmpvar_68) * tmpvar_68) + 1.0);
  mediump vec3 tmpvar_82;
  mediump float x_83;
  x_83 = (1.0 - tmpvar_69);
  tmpvar_82 = (specColor_61 + ((1.0 - specColor_61) * (
    (x_83 * x_83)
   * 
    ((x_83 * x_83) * x_83)
  )));
  color_56 = (((
    (tmpvar_59 * LIGHT_COLOR)
   * diffuseTerm_57) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_80)
       / 
        ((tmpvar_81 * tmpvar_81) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_67 * (
          (tmpvar_66 * (1.0 - tmpvar_79))
         + tmpvar_79)) + (tmpvar_66 * (
          (tmpvar_67 * (1.0 - tmpvar_79))
         + tmpvar_79))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_67)) * LIGHT_COLOR)
   * tmpvar_82)) * tmpvar_17);
  color_56 = (color_56 + tmpvar_5);
  outColor_1.xyz = color_56;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_18;
    highp vec3 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 texelsWeightsA_32;
    highp vec3 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.16 * tmpvar_37);
    texelsWeightsA_32.y = (0.16 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.16 * (computedArea_34.y + 1.0));
    texelsWeightsB_33.x = (0.16 * (computedArea_34.z + 1.0));
    texelsWeightsB_33.y = (0.16 * computedAreaUncut_35.z);
    texelsWeightsB_33.z = (0.16 * tmpvar_36);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_24.y;
    tmpvar_41.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.z = texelsWeightsB_33.y;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_32.y;
    tmpvar_44.yz = texelsWeightsB_33.xz;
    highp vec3 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec3 tmpvar_46;
    tmpvar_46.x = texelsWeightsA_24.y;
    tmpvar_46.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_47;
    tmpvar_47.x = texelsWeightsA_32.y;
    tmpvar_47.yz = texelsWeightsB_33.xz;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.x;
    tmpvar_58.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.y;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.z;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.x;
    tmpvar_67.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.y;
    tmpvar_70.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.z;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_75));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_76 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_78;
  highp vec3 color_79;
  mediump float diffuseTerm_80;
  highp float perceptualRoughness_81;
  mediump vec3 tmpvar_82;
  mediump vec3 albedo_83;
  albedo_83 = tmpvar_2;
  mediump vec3 specColor_84;
  specColor_84 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_83 * tmpvar_3));
  tmpvar_82 = (albedo_83 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_78 = 0.0;
  mediump float alpha_85;
  alpha_85 = tmpvar_78;
  tmpvar_78 = alpha_85;
  mediump float tmpvar_86;
  tmpvar_86 = (1.0 - tmpvar_4);
  perceptualRoughness_81 = tmpvar_86;
  highp vec3 tmpvar_87;
  highp vec3 inVec_88;
  inVec_88 = (tmpvar_77 + tmpvar_76);
  tmpvar_87 = (inVec_88 * inversesqrt(max (0.001, 
    dot (inVec_88, inVec_88)
  )));
  highp float tmpvar_89;
  tmpvar_89 = abs(dot (tmpvar_76, tmpvar_6));
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_6, tmpvar_77), 0.0, 1.0);
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_6, tmpvar_87), 0.0, 1.0);
  mediump float tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_77, tmpvar_87), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  mediump float tmpvar_94;
  mediump float NdotV_95;
  NdotV_95 = tmpvar_89;
  mediump float NdotL_96;
  NdotL_96 = tmpvar_90;
  mediump float perceptualRoughness_97;
  perceptualRoughness_97 = perceptualRoughness_81;
  mediump float tmpvar_98;
  tmpvar_98 = (0.5 + ((2.0 * tmpvar_92) * (tmpvar_92 * perceptualRoughness_97)));
  mediump float x_99;
  x_99 = (1.0 - NdotL_96);
  mediump float x_100;
  x_100 = (1.0 - NdotV_95);
  tmpvar_94 = ((1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )) * (1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_100 * x_100) * ((x_100 * x_100) * x_100))
  )));
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_94 * tmpvar_90);
  diffuseTerm_80 = tmpvar_101;
  highp float tmpvar_102;
  tmpvar_102 = max ((perceptualRoughness_81 * perceptualRoughness_81), 0.002);
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_102 * tmpvar_102);
  highp float tmpvar_104;
  tmpvar_104 = (((
    (tmpvar_91 * tmpvar_103)
   - tmpvar_91) * tmpvar_91) + 1.0);
  mediump vec3 tmpvar_105;
  mediump float x_106;
  x_106 = (1.0 - tmpvar_92);
  tmpvar_105 = (specColor_84 + ((1.0 - specColor_84) * (
    (x_106 * x_106)
   * 
    ((x_106 * x_106) * x_106)
  )));
  color_79 = (((
    (tmpvar_82 * LIGHT_COLOR)
   * diffuseTerm_80) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_103)
       / 
        ((tmpvar_104 * tmpvar_104) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_90 * (
          (tmpvar_89 * (1.0 - tmpvar_102))
         + tmpvar_102)) + (tmpvar_89 * (
          (tmpvar_90 * (1.0 - tmpvar_102))
         + tmpvar_102))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_90)) * LIGHT_COLOR)
   * tmpvar_105)) * tmpvar_17);
  color_79 = (color_79 + tmpvar_5);
  outColor_1.xyz = color_79;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_18;
    highp vec4 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 texelsWeightsA_32;
    highp vec4 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.081632 * tmpvar_37);
    texelsWeightsA_32.y = (0.081632 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.081632 * (computedAreaUncut_35.y + 1.0));
    texelsWeightsA_32.w = (0.081632 * (computedArea_34.y + 2.0));
    texelsWeightsB_33.x = (0.081632 * (computedArea_34.z + 2.0));
    texelsWeightsB_33.y = (0.081632 * (computedAreaUncut_35.z + 1.0));
    texelsWeightsB_33.z = (0.081632 * computedAreaUncut_35.z);
    texelsWeightsB_33.w = (0.081632 * tmpvar_36);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_24.yw;
    tmpvar_41.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.zw = texelsWeightsB_33.xz;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_32.yw;
    tmpvar_44.zw = texelsWeightsB_33.yw;
    highp vec4 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec4 tmpvar_46;
    tmpvar_46.xy = texelsWeightsA_24.yw;
    tmpvar_46.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_47;
    tmpvar_47.xy = texelsWeightsA_32.yw;
    tmpvar_47.zw = texelsWeightsB_33.yw;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.w;
    tmpvar_58.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.x;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.y;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.z;
    tmpvar_67.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.w;
    tmpvar_70.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.y) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.x;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_19.y;
    tmpvar_76.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_48 + tmpvar_76);
    tmpvar_77.z = shadowCoord_16.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_19.z;
    tmpvar_79.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_48 + tmpvar_79);
    tmpvar_80.z = shadowCoord_16.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_19.w;
    tmpvar_82.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_48 + tmpvar_82);
    tmpvar_83.z = shadowCoord_16.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.z) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_19.x;
    tmpvar_85.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_48 + tmpvar_85);
    tmpvar_86.z = shadowCoord_16.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_19.y;
    tmpvar_88.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_48 + tmpvar_88);
    tmpvar_89.z = shadowCoord_16.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_19.z;
    tmpvar_91.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_48 + tmpvar_91);
    tmpvar_92.z = shadowCoord_16.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.w) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_19.w;
    tmpvar_94.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_48 + tmpvar_94);
    tmpvar_95.z = shadowCoord_16.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.w) * tmpvar_96));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_97 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_99;
  highp vec3 color_100;
  mediump float diffuseTerm_101;
  highp float perceptualRoughness_102;
  mediump vec3 tmpvar_103;
  mediump vec3 albedo_104;
  albedo_104 = tmpvar_2;
  mediump vec3 specColor_105;
  specColor_105 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_104 * tmpvar_3));
  tmpvar_103 = (albedo_104 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_99 = 0.0;
  mediump float alpha_106;
  alpha_106 = tmpvar_99;
  tmpvar_99 = alpha_106;
  mediump float tmpvar_107;
  tmpvar_107 = (1.0 - tmpvar_4);
  perceptualRoughness_102 = tmpvar_107;
  highp vec3 tmpvar_108;
  highp vec3 inVec_109;
  inVec_109 = (tmpvar_98 + tmpvar_97);
  tmpvar_108 = (inVec_109 * inversesqrt(max (0.001, 
    dot (inVec_109, inVec_109)
  )));
  highp float tmpvar_110;
  tmpvar_110 = abs(dot (tmpvar_97, tmpvar_6));
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_6, tmpvar_98), 0.0, 1.0);
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (tmpvar_6, tmpvar_108), 0.0, 1.0);
  mediump float tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_98, tmpvar_108), 0.0, 1.0);
  tmpvar_113 = tmpvar_114;
  mediump float tmpvar_115;
  mediump float NdotV_116;
  NdotV_116 = tmpvar_110;
  mediump float NdotL_117;
  NdotL_117 = tmpvar_111;
  mediump float perceptualRoughness_118;
  perceptualRoughness_118 = perceptualRoughness_102;
  mediump float tmpvar_119;
  tmpvar_119 = (0.5 + ((2.0 * tmpvar_113) * (tmpvar_113 * perceptualRoughness_118)));
  mediump float x_120;
  x_120 = (1.0 - NdotL_117);
  mediump float x_121;
  x_121 = (1.0 - NdotV_116);
  tmpvar_115 = ((1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )) * (1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_121 * x_121) * ((x_121 * x_121) * x_121))
  )));
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_115 * tmpvar_111);
  diffuseTerm_101 = tmpvar_122;
  highp float tmpvar_123;
  tmpvar_123 = max ((perceptualRoughness_102 * perceptualRoughness_102), 0.002);
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_123 * tmpvar_123);
  highp float tmpvar_125;
  tmpvar_125 = (((
    (tmpvar_112 * tmpvar_124)
   - tmpvar_112) * tmpvar_112) + 1.0);
  mediump vec3 tmpvar_126;
  mediump float x_127;
  x_127 = (1.0 - tmpvar_113);
  tmpvar_126 = (specColor_105 + ((1.0 - specColor_105) * (
    (x_127 * x_127)
   * 
    ((x_127 * x_127) * x_127)
  )));
  color_100 = (((
    (tmpvar_103 * LIGHT_COLOR)
   * diffuseTerm_101) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_124)
       / 
        ((tmpvar_125 * tmpvar_125) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_111 * (
          (tmpvar_110 * (1.0 - tmpvar_123))
         + tmpvar_123)) + (tmpvar_110 * (
          (tmpvar_111 * (1.0 - tmpvar_123))
         + tmpvar_123))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_111)) * LIGHT_COLOR)
   * tmpvar_126)) * tmpvar_17);
  color_100 = (color_100 + tmpvar_5);
  outColor_1.xyz = color_100;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _CutOff;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    highp vec2 tmpvar_18;
    tmpvar_18.x = LIGHT_PARAM.z;
    tmpvar_18.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_19;
    tmpvar_19.xy = tmpvar_18;
    highp float tmpvar_20;
    tmpvar_20 = (1.0/(LIGHT_PARAM.z));
    tmpvar_19.z = tmpvar_20;
    tmpvar_19.w = tmpvar_20;
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_21;
    highp vec2 tmpvar_22;
    tmpvar_22 = tmpvar_19.xy;
    shadow_21 = 0.0;
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_16.xy - LIGHT_PARAM.zz);
    tmpvar_23.z = shadowCoord_16.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_21 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_16.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_16.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_21 = (tmpvar_25 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_22.x;
    tmpvar_30.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_16.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_16.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_33);
    highp vec2 tmpvar_34;
    tmpvar_34.y = 0.0;
    tmpvar_34.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (shadowCoord_16.xy + tmpvar_34);
    tmpvar_35.z = shadowCoord_16.z;
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_37);
    highp vec4 tmpvar_38;
    tmpvar_38 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_16.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.y = 0.0;
    tmpvar_40.x = tmpvar_22.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_16.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_16.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = -(LIGHT_PARAM.z);
    tmpvar_44.y = tmpvar_22.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_16.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = 0.0;
    tmpvar_48.y = tmpvar_22.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_16.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_16.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_51);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_16.xy + LIGHT_PARAM.zz);
    tmpvar_52.z = shadowCoord_16.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_54);
    shadow_21 = (shadow_21 / 9.0);
    tmpvar_17 = mix (1.0, shadow_21, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_57;
  highp vec3 color_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 tmpvar_61;
  mediump vec3 albedo_62;
  albedo_62 = tmpvar_2;
  mediump vec3 specColor_63;
  specColor_63 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_62 * tmpvar_3));
  tmpvar_61 = (albedo_62 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_57 = 0.0;
  mediump float alpha_64;
  alpha_64 = tmpvar_57;
  tmpvar_57 = alpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (tmpvar_56 + tmpvar_55);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_55, tmpvar_6));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_6, tmpvar_56), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_6, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_56, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_60;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_59 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_63 + ((1.0 - specColor_63) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  color_58 = (((
    (tmpvar_61 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * tmpvar_17);
  color_58 = (color_58 + tmpvar_5);
  outColor_1.xyz = color_58;
  outColor_1.w = 1.0;
  if (((col_10.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp vec4 o_15;
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_12 * 0.5);
  o_15.zw = tmpvar_16.zw;
  o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
  o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
  o_15.zw = tmpvar_12.zw;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_11[0].xyz;
  tmpvar_18[1] = tmpvar_11[1].xyz;
  tmpvar_18[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_11[0].xyz;
  tmpvar_20[1] = tmpvar_11[1].xyz;
  tmpvar_20[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_21[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_21[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[0] = tmpvar_11[0].xyz;
  tmpvar_22[1] = tmpvar_11[1].xyz;
  tmpvar_22[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_15;
  gl_Position = (tmpvar_13 * tmpvar_12);
}

]===],
		psShader = [===[uniform sampler2D _DiffuseTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _MetallicValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  mediump float tmpvar_2;
  highp vec4 metallicColor_3;
  highp vec4 col_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_4 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (col_4 * _DiffuseValue);
  metallicColor_3 = tmpvar_5;
  tmpvar_2 = (metallicColor_3.x * _MetallicValue);
  highp float tmpvar_7;
  mediump float tmpvar_8;
  tmpvar_8 = (0.7790837 - (tmpvar_2 * 0.7790837));
  tmpvar_7 = 0.0;
  mediump float alpha_9;
  alpha_9 = tmpvar_7;
  mediump float outModifiedAlpha_10;
  outModifiedAlpha_10 = ((1.0 - tmpvar_8) + (alpha_9 * tmpvar_8));
  tmpvar_7 = outModifiedAlpha_10;
  outColor_1.xyz = ((tmpvar_6 * _EmissiveValue) * _EmissiveColor).xyz;
  outColor_1.w = (tmpvar_6.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp vec4 o_15;
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_12 * 0.5);
  o_15.zw = tmpvar_16.zw;
  o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
  o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
  o_15.zw = tmpvar_12.zw;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_11[0].xyz;
  tmpvar_18[1] = tmpvar_11[1].xyz;
  tmpvar_18[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_11[0].xyz;
  tmpvar_20[1] = tmpvar_11[1].xyz;
  tmpvar_20[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_21[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_21[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[0] = tmpvar_11[0].xyz;
  tmpvar_22[1] = tmpvar_11[1].xyz;
  tmpvar_22[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_15;
  gl_Position = (tmpvar_13 * tmpvar_12);
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec4 normalColor_5;
  highp vec4 roughnessColor_6;
  highp vec4 metallicColor_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (col_8 * _DiffuseValue);
  metallicColor_7 = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_6 = tmpvar_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_5 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_10.xyz;
  tmpvar_3 = (metallicColor_7.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_6.w * _RoughnessValue);
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (normalColor_5 * vec4(_NormalValue)).xyz;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_17;
  highp vec3 color_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  mediump float tmpvar_23;
  tmpvar_23 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_17 = 0.0;
  mediump vec3 diffColor_24;
  mediump float alpha_25;
  alpha_25 = tmpvar_17;
  mediump float outModifiedAlpha_26;
  diffColor_24 = ((albedo_21 * tmpvar_23) * alpha_25);
  outModifiedAlpha_26 = ((1.0 - tmpvar_23) + (alpha_25 * tmpvar_23));
  tmpvar_17 = outModifiedAlpha_26;
  mediump float tmpvar_27;
  tmpvar_27 = (1.0 - tmpvar_4);
  perceptualRoughness_20 = tmpvar_27;
  highp vec3 tmpvar_28;
  highp vec3 inVec_29;
  inVec_29 = (tmpvar_15 + tmpvar_14);
  tmpvar_28 = (inVec_29 * inversesqrt(max (0.001, 
    dot (inVec_29, inVec_29)
  )));
  highp float tmpvar_30;
  tmpvar_30 = abs(dot (tmpvar_14, tmpvar_16));
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_16, tmpvar_15), 0.0, 1.0);
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_16, tmpvar_28), 0.0, 1.0);
  mediump float tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = clamp (dot (tmpvar_15, tmpvar_28), 0.0, 1.0);
  tmpvar_33 = tmpvar_34;
  mediump float tmpvar_35;
  mediump float NdotV_36;
  NdotV_36 = tmpvar_30;
  mediump float NdotL_37;
  NdotL_37 = tmpvar_31;
  mediump float perceptualRoughness_38;
  perceptualRoughness_38 = perceptualRoughness_20;
  mediump float tmpvar_39;
  tmpvar_39 = (0.5 + ((2.0 * tmpvar_33) * (tmpvar_33 * perceptualRoughness_38)));
  mediump float x_40;
  x_40 = (1.0 - NdotL_37);
  mediump float x_41;
  x_41 = (1.0 - NdotV_36);
  tmpvar_35 = ((1.0 + (
    (tmpvar_39 - 1.0)
   * 
    ((x_40 * x_40) * ((x_40 * x_40) * x_40))
  )) * (1.0 + (
    (tmpvar_39 - 1.0)
   * 
    ((x_41 * x_41) * ((x_41 * x_41) * x_41))
  )));
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_35 * tmpvar_31);
  diffuseTerm_19 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_44;
  tmpvar_44 = (tmpvar_43 * tmpvar_43);
  highp float tmpvar_45;
  tmpvar_45 = (((
    (tmpvar_32 * tmpvar_44)
   - tmpvar_32) * tmpvar_32) + 1.0);
  mediump vec3 tmpvar_46;
  mediump float x_47;
  x_47 = (1.0 - tmpvar_33);
  tmpvar_46 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_47 * x_47)
   * 
    ((x_47 * x_47) * x_47)
  )));
  color_18 = (((diffColor_24 * LIGHT_COLOR) * diffuseTerm_19) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_44) / (
        (tmpvar_45 * tmpvar_45)
       + 1e-7)) * (0.5 / (
        ((tmpvar_31 * ((tmpvar_30 * 
          (1.0 - tmpvar_43)
        ) + tmpvar_43)) + (tmpvar_30 * ((tmpvar_31 * 
          (1.0 - tmpvar_43)
        ) + tmpvar_43)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_31))
   * LIGHT_COLOR) * tmpvar_46));
  color_18 = (color_18 + ((tmpvar_10 * _EmissiveValue) * _EmissiveColor).xyz);
  outColor_1.xyz = color_18;
  outColor_1.w = (tmpvar_10.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_18;
    highp vec2 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_23.x);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_23.x, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_23.x, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec4 computedWeight_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_23.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_23.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_23.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    computedWeight_31 = (computedArea_32 * 0.44444);
    highp vec2 tmpvar_38;
    tmpvar_38 = (computedWeight_24.xz + computedWeight_24.yw);
    highp vec2 tmpvar_39;
    tmpvar_39 = (computedWeight_31.xz + computedWeight_31.yw);
    fetchesOffsetsU_19 = (((computedWeight_24.yw / tmpvar_38) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_18 = (((computedWeight_31.yw / tmpvar_39) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_19.x;
    tmpvar_41.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_16.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_20 = ((tmpvar_38.x * tmpvar_39.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_19.y;
    tmpvar_44.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_19.x;
    tmpvar_47.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_16.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_20 = (shadow_20 + ((tmpvar_38.x * tmpvar_39.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_19.y;
    tmpvar_50.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_16.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.y) * tmpvar_52));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  highp vec3 color_56;
  mediump float diffuseTerm_57;
  highp float perceptualRoughness_58;
  mediump vec3 albedo_59;
  albedo_59 = tmpvar_2;
  mediump vec3 specColor_60;
  specColor_60 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_59 * tmpvar_3));
  mediump float tmpvar_61;
  tmpvar_61 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_55 = 0.0;
  mediump vec3 diffColor_62;
  mediump float alpha_63;
  alpha_63 = tmpvar_55;
  mediump float outModifiedAlpha_64;
  diffColor_62 = ((albedo_59 * tmpvar_61) * alpha_63);
  outModifiedAlpha_64 = ((1.0 - tmpvar_61) + (alpha_63 * tmpvar_61));
  tmpvar_55 = outModifiedAlpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_58 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (tmpvar_54 + tmpvar_53);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_6, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_54, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_58;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_57 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_58 * perceptualRoughness_58), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_60 + ((1.0 - specColor_60) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  color_56 = (((
    (diffColor_62 * LIGHT_COLOR)
   * diffuseTerm_57) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * tmpvar_17);
  color_56 = (color_56 + tmpvar_5);
  outColor_1.xyz = color_56;
  outColor_1.w = (tmpvar_12.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_18;
    highp vec3 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 texelsWeightsA_32;
    highp vec3 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.16 * tmpvar_37);
    texelsWeightsA_32.y = (0.16 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.16 * (computedArea_34.y + 1.0));
    texelsWeightsB_33.x = (0.16 * (computedArea_34.z + 1.0));
    texelsWeightsB_33.y = (0.16 * computedAreaUncut_35.z);
    texelsWeightsB_33.z = (0.16 * tmpvar_36);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_24.y;
    tmpvar_41.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.z = texelsWeightsB_33.y;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_32.y;
    tmpvar_44.yz = texelsWeightsB_33.xz;
    highp vec3 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec3 tmpvar_46;
    tmpvar_46.x = texelsWeightsA_24.y;
    tmpvar_46.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_47;
    tmpvar_47.x = texelsWeightsA_32.y;
    tmpvar_47.yz = texelsWeightsB_33.xz;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.x;
    tmpvar_58.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.y;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.z;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.x;
    tmpvar_67.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.y;
    tmpvar_70.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.z;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_75));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_76 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_78;
  highp vec3 color_79;
  mediump float diffuseTerm_80;
  highp float perceptualRoughness_81;
  mediump vec3 albedo_82;
  albedo_82 = tmpvar_2;
  mediump vec3 specColor_83;
  specColor_83 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_82 * tmpvar_3));
  mediump float tmpvar_84;
  tmpvar_84 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_78 = 0.0;
  mediump vec3 diffColor_85;
  mediump float alpha_86;
  alpha_86 = tmpvar_78;
  mediump float outModifiedAlpha_87;
  diffColor_85 = ((albedo_82 * tmpvar_84) * alpha_86);
  outModifiedAlpha_87 = ((1.0 - tmpvar_84) + (alpha_86 * tmpvar_84));
  tmpvar_78 = outModifiedAlpha_87;
  mediump float tmpvar_88;
  tmpvar_88 = (1.0 - tmpvar_4);
  perceptualRoughness_81 = tmpvar_88;
  highp vec3 tmpvar_89;
  highp vec3 inVec_90;
  inVec_90 = (tmpvar_77 + tmpvar_76);
  tmpvar_89 = (inVec_90 * inversesqrt(max (0.001, 
    dot (inVec_90, inVec_90)
  )));
  highp float tmpvar_91;
  tmpvar_91 = abs(dot (tmpvar_76, tmpvar_6));
  highp float tmpvar_92;
  tmpvar_92 = clamp (dot (tmpvar_6, tmpvar_77), 0.0, 1.0);
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_6, tmpvar_89), 0.0, 1.0);
  mediump float tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = clamp (dot (tmpvar_77, tmpvar_89), 0.0, 1.0);
  tmpvar_94 = tmpvar_95;
  mediump float tmpvar_96;
  mediump float NdotV_97;
  NdotV_97 = tmpvar_91;
  mediump float NdotL_98;
  NdotL_98 = tmpvar_92;
  mediump float perceptualRoughness_99;
  perceptualRoughness_99 = perceptualRoughness_81;
  mediump float tmpvar_100;
  tmpvar_100 = (0.5 + ((2.0 * tmpvar_94) * (tmpvar_94 * perceptualRoughness_99)));
  mediump float x_101;
  x_101 = (1.0 - NdotL_98);
  mediump float x_102;
  x_102 = (1.0 - NdotV_97);
  tmpvar_96 = ((1.0 + (
    (tmpvar_100 - 1.0)
   * 
    ((x_101 * x_101) * ((x_101 * x_101) * x_101))
  )) * (1.0 + (
    (tmpvar_100 - 1.0)
   * 
    ((x_102 * x_102) * ((x_102 * x_102) * x_102))
  )));
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_96 * tmpvar_92);
  diffuseTerm_80 = tmpvar_103;
  highp float tmpvar_104;
  tmpvar_104 = max ((perceptualRoughness_81 * perceptualRoughness_81), 0.002);
  highp float tmpvar_105;
  tmpvar_105 = (tmpvar_104 * tmpvar_104);
  highp float tmpvar_106;
  tmpvar_106 = (((
    (tmpvar_93 * tmpvar_105)
   - tmpvar_93) * tmpvar_93) + 1.0);
  mediump vec3 tmpvar_107;
  mediump float x_108;
  x_108 = (1.0 - tmpvar_94);
  tmpvar_107 = (specColor_83 + ((1.0 - specColor_83) * (
    (x_108 * x_108)
   * 
    ((x_108 * x_108) * x_108)
  )));
  color_79 = (((
    (diffColor_85 * LIGHT_COLOR)
   * diffuseTerm_80) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_105)
       / 
        ((tmpvar_106 * tmpvar_106) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_92 * (
          (tmpvar_91 * (1.0 - tmpvar_104))
         + tmpvar_104)) + (tmpvar_91 * (
          (tmpvar_92 * (1.0 - tmpvar_104))
         + tmpvar_104))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_92)) * LIGHT_COLOR)
   * tmpvar_107)) * tmpvar_17);
  color_79 = (color_79 + tmpvar_5);
  outColor_1.xyz = color_79;
  outColor_1.w = (tmpvar_12.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_18;
    highp vec4 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 texelsWeightsA_32;
    highp vec4 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.081632 * tmpvar_37);
    texelsWeightsA_32.y = (0.081632 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.081632 * (computedAreaUncut_35.y + 1.0));
    texelsWeightsA_32.w = (0.081632 * (computedArea_34.y + 2.0));
    texelsWeightsB_33.x = (0.081632 * (computedArea_34.z + 2.0));
    texelsWeightsB_33.y = (0.081632 * (computedAreaUncut_35.z + 1.0));
    texelsWeightsB_33.z = (0.081632 * computedAreaUncut_35.z);
    texelsWeightsB_33.w = (0.081632 * tmpvar_36);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_24.yw;
    tmpvar_41.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.zw = texelsWeightsB_33.xz;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_32.yw;
    tmpvar_44.zw = texelsWeightsB_33.yw;
    highp vec4 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec4 tmpvar_46;
    tmpvar_46.xy = texelsWeightsA_24.yw;
    tmpvar_46.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_47;
    tmpvar_47.xy = texelsWeightsA_32.yw;
    tmpvar_47.zw = texelsWeightsB_33.yw;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.w;
    tmpvar_58.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.x;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.y;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.z;
    tmpvar_67.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.w;
    tmpvar_70.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.y) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.x;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_19.y;
    tmpvar_76.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_48 + tmpvar_76);
    tmpvar_77.z = shadowCoord_16.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_19.z;
    tmpvar_79.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_48 + tmpvar_79);
    tmpvar_80.z = shadowCoord_16.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_19.w;
    tmpvar_82.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_48 + tmpvar_82);
    tmpvar_83.z = shadowCoord_16.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.z) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_19.x;
    tmpvar_85.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_48 + tmpvar_85);
    tmpvar_86.z = shadowCoord_16.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_19.y;
    tmpvar_88.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_48 + tmpvar_88);
    tmpvar_89.z = shadowCoord_16.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_19.z;
    tmpvar_91.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_48 + tmpvar_91);
    tmpvar_92.z = shadowCoord_16.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.w) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_19.w;
    tmpvar_94.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_48 + tmpvar_94);
    tmpvar_95.z = shadowCoord_16.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.w) * tmpvar_96));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_97 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_99;
  highp vec3 color_100;
  mediump float diffuseTerm_101;
  highp float perceptualRoughness_102;
  mediump vec3 albedo_103;
  albedo_103 = tmpvar_2;
  mediump vec3 specColor_104;
  specColor_104 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_103 * tmpvar_3));
  mediump float tmpvar_105;
  tmpvar_105 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_99 = 0.0;
  mediump vec3 diffColor_106;
  mediump float alpha_107;
  alpha_107 = tmpvar_99;
  mediump float outModifiedAlpha_108;
  diffColor_106 = ((albedo_103 * tmpvar_105) * alpha_107);
  outModifiedAlpha_108 = ((1.0 - tmpvar_105) + (alpha_107 * tmpvar_105));
  tmpvar_99 = outModifiedAlpha_108;
  mediump float tmpvar_109;
  tmpvar_109 = (1.0 - tmpvar_4);
  perceptualRoughness_102 = tmpvar_109;
  highp vec3 tmpvar_110;
  highp vec3 inVec_111;
  inVec_111 = (tmpvar_98 + tmpvar_97);
  tmpvar_110 = (inVec_111 * inversesqrt(max (0.001, 
    dot (inVec_111, inVec_111)
  )));
  highp float tmpvar_112;
  tmpvar_112 = abs(dot (tmpvar_97, tmpvar_6));
  highp float tmpvar_113;
  tmpvar_113 = clamp (dot (tmpvar_6, tmpvar_98), 0.0, 1.0);
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_6, tmpvar_110), 0.0, 1.0);
  mediump float tmpvar_115;
  highp float tmpvar_116;
  tmpvar_116 = clamp (dot (tmpvar_98, tmpvar_110), 0.0, 1.0);
  tmpvar_115 = tmpvar_116;
  mediump float tmpvar_117;
  mediump float NdotV_118;
  NdotV_118 = tmpvar_112;
  mediump float NdotL_119;
  NdotL_119 = tmpvar_113;
  mediump float perceptualRoughness_120;
  perceptualRoughness_120 = perceptualRoughness_102;
  mediump float tmpvar_121;
  tmpvar_121 = (0.5 + ((2.0 * tmpvar_115) * (tmpvar_115 * perceptualRoughness_120)));
  mediump float x_122;
  x_122 = (1.0 - NdotL_119);
  mediump float x_123;
  x_123 = (1.0 - NdotV_118);
  tmpvar_117 = ((1.0 + (
    (tmpvar_121 - 1.0)
   * 
    ((x_122 * x_122) * ((x_122 * x_122) * x_122))
  )) * (1.0 + (
    (tmpvar_121 - 1.0)
   * 
    ((x_123 * x_123) * ((x_123 * x_123) * x_123))
  )));
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_117 * tmpvar_113);
  diffuseTerm_101 = tmpvar_124;
  highp float tmpvar_125;
  tmpvar_125 = max ((perceptualRoughness_102 * perceptualRoughness_102), 0.002);
  highp float tmpvar_126;
  tmpvar_126 = (tmpvar_125 * tmpvar_125);
  highp float tmpvar_127;
  tmpvar_127 = (((
    (tmpvar_114 * tmpvar_126)
   - tmpvar_114) * tmpvar_114) + 1.0);
  mediump vec3 tmpvar_128;
  mediump float x_129;
  x_129 = (1.0 - tmpvar_115);
  tmpvar_128 = (specColor_104 + ((1.0 - specColor_104) * (
    (x_129 * x_129)
   * 
    ((x_129 * x_129) * x_129)
  )));
  color_100 = (((
    (diffColor_106 * LIGHT_COLOR)
   * diffuseTerm_101) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_126)
       / 
        ((tmpvar_127 * tmpvar_127) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_113 * (
          (tmpvar_112 * (1.0 - tmpvar_125))
         + tmpvar_125)) + (tmpvar_112 * (
          (tmpvar_113 * (1.0 - tmpvar_125))
         + tmpvar_125))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_113)) * LIGHT_COLOR)
   * tmpvar_128)) * tmpvar_17);
  color_100 = (color_100 + tmpvar_5);
  outColor_1.xyz = color_100;
  outColor_1.w = (tmpvar_12.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    highp vec2 tmpvar_18;
    tmpvar_18.x = LIGHT_PARAM.z;
    tmpvar_18.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_19;
    tmpvar_19.xy = tmpvar_18;
    highp float tmpvar_20;
    tmpvar_20 = (1.0/(LIGHT_PARAM.z));
    tmpvar_19.z = tmpvar_20;
    tmpvar_19.w = tmpvar_20;
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_21;
    highp vec2 tmpvar_22;
    tmpvar_22 = tmpvar_19.xy;
    shadow_21 = 0.0;
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_16.xy - LIGHT_PARAM.zz);
    tmpvar_23.z = shadowCoord_16.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_21 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_16.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_16.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_21 = (tmpvar_25 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_22.x;
    tmpvar_30.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_16.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_16.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_33);
    highp vec2 tmpvar_34;
    tmpvar_34.y = 0.0;
    tmpvar_34.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (shadowCoord_16.xy + tmpvar_34);
    tmpvar_35.z = shadowCoord_16.z;
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_37);
    highp vec4 tmpvar_38;
    tmpvar_38 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_16.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.y = 0.0;
    tmpvar_40.x = tmpvar_22.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_16.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_16.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = -(LIGHT_PARAM.z);
    tmpvar_44.y = tmpvar_22.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_16.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = 0.0;
    tmpvar_48.y = tmpvar_22.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_16.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_16.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_51);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_16.xy + LIGHT_PARAM.zz);
    tmpvar_52.z = shadowCoord_16.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_54);
    shadow_21 = (shadow_21 / 9.0);
    tmpvar_17 = mix (1.0, shadow_21, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_57;
  highp vec3 color_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 albedo_61;
  albedo_61 = tmpvar_2;
  mediump vec3 specColor_62;
  specColor_62 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_61 * tmpvar_3));
  mediump float tmpvar_63;
  tmpvar_63 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_57 = 0.0;
  mediump vec3 diffColor_64;
  mediump float alpha_65;
  alpha_65 = tmpvar_57;
  mediump float outModifiedAlpha_66;
  diffColor_64 = ((albedo_61 * tmpvar_63) * alpha_65);
  outModifiedAlpha_66 = ((1.0 - tmpvar_63) + (alpha_65 * tmpvar_63));
  tmpvar_57 = outModifiedAlpha_66;
  mediump float tmpvar_67;
  tmpvar_67 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_67;
  highp vec3 tmpvar_68;
  highp vec3 inVec_69;
  inVec_69 = (tmpvar_56 + tmpvar_55);
  tmpvar_68 = (inVec_69 * inversesqrt(max (0.001, 
    dot (inVec_69, inVec_69)
  )));
  highp float tmpvar_70;
  tmpvar_70 = abs(dot (tmpvar_55, tmpvar_6));
  highp float tmpvar_71;
  tmpvar_71 = clamp (dot (tmpvar_6, tmpvar_56), 0.0, 1.0);
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_6, tmpvar_68), 0.0, 1.0);
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = clamp (dot (tmpvar_56, tmpvar_68), 0.0, 1.0);
  tmpvar_73 = tmpvar_74;
  mediump float tmpvar_75;
  mediump float NdotV_76;
  NdotV_76 = tmpvar_70;
  mediump float NdotL_77;
  NdotL_77 = tmpvar_71;
  mediump float perceptualRoughness_78;
  perceptualRoughness_78 = perceptualRoughness_60;
  mediump float tmpvar_79;
  tmpvar_79 = (0.5 + ((2.0 * tmpvar_73) * (tmpvar_73 * perceptualRoughness_78)));
  mediump float x_80;
  x_80 = (1.0 - NdotL_77);
  mediump float x_81;
  x_81 = (1.0 - NdotV_76);
  tmpvar_75 = ((1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_80 * x_80) * ((x_80 * x_80) * x_80))
  )) * (1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_81 * x_81) * ((x_81 * x_81) * x_81))
  )));
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_75 * tmpvar_71);
  diffuseTerm_59 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_84;
  tmpvar_84 = (tmpvar_83 * tmpvar_83);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_72 * tmpvar_84)
   - tmpvar_72) * tmpvar_72) + 1.0);
  mediump vec3 tmpvar_86;
  mediump float x_87;
  x_87 = (1.0 - tmpvar_73);
  tmpvar_86 = (specColor_62 + ((1.0 - specColor_62) * (
    (x_87 * x_87)
   * 
    ((x_87 * x_87) * x_87)
  )));
  color_58 = (((
    (diffColor_64 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_84)
       / 
        ((tmpvar_85 * tmpvar_85) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_71 * (
          (tmpvar_70 * (1.0 - tmpvar_83))
         + tmpvar_83)) + (tmpvar_70 * (
          (tmpvar_71 * (1.0 - tmpvar_83))
         + tmpvar_83))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_71)) * LIGHT_COLOR)
   * tmpvar_86)) * tmpvar_17);
  color_58 = (color_58 + tmpvar_5);
  outColor_1.xyz = color_58;
  outColor_1.w = (tmpvar_12.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp vec4 o_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_5 * 0.5);
  o_10.zw = tmpvar_11.zw;
  o_10.xy = (tmpvar_11.xy + tmpvar_11.ww);
  o_10.y = ((2.0 * tmpvar_11.w) - o_10.y);
  o_10.zw = tmpvar_5.zw;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_10;
  gl_Position = (tmpvar_7 * tmpvar_5);
}

]===],
		psShader = [===[uniform sampler2D _DiffuseTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _MetallicValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  mediump float tmpvar_2;
  highp vec4 metallicColor_3;
  highp vec4 col_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_4 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (col_4 * _DiffuseValue);
  metallicColor_3 = tmpvar_5;
  tmpvar_2 = (metallicColor_3.x * _MetallicValue);
  highp float tmpvar_7;
  mediump float tmpvar_8;
  tmpvar_8 = (0.7790837 - (tmpvar_2 * 0.7790837));
  tmpvar_7 = 0.0;
  mediump float alpha_9;
  alpha_9 = tmpvar_7;
  mediump float outModifiedAlpha_10;
  outModifiedAlpha_10 = ((1.0 - tmpvar_8) + (alpha_9 * tmpvar_8));
  tmpvar_7 = outModifiedAlpha_10;
  outColor_1.xyz = ((tmpvar_6 * _EmissiveValue) * _EmissiveColor).xyz;
  outColor_1.w = (tmpvar_6.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp vec4 o_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_5 * 0.5);
  o_10.zw = tmpvar_11.zw;
  o_10.xy = (tmpvar_11.xy + tmpvar_11.ww);
  o_10.y = ((2.0 * tmpvar_11.w) - o_10.y);
  o_10.zw = tmpvar_5.zw;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_10;
  gl_Position = (tmpvar_7 * tmpvar_5);
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec4 normalColor_5;
  highp vec4 roughnessColor_6;
  highp vec4 metallicColor_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (col_8 * _DiffuseValue);
  metallicColor_7 = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_6 = tmpvar_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_5 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_10.xyz;
  tmpvar_3 = (metallicColor_7.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_6.w * _RoughnessValue);
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (normalColor_5 * vec4(_NormalValue)).xyz;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_17;
  highp vec3 color_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 albedo_21;
  albedo_21 = tmpvar_2;
  mediump vec3 specColor_22;
  specColor_22 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_21 * tmpvar_3));
  mediump float tmpvar_23;
  tmpvar_23 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_17 = 0.0;
  mediump vec3 diffColor_24;
  mediump float alpha_25;
  alpha_25 = tmpvar_17;
  mediump float outModifiedAlpha_26;
  diffColor_24 = ((albedo_21 * tmpvar_23) * alpha_25);
  outModifiedAlpha_26 = ((1.0 - tmpvar_23) + (alpha_25 * tmpvar_23));
  tmpvar_17 = outModifiedAlpha_26;
  mediump float tmpvar_27;
  tmpvar_27 = (1.0 - tmpvar_4);
  perceptualRoughness_20 = tmpvar_27;
  highp vec3 tmpvar_28;
  highp vec3 inVec_29;
  inVec_29 = (tmpvar_15 + tmpvar_14);
  tmpvar_28 = (inVec_29 * inversesqrt(max (0.001, 
    dot (inVec_29, inVec_29)
  )));
  highp float tmpvar_30;
  tmpvar_30 = abs(dot (tmpvar_14, tmpvar_16));
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_16, tmpvar_15), 0.0, 1.0);
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_16, tmpvar_28), 0.0, 1.0);
  mediump float tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = clamp (dot (tmpvar_15, tmpvar_28), 0.0, 1.0);
  tmpvar_33 = tmpvar_34;
  mediump float tmpvar_35;
  mediump float NdotV_36;
  NdotV_36 = tmpvar_30;
  mediump float NdotL_37;
  NdotL_37 = tmpvar_31;
  mediump float perceptualRoughness_38;
  perceptualRoughness_38 = perceptualRoughness_20;
  mediump float tmpvar_39;
  tmpvar_39 = (0.5 + ((2.0 * tmpvar_33) * (tmpvar_33 * perceptualRoughness_38)));
  mediump float x_40;
  x_40 = (1.0 - NdotL_37);
  mediump float x_41;
  x_41 = (1.0 - NdotV_36);
  tmpvar_35 = ((1.0 + (
    (tmpvar_39 - 1.0)
   * 
    ((x_40 * x_40) * ((x_40 * x_40) * x_40))
  )) * (1.0 + (
    (tmpvar_39 - 1.0)
   * 
    ((x_41 * x_41) * ((x_41 * x_41) * x_41))
  )));
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_35 * tmpvar_31);
  diffuseTerm_19 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_44;
  tmpvar_44 = (tmpvar_43 * tmpvar_43);
  highp float tmpvar_45;
  tmpvar_45 = (((
    (tmpvar_32 * tmpvar_44)
   - tmpvar_32) * tmpvar_32) + 1.0);
  mediump vec3 tmpvar_46;
  mediump float x_47;
  x_47 = (1.0 - tmpvar_33);
  tmpvar_46 = (specColor_22 + ((1.0 - specColor_22) * (
    (x_47 * x_47)
   * 
    ((x_47 * x_47) * x_47)
  )));
  color_18 = (((diffColor_24 * LIGHT_COLOR) * diffuseTerm_19) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_44) / (
        (tmpvar_45 * tmpvar_45)
       + 1e-7)) * (0.5 / (
        ((tmpvar_31 * ((tmpvar_30 * 
          (1.0 - tmpvar_43)
        ) + tmpvar_43)) + (tmpvar_30 * ((tmpvar_31 * 
          (1.0 - tmpvar_43)
        ) + tmpvar_43)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_31))
   * LIGHT_COLOR) * tmpvar_46));
  color_18 = (color_18 + ((tmpvar_10 * _EmissiveValue) * _EmissiveColor).xyz);
  outColor_1.xyz = color_18;
  outColor_1.w = (tmpvar_10.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_18;
    highp vec2 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_23.x);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_23.x, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_23.x, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec4 computedWeight_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_23.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_23.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_23.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    computedWeight_31 = (computedArea_32 * 0.44444);
    highp vec2 tmpvar_38;
    tmpvar_38 = (computedWeight_24.xz + computedWeight_24.yw);
    highp vec2 tmpvar_39;
    tmpvar_39 = (computedWeight_31.xz + computedWeight_31.yw);
    fetchesOffsetsU_19 = (((computedWeight_24.yw / tmpvar_38) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_18 = (((computedWeight_31.yw / tmpvar_39) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_19.x;
    tmpvar_41.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_16.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_20 = ((tmpvar_38.x * tmpvar_39.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_19.y;
    tmpvar_44.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_19.x;
    tmpvar_47.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_16.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_20 = (shadow_20 + ((tmpvar_38.x * tmpvar_39.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_19.y;
    tmpvar_50.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_16.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.y) * tmpvar_52));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  highp vec3 color_56;
  mediump float diffuseTerm_57;
  highp float perceptualRoughness_58;
  mediump vec3 albedo_59;
  albedo_59 = tmpvar_2;
  mediump vec3 specColor_60;
  specColor_60 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_59 * tmpvar_3));
  mediump float tmpvar_61;
  tmpvar_61 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_55 = 0.0;
  mediump vec3 diffColor_62;
  mediump float alpha_63;
  alpha_63 = tmpvar_55;
  mediump float outModifiedAlpha_64;
  diffColor_62 = ((albedo_59 * tmpvar_61) * alpha_63);
  outModifiedAlpha_64 = ((1.0 - tmpvar_61) + (alpha_63 * tmpvar_61));
  tmpvar_55 = outModifiedAlpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_58 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (tmpvar_54 + tmpvar_53);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_6, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_54, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_58;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_57 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_58 * perceptualRoughness_58), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_60 + ((1.0 - specColor_60) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  color_56 = (((
    (diffColor_62 * LIGHT_COLOR)
   * diffuseTerm_57) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * tmpvar_17);
  color_56 = (color_56 + tmpvar_5);
  outColor_1.xyz = color_56;
  outColor_1.w = (tmpvar_12.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_18;
    highp vec3 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 texelsWeightsA_32;
    highp vec3 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.16 * tmpvar_37);
    texelsWeightsA_32.y = (0.16 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.16 * (computedArea_34.y + 1.0));
    texelsWeightsB_33.x = (0.16 * (computedArea_34.z + 1.0));
    texelsWeightsB_33.y = (0.16 * computedAreaUncut_35.z);
    texelsWeightsB_33.z = (0.16 * tmpvar_36);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_24.y;
    tmpvar_41.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.z = texelsWeightsB_33.y;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_32.y;
    tmpvar_44.yz = texelsWeightsB_33.xz;
    highp vec3 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec3 tmpvar_46;
    tmpvar_46.x = texelsWeightsA_24.y;
    tmpvar_46.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_47;
    tmpvar_47.x = texelsWeightsA_32.y;
    tmpvar_47.yz = texelsWeightsB_33.xz;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.x;
    tmpvar_58.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.y;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.z;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.x;
    tmpvar_67.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.y;
    tmpvar_70.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.z;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_75));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_76 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_78;
  highp vec3 color_79;
  mediump float diffuseTerm_80;
  highp float perceptualRoughness_81;
  mediump vec3 albedo_82;
  albedo_82 = tmpvar_2;
  mediump vec3 specColor_83;
  specColor_83 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_82 * tmpvar_3));
  mediump float tmpvar_84;
  tmpvar_84 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_78 = 0.0;
  mediump vec3 diffColor_85;
  mediump float alpha_86;
  alpha_86 = tmpvar_78;
  mediump float outModifiedAlpha_87;
  diffColor_85 = ((albedo_82 * tmpvar_84) * alpha_86);
  outModifiedAlpha_87 = ((1.0 - tmpvar_84) + (alpha_86 * tmpvar_84));
  tmpvar_78 = outModifiedAlpha_87;
  mediump float tmpvar_88;
  tmpvar_88 = (1.0 - tmpvar_4);
  perceptualRoughness_81 = tmpvar_88;
  highp vec3 tmpvar_89;
  highp vec3 inVec_90;
  inVec_90 = (tmpvar_77 + tmpvar_76);
  tmpvar_89 = (inVec_90 * inversesqrt(max (0.001, 
    dot (inVec_90, inVec_90)
  )));
  highp float tmpvar_91;
  tmpvar_91 = abs(dot (tmpvar_76, tmpvar_6));
  highp float tmpvar_92;
  tmpvar_92 = clamp (dot (tmpvar_6, tmpvar_77), 0.0, 1.0);
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_6, tmpvar_89), 0.0, 1.0);
  mediump float tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = clamp (dot (tmpvar_77, tmpvar_89), 0.0, 1.0);
  tmpvar_94 = tmpvar_95;
  mediump float tmpvar_96;
  mediump float NdotV_97;
  NdotV_97 = tmpvar_91;
  mediump float NdotL_98;
  NdotL_98 = tmpvar_92;
  mediump float perceptualRoughness_99;
  perceptualRoughness_99 = perceptualRoughness_81;
  mediump float tmpvar_100;
  tmpvar_100 = (0.5 + ((2.0 * tmpvar_94) * (tmpvar_94 * perceptualRoughness_99)));
  mediump float x_101;
  x_101 = (1.0 - NdotL_98);
  mediump float x_102;
  x_102 = (1.0 - NdotV_97);
  tmpvar_96 = ((1.0 + (
    (tmpvar_100 - 1.0)
   * 
    ((x_101 * x_101) * ((x_101 * x_101) * x_101))
  )) * (1.0 + (
    (tmpvar_100 - 1.0)
   * 
    ((x_102 * x_102) * ((x_102 * x_102) * x_102))
  )));
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_96 * tmpvar_92);
  diffuseTerm_80 = tmpvar_103;
  highp float tmpvar_104;
  tmpvar_104 = max ((perceptualRoughness_81 * perceptualRoughness_81), 0.002);
  highp float tmpvar_105;
  tmpvar_105 = (tmpvar_104 * tmpvar_104);
  highp float tmpvar_106;
  tmpvar_106 = (((
    (tmpvar_93 * tmpvar_105)
   - tmpvar_93) * tmpvar_93) + 1.0);
  mediump vec3 tmpvar_107;
  mediump float x_108;
  x_108 = (1.0 - tmpvar_94);
  tmpvar_107 = (specColor_83 + ((1.0 - specColor_83) * (
    (x_108 * x_108)
   * 
    ((x_108 * x_108) * x_108)
  )));
  color_79 = (((
    (diffColor_85 * LIGHT_COLOR)
   * diffuseTerm_80) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_105)
       / 
        ((tmpvar_106 * tmpvar_106) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_92 * (
          (tmpvar_91 * (1.0 - tmpvar_104))
         + tmpvar_104)) + (tmpvar_91 * (
          (tmpvar_92 * (1.0 - tmpvar_104))
         + tmpvar_104))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_92)) * LIGHT_COLOR)
   * tmpvar_107)) * tmpvar_17);
  color_79 = (color_79 + tmpvar_5);
  outColor_1.xyz = color_79;
  outColor_1.w = (tmpvar_12.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_18;
    highp vec4 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 texelsWeightsA_32;
    highp vec4 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.081632 * tmpvar_37);
    texelsWeightsA_32.y = (0.081632 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.081632 * (computedAreaUncut_35.y + 1.0));
    texelsWeightsA_32.w = (0.081632 * (computedArea_34.y + 2.0));
    texelsWeightsB_33.x = (0.081632 * (computedArea_34.z + 2.0));
    texelsWeightsB_33.y = (0.081632 * (computedAreaUncut_35.z + 1.0));
    texelsWeightsB_33.z = (0.081632 * computedAreaUncut_35.z);
    texelsWeightsB_33.w = (0.081632 * tmpvar_36);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_24.yw;
    tmpvar_41.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.zw = texelsWeightsB_33.xz;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_32.yw;
    tmpvar_44.zw = texelsWeightsB_33.yw;
    highp vec4 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec4 tmpvar_46;
    tmpvar_46.xy = texelsWeightsA_24.yw;
    tmpvar_46.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_47;
    tmpvar_47.xy = texelsWeightsA_32.yw;
    tmpvar_47.zw = texelsWeightsB_33.yw;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.w;
    tmpvar_58.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.x;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.y;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.z;
    tmpvar_67.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.w;
    tmpvar_70.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.y) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.x;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_19.y;
    tmpvar_76.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_48 + tmpvar_76);
    tmpvar_77.z = shadowCoord_16.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_19.z;
    tmpvar_79.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_48 + tmpvar_79);
    tmpvar_80.z = shadowCoord_16.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_19.w;
    tmpvar_82.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_48 + tmpvar_82);
    tmpvar_83.z = shadowCoord_16.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.z) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_19.x;
    tmpvar_85.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_48 + tmpvar_85);
    tmpvar_86.z = shadowCoord_16.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_19.y;
    tmpvar_88.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_48 + tmpvar_88);
    tmpvar_89.z = shadowCoord_16.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_19.z;
    tmpvar_91.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_48 + tmpvar_91);
    tmpvar_92.z = shadowCoord_16.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.w) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_19.w;
    tmpvar_94.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_48 + tmpvar_94);
    tmpvar_95.z = shadowCoord_16.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.w) * tmpvar_96));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_97 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_99;
  highp vec3 color_100;
  mediump float diffuseTerm_101;
  highp float perceptualRoughness_102;
  mediump vec3 albedo_103;
  albedo_103 = tmpvar_2;
  mediump vec3 specColor_104;
  specColor_104 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_103 * tmpvar_3));
  mediump float tmpvar_105;
  tmpvar_105 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_99 = 0.0;
  mediump vec3 diffColor_106;
  mediump float alpha_107;
  alpha_107 = tmpvar_99;
  mediump float outModifiedAlpha_108;
  diffColor_106 = ((albedo_103 * tmpvar_105) * alpha_107);
  outModifiedAlpha_108 = ((1.0 - tmpvar_105) + (alpha_107 * tmpvar_105));
  tmpvar_99 = outModifiedAlpha_108;
  mediump float tmpvar_109;
  tmpvar_109 = (1.0 - tmpvar_4);
  perceptualRoughness_102 = tmpvar_109;
  highp vec3 tmpvar_110;
  highp vec3 inVec_111;
  inVec_111 = (tmpvar_98 + tmpvar_97);
  tmpvar_110 = (inVec_111 * inversesqrt(max (0.001, 
    dot (inVec_111, inVec_111)
  )));
  highp float tmpvar_112;
  tmpvar_112 = abs(dot (tmpvar_97, tmpvar_6));
  highp float tmpvar_113;
  tmpvar_113 = clamp (dot (tmpvar_6, tmpvar_98), 0.0, 1.0);
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_6, tmpvar_110), 0.0, 1.0);
  mediump float tmpvar_115;
  highp float tmpvar_116;
  tmpvar_116 = clamp (dot (tmpvar_98, tmpvar_110), 0.0, 1.0);
  tmpvar_115 = tmpvar_116;
  mediump float tmpvar_117;
  mediump float NdotV_118;
  NdotV_118 = tmpvar_112;
  mediump float NdotL_119;
  NdotL_119 = tmpvar_113;
  mediump float perceptualRoughness_120;
  perceptualRoughness_120 = perceptualRoughness_102;
  mediump float tmpvar_121;
  tmpvar_121 = (0.5 + ((2.0 * tmpvar_115) * (tmpvar_115 * perceptualRoughness_120)));
  mediump float x_122;
  x_122 = (1.0 - NdotL_119);
  mediump float x_123;
  x_123 = (1.0 - NdotV_118);
  tmpvar_117 = ((1.0 + (
    (tmpvar_121 - 1.0)
   * 
    ((x_122 * x_122) * ((x_122 * x_122) * x_122))
  )) * (1.0 + (
    (tmpvar_121 - 1.0)
   * 
    ((x_123 * x_123) * ((x_123 * x_123) * x_123))
  )));
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_117 * tmpvar_113);
  diffuseTerm_101 = tmpvar_124;
  highp float tmpvar_125;
  tmpvar_125 = max ((perceptualRoughness_102 * perceptualRoughness_102), 0.002);
  highp float tmpvar_126;
  tmpvar_126 = (tmpvar_125 * tmpvar_125);
  highp float tmpvar_127;
  tmpvar_127 = (((
    (tmpvar_114 * tmpvar_126)
   - tmpvar_114) * tmpvar_114) + 1.0);
  mediump vec3 tmpvar_128;
  mediump float x_129;
  x_129 = (1.0 - tmpvar_115);
  tmpvar_128 = (specColor_104 + ((1.0 - specColor_104) * (
    (x_129 * x_129)
   * 
    ((x_129 * x_129) * x_129)
  )));
  color_100 = (((
    (diffColor_106 * LIGHT_COLOR)
   * diffuseTerm_101) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_126)
       / 
        ((tmpvar_127 * tmpvar_127) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_113 * (
          (tmpvar_112 * (1.0 - tmpvar_125))
         + tmpvar_125)) + (tmpvar_112 * (
          (tmpvar_113 * (1.0 - tmpvar_125))
         + tmpvar_125))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_113)) * LIGHT_COLOR)
   * tmpvar_128)) * tmpvar_17);
  color_100 = (color_100 + tmpvar_5);
  outColor_1.xyz = color_100;
  outColor_1.w = (tmpvar_12.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHAPREMULTIPLY_ON","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _Opacity;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    highp vec2 tmpvar_18;
    tmpvar_18.x = LIGHT_PARAM.z;
    tmpvar_18.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_19;
    tmpvar_19.xy = tmpvar_18;
    highp float tmpvar_20;
    tmpvar_20 = (1.0/(LIGHT_PARAM.z));
    tmpvar_19.z = tmpvar_20;
    tmpvar_19.w = tmpvar_20;
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_21;
    highp vec2 tmpvar_22;
    tmpvar_22 = tmpvar_19.xy;
    shadow_21 = 0.0;
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_16.xy - LIGHT_PARAM.zz);
    tmpvar_23.z = shadowCoord_16.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_21 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_16.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_16.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_21 = (tmpvar_25 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_22.x;
    tmpvar_30.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_16.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_16.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_33);
    highp vec2 tmpvar_34;
    tmpvar_34.y = 0.0;
    tmpvar_34.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (shadowCoord_16.xy + tmpvar_34);
    tmpvar_35.z = shadowCoord_16.z;
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_37);
    highp vec4 tmpvar_38;
    tmpvar_38 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_16.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.y = 0.0;
    tmpvar_40.x = tmpvar_22.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_16.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_16.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = -(LIGHT_PARAM.z);
    tmpvar_44.y = tmpvar_22.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_16.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = 0.0;
    tmpvar_48.y = tmpvar_22.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_16.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_16.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_51);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_16.xy + LIGHT_PARAM.zz);
    tmpvar_52.z = shadowCoord_16.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_54);
    shadow_21 = (shadow_21 / 9.0);
    tmpvar_17 = mix (1.0, shadow_21, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_57;
  highp vec3 color_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 albedo_61;
  albedo_61 = tmpvar_2;
  mediump vec3 specColor_62;
  specColor_62 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_61 * tmpvar_3));
  mediump float tmpvar_63;
  tmpvar_63 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_57 = 0.0;
  mediump vec3 diffColor_64;
  mediump float alpha_65;
  alpha_65 = tmpvar_57;
  mediump float outModifiedAlpha_66;
  diffColor_64 = ((albedo_61 * tmpvar_63) * alpha_65);
  outModifiedAlpha_66 = ((1.0 - tmpvar_63) + (alpha_65 * tmpvar_63));
  tmpvar_57 = outModifiedAlpha_66;
  mediump float tmpvar_67;
  tmpvar_67 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_67;
  highp vec3 tmpvar_68;
  highp vec3 inVec_69;
  inVec_69 = (tmpvar_56 + tmpvar_55);
  tmpvar_68 = (inVec_69 * inversesqrt(max (0.001, 
    dot (inVec_69, inVec_69)
  )));
  highp float tmpvar_70;
  tmpvar_70 = abs(dot (tmpvar_55, tmpvar_6));
  highp float tmpvar_71;
  tmpvar_71 = clamp (dot (tmpvar_6, tmpvar_56), 0.0, 1.0);
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_6, tmpvar_68), 0.0, 1.0);
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = clamp (dot (tmpvar_56, tmpvar_68), 0.0, 1.0);
  tmpvar_73 = tmpvar_74;
  mediump float tmpvar_75;
  mediump float NdotV_76;
  NdotV_76 = tmpvar_70;
  mediump float NdotL_77;
  NdotL_77 = tmpvar_71;
  mediump float perceptualRoughness_78;
  perceptualRoughness_78 = perceptualRoughness_60;
  mediump float tmpvar_79;
  tmpvar_79 = (0.5 + ((2.0 * tmpvar_73) * (tmpvar_73 * perceptualRoughness_78)));
  mediump float x_80;
  x_80 = (1.0 - NdotL_77);
  mediump float x_81;
  x_81 = (1.0 - NdotV_76);
  tmpvar_75 = ((1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_80 * x_80) * ((x_80 * x_80) * x_80))
  )) * (1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_81 * x_81) * ((x_81 * x_81) * x_81))
  )));
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_75 * tmpvar_71);
  diffuseTerm_59 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_84;
  tmpvar_84 = (tmpvar_83 * tmpvar_83);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_72 * tmpvar_84)
   - tmpvar_72) * tmpvar_72) + 1.0);
  mediump vec3 tmpvar_86;
  mediump float x_87;
  x_87 = (1.0 - tmpvar_73);
  tmpvar_86 = (specColor_62 + ((1.0 - specColor_62) * (
    (x_87 * x_87)
   * 
    ((x_87 * x_87) * x_87)
  )));
  color_58 = (((
    (diffColor_64 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_84)
       / 
        ((tmpvar_85 * tmpvar_85) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_71 * (
          (tmpvar_70 * (1.0 - tmpvar_83))
         + tmpvar_83)) + (tmpvar_70 * (
          (tmpvar_71 * (1.0 - tmpvar_83))
         + tmpvar_83))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_71)) * LIGHT_COLOR)
   * tmpvar_86)) * tmpvar_17);
  color_58 = (color_58 + tmpvar_5);
  outColor_1.xyz = color_58;
  outColor_1.w = (tmpvar_12.w * _Opacity);
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp vec4 o_15;
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_12 * 0.5);
  o_15.zw = tmpvar_16.zw;
  o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
  o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
  o_15.zw = tmpvar_12.zw;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_11[0].xyz;
  tmpvar_18[1] = tmpvar_11[1].xyz;
  tmpvar_18[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_11[0].xyz;
  tmpvar_20[1] = tmpvar_11[1].xyz;
  tmpvar_20[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_21[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_21[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[0] = tmpvar_11[0].xyz;
  tmpvar_22[1] = tmpvar_11[1].xyz;
  tmpvar_22[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_15;
  gl_Position = (tmpvar_13 * tmpvar_12);
}

]===],
		psShader = [===[uniform sampler2D _DiffuseTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = 0.0;
  mediump float alpha_5;
  alpha_5 = tmpvar_4;
  tmpvar_4 = alpha_5;
  outColor_1.xyz = ((col_2 * _DiffuseValue) * (_EmissiveValue * _EmissiveColor)).xyz;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp vec4 o_15;
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_12 * 0.5);
  o_15.zw = tmpvar_16.zw;
  o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
  o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
  o_15.zw = tmpvar_12.zw;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_11[0].xyz;
  tmpvar_18[1] = tmpvar_11[1].xyz;
  tmpvar_18[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_11[0].xyz;
  tmpvar_20[1] = tmpvar_11[1].xyz;
  tmpvar_20[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_21[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_21[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[0] = tmpvar_11[0].xyz;
  tmpvar_22[1] = tmpvar_11[1].xyz;
  tmpvar_22[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_15;
  gl_Position = (tmpvar_13 * tmpvar_12);
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec4 normalColor_5;
  highp vec4 roughnessColor_6;
  highp vec4 metallicColor_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (col_8 * _DiffuseValue);
  metallicColor_7 = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_6 = tmpvar_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_5 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_10.xyz;
  tmpvar_3 = (metallicColor_7.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_6.w * _RoughnessValue);
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (normalColor_5 * vec4(_NormalValue)).xyz;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_17;
  highp vec3 color_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_2;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_22 * tmpvar_3));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_17;
  tmpvar_17 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_4);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (tmpvar_15 + tmpvar_14);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_14, tmpvar_16));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_16, tmpvar_15), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_16, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_15, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  color_18 = (((tmpvar_21 * LIGHT_COLOR) * diffuseTerm_19) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_42) / (
        (tmpvar_43 * tmpvar_43)
       + 1e-7)) * (0.5 / (
        ((tmpvar_29 * ((tmpvar_28 * 
          (1.0 - tmpvar_41)
        ) + tmpvar_41)) + (tmpvar_28 * ((tmpvar_29 * 
          (1.0 - tmpvar_41)
        ) + tmpvar_41)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_29))
   * LIGHT_COLOR) * tmpvar_44));
  color_18 = (color_18 + ((tmpvar_10 * _EmissiveValue) * _EmissiveColor).xyz);
  outColor_1.xyz = color_18;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_18;
    highp vec2 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_23.x);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_23.x, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_23.x, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec4 computedWeight_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_23.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_23.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_23.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    computedWeight_31 = (computedArea_32 * 0.44444);
    highp vec2 tmpvar_38;
    tmpvar_38 = (computedWeight_24.xz + computedWeight_24.yw);
    highp vec2 tmpvar_39;
    tmpvar_39 = (computedWeight_31.xz + computedWeight_31.yw);
    fetchesOffsetsU_19 = (((computedWeight_24.yw / tmpvar_38) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_18 = (((computedWeight_31.yw / tmpvar_39) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_19.x;
    tmpvar_41.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_16.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_20 = ((tmpvar_38.x * tmpvar_39.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_19.y;
    tmpvar_44.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_19.x;
    tmpvar_47.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_16.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_20 = (shadow_20 + ((tmpvar_38.x * tmpvar_39.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_19.y;
    tmpvar_50.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_16.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.y) * tmpvar_52));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  highp vec3 color_56;
  mediump float diffuseTerm_57;
  highp float perceptualRoughness_58;
  mediump vec3 tmpvar_59;
  mediump vec3 albedo_60;
  albedo_60 = tmpvar_2;
  mediump vec3 specColor_61;
  specColor_61 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_60 * tmpvar_3));
  tmpvar_59 = (albedo_60 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_55 = 0.0;
  mediump float alpha_62;
  alpha_62 = tmpvar_55;
  tmpvar_55 = alpha_62;
  mediump float tmpvar_63;
  tmpvar_63 = (1.0 - tmpvar_4);
  perceptualRoughness_58 = tmpvar_63;
  highp vec3 tmpvar_64;
  highp vec3 inVec_65;
  inVec_65 = (tmpvar_54 + tmpvar_53);
  tmpvar_64 = (inVec_65 * inversesqrt(max (0.001, 
    dot (inVec_65, inVec_65)
  )));
  highp float tmpvar_66;
  tmpvar_66 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_6, tmpvar_64), 0.0, 1.0);
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_54, tmpvar_64), 0.0, 1.0);
  tmpvar_69 = tmpvar_70;
  mediump float tmpvar_71;
  mediump float NdotV_72;
  NdotV_72 = tmpvar_66;
  mediump float NdotL_73;
  NdotL_73 = tmpvar_67;
  mediump float perceptualRoughness_74;
  perceptualRoughness_74 = perceptualRoughness_58;
  mediump float tmpvar_75;
  tmpvar_75 = (0.5 + ((2.0 * tmpvar_69) * (tmpvar_69 * perceptualRoughness_74)));
  mediump float x_76;
  x_76 = (1.0 - NdotL_73);
  mediump float x_77;
  x_77 = (1.0 - NdotV_72);
  tmpvar_71 = ((1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )) * (1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_77 * x_77) * ((x_77 * x_77) * x_77))
  )));
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_71 * tmpvar_67);
  diffuseTerm_57 = tmpvar_78;
  highp float tmpvar_79;
  tmpvar_79 = max ((perceptualRoughness_58 * perceptualRoughness_58), 0.002);
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_79 * tmpvar_79);
  highp float tmpvar_81;
  tmpvar_81 = (((
    (tmpvar_68 * tmpvar_80)
   - tmpvar_68) * tmpvar_68) + 1.0);
  mediump vec3 tmpvar_82;
  mediump float x_83;
  x_83 = (1.0 - tmpvar_69);
  tmpvar_82 = (specColor_61 + ((1.0 - specColor_61) * (
    (x_83 * x_83)
   * 
    ((x_83 * x_83) * x_83)
  )));
  color_56 = (((
    (tmpvar_59 * LIGHT_COLOR)
   * diffuseTerm_57) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_80)
       / 
        ((tmpvar_81 * tmpvar_81) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_67 * (
          (tmpvar_66 * (1.0 - tmpvar_79))
         + tmpvar_79)) + (tmpvar_66 * (
          (tmpvar_67 * (1.0 - tmpvar_79))
         + tmpvar_79))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_67)) * LIGHT_COLOR)
   * tmpvar_82)) * tmpvar_17);
  color_56 = (color_56 + tmpvar_5);
  outColor_1.xyz = color_56;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_18;
    highp vec3 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 texelsWeightsA_32;
    highp vec3 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.16 * tmpvar_37);
    texelsWeightsA_32.y = (0.16 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.16 * (computedArea_34.y + 1.0));
    texelsWeightsB_33.x = (0.16 * (computedArea_34.z + 1.0));
    texelsWeightsB_33.y = (0.16 * computedAreaUncut_35.z);
    texelsWeightsB_33.z = (0.16 * tmpvar_36);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_24.y;
    tmpvar_41.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.z = texelsWeightsB_33.y;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_32.y;
    tmpvar_44.yz = texelsWeightsB_33.xz;
    highp vec3 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec3 tmpvar_46;
    tmpvar_46.x = texelsWeightsA_24.y;
    tmpvar_46.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_47;
    tmpvar_47.x = texelsWeightsA_32.y;
    tmpvar_47.yz = texelsWeightsB_33.xz;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.x;
    tmpvar_58.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.y;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.z;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.x;
    tmpvar_67.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.y;
    tmpvar_70.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.z;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_75));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_76 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_78;
  highp vec3 color_79;
  mediump float diffuseTerm_80;
  highp float perceptualRoughness_81;
  mediump vec3 tmpvar_82;
  mediump vec3 albedo_83;
  albedo_83 = tmpvar_2;
  mediump vec3 specColor_84;
  specColor_84 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_83 * tmpvar_3));
  tmpvar_82 = (albedo_83 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_78 = 0.0;
  mediump float alpha_85;
  alpha_85 = tmpvar_78;
  tmpvar_78 = alpha_85;
  mediump float tmpvar_86;
  tmpvar_86 = (1.0 - tmpvar_4);
  perceptualRoughness_81 = tmpvar_86;
  highp vec3 tmpvar_87;
  highp vec3 inVec_88;
  inVec_88 = (tmpvar_77 + tmpvar_76);
  tmpvar_87 = (inVec_88 * inversesqrt(max (0.001, 
    dot (inVec_88, inVec_88)
  )));
  highp float tmpvar_89;
  tmpvar_89 = abs(dot (tmpvar_76, tmpvar_6));
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_6, tmpvar_77), 0.0, 1.0);
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_6, tmpvar_87), 0.0, 1.0);
  mediump float tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_77, tmpvar_87), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  mediump float tmpvar_94;
  mediump float NdotV_95;
  NdotV_95 = tmpvar_89;
  mediump float NdotL_96;
  NdotL_96 = tmpvar_90;
  mediump float perceptualRoughness_97;
  perceptualRoughness_97 = perceptualRoughness_81;
  mediump float tmpvar_98;
  tmpvar_98 = (0.5 + ((2.0 * tmpvar_92) * (tmpvar_92 * perceptualRoughness_97)));
  mediump float x_99;
  x_99 = (1.0 - NdotL_96);
  mediump float x_100;
  x_100 = (1.0 - NdotV_95);
  tmpvar_94 = ((1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )) * (1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_100 * x_100) * ((x_100 * x_100) * x_100))
  )));
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_94 * tmpvar_90);
  diffuseTerm_80 = tmpvar_101;
  highp float tmpvar_102;
  tmpvar_102 = max ((perceptualRoughness_81 * perceptualRoughness_81), 0.002);
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_102 * tmpvar_102);
  highp float tmpvar_104;
  tmpvar_104 = (((
    (tmpvar_91 * tmpvar_103)
   - tmpvar_91) * tmpvar_91) + 1.0);
  mediump vec3 tmpvar_105;
  mediump float x_106;
  x_106 = (1.0 - tmpvar_92);
  tmpvar_105 = (specColor_84 + ((1.0 - specColor_84) * (
    (x_106 * x_106)
   * 
    ((x_106 * x_106) * x_106)
  )));
  color_79 = (((
    (tmpvar_82 * LIGHT_COLOR)
   * diffuseTerm_80) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_103)
       / 
        ((tmpvar_104 * tmpvar_104) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_90 * (
          (tmpvar_89 * (1.0 - tmpvar_102))
         + tmpvar_102)) + (tmpvar_89 * (
          (tmpvar_90 * (1.0 - tmpvar_102))
         + tmpvar_102))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_90)) * LIGHT_COLOR)
   * tmpvar_105)) * tmpvar_17);
  color_79 = (color_79 + tmpvar_5);
  outColor_1.xyz = color_79;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_18;
    highp vec4 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 texelsWeightsA_32;
    highp vec4 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.081632 * tmpvar_37);
    texelsWeightsA_32.y = (0.081632 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.081632 * (computedAreaUncut_35.y + 1.0));
    texelsWeightsA_32.w = (0.081632 * (computedArea_34.y + 2.0));
    texelsWeightsB_33.x = (0.081632 * (computedArea_34.z + 2.0));
    texelsWeightsB_33.y = (0.081632 * (computedAreaUncut_35.z + 1.0));
    texelsWeightsB_33.z = (0.081632 * computedAreaUncut_35.z);
    texelsWeightsB_33.w = (0.081632 * tmpvar_36);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_24.yw;
    tmpvar_41.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.zw = texelsWeightsB_33.xz;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_32.yw;
    tmpvar_44.zw = texelsWeightsB_33.yw;
    highp vec4 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec4 tmpvar_46;
    tmpvar_46.xy = texelsWeightsA_24.yw;
    tmpvar_46.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_47;
    tmpvar_47.xy = texelsWeightsA_32.yw;
    tmpvar_47.zw = texelsWeightsB_33.yw;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.w;
    tmpvar_58.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.x;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.y;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.z;
    tmpvar_67.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.w;
    tmpvar_70.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.y) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.x;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_19.y;
    tmpvar_76.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_48 + tmpvar_76);
    tmpvar_77.z = shadowCoord_16.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_19.z;
    tmpvar_79.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_48 + tmpvar_79);
    tmpvar_80.z = shadowCoord_16.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_19.w;
    tmpvar_82.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_48 + tmpvar_82);
    tmpvar_83.z = shadowCoord_16.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.z) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_19.x;
    tmpvar_85.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_48 + tmpvar_85);
    tmpvar_86.z = shadowCoord_16.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_19.y;
    tmpvar_88.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_48 + tmpvar_88);
    tmpvar_89.z = shadowCoord_16.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_19.z;
    tmpvar_91.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_48 + tmpvar_91);
    tmpvar_92.z = shadowCoord_16.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.w) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_19.w;
    tmpvar_94.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_48 + tmpvar_94);
    tmpvar_95.z = shadowCoord_16.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.w) * tmpvar_96));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_97 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_99;
  highp vec3 color_100;
  mediump float diffuseTerm_101;
  highp float perceptualRoughness_102;
  mediump vec3 tmpvar_103;
  mediump vec3 albedo_104;
  albedo_104 = tmpvar_2;
  mediump vec3 specColor_105;
  specColor_105 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_104 * tmpvar_3));
  tmpvar_103 = (albedo_104 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_99 = 0.0;
  mediump float alpha_106;
  alpha_106 = tmpvar_99;
  tmpvar_99 = alpha_106;
  mediump float tmpvar_107;
  tmpvar_107 = (1.0 - tmpvar_4);
  perceptualRoughness_102 = tmpvar_107;
  highp vec3 tmpvar_108;
  highp vec3 inVec_109;
  inVec_109 = (tmpvar_98 + tmpvar_97);
  tmpvar_108 = (inVec_109 * inversesqrt(max (0.001, 
    dot (inVec_109, inVec_109)
  )));
  highp float tmpvar_110;
  tmpvar_110 = abs(dot (tmpvar_97, tmpvar_6));
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_6, tmpvar_98), 0.0, 1.0);
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (tmpvar_6, tmpvar_108), 0.0, 1.0);
  mediump float tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_98, tmpvar_108), 0.0, 1.0);
  tmpvar_113 = tmpvar_114;
  mediump float tmpvar_115;
  mediump float NdotV_116;
  NdotV_116 = tmpvar_110;
  mediump float NdotL_117;
  NdotL_117 = tmpvar_111;
  mediump float perceptualRoughness_118;
  perceptualRoughness_118 = perceptualRoughness_102;
  mediump float tmpvar_119;
  tmpvar_119 = (0.5 + ((2.0 * tmpvar_113) * (tmpvar_113 * perceptualRoughness_118)));
  mediump float x_120;
  x_120 = (1.0 - NdotL_117);
  mediump float x_121;
  x_121 = (1.0 - NdotV_116);
  tmpvar_115 = ((1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )) * (1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_121 * x_121) * ((x_121 * x_121) * x_121))
  )));
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_115 * tmpvar_111);
  diffuseTerm_101 = tmpvar_122;
  highp float tmpvar_123;
  tmpvar_123 = max ((perceptualRoughness_102 * perceptualRoughness_102), 0.002);
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_123 * tmpvar_123);
  highp float tmpvar_125;
  tmpvar_125 = (((
    (tmpvar_112 * tmpvar_124)
   - tmpvar_112) * tmpvar_112) + 1.0);
  mediump vec3 tmpvar_126;
  mediump float x_127;
  x_127 = (1.0 - tmpvar_113);
  tmpvar_126 = (specColor_105 + ((1.0 - specColor_105) * (
    (x_127 * x_127)
   * 
    ((x_127 * x_127) * x_127)
  )));
  color_100 = (((
    (tmpvar_103 * LIGHT_COLOR)
   * diffuseTerm_101) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_124)
       / 
        ((tmpvar_125 * tmpvar_125) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_111 * (
          (tmpvar_110 * (1.0 - tmpvar_123))
         + tmpvar_123)) + (tmpvar_110 * (
          (tmpvar_111 * (1.0 - tmpvar_123))
         + tmpvar_123))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_111)) * LIGHT_COLOR)
   * tmpvar_126)) * tmpvar_17);
  color_100 = (color_100 + tmpvar_5);
  outColor_1.xyz = color_100;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_13 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_13.zw;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_12[0].xyz;
  tmpvar_19[1] = tmpvar_12[1].xyz;
  tmpvar_19[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_18 * (_glesNormal * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_20[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_20[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[0] = tmpvar_12[0].xyz;
  tmpvar_21[1] = tmpvar_12[1].xyz;
  tmpvar_21[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_20 * (_glesTangent * tmpvar_21)));
  highp mat3 tmpvar_22;
  tmpvar_22[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_22[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_22[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_23;
  tmpvar_23[0] = tmpvar_12[0].xyz;
  tmpvar_23[1] = tmpvar_12[1].xyz;
  tmpvar_23[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_22 * (_glesBinormal * tmpvar_23)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD5 = o_16;
  gl_Position = (tmpvar_14 * tmpvar_13);
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    highp vec2 tmpvar_18;
    tmpvar_18.x = LIGHT_PARAM.z;
    tmpvar_18.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_19;
    tmpvar_19.xy = tmpvar_18;
    highp float tmpvar_20;
    tmpvar_20 = (1.0/(LIGHT_PARAM.z));
    tmpvar_19.z = tmpvar_20;
    tmpvar_19.w = tmpvar_20;
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_21;
    highp vec2 tmpvar_22;
    tmpvar_22 = tmpvar_19.xy;
    shadow_21 = 0.0;
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_16.xy - LIGHT_PARAM.zz);
    tmpvar_23.z = shadowCoord_16.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_21 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_16.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_16.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_21 = (tmpvar_25 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_22.x;
    tmpvar_30.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_16.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_16.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_33);
    highp vec2 tmpvar_34;
    tmpvar_34.y = 0.0;
    tmpvar_34.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (shadowCoord_16.xy + tmpvar_34);
    tmpvar_35.z = shadowCoord_16.z;
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_37);
    highp vec4 tmpvar_38;
    tmpvar_38 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_16.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.y = 0.0;
    tmpvar_40.x = tmpvar_22.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_16.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_16.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = -(LIGHT_PARAM.z);
    tmpvar_44.y = tmpvar_22.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_16.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = 0.0;
    tmpvar_48.y = tmpvar_22.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_16.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_16.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_51);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_16.xy + LIGHT_PARAM.zz);
    tmpvar_52.z = shadowCoord_16.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_54);
    shadow_21 = (shadow_21 / 9.0);
    tmpvar_17 = mix (1.0, shadow_21, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_57;
  highp vec3 color_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 tmpvar_61;
  mediump vec3 albedo_62;
  albedo_62 = tmpvar_2;
  mediump vec3 specColor_63;
  specColor_63 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_62 * tmpvar_3));
  tmpvar_61 = (albedo_62 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_57 = 0.0;
  mediump float alpha_64;
  alpha_64 = tmpvar_57;
  tmpvar_57 = alpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (tmpvar_56 + tmpvar_55);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_55, tmpvar_6));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_6, tmpvar_56), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_6, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_56, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_60;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_59 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_63 + ((1.0 - specColor_63) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  color_58 = (((
    (tmpvar_61 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * tmpvar_17);
  color_58 = (color_58 + tmpvar_5);
  outColor_1.xyz = color_58;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp vec4 o_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_5 * 0.5);
  o_10.zw = tmpvar_11.zw;
  o_10.xy = (tmpvar_11.xy + tmpvar_11.ww);
  o_10.y = ((2.0 * tmpvar_11.w) - o_10.y);
  o_10.zw = tmpvar_5.zw;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_10;
  gl_Position = (tmpvar_7 * tmpvar_5);
}

]===],
		psShader = [===[uniform sampler2D _DiffuseTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  highp vec4 col_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = 0.0;
  mediump float alpha_5;
  alpha_5 = tmpvar_4;
  tmpvar_4 = alpha_5;
  outColor_1.xyz = ((col_2 * _DiffuseValue) * (_EmissiveValue * _EmissiveColor)).xyz;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp vec4 o_10;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_5 * 0.5);
  o_10.zw = tmpvar_11.zw;
  o_10.xy = (tmpvar_11.xy + tmpvar_11.ww);
  o_10.y = ((2.0 * tmpvar_11.w) - o_10.y);
  o_10.zw = tmpvar_5.zw;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_10;
  gl_Position = (tmpvar_7 * tmpvar_5);
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec4 normalColor_5;
  highp vec4 roughnessColor_6;
  highp vec4 metallicColor_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  highp vec4 tmpvar_10;
  tmpvar_10 = (col_8 * _DiffuseValue);
  metallicColor_7 = tmpvar_9;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_6 = tmpvar_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_5 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_10.xyz;
  tmpvar_3 = (metallicColor_7.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_6.w * _RoughnessValue);
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (normalColor_5 * vec4(_NormalValue)).xyz;
  tmpvar_14 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_15 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_17;
  highp vec3 color_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_2;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_22 * tmpvar_3));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_17 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_17;
  tmpvar_17 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_4);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (tmpvar_15 + tmpvar_14);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_14, tmpvar_16));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_16, tmpvar_15), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_16, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_15, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  color_18 = (((tmpvar_21 * LIGHT_COLOR) * diffuseTerm_19) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_42) / (
        (tmpvar_43 * tmpvar_43)
       + 1e-7)) * (0.5 / (
        ((tmpvar_29 * ((tmpvar_28 * 
          (1.0 - tmpvar_41)
        ) + tmpvar_41)) + (tmpvar_28 * ((tmpvar_29 * 
          (1.0 - tmpvar_41)
        ) + tmpvar_41)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_29))
   * LIGHT_COLOR) * tmpvar_44));
  color_18 = (color_18 + ((tmpvar_10 * _EmissiveValue) * _EmissiveColor).xyz);
  outColor_1.xyz = color_18;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_18;
    highp vec2 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 computedWeight_24;
    highp vec4 computedArea_25;
    highp vec4 computedAreaUncut_26;
    highp float tmpvar_27;
    tmpvar_27 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_27 - tmpvar_23.x);
    computedArea_25.x = tmpvar_28;
    computedAreaUncut_26.x = tmpvar_28;
    computedArea_25.w = tmpvar_27;
    computedAreaUncut_26.w = tmpvar_27;
    computedAreaUncut_26.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = min (tmpvar_23.x, 0.0);
    computedArea_25.y = (computedAreaUncut_26.y - (tmpvar_29 * tmpvar_29));
    computedAreaUncut_26.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = max (tmpvar_23.x, 0.0);
    computedArea_25.z = (computedAreaUncut_26.z - (tmpvar_30 * tmpvar_30));
    computedWeight_24 = (computedArea_25 * 0.44444);
    highp vec4 computedWeight_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_23.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_23.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_23.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    computedWeight_31 = (computedArea_32 * 0.44444);
    highp vec2 tmpvar_38;
    tmpvar_38 = (computedWeight_24.xz + computedWeight_24.yw);
    highp vec2 tmpvar_39;
    tmpvar_39 = (computedWeight_31.xz + computedWeight_31.yw);
    fetchesOffsetsU_19 = (((computedWeight_24.yw / tmpvar_38) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_18 = (((computedWeight_31.yw / tmpvar_39) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_19.x;
    tmpvar_41.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_16.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_20 = ((tmpvar_38.x * tmpvar_39.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_19.y;
    tmpvar_44.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_19.x;
    tmpvar_47.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_16.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_20 = (shadow_20 + ((tmpvar_38.x * tmpvar_39.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_19.y;
    tmpvar_50.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_16.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_20 = (shadow_20 + ((tmpvar_38.y * tmpvar_39.y) * tmpvar_52));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  highp vec3 color_56;
  mediump float diffuseTerm_57;
  highp float perceptualRoughness_58;
  mediump vec3 tmpvar_59;
  mediump vec3 albedo_60;
  albedo_60 = tmpvar_2;
  mediump vec3 specColor_61;
  specColor_61 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_60 * tmpvar_3));
  tmpvar_59 = (albedo_60 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_55 = 0.0;
  mediump float alpha_62;
  alpha_62 = tmpvar_55;
  tmpvar_55 = alpha_62;
  mediump float tmpvar_63;
  tmpvar_63 = (1.0 - tmpvar_4);
  perceptualRoughness_58 = tmpvar_63;
  highp vec3 tmpvar_64;
  highp vec3 inVec_65;
  inVec_65 = (tmpvar_54 + tmpvar_53);
  tmpvar_64 = (inVec_65 * inversesqrt(max (0.001, 
    dot (inVec_65, inVec_65)
  )));
  highp float tmpvar_66;
  tmpvar_66 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_6, tmpvar_64), 0.0, 1.0);
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_54, tmpvar_64), 0.0, 1.0);
  tmpvar_69 = tmpvar_70;
  mediump float tmpvar_71;
  mediump float NdotV_72;
  NdotV_72 = tmpvar_66;
  mediump float NdotL_73;
  NdotL_73 = tmpvar_67;
  mediump float perceptualRoughness_74;
  perceptualRoughness_74 = perceptualRoughness_58;
  mediump float tmpvar_75;
  tmpvar_75 = (0.5 + ((2.0 * tmpvar_69) * (tmpvar_69 * perceptualRoughness_74)));
  mediump float x_76;
  x_76 = (1.0 - NdotL_73);
  mediump float x_77;
  x_77 = (1.0 - NdotV_72);
  tmpvar_71 = ((1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )) * (1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_77 * x_77) * ((x_77 * x_77) * x_77))
  )));
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_71 * tmpvar_67);
  diffuseTerm_57 = tmpvar_78;
  highp float tmpvar_79;
  tmpvar_79 = max ((perceptualRoughness_58 * perceptualRoughness_58), 0.002);
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_79 * tmpvar_79);
  highp float tmpvar_81;
  tmpvar_81 = (((
    (tmpvar_68 * tmpvar_80)
   - tmpvar_68) * tmpvar_68) + 1.0);
  mediump vec3 tmpvar_82;
  mediump float x_83;
  x_83 = (1.0 - tmpvar_69);
  tmpvar_82 = (specColor_61 + ((1.0 - specColor_61) * (
    (x_83 * x_83)
   * 
    ((x_83 * x_83) * x_83)
  )));
  color_56 = (((
    (tmpvar_59 * LIGHT_COLOR)
   * diffuseTerm_57) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_80)
       / 
        ((tmpvar_81 * tmpvar_81) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_67 * (
          (tmpvar_66 * (1.0 - tmpvar_79))
         + tmpvar_79)) + (tmpvar_66 * (
          (tmpvar_67 * (1.0 - tmpvar_79))
         + tmpvar_79))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_67)) * LIGHT_COLOR)
   * tmpvar_82)) * tmpvar_17);
  color_56 = (color_56 + tmpvar_5);
  outColor_1.xyz = color_56;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_18;
    highp vec3 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 texelsWeightsA_32;
    highp vec3 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.16 * tmpvar_37);
    texelsWeightsA_32.y = (0.16 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.16 * (computedArea_34.y + 1.0));
    texelsWeightsB_33.x = (0.16 * (computedArea_34.z + 1.0));
    texelsWeightsB_33.y = (0.16 * computedAreaUncut_35.z);
    texelsWeightsB_33.z = (0.16 * tmpvar_36);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_24.y;
    tmpvar_41.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.z = texelsWeightsB_33.y;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_32.y;
    tmpvar_44.yz = texelsWeightsB_33.xz;
    highp vec3 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec3 tmpvar_46;
    tmpvar_46.x = texelsWeightsA_24.y;
    tmpvar_46.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_47;
    tmpvar_47.x = texelsWeightsA_32.y;
    tmpvar_47.yz = texelsWeightsB_33.xz;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.x;
    tmpvar_58.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.y;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.z;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.x;
    tmpvar_67.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.y;
    tmpvar_70.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.z;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_75));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_76;
  highp vec3 tmpvar_77;
  tmpvar_76 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_78;
  highp vec3 color_79;
  mediump float diffuseTerm_80;
  highp float perceptualRoughness_81;
  mediump vec3 tmpvar_82;
  mediump vec3 albedo_83;
  albedo_83 = tmpvar_2;
  mediump vec3 specColor_84;
  specColor_84 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_83 * tmpvar_3));
  tmpvar_82 = (albedo_83 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_78 = 0.0;
  mediump float alpha_85;
  alpha_85 = tmpvar_78;
  tmpvar_78 = alpha_85;
  mediump float tmpvar_86;
  tmpvar_86 = (1.0 - tmpvar_4);
  perceptualRoughness_81 = tmpvar_86;
  highp vec3 tmpvar_87;
  highp vec3 inVec_88;
  inVec_88 = (tmpvar_77 + tmpvar_76);
  tmpvar_87 = (inVec_88 * inversesqrt(max (0.001, 
    dot (inVec_88, inVec_88)
  )));
  highp float tmpvar_89;
  tmpvar_89 = abs(dot (tmpvar_76, tmpvar_6));
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_6, tmpvar_77), 0.0, 1.0);
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_6, tmpvar_87), 0.0, 1.0);
  mediump float tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_77, tmpvar_87), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  mediump float tmpvar_94;
  mediump float NdotV_95;
  NdotV_95 = tmpvar_89;
  mediump float NdotL_96;
  NdotL_96 = tmpvar_90;
  mediump float perceptualRoughness_97;
  perceptualRoughness_97 = perceptualRoughness_81;
  mediump float tmpvar_98;
  tmpvar_98 = (0.5 + ((2.0 * tmpvar_92) * (tmpvar_92 * perceptualRoughness_97)));
  mediump float x_99;
  x_99 = (1.0 - NdotL_96);
  mediump float x_100;
  x_100 = (1.0 - NdotV_95);
  tmpvar_94 = ((1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )) * (1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_100 * x_100) * ((x_100 * x_100) * x_100))
  )));
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_94 * tmpvar_90);
  diffuseTerm_80 = tmpvar_101;
  highp float tmpvar_102;
  tmpvar_102 = max ((perceptualRoughness_81 * perceptualRoughness_81), 0.002);
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_102 * tmpvar_102);
  highp float tmpvar_104;
  tmpvar_104 = (((
    (tmpvar_91 * tmpvar_103)
   - tmpvar_91) * tmpvar_91) + 1.0);
  mediump vec3 tmpvar_105;
  mediump float x_106;
  x_106 = (1.0 - tmpvar_92);
  tmpvar_105 = (specColor_84 + ((1.0 - specColor_84) * (
    (x_106 * x_106)
   * 
    ((x_106 * x_106) * x_106)
  )));
  color_79 = (((
    (tmpvar_82 * LIGHT_COLOR)
   * diffuseTerm_80) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_103)
       / 
        ((tmpvar_104 * tmpvar_104) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_90 * (
          (tmpvar_89 * (1.0 - tmpvar_102))
         + tmpvar_102)) + (tmpvar_89 * (
          (tmpvar_90 * (1.0 - tmpvar_102))
         + tmpvar_102))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_90)) * LIGHT_COLOR)
   * tmpvar_105)) * tmpvar_17);
  color_79 = (color_79 + tmpvar_5);
  outColor_1.xyz = color_79;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_18;
    highp vec4 fetchesOffsetsU_19;
    highp float shadow_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (shadowCoord_16.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_22;
    tmpvar_22 = floor((tmpvar_21 + 0.5));
    highp vec2 tmpvar_23;
    tmpvar_23 = (tmpvar_21 - tmpvar_22);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_23.x + 0.5) * (tmpvar_23.x + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_23.x);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_23.x) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_23.x, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_23.x) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_23.x, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 texelsWeightsA_32;
    highp vec4 texelsWeightsB_33;
    highp vec4 computedArea_34;
    highp vec4 computedAreaUncut_35;
    highp float tmpvar_36;
    tmpvar_36 = (((tmpvar_23.y + 0.5) * (tmpvar_23.y + 0.5)) * 0.5);
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_36 - tmpvar_23.y);
    computedArea_34.x = tmpvar_37;
    computedAreaUncut_35.x = tmpvar_37;
    computedArea_34.w = tmpvar_36;
    computedAreaUncut_35.w = tmpvar_36;
    computedAreaUncut_35.y = ((1.5 - tmpvar_23.y) - 0.5);
    highp float tmpvar_38;
    tmpvar_38 = min (tmpvar_23.y, 0.0);
    computedArea_34.y = (computedAreaUncut_35.y - (tmpvar_38 * tmpvar_38));
    computedAreaUncut_35.z = ((1.5 + tmpvar_23.y) - 0.5);
    highp float tmpvar_39;
    tmpvar_39 = max (tmpvar_23.y, 0.0);
    computedArea_34.z = (computedAreaUncut_35.z - (tmpvar_39 * tmpvar_39));
    texelsWeightsA_32.x = (0.081632 * tmpvar_37);
    texelsWeightsA_32.y = (0.081632 * computedAreaUncut_35.y);
    texelsWeightsA_32.z = (0.081632 * (computedAreaUncut_35.y + 1.0));
    texelsWeightsA_32.w = (0.081632 * (computedArea_34.y + 2.0));
    texelsWeightsB_33.x = (0.081632 * (computedArea_34.z + 2.0));
    texelsWeightsB_33.y = (0.081632 * (computedAreaUncut_35.z + 1.0));
    texelsWeightsB_33.z = (0.081632 * computedAreaUncut_35.z);
    texelsWeightsB_33.w = (0.081632 * tmpvar_36);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_24.xz;
    tmpvar_40.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_24.yw;
    tmpvar_41.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_32.xz;
    tmpvar_43.zw = texelsWeightsB_33.xz;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_32.yw;
    tmpvar_44.zw = texelsWeightsB_33.yw;
    highp vec4 tmpvar_45;
    tmpvar_45 = (tmpvar_43 + tmpvar_44);
    highp vec4 tmpvar_46;
    tmpvar_46.xy = texelsWeightsA_24.yw;
    tmpvar_46.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_47;
    tmpvar_47.xy = texelsWeightsA_32.yw;
    tmpvar_47.zw = texelsWeightsB_33.yw;
    fetchesOffsetsU_19 = (((tmpvar_46 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_18 = (((tmpvar_47 / tmpvar_45) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_48;
    tmpvar_48 = (tmpvar_22 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_19.x;
    tmpvar_49.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_48 + tmpvar_49);
    tmpvar_50.z = shadowCoord_16.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_20 = ((tmpvar_42.x * tmpvar_45.x) * tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_19.y;
    tmpvar_52.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_48 + tmpvar_52);
    tmpvar_53.z = shadowCoord_16.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_19.z;
    tmpvar_55.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_48 + tmpvar_55);
    tmpvar_56.z = shadowCoord_16.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_19.w;
    tmpvar_58.y = fetchesOffsetsV_18.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_48 + tmpvar_58);
    tmpvar_59.z = shadowCoord_16.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_19.x;
    tmpvar_61.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_48 + tmpvar_61);
    tmpvar_62.z = shadowCoord_16.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_19.y;
    tmpvar_64.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_48 + tmpvar_64);
    tmpvar_65.z = shadowCoord_16.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_19.z;
    tmpvar_67.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_48 + tmpvar_67);
    tmpvar_68.z = shadowCoord_16.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_19.w;
    tmpvar_70.y = fetchesOffsetsV_18.y;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_48 + tmpvar_70);
    tmpvar_71.z = shadowCoord_16.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.y) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_19.x;
    tmpvar_73.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_48 + tmpvar_73);
    tmpvar_74.z = shadowCoord_16.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_19.y;
    tmpvar_76.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_48 + tmpvar_76);
    tmpvar_77.z = shadowCoord_16.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_19.z;
    tmpvar_79.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_48 + tmpvar_79);
    tmpvar_80.z = shadowCoord_16.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_19.w;
    tmpvar_82.y = fetchesOffsetsV_18.z;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_48 + tmpvar_82);
    tmpvar_83.z = shadowCoord_16.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.z) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_19.x;
    tmpvar_85.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_48 + tmpvar_85);
    tmpvar_86.z = shadowCoord_16.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_20 = (shadow_20 + ((tmpvar_42.x * tmpvar_45.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_19.y;
    tmpvar_88.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_48 + tmpvar_88);
    tmpvar_89.z = shadowCoord_16.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_20 = (shadow_20 + ((tmpvar_42.y * tmpvar_45.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_19.z;
    tmpvar_91.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_48 + tmpvar_91);
    tmpvar_92.z = shadowCoord_16.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_20 = (shadow_20 + ((tmpvar_42.z * tmpvar_45.w) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_19.w;
    tmpvar_94.y = fetchesOffsetsV_18.w;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_48 + tmpvar_94);
    tmpvar_95.z = shadowCoord_16.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_20 = (shadow_20 + ((tmpvar_42.w * tmpvar_45.w) * tmpvar_96));
    tmpvar_17 = mix (1.0, shadow_20, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_97;
  highp vec3 tmpvar_98;
  tmpvar_97 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_99;
  highp vec3 color_100;
  mediump float diffuseTerm_101;
  highp float perceptualRoughness_102;
  mediump vec3 tmpvar_103;
  mediump vec3 albedo_104;
  albedo_104 = tmpvar_2;
  mediump vec3 specColor_105;
  specColor_105 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_104 * tmpvar_3));
  tmpvar_103 = (albedo_104 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_99 = 0.0;
  mediump float alpha_106;
  alpha_106 = tmpvar_99;
  tmpvar_99 = alpha_106;
  mediump float tmpvar_107;
  tmpvar_107 = (1.0 - tmpvar_4);
  perceptualRoughness_102 = tmpvar_107;
  highp vec3 tmpvar_108;
  highp vec3 inVec_109;
  inVec_109 = (tmpvar_98 + tmpvar_97);
  tmpvar_108 = (inVec_109 * inversesqrt(max (0.001, 
    dot (inVec_109, inVec_109)
  )));
  highp float tmpvar_110;
  tmpvar_110 = abs(dot (tmpvar_97, tmpvar_6));
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_6, tmpvar_98), 0.0, 1.0);
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (tmpvar_6, tmpvar_108), 0.0, 1.0);
  mediump float tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_98, tmpvar_108), 0.0, 1.0);
  tmpvar_113 = tmpvar_114;
  mediump float tmpvar_115;
  mediump float NdotV_116;
  NdotV_116 = tmpvar_110;
  mediump float NdotL_117;
  NdotL_117 = tmpvar_111;
  mediump float perceptualRoughness_118;
  perceptualRoughness_118 = perceptualRoughness_102;
  mediump float tmpvar_119;
  tmpvar_119 = (0.5 + ((2.0 * tmpvar_113) * (tmpvar_113 * perceptualRoughness_118)));
  mediump float x_120;
  x_120 = (1.0 - NdotL_117);
  mediump float x_121;
  x_121 = (1.0 - NdotV_116);
  tmpvar_115 = ((1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )) * (1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_121 * x_121) * ((x_121 * x_121) * x_121))
  )));
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_115 * tmpvar_111);
  diffuseTerm_101 = tmpvar_122;
  highp float tmpvar_123;
  tmpvar_123 = max ((perceptualRoughness_102 * perceptualRoughness_102), 0.002);
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_123 * tmpvar_123);
  highp float tmpvar_125;
  tmpvar_125 = (((
    (tmpvar_112 * tmpvar_124)
   - tmpvar_112) * tmpvar_112) + 1.0);
  mediump vec3 tmpvar_126;
  mediump float x_127;
  x_127 = (1.0 - tmpvar_113);
  tmpvar_126 = (specColor_105 + ((1.0 - specColor_105) * (
    (x_127 * x_127)
   * 
    ((x_127 * x_127) * x_127)
  )));
  color_100 = (((
    (tmpvar_103 * LIGHT_COLOR)
   * diffuseTerm_101) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_124)
       / 
        ((tmpvar_125 * tmpvar_125) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_111 * (
          (tmpvar_110 * (1.0 - tmpvar_123))
         + tmpvar_123)) + (tmpvar_110 * (
          (tmpvar_111 * (1.0 - tmpvar_123))
         + tmpvar_123))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_111)) * LIGHT_COLOR)
   * tmpvar_126)) * tmpvar_17);
  color_100 = (color_100 + tmpvar_5);
  outColor_1.xyz = color_100;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHAPREMULTIPLY_OFF","ALPHATEST_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RoughnessValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissiveColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_6 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_6.zw;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_13 * _glesNormal));
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_14 * _glesTangent));
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_15 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_17;
  tmpvar_17.w = 1.0;
  tmpvar_17.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_17)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD5 = o_11;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _NormalTex;
uniform sampler2D _RoughnessTex;
uniform highp float _DiffuseValue;
uniform highp float _EmissiveValue;
uniform highp float _NormalValue;
uniform highp float _MetallicValue;
uniform highp float _RoughnessValue;
uniform highp vec4 _EmissiveColor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec4 normalColor_7;
  highp vec4 roughnessColor_8;
  highp vec4 metallicColor_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (col_10 * _DiffuseValue);
  metallicColor_9 = tmpvar_11;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_RoughnessTex, xlv_TEXCOORD0);
  roughnessColor_8 = tmpvar_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_NormalTex, xlv_TEXCOORD0);
  normalColor_7 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  tmpvar_2 = tmpvar_12.xyz;
  tmpvar_3 = (metallicColor_9.x * _MetallicValue);
  tmpvar_4 = (roughnessColor_8.w * _RoughnessValue);
  tmpvar_6 = (normalColor_7 * vec4(_NormalValue)).xyz;
  tmpvar_5 = ((tmpvar_12 * _EmissiveValue) * _EmissiveColor).xyz;
  highp vec4 shadowCoord_16;
  shadowCoord_16 = xlv_TEXCOORD4;
  highp float tmpvar_17;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_17 = 1.0;
  } else {
    highp vec2 tmpvar_18;
    tmpvar_18.x = LIGHT_PARAM.z;
    tmpvar_18.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_19;
    tmpvar_19.xy = tmpvar_18;
    highp float tmpvar_20;
    tmpvar_20 = (1.0/(LIGHT_PARAM.z));
    tmpvar_19.z = tmpvar_20;
    tmpvar_19.w = tmpvar_20;
    shadowCoord_16.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_21;
    highp vec2 tmpvar_22;
    tmpvar_22 = tmpvar_19.xy;
    shadow_21 = 0.0;
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_16.xy - LIGHT_PARAM.zz);
    tmpvar_23.z = shadowCoord_16.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_21 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_16.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_16.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_21 = (tmpvar_25 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_22.x;
    tmpvar_30.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_16.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_16.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_33);
    highp vec2 tmpvar_34;
    tmpvar_34.y = 0.0;
    tmpvar_34.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = (shadowCoord_16.xy + tmpvar_34);
    tmpvar_35.z = shadowCoord_16.z;
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_35.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_37);
    highp vec4 tmpvar_38;
    tmpvar_38 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_16.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.y = 0.0;
    tmpvar_40.x = tmpvar_22.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_16.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_16.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = -(LIGHT_PARAM.z);
    tmpvar_44.y = tmpvar_22.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_16.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_16.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = 0.0;
    tmpvar_48.y = tmpvar_22.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_16.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_16.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_51);
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (shadowCoord_16.xy + LIGHT_PARAM.zz);
    tmpvar_52.z = shadowCoord_16.z;
    highp vec4 tmpvar_53;
    tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
    highp float tmpvar_54;
    if ((tmpvar_53.x < xlv_TEXCOORD4.z)) {
      tmpvar_54 = 0.0;
    } else {
      tmpvar_54 = 1.0;
    };
    shadow_21 = (shadow_21 + tmpvar_54);
    shadow_21 = (shadow_21 / 9.0);
    tmpvar_17 = mix (1.0, shadow_21, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_57;
  highp vec3 color_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 tmpvar_61;
  mediump vec3 albedo_62;
  albedo_62 = tmpvar_2;
  mediump vec3 specColor_63;
  specColor_63 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_62 * tmpvar_3));
  tmpvar_61 = (albedo_62 * (0.7790837 - (tmpvar_3 * 0.7790837)));
  tmpvar_57 = 0.0;
  mediump float alpha_64;
  alpha_64 = tmpvar_57;
  tmpvar_57 = alpha_64;
  mediump float tmpvar_65;
  tmpvar_65 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_65;
  highp vec3 tmpvar_66;
  highp vec3 inVec_67;
  inVec_67 = (tmpvar_56 + tmpvar_55);
  tmpvar_66 = (inVec_67 * inversesqrt(max (0.001, 
    dot (inVec_67, inVec_67)
  )));
  highp float tmpvar_68;
  tmpvar_68 = abs(dot (tmpvar_55, tmpvar_6));
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_6, tmpvar_56), 0.0, 1.0);
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_6, tmpvar_66), 0.0, 1.0);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (tmpvar_56, tmpvar_66), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump float tmpvar_73;
  mediump float NdotV_74;
  NdotV_74 = tmpvar_68;
  mediump float NdotL_75;
  NdotL_75 = tmpvar_69;
  mediump float perceptualRoughness_76;
  perceptualRoughness_76 = perceptualRoughness_60;
  mediump float tmpvar_77;
  tmpvar_77 = (0.5 + ((2.0 * tmpvar_71) * (tmpvar_71 * perceptualRoughness_76)));
  mediump float x_78;
  x_78 = (1.0 - NdotL_75);
  mediump float x_79;
  x_79 = (1.0 - NdotV_74);
  tmpvar_73 = ((1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_78 * x_78) * ((x_78 * x_78) * x_78))
  )) * (1.0 + (
    (tmpvar_77 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )));
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_73 * tmpvar_69);
  diffuseTerm_59 = tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_81 * tmpvar_81);
  highp float tmpvar_83;
  tmpvar_83 = (((
    (tmpvar_70 * tmpvar_82)
   - tmpvar_70) * tmpvar_70) + 1.0);
  mediump vec3 tmpvar_84;
  mediump float x_85;
  x_85 = (1.0 - tmpvar_71);
  tmpvar_84 = (specColor_63 + ((1.0 - specColor_63) * (
    (x_85 * x_85)
   * 
    ((x_85 * x_85) * x_85)
  )));
  color_58 = (((
    (tmpvar_61 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_82)
       / 
        ((tmpvar_83 * tmpvar_83) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_69 * (
          (tmpvar_68 * (1.0 - tmpvar_81))
         + tmpvar_81)) + (tmpvar_68 * (
          (tmpvar_69 * (1.0 - tmpvar_81))
         + tmpvar_81))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_69)) * LIGHT_COLOR)
   * tmpvar_84)) * tmpvar_17);
  color_58 = (color_58 + tmpvar_5);
  outColor_1.xyz = color_58;
  outColor_1.w = 1.0;
  gl_FragData[0] = outColor_1;
}

]===],
	},
}


end

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", ONE, ONE, ONE }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * 0.5);
  tmpvar_4 = (mg_6.y * 0.5);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_15;
  mediump float diffuseTerm_16;
  highp float perceptualRoughness_17;
  mediump vec3 albedo_18;
  albedo_18 = tmpvar_2;
  mediump vec3 specColor_19;
  specColor_19 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_18 * tmpvar_3));
  mediump float tmpvar_20;
  tmpvar_20 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_15 = 0.0;
  mediump vec3 diffColor_21;
  mediump float alpha_22;
  alpha_22 = tmpvar_15;
  mediump float outModifiedAlpha_23;
  diffColor_21 = ((albedo_18 * tmpvar_20) * alpha_22);
  outModifiedAlpha_23 = ((1.0 - tmpvar_20) + (alpha_22 * tmpvar_20));
  tmpvar_15 = outModifiedAlpha_23;
  mediump float tmpvar_24;
  tmpvar_24 = (1.0 - tmpvar_4);
  perceptualRoughness_17 = tmpvar_24;
  highp vec3 tmpvar_25;
  highp vec3 inVec_26;
  inVec_26 = (tmpvar_13 + tmpvar_12);
  tmpvar_25 = (inVec_26 * inversesqrt(max (0.001, 
    dot (inVec_26, inVec_26)
  )));
  highp float tmpvar_27;
  tmpvar_27 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_14, tmpvar_25), 0.0, 1.0);
  mediump float tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_13, tmpvar_25), 0.0, 1.0);
  tmpvar_30 = tmpvar_31;
  mediump float tmpvar_32;
  mediump float NdotV_33;
  NdotV_33 = tmpvar_27;
  mediump float NdotL_34;
  NdotL_34 = tmpvar_28;
  mediump float perceptualRoughness_35;
  perceptualRoughness_35 = perceptualRoughness_17;
  mediump float tmpvar_36;
  tmpvar_36 = (0.5 + ((2.0 * tmpvar_30) * (tmpvar_30 * perceptualRoughness_35)));
  mediump float x_37;
  x_37 = (1.0 - NdotL_34);
  mediump float x_38;
  x_38 = (1.0 - NdotV_33);
  tmpvar_32 = ((1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )) * (1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_32 * tmpvar_28);
  diffuseTerm_16 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_17 * perceptualRoughness_17), 0.002);
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_40 * tmpvar_40);
  highp float tmpvar_42;
  tmpvar_42 = (((
    (tmpvar_29 * tmpvar_41)
   - tmpvar_29) * tmpvar_29) + 1.0);
  mediump vec3 tmpvar_43;
  mediump float x_44;
  x_44 = (1.0 - tmpvar_30);
  tmpvar_43 = (specColor_19 + ((1.0 - specColor_19) * (
    (x_44 * x_44)
   * 
    ((x_44 * x_44) * x_44)
  )));
  outColor_1.xyz = (((diffColor_21 * LIGHT_COLOR) * diffuseTerm_16) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_41) / (
        (tmpvar_42 * tmpvar_42)
       + 1e-7)) * (0.5 / (
        ((tmpvar_28 * ((tmpvar_27 * 
          (1.0 - tmpvar_40)
        ) + tmpvar_40)) + (tmpvar_27 * ((tmpvar_28 * 
          (1.0 - tmpvar_40)
        ) + tmpvar_40)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_28))
   * LIGHT_COLOR) * tmpvar_43));
  outColor_1.w = 1.0;
  if (((col_7.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * 0.5);
  tmpvar_4 = (mg_7.y * 0.5);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_15;
    highp vec2 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 computedWeight_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_20.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_20.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    computedWeight_21 = (computedArea_22 * 0.44444);
    highp vec4 computedWeight_28;
    highp vec4 computedArea_29;
    highp vec4 computedAreaUncut_30;
    highp float tmpvar_31;
    tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_32;
    tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
    computedArea_29.x = tmpvar_32;
    computedAreaUncut_30.x = tmpvar_32;
    computedArea_29.w = tmpvar_31;
    computedAreaUncut_30.w = tmpvar_31;
    computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = min (tmpvar_20.y, 0.0);
    computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
    computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = max (tmpvar_20.y, 0.0);
    computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
    computedWeight_28 = (computedArea_29 * 0.44444);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
    fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_16.x;
    tmpvar_38.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_13.z;
    lowp float tmpvar_40;
    tmpvar_40 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_16.y;
    tmpvar_41.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_16.x;
    tmpvar_44.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_13.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_16.y;
    tmpvar_47.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_13.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_50;
  highp vec3 tmpvar_51;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_51 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_52;
  mediump float diffuseTerm_53;
  highp float perceptualRoughness_54;
  mediump vec3 albedo_55;
  albedo_55 = tmpvar_2;
  mediump vec3 specColor_56;
  specColor_56 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_55 * tmpvar_3));
  mediump float tmpvar_57;
  tmpvar_57 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_52 = 0.0;
  mediump vec3 diffColor_58;
  mediump float alpha_59;
  alpha_59 = tmpvar_52;
  mediump float outModifiedAlpha_60;
  diffColor_58 = ((albedo_55 * tmpvar_57) * alpha_59);
  outModifiedAlpha_60 = ((1.0 - tmpvar_57) + (alpha_59 * tmpvar_57));
  tmpvar_52 = outModifiedAlpha_60;
  mediump float tmpvar_61;
  tmpvar_61 = (1.0 - tmpvar_4);
  perceptualRoughness_54 = tmpvar_61;
  highp vec3 tmpvar_62;
  highp vec3 inVec_63;
  inVec_63 = (tmpvar_51 + tmpvar_50);
  tmpvar_62 = (inVec_63 * inversesqrt(max (0.001, 
    dot (inVec_63, inVec_63)
  )));
  highp float tmpvar_64;
  tmpvar_64 = abs(dot (tmpvar_50, tmpvar_5));
  highp float tmpvar_65;
  tmpvar_65 = clamp (dot (tmpvar_5, tmpvar_51), 0.0, 1.0);
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_5, tmpvar_62), 0.0, 1.0);
  mediump float tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_51, tmpvar_62), 0.0, 1.0);
  tmpvar_67 = tmpvar_68;
  mediump float tmpvar_69;
  mediump float NdotV_70;
  NdotV_70 = tmpvar_64;
  mediump float NdotL_71;
  NdotL_71 = tmpvar_65;
  mediump float perceptualRoughness_72;
  perceptualRoughness_72 = perceptualRoughness_54;
  mediump float tmpvar_73;
  tmpvar_73 = (0.5 + ((2.0 * tmpvar_67) * (tmpvar_67 * perceptualRoughness_72)));
  mediump float x_74;
  x_74 = (1.0 - NdotL_71);
  mediump float x_75;
  x_75 = (1.0 - NdotV_70);
  tmpvar_69 = ((1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_74 * x_74) * ((x_74 * x_74) * x_74))
  )) * (1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )));
  highp float tmpvar_76;
  tmpvar_76 = (tmpvar_69 * tmpvar_65);
  diffuseTerm_53 = tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = max ((perceptualRoughness_54 * perceptualRoughness_54), 0.002);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_66 * tmpvar_78)
   - tmpvar_66) * tmpvar_66) + 1.0);
  mediump vec3 tmpvar_80;
  mediump float x_81;
  x_81 = (1.0 - tmpvar_67);
  tmpvar_80 = (specColor_56 + ((1.0 - specColor_56) * (
    (x_81 * x_81)
   * 
    ((x_81 * x_81) * x_81)
  )));
  outColor_1.xyz = (((
    (diffColor_58 * LIGHT_COLOR)
   * diffuseTerm_53) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_78)
       / 
        ((tmpvar_79 * tmpvar_79) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_65 * (
          (tmpvar_64 * (1.0 - tmpvar_77))
         + tmpvar_77)) + (tmpvar_64 * (
          (tmpvar_65 * (1.0 - tmpvar_77))
         + tmpvar_77))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_65)) * LIGHT_COLOR)
   * tmpvar_80)) * tmpvar_14);
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * 0.5);
  tmpvar_4 = (mg_7.y * 0.5);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_15;
    highp vec3 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 texelsWeightsA_29;
    highp vec3 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.16 * tmpvar_34);
    texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
    texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
    texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
    texelsWeightsB_30.z = (0.16 * tmpvar_33);
    highp vec3 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_21.y;
    tmpvar_38.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.z = texelsWeightsB_30.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_29.y;
    tmpvar_41.yz = texelsWeightsB_30.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_21.y;
    tmpvar_43.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_29.y;
    tmpvar_44.yz = texelsWeightsB_30.xz;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    lowp float tmpvar_48;
    tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.x;
    tmpvar_55.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.y;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.z;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.x;
    tmpvar_64.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.y;
    tmpvar_67.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.z;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_73;
  highp vec3 tmpvar_74;
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_74 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_75;
  mediump float diffuseTerm_76;
  highp float perceptualRoughness_77;
  mediump vec3 albedo_78;
  albedo_78 = tmpvar_2;
  mediump vec3 specColor_79;
  specColor_79 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_78 * tmpvar_3));
  mediump float tmpvar_80;
  tmpvar_80 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_75 = 0.0;
  mediump vec3 diffColor_81;
  mediump float alpha_82;
  alpha_82 = tmpvar_75;
  mediump float outModifiedAlpha_83;
  diffColor_81 = ((albedo_78 * tmpvar_80) * alpha_82);
  outModifiedAlpha_83 = ((1.0 - tmpvar_80) + (alpha_82 * tmpvar_80));
  tmpvar_75 = outModifiedAlpha_83;
  mediump float tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_4);
  perceptualRoughness_77 = tmpvar_84;
  highp vec3 tmpvar_85;
  highp vec3 inVec_86;
  inVec_86 = (tmpvar_74 + tmpvar_73);
  tmpvar_85 = (inVec_86 * inversesqrt(max (0.001, 
    dot (inVec_86, inVec_86)
  )));
  highp float tmpvar_87;
  tmpvar_87 = abs(dot (tmpvar_73, tmpvar_5));
  highp float tmpvar_88;
  tmpvar_88 = clamp (dot (tmpvar_5, tmpvar_74), 0.0, 1.0);
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_5, tmpvar_85), 0.0, 1.0);
  mediump float tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_74, tmpvar_85), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  mediump float tmpvar_92;
  mediump float NdotV_93;
  NdotV_93 = tmpvar_87;
  mediump float NdotL_94;
  NdotL_94 = tmpvar_88;
  mediump float perceptualRoughness_95;
  perceptualRoughness_95 = perceptualRoughness_77;
  mediump float tmpvar_96;
  tmpvar_96 = (0.5 + ((2.0 * tmpvar_90) * (tmpvar_90 * perceptualRoughness_95)));
  mediump float x_97;
  x_97 = (1.0 - NdotL_94);
  mediump float x_98;
  x_98 = (1.0 - NdotV_93);
  tmpvar_92 = ((1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_97 * x_97) * ((x_97 * x_97) * x_97))
  )) * (1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_98 * x_98) * ((x_98 * x_98) * x_98))
  )));
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_92 * tmpvar_88);
  diffuseTerm_76 = tmpvar_99;
  highp float tmpvar_100;
  tmpvar_100 = max ((perceptualRoughness_77 * perceptualRoughness_77), 0.002);
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_100 * tmpvar_100);
  highp float tmpvar_102;
  tmpvar_102 = (((
    (tmpvar_89 * tmpvar_101)
   - tmpvar_89) * tmpvar_89) + 1.0);
  mediump vec3 tmpvar_103;
  mediump float x_104;
  x_104 = (1.0 - tmpvar_90);
  tmpvar_103 = (specColor_79 + ((1.0 - specColor_79) * (
    (x_104 * x_104)
   * 
    ((x_104 * x_104) * x_104)
  )));
  outColor_1.xyz = (((
    (diffColor_81 * LIGHT_COLOR)
   * diffuseTerm_76) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_101)
       / 
        ((tmpvar_102 * tmpvar_102) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_88 * (
          (tmpvar_87 * (1.0 - tmpvar_100))
         + tmpvar_100)) + (tmpvar_87 * (
          (tmpvar_88 * (1.0 - tmpvar_100))
         + tmpvar_100))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_88)) * LIGHT_COLOR)
   * tmpvar_103)) * tmpvar_14);
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * 0.5);
  tmpvar_4 = (mg_7.y * 0.5);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_15;
    highp vec4 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 texelsWeightsA_29;
    highp vec4 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.081632 * tmpvar_34);
    texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
    texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
    texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
    texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
    texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
    texelsWeightsB_30.w = (0.081632 * tmpvar_33);
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_21.yw;
    tmpvar_38.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.zw = texelsWeightsB_30.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_29.yw;
    tmpvar_41.zw = texelsWeightsB_30.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_21.yw;
    tmpvar_43.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_29.yw;
    tmpvar_44.zw = texelsWeightsB_30.yw;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    lowp float tmpvar_48;
    tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.w;
    tmpvar_55.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.x;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.y;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.z;
    tmpvar_64.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.w;
    tmpvar_67.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.x;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_16.y;
    tmpvar_73.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
    tmpvar_74.z = shadowCoord_13.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_16.z;
    tmpvar_76.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
    tmpvar_77.z = shadowCoord_13.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_16.w;
    tmpvar_79.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
    tmpvar_80.z = shadowCoord_13.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_16.x;
    tmpvar_82.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
    tmpvar_83.z = shadowCoord_13.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_16.y;
    tmpvar_85.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
    tmpvar_86.z = shadowCoord_13.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_16.z;
    tmpvar_88.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
    tmpvar_89.z = shadowCoord_13.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_16.w;
    tmpvar_91.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
    tmpvar_92.z = shadowCoord_13.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_94;
  highp vec3 tmpvar_95;
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_95 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_96;
  mediump float diffuseTerm_97;
  highp float perceptualRoughness_98;
  mediump vec3 albedo_99;
  albedo_99 = tmpvar_2;
  mediump vec3 specColor_100;
  specColor_100 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_99 * tmpvar_3));
  mediump float tmpvar_101;
  tmpvar_101 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_96 = 0.0;
  mediump vec3 diffColor_102;
  mediump float alpha_103;
  alpha_103 = tmpvar_96;
  mediump float outModifiedAlpha_104;
  diffColor_102 = ((albedo_99 * tmpvar_101) * alpha_103);
  outModifiedAlpha_104 = ((1.0 - tmpvar_101) + (alpha_103 * tmpvar_101));
  tmpvar_96 = outModifiedAlpha_104;
  mediump float tmpvar_105;
  tmpvar_105 = (1.0 - tmpvar_4);
  perceptualRoughness_98 = tmpvar_105;
  highp vec3 tmpvar_106;
  highp vec3 inVec_107;
  inVec_107 = (tmpvar_95 + tmpvar_94);
  tmpvar_106 = (inVec_107 * inversesqrt(max (0.001, 
    dot (inVec_107, inVec_107)
  )));
  highp float tmpvar_108;
  tmpvar_108 = abs(dot (tmpvar_94, tmpvar_5));
  highp float tmpvar_109;
  tmpvar_109 = clamp (dot (tmpvar_5, tmpvar_95), 0.0, 1.0);
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_5, tmpvar_106), 0.0, 1.0);
  mediump float tmpvar_111;
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (tmpvar_95, tmpvar_106), 0.0, 1.0);
  tmpvar_111 = tmpvar_112;
  mediump float tmpvar_113;
  mediump float NdotV_114;
  NdotV_114 = tmpvar_108;
  mediump float NdotL_115;
  NdotL_115 = tmpvar_109;
  mediump float perceptualRoughness_116;
  perceptualRoughness_116 = perceptualRoughness_98;
  mediump float tmpvar_117;
  tmpvar_117 = (0.5 + ((2.0 * tmpvar_111) * (tmpvar_111 * perceptualRoughness_116)));
  mediump float x_118;
  x_118 = (1.0 - NdotL_115);
  mediump float x_119;
  x_119 = (1.0 - NdotV_114);
  tmpvar_113 = ((1.0 + (
    (tmpvar_117 - 1.0)
   * 
    ((x_118 * x_118) * ((x_118 * x_118) * x_118))
  )) * (1.0 + (
    (tmpvar_117 - 1.0)
   * 
    ((x_119 * x_119) * ((x_119 * x_119) * x_119))
  )));
  highp float tmpvar_120;
  tmpvar_120 = (tmpvar_113 * tmpvar_109);
  diffuseTerm_97 = tmpvar_120;
  highp float tmpvar_121;
  tmpvar_121 = max ((perceptualRoughness_98 * perceptualRoughness_98), 0.002);
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_121 * tmpvar_121);
  highp float tmpvar_123;
  tmpvar_123 = (((
    (tmpvar_110 * tmpvar_122)
   - tmpvar_110) * tmpvar_110) + 1.0);
  mediump vec3 tmpvar_124;
  mediump float x_125;
  x_125 = (1.0 - tmpvar_111);
  tmpvar_124 = (specColor_100 + ((1.0 - specColor_100) * (
    (x_125 * x_125)
   * 
    ((x_125 * x_125) * x_125)
  )));
  outColor_1.xyz = (((
    (diffColor_102 * LIGHT_COLOR)
   * diffuseTerm_97) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_122)
       / 
        ((tmpvar_123 * tmpvar_123) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_109 * (
          (tmpvar_108 * (1.0 - tmpvar_121))
         + tmpvar_121)) + (tmpvar_108 * (
          (tmpvar_109 * (1.0 - tmpvar_121))
         + tmpvar_121))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_109)) * LIGHT_COLOR)
   * tmpvar_124)) * tmpvar_14);
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * 0.5);
  tmpvar_4 = (mg_7.y * 0.5);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    highp vec2 tmpvar_15;
    tmpvar_15.x = LIGHT_PARAM.z;
    tmpvar_15.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_16;
    tmpvar_16.xy = tmpvar_15;
    highp float tmpvar_17;
    tmpvar_17 = (1.0/(LIGHT_PARAM.z));
    tmpvar_16.z = tmpvar_17;
    tmpvar_16.w = tmpvar_17;
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = tmpvar_16.xy;
    shadow_18 = 0.0;
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_13.xy - LIGHT_PARAM.zz);
    tmpvar_20.z = shadowCoord_13.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_18 = tmpvar_22;
    highp vec2 tmpvar_23;
    tmpvar_23.x = 0.0;
    tmpvar_23.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_13.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_13.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_18 = (tmpvar_22 + tmpvar_26);
    highp vec2 tmpvar_27;
    tmpvar_27.x = tmpvar_19.x;
    tmpvar_27.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_28;
    tmpvar_28.xy = (shadowCoord_13.xy + tmpvar_27);
    tmpvar_28.z = shadowCoord_13.z;
    highp vec4 tmpvar_29;
    tmpvar_29 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_28.xy);
    highp float tmpvar_30;
    if ((tmpvar_29.x < xlv_TEXCOORD4.z)) {
      tmpvar_30 = 0.0;
    } else {
      tmpvar_30 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_30);
    highp vec2 tmpvar_31;
    tmpvar_31.y = 0.0;
    tmpvar_31.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = (shadowCoord_13.xy + tmpvar_31);
    tmpvar_32.z = shadowCoord_13.z;
    highp vec4 tmpvar_33;
    tmpvar_33 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_32.xy);
    highp float tmpvar_34;
    if ((tmpvar_33.x < xlv_TEXCOORD4.z)) {
      tmpvar_34 = 0.0;
    } else {
      tmpvar_34 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_34);
    highp vec4 tmpvar_35;
    tmpvar_35 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_13.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.y = 0.0;
    tmpvar_37.x = tmpvar_19.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_13.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_13.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = -(LIGHT_PARAM.z);
    tmpvar_41.y = tmpvar_19.y;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (shadowCoord_13.xy + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    highp vec4 tmpvar_43;
    tmpvar_43 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_42.xy);
    highp float tmpvar_44;
    if ((tmpvar_43.x < xlv_TEXCOORD4.z)) {
      tmpvar_44 = 0.0;
    } else {
      tmpvar_44 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_44);
    highp vec2 tmpvar_45;
    tmpvar_45.x = 0.0;
    tmpvar_45.y = tmpvar_19.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (shadowCoord_13.xy + tmpvar_45);
    tmpvar_46.z = shadowCoord_13.z;
    highp vec4 tmpvar_47;
    tmpvar_47 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_46.xy);
    highp float tmpvar_48;
    if ((tmpvar_47.x < xlv_TEXCOORD4.z)) {
      tmpvar_48 = 0.0;
    } else {
      tmpvar_48 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_48);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_13.xy + LIGHT_PARAM.zz);
    tmpvar_49.z = shadowCoord_13.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_18 = (shadow_18 + tmpvar_51);
    shadow_18 = (shadow_18 / 9.0);
    tmpvar_14 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_52;
  highp vec3 tmpvar_53;
  tmpvar_52 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_53 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_54;
  mediump float diffuseTerm_55;
  highp float perceptualRoughness_56;
  mediump vec3 albedo_57;
  albedo_57 = tmpvar_2;
  mediump vec3 specColor_58;
  specColor_58 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_57 * tmpvar_3));
  mediump float tmpvar_59;
  tmpvar_59 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_54 = 0.0;
  mediump vec3 diffColor_60;
  mediump float alpha_61;
  alpha_61 = tmpvar_54;
  mediump float outModifiedAlpha_62;
  diffColor_60 = ((albedo_57 * tmpvar_59) * alpha_61);
  outModifiedAlpha_62 = ((1.0 - tmpvar_59) + (alpha_61 * tmpvar_59));
  tmpvar_54 = outModifiedAlpha_62;
  mediump float tmpvar_63;
  tmpvar_63 = (1.0 - tmpvar_4);
  perceptualRoughness_56 = tmpvar_63;
  highp vec3 tmpvar_64;
  highp vec3 inVec_65;
  inVec_65 = (tmpvar_53 + tmpvar_52);
  tmpvar_64 = (inVec_65 * inversesqrt(max (0.001, 
    dot (inVec_65, inVec_65)
  )));
  highp float tmpvar_66;
  tmpvar_66 = abs(dot (tmpvar_52, tmpvar_5));
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_5, tmpvar_53), 0.0, 1.0);
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_5, tmpvar_64), 0.0, 1.0);
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (tmpvar_53, tmpvar_64), 0.0, 1.0);
  tmpvar_69 = tmpvar_70;
  mediump float tmpvar_71;
  mediump float NdotV_72;
  NdotV_72 = tmpvar_66;
  mediump float NdotL_73;
  NdotL_73 = tmpvar_67;
  mediump float perceptualRoughness_74;
  perceptualRoughness_74 = perceptualRoughness_56;
  mediump float tmpvar_75;
  tmpvar_75 = (0.5 + ((2.0 * tmpvar_69) * (tmpvar_69 * perceptualRoughness_74)));
  mediump float x_76;
  x_76 = (1.0 - NdotL_73);
  mediump float x_77;
  x_77 = (1.0 - NdotV_72);
  tmpvar_71 = ((1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )) * (1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_77 * x_77) * ((x_77 * x_77) * x_77))
  )));
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_71 * tmpvar_67);
  diffuseTerm_55 = tmpvar_78;
  highp float tmpvar_79;
  tmpvar_79 = max ((perceptualRoughness_56 * perceptualRoughness_56), 0.002);
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_79 * tmpvar_79);
  highp float tmpvar_81;
  tmpvar_81 = (((
    (tmpvar_68 * tmpvar_80)
   - tmpvar_68) * tmpvar_68) + 1.0);
  mediump vec3 tmpvar_82;
  mediump float x_83;
  x_83 = (1.0 - tmpvar_69);
  tmpvar_82 = (specColor_58 + ((1.0 - specColor_58) * (
    (x_83 * x_83)
   * 
    ((x_83 * x_83) * x_83)
  )));
  outColor_1.xyz = (((
    (diffColor_60 * LIGHT_COLOR)
   * diffuseTerm_55) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_80)
       / 
        ((tmpvar_81 * tmpvar_81) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_67 * (
          (tmpvar_66 * (1.0 - tmpvar_79))
         + tmpvar_79)) + (tmpvar_66 * (
          (tmpvar_67 * (1.0 - tmpvar_79))
         + tmpvar_79))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_67)) * LIGHT_COLOR)
   * tmpvar_82)) * tmpvar_14);
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOff","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * 0.5);
  tmpvar_4 = (mg_6.y * 0.5);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 lightDir_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_14 = normalize(tmpvar_15);
  tmpvar_13 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 albedo_20;
  albedo_20 = tmpvar_2;
  mediump vec3 specColor_21;
  specColor_21 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_20 * tmpvar_3));
  mediump float tmpvar_22;
  tmpvar_22 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_17 = 0.0;
  mediump vec3 diffColor_23;
  mediump float alpha_24;
  alpha_24 = tmpvar_17;
  mediump float outModifiedAlpha_25;
  diffColor_23 = ((albedo_20 * tmpvar_22) * alpha_24);
  outModifiedAlpha_25 = ((1.0 - tmpvar_22) + (alpha_24 * tmpvar_22));
  tmpvar_17 = outModifiedAlpha_25;
  mediump float tmpvar_26;
  tmpvar_26 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_26;
  highp vec3 tmpvar_27;
  highp vec3 inVec_28;
  inVec_28 = (lightDir_14 + tmpvar_12);
  tmpvar_27 = (inVec_28 * inversesqrt(max (0.001, 
    dot (inVec_28, inVec_28)
  )));
  highp float tmpvar_29;
  tmpvar_29 = abs(dot (tmpvar_12, tmpvar_13));
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_13, lightDir_14), 0.0, 1.0);
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_13, tmpvar_27), 0.0, 1.0);
  mediump float tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = clamp (dot (lightDir_14, tmpvar_27), 0.0, 1.0);
  tmpvar_32 = tmpvar_33;
  mediump float tmpvar_34;
  mediump float NdotV_35;
  NdotV_35 = tmpvar_29;
  mediump float NdotL_36;
  NdotL_36 = tmpvar_30;
  mediump float perceptualRoughness_37;
  perceptualRoughness_37 = perceptualRoughness_19;
  mediump float tmpvar_38;
  tmpvar_38 = (0.5 + ((2.0 * tmpvar_32) * (tmpvar_32 * perceptualRoughness_37)));
  mediump float x_39;
  x_39 = (1.0 - NdotL_36);
  mediump float x_40;
  x_40 = (1.0 - NdotV_35);
  tmpvar_34 = ((1.0 + (
    (tmpvar_38 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )) * (1.0 + (
    (tmpvar_38 - 1.0)
   * 
    ((x_40 * x_40) * ((x_40 * x_40) * x_40))
  )));
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_34 * tmpvar_30);
  diffuseTerm_18 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_43;
  tmpvar_43 = (tmpvar_42 * tmpvar_42);
  highp float tmpvar_44;
  tmpvar_44 = (((
    (tmpvar_31 * tmpvar_43)
   - tmpvar_31) * tmpvar_31) + 1.0);
  mediump vec3 tmpvar_45;
  mediump float x_46;
  x_46 = (1.0 - tmpvar_32);
  tmpvar_45 = (specColor_21 + ((1.0 - specColor_21) * (
    (x_46 * x_46)
   * 
    ((x_46 * x_46) * x_46)
  )));
  outColor_1.xyz = (((
    (diffColor_23 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_43)
       / 
        ((tmpvar_44 * tmpvar_44) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_30 * (
          (tmpvar_29 * (1.0 - tmpvar_42))
         + tmpvar_42)) + (tmpvar_29 * (
          (tmpvar_30 * (1.0 - tmpvar_42))
         + tmpvar_42))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_30)) * LIGHT_COLOR)
   * tmpvar_45)) * ((
    (1.0 - tmpvar_16)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y)) + ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (lightDir_14, 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  outColor_1.w = 1.0;
  if (((col_7.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * 0.5);
  tmpvar_4 = (mg_6.y * 0.5);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec2 fetchesOffsetsV_14;
  highp vec2 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec4 computedWeight_20;
  highp vec4 computedArea_21;
  highp vec4 computedAreaUncut_22;
  highp float tmpvar_23;
  tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
  computedArea_21.x = tmpvar_24;
  computedAreaUncut_22.x = tmpvar_24;
  computedArea_21.w = tmpvar_23;
  computedAreaUncut_22.w = tmpvar_23;
  computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_25;
  tmpvar_25 = min (tmpvar_19.x, 0.0);
  computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
  computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = max (tmpvar_19.x, 0.0);
  computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
  computedWeight_20 = (computedArea_21 * 0.44444);
  highp vec4 computedWeight_27;
  highp vec4 computedArea_28;
  highp vec4 computedAreaUncut_29;
  highp float tmpvar_30;
  tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
  computedArea_28.x = tmpvar_31;
  computedAreaUncut_29.x = tmpvar_31;
  computedArea_28.w = tmpvar_30;
  computedAreaUncut_29.w = tmpvar_30;
  computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_32;
  tmpvar_32 = min (tmpvar_19.y, 0.0);
  computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
  computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_33;
  tmpvar_33 = max (tmpvar_19.y, 0.0);
  computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
  computedWeight_27 = (computedArea_28 * 0.44444);
  highp vec2 tmpvar_34;
  tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
  highp vec2 tmpvar_35;
  tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
  fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_36;
  tmpvar_36 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37.x = fetchesOffsetsU_15.x;
  tmpvar_37.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_38;
  tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
  tmpvar_38.z = shadowCoord_12.z;
  lowp float tmpvar_39;
  tmpvar_39 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_38);
  shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
  highp vec2 tmpvar_40;
  tmpvar_40.x = fetchesOffsetsU_15.y;
  tmpvar_40.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_41;
  tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
  tmpvar_41.z = shadowCoord_12.z;
  lowp float tmpvar_42;
  tmpvar_42 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_41);
  shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_15.x;
  tmpvar_43.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
  tmpvar_44.z = shadowCoord_12.z;
  lowp float tmpvar_45;
  tmpvar_45 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_44);
  shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_15.y;
  tmpvar_46.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
  tmpvar_47.z = shadowCoord_12.z;
  lowp float tmpvar_48;
  tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
  highp vec3 tmpvar_49;
  highp vec3 tmpvar_50;
  highp vec3 lightDir_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_53;
  tmpvar_53 = clamp ((sqrt(
    dot (tmpvar_52, tmpvar_52)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_51 = normalize(tmpvar_52);
  tmpvar_50 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_49 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_54;
  mediump float diffuseTerm_55;
  highp float perceptualRoughness_56;
  mediump vec3 albedo_57;
  albedo_57 = tmpvar_2;
  mediump vec3 specColor_58;
  specColor_58 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_57 * tmpvar_3));
  mediump float tmpvar_59;
  tmpvar_59 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_54 = 0.0;
  mediump vec3 diffColor_60;
  mediump float alpha_61;
  alpha_61 = tmpvar_54;
  mediump float outModifiedAlpha_62;
  diffColor_60 = ((albedo_57 * tmpvar_59) * alpha_61);
  outModifiedAlpha_62 = ((1.0 - tmpvar_59) + (alpha_61 * tmpvar_59));
  tmpvar_54 = outModifiedAlpha_62;
  mediump float tmpvar_63;
  tmpvar_63 = (1.0 - tmpvar_4);
  perceptualRoughness_56 = tmpvar_63;
  highp vec3 tmpvar_64;
  highp vec3 inVec_65;
  inVec_65 = (lightDir_51 + tmpvar_49);
  tmpvar_64 = (inVec_65 * inversesqrt(max (0.001, 
    dot (inVec_65, inVec_65)
  )));
  highp float tmpvar_66;
  tmpvar_66 = abs(dot (tmpvar_49, tmpvar_50));
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_50, lightDir_51), 0.0, 1.0);
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_50, tmpvar_64), 0.0, 1.0);
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (lightDir_51, tmpvar_64), 0.0, 1.0);
  tmpvar_69 = tmpvar_70;
  mediump float tmpvar_71;
  mediump float NdotV_72;
  NdotV_72 = tmpvar_66;
  mediump float NdotL_73;
  NdotL_73 = tmpvar_67;
  mediump float perceptualRoughness_74;
  perceptualRoughness_74 = perceptualRoughness_56;
  mediump float tmpvar_75;
  tmpvar_75 = (0.5 + ((2.0 * tmpvar_69) * (tmpvar_69 * perceptualRoughness_74)));
  mediump float x_76;
  x_76 = (1.0 - NdotL_73);
  mediump float x_77;
  x_77 = (1.0 - NdotV_72);
  tmpvar_71 = ((1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )) * (1.0 + (
    (tmpvar_75 - 1.0)
   * 
    ((x_77 * x_77) * ((x_77 * x_77) * x_77))
  )));
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_71 * tmpvar_67);
  diffuseTerm_55 = tmpvar_78;
  highp float tmpvar_79;
  tmpvar_79 = max ((perceptualRoughness_56 * perceptualRoughness_56), 0.002);
  highp float tmpvar_80;
  tmpvar_80 = (tmpvar_79 * tmpvar_79);
  highp float tmpvar_81;
  tmpvar_81 = (((
    (tmpvar_68 * tmpvar_80)
   - tmpvar_68) * tmpvar_68) + 1.0);
  mediump vec3 tmpvar_82;
  mediump float x_83;
  x_83 = (1.0 - tmpvar_69);
  tmpvar_82 = (specColor_58 + ((1.0 - specColor_58) * (
    (x_83 * x_83)
   * 
    ((x_83 * x_83) * x_83)
  )));
  outColor_1.xyz = (((
    (diffColor_60 * LIGHT_COLOR)
   * diffuseTerm_55) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_80)
       / 
        ((tmpvar_81 * tmpvar_81) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_67 * (
          (tmpvar_66 * (1.0 - tmpvar_79))
         + tmpvar_79)) + (tmpvar_66 * (
          (tmpvar_67 * (1.0 - tmpvar_79))
         + tmpvar_79))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_67)) * LIGHT_COLOR)
   * tmpvar_82)) * ((
    ((1.0 - tmpvar_53) / ((LIGHT_ATTENUATION.x + (tmpvar_53 * LIGHT_ATTENUATION.y)) + ((tmpvar_53 * tmpvar_53) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_51, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  if (((col_7.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * 0.5);
  tmpvar_4 = (mg_6.y * 0.5);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec3 fetchesOffsetsV_14;
  highp vec3 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec3 texelsWeightsA_20;
  highp vec3 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_19.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_19.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.16 * tmpvar_25);
  texelsWeightsA_20.y = (0.16 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.16 * (computedArea_22.y + 1.0));
  texelsWeightsB_21.x = (0.16 * (computedArea_22.z + 1.0));
  texelsWeightsB_21.y = (0.16 * computedAreaUncut_23.z);
  texelsWeightsB_21.z = (0.16 * tmpvar_24);
  highp vec3 texelsWeightsA_28;
  highp vec3 texelsWeightsB_29;
  highp vec4 computedArea_30;
  highp vec4 computedAreaUncut_31;
  highp float tmpvar_32;
  tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
  computedArea_30.x = tmpvar_33;
  computedAreaUncut_31.x = tmpvar_33;
  computedArea_30.w = tmpvar_32;
  computedAreaUncut_31.w = tmpvar_32;
  computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = min (tmpvar_19.y, 0.0);
  computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
  computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = max (tmpvar_19.y, 0.0);
  computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
  texelsWeightsA_28.x = (0.16 * tmpvar_33);
  texelsWeightsA_28.y = (0.16 * computedAreaUncut_31.y);
  texelsWeightsA_28.z = (0.16 * (computedArea_30.y + 1.0));
  texelsWeightsB_29.x = (0.16 * (computedArea_30.z + 1.0));
  texelsWeightsB_29.y = (0.16 * computedAreaUncut_31.z);
  texelsWeightsB_29.z = (0.16 * tmpvar_32);
  highp vec3 tmpvar_36;
  tmpvar_36.xy = texelsWeightsA_20.xz;
  tmpvar_36.z = texelsWeightsB_21.y;
  highp vec3 tmpvar_37;
  tmpvar_37.x = texelsWeightsA_20.y;
  tmpvar_37.yz = texelsWeightsB_21.xz;
  highp vec3 tmpvar_38;
  tmpvar_38 = (tmpvar_36 + tmpvar_37);
  highp vec3 tmpvar_39;
  tmpvar_39.xy = texelsWeightsA_28.xz;
  tmpvar_39.z = texelsWeightsB_29.y;
  highp vec3 tmpvar_40;
  tmpvar_40.x = texelsWeightsA_28.y;
  tmpvar_40.yz = texelsWeightsB_29.xz;
  highp vec3 tmpvar_41;
  tmpvar_41 = (tmpvar_39 + tmpvar_40);
  highp vec3 tmpvar_42;
  tmpvar_42.x = texelsWeightsA_20.y;
  tmpvar_42.yz = texelsWeightsB_21.xz;
  highp vec3 tmpvar_43;
  tmpvar_43.x = texelsWeightsA_28.y;
  tmpvar_43.yz = texelsWeightsB_29.xz;
  fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_44;
  tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_45;
  tmpvar_45.x = fetchesOffsetsU_15.x;
  tmpvar_45.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_46;
  tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
  tmpvar_46.z = shadowCoord_12.z;
  lowp float tmpvar_47;
  tmpvar_47 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_46);
  shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
  highp vec2 tmpvar_48;
  tmpvar_48.x = fetchesOffsetsU_15.y;
  tmpvar_48.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_49;
  tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
  tmpvar_49.z = shadowCoord_12.z;
  lowp float tmpvar_50;
  tmpvar_50 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_49);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
  highp vec2 tmpvar_51;
  tmpvar_51.x = fetchesOffsetsU_15.z;
  tmpvar_51.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_52;
  tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
  tmpvar_52.z = shadowCoord_12.z;
  lowp float tmpvar_53;
  tmpvar_53 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_52);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
  highp vec2 tmpvar_54;
  tmpvar_54.x = fetchesOffsetsU_15.x;
  tmpvar_54.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_55;
  tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
  tmpvar_55.z = shadowCoord_12.z;
  lowp float tmpvar_56;
  tmpvar_56 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_55);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_56));
  highp vec2 tmpvar_57;
  tmpvar_57.x = fetchesOffsetsU_15.y;
  tmpvar_57.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_58;
  tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
  tmpvar_58.z = shadowCoord_12.z;
  lowp float tmpvar_59;
  tmpvar_59 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_58);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_59));
  highp vec2 tmpvar_60;
  tmpvar_60.x = fetchesOffsetsU_15.z;
  tmpvar_60.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_61;
  tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
  tmpvar_61.z = shadowCoord_12.z;
  lowp float tmpvar_62;
  tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_62));
  highp vec2 tmpvar_63;
  tmpvar_63.x = fetchesOffsetsU_15.x;
  tmpvar_63.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_64;
  tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
  tmpvar_64.z = shadowCoord_12.z;
  lowp float tmpvar_65;
  tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_65));
  highp vec2 tmpvar_66;
  tmpvar_66.x = fetchesOffsetsU_15.y;
  tmpvar_66.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_67;
  tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
  tmpvar_67.z = shadowCoord_12.z;
  lowp float tmpvar_68;
  tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_68));
  highp vec2 tmpvar_69;
  tmpvar_69.x = fetchesOffsetsU_15.z;
  tmpvar_69.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_70;
  tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
  tmpvar_70.z = shadowCoord_12.z;
  lowp float tmpvar_71;
  tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_71));
  highp vec3 tmpvar_72;
  highp vec3 tmpvar_73;
  highp vec3 lightDir_74;
  highp vec3 tmpvar_75;
  tmpvar_75 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_76;
  tmpvar_76 = clamp ((sqrt(
    dot (tmpvar_75, tmpvar_75)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_74 = normalize(tmpvar_75);
  tmpvar_73 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_72 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_77;
  mediump float diffuseTerm_78;
  highp float perceptualRoughness_79;
  mediump vec3 albedo_80;
  albedo_80 = tmpvar_2;
  mediump vec3 specColor_81;
  specColor_81 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_80 * tmpvar_3));
  mediump float tmpvar_82;
  tmpvar_82 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_77 = 0.0;
  mediump vec3 diffColor_83;
  mediump float alpha_84;
  alpha_84 = tmpvar_77;
  mediump float outModifiedAlpha_85;
  diffColor_83 = ((albedo_80 * tmpvar_82) * alpha_84);
  outModifiedAlpha_85 = ((1.0 - tmpvar_82) + (alpha_84 * tmpvar_82));
  tmpvar_77 = outModifiedAlpha_85;
  mediump float tmpvar_86;
  tmpvar_86 = (1.0 - tmpvar_4);
  perceptualRoughness_79 = tmpvar_86;
  highp vec3 tmpvar_87;
  highp vec3 inVec_88;
  inVec_88 = (lightDir_74 + tmpvar_72);
  tmpvar_87 = (inVec_88 * inversesqrt(max (0.001, 
    dot (inVec_88, inVec_88)
  )));
  highp float tmpvar_89;
  tmpvar_89 = abs(dot (tmpvar_72, tmpvar_73));
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_73, lightDir_74), 0.0, 1.0);
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_73, tmpvar_87), 0.0, 1.0);
  mediump float tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (lightDir_74, tmpvar_87), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  mediump float tmpvar_94;
  mediump float NdotV_95;
  NdotV_95 = tmpvar_89;
  mediump float NdotL_96;
  NdotL_96 = tmpvar_90;
  mediump float perceptualRoughness_97;
  perceptualRoughness_97 = perceptualRoughness_79;
  mediump float tmpvar_98;
  tmpvar_98 = (0.5 + ((2.0 * tmpvar_92) * (tmpvar_92 * perceptualRoughness_97)));
  mediump float x_99;
  x_99 = (1.0 - NdotL_96);
  mediump float x_100;
  x_100 = (1.0 - NdotV_95);
  tmpvar_94 = ((1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )) * (1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_100 * x_100) * ((x_100 * x_100) * x_100))
  )));
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_94 * tmpvar_90);
  diffuseTerm_78 = tmpvar_101;
  highp float tmpvar_102;
  tmpvar_102 = max ((perceptualRoughness_79 * perceptualRoughness_79), 0.002);
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_102 * tmpvar_102);
  highp float tmpvar_104;
  tmpvar_104 = (((
    (tmpvar_91 * tmpvar_103)
   - tmpvar_91) * tmpvar_91) + 1.0);
  mediump vec3 tmpvar_105;
  mediump float x_106;
  x_106 = (1.0 - tmpvar_92);
  tmpvar_105 = (specColor_81 + ((1.0 - specColor_81) * (
    (x_106 * x_106)
   * 
    ((x_106 * x_106) * x_106)
  )));
  outColor_1.xyz = (((
    (diffColor_83 * LIGHT_COLOR)
   * diffuseTerm_78) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_103)
       / 
        ((tmpvar_104 * tmpvar_104) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_90 * (
          (tmpvar_89 * (1.0 - tmpvar_102))
         + tmpvar_102)) + (tmpvar_89 * (
          (tmpvar_90 * (1.0 - tmpvar_102))
         + tmpvar_102))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_90)) * LIGHT_COLOR)
   * tmpvar_105)) * ((
    ((1.0 - tmpvar_76) / ((LIGHT_ATTENUATION.x + (tmpvar_76 * LIGHT_ATTENUATION.y)) + ((tmpvar_76 * tmpvar_76) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_74, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  if (((col_7.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * 0.5);
  tmpvar_4 = (mg_6.y * 0.5);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_12.w = tmpvar_13.w;
  shadowCoord_12.xyz = (tmpvar_13.xyz / tmpvar_13.w);
  shadowCoord_12.xyz = ((shadowCoord_12.xyz * 0.5) + 0.5);
  shadowCoord_12.y = (1.0 - shadowCoord_12.y);
  highp vec4 fetchesOffsetsV_14;
  highp vec4 fetchesOffsetsU_15;
  highp float shadow_16;
  highp vec2 tmpvar_17;
  tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_18;
  tmpvar_18 = floor((tmpvar_17 + 0.5));
  highp vec2 tmpvar_19;
  tmpvar_19 = (tmpvar_17 - tmpvar_18);
  highp vec4 texelsWeightsA_20;
  highp vec4 texelsWeightsB_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_19.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_19.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  texelsWeightsA_20.x = (0.081632 * tmpvar_25);
  texelsWeightsA_20.y = (0.081632 * computedAreaUncut_23.y);
  texelsWeightsA_20.z = (0.081632 * (computedAreaUncut_23.y + 1.0));
  texelsWeightsA_20.w = (0.081632 * (computedArea_22.y + 2.0));
  texelsWeightsB_21.x = (0.081632 * (computedArea_22.z + 2.0));
  texelsWeightsB_21.y = (0.081632 * (computedAreaUncut_23.z + 1.0));
  texelsWeightsB_21.z = (0.081632 * computedAreaUncut_23.z);
  texelsWeightsB_21.w = (0.081632 * tmpvar_24);
  highp vec4 texelsWeightsA_28;
  highp vec4 texelsWeightsB_29;
  highp vec4 computedArea_30;
  highp vec4 computedAreaUncut_31;
  highp float tmpvar_32;
  tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
  computedArea_30.x = tmpvar_33;
  computedAreaUncut_31.x = tmpvar_33;
  computedArea_30.w = tmpvar_32;
  computedAreaUncut_31.w = tmpvar_32;
  computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = min (tmpvar_19.y, 0.0);
  computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
  computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = max (tmpvar_19.y, 0.0);
  computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
  texelsWeightsA_28.x = (0.081632 * tmpvar_33);
  texelsWeightsA_28.y = (0.081632 * computedAreaUncut_31.y);
  texelsWeightsA_28.z = (0.081632 * (computedAreaUncut_31.y + 1.0));
  texelsWeightsA_28.w = (0.081632 * (computedArea_30.y + 2.0));
  texelsWeightsB_29.x = (0.081632 * (computedArea_30.z + 2.0));
  texelsWeightsB_29.y = (0.081632 * (computedAreaUncut_31.z + 1.0));
  texelsWeightsB_29.z = (0.081632 * computedAreaUncut_31.z);
  texelsWeightsB_29.w = (0.081632 * tmpvar_32);
  highp vec4 tmpvar_36;
  tmpvar_36.xy = texelsWeightsA_20.xz;
  tmpvar_36.zw = texelsWeightsB_21.xz;
  highp vec4 tmpvar_37;
  tmpvar_37.xy = texelsWeightsA_20.yw;
  tmpvar_37.zw = texelsWeightsB_21.yw;
  highp vec4 tmpvar_38;
  tmpvar_38 = (tmpvar_36 + tmpvar_37);
  highp vec4 tmpvar_39;
  tmpvar_39.xy = texelsWeightsA_28.xz;
  tmpvar_39.zw = texelsWeightsB_29.xz;
  highp vec4 tmpvar_40;
  tmpvar_40.xy = texelsWeightsA_28.yw;
  tmpvar_40.zw = texelsWeightsB_29.yw;
  highp vec4 tmpvar_41;
  tmpvar_41 = (tmpvar_39 + tmpvar_40);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = texelsWeightsA_20.yw;
  tmpvar_42.zw = texelsWeightsB_21.yw;
  highp vec4 tmpvar_43;
  tmpvar_43.xy = texelsWeightsA_28.yw;
  tmpvar_43.zw = texelsWeightsB_29.yw;
  fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_44;
  tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_45;
  tmpvar_45.x = fetchesOffsetsU_15.x;
  tmpvar_45.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_46;
  tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
  tmpvar_46.z = shadowCoord_12.z;
  lowp float tmpvar_47;
  tmpvar_47 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_46);
  shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
  highp vec2 tmpvar_48;
  tmpvar_48.x = fetchesOffsetsU_15.y;
  tmpvar_48.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_49;
  tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
  tmpvar_49.z = shadowCoord_12.z;
  lowp float tmpvar_50;
  tmpvar_50 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_49);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
  highp vec2 tmpvar_51;
  tmpvar_51.x = fetchesOffsetsU_15.z;
  tmpvar_51.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_52;
  tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
  tmpvar_52.z = shadowCoord_12.z;
  lowp float tmpvar_53;
  tmpvar_53 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_52);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
  highp vec2 tmpvar_54;
  tmpvar_54.x = fetchesOffsetsU_15.w;
  tmpvar_54.y = fetchesOffsetsV_14.x;
  highp vec3 tmpvar_55;
  tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
  tmpvar_55.z = shadowCoord_12.z;
  lowp float tmpvar_56;
  tmpvar_56 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_55);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.x) * tmpvar_56));
  highp vec2 tmpvar_57;
  tmpvar_57.x = fetchesOffsetsU_15.x;
  tmpvar_57.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_58;
  tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
  tmpvar_58.z = shadowCoord_12.z;
  lowp float tmpvar_59;
  tmpvar_59 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_58);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_59));
  highp vec2 tmpvar_60;
  tmpvar_60.x = fetchesOffsetsU_15.y;
  tmpvar_60.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_61;
  tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
  tmpvar_61.z = shadowCoord_12.z;
  lowp float tmpvar_62;
  tmpvar_62 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_61);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_62));
  highp vec2 tmpvar_63;
  tmpvar_63.x = fetchesOffsetsU_15.z;
  tmpvar_63.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_64;
  tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
  tmpvar_64.z = shadowCoord_12.z;
  lowp float tmpvar_65;
  tmpvar_65 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_64);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_65));
  highp vec2 tmpvar_66;
  tmpvar_66.x = fetchesOffsetsU_15.w;
  tmpvar_66.y = fetchesOffsetsV_14.y;
  highp vec3 tmpvar_67;
  tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
  tmpvar_67.z = shadowCoord_12.z;
  lowp float tmpvar_68;
  tmpvar_68 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_67);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.y) * tmpvar_68));
  highp vec2 tmpvar_69;
  tmpvar_69.x = fetchesOffsetsU_15.x;
  tmpvar_69.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_70;
  tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
  tmpvar_70.z = shadowCoord_12.z;
  lowp float tmpvar_71;
  tmpvar_71 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_70);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_71));
  highp vec2 tmpvar_72;
  tmpvar_72.x = fetchesOffsetsU_15.y;
  tmpvar_72.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = (tmpvar_44 + tmpvar_72);
  tmpvar_73.z = shadowCoord_12.z;
  lowp float tmpvar_74;
  tmpvar_74 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_73);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_74));
  highp vec2 tmpvar_75;
  tmpvar_75.x = fetchesOffsetsU_15.z;
  tmpvar_75.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_76;
  tmpvar_76.xy = (tmpvar_44 + tmpvar_75);
  tmpvar_76.z = shadowCoord_12.z;
  lowp float tmpvar_77;
  tmpvar_77 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_76);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_77));
  highp vec2 tmpvar_78;
  tmpvar_78.x = fetchesOffsetsU_15.w;
  tmpvar_78.y = fetchesOffsetsV_14.z;
  highp vec3 tmpvar_79;
  tmpvar_79.xy = (tmpvar_44 + tmpvar_78);
  tmpvar_79.z = shadowCoord_12.z;
  lowp float tmpvar_80;
  tmpvar_80 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_79);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.z) * tmpvar_80));
  highp vec2 tmpvar_81;
  tmpvar_81.x = fetchesOffsetsU_15.x;
  tmpvar_81.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_82;
  tmpvar_82.xy = (tmpvar_44 + tmpvar_81);
  tmpvar_82.z = shadowCoord_12.z;
  lowp float tmpvar_83;
  tmpvar_83 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_82);
  shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.w) * tmpvar_83));
  highp vec2 tmpvar_84;
  tmpvar_84.x = fetchesOffsetsU_15.y;
  tmpvar_84.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_85;
  tmpvar_85.xy = (tmpvar_44 + tmpvar_84);
  tmpvar_85.z = shadowCoord_12.z;
  lowp float tmpvar_86;
  tmpvar_86 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_85);
  shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.w) * tmpvar_86));
  highp vec2 tmpvar_87;
  tmpvar_87.x = fetchesOffsetsU_15.z;
  tmpvar_87.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_88;
  tmpvar_88.xy = (tmpvar_44 + tmpvar_87);
  tmpvar_88.z = shadowCoord_12.z;
  lowp float tmpvar_89;
  tmpvar_89 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_88);
  shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.w) * tmpvar_89));
  highp vec2 tmpvar_90;
  tmpvar_90.x = fetchesOffsetsU_15.w;
  tmpvar_90.y = fetchesOffsetsV_14.w;
  highp vec3 tmpvar_91;
  tmpvar_91.xy = (tmpvar_44 + tmpvar_90);
  tmpvar_91.z = shadowCoord_12.z;
  lowp float tmpvar_92;
  tmpvar_92 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_91);
  shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.w) * tmpvar_92));
  highp vec3 tmpvar_93;
  highp vec3 tmpvar_94;
  highp vec3 lightDir_95;
  highp vec3 tmpvar_96;
  tmpvar_96 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_97;
  tmpvar_97 = clamp ((sqrt(
    dot (tmpvar_96, tmpvar_96)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_95 = normalize(tmpvar_96);
  tmpvar_94 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_93 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  highp float tmpvar_98;
  mediump float diffuseTerm_99;
  highp float perceptualRoughness_100;
  mediump vec3 albedo_101;
  albedo_101 = tmpvar_2;
  mediump vec3 specColor_102;
  specColor_102 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_101 * tmpvar_3));
  mediump float tmpvar_103;
  tmpvar_103 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_98 = 0.0;
  mediump vec3 diffColor_104;
  mediump float alpha_105;
  alpha_105 = tmpvar_98;
  mediump float outModifiedAlpha_106;
  diffColor_104 = ((albedo_101 * tmpvar_103) * alpha_105);
  outModifiedAlpha_106 = ((1.0 - tmpvar_103) + (alpha_105 * tmpvar_103));
  tmpvar_98 = outModifiedAlpha_106;
  mediump float tmpvar_107;
  tmpvar_107 = (1.0 - tmpvar_4);
  perceptualRoughness_100 = tmpvar_107;
  highp vec3 tmpvar_108;
  highp vec3 inVec_109;
  inVec_109 = (lightDir_95 + tmpvar_93);
  tmpvar_108 = (inVec_109 * inversesqrt(max (0.001, 
    dot (inVec_109, inVec_109)
  )));
  highp float tmpvar_110;
  tmpvar_110 = abs(dot (tmpvar_93, tmpvar_94));
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_94, lightDir_95), 0.0, 1.0);
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (tmpvar_94, tmpvar_108), 0.0, 1.0);
  mediump float tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (lightDir_95, tmpvar_108), 0.0, 1.0);
  tmpvar_113 = tmpvar_114;
  mediump float tmpvar_115;
  mediump float NdotV_116;
  NdotV_116 = tmpvar_110;
  mediump float NdotL_117;
  NdotL_117 = tmpvar_111;
  mediump float perceptualRoughness_118;
  perceptualRoughness_118 = perceptualRoughness_100;
  mediump float tmpvar_119;
  tmpvar_119 = (0.5 + ((2.0 * tmpvar_113) * (tmpvar_113 * perceptualRoughness_118)));
  mediump float x_120;
  x_120 = (1.0 - NdotL_117);
  mediump float x_121;
  x_121 = (1.0 - NdotV_116);
  tmpvar_115 = ((1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )) * (1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_121 * x_121) * ((x_121 * x_121) * x_121))
  )));
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_115 * tmpvar_111);
  diffuseTerm_99 = tmpvar_122;
  highp float tmpvar_123;
  tmpvar_123 = max ((perceptualRoughness_100 * perceptualRoughness_100), 0.002);
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_123 * tmpvar_123);
  highp float tmpvar_125;
  tmpvar_125 = (((
    (tmpvar_112 * tmpvar_124)
   - tmpvar_112) * tmpvar_112) + 1.0);
  mediump vec3 tmpvar_126;
  mediump float x_127;
  x_127 = (1.0 - tmpvar_113);
  tmpvar_126 = (specColor_102 + ((1.0 - specColor_102) * (
    (x_127 * x_127)
   * 
    ((x_127 * x_127) * x_127)
  )));
  outColor_1.xyz = (((
    (diffColor_104 * LIGHT_COLOR)
   * diffuseTerm_99) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_124)
       / 
        ((tmpvar_125 * tmpvar_125) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_111 * (
          (tmpvar_110 * (1.0 - tmpvar_123))
         + tmpvar_123)) + (tmpvar_110 * (
          (tmpvar_111 * (1.0 - tmpvar_123))
         + tmpvar_123))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_111)) * LIGHT_COLOR)
   * tmpvar_126)) * ((
    ((1.0 - tmpvar_97) / ((LIGHT_ATTENUATION.x + (tmpvar_97 * LIGHT_ATTENUATION.y)) + ((tmpvar_97 * tmpvar_97) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_95, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_16, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  if (((col_7.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalWorld_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  normalWorld_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * 0.5);
  tmpvar_4 = (mg_7.y * 0.5);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec2 fetchesOffsetsV_15;
  highp vec2 fetchesOffsetsU_16;
  highp float shadow_17;
  shadow_17 = 1.0;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec4 computedWeight_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_20.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_20.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  computedWeight_21 = (computedArea_22 * 0.44444);
  highp vec4 computedWeight_28;
  highp vec4 computedArea_29;
  highp vec4 computedAreaUncut_30;
  highp float tmpvar_31;
  tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
  computedArea_29.x = tmpvar_32;
  computedAreaUncut_30.x = tmpvar_32;
  computedArea_29.w = tmpvar_31;
  computedAreaUncut_30.w = tmpvar_31;
  computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_33;
  tmpvar_33 = min (tmpvar_20.y, 0.0);
  computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
  computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = max (tmpvar_20.y, 0.0);
  computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
  computedWeight_28 = (computedArea_29 * 0.44444);
  highp vec2 tmpvar_35;
  tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
  highp vec2 tmpvar_36;
  tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
  fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_16.x;
  tmpvar_38.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_13.z;
  highp vec4 tmpvar_40;
  tmpvar_40 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
  highp float tmpvar_41;
  if ((tmpvar_40.x < shadowCoord_13.z)) {
    tmpvar_41 = 0.0;
  } else {
    tmpvar_41 = 1.0;
  };
  shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_41);
  highp vec2 tmpvar_42;
  tmpvar_42.x = fetchesOffsetsU_16.y;
  tmpvar_42.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_43;
  tmpvar_43.xy = (tmpvar_37 + tmpvar_42);
  tmpvar_43.z = shadowCoord_13.z;
  highp vec4 tmpvar_44;
  tmpvar_44 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
  highp float tmpvar_45;
  if ((tmpvar_44.x < shadowCoord_13.z)) {
    tmpvar_45 = 0.0;
  } else {
    tmpvar_45 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_45));
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_16.x;
  tmpvar_46.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_37 + tmpvar_46);
  tmpvar_47.z = shadowCoord_13.z;
  highp vec4 tmpvar_48;
  tmpvar_48 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_47.xy);
  highp float tmpvar_49;
  if ((tmpvar_48.x < shadowCoord_13.z)) {
    tmpvar_49 = 0.0;
  } else {
    tmpvar_49 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_49));
  highp vec2 tmpvar_50;
  tmpvar_50.x = fetchesOffsetsU_16.y;
  tmpvar_50.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_51;
  tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
  tmpvar_51.z = shadowCoord_13.z;
  highp vec4 tmpvar_52;
  tmpvar_52 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_51.xy);
  highp float tmpvar_53;
  if ((tmpvar_52.x < shadowCoord_13.z)) {
    tmpvar_53 = 0.0;
  } else {
    tmpvar_53 = 1.0;
  };
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_53));
  highp vec3 tmpvar_54;
  highp vec3 lightDir_55;
  highp vec3 tmpvar_56;
  tmpvar_56 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_57;
  tmpvar_57 = clamp ((sqrt(
    dot (tmpvar_56, tmpvar_56)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_55 = normalize(tmpvar_56);
  tmpvar_54 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_58;
  mediump float diffuseTerm_59;
  highp float perceptualRoughness_60;
  mediump vec3 albedo_61;
  albedo_61 = tmpvar_2;
  mediump vec3 specColor_62;
  specColor_62 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_61 * tmpvar_3));
  mediump float tmpvar_63;
  tmpvar_63 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_58 = 0.0;
  mediump vec3 diffColor_64;
  mediump float alpha_65;
  alpha_65 = tmpvar_58;
  mediump float outModifiedAlpha_66;
  diffColor_64 = ((albedo_61 * tmpvar_63) * alpha_65);
  outModifiedAlpha_66 = ((1.0 - tmpvar_63) + (alpha_65 * tmpvar_63));
  tmpvar_58 = outModifiedAlpha_66;
  mediump float tmpvar_67;
  tmpvar_67 = (1.0 - tmpvar_4);
  perceptualRoughness_60 = tmpvar_67;
  highp vec3 tmpvar_68;
  highp vec3 inVec_69;
  inVec_69 = (lightDir_55 + tmpvar_54);
  tmpvar_68 = (inVec_69 * inversesqrt(max (0.001, 
    dot (inVec_69, inVec_69)
  )));
  highp float tmpvar_70;
  tmpvar_70 = abs(dot (tmpvar_54, normalWorld_5));
  highp float tmpvar_71;
  tmpvar_71 = clamp (dot (normalWorld_5, lightDir_55), 0.0, 1.0);
  highp float tmpvar_72;
  tmpvar_72 = clamp (dot (normalWorld_5, tmpvar_68), 0.0, 1.0);
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = clamp (dot (lightDir_55, tmpvar_68), 0.0, 1.0);
  tmpvar_73 = tmpvar_74;
  mediump float tmpvar_75;
  mediump float NdotV_76;
  NdotV_76 = tmpvar_70;
  mediump float NdotL_77;
  NdotL_77 = tmpvar_71;
  mediump float perceptualRoughness_78;
  perceptualRoughness_78 = perceptualRoughness_60;
  mediump float tmpvar_79;
  tmpvar_79 = (0.5 + ((2.0 * tmpvar_73) * (tmpvar_73 * perceptualRoughness_78)));
  mediump float x_80;
  x_80 = (1.0 - NdotL_77);
  mediump float x_81;
  x_81 = (1.0 - NdotV_76);
  tmpvar_75 = ((1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_80 * x_80) * ((x_80 * x_80) * x_80))
  )) * (1.0 + (
    (tmpvar_79 - 1.0)
   * 
    ((x_81 * x_81) * ((x_81 * x_81) * x_81))
  )));
  highp float tmpvar_82;
  tmpvar_82 = (tmpvar_75 * tmpvar_71);
  diffuseTerm_59 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max ((perceptualRoughness_60 * perceptualRoughness_60), 0.002);
  highp float tmpvar_84;
  tmpvar_84 = (tmpvar_83 * tmpvar_83);
  highp float tmpvar_85;
  tmpvar_85 = (((
    (tmpvar_72 * tmpvar_84)
   - tmpvar_72) * tmpvar_72) + 1.0);
  mediump vec3 tmpvar_86;
  mediump float x_87;
  x_87 = (1.0 - tmpvar_73);
  tmpvar_86 = (specColor_62 + ((1.0 - specColor_62) * (
    (x_87 * x_87)
   * 
    ((x_87 * x_87) * x_87)
  )));
  outColor_1.xyz = (((
    (diffColor_64 * LIGHT_COLOR)
   * diffuseTerm_59) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_84)
       / 
        ((tmpvar_85 * tmpvar_85) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_71 * (
          (tmpvar_70 * (1.0 - tmpvar_83))
         + tmpvar_83)) + (tmpvar_70 * (
          (tmpvar_71 * (1.0 - tmpvar_83))
         + tmpvar_83))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_71)) * LIGHT_COLOR)
   * tmpvar_86)) * ((
    ((1.0 - tmpvar_57) / ((LIGHT_ATTENUATION.x + (tmpvar_57 * LIGHT_ATTENUATION.y)) + ((tmpvar_57 * tmpvar_57) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_55, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","PointLight","ShadowOff","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * 0.5);
  tmpvar_4 = (mg_6.y * 0.5);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = normalize(tmpvar_15);
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 albedo_20;
  albedo_20 = tmpvar_2;
  mediump vec3 specColor_21;
  specColor_21 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_20 * tmpvar_3));
  mediump float tmpvar_22;
  tmpvar_22 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_17 = 0.0;
  mediump vec3 diffColor_23;
  mediump float alpha_24;
  alpha_24 = tmpvar_17;
  mediump float outModifiedAlpha_25;
  diffColor_23 = ((albedo_20 * tmpvar_22) * alpha_24);
  outModifiedAlpha_25 = ((1.0 - tmpvar_22) + (alpha_24 * tmpvar_22));
  tmpvar_17 = outModifiedAlpha_25;
  mediump float tmpvar_26;
  tmpvar_26 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_26;
  highp vec3 tmpvar_27;
  highp vec3 inVec_28;
  inVec_28 = (tmpvar_13 + tmpvar_12);
  tmpvar_27 = (inVec_28 * inversesqrt(max (0.001, 
    dot (inVec_28, inVec_28)
  )));
  highp float tmpvar_29;
  tmpvar_29 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_14, tmpvar_27), 0.0, 1.0);
  mediump float tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = clamp (dot (tmpvar_13, tmpvar_27), 0.0, 1.0);
  tmpvar_32 = tmpvar_33;
  mediump float tmpvar_34;
  mediump float NdotV_35;
  NdotV_35 = tmpvar_29;
  mediump float NdotL_36;
  NdotL_36 = tmpvar_30;
  mediump float perceptualRoughness_37;
  perceptualRoughness_37 = perceptualRoughness_19;
  mediump float tmpvar_38;
  tmpvar_38 = (0.5 + ((2.0 * tmpvar_32) * (tmpvar_32 * perceptualRoughness_37)));
  mediump float x_39;
  x_39 = (1.0 - NdotL_36);
  mediump float x_40;
  x_40 = (1.0 - NdotV_35);
  tmpvar_34 = ((1.0 + (
    (tmpvar_38 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )) * (1.0 + (
    (tmpvar_38 - 1.0)
   * 
    ((x_40 * x_40) * ((x_40 * x_40) * x_40))
  )));
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_34 * tmpvar_30);
  diffuseTerm_18 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_43;
  tmpvar_43 = (tmpvar_42 * tmpvar_42);
  highp float tmpvar_44;
  tmpvar_44 = (((
    (tmpvar_31 * tmpvar_43)
   - tmpvar_31) * tmpvar_31) + 1.0);
  mediump vec3 tmpvar_45;
  mediump float x_46;
  x_46 = (1.0 - tmpvar_32);
  tmpvar_45 = (specColor_21 + ((1.0 - specColor_21) * (
    (x_46 * x_46)
   * 
    ((x_46 * x_46) * x_46)
  )));
  outColor_1.xyz = (((
    (diffColor_23 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_43)
       / 
        ((tmpvar_44 * tmpvar_44) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_30 * (
          (tmpvar_29 * (1.0 - tmpvar_42))
         + tmpvar_42)) + (tmpvar_29 * (
          (tmpvar_30 * (1.0 - tmpvar_42))
         + tmpvar_42))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_30)) * LIGHT_COLOR)
   * tmpvar_45)) * ((1.0 - tmpvar_16) / (
    (LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z)
  )));
  outColor_1.w = 1.0;
  if (((col_7.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","PointLight","ShadowOn","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * 0.5);
  tmpvar_4 = (mg_6.y * 0.5);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LIGHT_POSITION - tmpvar_11);
  highp float tmpvar_16;
  tmpvar_16 = clamp ((sqrt(
    dot (tmpvar_15, tmpvar_15)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = normalize(tmpvar_15);
  highp float tmpvar_17;
  mediump float diffuseTerm_18;
  highp float perceptualRoughness_19;
  mediump vec3 albedo_20;
  albedo_20 = tmpvar_2;
  mediump vec3 specColor_21;
  specColor_21 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_20 * tmpvar_3));
  mediump float tmpvar_22;
  tmpvar_22 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_17 = 0.0;
  mediump vec3 diffColor_23;
  mediump float alpha_24;
  alpha_24 = tmpvar_17;
  mediump float outModifiedAlpha_25;
  diffColor_23 = ((albedo_20 * tmpvar_22) * alpha_24);
  outModifiedAlpha_25 = ((1.0 - tmpvar_22) + (alpha_24 * tmpvar_22));
  tmpvar_17 = outModifiedAlpha_25;
  mediump float tmpvar_26;
  tmpvar_26 = (1.0 - tmpvar_4);
  perceptualRoughness_19 = tmpvar_26;
  highp vec3 tmpvar_27;
  highp vec3 inVec_28;
  inVec_28 = (tmpvar_13 + tmpvar_12);
  tmpvar_27 = (inVec_28 * inversesqrt(max (0.001, 
    dot (inVec_28, inVec_28)
  )));
  highp float tmpvar_29;
  tmpvar_29 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_14, tmpvar_27), 0.0, 1.0);
  mediump float tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = clamp (dot (tmpvar_13, tmpvar_27), 0.0, 1.0);
  tmpvar_32 = tmpvar_33;
  mediump float tmpvar_34;
  mediump float NdotV_35;
  NdotV_35 = tmpvar_29;
  mediump float NdotL_36;
  NdotL_36 = tmpvar_30;
  mediump float perceptualRoughness_37;
  perceptualRoughness_37 = perceptualRoughness_19;
  mediump float tmpvar_38;
  tmpvar_38 = (0.5 + ((2.0 * tmpvar_32) * (tmpvar_32 * perceptualRoughness_37)));
  mediump float x_39;
  x_39 = (1.0 - NdotL_36);
  mediump float x_40;
  x_40 = (1.0 - NdotV_35);
  tmpvar_34 = ((1.0 + (
    (tmpvar_38 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )) * (1.0 + (
    (tmpvar_38 - 1.0)
   * 
    ((x_40 * x_40) * ((x_40 * x_40) * x_40))
  )));
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_34 * tmpvar_30);
  diffuseTerm_18 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = max ((perceptualRoughness_19 * perceptualRoughness_19), 0.002);
  highp float tmpvar_43;
  tmpvar_43 = (tmpvar_42 * tmpvar_42);
  highp float tmpvar_44;
  tmpvar_44 = (((
    (tmpvar_31 * tmpvar_43)
   - tmpvar_31) * tmpvar_31) + 1.0);
  mediump vec3 tmpvar_45;
  mediump float x_46;
  x_46 = (1.0 - tmpvar_32);
  tmpvar_45 = (specColor_21 + ((1.0 - specColor_21) * (
    (x_46 * x_46)
   * 
    ((x_46 * x_46) * x_46)
  )));
  outColor_1.xyz = (((
    (diffColor_23 * LIGHT_COLOR)
   * diffuseTerm_18) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_43)
       / 
        ((tmpvar_44 * tmpvar_44) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_30 * (
          (tmpvar_29 * (1.0 - tmpvar_42))
         + tmpvar_42)) + (tmpvar_29 * (
          (tmpvar_30 * (1.0 - tmpvar_42))
         + tmpvar_42))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_30)) * LIGHT_COLOR)
   * tmpvar_45)) * ((1.0 - tmpvar_16) / (
    (LIGHT_ATTENUATION.x + (tmpvar_16 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_16 * tmpvar_16) * LIGHT_ATTENUATION.z)
  )));
  outColor_1.w = 1.0;
  if (((col_7.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 normalTangent_5;
  highp vec2 mg_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_6 = tmpvar_9;
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_5 = tmpvar_10;
  normalTangent_5 = ((normalTangent_5 * 2.0) - 1.0);
  tmpvar_2 = col_7.xyz;
  tmpvar_3 = (mg_6.x * 0.5);
  tmpvar_4 = (mg_6.y * 0.5);
  highp vec3 tmpvar_11;
  tmpvar_11.x = xlv_TEXCOORD1.w;
  tmpvar_11.y = xlv_TEXCOORD2.w;
  tmpvar_11.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(((
    (normalTangent_5.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_5.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_5.z * xlv_TEXCOORD1.xyz)));
  tmpvar_12 = normalize((CAMERA_WORLDPOSITION - tmpvar_11));
  tmpvar_13 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_15;
  mediump float diffuseTerm_16;
  highp float perceptualRoughness_17;
  mediump vec3 albedo_18;
  albedo_18 = tmpvar_2;
  mediump vec3 specColor_19;
  specColor_19 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_18 * tmpvar_3));
  mediump float tmpvar_20;
  tmpvar_20 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_15 = 0.0;
  mediump vec3 diffColor_21;
  mediump float alpha_22;
  alpha_22 = tmpvar_15;
  mediump float outModifiedAlpha_23;
  diffColor_21 = ((albedo_18 * tmpvar_20) * alpha_22);
  outModifiedAlpha_23 = ((1.0 - tmpvar_20) + (alpha_22 * tmpvar_20));
  tmpvar_15 = outModifiedAlpha_23;
  mediump float tmpvar_24;
  tmpvar_24 = (1.0 - tmpvar_4);
  perceptualRoughness_17 = tmpvar_24;
  highp vec3 tmpvar_25;
  highp vec3 inVec_26;
  inVec_26 = (tmpvar_13 + tmpvar_12);
  tmpvar_25 = (inVec_26 * inversesqrt(max (0.001, 
    dot (inVec_26, inVec_26)
  )));
  highp float tmpvar_27;
  tmpvar_27 = abs(dot (tmpvar_12, tmpvar_14));
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_14, tmpvar_13), 0.0, 1.0);
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_14, tmpvar_25), 0.0, 1.0);
  mediump float tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = clamp (dot (tmpvar_13, tmpvar_25), 0.0, 1.0);
  tmpvar_30 = tmpvar_31;
  mediump float tmpvar_32;
  mediump float NdotV_33;
  NdotV_33 = tmpvar_27;
  mediump float NdotL_34;
  NdotL_34 = tmpvar_28;
  mediump float perceptualRoughness_35;
  perceptualRoughness_35 = perceptualRoughness_17;
  mediump float tmpvar_36;
  tmpvar_36 = (0.5 + ((2.0 * tmpvar_30) * (tmpvar_30 * perceptualRoughness_35)));
  mediump float x_37;
  x_37 = (1.0 - NdotL_34);
  mediump float x_38;
  x_38 = (1.0 - NdotV_33);
  tmpvar_32 = ((1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )) * (1.0 + (
    (tmpvar_36 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )));
  highp float tmpvar_39;
  tmpvar_39 = (tmpvar_32 * tmpvar_28);
  diffuseTerm_16 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_17 * perceptualRoughness_17), 0.002);
  highp float tmpvar_41;
  tmpvar_41 = (tmpvar_40 * tmpvar_40);
  highp float tmpvar_42;
  tmpvar_42 = (((
    (tmpvar_29 * tmpvar_41)
   - tmpvar_29) * tmpvar_29) + 1.0);
  mediump vec3 tmpvar_43;
  mediump float x_44;
  x_44 = (1.0 - tmpvar_30);
  tmpvar_43 = (specColor_19 + ((1.0 - specColor_19) * (
    (x_44 * x_44)
   * 
    ((x_44 * x_44) * x_44)
  )));
  outColor_1.xyz = (((diffColor_21 * LIGHT_COLOR) * diffuseTerm_16) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_41) / (
        (tmpvar_42 * tmpvar_42)
       + 1e-7)) * (0.5 / (
        ((tmpvar_28 * ((tmpvar_27 * 
          (1.0 - tmpvar_40)
        ) + tmpvar_40)) + (tmpvar_27 * ((tmpvar_28 * 
          (1.0 - tmpvar_40)
        ) + tmpvar_40)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_28))
   * LIGHT_COLOR) * tmpvar_43));
  outColor_1.w = 1.0;
  if (((col_7.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * 0.5);
  tmpvar_4 = (mg_7.y * 0.5);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_15;
    highp vec2 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 computedWeight_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_20.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_20.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    computedWeight_21 = (computedArea_22 * 0.44444);
    highp vec4 computedWeight_28;
    highp vec4 computedArea_29;
    highp vec4 computedAreaUncut_30;
    highp float tmpvar_31;
    tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_32;
    tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
    computedArea_29.x = tmpvar_32;
    computedAreaUncut_30.x = tmpvar_32;
    computedArea_29.w = tmpvar_31;
    computedAreaUncut_30.w = tmpvar_31;
    computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = min (tmpvar_20.y, 0.0);
    computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
    computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = max (tmpvar_20.y, 0.0);
    computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
    computedWeight_28 = (computedArea_29 * 0.44444);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
    fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_16.x;
    tmpvar_38.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_13.z;
    lowp float tmpvar_40;
    tmpvar_40 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_16.y;
    tmpvar_41.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_13.z;
    lowp float tmpvar_43;
    tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_16.x;
    tmpvar_44.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_13.z;
    lowp float tmpvar_46;
    tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_16.y;
    tmpvar_47.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_13.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_50;
  highp vec3 tmpvar_51;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_51 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_52;
  mediump float diffuseTerm_53;
  highp float perceptualRoughness_54;
  mediump vec3 albedo_55;
  albedo_55 = tmpvar_2;
  mediump vec3 specColor_56;
  specColor_56 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_55 * tmpvar_3));
  mediump float tmpvar_57;
  tmpvar_57 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_52 = 0.0;
  mediump vec3 diffColor_58;
  mediump float alpha_59;
  alpha_59 = tmpvar_52;
  mediump float outModifiedAlpha_60;
  diffColor_58 = ((albedo_55 * tmpvar_57) * alpha_59);
  outModifiedAlpha_60 = ((1.0 - tmpvar_57) + (alpha_59 * tmpvar_57));
  tmpvar_52 = outModifiedAlpha_60;
  mediump float tmpvar_61;
  tmpvar_61 = (1.0 - tmpvar_4);
  perceptualRoughness_54 = tmpvar_61;
  highp vec3 tmpvar_62;
  highp vec3 inVec_63;
  inVec_63 = (tmpvar_51 + tmpvar_50);
  tmpvar_62 = (inVec_63 * inversesqrt(max (0.001, 
    dot (inVec_63, inVec_63)
  )));
  highp float tmpvar_64;
  tmpvar_64 = abs(dot (tmpvar_50, tmpvar_5));
  highp float tmpvar_65;
  tmpvar_65 = clamp (dot (tmpvar_5, tmpvar_51), 0.0, 1.0);
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_5, tmpvar_62), 0.0, 1.0);
  mediump float tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = clamp (dot (tmpvar_51, tmpvar_62), 0.0, 1.0);
  tmpvar_67 = tmpvar_68;
  mediump float tmpvar_69;
  mediump float NdotV_70;
  NdotV_70 = tmpvar_64;
  mediump float NdotL_71;
  NdotL_71 = tmpvar_65;
  mediump float perceptualRoughness_72;
  perceptualRoughness_72 = perceptualRoughness_54;
  mediump float tmpvar_73;
  tmpvar_73 = (0.5 + ((2.0 * tmpvar_67) * (tmpvar_67 * perceptualRoughness_72)));
  mediump float x_74;
  x_74 = (1.0 - NdotL_71);
  mediump float x_75;
  x_75 = (1.0 - NdotV_70);
  tmpvar_69 = ((1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_74 * x_74) * ((x_74 * x_74) * x_74))
  )) * (1.0 + (
    (tmpvar_73 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )));
  highp float tmpvar_76;
  tmpvar_76 = (tmpvar_69 * tmpvar_65);
  diffuseTerm_53 = tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = max ((perceptualRoughness_54 * perceptualRoughness_54), 0.002);
  highp float tmpvar_78;
  tmpvar_78 = (tmpvar_77 * tmpvar_77);
  highp float tmpvar_79;
  tmpvar_79 = (((
    (tmpvar_66 * tmpvar_78)
   - tmpvar_66) * tmpvar_66) + 1.0);
  mediump vec3 tmpvar_80;
  mediump float x_81;
  x_81 = (1.0 - tmpvar_67);
  tmpvar_80 = (specColor_56 + ((1.0 - specColor_56) * (
    (x_81 * x_81)
   * 
    ((x_81 * x_81) * x_81)
  )));
  outColor_1.xyz = (((
    (diffColor_58 * LIGHT_COLOR)
   * diffuseTerm_53) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_78)
       / 
        ((tmpvar_79 * tmpvar_79) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_65 * (
          (tmpvar_64 * (1.0 - tmpvar_77))
         + tmpvar_77)) + (tmpvar_64 * (
          (tmpvar_65 * (1.0 - tmpvar_77))
         + tmpvar_77))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_65)) * LIGHT_COLOR)
   * tmpvar_80)) * tmpvar_14);
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * 0.5);
  tmpvar_4 = (mg_7.y * 0.5);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_15;
    highp vec3 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 texelsWeightsA_29;
    highp vec3 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.16 * tmpvar_34);
    texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
    texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
    texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
    texelsWeightsB_30.z = (0.16 * tmpvar_33);
    highp vec3 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_21.y;
    tmpvar_38.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec3 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.z = texelsWeightsB_30.y;
    highp vec3 tmpvar_41;
    tmpvar_41.x = texelsWeightsA_29.y;
    tmpvar_41.yz = texelsWeightsB_30.xz;
    highp vec3 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_21.y;
    tmpvar_43.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_29.y;
    tmpvar_44.yz = texelsWeightsB_30.xz;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    lowp float tmpvar_48;
    tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.x;
    tmpvar_55.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.y;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.z;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.x;
    tmpvar_64.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.y;
    tmpvar_67.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.z;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_73;
  highp vec3 tmpvar_74;
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_74 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_75;
  mediump float diffuseTerm_76;
  highp float perceptualRoughness_77;
  mediump vec3 albedo_78;
  albedo_78 = tmpvar_2;
  mediump vec3 specColor_79;
  specColor_79 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_78 * tmpvar_3));
  mediump float tmpvar_80;
  tmpvar_80 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_75 = 0.0;
  mediump vec3 diffColor_81;
  mediump float alpha_82;
  alpha_82 = tmpvar_75;
  mediump float outModifiedAlpha_83;
  diffColor_81 = ((albedo_78 * tmpvar_80) * alpha_82);
  outModifiedAlpha_83 = ((1.0 - tmpvar_80) + (alpha_82 * tmpvar_80));
  tmpvar_75 = outModifiedAlpha_83;
  mediump float tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_4);
  perceptualRoughness_77 = tmpvar_84;
  highp vec3 tmpvar_85;
  highp vec3 inVec_86;
  inVec_86 = (tmpvar_74 + tmpvar_73);
  tmpvar_85 = (inVec_86 * inversesqrt(max (0.001, 
    dot (inVec_86, inVec_86)
  )));
  highp float tmpvar_87;
  tmpvar_87 = abs(dot (tmpvar_73, tmpvar_5));
  highp float tmpvar_88;
  tmpvar_88 = clamp (dot (tmpvar_5, tmpvar_74), 0.0, 1.0);
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_5, tmpvar_85), 0.0, 1.0);
  mediump float tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_74, tmpvar_85), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  mediump float tmpvar_92;
  mediump float NdotV_93;
  NdotV_93 = tmpvar_87;
  mediump float NdotL_94;
  NdotL_94 = tmpvar_88;
  mediump float perceptualRoughness_95;
  perceptualRoughness_95 = perceptualRoughness_77;
  mediump float tmpvar_96;
  tmpvar_96 = (0.5 + ((2.0 * tmpvar_90) * (tmpvar_90 * perceptualRoughness_95)));
  mediump float x_97;
  x_97 = (1.0 - NdotL_94);
  mediump float x_98;
  x_98 = (1.0 - NdotV_93);
  tmpvar_92 = ((1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_97 * x_97) * ((x_97 * x_97) * x_97))
  )) * (1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_98 * x_98) * ((x_98 * x_98) * x_98))
  )));
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_92 * tmpvar_88);
  diffuseTerm_76 = tmpvar_99;
  highp float tmpvar_100;
  tmpvar_100 = max ((perceptualRoughness_77 * perceptualRoughness_77), 0.002);
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_100 * tmpvar_100);
  highp float tmpvar_102;
  tmpvar_102 = (((
    (tmpvar_89 * tmpvar_101)
   - tmpvar_89) * tmpvar_89) + 1.0);
  mediump vec3 tmpvar_103;
  mediump float x_104;
  x_104 = (1.0 - tmpvar_90);
  tmpvar_103 = (specColor_79 + ((1.0 - specColor_79) * (
    (x_104 * x_104)
   * 
    ((x_104 * x_104) * x_104)
  )));
  outColor_1.xyz = (((
    (diffColor_81 * LIGHT_COLOR)
   * diffuseTerm_76) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_101)
       / 
        ((tmpvar_102 * tmpvar_102) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_88 * (
          (tmpvar_87 * (1.0 - tmpvar_100))
         + tmpvar_100)) + (tmpvar_87 * (
          (tmpvar_88 * (1.0 - tmpvar_100))
         + tmpvar_100))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_88)) * LIGHT_COLOR)
   * tmpvar_103)) * tmpvar_14);
  outColor_1.w = 1.0;
  if (((col_8.w - _CutOff) <= 0.0)) {
    discard;
  };
  gl_FragData[0] = outColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE","ALPHATEST_ON","ALPHAPREMULTIPLY_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_NormalTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _DiffuseTex;
uniform sampler2D _MetallicTex;
uniform sampler2D _NormalTex;
uniform highp float _CutOff;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 outColor_1;
  highp vec3 tmpvar_2;
  mediump float tmpvar_3;
  mediump float tmpvar_4;
  highp vec3 tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_DiffuseTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicTex, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_NormalTex, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_2 = col_8.xyz;
  tmpvar_3 = (mg_7.x * 0.5);
  tmpvar_4 = (mg_7.y * 0.5);
  tmpvar_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  shadowCoord_13 = xlv_TEXCOORD4;
  highp float tmpvar_14;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_14 = 1.0;
  } else {
    shadowCoord_13.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_15;
    highp vec4 fetchesOffsetsU_16;
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_19;
    tmpvar_19 = floor((tmpvar_18 + 0.5));
    highp vec2 tmpvar_20;
    tmpvar_20 = (tmpvar_18 - tmpvar_19);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_20.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_20.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 texelsWeightsA_29;
    highp vec4 texelsWeightsB_30;
    highp vec4 computedArea_31;
    highp vec4 computedAreaUncut_32;
    highp float tmpvar_33;
    tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
    highp float tmpvar_34;
    tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
    computedArea_31.x = tmpvar_34;
    computedAreaUncut_32.x = tmpvar_34;
    computedArea_31.w = tmpvar_33;
    computedAreaUncut_32.w = tmpvar_33;
    computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = min (tmpvar_20.y, 0.0);
    computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
    computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = max (tmpvar_20.y, 0.0);
    computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
    texelsWeightsA_29.x = (0.081632 * tmpvar_34);
    texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
    texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
    texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
    texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
    texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
    texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
    texelsWeightsB_30.w = (0.081632 * tmpvar_33);
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_21.xz;
    tmpvar_37.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_21.yw;
    tmpvar_38.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_39;
    tmpvar_39 = (tmpvar_37 + tmpvar_38);
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_29.xz;
    tmpvar_40.zw = texelsWeightsB_30.xz;
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_29.yw;
    tmpvar_41.zw = texelsWeightsB_30.yw;
    highp vec4 tmpvar_42;
    tmpvar_42 = (tmpvar_40 + tmpvar_41);
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_21.yw;
    tmpvar_43.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_29.yw;
    tmpvar_44.zw = texelsWeightsB_30.yw;
    fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_45;
    tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_16.x;
    tmpvar_46.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
    tmpvar_47.z = shadowCoord_13.z;
    lowp float tmpvar_48;
    tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
    highp vec2 tmpvar_49;
    tmpvar_49.x = fetchesOffsetsU_16.y;
    tmpvar_49.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
    tmpvar_50.z = shadowCoord_13.z;
    lowp float tmpvar_51;
    tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
    highp vec2 tmpvar_52;
    tmpvar_52.x = fetchesOffsetsU_16.z;
    tmpvar_52.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
    tmpvar_53.z = shadowCoord_13.z;
    lowp float tmpvar_54;
    tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_16.w;
    tmpvar_55.y = fetchesOffsetsV_15.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
    tmpvar_56.z = shadowCoord_13.z;
    lowp float tmpvar_57;
    tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_16.x;
    tmpvar_58.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
    tmpvar_59.z = shadowCoord_13.z;
    lowp float tmpvar_60;
    tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_16.y;
    tmpvar_61.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
    tmpvar_62.z = shadowCoord_13.z;
    lowp float tmpvar_63;
    tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_16.z;
    tmpvar_64.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
    tmpvar_65.z = shadowCoord_13.z;
    lowp float tmpvar_66;
    tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_16.w;
    tmpvar_67.y = fetchesOffsetsV_15.y;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
    tmpvar_68.z = shadowCoord_13.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_16.x;
    tmpvar_70.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
    tmpvar_71.z = shadowCoord_13.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_16.y;
    tmpvar_73.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
    tmpvar_74.z = shadowCoord_13.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_16.z;
    tmpvar_76.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
    tmpvar_77.z = shadowCoord_13.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_16.w;
    tmpvar_79.y = fetchesOffsetsV_15.z;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
    tmpvar_80.z = shadowCoord_13.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_16.x;
    tmpvar_82.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
    tmpvar_83.z = shadowCoord_13.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_16.y;
    tmpvar_85.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
    tmpvar_86.z = shadowCoord_13.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_16.z;
    tmpvar_88.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
    tmpvar_89.z = shadowCoord_13.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_16.w;
    tmpvar_91.y = fetchesOffsetsV_15.w;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
    tmpvar_92.z = shadowCoord_13.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
    tmpvar_14 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_94;
  highp vec3 tmpvar_95;
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_95 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_96;
  mediump float diffuseTerm_97;
  highp float perceptualRoughness_98;
  mediump vec3 albedo_99;
  albedo_99 = tmpvar_2;
  mediump vec3 specColor_100;
  specColor_100 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_3)) + (albedo_99 * tmpvar_3));
  mediump float tmpvar_101;
  tmpvar_101 = (0.7790837 - (tmpvar_3 * 0.7790837));
  tmpvar_96 = 0.0;
  mediump vec3 diffColor_102;
  mediump float alpha_103;
  alpha_103 = tmpvar_96;
  mediump float outModifiedAlpha_104;
  diffColor_102 = ((albedo_99 * tmpvar_101) * alpha_103);
  outModifiedAlpha_104 = ((1.0 - tmpvar_101) + (alpha_103 * tmpvar_101));
  tmpvar_96 = outModifiedAlpha_104;
  mediump float tmpvar_105;
  tmpvar_105 = (1.0 - tmpvar_4);
  perceptualRoughness_98 = tmpvar_105;
  highp vec3 tmpvar_106;
  highp vec3 inVec_107;
  inVec_107 = (tmpvar_95 + tmpvar_94);
  tmpvar_106 = (inVec_107 * inversesqrt(max (0.001, 
    dot (inVec_107, inVec_107)
  )));
  highp float tmpvar_108;
  tmpvar_108 = abs(dot (tmpvar_94, tmpvar_5));
  highp float tmpvar_109;
  tmpvar_109 = clamp (dot (tmpvar_5, tmpvar_95), 0.0, 1.0);
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_5, tmpvar_106), 0.0, 1.0);
  mediump float tmpvar_111;
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (tmpvar_95, tmpvar_106), 0.0, 1.0);
  tmpvar_111 = tmpvar_112;
  mediump float tmpvar_113;
  mediump float NdotV_114;
  NdotV_114 = tmpvar_108;
  mediump float NdotL_115;
  NdotL_115 = tmpvar_109;
  mediump float perceptualRoughness_116;
  perceptualRoughness_116 = perceptualRoughness_98;
  mediump float tmpvar_117;
  tmpvar_117 = (0.5 + ((2.0 * tmpvar_111) * (tmpvar_111 * perceptualRoughness_116)));
  mediump float x_118;
  x_118 = (1.0 - NdotL_115);
  mediump float x_119;
  x_119 = (1.0 - NdotV_114);
  tmpvar_113 = ((1.0 + (
    (tmpvar_117 - 1.0)
   * 
    ((x_118 * x_118) * ((x_118 * x_118) * x_118))
  )) * (1.0 + (
    (tmpvar_117 - 1.0)
   * 
    ((x_119 * x_119) * ((x_119 * x_119) * x_119))
  )));
  highp float tmpvar_120;
 