function DefineParams()
	Properties = 
	{
		
_BlendTex =     {"2_Texture         ", TEXTURE2D, "white"},

_BlendMode =    {"3_Belnd Mode  ", FLOAT, "0.0"},
_Alpha =        {"4_Opacity         ", FLOATRANGE, "1.0,1.0,0.0"},

_DepthTest =    {"5_Depth Test    ", FLOAT, "1.0"},

_StretchMode =    {"6_Stretch Mode ", FLOAT, "0.0"},

_FlipHorizon =  {"7_Flip Horizon", FLOAT, "0.0"},

_FlipVertical = {"8_Flip Vertical", FLOAT, "0.0"},
_TextureRatio =    {"9_TextureRatio ", FLOAT, "0.0"},
_WindowRatio =    {"10_WindowRatio ", FLOAT, "1.0"},
_ScaleXRatio =    {"11_ScaleXRatio ", FLOAT, "1.0"},
_ScaleYRatio =    {"12_ScaleYRatio ", FLOAT, "1.0"},

	}
	Attributes = 
	{
		_BlendMode = "Enum(Normal,0,Add,1,Lighten,2,Multiply,3,Overlay,4,Screen,5,Lighter,6)", 
		_DepthTest = "Enum(ON,0,OFF,1)", 
		_StretchMode = "Enum(Fit,0,Fill,1,Stretch,2,FitHeight,3,FitWidth,4,FillAndCut,5)", 
		_FlipHorizon = "Enum(HON,0,HOFF,1)", 
		_FlipVertical = "Enum(ON,0,VOFF,1)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "screenimage"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_StretchMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FlipVertical",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FlipHorizon",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TextureRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_WindowRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScaleXRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScaleYRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _StretchMode;
uniform highp float _FlipVertical;
uniform highp float _FlipHorizon;
uniform highp float _TextureRatio;
uniform highp float _WindowRatio;
uniform highp float _ScaleXRatio;
uniform highp float _ScaleYRatio;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  highp vec2 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[uint(0)].x = row0_5.x;
  tmpvar_10[uint(0)].y = row0_5.y;
  tmpvar_10[uint(0)].z = row0_5.z;
  tmpvar_10[uint(0)].w = row0_5.w;
  tmpvar_10[1u].x = row1_4.x;
  tmpvar_10[1u].y = row1_4.y;
  tmpvar_10[1u].z = row1_4.z;
  tmpvar_10[1u].w = row1_4.w;
  tmpvar_10[2u].x = row2_3.x;
  tmpvar_10[2u].y = row2_3.y;
  tmpvar_10[2u].z = row2_3.z;
  tmpvar_10[2u].w = row2_3.w;
  tmpvar_10[3u].x = 0.0;
  tmpvar_10[3u].y = 0.0;
  tmpvar_10[3u].z = 0.0;
  tmpvar_10[3u].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)));
  highp vec2 tmpvar_12;
  tmpvar_12.x = tmpvar_11.x;
  tmpvar_12.y = -(tmpvar_11.y);
  tmpvar_2 = (((tmpvar_12 / tmpvar_11.w) + 1.0) / 2.0);
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_14;
  tmpvar_14 = (tmpvar_13 * tmpvar_11);
  tmpvar_1 = _glesMultiTexCoord0.xy;
  if ((_StretchMode == 5.0)) {
    if ((((_ScaleXRatio / _ScaleYRatio) * _WindowRatio) > _TextureRatio)) {
      tmpvar_1.y = (((
        (_glesMultiTexCoord0.y * _ScaleYRatio)
       / _ScaleXRatio) * _TextureRatio) / _WindowRatio);
      tmpvar_1.y = (tmpvar_1.y + ((1.0 - 
        (((_ScaleYRatio / _ScaleXRatio) * _TextureRatio) / _WindowRatio)
      ) / 2.0));
    } else {
      tmpvar_1.x = (((
        (_glesMultiTexCoord0.x * _ScaleXRatio)
       / _ScaleYRatio) * _WindowRatio) / _TextureRatio);
      tmpvar_1.x = (tmpvar_1.x + ((1.0 - 
        (((_ScaleXRatio / _ScaleYRatio) * _WindowRatio) / _TextureRatio)
      ) / 2.0));
    };
  };
  if (bool(_FlipHorizon)) {
    tmpvar_1.x = (1.0 - tmpvar_1.x);
  };
  if (bool(_FlipVertical)) {
    tmpvar_1.y = (1.0 - tmpvar_1.y);
  };
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_2;
  gl_Position = tmpvar_14;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _BlendTex;
uniform highp float _BlendMode;
uniform highp float _Alpha;
in highp vec2 xlv_TEXCOORD0;
in highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec4 blendColor_1;
  highp vec4 mainColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_GRAP, xlv_TEXCOORD1);
  mainColor_2 = tmpvar_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, xlv_TEXCOORD0);
  blendColor_1 = tmpvar_4;
  highp int mode_5;
  mode_5 = int((_BlendMode + 1.5));
  bool tmpvar_6;
  tmpvar_6 = bool(1);
  highp vec3 tmpvar_7;
  if ((mode_5 == 1)) {
    tmpvar_7 = (((
      (mainColor_2.xyz * (1.0 - blendColor_1.w))
     + 
      (blendColor_1.xyz * blendColor_1.w)
    ) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
    tmpvar_6 = bool(0);
  } else {
    if ((mode_5 == 2)) {
      tmpvar_7 = ((min (
        (mainColor_2.xyz + blendColor_1.xyz)
      , vec3(1.0, 1.0, 1.0)) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
      tmpvar_6 = bool(0);
    } else {
      if ((mode_5 == 3)) {
        tmpvar_7 = ((max (blendColor_1.xyz, mainColor_2.xyz) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
        tmpvar_6 = bool(0);
      } else {
        if ((mode_5 == 4)) {
          tmpvar_7 = (((mainColor_2.xyz * blendColor_1.xyz) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
          tmpvar_6 = bool(0);
        } else {
          if ((mode_5 == 5)) {
            highp float tmpvar_8;
            if ((mainColor_2.x < 0.5)) {
              tmpvar_8 = ((2.0 * mainColor_2.x) * blendColor_1.x);
            } else {
              tmpvar_8 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.x)
              ) * (1.0 - blendColor_1.x)));
            };
            highp float tmpvar_9;
            if ((mainColor_2.y < 0.5)) {
              tmpvar_9 = ((2.0 * mainColor_2.y) * blendColor_1.y);
            } else {
              tmpvar_9 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.y)
              ) * (1.0 - blendColor_1.y)));
            };
            highp float tmpvar_10;
            if ((mainColor_2.z < 0.5)) {
              tmpvar_10 = ((2.0 * mainColor_2.z) * blendColor_1.z);
            } else {
              tmpvar_10 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.z)
              ) * (1.0 - blendColor_1.z)));
            };
            highp vec3 tmpvar_11;
            tmpvar_11.x = tmpvar_8;
            tmpvar_11.y = tmpvar_9;
            tmpvar_11.z = tmpvar_10;
            tmpvar_7 = ((tmpvar_11 * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
            tmpvar_6 = bool(0);
          } else {
            if ((mode_5 == 6)) {
              tmpvar_7 = (((vec3(1.0, 1.0, 1.0) - 
                ((vec3(1.0, 1.0, 1.0) - mainColor_2.xyz) * (vec3(1.0, 1.0, 1.0) - blendColor_1.xyz))
              ) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
              tmpvar_6 = bool(0);
            } else {
              if ((mode_5 == 7)) {
                highp vec3 tmpvar_12;
                if ((((mainColor_2.x + mainColor_2.y) + mainColor_2.z) > ((blendColor_1.x + blendColor_1.y) + blendColor_1.z))) {
                  tmpvar_12 = mainColor_2.xyz;
                } else {
                  tmpvar_12 = blendColor_1.xyz;
                };
                tmpvar_7 = ((tmpvar_12 * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
                tmpvar_6 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_6) {
    tmpvar_7 = vec3(1.0, 0.0, 0.0);
    tmpvar_6 = bool(0);
  };
  highp vec4 tmpvar_13;
  tmpvar_13.xyz = tmpvar_7;
  tmpvar_13.w = blendColor_1.w;
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_StretchMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FlipVertical",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FlipHorizon",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TextureRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_WindowRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScaleXRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScaleYRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _StretchMode;
uniform highp float _FlipVertical;
uniform highp float _FlipHorizon;
uniform highp float _TextureRatio;
uniform highp float _WindowRatio;
uniform highp float _ScaleXRatio;
uniform highp float _ScaleYRatio;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  highp vec2 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = _glesVertex.xyz;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec2 tmpvar_5;
  tmpvar_5.x = tmpvar_3.x;
  tmpvar_5.y = -(tmpvar_3.y);
  tmpvar_2 = (((tmpvar_5 / tmpvar_3.w) + 1.0) / 2.0);
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_6 * tmpvar_3);
  tmpvar_1 = _glesMultiTexCoord0.xy;
  if ((_StretchMode == 5.0)) {
    if ((((_ScaleXRatio / _ScaleYRatio) * _WindowRatio) > _TextureRatio)) {
      tmpvar_1.y = (((
        (_glesMultiTexCoord0.y * _ScaleYRatio)
       / _ScaleXRatio) * _TextureRatio) / _WindowRatio);
      tmpvar_1.y = (tmpvar_1.y + ((1.0 - 
        (((_ScaleYRatio / _ScaleXRatio) * _TextureRatio) / _WindowRatio)
      ) / 2.0));
    } else {
      tmpvar_1.x = (((
        (_glesMultiTexCoord0.x * _ScaleXRatio)
       / _ScaleYRatio) * _WindowRatio) / _TextureRatio);
      tmpvar_1.x = (tmpvar_1.x + ((1.0 - 
        (((_ScaleXRatio / _ScaleYRatio) * _WindowRatio) / _TextureRatio)
      ) / 2.0));
    };
  };
  if (bool(_FlipHorizon)) {
    tmpvar_1.x = (1.0 - tmpvar_1.x);
  };
  if (bool(_FlipVertical)) {
    tmpvar_1.y = (1.0 - tmpvar_1.y);
  };
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_2;
  gl_Position = tmpvar_7;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _BlendTex;
uniform highp float _BlendMode;
uniform highp float _Alpha;
in highp vec2 xlv_TEXCOORD0;
in highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec4 blendColor_1;
  highp vec4 mainColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_GRAP, xlv_TEXCOORD1);
  mainColor_2 = tmpvar_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, xlv_TEXCOORD0);
  blendColor_1 = tmpvar_4;
  highp int mode_5;
  mode_5 = int((_BlendMode + 1.5));
  bool tmpvar_6;
  tmpvar_6 = bool(1);
  highp vec3 tmpvar_7;
  if ((mode_5 == 1)) {
    tmpvar_7 = (((
      (mainColor_2.xyz * (1.0 - blendColor_1.w))
     + 
      (blendColor_1.xyz * blendColor_1.w)
    ) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
    tmpvar_6 = bool(0);
  } else {
    if ((mode_5 == 2)) {
      tmpvar_7 = ((min (
        (mainColor_2.xyz + blendColor_1.xyz)
      , vec3(1.0, 1.0, 1.0)) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
      tmpvar_6 = bool(0);
    } else {
      if ((mode_5 == 3)) {
        tmpvar_7 = ((max (blendColor_1.xyz, mainColor_2.xyz) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
        tmpvar_6 = bool(0);
      } else {
        if ((mode_5 == 4)) {
          tmpvar_7 = (((mainColor_2.xyz * blendColor_1.xyz) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
          tmpvar_6 = bool(0);
        } else {
          if ((mode_5 == 5)) {
            highp float tmpvar_8;
            if ((mainColor_2.x < 0.5)) {
              tmpvar_8 = ((2.0 * mainColor_2.x) * blendColor_1.x);
            } else {
              tmpvar_8 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.x)
              ) * (1.0 - blendColor_1.x)));
            };
            highp float tmpvar_9;
            if ((mainColor_2.y < 0.5)) {
              tmpvar_9 = ((2.0 * mainColor_2.y) * blendColor_1.y);
            } else {
              tmpvar_9 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.y)
              ) * (1.0 - blendColor_1.y)));
            };
            highp float tmpvar_10;
            if ((mainColor_2.z < 0.5)) {
              tmpvar_10 = ((2.0 * mainColor_2.z) * blendColor_1.z);
            } else {
              tmpvar_10 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.z)
              ) * (1.0 - blendColor_1.z)));
            };
            highp vec3 tmpvar_11;
            tmpvar_11.x = tmpvar_8;
            tmpvar_11.y = tmpvar_9;
            tmpvar_11.z = tmpvar_10;
            tmpvar_7 = ((tmpvar_11 * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
            tmpvar_6 = bool(0);
          } else {
            if ((mode_5 == 6)) {
              tmpvar_7 = (((vec3(1.0, 1.0, 1.0) - 
                ((vec3(1.0, 1.0, 1.0) - mainColor_2.xyz) * (vec3(1.0, 1.0, 1.0) - blendColor_1.xyz))
              ) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
              tmpvar_6 = bool(0);
            } else {
              if ((mode_5 == 7)) {
                highp vec3 tmpvar_12;
                if ((((mainColor_2.x + mainColor_2.y) + mainColor_2.z) > ((blendColor_1.x + blendColor_1.y) + blendColor_1.z))) {
                  tmpvar_12 = mainColor_2.xyz;
                } else {
                  tmpvar_12 = blendColor_1.xyz;
                };
                tmpvar_7 = ((tmpvar_12 * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
                tmpvar_6 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_6) {
    tmpvar_7 = vec3(1.0, 0.0, 0.0);
    tmpvar_6 = bool(0);
  };
  highp vec4 tmpvar_13;
  tmpvar_13.xyz = tmpvar_7;
  tmpvar_13.w = blendColor_1.w;
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
}

end

