

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
BOLD = {"bold", FLOATRANGE, "0.0, 0.3, -0.3"},
OUTLINE = {"outline", FLOAT, "0.0"},
TEXTCOLOR = {"Text Color", COLOR, "0.0, 0.0, 0.0, 1.0"},
OUTLINECOLOR = {"Outline Color", COLOR, "0.0, 0.0, 0.0, 1.0"},

HALO = {"halo", FLOAT, "0.0"},

	}
	Attributes = 
	{
		HALO = "Keywords(HALO_ON,HALO_OFF)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "realtimesdf2d"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"HALO_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#define gl_Vertex _glesVertex
#define gl_Color _glesColor
#define gl_Normal _glesNormal
#define TANGENT _glesTangent
#define BINORMAL _glesBinormal
#define BLENDWEIGHT _glesBlendWeight
#define BLENDINDICES _glesBlendIndices
#define gl_MultiTexCoord0 _glesMultiTexCoord0
#define gl_MultiTexCoord1 _glesMultiTexCoord1
#define gl_MultiTexCoord2 _glesMultiTexCoord2
#define gl_MultiTexCoord3 _glesMultiTexCoord3
#define gl_MultiTexCoord4 _glesMultiTexCoord4
#define gl_MultiTexCoord5 _glesMultiTexCoord5
#define gl_MultiTexCoord6 _glesMultiTexCoord6
#define gl_MultiTexCoord7 _glesMultiTexCoord7
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 18
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
};
#line 12
struct appdata {
    highp vec2 vertex;
    highp vec2 uv;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform sampler2D TEXTURE_SHADOW_DEPTH;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
#line 25
uniform highp vec2 CAMERA_RESOLUTION;
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
#line 29
uniform sampler2D TEXTURE_GRAP;
#line 33
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 74
#line 80
#line 85
#line 90
#line 95
#line 100
#line 105
#line 112
#line 117
#line 132
#line 8
#line 18
#line 75
#line 33
#line 24
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float BOLD;
uniform highp float OUTLINE;
uniform highp vec4 TEXTCOLOR;
#line 28
uniform highp vec4 OUTLINECOLOR;
#line 41
#line 132
highp vec4 UniformNDC( in highp vec4 vertex ) {
    highp vec4 scale = vec4( 1.0, DEVICE_COORDINATE_Y_FLIP, 1.0, 1.0);
    #line 140
    highp vec4 newVertex = (scale * vertex);
    #line 149
    return newVertex;
}
#line 30
v2f vert( in appdata v ) {
    #line 32
    v2f o;
    highp vec2 in_WorldScale = (vec4( 1.0, 1.0, 1.0, 1.0) * LOCALWORLD_TRANSFORM).xy;
    highp vec2 in_WorldPosition = WORLD_POSITION.xy;
    highp vec4 pos = vec4( (((v.vertex * in_WorldScale) * CAMERA_RESOLUTION_INV) + (in_WorldPosition.xy * CAMERA_RESOLUTION_HALF_INV)), 0.0, 1.0);
    #line 36
    o.vertex = UniformNDC( pos);
    o.uv = v.uv.xy;
    return o;
}
out highp vec2 xlv_TEXCOORD0;
void main() {
    v2f xl_retval;
    appdata xlt_v;
    xlt_v.vertex = vec2(gl_Vertex);
    xlt_v.uv = vec2(gl_MultiTexCoord0);
    xl_retval = vert( xlt_v);
    xlv_TEXCOORD0 = vec2(xl_retval.uv);
    gl_Position = vec4(xl_retval.vertex);
}
]===],
		psShader = [===[#define gl_FragData _glesFragData
layout(location = 0) out mediump vec4 gl_FragData[1];float xll_dFdx_f(float f) {
  return dFdx(f);
}
vec2 xll_dFdx_vf2(vec2 v) {
  return dFdx(v);
}
vec3 xll_dFdx_vf3(vec3 v) {
  return dFdx(v);
}
vec4 xll_dFdx_vf4(vec4 v) {
  return dFdx(v);
}
mat2 xll_dFdx_mf2x2(mat2 m) {
  return mat2( dFdx(m[0]), dFdx(m[1]));
}
mat3 xll_dFdx_mf3x3(mat3 m) {
  return mat3( dFdx(m[0]), dFdx(m[1]), dFdx(m[2]));
}
mat4 xll_dFdx_mf4x4(mat4 m) {
  return mat4( dFdx(m[0]), dFdx(m[1]), dFdx(m[2]), dFdx(m[3]));
}
float xll_dFdy_f(float f) {
  return dFdy(f);
}
vec2 xll_dFdy_vf2(vec2 v) {
  return dFdy(v);
}
vec3 xll_dFdy_vf3(vec3 v) {
  return dFdy(v);
}
vec4 xll_dFdy_vf4(vec4 v) {
  return dFdy(v);
}
mat2 xll_dFdy_mf2x2(mat2 m) {
  return mat2( dFdy(m[0]), dFdy(m[1]));
}
mat3 xll_dFdy_mf3x3(mat3 m) {
  return mat3( dFdy(m[0]), dFdy(m[1]), dFdy(m[2]));
}
mat4 xll_dFdy_mf4x4(mat4 m) {
  return mat4( dFdy(m[0]), dFdy(m[1]), dFdy(m[2]), dFdy(m[3]));
}
#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 18
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
};
#line 12
struct appdata {
    highp vec2 vertex;
    highp vec2 uv;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform sampler2D TEXTURE_SHADOW_DEPTH;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
#line 25
uniform highp vec2 CAMERA_RESOLUTION;
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
#line 29
uniform sampler2D TEXTURE_GRAP;
#line 33
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 74
#line 80
#line 85
#line 90
#line 95
#line 100
#line 105
#line 112
#line 117
#line 132
#line 8
#line 18
#line 75
#line 33
#line 24
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float BOLD;
uniform highp float OUTLINE;
uniform highp vec4 TEXTCOLOR;
#line 28
uniform highp vec4 OUTLINECOLOR;
#line 41
#line 41
highp float outline( in highp float xlat_vardistance, in highp float smoothing, in highp float weight ) {
    highp float textAlpha = smoothstep( ((0.5 + weight) - smoothing), ((0.5 + weight) + smoothing), xlat_vardistance);
    highp float outlineAlpha = smoothstep( ((0.5 - weight) - smoothing), ((0.5 - weight) + smoothing), xlat_vardistance);
    #line 45
    return (outlineAlpha - textAlpha);
}
#line 48
highp vec4 frag( in v2f i ) {
    #line 50
    highp float xlat_vardistance = texture( TEXTURE_DIFFUSE, i.uv).w;
    highp float dx = (xll_dFdx_f(i.uv.x) * 2048.0);
    highp float dy = (xll_dFdy_f(i.uv.y) * 2048.0);
    highp float smoothing = (0.02 * sqrt(((dx * dx) + (dy * dy))));
    #line 62
    highp float textAlpha = outline( xlat_vardistance, smoothing, BOLD);
    highp float haloAlpha = (1.0 - abs(((xlat_vardistance * 2.0) - 1.0)));
    highp vec4 color = ((TEXTCOLOR * textAlpha) + (OUTLINECOLOR * clamp( (haloAlpha - textAlpha), 0.0, 1.0)));
    #line 67
    return color;
}
in highp vec2 xlv_TEXCOORD0;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"HALO_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#define gl_Vertex _glesVertex
#define gl_Color _glesColor
#define gl_Normal _glesNormal
#define TANGENT _glesTangent
#define BINORMAL _glesBinormal
#define BLENDWEIGHT _glesBlendWeight
#define BLENDINDICES _glesBlendIndices
#define gl_MultiTexCoord0 _glesMultiTexCoord0
#define gl_MultiTexCoord1 _glesMultiTexCoord1
#define gl_MultiTexCoord2 _glesMultiTexCoord2
#define gl_MultiTexCoord3 _glesMultiTexCoord3
#define gl_MultiTexCoord4 _glesMultiTexCoord4
#define gl_MultiTexCoord5 _glesMultiTexCoord5
#define gl_MultiTexCoord6 _glesMultiTexCoord6
#define gl_MultiTexCoord7 _glesMultiTexCoord7
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 18
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
};
#line 12
struct appdata {
    highp vec2 vertex;
    highp vec2 uv;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform sampler2D TEXTURE_SHADOW_DEPTH;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
#line 25
uniform highp vec2 CAMERA_RESOLUTION;
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
#line 29
uniform sampler2D TEXTURE_GRAP;
#line 33
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 74
#line 80
#line 85
#line 90
#line 95
#line 100
#line 105
#line 112
#line 117
#line 132
#line 8
#line 18
#line 75
#line 33
#line 24
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float BOLD;
uniform highp float OUTLINE;
uniform highp vec4 TEXTCOLOR;
#line 28
uniform highp vec4 OUTLINECOLOR;
#line 41
#line 132
highp vec4 UniformNDC( in highp vec4 vertex ) {
    highp vec4 scale = vec4( 1.0, DEVICE_COORDINATE_Y_FLIP, 1.0, 1.0);
    #line 140
    highp vec4 newVertex = (scale * vertex);
    #line 149
    return newVertex;
}
#line 30
v2f vert( in appdata v ) {
    #line 32
    v2f o;
    highp vec2 in_WorldScale = (vec4( 1.0, 1.0, 1.0, 1.0) * LOCALWORLD_TRANSFORM).xy;
    highp vec2 in_WorldPosition = WORLD_POSITION.xy;
    highp vec4 pos = vec4( (((v.vertex * in_WorldScale) * CAMERA_RESOLUTION_INV) + (in_WorldPosition.xy * CAMERA_RESOLUTION_HALF_INV)), 0.0, 1.0);
    #line 36
    o.vertex = UniformNDC( pos);
    o.uv = v.uv.xy;
    return o;
}
out highp vec2 xlv_TEXCOORD0;
void main() {
    v2f xl_retval;
    appdata xlt_v;
    xlt_v.vertex = vec2(gl_Vertex);
    xlt_v.uv = vec2(gl_MultiTexCoord0);
    xl_retval = vert( xlt_v);
    xlv_TEXCOORD0 = vec2(xl_retval.uv);
    gl_Position = vec4(xl_retval.vertex);
}
]===],
		psShader = [===[#define gl_FragData _glesFragData
layout(location = 0) out mediump vec4 gl_FragData[1];float xll_dFdx_f(float f) {
  return dFdx(f);
}
vec2 xll_dFdx_vf2(vec2 v) {
  return dFdx(v);
}
vec3 xll_dFdx_vf3(vec3 v) {
  return dFdx(v);
}
vec4 xll_dFdx_vf4(vec4 v) {
  return dFdx(v);
}
mat2 xll_dFdx_mf2x2(mat2 m) {
  return mat2( dFdx(m[0]), dFdx(m[1]));
}
mat3 xll_dFdx_mf3x3(mat3 m) {
  return mat3( dFdx(m[0]), dFdx(m[1]), dFdx(m[2]));
}
mat4 xll_dFdx_mf4x4(mat4 m) {
  return mat4( dFdx(m[0]), dFdx(m[1]), dFdx(m[2]), dFdx(m[3]));
}
float xll_dFdy_f(float f) {
  return dFdy(f);
}
vec2 xll_dFdy_vf2(vec2 v) {
  return dFdy(v);
}
vec3 xll_dFdy_vf3(vec3 v) {
  return dFdy(v);
}
vec4 xll_dFdy_vf4(vec4 v) {
  return dFdy(v);
}
mat2 xll_dFdy_mf2x2(mat2 m) {
  return mat2( dFdy(m[0]), dFdy(m[1]));
}
mat3 xll_dFdy_mf3x3(mat3 m) {
  return mat3( dFdy(m[0]), dFdy(m[1]), dFdy(m[2]));
}
mat4 xll_dFdy_mf4x4(mat4 m) {
  return mat4( dFdy(m[0]), dFdy(m[1]), dFdy(m[2]), dFdy(m[3]));
}
#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 18
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
};
#line 12
struct appdata {
    highp vec2 vertex;
    highp vec2 uv;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform sampler2D TEXTURE_SHADOW_DEPTH;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
#line 25
uniform highp vec2 CAMERA_RESOLUTION;
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
#line 29
uniform sampler2D TEXTURE_GRAP;
#line 33
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 74
#line 80
#line 85
#line 90
#line 95
#line 100
#line 105
#line 112
#line 117
#line 132
#line 8
#line 18
#line 75
#line 33
#line 24
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float BOLD;
uniform highp float OUTLINE;
uniform highp vec4 TEXTCOLOR;
#line 28
uniform highp vec4 OUTLINECOLOR;
#line 41
#line 48
highp vec4 frag( in v2f i ) {
    #line 50
    highp float xlat_vardistance = texture( TEXTURE_DIFFUSE, i.uv).w;
    highp float dx = (xll_dFdx_f(i.uv.x) * 2048.0);
    highp float dy = (xll_dFdy_f(i.uv.y) * 2048.0);
    highp float smoothing = (0.02 * sqrt(((dx * dx) + (dy * dy))));
    #line 56
    highp float bold = clamp( (0.5 - BOLD), smoothing, (1.0 - smoothing));
    highp float outline = clamp( (bold - OUTLINE), smoothing, (1.0 - smoothing));
    highp float textAlpha = smoothstep( (bold - smoothing), (bold + smoothing), xlat_vardistance);
    highp float outlineAlpha = smoothstep( (outline - smoothing), (outline + smoothing), xlat_vardistance);
    #line 60
    highp vec4 color = ((TEXTCOLOR * textAlpha) + (OUTLINECOLOR * (outlineAlpha - textAlpha)));
    #line 67
    return color;
}
in highp vec2 xlv_TEXCOORD0;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
]===],
	},
}

end
