#DEFPARAMS
_TexMask = {"TexMask", TEXTURE2D, "white" },
_TexForeground = {"TexForeground", TEXTURE2D, "white" },
_TexBackground = {"TexBackground", TEXTURE2D, "white" },
BlendOpacity = {"Blend_Opacity", FLOAT, "1.0"},
[Enum(True,1.0,False,2.0)]
isDebug = { "isDebug", FLOAT, "1.0" },
GAUSSIAN_STEP = { "Edge_Feathering", FLOAT, "0.0" },
Threshold = { "Threshold", VEC2, "0.0,1.0" },
[Enum(Normal,1.0,Add,2.0,Lighten,3.0,Multiply,4.0,Overlay,5.0,Screen,6.0)]
_BlendType = { "BlendType", FLOAT, "1.0" },
#END

#DEFTAG
ShaderName = "MagicSky_t"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"
#include "common.inc"
#include "blendmakeupfunc.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv     : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _TexMask;
sampler2D  _TexForeground;
sampler2D  _TexBackground;
float isDebug;
float BlendOpacity;
float GAUSSIAN_STEP;
float2 Threshold;
float _BlendType;


v2f vert(appdata v)
{
	v2f o;
	float4 pos = v.vertex * (1.0 / v.vertex.w);
	pos = mul(LOCALWORLD_TRANSFORM, pos);
	pos.w = 1.0;
	pos.x = pos.x + WORLD_POSITION.x;
	pos.y = pos.y + WORLD_POSITION.y;
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{	
    float2 maskuv =  i.uv;
    float step = max(0.0,GAUSSIAN_STEP);
    float2 gaussianCoord[5];
    gaussianCoord[0] = maskuv;
    gaussianCoord[1] = maskuv - float2(step, step);
    gaussianCoord[2] = maskuv + float2(step, step);
    gaussianCoord[3] = maskuv - float2(step, -step);
    gaussianCoord[4] = maskuv + float2(step, -step);
    float Weight[5];
    Weight[0] = 0.4;
    Weight[1] = Weight[2] = 0.2;
    Weight[3] = Weight[4] = 0.1;
    float maskcolor =  Weight[0] * tex2D(_TexMask, gaussianCoord[0]).a;
    maskcolor += Weight[1] * tex2D(_TexMask, gaussianCoord[1]).a;
    maskcolor += Weight[2] * tex2D(_TexMask, gaussianCoord[2]).a;
    maskcolor += Weight[3] * tex2D(_TexMask, gaussianCoord[3]).a;
    maskcolor += Weight[4] * tex2D(_TexMask, gaussianCoord[4]).a;

    maskcolor = smoothstep(max(0.0,Threshold.x), min(1.0,Threshold.y), maskcolor);
    float4 colorf  = tex2D(_TexForeground, i.uv).rgba;
    float4 colorb  = tex2D(_TexBackground, i.uv).rgba;
    if(isDebug==1.0)
    {    
        colorb.r = 1.0;
        colorb.g = 1.0;
        colorb.b = 1.0;
        colorb.a = 1.0;
		colorf.r = 0.0;
        colorf.g = 0.0;
        colorf.b = 0.0;
        colorf.a = 1.0;
    }

	float factor = BlendOpacity * maskcolor;

    colorb = colorb*factor;
    float3 colorf_notsky = colorf * (1-factor);
    float4 resultColor;
  	int blend_mode = int(_BlendType);
	if( blend_mode == 1 ){
		float3 blendRGB = colorf.rgb * (1.0 - factor) + colorb.rgb * factor;
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, 1);
 	 }else if( blend_mode == 2 ){
		float3 blendRGB = clamp(colorf.rgb + colorb.rgb, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, 1);
	}else if( blend_mode == 3 ){
		float3 blendRGB = float3(max(colorf.r,colorb.r),max(colorf.g,colorb.g),max(colorf.b,colorb.b));
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, 1);
	}else if( blend_mode == 4 ){
		float3 blendRGB = colorf.rgb * colorb.rgb + colorf_notsky;
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, 1);
	}else if( blend_mode == 5 ){
		float3 blendRGB = float3(blendOverlay(colorf.r,colorb.r),blendOverlay(colorf.g,colorb.g),blendOverlay(colorf.b,colorb.b)) + colorf_notsky;
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, 1);
	}else if( blend_mode == 6 ){
		float3 blendRGB = 1.0-((1.0-colorf.rgb)*(1.0-colorb.rgb));
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, 1);
	}

	return resultColor;
}
ENDCG
#END
