function DefineParams()
	Properties = 
	{
		
_TexMask = {"TexMask", TEXTURE2D, "white" },
_TexForeground = {"TexForeground", TEXTURE2D, "white" },
_TexBackground = {"TexBackground", TEXTURE2D, "white" },
BlendOpacity = {"Blend_Opacity", FLOAT, "1.0"},

isDebug = { "isDebug", FLOAT, "1.0" },
GAUSSIAN_STEP = { "Edge_Feathering", FLOAT, "0.0" },
Threshold = { "Threshold", VEC2, "0.0,1.0" },

_BlendType = { "BlendType", FLOAT, "1.0" },

	}
	Attributes = 
	{
		isDebug = "Enum(True,1.0,False,2.0)", 
		_BlendType = "Enum(Normal,1.0,Add,2.0,Lighten,3.0,Multiply,4.0,Overlay,5.0,Screen,6.0)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "MagicSky_t"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_TexMask",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexForeground",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexBackground",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "isDebug",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BlendOpacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "GAUSSIAN_STEP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Threshold",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp vec3 WORLD_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 pos_1;
  pos_1.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * (1.0/(_glesVertex.w)))).xyz;
  pos_1.w = 1.0;
  pos_1.xy = (pos_1.xy + WORLD_POSITION.xy);
  highp vec4 tmpvar_2;
  tmpvar_2.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_2.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_2 * pos_1);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _TexMask;
uniform sampler2D _TexForeground;
uniform sampler2D _TexBackground;
uniform highp float isDebug;
uniform highp float BlendOpacity;
uniform highp float GAUSSIAN_STEP;
uniform highp vec2 Threshold;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 resultColor_1;
  highp vec4 colorb_2;
  highp vec4 colorf_3;
  highp float maskcolor_4;
  highp vec2 gaussianCoord_1_5;
  highp vec2 gaussianCoord_2_6;
  highp vec2 gaussianCoord_3_7;
  highp vec2 gaussianCoord_4_8;
  highp float tmpvar_9;
  tmpvar_9 = max (0.0, GAUSSIAN_STEP);
  gaussianCoord_1_5 = (xlv_TEXCOORD0 - vec2(tmpvar_9));
  gaussianCoord_2_6 = (xlv_TEXCOORD0 + vec2(tmpvar_9));
  highp vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9;
  tmpvar_10.y = -(tmpvar_9);
  gaussianCoord_3_7 = (xlv_TEXCOORD0 - tmpvar_10);
  highp vec2 tmpvar_11;
  tmpvar_11.x = tmpvar_9;
  tmpvar_11.y = -(tmpvar_9);
  gaussianCoord_4_8 = (xlv_TEXCOORD0 + tmpvar_11);
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture (_TexMask, xlv_TEXCOORD0);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture (_TexMask, gaussianCoord_1_5);
  maskcolor_4 = ((0.4 * tmpvar_12.w) + (0.2 * tmpvar_13.w));
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_TexMask, gaussianCoord_2_6);
  maskcolor_4 = (maskcolor_4 + (0.2 * tmpvar_14.w));
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture (_TexMask, gaussianCoord_3_7);
  maskcolor_4 = (maskcolor_4 + (0.1 * tmpvar_15.w));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture (_TexMask, gaussianCoord_4_8);
  maskcolor_4 = (maskcolor_4 + (0.1 * tmpvar_16.w));
  highp float tmpvar_17;
  tmpvar_17 = max (0.0, Threshold.x);
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = clamp (((maskcolor_4 - tmpvar_17) / (
    min (1.0, Threshold.y)
   - tmpvar_17)), 0.0, 1.0);
  tmpvar_18 = (tmpvar_19 * (tmpvar_19 * (3.0 - 
    (2.0 * tmpvar_19)
  )));
  maskcolor_4 = tmpvar_18;
  lowp vec4 tmpvar_20;
  tmpvar_20 = texture (_TexForeground, xlv_TEXCOORD0);
  colorf_3 = tmpvar_20;
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (_TexBackground, xlv_TEXCOORD0);
  colorb_2 = tmpvar_21;
  if ((isDebug == 1.0)) {
    colorb_2.x = 1.0;
    colorb_2.y = 1.0;
    colorb_2.z = 1.0;
    colorb_2.w = 1.0;
    colorf_3.x = 0.0;
    colorf_3.y = 0.0;
    colorf_3.z = 0.0;
    colorf_3.w = 1.0;
  };
  highp float tmpvar_22;
  tmpvar_22 = (BlendOpacity * tmpvar_18);
  colorb_2 = (colorb_2 * tmpvar_22);
  highp vec3 tmpvar_23;
  tmpvar_23 = (colorf_3 * (1.0 - tmpvar_22)).xyz;
  highp int tmpvar_24;
  tmpvar_24 = int(_BlendType);
  if ((tmpvar_24 == 1)) {
    highp vec4 tmpvar_25;
    tmpvar_25.w = 1.0;
    tmpvar_25.xyz = ((colorf_3.xyz * (1.0 - tmpvar_22)) + (colorb_2.xyz * tmpvar_22));
    resultColor_1 = tmpvar_25;
  } else {
    if ((tmpvar_24 == 2)) {
      highp vec4 tmpvar_26;
      tmpvar_26.w = 1.0;
      tmpvar_26.xyz = clamp ((colorf_3.xyz + colorb_2.xyz), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
      resultColor_1 = tmpvar_26;
    } else {
      if ((tmpvar_24 == 3)) {
        highp vec4 tmpvar_27;
        tmpvar_27.w = 1.0;
        tmpvar_27.xyz = max (colorf_3.xyz, colorb_2.xyz);
        resultColor_1 = tmpvar_27;
      } else {
        if ((tmpvar_24 == 4)) {
          highp vec4 tmpvar_28;
          tmpvar_28.w = 1.0;
          tmpvar_28.xyz = ((colorf_3.xyz * colorb_2.xyz) + tmpvar_23);
          resultColor_1 = tmpvar_28;
        } else {
          if ((tmpvar_24 == 5)) {
            highp float tmpvar_29;
            if ((colorb_2.x < 0.5)) {
              tmpvar_29 = ((2.0 * colorf_3.x) * colorb_2.x);
            } else {
              tmpvar_29 = (1.0 - ((2.0 * 
                (1.0 - colorf_3.x)
              ) * (1.0 - colorb_2.x)));
            };
            highp float tmpvar_30;
            if ((colorb_2.y < 0.5)) {
              tmpvar_30 = ((2.0 * colorf_3.y) * colorb_2.y);
            } else {
              tmpvar_30 = (1.0 - ((2.0 * 
                (1.0 - colorf_3.y)
              ) * (1.0 - colorb_2.y)));
            };
            highp float tmpvar_31;
            if ((colorb_2.z < 0.5)) {
              tmpvar_31 = ((2.0 * colorf_3.z) * colorb_2.z);
            } else {
              tmpvar_31 = (1.0 - ((2.0 * 
                (1.0 - colorf_3.z)
              ) * (1.0 - colorb_2.z)));
            };
            highp vec3 tmpvar_32;
            tmpvar_32.x = tmpvar_29;
            tmpvar_32.y = tmpvar_30;
            tmpvar_32.z = tmpvar_31;
            highp vec4 tmpvar_33;
            tmpvar_33.w = 1.0;
            tmpvar_33.xyz = (tmpvar_32 + tmpvar_23);
            resultColor_1 = tmpvar_33;
          } else {
            if ((tmpvar_24 == 6)) {
              highp vec4 tmpvar_34;
              tmpvar_34.w = 1.0;
              tmpvar_34.xyz = (1.0 - ((1.0 - colorf_3.xyz) * (1.0 - colorb_2.xyz)));
              resultColor_1 = tmpvar_34;
            };
          };
        };
      };
    };
  };
  _glesFragData[0] = resultColor_1;
}

]===],
	},
}

end
