
#DEFPARAMS
#END

#DEFTAG
ShaderName = "LowPoly"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float2 position : POSITION;
	float3 color : COLOR0;
};

struct v2f
{
	float4 position : SV_POSITION;
	float3 color : COLOR0;
};

v2f vert(appdata v)
{
	v2f o;
	o.position = UniformNDC(float4(v.position.x, v.position.y, 0.0, 1.0));
	o.color = v.color;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	return float4(i.color, 1.0);
}
ENDCG
#END
