

#DEFPARAMS
_Color = { "Color ", VEC4, "1.0,1.0,1.0,1.0" },
_MaskPos = {"Mask Pos", VEC2, "300.0,708.0"},
_MaskScale = {"Mask Scale", FLOAT, "1.01"},
_MaskSize = {"Mask Size", VEC2, "167.0,122.0"},
#END

#DEFTAG
ShaderName = "LipLine"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv0 : TEXCOORD0;
};

struct v2f
{
	float2 uv0 : TEXCOORD0; 
	float4 vertex : SV_POSITION;
};

float4 _Color;
float2 _MaskPos;
float2 _MaskSize;
float _MaskScale;


v2f vert(appdata v)
{
	v2f o;
    float4 facetexpara = float4(1.0/(_MaskSize.x*_MaskScale),1.0/(_MaskSize.y*_MaskScale),_MaskPos.x/(-_MaskSize.x*_MaskScale),_MaskPos.y/(-_MaskSize.y*_MaskScale));
    o.uv0 = v.uv0*facetexpara.xy+facetexpara.zw;
	o.vertex = UniformNDC(float4(2.0*o.uv0.x-1.0,1.0-2.0*o.uv0.y,0.0,1.0));
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
    return _Color;

}
ENDCG
#END
