
function DefineParams()
	Properties = 
	{
		
_AvatarTex = {"Avator Color", TEXTURE2D, "avatartex"},
_FrameTex = { "Frame Color", TEXTURE2D, "frameColor"},
_MaskTex = {"Mask Color", TEXTURE2D, "maskcolor"},

_BlendState = {"belnd state", FLOAT, "0.0"},

_BlendSrc = {"blendsrc", FLOAT, "1.0"},

_BlendDst = {"blenddst", FLOAT, "1.0"},

	}
	Attributes = 
	{
		_BlendState = "Enum(ON,1,OFF,0)", 
		_BlendSrc = "Enum(BlendFunc)", 
		_BlendDst = "Enum(BlendFunc)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "FullScreenQuad"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = {"%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_AvatarTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FrameTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.w = 1.0;
  tmpvar_1.xyz = _glesVertex.xyz;
  highp vec4 tmpvar_2;
  tmpvar_2.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_2.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_2 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_1)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _AvatarTex;
uniform sampler2D _FrameTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 frameColor_1;
  highp vec4 maskColor_2;
  highp vec4 mainColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_AvatarTex, xlv_TEXCOORD0);
  mainColor_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (_MaskTex, xlv_TEXCOORD0);
  maskColor_2 = tmpvar_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture (_FrameTex, xlv_TEXCOORD0);
  frameColor_1 = tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = ((mainColor_3.xyz * maskColor_2.w) + (frameColor_1.xyz * frameColor_1.w));
  tmpvar_7.w = (maskColor_2.w + frameColor_1.w);
  _glesFragData[0] = tmpvar_7;
}

]===],
	},
}

end
