

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "editorui"
RenderQueue = "Background"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float2 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float4 color : COLOR0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
	float4 color : COLOR0;
};

sampler2D TEXTURE_DIFFUSE;

v2f vert(appdata v)
{
	v2f o;
	float4 pos;
	pos.z = 0.0;
	pos.w = 1.0;
	pos.xy = v.vertex;
	o.vertex = mul(pos, CAMERA_PROJECTION);
	o.vertex = UniformNDC(o.vertex);
	o.uv = v.uv;
	o.color = v.color;
	return o;
}

float4 frag(v2f i) : SV_Target
{
	float4 col = i.color*tex2D(TEXTURE_DIFFUSE, i.uv);
    return col;
}
ENDCG
#END
