
#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "maintex" },
_BlendTex = { "Blend Texture", TEXTURE2D, "blendtex"},
_BlendMode = {"Blend Mode", FLOAT, "1.0"},
_BlendOpacity = {"Blend Opacity", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "BlendMode"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "blendfunc.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
sampler2D _BlendTex;
float     _BlendMode;
float     _BlendOpacity;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{

  float4 mainColor = tex2D(_MainTex,i.uv);
  float4 blendColor = tex2D(_BlendTex,i.uv);
  //float3 mainRGB = float3(mainColor.r,mainColor.g,mainColor.b);
  //float3 blendRGB = float3(blendColor.r,blendColor.g,blendColor.b);
  
  float3 blendR = float3(1.0,0.0,0.0);
  int iBlendMode = int(_BlendMode + 0.5);
  if (_BlendOpacity >= 1.0){
    blendR = blend(iBlendMode,mainColor,blendColor);
  }else {
    blendR = blend( iBlendMode, mainColor, blendColor, _BlendOpacity );
  }
  //return blendColor;
  return float4(blendR.r,blendR.g,blendR.b,blendColor.a);
}
ENDCG
#END
