

#DEFPARAMS
DILATE_STEP = { "DILATE_STEP", VEC2, "5.0,5.0" },
INPUTSIZE = { "INPUTSIZE", VEC2, "500.0,500.0" },
#END

#DEFTAG
ShaderName = "Dilate_Circle_X"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 INPUTSIZE;
float2 DILATE_STEP;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;


	return o;
}

float4 frag(v2f i) : SV_Target
{
	float4 color = tex2D(TEXTURE_DIFFUSE, i.uv);
	float2 step = DILATE_STEP / (INPUTSIZE);
	float color_r = color.a;
	float halfWidth = 1;//max(max(step.x, step.y) / 2, 1);
	float2 onestep = step / halfWidth;

	int j = 4;
	//for (; j<=halfWidth; j++)
	{
		float2 step =  j*onestep;
		float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color_r = max(tex2D(TEXTURE_DIFFUSE, uv1).a, color_r);
		color_r = max(tex2D(TEXTURE_DIFFUSE, uv2).a, color_r);
	}
	float color_g = color_r;
	j = 12;
	//for (; j<=12*halfWidth; j++)
	{
		float2 step =  j*onestep;
		float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color_g = max(tex2D(TEXTURE_DIFFUSE, uv1).a, color_g);
		color_g = max(tex2D(TEXTURE_DIFFUSE, uv2).a, color_g);
	}
	// float2 step =  onestep;
	// float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
	// float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
	// float color_g = max(tex2D(TEXTURE_DIFFUSE, uv1).a, color_r);
	// color_g = max(tex2D(TEXTURE_DIFFUSE, uv2).a, color_g);
	float color_b = color_g;
	j = 16;
	//for (; j<=16*halfWidth; j++)
	{
		float2 step =  j*onestep;
		float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color_b = max(tex2D(TEXTURE_DIFFUSE, uv1).a, color_b);
		color_b = max(tex2D(TEXTURE_DIFFUSE, uv2).a, color_b);
	}
	// step =  2*onestep;
	// uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
	// uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
	// float color_b = max(tex2D(TEXTURE_DIFFUSE, uv1).a, color_g);
	// color_b = max(tex2D(TEXTURE_DIFFUSE, uv2).a, color_b);

	// step =  3*onestep;
	// uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
	// uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
	// color_b = max(tex2D(TEXTURE_DIFFUSE, uv1).a, color_b);
	// color_b = max(tex2D(TEXTURE_DIFFUSE, uv2).a, color_b);
	float color_a = color_b;
	 j = 19;
	//for (; j<=19*halfWidth; j++)
	{
		float2 step =  j*onestep;
		float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color_a = max(tex2D(TEXTURE_DIFFUSE, uv1).a, color_a);
		color_a = max(tex2D(TEXTURE_DIFFUSE, uv2).a, color_a);
	}
	// step =  4*onestep;
	// uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
	// uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
	// float color_a = max(tex2D(TEXTURE_DIFFUSE, uv1).a, color_b);
	// color_a = max(tex2D(TEXTURE_DIFFUSE, uv2).a, color_a);

	return float4(color_r, color_g, color_b, color_a);
}
ENDCG
#END
