#DEFPARAMS
#END

#DEFTAG
ShaderName = "contourextract"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE_IN;
sampler2D TEXTURE_DIFFUSE_OUT;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float value1 = tex2D(TEXTURE_DIFFUSE_IN, i.uv).a;
	float value2 = tex2D(TEXTURE_DIFFUSE_OUT, i.uv).a;
	float resValue = 0;
	if(value1 < 0.2) 	
    {
		resValue = value2*(1.0 - value1);
		resValue *= 20.0;
		resValue = min(1.0 , resValue);
		//resValue *= (1.0 - value1);
	}
	else if(value2 > value1 )
    {
		resValue = value2 - value1;
		resValue = resValue * 20 * (1.0 - value1);
		resValue = min(1.0 , resValue);
		//resValue *= (1.0 - value1);
	}
	//resValue = clamp(resValue * 20, 0.0, 1.0);
	return float4(resValue, resValue, resValue, resValue);
}
ENDCG
#END
