local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local faceseg = require "videodecet.faceseg"
local videocapture = require "videocapture"
local venuscore = require "venuscore"
local videodefined = require"videodecet.defined"
local vc = require "venuscore"
local cnnseg = require "videodecet.cnnseg"
local maxfacecount = 3;
local keypointcount = 106;
local bitop = require "bit"

  

local videodecet = {}
setmetatable(videodecet, basedetect);

function videodecet:GetPixelFacekeypointArray()
  local keypointarray = mathfunction.vector2array();
  local count = faceseg:GetCount(videodefined.detectType.Face,0);
  for i=1, count do
    local landmark = faceseg:GetData(
            videodefined.detectType.Face, i,
            videodefined.MLDataType.FACE_LANDMARK
    );
    for j=1, #landmark, 2 do
      keypointarray:PushBack(mathfunction.vector2(landmark[j], landmark[j+1]));
    end
  end
  return keypointarray;
end

function videodecet:GetVideoFrame() --得到texturestream 和安卓端统一接口
  if not self.entity then
    self.entity= apolloengine.TextureEntity();
    self.entity:PushMetadata(apolloengine.TextureReferenceMetadata("DEVICE_CAPTURE"));
    self.entity:CreateResource();
  end
  return self.entity:GetSourceStream();
end



return videodecet;
