
local TransNode = require "apolloutility.apollonode.trasnnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local util = require "superme3d.model.util"
local apolloDefine = require "apolloutility.defiend"
local SkeletonNode = TransNode:extend();
local radiusscale = math.pi / 180;



function SkeletonNode:new()
  SkeletonNode.super.new(self);
  self.skeleton = self.node:CreateComponent(apolloengine.Node.CT_SKELETON);
  
  self.animations = nil;
  self.children = {2,3,0,5,6,0,8,9,0,11,12,0,14,0}
  
  self.bodypair = {{1,2},{3,4},{1,3},{2,4}}
 
end

function SkeletonNode:SetBodyBoneNames(rootname,bonenames)
  self.rootbone = rootname;
  self.bodybones = bonenames;
end

function SkeletonNode:SetPoseEstimateBoneNames(rootname,spinebone,bonenames)
  self.rootbone = rootname;
  self.spinebone = spinebone;
  self.bonenamemap = bonenames;
  
  self.bodybones = {
      self.bonenamemap[1],
      self.bonenamemap[4],
      self.bonenamemap[7],
      self.bonenamemap[10]
    }
end

function SkeletonNode:SetBoneTwist(bonenames)
  self.bonetwist = bonenames;
end

function SkeletonNode:SetSkeleton(skeletonPath,skeletonType)
  self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(skeletonType,0,skeletonPath));
end

function SkeletonNode:AddAnimation(animationPath, animationType, frameCount)
  self.skeleton:PushMetadata(apolloengine.KeyFrameFileMetaData(animationType,1,animationPath));
  --self.skeleton:SetAnimationInterval(0, frameCount - 1);
end

function SkeletonNode:CreateResource(skeletonPath,skeletonType,defaultAnimation,animationList)
  self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(skeletonType,0,skeletonPath));
  local animationListCnt = #animationList;
  for i = 1, animationListCnt, 1 do
    local animationInfo = animationList[i];
    self.skeleton:PushMetadata(apolloengine.KeyFrameFileMetaData(skeletonType,1,animationInfo[1]));
    self.skeleton:SetAnimationInterval(0,animationInfo[2] - 1);
  end
  self.skeleton:CreateResource();
  if animationListCnt > 0 then
    self.skeleton:SetDefaultAnimation(animationList[1][1]); --设置默认动画
  end
end

function SkeletonNode:GetCurrentPose()
  local currentpose = {}
  for i=1,14,1 do
    currentpose[i] = self:GetTPos(i);
  end
  local mid = {}
  mid[1] = (currentpose[7][1] + currentpose[10][1])/2
  mid[2] = (currentpose[7][2] + currentpose[10][2])/2
  mid[3] = (currentpose[7][3] + currentpose[10][3])/2
  for i=1,14,1 do
    currentpose[i][1] = currentpose[i][1] -  mid[1]
    currentpose[i][2] = currentpose[i][2] -  mid[2];
    currentpose[i][3] = currentpose[i][3] -  mid[3];
  end
  return currentpose;
end

function SkeletonNode:BindPose()
  self.Tdir = {}
  self.Trot = {}
  self.Tpos = {}
  self.TBody = {}
  
  for i=1,14,1 do
    self.Trot[i] = self:GetTRot(i);
    self.Tdir[i] = self:GetTDir(i);
    self.Tpos[i] = self:GetTPos(i)
  end
  
  self.TBody = self:GetBodyPose();
  self.TBodyRot = self:GetBodyRot();
  
  self.RootInitRot = self.trans:GetWorldRotation();
  
  self.BodyStartRotMat = util:ConstractRotationFromVector(self.TBody[2],self.TBody[3]);
  self.BodyStartRotMat:Transpose();
  LOG(self.TBody[2]);
  LOG(self.TBody[3]);
  LOG("AT INIT GO");
  
  local rootjoint = self:GetJoint(self.rootbone);
  local comp = rootjoint.trans;
  self.rootpos = comp:GetWorldPosition();
end

function SkeletonNode:AddRigidBodys()
  --local gravity = mathfunction.vector3(0.0,0.0,0.0)
  --apolloengine.IPhysicSystem:SetGravity(gravity)
  --local bonesName = {}
  local bonesName = {self.bonenamemap[13], self.bonenamemap[2], self.bonenamemap[5], 
  self.bonenamemap[11], self.bonenamemap[8], self.spinebone[1]}
  local config = {{0.1, 0.1, 1},{0.05, 0.38, 1},{0.05, 0.38, 1},
   {0.05, 0.5, 1}, {0.05, 0.5, 1}, {0.14, 0.35, 1}}
  local offCenter = {
      mathfunction.vector3(0.08,0.0,0.0),
      mathfunction.vector3(0.2,0.0,0.0),
      mathfunction.vector3(0.2,0.0,0.0),
      mathfunction.vector3(0.28,0.0,0.0),
      mathfunction.vector3(0.28,0.0,0.0),
      mathfunction.vector3(-0.02,0.0,0.0)
  };
  local ret = {}
  self.shape = {}
  self.rigid = {}
  self.rigidId2Name = {}
  self.rigidPreLpos = {}
  self.rigidPreLrot = {}
  self.rigidLpos = {}
  self.rigidLrot = {}
  for i=1, #bonesName do
    local node = self:GetJoint(bonesName[i])
    local rigid = node:CreateComponent(apolloengine.Node.CT_SHAPECOLLIDER)
    rigid:SetCollisionShape(apolloengine.ShapeColliderComponent.CST_CAPSULE);
    local shape = rigid:GetCollisionShape();
    shape.CapsuleHeight = config[i][2];
    shape.CapsuleRadius = config[i][1];
    shape.CapsuleAxis = config[i][3];
    shape:SetLocalCenter(offCenter[i]);
    self.shape[bonesName[i]] = shape;
    rigid:EnableCollision()
    
    --rigid:EnableDebug()
    self.rigid[bonesName[i]] = rigid
    self.rigidId2Name[rigid:GetObjectID()] = bonesName[i]
  end
end

function SkeletonNode:AddColliders(cdrcfg)
  local ret = {}
  self.shapeNodes = {}
  self.collisionshapenames = {}
  self.shape = {}
  self.rigid = {}
  self.rigidId2Name = {}
  self.rigidPreLpos = {}
  self.rigidPreLrot = {}
  self.rigidLpos = {}
  self.rigidLrot = {}
  for i=1, #cdrcfg do
    LOG(cdrcfg[1][1]);
    local node = self:GetJoint(cdrcfg[i][1])
    self.collisionshapenames[i] = cdrcfg[i][1];

    local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
    local shapenode = scene:CreateNode(apolloengine.Node.CT_NODE);
   
    local shapetrans = shapenode:CreateComponent(apolloengine.Node.CT_TRANSFORM);
    if #cdrcfg[i]>7 then
      local rotation = mathfunction.Quaternion();
      rotation:RotateXYZ(cdrcfg[i][8],cdrcfg[i][9],cdrcfg[i][10])
      shapetrans:SetLocalRotation(rotation);
    end
    node.node:AttachNode(shapenode);
    self.shapeNodes[cdrcfg[i][1]] = shapenode

    local rigid = shapenode:CreateComponent(apolloengine.Node.CT_SHAPECOLLIDER)
    rigid:SetCollisionShape(apolloengine.ShapeColliderComponent.CST_CAPSULE);
    local shape = rigid:GetCollisionShape();
    
    shape.CapsuleHeight = cdrcfg[i][3];
    shape.CapsuleRadius = cdrcfg[i][2];
    shape.CapsuleAxis = cdrcfg[i][4];
    shape:SetLocalCenter(mathfunction.vector3(cdrcfg[i][5],cdrcfg[i][6],cdrcfg[i][7]));
    self.shape[cdrcfg[i][1]] = shape;
    rigid:EnableCollision()
    
    --rigid:EnableDebug()
    self.rigid[cdrcfg[i][1]] = rigid
    self.rigidId2Name[rigid:GetObjectID()] =cdrcfg[i][1]
  end
end

function SkeletonNode:GetNameByID(id)
  for key, value in pairs(self.rigidId2Name) do
    if key == id then
   
      return value;
    end
  end
end

function SkeletonNode:HandleCollider(colliders)

  local bonesName = {"Bip001 Head", "Bip001 R Forearm", "Bip001 L Forearm", 
  "Bip001 L Calf", "Bip001 R Calf", "Bip001 Spine1"}
  
  for i=1, #bonesName do
    local joint = self:GetJoint(bonesName[i])
    local lp = joint.trans:GetLocalPosition()
    local lr = joint.trans:GetLocalRotation()
    
    if self.rigidLpos[bonesName[i]] == nil then
      self.rigidLpos[bonesName[i]] = lp
    end
    
    if self.rigidLrot[bonesName[i]] == nil then
      self.rigidLrot[bonesName[i]] = lr
    end
    
    self.rigidPreLpos[bonesName[i]] = self.rigidLpos[bonesName[i]]
    self.rigidPreLrot[bonesName[i]] = self.rigidLrot[bonesName[i]]
    self.rigidLpos[bonesName[i]] = lp
    self.rigidLrot[bonesName[i]] = lr
  end

   local colliderComponents = {}
   for i=1, #colliders do
     local objA = colliders[i]["objAId"]
     local objB = colliders[i]["objBId"]
     local pointList = colliders[i]["collisionPointList"]
     
     for key, value in pairs(self.rigidId2Name) do
         if key == objA or key == objB then
          colliderComponents[value] = self.rigid[value]
         end
     end
   end

   local test = self:GetJoint("Bip001 L Hand").trans
   local w1 = test:GetWorldPosition()
   local lerpV = -0.01
   --if #self.rigidPreWpos > 0 and #self.rigidWpos > 0 then
    for key, value in pairs(colliderComponents) do
      local joint = self:GetJoint(key)
      local localPos = self.rigidPreLpos[key] * (1.0 - lerpV) + self.rigidLpos[key] * lerpV
      local localRot = mathfunction.Mathutility:Slerp(self.rigidPreLrot[key], self.rigidLrot[key], lerpV)
      joint.trans:SetLocalPosition(localPos)
      joint.trans:SetLocalRotation(localRot)
      
      self.rigidLpos[key] = localPos
      self.rigidLrot[key] = localRot
    end
   --end
   local w2 = test:GetWorldPosition()
   local w3 = nil
end

function SkeletonNode:GetBodyRot()
  local bonenames = {self.rootbone,self.bonenamemap[13]}
  for i=1,#self.spinebone do
    bonenames[2 + i] = self.spinebone[i]
  end
  local ret = {}
  for i=1,#bonenames do
    local transcom = self:GetJoint(bonenames[i]).trans;
    rot = transcom:GetWorldRotation();
    ret[bonenames[i]] = rot;
  end
  return ret;
end

function SkeletonNode:GetBodyPose()
  local bonepose = {}
  for i =1, #self.bodypair do
    local first =  self.bodybones[self.bodypair[i][1]]
    local second = self.bodybones[self.bodypair[i][2]]
    
    local fristjoint = self:GetJoint(first);
    local firstworldpose = fristjoint.trans:GetWorldPosition();
   
    local secondjoint = self:GetJoint(second);
    local secondworldpose = secondjoint.trans:GetWorldPosition();
    bonepose[i] = secondworldpose - firstworldpose;
    bonepose[i]:NormalizeSelf();
  end

  bonepose[3] = (bonepose[3]+bonepose[4]/2);
  bonepose[3]:NormalizeSelf();

  bonepose[4] = nil;
  return bonepose;
end

function SkeletonNode:GetTPos(boneidx)

  local name = self.bonenamemap[boneidx];

  if name==nil then
    return nil
  end
  
  local joint = self:GetJoint(name);
  local comp = joint.trans;
  local pos = comp:GetWorldPosition();
  return {pos:x(),pos:y(),pos:z()};
end


function SkeletonNode:GetTRot(boneidx)
  if self.children[boneidx] == 0 then
    return nil
  end

  local name = self.bonenamemap[boneidx];

  if name==nil then
    return nil
  end
  local joint = self:GetJoint(name);
  local comp = joint.trans;

  return comp:GetWorldRotation();
end

function SkeletonNode:GetTDir(boneidx)
  if self.children[boneidx] == 0 then
    return nil
  end
  local name1 = self.bonenamemap[boneidx];
  local name2 = self.bonenamemap[self.children[boneidx]];
  if name1==nil or name2==nil then
    return nil
  end
  local joint1 = self:GetJoint(name1);
  local comp1 = joint1.trans;
  
  local joint2 = self:GetJoint(name2);
  local comp2 = joint2.trans;
  
  local pos1 = comp1:GetWorldPosition();
  local pos2 = comp2:GetWorldPosition();
  
  local dir =  pos2 - pos1;
  dir:NormalizeSelf();

  return dir;
end

function SkeletonNode:GetTargets()
  local target = {}
  for i =1 , #self.children do
    local joint = self:GetJoint(self.bonenamemap[i]);
    local trans = joint.trans;
    --target[self.bonenamemap[i] ] = trans:GetWorldPosition();
    target[self.bonenamemap[i] ] = trans;
  end

  return target,self.RootRot;
end

function SkeletonNode:UpdateSkeleton(pos3d, cameraT, cameraR)
  
  tempppair = {{1,4},{7,10},{1,7},{4,10}}
  tempdir = {}
  for i=1,#tempppair do
      local fpos = mathfunction.vector3(pos3d[tempppair[i][1]][1],pos3d[tempppair[i][1]][2],pos3d[tempppair[i][1]][3]);
      local spos = mathfunction.vector3(pos3d[tempppair[i][2]][1],pos3d[tempppair[i][2]][2],pos3d[tempppair[i][2]][3]);
      local dir = (spos - fpos);
      dir:NormalizeSelf();
      table.insert(tempdir,dir);
  end
  tempdir[3] = (tempdir[3]+tempdir[4])/2
  tempdir[3]:NormalizeSelf();
  
  
  local currentBodyRotMat = util:ConstractRotationFromVector(tempdir[2],tempdir[3]);
  
  local rotationmat =  self.BodyStartRotMat * currentBodyRotMat ;
  
  local rootrot = rotationmat:ToQuaternion();
  
 
  
  self.RootRot = rootrot;

  local rotation1 = mathfunction.Quaternion();
  rotation1:AxisToAxis(self.TBody[1]*rotationmat,tempdir[1]);
 
  --local rotation2 = mathfunction.Quaternion();
  --rotation2:AxisToAxis(self.TBody[2]*rotationmat,tempdir[2]);
  
  local trans2 = self:GetJoint(self.rootbone).trans;
  trans2:SetWorldRotation(self.TBodyRot[self.rootbone]*rootrot);  
  
  if cameraT ~= nil then
    trans2:SetWorldPosition( ( cameraT )/1000 );
  end  


  for i = 1, #self.spinebone do
    local spine_rot = mathfunction.Mathutility:Slerp(mathfunction.Quaternion(),rotation1,i/#self.spinebone);
    local transS1 = self:GetJoint(self.spinebone[i]).trans;
    local rotS1 = self.TBodyRot[self.spinebone[i] ];
    transS1:SetWorldRotation(rotS1*rootrot*spine_rot);
  end


  
  local target = {}
  for i =1 , #self.children do
        
    local joint = self:GetJoint(self.bonenamemap[i]);
    local trans = joint.trans;

    if self.children[i] ~= 0  then
      local mypos = mathfunction.vector3(pos3d[i][1],pos3d[i][2],pos3d[i][3]);
      local chidx = self.children[i]
      local chpos = mathfunction.vector3(pos3d[chidx][1],pos3d[chidx][2],pos3d[chidx][3]);
      
      local dir =  chpos - mypos;
      dir:NormalizeSelf();
      local rotation = mathfunction.Quaternion();
      rotation:AxisToAxis(self.Tdir[i]*rotationmat,dir);
      if joint ~= nil then
        local rotated = self.Trot[i]*rootrot*rotation
        trans:SetWorldRotation( rotated );
      end
    end
    target[self.bonenamemap[i] ] = trans:GetWorldPosition();
  end
  

  return target,rootrot;
end

--[[
参数说明:
rotUpper:大臂世界旋转
rotFore：小臂世界旋转
upperarm：大臂方向向量
forearm：小臂方向向量
bendAxisUpper：初始大臂外侧朝向 bendAxisUpper * rotUpper = upperarm X forearm
bendAxisFore：初始小臂外侧朝向  bendAxisFore * rotFore = upperarm X forearm
isLeft: (bool)是否为左臂
]]--
function SkeletonNode:EstimateArmRot(rotUpper,rotFore,upperarm,forearm,bendAxisUpper,bendAxisFore,isLeft)
  
  local resRotUpper = rotUpper;
  local resRotFore = rotFore;
  
  upperarm : NormalizeSelf();
  forearm : NormalizeSelf();
  local cosine = math.abs(upperarm : Dot(forearm));

  if cosine < 0.996 then
    local elbowRotAxisW0 = upperarm:Cross(forearm); 
    if isLeft then
      elbowRotAxisW0 = mathfunction.vector3(0.0,0.0,0.0) - elbowRotAxisW0;
    end
    local initRotAxis1 = elbowRotAxisW0 * rotUpper:Inverse();
    local rotation0 = mathfunction.Quaternion();
    rotation0:AxisToAxis(bendAxisUpper,initRotAxis1);
    resRotUpper = rotation0 * resRotUpper;

    local initRotAxis2 = elbowRotAxisW0 * rotFore : Inverse();
    local rotation1 = mathfunction.Quaternion();
    rotation1:AxisToAxis(bendAxisFore,initRotAxis2);
    resRotFore = rotation1 * resRotFore;

  end
  
  return resRotUpper,resRotFore;
end

function SkeletonNode:CorrectArmsTwist()
  
  if self.leftElbowAxis0 == nil then
  local upper,fore,hand;
  upper = mathfunction.vector3(self.Tpos[4][1],self.Tpos[4][2],self.Tpos[4][3]);
  fore = mathfunction.vector3(self.Tpos[5][1],self.Tpos[5][2],self.Tpos[5][3]);
  hand = mathfunction.vector3(self.Tpos[6][1],self.Tpos[6][2],self.Tpos[6][3]);
  local upperarmL = fore - upper;
  local forearmL = hand - fore;
  self.leftElbowAxis = forearmL :Cross(upperarmL);
  self.leftElbowAxis1 = self.leftElbowAxis * self.Trot[5] : Inverse();
  self.leftElbowAxis0 = self.leftElbowAxis * self.Trot[4] : Inverse();
  self.leftElbowAxis0 : NormalizeSelf()
  self.leftElbowAxis1 : NormalizeSelf()
  --LOG("leftElbowAxis0 :"..self.leftElbowAxis0:x()..","..self.leftElbowAxis0:y()..","..self.leftElbowAxis0:z());
  --LOG("leftElbowAxis1 :"..self.leftElbowAxis1:x()..","..self.leftElbowAxis1:y()..","..self.leftElbowAxis1:z());
   
  upper = mathfunction.vector3(self.Tpos[1][1],self.Tpos[1][2],self.Tpos[1][3]);
  fore = mathfunction.vector3(self.Tpos[2][1],self.Tpos[2][2],self.Tpos[2][3]);
  hand = mathfunction.vector3(self.Tpos[3][1],self.Tpos[3][2],self.Tpos[3][3]);
  local upperarmR =  fore - upper;
  local forearmR = hand - fore;
  self.rightElbowAxis = upperarmR :Cross(forearmR);
  self.rightElbowAxis1 = self.rightElbowAxis * self.Trot[2] : Inverse();
  self.rightElbowAxis0 = self.rightElbowAxis * self.Trot[1] : Inverse();
  self.rightElbowAxis0 : NormalizeSelf()
  self.rightElbowAxis1 : NormalizeSelf()
  --LOG("rightElbowAxis0 :"..self.rightElbowAxis0:x()..","..self.rightElbowAxis0:y()..","..self.rightElbowAxis0:z());
  --LOG("rightElbowAxis1 :"..self.rightElbowAxis1:x()..","..self.rightElbowAxis1:y()..","..self.rightElbowAxis1:z());
  end

  --left UpperArm/ForeArm/Hand
  local transUpperL = self:GetJoint(self.bonenamemap[4]).trans;
  local rotUpperL = transUpperL : GetWorldRotation();
  local targetUpperL = transUpperL : GetWorldPosition();
  
  local transForeL = self:GetJoint(self.bonenamemap[5]).trans;
  local rotForeL = transForeL:GetLocalRotation() * rotUpperL;
  local targetForeL = transForeL : GetWorldPosition();

  local transHandL = self:GetJoint(self.bonenamemap[6]).trans;
  local targetHandL = transHandL : GetWorldPosition();
  
  local upperarmL = targetForeL - targetUpperL;
  local forearmL = targetHandL - targetForeL;
  
  local resrotUpperL,resrotForeL = self:EstimateArmRot(rotUpperL,rotForeL,upperarmL,forearmL,
    self.leftElbowAxis0,self.leftElbowAxis1,true);
  transUpperL : SetWorldRotation( resrotUpperL  );
  transForeL : SetWorldRotation( resrotForeL );

  --right UpperArm/ForeArm/Hand
  local transUpperR = self:GetJoint(self.bonenamemap[1]).trans;
  local rotUpperR = transUpperR : GetWorldRotation();
  local targetUpperR = transUpperR : GetWorldPosition();
  
  local transForeR = self:GetJoint(self.bonenamemap[2]).trans;
  local rotForeR = transForeR:GetLocalRotation() * rotUpperR;
  local targetForeR = transForeR : GetWorldPosition();

  local transHandR = self:GetJoint(self.bonenamemap[3]).trans;
  local targetHandR = transHandR : GetWorldPosition();
  
  local upperarmR = targetForeR - targetUpperR;
  local forearmR = targetHandR - targetForeR;
  
  local resrotUpperR,resrotForeR = self:EstimateArmRot(rotUpperR,rotForeR,upperarmR,forearmR,
    self.rightElbowAxis0,self.rightElbowAxis1,false);
  transUpperR : SetWorldRotation( resrotUpperR  );
  transForeR : SetWorldRotation( resrotForeR ); 

end

function SkeletonNode:UpdateTwist()
  for i=1,#self.bonenamemap do
    if self.bonetwist[i]~= "" and self.bonetwist[i]~= nil then
      local joint = self:GetJoint(self.bonenamemap[i]);
      local jointtwist = self:GetJoint(self.bonetwist[i]);
      local wr = joint.trans:GetWorldRotation();
      jointtwist.trans:SetWorldRotation(wr);
    end
  end
end

function SkeletonNode:UpdateTargetsAndKinematics(targets,rootrot,cameraT,cameraR,scores,errmax,itrmax)
  local trans = self:GetJoint(self.rootbone).trans;
  trans:SetWorldRotation(self.TBodyRot[self.rootbone]*rootrot);
  trans:SetWorldPosition( ( cameraT )/1000 );
  
  if not self.hasTargetSet then
    for i=1,#self.bonenamemap do
      local bone = self:GetJoint(self.bonenamemap[i]).trans;
      self.ik : SetTarget(bone:GetStaticID(),targets[self.bonenamemap[i]]);
    end
    self.hasTargetSet = true;
  end
  --for i=1,#self.bonenamemap do
  --  if scores == nil or scores[i] > 4 then
  --    self:SetTarget(self.bonenamemap[i], targets[self.bonenamemap[i]]);     
  --  end
  --end
  
  if errmax ==nil then errmax = 0.2 end
  if itrmax ==nil then itrmax = 5 end
  
  self:UpdateKinematics(errmax, itrmax);
  
  return;
end

function SkeletonNode:SetLoop(loop)
    self.skeleton:Loop(loop);
end

function SkeletonNode:Reset(frame)
if frame then
    self.skeleton:Reset(frame)
else
    self.skeleton:Reset()
end  
end

function SkeletonNode:Play()
    --self.skeleton:Play()
end

function SkeletonNode:Stop()
    --self.skeleton:Stop()
end


function SkeletonNode:GetFrameCount()
    return self.framecount;
end

function SkeletonNode:AttachNodeToJoint(jointName,node)
    self.skeleton:AttachNodeToJoint(jointName,node);
end

local function _TransNodeCast(rawnode)
  local transnode = {}
  transnode = TransNode:cast(transnode);
  transnode.node = rawnode;
  transnode.position = mathfunction.vector3();
  transnode.trans = rawnode:GetComponent(apolloengine.Node.CT_TRANSFORM);
  return transnode;
end

function SkeletonNode:GetJoint(name)
    if self.namejointmap==nil then
      self.namejointmap = {};
    end
    if self.namejointmap[name]~=nil then
      return self.namejointmap[name];
    end
    local rawnode = self.skeleton:GetHostNode():GetNodeByName(name);
    if rawnode then
      local node = _TransNodeCast(rawnode);
     self.namejointmap[name]=node;
      return node;
    end
    ERROR("unkown joint with name '"..name.."'");
    return nil;      
end

function SkeletonNode:GetJointNames()
    return self.skeleton:GetJointNames();
end

function SkeletonNode:GetBoneRoots()
  return self.skeleton:GetBoneRoots();
end

function SkeletonNode:CreateIKComponent(isJacobian, root)
  if not self.ik then
    local joint = self:GetJoint(root);
    --self.ik = apolloengine.KinematicsComponent();
    self.ik = joint:CreateComponent(apolloengine.Node.CT_KINEMATICS);
    if isJacobian then
      --self.ik:CreateJacobianSolver();
      self.ik.SolverType = apolloengine.InverseKinematicsComponent.SolverJacobian;
    else
      --self.ik:CreateFabrikSolver();
      self.ik.SolverType = apolloengine.InverseKinematicsComponent.SolverFabrik;
    end
  end  
end

function SkeletonNode:CreateJoint(joint, lx, ux, ly, uy, lz, uz)
  self:CreateJointV3(
    joint,
    mathfunction.vector3(lx * radiusscale, ly * radiusscale, lz * radiusscale),
    mathfunction.vector3(ux * radiusscale, uy * radiusscale, uz * radiusscale));
end

function SkeletonNode:CreateJointV3(name, rotlimlow, rotlimup)
  local node = self:GetJoint(name);
  self.ik:CreateJoint(node.trans);
  local joint = self.ik : GetJoint(node.trans:GetStaticID())
  joint.Constraint.UpperLimit = rotlimup;
  joint.Constraint.LowerLimit = rotlimlow;
  --self.ik:CreateJoint(name);
  --self.ik:DegreeConstraint(name, rotlimlow, rotlimup)
end

function SkeletonNode:CreateJointFabrik( config )
  local num = #config;
  if num < 1 then
    return
  end
      
  local name = config[1];
  
  local rawnode = self.skeleton:GetHostNode():GetNodeByName(name);
  local trans = rawnode:GetComponent(apolloengine.Node.CT_TRANSFORM);
  
  self.ik:CreateJoint(trans);
  
  if num == 1 then
    return
  end
  
  local joint = self.ik : GetJoint(trans:GetStaticID());
  
  local type = config[2];
  
  if type == "Angle" then
    self.ik:SetConstraint(trans:GetStaticID(), apolloengine.KinematicsJointConstraint.IKCST_ANGLE);
    local constraint = joint.Constraint;
    constraint.Axis = mathfunction.vector3(config[3], config[4], config[5]);
    constraint.Swing = config[6];
    constraint.Twist = config[7];
    --self.ik:AngleConstraint(name,mathfunction.vector3(config[3], config[4], config[5]),config[6], config[7]);
  end
  
  if type == "Hinge" then
    self.ik:SetConstraint(trans:GetStaticID(), apolloengine.KinematicsJointConstraint.IKCST_HINGE);
    local constraint = joint.Constraint;
    constraint.Axis = mathfunction.vector3(config[3], config[4], config[5]);
    constraint.Range = mathfunction.vector2(config[6],config[7]);
    --self.ik:HingeConstraint(name,mathfunction.vector3(config[3], config[4], config[5]),config[6], config[7]);
  end
  
  if type == "Polyg" then
    self.ik:SetConstraint(trans:GetStaticID(), apolloengine.KinematicsJointConstraint.IKCST_POLYG);
    local constraint = joint.Constraint;
    constraint.Axis = mathfunction.vector3(config[3], config[4], config[5]);
    
    local axis = mathfunction.vector3(config[3], config[4], config[5]);
    local points = mathfunction.vector3array();
    for i=1, #config[6]/3 do
      points:PushBack(mathfunction.vector3(config[6][i*3-2],config[6][i*3-1],config[6][i*3]));
    end
    local twist = config[7];
    --self.ik:PolygConstraint(name, axis, points, twist);
    constraint.Axis = axis;
    constraint.Twist = twist;
    constraint.ControlPoints = points;
  end
  --[[
  self.ik:AngleConstraint("Bip001 L UpperArm",mathfunction.vector3(-1.0, 0.0, 0.0),135.0, 180.0);
  self.ik:AngleConstraint("Bip001 Head",mathfunction.vector3(0.0, 1.0, 0.0),45.0, 0.0);
  
  self.ik:HingeConstraint("Bip001 L Forearm",mathfunction.vector3(0.0, 1.0, 0.0),-150, 0);
  self.ik:HingeConstraint("Bip001 R Forearm",mathfunction.vector3(0.0, 1.0, 0.0),0, 150);
  
  self.ik:HingeConstraint("Bip001 L Calf",mathfunction.vector3(1.0, 0.0, 0.0),0, 150);
  self.ik:HingeConstraint("Bip001 R Calf",mathfunction.vector3(1.0, 0.0, 0.0),0, 150);
  ]]--
end

function SkeletonNode:SetTarget(name, t)
  return self.ik:SetTarget(name, t);
end

--function SkeletonNode:CreateEffector(name)
--  return self.ik:CreateEffector(name);
--end

function SkeletonNode:SetRootJoint(name)
  local joint = self:GetJoint(name);
  local comp = joint.trans;
  self.rootpos = comp:GetWorldPosition();
  --return self.ik:SetRootJoint(name);
end

function SkeletonNode:LinkJoints(j1, j2)
  local joint1 = self:GetJoint(j1).trans;
  local joint2 = self:GetJoint(j2).trans;
  local joint2Key = joint2 : GetStaticID();
  self.ik:SetParent(joint2Key, joint1);
  --return self.ik:LinkJoints(j1, j2);
end

function SkeletonNode:BuildKinematics()
  self.ik:BuildKinematics();
end

function SkeletonNode:UpdateKinematics(threshold,maxstep)
  return self.ik:UpdateKinematics(threshold,maxstep);
end

return SkeletonNode;