
local _DEBUG = true;
require "venusdebug"
require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local super3d = require "superme3d.superme3d"
local environment = require "superme3d.environment"
local pbrlighting = require "apolloutility.pbrlighting"
local videodecet = require "videodecet"
local textureloader = require "apolloutility.asynctexture.textureloader"
local emptyimage = require "apolloutility.emptyimage"

local renderqueue = require "apolloutility.renderqueue"

local vnectdection = require "avatar.posedection.vnectdection_file"
local cameracorrection = require "avatar.skeletonfit.camera_correction"
local skeletonfit = require "avatar.skeletonfit.skeletonfit_pos"
local lowpassfilter = require "avatar.filter.lowpassfilter"
local debugske = require "avatar.posedection.debugske"

local mlaa = require "superme3d.model.mlaa"

local laplacian = require "avatar.retarget.laplacianretarget"
local emafilter = require "avatar.filter.exp_moving_avg"

local collisionhandler = require "avatar.retarget.collisionhandler"

local main = {}
g_callbackhandle = main;

--以下为固定接口
function main:RegisterCallback(func)
  local index = self.callbackindex;
  self.callbackindex = self.callbackindex + 1;
  self.servicecallbacks[index] = func;
  return self._Agent, index;
end

function main:CallbackFunction(index, ...)
  _COROUTINES_ON();
  local func = self.servicecallbacks[index];
  if func then
    local res = func(...);
  end
  _COROUTINES_OFF();
  return res;
end

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;
  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;
  
  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("FPS "..fps);
  end
  return def;
end


function main:CreateCameras(near, far, pos, lookat, up) 

  self.maincamera = apollonode.CameraNode();--新建摄像机
	self.maincamera:CreatePerspectiveProjection(near, far);--设置摄像机
	self.maincamera:LookAt(pos, lookat, up);
  self.maincamera:Activate();--激活主摄像机
  
  
  self.envConfig = environment(self.maincamera,10);
  self.envConfig:AmbientLight(mathfunction.vector3(0.08,0.08,0.08));
  local lightDirection = mathfunction.vector3(1,-0.8,-1);
  lightDirection:NormalizeSelf();
  self.envConfig:DirectionLight(lightDirection,mathfunction.vector3(1,1,1));
  --self.envConfig:DirectionLight(mathfunction.vector3(0,-0.4,-1),mathfunction.vector3(1,1,1));
end

--加载换脸配置表
function main:FacecuteLoadResource(path)
  _COROUTINES_ON();
  local res = super3d:LoadResource(path);
  self.isloaded = res;
  _COROUTINES_OFF();
  return self.isloaded;
end


local bonelength = {102, 53, 90, 57, 43, 90, 57, 43, 25, 100, 75, 25, 100, 75, 0}

local bonepair = {
   -- 15 is additional root joint
  {15, 13},--head
  {13, 14},
  
  {15, 1},--rarm
  {1, 2}, 
  {2, 3},
  
  {15, 4},--larm
  {4, 5}, 
  {5, 6},
  
  {15, 7},--rleg
  {7, 8}, 
  {8, 9},
  
  {15, 10},--lleg
  {10, 11}, 
  {11, 12},
  
  {15, 15} --root
}

function main:Initialize()
  _COROUTINES_ON();
  self.servicecallbacks = {}
  self.callbackindex = 1;
  setmetatable(self.servicecallbacks, {__mode = "v"}) --弱引用 
  
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.testCounter = 1;

  self.cumtime = 0;
  self.fps = 0;
  self:CreateCameras(1, 7,
    mathfunction.vector3( 0,1,2.5),
		mathfunction.vector3(0,1,0),
		mathfunction.vector3(0,1,0));
  
  self.rotation = mathfunction.Quaternion();

  
  super3d:Initialize(self.maincamera);
  
  textureloader:Initialize();
  emptyimage:Initialize();
  renderqueue:Initialize(self.maincamera);
  
  local video_path = "test:test_images/03.3/"
  videodecet:Initialize(video_path, "%04d.jpg", "point.txt", false);
  vnectdection:Initialize("test:superme3d/vnectmodel/graph.mnn", video_path);
  
  lowpassfilter:Initialize(0,1.3,0,0.5);
  emafilter:Initialize({7, 4, 2, 1, 0.5});
  cameracorrection:Initialize(46, 12, 23); --from heatmap size
  skeletonfit:Initialize(bonelength, bonepair, cameracorrection.viewmat);
  debugske:Initialize();
  super3d:LoadBackground("test:3dsuperme/Skybox/Superme3D.json");
  super3d:LoadResource("test:3dsuperme/Hair/Superme3D.json");
  super3d:LoadResource("test:3dsuperme/Head/Superme3D.json");
  super3d:LoadResource("test:3dsuperme/Tops/Superme3D.json");
  super3d:LoadResource("test:3dsuperme/Pants/Superme3D.json");
  super3d:LoadResource("test:3dsuperme/Legs/Superme3D.json");   --腿和袜子是一个模型（腿就是袜子，袜子就是腿）
  super3d:LoadResource("test:3dsuperme/Shoes/Superme3D.json");
  local needIK = false;
  

  super3d:LoadSkeleton(needIK,"test:3dsuperme/skeleton");
  

  --super3d:LoadPhysics("docs:../../testcase/documents/3dsuperme/physics/physicsconfig.json");
  
  
  local nodemgr = super3d:GetNodeMgr();
  self.skenode = nil;
  
  if nodemgr.skeletonNodePose then
    self.skenode = nodemgr.skeletonNodePose
  else
    self.skenode = nodemgr.skeletonNode
  end
  
  collisionhandler:Init(self.skenode);
  
  --加一个地板测试阴影
  --[[
  self.plane = apollonode.ModelNode();
  self.plane:CreateResource("docs:../../testcase/documents/Shadow/ground","comm:documents/material/simple.material");
  self.plane:SetLocalScale(mathfunction.vector3(3.0,1.0,2.0));
  self.plane:SetLocalPosition(mathfunction.vector3(0.0,-0.15,-1.0));
  ]]
  --mlaa:Initialize(self.maincamera);

  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "SyncUpdate");--添加同步更新
  apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");
  LOG("initialize done");
  _COROUTINES_OFF();
  return true;
end


function main:SyncUpdate()
  _COROUTINES_ON();
  
  local def = self:Timespan();
  videodecet:Update(def);
  self.testCounter = self.testCounter + 1;

  local currentrgb,_ = videodecet:GetCurrentFrame();
  local pos2d,pos3d,scores = vnectdection:Estimate(currentrgb);
 
  --pos2d,pos3d = emafilter:Smooth(scores, pos2d, pos3d);
  table.insert(pos3d, {0, 0, 0})
  table.insert(pos2d, {(pos2d[7][1]+pos2d[10][1])/2, (pos2d[7][2]+pos2d[10][2])/2})
  
  local cameraT,cameraR = cameracorrection:Correct(pos2d,pos3d)
  cameraT = cameraT + mathfunction.vector3(0,1000,1000);
  
  pos3d[15] = nil
  for i=1,14 do
    pos3d[i][1] = pos3d[i][1]/1000
    pos3d[i][2] = -pos3d[i][2]/1000
    pos3d[i][3] = -pos3d[i][3]/1000
  end
 
  super3d:UpdatePose(def,pos3d,cameraT, cameraR);  
  
  

  
  local J,collision = collisionhandler:CaculatePD();
  LOG(J);
 
  super3d:Update(def);

  local modelpose =   self.skenode:GetCurrentPose();
  debugske:Draw(modelpose)
       
  laplacian:SetupInitPose(pos3d,modelpose);

  laplacian:SetupCollisionMat(J,collision,2000)
  
  local static_anchors = {7, 10}
  laplacian:SetupStaticAnchor(static_anchors,4000);
  
  laplacian:SetupFrameLinkData(200);

  
  local links = {  {2,{4,7,10,13,14}},
                   {3,{4,7,10,13,14,6}},
                   {5,{1,7,10,13,14}},
                   {6,{1,7,10,13,14,3}},
                   {8,{1,4,10,11,12}},
                   {9,{1,4,10,11,12}},
                   {11,{1,4,7,8,9}},
                   {12,{1,4,7,8,9}},
                   {13,{1,4,7,10}},
                   {14,{1,4,7,10}},
                   {1,{4,7,10}},
                   {4,{1,7,10}},
                   };
  
  laplacian:CaculateWeightFromLink(links,20)
  
  local parent = {1, 2, 4 ,5, 7, 8, 10, 11 };
  local children = {2, 3, 5 ,6, 8, 9, 11, 12};
  local bonepair = {{1,2},{2,3},{4,5},{5,6},{7,8},{8,9},{10,11},{11,12}}
  local boneLengthSquare = {};
  
  for i =1,#parent do
    local xs = 0
    local ys = 0
    local zs = 0
    if parent[i]~= 0 then
      xs = modelpose[parent[i] ][1] - modelpose[children[i] ][1];
      ys = modelpose[parent[i] ][2] - modelpose[children[i] ][2];
      zs = modelpose[parent[i] ][3] - modelpose[children[i] ][3];
    else
      xs = 0 - modelpose[children[i] ][1];
      ys = 0 - modelpose[children[i] ][2];
      zs = 0 - modelpose[children[i] ][3];
    end
    local lengthsqure =  xs*xs+ys*ys+zs*zs;
    boneLengthSquare[i] = lengthsqure ^ (0.5);
  end
  
  laplacian:SetupBoneData(bonepair,boneLengthSquare,2000);
  local newpose3d = laplacian:Minimize();

  local pose3dlua = {};
  for i=1,14 do
    pose3dlua[i] = {};
    pose3dlua[i][1] = newpose3d[i][1];
    pose3dlua[i][2] = newpose3d[i][2];
    pose3dlua[i][3] = newpose3d[i][3];
  end
  
  pose3dlua[15] = {cameraT:x(),cameraT:y(),cameraT:z()};
  pose3dlua = lowpassfilter:Filter(pose3dlua);
  cameraT = mathfunction.vector3(pose3dlua[15][1],pose3dlua[15][2],pose3dlua[15][3]);
  pose3dlua[15] = nil;  
 
  super3d:UpdatePose(def,pose3dlua,cameraT, cameraR); 
 
  
  
  super3d:UpdateIK(cameraT, cameraR);
  
  

  _COROUTINES_OFF();
 
end


function main:Ontime()
  _COROUTINES_ON();
  self.gestureanimation:Update();
  
 
  
  _COROUTINES_OFF();
end


function main:OnTouch(touchinfo)
	_COROUTINES_ON();
	
	local vec2 = touchinfo:GetTouchPoint(1);
  
	local tt = touchinfo:GetTouchType(1);
	if apolloengine.TouchInfo.TT_PRESS == tt  then
		self.point = vec2;
    
	elseif apolloengine.TouchInfo.TT_MOVE == tt then
		local rd = vec2 - self.point;
		self.point = vec2;
		local x = rd:x();
		local pos = self.maincamera:GetPosition();
		local dir = self.maincamera:GetForward();
		local rot = mathfunction.Mathutility:RotateAxis(
		mathfunction.vector3(0,1,0),
		-x);
		pos = pos * rot;
		dir = dir * rot;
		self.maincamera:SetPosition(pos);
		self.maincamera:SetForward(dir);
	end

	_COROUTINES_OFF();
  
end

function main:Abort()
  apolloengine.Framework:RemoveAsynchronousUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end


return main;