local venusjson = require "venusjson"
local libmasquerade = require "libmasque"

local portraitAnim = {}

function portraitAnim:Initialize(channel_map)
  self.channel_map = channel_map;
  self.portrait_anim = libmasquerade.PortraitAnimation();
  self.last_frame = 0
end

function portraitAnim:LoadAnim(anim_path)
  if self.portrait_anim:Load(anim_path) == false then
    return false;
  end
  self.last_frame = self.portrait_anim:GetFrameNumber();
  self.channel_file_number = self.portrait_anim:GetChannelNumber();
  self.channel_file_map = {};
  for i=1, self.channel_file_number do
    local name = self.portrait_anim:GetChannelName(i);
    local index = self.channel_map[name];
    if index == nil then
      LOG("Warning: failed to find channel "..name.." in blendshape model, animation file: "..anim_path);
    else
      self.channel_file_map[index] = i;
    end
  end
  
  return true
end

function portraitAnim:Play(time)
  local frame_data = self.portrait_anim:GetChannelValues(time);
  local val = {}
  for k, v in pairs(self.channel_file_map) do
    val[k] = frame_data[v];
  end
  return val
end

function portraitAnim:Clear()
  self.channel_map = nil
  self.portrait_anim = nil
  self.channel_file_map = nil
end


return portraitAnim
