--@author      : Jin Shiyu
--@date        : 2020-11-03
--@description : lua script to deal with the image by face beauty filter
--@version     : 1.0

local Object       = require "classic"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local apollonode   = require "apolloutility.apollonode"
local venuscore    = require "venuscore"
local defined      = require "apolloutility.defiend"
--[[
    deal width the current video frame by face beauty filter.

]]
local FaceBeautyRender = Object:extend();

function FaceBeautyRender:new(material_path, vetex_stream, index_stream, sequence)

    self.node = apollonode.RenderNode();

    self.node:SetSequence(sequence);
    self.node:CreateResource(venuscore.IFileSystem:PathAssembly(material_path),
                             apolloengine.RenderComponent.RM_TRIANGLES,
                             vetex_stream,
                             index_stream);
    self.node:SetShow(false);
    self.is_show = false;
    LOG("[FaceBeautyRender] create success ")
end

function FaceBeautyRender:SetSequence(sequence)
    if self.node ~= nil then
        self.node:SetSequence(sequence);
        --self.node:SetShow(false);
    end
end

function FaceBeautyRender:SetShow(is_show)
    if self.node ~= nil then
        self.node:SetShow(is_show);
    end
    self.is_show = is_show;
end

function FaceBeautyRender:Update(vetex_stream)
    if self.node == nil then
        return;
    end

    if vetex_stream ~= nil then
        self.node.render:ChangeVertexBuffer(vetex_stream);
        self:SetShow(true);
    else
        self:SetShow(false);
    end
end

function FaceBeautyRender:SetParameter(key, value)
    if key == nil or value == nil then
        LOG("[FaceBeautyRender] SetParameter nil "..key);
        return;
    end

    if self.node ~= nil then
        self.node:SetParameter(key, value);
    end
end

function FaceBeautyRender:SetDrawCount(render_num)
    if self.node ~= nil then
        self.node:SetDrawCount(render_num);
    end
end

function FaceBeautyRender:Clear()
    if self.node ~= nil then
        self.node:Destroy();
    end
end

return FaceBeautyRender;
