local vc = require "venuscore"
local ae = require "apolloengine"
local mf = require "mathfunction"
local cv = require "computervisionfunction"
local venuscore = require "venuscore"
local FeedFaceStickerBehavior = vc.VenusBehavior:extend("FeedFaceStickerBehavior"); 

local dtSize = cv.GPUSegmentComponent.mlRectSize
local dtPosition = cv.GPUSegmentComponent.mlRectPosition
local dtPivot = cv.GPUSegmentComponent.mlRectPivot
local dtRoll = cv.GPUSegmentComponent.mlRectRoll;
local dtHeadPos = cv.SegmentComponent.mlHeadSegPosition;

local BLEND_NORMAL = 0
local BLEND_MULTIPLY = 1
local BLEND_SCREEN = 2
local BLEND_HUE = 3
local BLEND_SATURATION = 4
local BLEND_LUMINOSITY = 5
local BLEND_COLOR = 6
local BLEND_BLEND = 7

local BLEND_EXCLUSION = 8
local BLEND_HARDLIGHT = 9
local BLEND_VIVIDLIGHT = 10
local BLEND_OVERLAY = 11
local BLEND_COLORBURN = 12
local BLEND_COLORDODGE = 13
local BLEND_SOFTLIGHT = 14
local BLEND_HARDMIX = 15
local BLEND_PINLIGHT = 16
local BLEND_LINEARLIGHT = 17
local BLEND_DIFF = 18
local BLEND_LINEARBURN = 19
local BLEND_SUB = 20
local BLEND_LUT = 21

local BlendModeValues = 
{ -- {src, dst, shader里的blendmode, lut路径}
    {ae.MaterialEntity.BL_SRC_ALPHA, ae.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_NORMAL, "comm:documents/make_up/lut/white.png"},   --Normal
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LUT, "comm:documents/make_up/lut/darken.png"},           --Dark
    {ae.MaterialEntity.BL_DST_COLOR, ae.MaterialEntity.BL_ZERO, BLEND_MULTIPLY, "comm:documents/make_up/lut/white.png"},  --Multiply            
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_COLORBURN, "comm:documents/make_up/lut/white.png"},    --Color_burn      

    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LINEARBURN, "comm:documents/make_up/lut/white.png"},  --linear burn                    
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LUT, "comm:documents/make_up/lut/dark.png"}, --dark                          
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LUT, "comm:documents/make_up/lut/lighten.png"},     --Lighten                        
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ONE_MINUS_SRC_COLOR, BLEND_SCREEN, "comm:documents/make_up/lut/white.png"},             --Screen

    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_COLORDODGE, "comm:documents/make_up/lut/white.png"},  --Color_dodge                      
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LUT, "comm:documents/make_up/lut/lineardodge.png"},  --Linear_dodge               
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LUT, "comm:documents/make_up/lut/light.png"},  --Light                
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_OVERLAY, "comm:documents/make_up/lut/white.png"},  --Overlay

    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_SOFTLIGHT, "comm:documents/make_up/lut/white.png"}, --Soft_light                                                        
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_HARDLIGHT, "comm:documents/make_up/lut/white.png"}, --Hard_light                        
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_VIVIDLIGHT, "comm:documents/make_up/lut/white.png"},  --Vivid_light                               
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LINEARLIGHT, "comm:documents/make_up/lut/white.png"},  --Linear_light 

    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_PINLIGHT, "comm:documents/make_up/lut/white.png"},  --Pin_light                            
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_HARDMIX, "comm:documents/make_up/lut/white.png"},  --Hard_mix                               
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_DIFF, "comm:documents/make_up/lut/white.png"},  --Difference                              
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_EXCLUSION, "comm:documents/make_up/lut/white.png"},  --Exclusion 

    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_SUB, "comm:documents/make_up/lut/white.png"},  --Subtract                            
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LUT, "comm:documents/make_up/lut/div.png"},  --Divide 

    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_HUE, "comm:documents/make_up/lut/white.png"},  --Hue                               
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_SATURATION, "comm:documents/make_up/lut/white.png"},  --Saturation
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_COLOR, "comm:documents/make_up/lut/white.png"},  --Color                             
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_LUMINOSITY, "comm:documents/make_up/lut/white.png"},  --Luminosity
    {ae.MaterialEntity.BL_ONE, ae.MaterialEntity.BL_ZERO, BLEND_BLEND, "comm:documents/make_up/lut/white.png"},  --Blend                               
};

local rectInfo1 = mf.vector2(0,0);
local rectInfo2 = mf.vector2(0,0);
local mainSize = mf.vector2(0,0);
local mainPivot = mf.vector2(0,0);
local opacity = mf.vector1(0);
local blendSrc = mf.vector1(0);
local blendDst = mf.vector1(0);
local blendMode = mf.vector1(0);
local use3DAnchor = mf.vector1(0);
local scaleFace = mf.vector2(0,0);
local horizontalFlip = mf.vector1(0);
local verticalFlip = mf.vector1(0);
function FeedFaceStickerBehavior:new()
  self.rollMode = 0;
  self.FixedHorizontal = 0;
  self.sticker = nil;
  self.Opacity = 1;
  self.BlendMode = 0.0;
  self.Hflip = false;
  self.Vflip = false;
  self.FaceID = 1;
  self.HeadID = 0;
  self.feathering = 0.0;
  self.MaskContourVal = 0;
  --self.TexturePath = "DEVICE_CAPTURE";
  --self.Texture = nil;
  self.RenderOrder = 0;
  self.lutMapTex = nil;
  self.isFixedSize = false;
  self.AutoZ = true;
  self.Tracking3D = true;
  self.UV2D = mf.vector2(0.5, 0.5);
end

function FeedFaceStickerBehavior:_OnUpdate(delta)
-----------------------------------------------------------------------------------------------
-- set parameter for GPUSegment component
-----------------------------------------------------------------------------------------------
  local gpuSeg = self.Node:GetComponent(ae.Node.CT_CV_GPUSEGMENT);
  if gpuSeg == nil then
    return
  end
 
  gpuSeg.FaceID = self.FaceID;
  gpuSeg.Feathering = self.feathering;
  gpuSeg.MaskContourVal = self.MaskContourVal;
  
  -- if self.Texture then
  --   gpuSeg:SetTexture(self.Texture);
  -- end
  
  -- local cpuSeg = self.Node:GetRoot():GetComponent(ae.Node.CT_CV_SEGMENT);
  -- if cpuSeg ~= nil then
  --   local maskTex = cpuSeg:GetMask();
  --   local rectsize = cpuSeg:GetData(dtSize)[dtSize];
  --   local rectpos = cpuSeg:GetData(dtPosition)[dtPosition];
  --   if cpuSeg.Type ~= cv.SegmentComponent.cvFacePars_Head then
  --     if rectsize and rectpos then
  --       rectInfo1:Set(rectpos[1], rectpos[2]);
  --       rectInfo2:Set(rectsize[1], rectsize[2]);
  --       gpuSeg:SetRectInfo(rectInfo1, rectInfo2);
  --     else
  --       rectInfo1:Set(0, 0);
  --       rectInfo2:Set(0, 0);
  --       gpuSeg:SetRectInfo(rectInfo1, rectInfo2);
  --     end
  --   else
  --     local cpuSegHeadPos = cpuSeg:GetData(dtHeadPos)[dtHeadPos];
  --     if cpuSegHeadPos then
  --       WARNING("FeedFaceStickerBehavior cpuSegHeadPos:pos[0].x:"..tostring(cpuSegHeadPos[1]).."pos[0].y:"..tostring(cpuSegHeadPos[2]));
  --       WARNING("FeedFaceStickerBehavior cpuSegHeadPos:pos[1].x:"..tostring(cpuSegHeadPos[3]).."pos[1].y:"..tostring(cpuSegHeadPos[4]));
  --       WARNING("FeedFaceStickerBehavior cpuSegHeadPos:pos[2].x:"..tostring(cpuSegHeadPos[5]).."pos[2].y:"..tostring(cpuSegHeadPos[6]))
  --       WARNING("FeedFaceStickerBehavior cpuSegHeadPos:pos[3].x:"..tostring(cpuSegHeadPos[7]).."pos[3].y:"..tostring(cpuSegHeadPos[8]))
  --       gpuSeg:SetRectPositionInfo(cpuSegHeadPos);
  --     else
  --       cpuSegHeadPos = {0,0,
  --                        0,0,
  --                        0,0,
  --                        0,0}
  --       gpuSeg:SetRectPositionInfo(cpuSegHeadPos);
  --     end
  --   end
  --   if maskTex then
  --     gpuSeg:SetMaskTexture(maskTex);
  --   end
  --   cpuSeg.FaceID = self.FaceID;
  --   if self.Texture then
  --     cpuSeg:SetTexture(self.Texture);
  --   end
  -- end
  
  local fgTex = gpuSeg:GetMask()
  local data = gpuSeg:GetData();
  local texPos = data[dtPosition];
  local texSize = data[dtSize];
  local texPivot = data[dtPivot];
  local texRoll = data[dtRoll];

  if texPos == nil or texSize == nil or texPivot == nil or texRoll == nil then
    return
  end

-----------------------------------------------------------------------------------------------
-- dynamically change scale factor according to the tracking head
-----------------------------------------------------------------------------------------------
local ScaleFactor = 1.0;
local RootNode = self.Node:GetRoot();
if RootNode then
  local HeadSeg = RootNode:GetComponent(ae.Node.CT_HEAD_TRACK);
  if HeadSeg then
    self.isFixedSize = false;
    self.HeadID = HeadSeg.HeadID;
    if (self.HeadID + 1) ~= self.FaceID then
      local HeadSize = gpuSeg:GetSizebyID(self.HeadID+1);
      local FaceSize = gpuSeg:GetSizebyID(self.FaceID);
      if HeadSize ~= 0 and FaceSize ~= 0 then
        ScaleFactor = HeadSize/FaceSize;
      end 
    end
  else
    self.isFixedSize = true;
    self.Tracking3D = true;
  end
end
-----------------------------------------------------------------------------------------------
-- set parameter for child sticker
-----------------------------------------------------------------------------------------------
  if self.sticker == nil then
    return;
  end
  local stickerRender = self.sticker:GetComponent(ae.Node.CT_RENDER);
  if stickerRender == nil then
    return;
  end

  stickerRender:SetParameter("_MainTex", fgTex)
  local fixedSizeWidth,fixedSizeHeight;
  if self.isFixedSize then 
    fixedSizeWidth = gpuSeg:GetDetectSize():x() * 0.5;
    local mainSizeRatio = texSize[2]/texSize[1];
    fixedSizeHeight = fixedSizeWidth * mainSizeRatio;
    local pivotXRatio = texPivot[1]/texSize[1];
    local pivotYRatio = texPivot[2]/texSize[2];
    texSize[1] = fixedSizeWidth;
    texSize[2] = fixedSizeHeight;
    texPivot[1] = pivotXRatio * texSize[1];
    texPivot[2] = pivotYRatio * texSize[2];
  end
  mainSize:Set(texSize[1], texSize[2]);
  stickerRender:SetParameter("_MainSize",mainSize);
  mainPivot:Set(texPivot[1], texPivot[2]);
  stickerRender:SetParameter("_MainPivot", mainPivot)
  
  stickerRender:SetParameter("_VideoSize", gpuSeg:GetDetectSize());

  opacity:Set(self.Opacity);
  stickerRender:SetParameter("_Opacity", opacity);
  
  local blendvalues = BlendModeValues[self.BlendMode + 1];
  blendSrc:Set(blendvalues[1]);
  stickerRender:SetParameter("_BlendSrc", blendSrc);
  blendDst:Set(blendvalues[2]);
  stickerRender:SetParameter("_BlendDst", blendDst);
  blendMode:Set(blendvalues[3]);
  stickerRender:SetParameter("_BlendMode", blendMode);

  if self.lutMapTex then
    stickerRender:SetParameter("_LutMap", self.lutMapTex);
  end

  local trans = self.Node:GetComponent(ae.Node.CT_TRANSFORM);
  
  if self.Tracking3D == true then
    use3DAnchor:Set(1.0);
    stickerRender:SetParameter("_Use3DAnchor", use3DAnchor);
    stickerRender:SetParameter("_AnchorPoint", trans:GetWorldPosition());
  else
    local TrackingPoint = cv.FaceTrackingUtility:GetTrackingPoint(gpuSeg, self.UV2D);
    TrackingPoint[self.HeadID+1] = TrackingPoint[self.HeadID+1] or {gpuSeg:GetDetectSize():x()*0.5, gpuSeg:GetDetectSize():y()*0.5}; 
    use3DAnchor:Set(0.0);
    stickerRender:SetParameter("_Use3DAnchor", use3DAnchor);
    stickerRender:SetParameter("_AnchorPoint", mf.vector3(TrackingPoint[self.HeadID+1][1],TrackingPoint[self.HeadID+1][2],0));
  end

  local scale = trans:GetWorldScale();
  scaleFace:Set(scale:x() * ScaleFactor, scale:y() * ScaleFactor);
  stickerRender:SetParameter("_Scale", scaleFace);
  local quaternion = trans:GetWorldRotation();
  local eularAngle = quaternion:ToEulerAngle();
  stickerRender:SetParameter("_Rotation", eularAngle);


  if self.Hflip == true then
    horizontalFlip:Set(1.0);
    stickerRender:SetParameter("_HorizontalFlip", horizontalFlip);
  else
    horizontalFlip:Set(0.0);
    stickerRender:SetParameter("_HorizontalFlip", horizontalFlip);
  end

  if self.Vflip == true then
    verticalFlip:Set(1.0);
    stickerRender:SetParameter("_VerticalFlip", verticalFlip);
  else
    verticalFlip:Set(0.0);
    stickerRender:SetParameter("_VerticalFlip", verticalFlip);
  end
  
  -- set render order for sticker node
  stickerRender:SetRenderOrder(self.RenderOrder); 

-----------------------------------------------------------------------------------------------
-- set layer mask for both sticker and skin based on the layer value of current node(father)
-----------------------------------------------------------------------------------------------
  local layerItems = ae.LayerMask:GetLayerNames();
  for k, v in pairs(layerItems) do
    if v ~= ae.LayerMask.MASK_EDITOR_SCENE_LAYER_NAME and 
      v ~= ae.LayerMask.MASK_EDITOR_UI_LAYER_NAME then
      local islayer = self.Node:isLayer(v);
      if islayer == true then
        self.sticker:SetLayer(v);
        break;
      end
    end
  end
end

-----------------------------------------------------------------------------------------------
-- reigistered member set/get function
-----------------------------------------------------------------------------------------------
function FeedFaceStickerBehavior:GetRender()
  return  self.sticker;
end

function FeedFaceStickerBehavior:SetRender(in_sticker)
  self.sticker = in_sticker;
end

function FeedFaceStickerBehavior:GetOpacity()
  return self.Opacity;
end

function FeedFaceStickerBehavior:SetOpacity(in_Opacity)
 self.Opacity = in_Opacity;
end


function FeedFaceStickerBehavior:GetBlendModes()
  local heavy = "[heavy]";
  return
  {
    "Normal",       -- 正常
    "Darken"..heavy,       -- 变暗
    "Multiply",     -- 正片叠加
    "Color_burn"..heavy,   -- 颜色加深

    "Linear_burn"..heavy,  -- 线性加深
    "Dark"..heavy,         -- 深色
    "Lighten"..heavy,      -- 变亮
    "Screen",       -- 滤色

    "Color_dodge"..heavy,  -- 颜色减淡
    "Linear_dodge"..heavy, -- 线性减淡(添加)
    "Light"..heavy,        -- 线色
    "Overlay"..heavy,      -- 叠加

    "Soft_light"..heavy,   -- 柔光
    "Hard_light"..heavy,   -- 强光
    "Vivid_light"..heavy,  -- 亮光
    "Linear_light"..heavy, -- 线性光

    "Pin_light"..heavy,    -- 点光
    "Hard_mix"..heavy,     -- 实色混合
    "Difference"..heavy,   -- 差值
    "Exclusion"..heavy,    -- 排除

    "Subtract"..heavy,     -- 减去
    "Divide"..heavy,       -- 划分

    "Hue"..heavy,          -- 色相
    "Saturation"..heavy,   -- 饱和度
    "Color"..heavy,        -- 颜色
    "Luminosity"..heavy,   -- 透明度
    "Blend"..heavy,        -- 融合
  };
end

function FeedFaceStickerBehavior:LoadTexture(TexturePath)
  
  --local extension = filelfs:getExtension(TexturePath);
  --extension  = extension or defined.TextureType.ReFS;
  local Texture = ae.TextureEntity();

  --if extension == defined.TextureType.ReFS then
    --Texture:PushMetadata(ae.TextureReferenceMetadata(TexturePath))
    --Texture:CreateResource();
  --else
    Texture:PushMetadata(ae.TextureFileMetadata(
      ae.TextureEntity.TU_STATIC,
      ae.TextureEntity.PF_AUTO,
      1, false,
      ae.TextureEntity.TW_CLAMP_TO_EDGE,
      ae.TextureEntity.TW_CLAMP_TO_EDGE,
      ae.TextureEntity.TF_LINEAR,
      ae.TextureEntity.TF_LINEAR,
      vc.IFileSystem:PathAssembly(TexturePath)));
    
    Texture:SetKeepSource(true);
    Texture:CreateResource();
  --end
  local texStream = Texture:GetSourceStream();
  if texStream == nil then
    return nil;
  else
    return Texture;
  end
end

function FeedFaceStickerBehavior:GetRenderOrder()
  return self.RenderOrder;
end

function FeedFaceStickerBehavior:SetRenderOrder(in_RenderOrder)
  self.RenderOrder = in_RenderOrder;
end

function FeedFaceStickerBehavior:GetFaceID()
  return self.FaceID;
end

function FeedFaceStickerBehavior:SetFaceID(in_FaceID)
  self.FaceID = in_FaceID;
end

function FeedFaceStickerBehavior:GetHFlip()
  return self.Hflip;
end

function FeedFaceStickerBehavior:SetHFlip(in_flip)
   self.Hflip = in_flip;
end

function FeedFaceStickerBehavior:GetVFlip()
  return self.Vflip;
end

function FeedFaceStickerBehavior:SetVFlip(in_flip)
   self.Vflip = in_flip;
end

function FeedFaceStickerBehavior:GetBlendMode()
  return self.BlendMode;
end

function FeedFaceStickerBehavior:SetBlendMode(in_BlendMode)
  self.BlendMode = in_BlendMode;
  local blendvalues = BlendModeValues[self.BlendMode+1];
  self.lutMapTex = self:LoadTexture(blendvalues[4]) or self.lutMapTex;
end

-- real feathering value range[0, 60] normalized to [0, 20] when displayed
function FeedFaceStickerBehavior:SetFeathering(in_feathering)
  self.feathering = in_feathering;
end

function FeedFaceStickerBehavior:GetFeathering()
  return self.feathering;

end

function FeedFaceStickerBehavior:SetMaskContourVal(in_MaskContourVal)
  self.MaskContourVal = in_MaskContourVal;
end

function FeedFaceStickerBehavior:GetMaskContourVal()
  return self.MaskContourVal;
end

function FeedFaceStickerBehavior:SetAutoZ(in_AutoZ)
  self.AutoZ = in_AutoZ;
end

function FeedFaceStickerBehavior:GetAutoZ()
  return self.AutoZ;
end

function FeedFaceStickerBehavior:SetUV2D(in_UV2D)
  self.UV2D = in_UV2D;
end

function FeedFaceStickerBehavior:GetUV2D()
  return self.UV2D;
end

function FeedFaceStickerBehavior:GetTracking3D()
  return self.Tracking3D;
end

function FeedFaceStickerBehavior:SetTracking3D(in_Tracking3D)
  self.Tracking3D = in_Tracking3D;
end

--[[
function FeedFaceStickerBehavior:GetTexturePath()
  return self.TexturePath;
end

function FeedFaceStickerBehavior:SetTexturePath(in_texturepath)
  self.TexturePath = in_texturepath;
  self.Texture = self:LoadTexture(self.TexturePath) or self.Texture;
end
]]
-----------------------------------------------------------------------------------------------
-- reigistered member(UI)
-----------------------------------------------------------------------------------------------

FeedFaceStickerBehavior:MemberRegister(
    "sticker",
    vc.ScriptTypes.ReferenceType(
      ae.Node:RTTI(),
      FeedFaceStickerBehavior.GetSticker,
      FeedFaceStickerBehavior.SetSticker
    ),
"none");

FeedFaceStickerBehavior:MemberRegister(
  "Render Order",
  vc.ScriptTypes.IntType(
    nil, nil,
    FeedFaceStickerBehavior.GetRenderOrder,
    FeedFaceStickerBehavior.SetRenderOrder
  )
);

-- add interface to GPUsegment component FaceID 
FeedFaceStickerBehavior:MemberRegister(
    "FaceID",
    vc.ScriptTypes.ComboType(
      {
        {
          key = "0",
          value = 1
        },
        {
          key = "1",
          value = 2
        },
        {
          key = "2",
          value = 3
        },
      },
      FeedFaceStickerBehavior.GetFaceID,
      FeedFaceStickerBehavior.SetFaceID
));


FeedFaceStickerBehavior:MemberRegister("horizontal",
  venuscore.ScriptTypes.ImageButtonType(
  {
    textName = "Flip",
    icon = "comm:documents/icons/Horizon.png",
    size = {30,30},
    tip = "horizontal",
    sameline = false,
  },
  FeedFaceStickerBehavior.GetHFlip,
  FeedFaceStickerBehavior.SetHFlip
));
FeedFaceStickerBehavior:MemberRegister("vertical",
  venuscore.ScriptTypes.ImageButtonType(
  {
    icon = "comm:documents/icons/Vertical.png",
    size = {30,30},
    tip = "vertical",
    sameline = true,
  },
  FeedFaceStickerBehavior.GetVFlip,
  FeedFaceStickerBehavior.SetVFlip
));

FeedFaceStickerBehavior:MemberRegister(
    "BlendMode",
    vc.ScriptTypes.ComboType(
        function(this)
            local result = {}
            local properties = this:GetBlendModes()
            for _key, _value in pairs(properties) do
                table.insert(
                    result,
                    {
                        key = _value,
                        value = _key-1,
                    }
                )
            end
            return result
        end,
        FeedFaceStickerBehavior.GetBlendMode,
        FeedFaceStickerBehavior.SetBlendMode
    )
)

FeedFaceStickerBehavior:MemberRegister(
    "Opacity",
    vc.ScriptTypes.FloatType(
      0, 1,
      FeedFaceStickerBehavior.GetOpacity,
      FeedFaceStickerBehavior.SetOpacity
));


--[[
FeedFaceStickerBehavior:MemberRegister("TexturePath",
  vc.ScriptTypes.FilePathType(
    ae.TextureEntity:RTTI(),
    FeedFaceStickerBehavior.GetTexturePath,
    FeedFaceStickerBehavior.SetTexturePath
));]]


-- add interface to GPUsegment component MaskContour value
FeedFaceStickerBehavior:MemberRegister(
     "Expand/Shrink",
     vc.ScriptTypes.FloatType(
       0, 1,
       FeedFaceStickerBehavior.GetMaskContourVal,
       FeedFaceStickerBehavior.SetMaskContourVal
));

-- add interface to GPUsegment component feathering value
FeedFaceStickerBehavior:MemberRegister(
     "Feathering",
     vc.ScriptTypes.FloatType(
       0, 1,
       FeedFaceStickerBehavior.GetFeathering,
       FeedFaceStickerBehavior.SetFeathering
));

FeedFaceStickerBehavior:MemberRegister(
  "Auto Z",
  vc.ScriptTypes.CheckBoxType(
    FeedFaceStickerBehavior.GetAutoZ,
    FeedFaceStickerBehavior.SetAutoZ
  )
);


FeedFaceStickerBehavior:MemberRegister(
  "Tracking3D",
  vc.ScriptTypes.CheckBoxType(
    FeedFaceStickerBehavior.GetTracking3D,
    FeedFaceStickerBehavior.SetTracking3D
  )
);

FeedFaceStickerBehavior:MemberRegister(
  "UV2D",
  venuscore.ScriptTypes.FloatArrayType(
    2,
    FeedFaceStickerBehavior.GetUV2D,
    FeedFaceStickerBehavior.SetUV2D
  ),
"none");

return FeedFaceStickerBehavior;
