local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local makeup_common = require "behavior.aiface_make.ai_makeup_common"
local cv = require "computervisionfunction"

local ai_makeup_base = venuscore.VenusBehavior:extend("ai_makeup_base");
function ai_makeup_base:new()
  self.hasInit = false;
  self.render = nil
  self.recognition = nil
  self.MakeupType = makeup_common.NONE
  self.FaceID = 1
  self.vertexStream = nil
  self.vertexNumber = 0
  self.errorThreshold = 0.9
end

function ai_makeup_base:_OnAwake(def)
  self:BInitialParameters();
end

function ai_makeup_base:_OnLateUpdate(def)
  if self.hasInit then
    self:BUpdateFaceData()
    if self.recognition ~= nil and  self.faceMeshType ~= nil then
    -- if false then
      self:IUpdateParameters()
      cv.AIFaceUtility:UpdateMakeupVertex(self.recognition, self.render, self.faceMeshType, self:BGetFaceID())
    end
  else
    self:BInitialParameters();
  end
end 

function ai_makeup_base:_OnDestroy()
  self:IDestroy(); --删除Script时需要删除动态创建的Node
end

--Base class methods that can be overwrite, beginning with "I,"I" was "implementation"
function ai_makeup_base:IInitialParameters()
  --return bool type flag
  --type:return true or return false
  return true
end

function ai_makeup_base:IUpdateParameters()
  return true
end

function ai_makeup_base:IDestroy()
  return true
end

--Base class methods begin with "B",not overwrite,"B" was "Basic"
function ai_makeup_base:BGetMakeupType()
    return self.MakeupType;
end

function ai_makeup_base:BSetMakeupType(value)
    self.MakeupType = value
    -- 重置makeup
    self:BInitialParameters();
end

function ai_makeup_base:BGetRecongnition()
  local parentnode =  self.Node:GetRoot();
  if nil == parentnode then
    ERROR("[ai_makeup_base]"..makeup_common.makeup_types[self:BGetMakeupType()].key..": We Have No AIFace Component!")
    return nil
  end

  local grandnode = parentnode:GetRoot();
  if nil == grandnode then
    ERROR("[ai_makeup_base]"..makeup_common.makeup_types[self:BGetMakeupType()].key..": We Have No AIFace Component!")
    return nil
  end
  self.recognition = grandnode:GetComponent(apolloengine.Node.CT_CV_AIFace);
 
  if nil == self.recognition then
    ERROR("[ai_makeup_base]"..makeup_common.makeup_types[self:BGetMakeupType()].key..": We Have No AIFace Component!")
    return nil
  end
  
  -- for k,v in ipairs(self.recognition) do
  --   print("*************[DEBUG]***********",k,v)
  -- end
  return self.recognition
end

function ai_makeup_base:BGetFaceID()
  return self.FaceID
end

function ai_makeup_base:BSetFaceID(value)
  self.FaceID = value;
end

function ai_makeup_base:BGetRender()
  if nil == self.render and nil~=self.Node then
      self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
      if nil == self.render then
          ERROR("[ai_makeup_base]"..makeup_common.makeup_types[self:BGetMakeupType()].key..": We Have No Render Component!")
          return nil
      end
  end
  return  self.render
end

function ai_makeup_base:BInitialParameters()
  local result = self:IInitialParameters();
  self.hasInit = true;
  self.render = self:BGetRender()
  if self.render then 
    local makeup_type_value = self:BGetMakeupType()
    local materialEntity = self.render.MaterialEntities[1]
    if makeup_type_value >= 2 and materialEntity then
      local mask_position = makeup_common.makeup_uv_offset[makeup_type_value - 1][1]
      local mask_size = makeup_common.makeup_uv_offset[makeup_type_value - 1][2]
      materialEntity:SetParameter("_MaskInfo",mathfunction.vector4(
        mask_position[1],mask_position[2],mask_size[1],mask_size[2]))
      -- materialEntity:SetParameter("_Polygon",mathfunction.vector1(2.0));
    end
  end
  return result;
end

function SqrDistance(pt1, pt2)
  return (pt1[1]-pt2[1])*(pt1[1]-pt2[1]) + (pt1[2]-pt2[2])*(pt1[2]-pt2[2]);
end

function ai_makeup_base:BUpdateFaceData()
  if not self.faceMeshType then
    self.render = self:BGetRender()
    self.recognition = self:BGetRecongnition()
    local makeup_type = self:BGetMakeupType()
    if nil == self.recognition or makeup_type == makeup_common.NONE then
      return nil 
    end
    --根据cv的类型选择读取不同类型的cv数据
    local bvt_facemesh_type = makeup_common.makeup_uv_offset[makeup_type - 1][3]
    self.faceMeshType = bvt_facemesh_type[1]
  end
   
end

ai_makeup_base:MemberRegister("MakeupType", 
    venuscore.ScriptTypes.ComboType(
        makeup_common.makeup_types,    
        ai_makeup_base.BGetMakeupType,
        ai_makeup_base.BSetMakeupType));


ai_makeup_base:MemberRegister("FaceID", 
    venuscore.ScriptTypes.ComboType(
        makeup_common.faceId,    
        ai_makeup_base.BGetFaceID,
        ai_makeup_base.BSetFaceID));

return ai_makeup_base;
