local mathfunction = require "mathfunction"

local gmm = require "torchutility.gaussianmixturemodel"
local ViewCamera = require "torchutility.cameraviewproj"
local Robustifier = require "torchutility.robustifier"
local Substract =  require "torchutility.substract"
local Multiply =  require "torchutility.multiply"
local ToPoseList =  require "torchutility.toposelist"
local SignedSqrt =  require "torchutility.signedsqrt"
local AutoTensor =  require "torchutility.autotensor"
local Rodrigues = require "torchutility.rodrigues"
local SubTensor = require "torchutility.subtensor"
local TransformMat = require "torchutility.transformmat"
local dogleg = require "torchutility.dogleg"
require "venusdebug"
require "utility"

local emptyfather = mathfunction.vector3(0,1,0);

local skeletonfit = {}

function skeletonfit:Initialize()
    self.boneLengthMap = {
        ["UpperArm"] = 1,
        ["ForeArm"] = 1,
    }
    
    self.gmm = gmm();
    self.gmm:Load("docs:gmm8.vtt");
    
    local bx = self.gmm:MeanPose()
    
    local bi, bp, blll = self.gmm:MinAPriori(bx);
end


function skeletonfit:VectorToRot(fatherdir,mydir)
    if fatherdir == nil then
      local ret = mathfunction.vector3(0,0,0);
      return ret;
    end
    local norfadir = fatherdir:Normalize();
    local normydir = mydir:Normalize();
    local rotateaxis = norfadir:Cross(normydir);
    local sintheta =  rotateaxis:Length();
    local theta = math.asin(sintheta);
    local temp = theta/sintheta;
   -- temp = temp/3.14*180;
    rotateaxis:Set(rotateaxis:x()*temp,rotateaxis:y()*temp,rotateaxis:z()*temp);
    return rotateaxis;
end

function GetWorldRotate(bone)
  local rotatemat = {};
  
  local tempbone = bone;
  while tempbone~=nil do
    table.insert(rotatemat,tempbone.rotatemat);
    tempbone = tempbone.father;
  end
  local ret = nil;
  for i=1,#rotatemat do
    if ret ==nil then
      ret = rotatemat[i];
    else
      ret = rotatemat[i]*ret;
    end
  end
  return ret;
end

function skeletonfit:SetupBone(bone,resultmat)
  if bone == nil then
    return;
  end
  if bone.father~=nil then
    bone.dir = bone.pos - bone.father.pos;
  else
    bone.dir = emptyfather;
  end
  bone.boneLength = bone.dir:Length();
  if bone.father~=nil then
    bone.rotatevector = self:VectorToRot(bone.father.dir,bone.dir);
  else
    bone.rotatevector = self:VectorToRot(nil,bone.dir);
  end
  
  local temp = AutoTensor({bone.rotatevector:x(), bone.rotatevector:y(),bone.rotatevector:z()});
  bone.rotatemat = Rodrigues(temp):R();
  
  if bone.father~=nil then
    local inverserotate = torch.inverse(GetWorldRotate(bone.father));

    local dirtorch = torch.Tensor(3);
    dirtorch[1] =  bone.dir:x();
    dirtorch[2] =  bone.dir:y();
    dirtorch[3] =  bone.dir:z();
    
    local childlocalpos = inverserotate*(dirtorch);
    local ttt = bone.name;
    bone.localpos = {};
    bone.localpos[1] = childlocalpos[1];
    bone.localpos[2] = childlocalpos[2];
    bone.localpos[3] = childlocalpos[3];
  else
    bone.localpos = {};
    bone.localpos[1] = bone.pos:x();
    bone.localpos[2] = bone.pos:y();
    bone.localpos[3] = bone.pos:z();
  end
  
  for i=1,#bone.children do
    table.insert(resultmat, bone.children[i].rotatemat);
    self:SetupBone(bone.children[i],resultmat);
  end
end

function skeletonfit:TreetoList(boneroot,rotatelist,poslist)
  if boneroot == nil then
    return
  end
  local rotate = {};
  rotate[1] = boneroot.rotatevector:x();
  rotate[2] = boneroot.rotatevector:y();
  rotate[3] = boneroot.rotatevector:z();
  table.insert(rotatelist,rotate);
  table.insert(poslist,boneroot.localpos);
  for i=1,#boneroot.children do
    if #boneroot.children==2 then
      local ttt = 3;
      local gggg = f;
    end
    self:TreetoList(boneroot.children[i],rotatelist,poslist);
  end
end

function skeletonfit:SetCamera(fx,fy,cx,cy)
    self.fx = fx;
    self.fy = fy;
    self.cx = cx;
    self.cy = cy;
end

function skeletonfit:Optimise(bonepair,rotatelist,offsetlist, point2d)
    
    local matlist = {};

    local rotate = AutoTensor(rotatelist);
    local offset = AutoTensor(offsetlist);
    local transformmats = TransformMat(rotate,offset);
    
    local poslist = ToPoseList(transformmats,bonepair);
    LOG("Convert back 3d pos");
    LOG(poslist);
    
    local point3d = SubTensor({2,3,4,5,6,7,8,9,10,11,12,13},poslist);--AutoTensor(points);
    local projectto = AutoTensor(point2d);
    LOG("sub3d");
    LOG(point3d);
    local Camera = ViewCamera(self.fx,self.fy,self.cx,self.cy,point3d);
    LOG("projection");
    LOG(Camera);
    local Sub = Substract(projectto,Camera);
    local Robu = Robustifier(100,Sub);
    local SignedSqrt = SignedSqrt(Robu);
  
    local funcs = {}
    funcs.project = {}
  
    funcs.project.fx = function(x)
      rotate:V(x);
      local ret = SignedSqrt:R();
      return ret;
    end
  
    funcs.project.dx = function(x)
      rotate:V(x);
      local final = SignedSqrt:D2(rotate);
      return final;
    end
    local config =  {
          maxiter = 20,
          e_3 = 0.005,
          }
    local rotateret = dogleg(funcs, rotate:R(),config); 
    
    --local final2d = Camera:R();
    --LOG("**********this is justice!*****************");
    --LOG(final2d)
    --LOG(Camera);
    --LOG(point3d);
    return point3d:R();

end

return skeletonfit;