
function DefineParams()
	Properties = 
	{
		
FRAME_TEXTURE = { "Frame Tex", TEXTURE2D, "white" },
BRIGHT_TEXTURE = { "Bright Tex", TEXTURE2D, "white" },
UNIFORM_LIGHT_COLOR = { "Offset", VEC3, "0.0,0.0,0.0" },
SAMPLES = { "Samples", FLOAT, "0.0" },
STEP = { "Step", FLOAT, "0.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "ShineVolumnLight"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "FRAME_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRIGHT_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SAMPLES",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STEP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D FRAME_TEXTURE;
uniform sampler2D BRIGHT_TEXTURE;
uniform highp vec3 UNIFORM_LIGHT_COLOR;
uniform highp float SAMPLES;
uniform highp float STEP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 rgb_1;
  highp int i_1_2;
  highp float cur_dis_3;
  highp float delta_step_4;
  highp float sum_brightness_5;
  highp vec2 dTuv_6;
  highp vec2 uv_7;
  highp int samples_8;
  samples_8 = int(SAMPLES);
  uv_7 = xlv_TEXCOORD0;
  highp vec2 tmpvar_9;
  tmpvar_9 = (xlv_TEXCOORD0 - vec2(0.5, 0.5));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec2 tmpvar_11;
  if ((tmpvar_10 > (SAMPLES * STEP))) {
    tmpvar_11 = (normalize(tmpvar_9) * STEP);
  } else {
    tmpvar_11 = (tmpvar_9 / SAMPLES);
  };
  dTuv_6 = tmpvar_11;
  sum_brightness_5 = 0.0;
  delta_step_4 = (1.0/(SAMPLES));
  cur_dis_3 = 1.0;
  i_1_2 = 0;
  for (; i_1_2 < samples_8; i_1_2++, uv_7 = (uv_7 - dTuv_6), cur_dis_3 = (cur_dis_3 - delta_step_4)) {
    lowp vec4 tmpvar_12;
    tmpvar_12 = texture2D (BRIGHT_TEXTURE, uv_7);
    sum_brightness_5 = (sum_brightness_5 + ((tmpvar_12.x * 0.05) * (cur_dis_3 * cur_dis_3)));
  };
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (FRAME_TEXTURE, xlv_TEXCOORD0).xyz;
  rgb_1 = tmpvar_13;
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = (rgb_1 + (UNIFORM_LIGHT_COLOR * sum_brightness_5));
  gl_FragData[0] = tmpvar_14;
}

]===],
	},
}

end
