
#DEFPARAMS
CUR_FRAME_TEXTURE = { "Cur Frame Tex", TEXTURE2D, "white" },
PRE_FRAME_TEXTURE = { "Pre Frame Tex", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "ShineMotion"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D CUR_FRAME_TEXTURE;
sampler2D PRE_FRAME_TEXTURE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float3 cur_rgb = tex2D(CUR_FRAME_TEXTURE, i.uv).xyz + 0.5 / 255.0;
	float3 pre_rgb = tex2D(PRE_FRAME_TEXTURE, i.uv).xyz + 0.5 / 255.0;

    float3 coeff = float3(0.299, 0.587, 0.114);

    float cur_bright = dot(coeff, cur_rgb);
    float pre_bright = dot(coeff, pre_rgb);

    float diff = abs(cur_bright - pre_bright) > 30.0/255.0 ? 1.0 : 0.0;
    float motion_v = diff * cur_bright * 0.7;

	return float4(motion_v, motion_v, motion_v, 1.0);
}
ENDCG
#END
