#include "functions/util.function"
#SHADER_DEFINE OutLine1Vertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
       
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;  
    vec2 out_TexCooridate;
    out_TexCooridate= in_TexCoordinate.xy;     // upper left corner
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE OutLine1Fragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_uBwm,		    	NONE,	TEXTURE2D,	  "uBwm" },
		{ TEXTURE_uHam,		    	NONE,	TEXTURE2D,	  "uHam" },
        { ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,	"textureCoordinate"},
        { UNIFORM_uTau,             HIGH, FLOAT,   "uTau"},
		{ UNIFORM_uOs,				HIGH,	VEC2,	"uOs"},
        { UNIFORM_uHiu,            	MEDIUM, FLOAT,   "uHiu"},
        { UNIFORM_uVer,             MEDIUM, FLOAT,   "uVer"},
		{ UNIFORM_uSmooth,          MEDIUM, FLOAT,   "uSmooth"}
	}
  
#SHADER_CODE

    highp vec2 bad;
    //if (abs(uVer - 2.0) < 0.0001) {
        highp vec4 dircolor = texture2D(uBwm, textureCoordinate);
        bad = decode(dircolor);
    //}
    //else bad = texture2D(uBwm, textureCoordinate).xy;

    vec2 dir = normalize(vec2(bad.y, -bad.x));
    vec2 offset = dir * uOs * uSmooth;
    float voi0 = uHiu;
    float voi1 = uHiu * 1.6;

    float k0 = gauss(0.0, voi0);
    float sum0 = k0;
    vec3 result0 = texture2D(uHam, textureCoordinate).rgb * k0;

    float k1 = gauss(0.0, voi1);
    float sum1 = k1;
    vec3 result1 = texture2D(uHam, textureCoordinate).rgb * k1;

    for (int i = 1; i < 3; ++i) {
        vec3 c0 = texture2D(uHam, textureCoordinate + float(i) * offset).rgb;
        vec3 c1 = texture2D(uHam, textureCoordinate - float(i) * offset).rgb;

        k0 = gauss(float(i), voi0);
        sum0 += k0 + k0;
        result0 += c0 * k0;
        result0 += c1 * k0;

        k1 = gauss(float(i), voi1);
        sum1 += k1 + k1;
        result1 += c0 * k1;
        result1 += c1 * k1;
    }

    result0 /= sum0;
    result1 /= sum1;
    float d = (result0.x - 0.9985 * result1.x) * 100.;
    float d2 = (result0.x - (0.99+uTau) * result1.x) * 100.;

    gl_FragColor = vec4(d, d2, 0.0, 0.0);
    
#END_CODE

#END_DEFINE

